<?php
// ++=========================================================================++
// || vBadvanced Dynamics v1.0.0 (vB 3.6 - vB 3.7)
// ||  2003-2007 vBadvanced.com - All Rights Reserved
// || This file may not be redistributed in whole or significant part.
// || http://vbadvanced.com
// ++ ========================================================================++

error_reporting(E_ALL & ~E_NOTICE);
define('GET_EDIT_TEMPLATES', true);
define('THIS_SCRIPT', 'dyna_newentry');

$specialtemplates = array(
	'adv_dyna_attach',
	'adv_dyna_cfield',
	'adv_dyna_modpos',
	'adv_dyna_module',
	'smiliecache',
	'bbcodecache',
	'iconcache'
);

$globaltemplates = array(
	'ADV_DYNA_ADD_EDIT',
	'adv_dyna_add_edit_custombits',
	'adv_dyna_add_edit_multipagebits',
	'adv_dyna_columns_end',
	'adv_dyna_columns_start',
	'bbcode_code',
	'bbcode_html',
	'bbcode_php',
	'bbcode_quote',
	'newpost_attachment',
	'newpost_attachmentbit'
);

$actiontemplates = array(
	'addentry' => array(
		'ADV_DYNA_ADD_START',
		'humanverify',
		'imagereg',
		'newpost_errormessage',
		'newpost_preview'
	),
	'newentry' => array(
		'humanverify',
		'imagereg',
		'newpost_errormessage',
		'newpost_preview'
	),
	'doaddentry' => array(
		'humanverify',
		'imagereg',
		'newpost_errormessage',
		'newpost_preview'
	),
	'doedit' => array(
		'humanverify',
		'imagereg',
		'newpost_errormessage',
		'newpost_preview'
	),
	'multipage' => array(
		'ADV_DYNA_ADD_EDIT_MULTIPAGE',
		'adv_dyna_add_edit_multipage_errorbit',
		'adv_dyna_add_edit_multipage_messagearea'
	),
	'savemultipage' => array(
		'ADV_DYNA_ADD_EDIT_MULTIPAGE',
		'adv_dyna_add_edit_multipage_errorbit',
		'adv_dyna_add_edit_multipage_messagearea',
		'adv_dyna_add_edit_multipage_previewbit'
	),
	'deletepage' => array(
		'ADV_DYNA_CONFORMATION'
	)
);

$actiontemplates['none'] =& $actiontemplates['addentry'];

$phrasegroups = array(
	'adv_dyna_add_entpost',
	'adv_dyna_editentry',
	'posting',
	'threadmanage'
);

require_once('./dyna_global.php');
require_once(DIR . '/includes/functions_newpost.php');
require_once(DIR . '/includes/vba_dyna_functions_saveentry.php');
require_once(DIR . '/includes/vba_dyna_functions_cats.php');

if (!$_REQUEST['do'])
{
	$_REQUEST['do'] = 'addentry';
}

$title = '';

($hook = vBulletinHook::fetch_hook('vba_dyna_newentry_start')) ? eval($hook) : false;

// ##### Submit New Entry ######################################################
if ($_REQUEST['do'] == 'addentry')
{
	if ($vba_options['dyna_disablecats'])
	{
		$_REQUEST['do'] = 'newentry';
		$catid = $vba_options['dyna_disablecats'];
	}
	else if (!$vbulletin->options['disable_ajax'] OR (intval($catid) AND cat_opt('open_for_entries') AND cat_user_opt('allow_newentries', $catid)))
	{
		$_REQUEST['do'] = 'newentry';
	}
	else
	{
		$allowedparents = fetch_allowed_submit_parents();

		$options = print_cat_select($catid, 'submitentry');

		if (!$options)
		{
			print_no_permission();
		}

		if ($vba_dyna->check_perms('cancreatecats') AND $vba_options['dyna_allow_user_cats'])
		{
			$addcatlink = true;
			$moderatecats = $vba_dyna->check_perms('moderatecats');
		}

		$navbits[''] = construct_phrase($vbphrase['submit_x'], $vbphrase['entry']);
		$navbits = construct_navbits($navbits);
		eval('$navbar = "' . fetch_template('navbar') . '";');

		require_once(DIR . '/includes/vba_dyna_include_modules.php');

		eval('print_output("' . fetch_template(ADV_DYNA_PREFIX_UPPER . '_ADD_START') . '");');
	}
}

// ########################## Do Reply to Entry #############################
if ($_POST['do'] == 'doaddentry' OR $_POST['do'] == 'doedit')
{
	require_once(DIR . '/includes/functions_misc.php');

	// Load BBcode parser
	require_once(DIR . '/includes/class_bbcode.php');
	$bbcode_parser =& new vB_BbCodeParser($vbulletin, fetch_tag_list());

	$vbulletin->input->clean_array_gpc('p', array(
		'customdate' => TYPE_ARRAY,
		'disablesmilies' => TYPE_INT,
		'draft' => TYPE_INT,
		'entryoptions' => TYPE_ARRAY,
		'iconid' => TYPE_INT,
		'imagehash' => TYPE_STR,
		'imagestamp' => TYPE_STR,
		'keywords' => TYPE_STR,
		'message' => TYPE_STR,
		'pagecount' => TYPE_INT,
		'parseurl' => TYPE_INT,
		'posthash' => TYPE_NOHTML,
		'poststarttime' => TYPE_INT,
		'preview' => TYPE_STR,
		'private' => TYPE_INT,
		'pubdate' => TYPE_ARRAY,
		'signature' => TYPE_INT,
		'submitas' => TYPE_NOHTML,
		'title' => TYPE_NOHTML,
		'username' => TYPE_NOHTML,
		'wysiwyg' => TYPE_BOOL
	));

	$vbulletin->GPC['preview'] = (trim($vbulletin->GPC['preview'])) ? true : false;
	$title =& $vbulletin->GPC['title'];
	$message = fetch_censored_text($vbulletin->GPC['message']);

	$posthash =& $vbulletin->GPC['posthash'];
	$poststarttime =& $vbulletin->GPC['poststarttime'];
	$keywords = clean_keywords($vbulletin->GPC['keywords']);

	$entry['title'] =& $title;
	$entry['catid'] = intval($catid);

	$is_category_mod = is_category_mod($entry['catid']);

	// ##### Add entry - permission checks
	if ($_POST['do'] == 'doaddentry')
	{
		// Check permissions
		if (!$vba_dyna->check_cat_perms('canaddentries', $entry))
		{
			print_no_permission();
		}

		if ($catid AND (!cat_opt('open_for_entries') OR !cat_user_opt('allow_newentries', $catid)))
		{
			eval(standard_error(fetch_error(ADV_DYNA_PREFIX . '_not_open_for_x', $vbphrase['entries'])));
		}

		if ($vba_dyna->check_cat_perms('cansubmitothers') AND $vbulletin->GPC['submitas'])
		{
			$show['submitasmember'] = true;

			$submittedas = $db->query_first("SELECT userid FROM " . TABLE_PREFIX . "user WHERE username = '" . $db->escape_string($vbulletin->GPC['submitas']) . "'");

			$entry['username'] = $vbulletin->GPC['submitas'];
			$entry['userid'] = $submittedas['userid'];
		}
		else
		{
			$entry['userid'] = $vbulletin->userinfo['userid'];
			$entry['username'] = $vbulletin->userinfo['username'];
		}

		($hook = vBulletinHook::fetch_hook('vba_dyna_newentry_doadd')) ? eval($hook) : false;
	}

	// ##### Edit Entry - permission checks
	else
	{
		$vba_dyna->load_entry('', true, true, true, true);
		if (
			(!$vbulletin->userinfo['userid']
				OR ($vbulletin->userinfo['userid'] != $vba_dyna->_entry['userid'] AND !$vba_dyna->check_cat_perms('caneditothers'))
				OR ($vbulletin->userinfo['userid'] == $vba_dyna->_entry['userid'] AND !$vba_dyna->check_cat_perms('caneditentries'))
			) AND !$is_category_mod)
		{
			print_no_permission();
		}

		// Check time limit
		if (!$is_category_mod
			AND $vba_options['dyna_editentry_timelimit']
			AND !$vba_dyna->_entry['draft']
			AND (TIMENOW - ($vba_options['dyna_editentry_timelimit'] * 60)) > $vba_dyna->_entry['dateline']
		)
		{
			eval(standard_error(fetch_error('edittimelimit', $vba_options['dyna_editentry_timelimit'], $vbulletin->options['contactuslink'])));
		}

		($hook = vBulletinHook::fetch_hook('vba_dyna_newentry_doedit')) ? eval($hook) : false;
	}

	// WYSIWYG
	if ($vbulletin->GPC['wysiwyg'])
	{
		require_once(DIR . '/includes/functions_wysiwyg.php');

		if (cat_opt('allow_entry_html', $entry['catid']))
		{
			$vbulletin->options['do_nl2br'] = false;
		}

		$message = convert_wysiwyg_html_to_bbcode($message, cat_opt('allow_entry_html', $entry['catid']));
	}

	if ($vbulletin->GPC['parseurl'])
	{
		$message = convert_url_to_bbcode($message);
	}

	$entry['message'] =& $message;
	$entry['pagetext'] =& $message;

	// Smilies
	$entry['enablesmilies'] = (!$vbulletin->GPC['disablesmilies']) ? 1 : 0;

	if ($vba_options['dyna_add_timeformat'] != '24hour')
	{
		if ($vbulletin->GPC['customdate']['meridiem'] == 'PM' AND $vbulletin->GPC['customdate']['hour'] != 12)
		{
			$vbulletin->GPC['customdate']['hour'] += 12;
		}
		else if ($vbulletin->GPC['customdate']['meridiem'] == 'AM' AND $vbulletin->GPC['customdate']['hour'] == 12)
		{
			$vbulletin->GPC['customdate']['hour'] = 0;
		}
	
		if ($vbulletin->GPC['pubdate']['meridiem'] == 'PM' AND $vbulletin->GPC['pubdate']['hour'] != 12)
		{
			$vbulletin->GPC['pubdate']['hour'] += 12;
		}
		else if ($vbulletin->GPC['pubdate']['meridiem'] == 'AM' AND $vbulletin->GPC['pubdate']['hour'] == 12)
		{
			$vbulletin->GPC['pubdate']['hour'] = 0;
		}
	}

	$entry['pubdateline'] = '';
	if ($vba_options['dyna_allowdrafts'])
	{
		$entry['pubdateline'] = fetch_custom_datestamp('pubdate');
	}

	// Attachments
	$entry['attachcount'] = 0;
	$entry['attachcount_valid'] = 0;

	if ($_POST['do'] == 'newentry' OR $vba_options['dyna_require_attach'])
	{
		$getattaches = $vbulletin->db->query_read("
			SELECT valid
			FROM " . ADV_DYNA_TABLE_PREFIX . "attachments
			WHERE " . iif($_POST['do'] == 'doaddentry',
				"posthash = '" . $vbulletin->db->escape_string($posthash) . "'
					AND userid = " . $vbulletin->userinfo['userid'] . "
					AND entryid = 0
				",
				"entryid = $entryid"
			)
		);
		while ($attach = $db->fetch_array($getattaches))
		{
			$entry['attachcount']++;
			if ($attach['valid'])
			{
				$entry['attachcount_valid']++;
			}
		}
	}

	$errors = check_entry_errors($entry);

	$entry['dateline'] = ($_POST['do'] == 'doedit') ? $vba_dyna->_entry['dateline'] : TIMENOW;
	if ($vba_dyna->check_cat_perms('caneditdateline'))
	{
		$entry['dateline'] = fetch_custom_datestamp();
	}

	// Cached version
	if (!$errors AND $vba_options['dyna_cachedlife'])
	{
		$vbulletin->options['allowhtml'] = cat_opt('allow_entry_html', $entry['catid']);
		$vbulletin->options['allowbbcode'] = cat_opt('allow_entry_bbcode', $entry['catid']);
		$vbulletin->options['allowbbimagecode'] = cat_opt('allow_entry_bbimgcode', $entry['catid']);
		$vbulletin->options['allowsmilies'] = iif(cat_opt('allow_entry_smilies', $entry['catid']), $entry['enablesmilies'], 0);

		// Parse pagetext
		$entry['message_parsed'] = $bbcode_parser->parse(
			$entry['message'],
			'nonforum',
			$vbulletin->options['allowsmilies'],
			true,
			$entry['pagetext_parsed'],
			3,
			($vba_options['dyna_cachedlife'] AND $entry['dateline'] >= (TIMENOW - ($vba_options['dyna_cachedlife'] * 86400)) ? true : false)
		);
	}

	// ##### Errors or previewing, send 'em back
	if ($errors OR $vbulletin->GPC['preview'])
	{
		$newpost['message'] =& $message;
		construct_checkboxes($_POST);

		if ($_POST['do'] == 'doedit')
		{
			$_REQUEST['do'] = 'editentry';
		}
		else
		{
			$_REQUEST['do'] = 'newentry';
		}

		// Errors
		if ($errors)
		{
			require_once(DIR . '/includes/functions_newpost.php');
			$entryerrors = construct_errors($errors);
			$haderrors = true;
		}
		// Previewing
		else
		{
			if (!cat_opt('allow_entry_smilies'))
			{
				$entry['disablesmilies'] = 1;
			}

			$entrypreview = process_post_preview($entry);
		}
	}
	// ##### Everything's good, so get ready to insert or update
	else
	{
		$entry['open'] = ($_POST['do'] == 'doedit') ? $vba_dyna->_entry['open'] : 1;

		if ($is_category_mod
			OR (($vba_dyna->_entry['userid'] == $vbulletin->userinfo['userid'] OR $_POST['do'] == 'doaddentry')
				AND $vba_dyna->check_cat_perms('canopenclose', $entry)
			)
		)
		{
			$entry['open'] = ($vbulletin->GPC['entryoptions']['close']) ? 0 : 1;
		}

		// ##### Editing an entry
		if ($_POST['do'] == 'doedit')
		{
			$entry['valid'] = $vba_dyna->_entry['valid'];

			if ($entry['valid'] != 2 AND $vba_options['dyna_entry_editmoderation'] AND $vba_dyna->check_cat_perms('moderateentries', $entry))
			{
				$entry['valid'] = 1;
			}

			$db->query_write("
				UPDATE " . ADV_DYNA_TABLE_PREFIX . "entries SET
					title = '" . $db->escape_string($entry['title']) . "',
					catid = $entry[catid],
					dateline = $entry[dateline],
					keywords = '" . $db->escape_string($keywords) . "',
					iconid = " . $vbulletin->GPC['iconid'] . ",
					valid = $entry[valid],
					open = $entry[open],
					draft = " . $vbulletin->GPC['draft'] . ",
					private = " . $vbulletin->GPC['private'] . ",
					showsignature = " . $vbulletin->GPC['signature'] . "
					" . iif($vba_options['dyna_require_attach'], ", hasattach = $entry[attachcount_valid]") . "
				WHERE entryid = $entryid
			");

			$db->query_write("
				REPLACE INTO " . ADV_DYNA_TABLE_PREFIX . "entries_pages
					(entryid, title, pagetext, pagenumber, allowsmilie)
				VALUES (
					$entryid,
					'" . $db->escape_string($entry['pagetitle']) . "',
					'" . $db->escape_string($entry['message']) . "',
					1,
					$entry[enablesmilies]
				)
			");

			// Auto publishing
			if ($entry['pubdateline'])
			{
				$db->query_write("
					REPLACE INTO " . ADV_DYNA_TABLE_PREFIX . "entrypublish
						(entryid, pubdateline)
					VALUES (
						$entryid,
						$entry[pubdateline]
					)
				");

				if (!is_array($vbulletin->adv_dyna_autpub['entries']))
				{
					$vbulletin->adv_dyna_autpub['entries'] = array();
				}

				if ($entry['pubdateline'] <= (TIMENOW + 172800) AND $vbulletin->adv_dyna_autpub['entries'][$entryid] != $entry['pubdateline'])
				{
					$vbulletin->adv_dyna_autpub['entries'][$entryid] = $entry['pubdateline'];

					$vbulletin->adv_dyna_autpub['mindate'] = min(array_values($vbulletin->adv_dyna_autpub['entries']));

					build_datastore(ADV_DYNA_PREFIX . '_autpub', serialize($vbulletin->adv_dyna_autpub), 1);
				}
			}
			else
			{
				$db->query_write("DELETE FROM " . ADV_DYNA_TABLE_PREFIX . "entrypublish WHERE entryid = $entryid");
			}

			// Entry cache
			if ($vba_options['dyna_cachedlife'])
			{
				// Delete first since a replace into would not update all languages/styles
				$db->query_write("DELETE FROM " . ADV_DYNA_TABLE_PREFIX . "entryparsed WHERE entryid = $entryid");

				$db->query_write("
					INSERT INTO " . ADV_DYNA_TABLE_PREFIX . "entryparsed
						(entryid, pagenumber, pagetext_parsed, dateline, styleid, languageid, hasimages)
					VALUES (
						$entryid,
						1,
						'" . $db->escape_string($bbcode_parser->cached['text']) . "',
						$entry[dateline],
						" . $vbulletin->userinfo['styleid'] . ",
						" . $vbulletin->userinfo['languageid'] . ",
						" . $bbcode_parser->cached['has_images'] . "
					)
				");
			}

			construct_customfields_sql($entryid, false);

			$newentry['draft'] = $vbulletin->GPC['draft'];
			$newentry['valid'] = $vba_dyna->_entry['valid'];
			$newentry['catid'] = $catid;

			require_once(DIR . '/includes/vba_dyna_functions_savecat.php');

			update_counts_moved($entryid, $newentry, $vba_dyna->_entry);

			$entry['entryid'] = $entryid;
			fetch_entry_url($entry);

			$vbulletin->url = $entry['url'];
			eval(print_standard_redirect(ADV_DYNA_PREFIX . '_addednew'));
		}

		// ##### New Entry
		else
		{
			$cat = $db->query_first("
				SELECT title, options, newentryemail
				FROM " . ADV_DYNA_TABLE_PREFIX . "categories
				WHERE catid = '$entry[catid]'
			");

			$sendmailto = explode(' ', $cat['newentryemail']);

			$valid = ($vba_dyna->check_cat_perms('moderateentries', $entry)) ? 0 : 1;

			// Insert the entry
			$db->query_write("
				INSERT INTO " . ADV_DYNA_TABLE_PREFIX . "entries
					(catid, title, keywords, userid, username, dateline, ipaddress, iconid, showsignature, valid, open, draft, private, hasattach)
				VALUES (
					$entry[catid],
					'" . $db->escape_string($entry['title']) . "',
					'" . $db->escape_string($keywords) . "',
					" . $entry['userid'] . ",
					'" . $db->escape_string($entry['username']) . "',
					$entry[dateline],
					'" . $db->escape_string(IPADDRESS) . "',
					" . $vbulletin->GPC['iconid'] . ",
					" . $vbulletin->GPC['signature'] . ",
					$valid,
					$entry[open],
					" . $vbulletin->GPC['draft'] . ",
					" . $vbulletin->GPC['private'] . ",
					$entry[attachcount_valid]
			)");

			$newentryid = $db->insert_id();

			$db->query_write("
				INSERT INTO " . ADV_DYNA_TABLE_PREFIX . "entries_pages
					(entryid, pagetext, pagenumber, allowsmilie)
				VALUES (
					$newentryid,
					'" . $db->escape_string($entry['message']) . "',
					1,
					$entry[enablesmilies]
			)");

			// Parsed version
			if ($vba_options['dyna_cachedlife'])
			{
				$db->query_write("
					INSERT INTO " . ADV_DYNA_TABLE_PREFIX . "entryparsed
						(entryid, pagenumber, pagetext_parsed, dateline, styleid, languageid, hasimages)
					VALUES (
						$newentryid,
						1,
						'" . $db->escape_string($bbcode_parser->cached['text']) . "',
						" . TIMENOW . ",
						" . $vbulletin->userinfo['styleid'] . ",
						" . $vbulletin->userinfo['languageid'] . ",
						" . $bbcode_parser->cached['has_images'] . "
				)");
			}

			// Auto publishing
			if ($entry['pubdateline'])
			{
				$db->query_write("
					INSERT INTO " . ADV_DYNA_TABLE_PREFIX . "entrypublish
						(entryid, pubdateline)
					VALUES (
						$newentryid,
						$entry[pubdateline]
					)
				");
			}

			if ($vbulletin->userinfo['userid'])
			{
				// Update user post counts
				if ($vba_options['dyna_update_postcount_entries'])
				{
					$db->query_write("UPDATE " . TABLE_PREFIX . "user SET posts = posts+1 WHERE userid = " . $entry['userid']);
				}

				// Favorites
				if ($vbulletin->GPC['entryoptions']['favorite'])
				{
					$db->query_write("
						INSERT INTO " . ADV_DYNA_TABLE_PREFIX . "favorites
							(userid, entryid)
						VALUES (
							" . $vbulletin->userinfo['userid'] . ",
							$newentryid
					)");
				}

				// Subscribe
				if ($vbulletin->GPC['entryoptions']['subscribe'])
				{
					$db->query_write("
						INSERT INTO " . ADV_DYNA_TABLE_PREFIX . "subscribeentry
							(userid, entryid)
						VALUES (
							" . $vbulletin->userinfo['userid'] . ",
							$newentryid
					)");
				}
			}

			construct_customfields_sql($newentryid);

			// ##### Attachments
			if ($vba_dyna->check_cat_perms('canattach'))
			{
				// Update attachments
				$db->query_write("
					UPDATE " . ADV_DYNA_TABLE_PREFIX . "attachments SET
						entryid = $newentryid,
						posthash = ''
					WHERE userid = " . $vbulletin->userinfo['userid'] . "
						AND posthash = '" . $db->escape_string($posthash) . "'
				");

				// First attachment
				$entryattachid = 0;
				if ($vba_options['dyna_entrybit_showattach'])
				{
					$attachthumb = $db->query_first("
						SELECT attachmentid
						FROM " . ADV_DYNA_TABLE_PREFIX . "attachments
						WHERE entryid = $newentryid
							" . iif($vba_options['dyna_entrybit_showattach'] == 2, 'AND hasthumb = 1') . "
						ORDER BY attachmentid
					");
					$entryattachid = intval($attachthumb['attachmentid']);
				}

				// hasattach count
				$attaches['count'] = 0;
				if (!$vba_options['dyna_require_attach'])
				{
					$attaches = $db->query_first("
						SELECT COUNT(*) AS count
						FROM " . ADV_DYNA_TABLE_PREFIX . "attachments
						WHERE entryid = $newentryid
							AND valid = 1
					");
				}

				if ($attaches['count'] OR $entryattachid)
				{
					$db->query_write("
						UPDATE " . ADV_DYNA_TABLE_PREFIX . "entries SET
							" . iif($attaches['count'], 'hasattach = ' . $attaches['count']) .
								iif($attaches['count'] AND $entryattachid, ',') . "
							" . iif($entryattachid, 'attachid = ' . $entryattachid) . "
						WHERE entryid = $newentryid
					");
				}
			}

			// New entry email
			if (!$valid OR $vba_options['dyna_newentryemail_all'])
			{
				if ($vba_options['dyna_newentryemail'])
				{
					$optmailer = explode(' ', $vba_options['dyna_newentryemail']);
					$sendmailto = array_merge($optmailer, $sendmailto);
				}

				if (!empty($sendmailto))
				{
					$entry['entryid'] = $newentryid;
					fetch_entry_url($entry);
					foreach ($sendmailto AS $email)
					{
						eval(fetch_email_phrases(ADV_DYNA_PREFIX . '_newentry', 0));
						vbmail(trim($email), $subject, $message);
					}
				}
			}

			// Entry is valid, so update the cats
			if ($valid)
			{
				if (!$vbulletin->GPC['draft'] AND !$vbulletin->GPC['private'])
				{
					$catquery = "
						entrycount = entrycount+1,
						lastentryid = $newentryid,
						lastentryusername = '" . $db->escape_string($entry['username']) . "',
						lastentrytitle = '" . $db->escape_string($entry['title']) . "',
						lastentryuserid = " . $entry['userid'] . ",
						lastentrydateline = " . TIMENOW . "
					";

					// Update normal category
					$db->query_write("
						UPDATE " . ADV_DYNA_TABLE_PREFIX . "categories SET
						$catquery
						WHERE catid = $catid
					");

					// Try to insert
					$vbulletin->db->query_write("
						INSERT IGNORE INTO " . ADV_DYNA_TABLE_PREFIX . "memberscats
							(catid, userid, entrycount, lastentryid, lastentrytitle, lastentryuserid, lastentryusername, lastentrydateline)
						VALUES (
							$entry[catid],
							" . $entry['userid'] . ",
							0,
							$newentryid,
							'" . $db->escape_string($entry['title']) . "',
							" . $entry['userid'] . ",
							'" . $db->escape_string($entry['username']) . "',
							" . TIMENOW . "
					)");

					// Update members' cat
					$db->query_write("
						UPDATE " . ADV_DYNA_TABLE_PREFIX . "memberscats SET
						$catquery
						WHERE catid = $catid AND userid = " . $entry['userid']
					);
				}

				$entry['entryid'] = $newentryid;

				if ($vbulletin->GPC['pagecount'])
				{
					$vbulletin->url = 'newentry.php?' . $vbulletin->session->vars['sessionurl'] . 'do=multipage&entryid=' . $newentryid . '&pagecount=' . $vbulletin->GPC['pagecount'];
				}
				else
				{
					fetch_entry_url($entry);
					$vbulletin->url = $entry['url'];
				}

				eval(print_standard_redirect(ADV_DYNA_PREFIX . '_addednew'));
			}
			else
			{
				if ($vbulletin->GPC['pagecount'])
				{
					exec_header_redirect('newentry.php?' . $vbulletin->session->vars['sessionurl'] . 'do=multipage&entryid=' . $newentryid . '&pagecount=' . $vbulletin->GPC['pagecount']);
				}
				else
				{
					eval(standard_error(fetch_error(
						ADV_DYNA_PREFIX . '_submitted',
						$vbphrase['entry_lwr'],
						$vbulletin->session->vars['sessionurl_q'],
						$vba_options['dyna_title']
					)));
				}
			}
		}
	}
}

// ##### Submit / Edit Entry ##################################################
if ($_REQUEST['do'] == 'newentry' OR $_REQUEST['do'] == 'editentry')
{
	$show['submitasmember'] = false;

	// ##### Edit entry
	if ($_REQUEST['do'] == 'editentry')
	{
		$vba_dyna->load_entry('', true, true, true, true, false, true);
		$entry =& $vba_dyna->_entry;

		$is_category_mod = is_category_mod($entry['catid']);

		// Permisssions
		if (
			(!$vbulletin->userinfo['userid']
				OR ($vbulletin->userinfo['userid'] != $entry['userid'] AND !$vba_dyna->check_cat_perms('caneditothers'))
				OR ($vbulletin->userinfo['userid'] == $entry['userid'] AND !$vba_dyna->check_cat_perms('caneditentries'))
			)
			AND !$is_category_mod)
		{
			print_no_permission();
		}

		// Check time limit
		if (!$is_category_mod
			AND $vba_options['dyna_editentry_timelimit']
			AND !$vba_dyna->_entry['draft']
			AND (TIMENOW - ($vba_options['dyna_editentry_timelimit'] * 60)) > $vba_dyna->_entry['dateline']
		)
		{
			eval(standard_error(fetch_error('edittimelimit', $vba_options['dyna_editentry_timelimit'], $vbulletin->options['contactuslink'])));
		}

		$title =& $entry['title'];

		// Set this for the messagearea
		$post =& $entry;

		$show['editentry'] = true;

		if (!$errors AND !$vbulletin->GPC['preview'])
		{
			$newpost['message'] = $post['pagetext'];
			$keywords = iif($vba_options['dyna_keyword_separator'], $entry['keywords'], str_replace(',', ' ', $entry['keywords']));
		}

		// Show delete option?
		if (($vba_dyna->check_cat_perms('candelete') AND $vbulletin->userinfo['userid'] == $entry['userid']) OR $vba_dyna->check_cat_perms('candeleteothers') OR $is_category_mod)
		{
			$show['deleteopt'] = true;

			$show['physremove'] = $vba_dyna->check_cat_perms('canharddelete');
		}

		// Multiple pages
		$show['editmultipage'] = false;
		if ($vba_options['dyna_multipage_limit'])
		{
			$multipagebits = '';
			$mpageselect = '';
			$getmultipages = $db->query_read("
				SELECT title, pagenumber, pagetext
				FROM " . ADV_DYNA_TABLE_PREFIX . "entries_pages
				WHERE entryid = $entryid
				ORDER BY pagenumber
			");
			$epagecount = $db->num_rows($getmultipages);
			while ($mpages = $db->fetch_array($getmultipages))
			{
				$mpageselect .= '<option value="' . $mpages['pagenumber'] . '"' . iif($epagecount == $mpages['pagenumber'], ' selected="selected"') . '>' . construct_phrase($vbphrase['after_x'], construct_phrase($vbphrase['page_x'], $mpages['pagenumber'])) . iif($mpages['title'], ' (' . fetch_trimmed_title($mpages['title'], 25) . ')') . '</option>';

				if ($mpages['pagenumber'] > 1)
				{
					$mpages['preview'] = fetch_trimmed_title($mpages['pagetext'], 250);
					eval('$multipagebits .= "' . fetch_template(ADV_DYNA_PREFIX . '_add_edit_multipagebits') . '";');
				}
			}

			$show['editmultipage'] = true;
		}

		($hook = vBulletinHook::fetch_hook('vba_dyna_newentry_editentry')) ? eval($hook) : false;
	}
	// ##### Add entry
	else
	{
		if (intval($catid))
		{
			$entry['catid'] = $catid;
		}

		// Set for the construct_custom_fieldbits() function way below
		$_POST['catid'] = $entry['catid'];

		$pagecount = ($vbulletin->GPC['pagecount']) ? $vbulletin->GPC['pagecount'] : '';

		$is_category_mod = is_category_mod($entry['catid']);

		if (!$vbulletin->options['usepopups'])
		{
			if (!$entry['catid'])
			{
				eval(standard_error(fetch_error(ADV_DYNA_PREFIX . '_must_choose_x_for_your_y', $vbphrase['category'], $vbphrase['entry_lwr'])));
			}

			// Check permissions
			if (!$vba_dyna->check_cat_perms('canaddentries', $entry))
			{
				print_no_permission();
			}

			if (!cat_opt('open_for_entries') OR !cat_user_opt('allow_newentries', $entry['catid']))
			{
				eval(standard_error(fetch_error(ADV_DYNA_PREFIX . '_not_open_for_x', $vbphrase['entries'])));
			}
		}

		// Submit as another member
		if ($vba_dyna->check_cat_perms('cansubmitothers'))
		{
			$show['submitasmember'] = true;
			$submitas = $vbulletin->GPC['submitas'];
		}

		($hook = vBulletinHook::fetch_hook('vba_dyna_newentry_addentry')) ? eval($hook) : false;
	}

	$allowedparents = fetch_allowed_submit_parents();
	$options = print_cat_select($entry['catid'], 'submitentry');

	if (!$options)
	{
		print_no_permission();
	}

	$navbits = fetch_cat_navbits($entry['catid']);

	$attachurl = 'catid=' . $catid;

	// ##### Edit entry
	if ($_REQUEST['do'] == 'editentry')
	{
		$attachurl .= '&entryid=' . $vba_dyna->_entry['entryid'];

		$navbits[''] = construct_phrase($vbphrase['edit_x'], $vbphrase['entry']);
	}
	// ##### Add entry
	else
	{
		// Last of the navbits
		$navbits[''] = construct_phrase($vbphrase['submit_x'], $vbphrase['entry']);
	}

	// Time Stamp
	$show['editdate'] = false;
	if ($vba_dyna->check_cat_perms('caneditdateline'))
	{
		$show['editdate'] = true;

		$datelinesel = construct_date_select('customdate', $entry['dateline']);
	}

	if ($vba_options['dyna_allowdrafts'])
	{
		$draftdatesel = construct_date_select('pubdate', ($entry['pubdateline'] ? $entry['pubdateline'] : false));
	}

	// Open close
	$show['openclose'] = false;
	if ($is_category_mod
		OR (($vba_dyna->_entry['userid'] == $vbulletin->userinfo['userid'] OR $_REQUEST['do'] == 'newentry')
			AND $vba_dyna->check_cat_perms('canopenclose', $entry)
		)
	)
	{
		$show['openclose'] = true;
	}

	// ##### Checkboxes
	$checked = array(
		'close' => '',
		'draft' => '',
		'private' => '',
		'favorite' => '',
		'subscribe' => '',
		'disablesmilies' => '',
		'showsignature' => '',
		'parseurl' => 'checked="checked"'
	);

	// Base the values on what's submitted
	if ($errors OR $vbulletin->GPC['preview'])
	{
		if (!$vbulletin->GPC['parseurl'])
		{
			$checked['parseurl'] = '';
		}

		if ($vbulletin->GPC['signature'])
		{
			$checked['signature'] = 'checked="checked"';
		}

		if ($vbulletin->GPC['close'])
		{
			$checked['close'] = 'checked="checked"';
		}

		if ($vbulletin->GPC['disablesmilies'])
		{
			$checked['disablesmilies'] = 'checked="checked"';
		}

		if ($vbulletin->GPC['entryoptions']['subscribe'])
		{
			$checked['subscribe'] = 'checked="checked"';
		}

		if ($vbulletin->GPC['draft'])
		{
			$checked['draft'] = 'checked="checked"';
		}

		if ($vbulletin->GPC['private'])
		{
			$checked['private'] = 'checked="checked"';
		}

		if ($vbulletin->GPC['entryoptions']['favorite'])
		{
			$checked['favorite'] = 'checked="checked"';
		}
	}
	// Editing entry
	else if ($show['editentry'])
	{
		if (!$entry['allowsmilie'])
		{
			$checked['disablesmilies'] = 'checked="checked"';
		}

		if ($entry['issubscribed'])
		{
			$checked['subscribe'] = 'checked="checked"';
		}

		if ($entry['isfavorite'])
		{
			$checked['favorite'] = 'checked="checked"';
		}

		if ($entry['draft'])
		{
			$checked['draft'] = 'checked="checked"';
		}

		if ($entry['private'])
		{
			$checked['private'] = 'checked="checked"';
		}

		if (!$entry['open'])
		{
			$checked['close'] = 'checked="checked"';
		}

		if ($entry['showsignature'])
		{
			$checked['signature'] = 'checked="checked"';
		}
	}
	else if ($vbulletin->userinfo['userid'] AND trim($vbulletin->userinfo['signature']))
	{
		$checked['signature'] = 'checked="checked"';
	}

	$vbulletin->options['editormodes'] = serialize(array('fe' => $vba_options['dyna_editormode']));

	// ##### Editor
	format_vb_text_editor();

	$iconbits = construct_icons(iif($vbulletin->GPC['iconid'], $vbulletin->GPC['iconid'], $entry['iconid']), 1);

	$editsmilie = cat_opt('allow_entry_smilies');

	if (!empty($post) AND !$post['allowsmilie'])
	{
		$editsmilie = 0;
	}

	// [img] tag
	if ($entry['catid'])
	{
		$vbulletin->options['allowbbimagecode'] = (cat_opt('allow_entry_bbimgcode', $entry['catid']) ? 1 : 0);
	}

	if (!$vbulletin->options['allowbbimagecode'])
	{
		$vbulletin->templatecache['editor_toolbar_on'] = str_replace(
			'id=\"{$editorid}_cmd_insertimage\"',
			'id=\"{$editorid}_cmd_insertimage\" style=\"display: none\"',
			$vbulletin->templatecache['editor_toolbar_on']
		);

		$vbulletin->options['allowbbimagecode'] = true;
	}

	// Hide smilies if necessary
	if ((!$entry['catid'] AND !$vbulletin->options['allowsmilies']) OR ($entry['catid'] AND !cat_opt('allow_entry_smilies', $entry['catid'])))
	{
		$vbulletin->templatecache['editor_smiliebox'] = str_replace(
			'id=\"{$editorid}_smiliebox\"',
			'id=\"{$editorid}_smiliebox\" style=\"display: none\"',
			$vbulletin->templatecache['editor_smiliebox']
		);
	}

	// For the editor incase bbcode is not allowed by default
	$vbulletin->options['allowbbcode'] = $vba_options['dyna_editormode'];

	// Editor & message area
	$editorid = construct_edit_toolbar(
		$newpost['message'],
		0,
		'nonforum',
		1,
		$editsmilie,
		1
	);

	$selectedicon['src'] = str_replace(
		$vbulletin->options['cleargifurl'],
		$vbulletin->options['bburl'] . '/' . $vbulletin->options['cleargifurl'],
		$selectedicon['src']
	);

	$usernamecode = '';
	$usernamecode_login = '';
	if ($vbulletin->userinfo['userid'])
	{
		eval('$usernamecode = "' . fetch_template('newpost_usernamecode') . '";');
	}
	else
	{
		eval('$usernamecode_login = "' . fetch_template('newpost_usernamecode') . '";');
	}

	// Image verification
	$imagereg = fetch_human_verify('newentry');

	if ($errorhighlight['imagereg'])
	{
		$vbulletin->templatecache['imagereg'] = str_replace(
			'$vbphrase[image_verification]',
			'<span class=\"problemfield\">$vbphrase[image_verification]</span>',
			$vbulletin->templatecache['imagereg']
		);
	}

	// Custom Fields
	$customfieldbits = construct_custom_fieldbits(
		iif($show['editentry'] AND !$haderrors AND !$vbulletin->GPC['preview'], $vba_dyna->_entry, $_POST),
		'',
		iif($show['editentry'] AND !$haderrors AND !$vbulletin->GPC['preview'], true, false)
	);

	$js_customfields = '';
	if (!empty($cfieldids))
	{
		$js_customfields = implode(',', $cfieldids);
	}

	// Post hash
	if (!$posthash)
	{
		$poststarttime = TIMENOW;
		$posthash = md5(TIMENOW . $vbulletin->userinfo['userid'] . $vbulletin->userinfo['salt']);
	}

	// ##### Attachments
	$attachmentoption = array(
		'above' => '',
		'below' => '',
		'addit' => ''
	);

	require_once(DIR . '/includes/vba_dyna_class_image.php');

	$vba_image =& new vba_dyna_image();
	$vba_image->_vb =& $vbulletin;

	$vba_image->load_extensions();

	if (!empty($vba_image->_extkeys))
	{
		$attachtemp_find = array('"clientscript');
		$attachtemp_replace = array('"' . $vbulletin->options['bburl'] . '/clientscript');

		if ($vba_options['dyna_require_attach'])
		{
			$attachtemp_find[] = '<legend>$vbphrase[attach_files]</legend>';
			$attachtemp_replace[] = '<legend>$vbphrase[attach_files] *</legend>';
		}

		if ($errorhighlight['attach'])
		{
			$attachtemp_find[] = '$vbphrase[attach_files]';
			$attachtemp_replace[] = '<span class=\"problemfield\">$vbphrase[attach_files]</span>';
		}

		$vbulletin->templatecache['newpost_attachment'] = str_replace(
			$attachtemp_find,
			$attachtemp_replace,
			$vbulletin->templatecache['newpost_attachment']
		);

		$vbulletin->userinfo['attachmentextensions'] = implode(', ', $vba_image->_extkeys);

		// Hide the icons div?
		$icondiv_hide = 'marker';
		if (!cat_opt('allow_entry_icons', $catid) OR !$vba_options['dyna_entry_icons'])
		{
			$icondiv_hide = 'none';
		}

		// Hide the attachment option?
		$attachdiv_hide = 'marker';
		if (!$vba_dyna->check_cat_perms('canattach', $entry))
		{
			$attachdiv_hide = 'none';
		}

		$attachments = '';
		$getattach = $db->query_read("
			SELECT attachmentid, dateline, filename, filesize, attach.extension
			FROM " . ADV_DYNA_TABLE_PREFIX . "attachments AS attach
			LEFT JOIN " . ADV_DYNA_TABLE_PREFIX . "attachmenttype AS attachtype ON(attach.extension = attachtype.extension)
			WHERE entryid = " . $entryid .
				iif($_REQUEST['do'] != 'editentry',
					" AND userid = " . $vbulletin->userinfo['userid'] . " AND posthash = '" . $db->escape_string($posthash) . "'")
				. "
			ORDER BY attachtype.displayorder ASC, attach.dateline ASC
		");
		while ($attach = $db->fetch_array($getattach))
		{
			$show['attachmentlist'] = true;

			$attach['imgpath'] = $stylevar['imgdir_attach'] . '/' . $attach['extension'] . '.gif';
			$attach['filesize'] = fetch_rfilesize($attach['filesize']);

			eval('$attachments .= "' . fetch_template('newpost_attachmentbit') . '";');
		}

		$newpost_attachmentbit = prepare_newpost_attachmentbit();
		eval('$attachmentoption[' . $vba_options['dyna_attachlocation'] . '] = "<div id=\"dyna_attach\" style=\"display:$attachdiv_hide\">' . fetch_template('newpost_attachment') . '</div>";');
	}

	($hook = vBulletinHook::fetch_hook('vba_dyna_newentry_complete')) ? eval($hook) : false;

	$navbits = construct_navbits($navbits);
	eval('$navbar = "' . fetch_template('navbar') . '";');

	require_once(DIR . '/includes/vba_dyna_include_modules.php');

	eval('print_output("' . fetch_template(ADV_DYNA_PREFIX_UPPER . '_ADD_EDIT') . '");');
}

// ##### Edit Multiple Pages ##################################################
if ($_REQUEST['do'] == 'multipage' OR $_POST['do'] == 'savemultipage')
{
	if (!$vba_options['dyna_multipage_limit'])
	{
		print_no_permission();
	}

	$vba_dyna->load_entry('', false, true, true, true);
	$vba_dyna->check_loaded_entry();

	$entry =& $vba_dyna->_entry;

	$is_category_mod = is_category_mod($entry['catid']);

	$pagecheck = $db->query_first("SELECT COUNT(*) AS count FROM " . ADV_DYNA_TABLE_PREFIX . "entries_pages WHERE entryid = $entryid");

	// Permissions
	if (
		(!$vbulletin->userinfo['userid']
			OR ($vbulletin->userinfo['userid'] != $vba_dyna->_entry['userid'] AND !$vba_dyna->check_cat_perms('caneditothers'))
			OR ($vbulletin->userinfo['userid'] == $vba_dyna->_entry['userid'] AND !$vba_dyna->check_cat_perms('caneditentries') AND $pagecheck['count'] > 1)
		) AND !$is_category_mod)
	{
		print_no_permission();
	}

	// Check time limit
	if (!$is_category_mod
		AND $vba_options['dyna_editentry_timelimit']
		AND !$vba_dyna->_entry['draft']
		AND (TIMENOW - ($vba_options['dyna_editentry_timelimit'] * 60)) > $vba_dyna->_entry['dateline']
		AND $pagecheck['count'] > 1
	)
	{
		eval(standard_error(fetch_error('edittimelimit', $vba_options['dyna_editentry_timelimit'], $vbulletin->options['contactuslink'])));
	}

	($hook = vBulletinHook::fetch_hook('vba_dyna_savemultipage_start')) ? eval($hook) : false;

	// ##### Save Multiple Pages ################################################
	if ($_POST['do'] == 'savemultipage')
	{
		$vbulletin->input->clean_array_gpc('p', array(
			'afterpage' => TYPE_INT,
			'epage' => TYPE_INT,
			'disablesmilies' => TYPE_ARRAY_INT,
			'message' => TYPE_ARRAY,
			'pagecount' => TYPE_INT,
			'parseurl' => TYPE_ARRAY_INT,
			'preview' => TYPE_STR,
			'title' => TYPE_ARRAY,
			'wysiwyg' => TYPE_ARRAY_INT
		));

		$vbulletin->GPC['preview'] = (trim($vbulletin->GPC['preview'])) ? true : false;

		$pagecount = min($vbulletin->GPC['pagecount'], $vba_options['dyna_multipage_limit']);

		// Load BBcode parser
		require_once(DIR . '/includes/class_bbcode.php');
		$bbcode_parser =& new vB_BbCodeParser($vbulletin, fetch_tag_list());

		// WYSIWYG
		if (!empty($vbulletin->GPC['wysiwyg']))
		{
			require_once(DIR . '/includes/functions_wysiwyg.php');
		}

		$vbulletin->options['allowhtml'] = cat_opt('allow_entry_html', $entry['catid']);
		$vbulletin->options['allowbbcode'] = cat_opt('allow_entry_bbcode', $entry['catid']);
		$vbulletin->options['allowbbimagecode'] = cat_opt('allow_entry_bbimgcode', $entry['catid']);
		$catsmilies = cat_opt('allow_entry_smilies', $entry['catid']);

		// What are we doing?
		if ($vbulletin->GPC['pagecount'])
		{
			if ($vbulletin->GPC['afterpage'])
			{
				$pagearray = range(($vbulletin->GPC['afterpage'] + 1), ($vbulletin->GPC['pagecount'] + $vbulletin->GPC['afterpage']));
			}
			else
			{
				$pagearray = range(1, $vbulletin->GPC['pagecount']);
			}
		}
		else
		{
			$pagearray = range(1, $pagecheck['count']);
		}

		// Load bbcode img check
		if ($vba_options['dyna_maxentryimages'])
		{
			require_once(DIR . '/includes/functions_misc.php');
		}

		$errors = array();
		$errorhighlight = array();
		$message_parsed = array();
		$entrypreview = '';

		// Format the query
		$epages_query = '';
		$ecache_query = '';

		foreach ($pagearray AS $i)
		{
			$message =& $vbulletin->GPC['message'][$i];
			$title = htmlspecialchars($_POST['title_' . $i]);

			if ($message OR $title)
			{
				if ($vbulletin->GPC['wysiwyg'][$i])
				{
					$message = convert_wysiwyg_html_to_bbcode($message, cat_opt('allow_entry_html', $entry['catid']));
				}

				if ($vbulletin->GPC['parseurl'][$i])
				{
					$message = convert_url_to_bbcode($message);
				}

				$allowsmilies = 1;
				if ($vbulletin->GPC['disablesmilies'][$i] OR !$catsmilies)
				{
					$allowsmilies = 0;
				}

				// Check max title length
				$titlelen = strlen($title);
				if ($vba_options['dyna_maxtitlelength'] AND $titlelen > $vba_options['dyna_maxtitlelength'])
				{
					eval('$errors[$i][] = "' . fetch_error(ADV_DYNA_PREFIX . '_x_too_long', $vbphrase['title'], vb_number_format($titlelen), vb_number_format($vba_options['dyna_maxtitlelength'])) . '";');
					$errorhighlight[$i]['title'] = true;
				}

				// Check message length
				$entrylength = strlen($message);
				if ($vba_options['dyna_maxdesclength'] AND $entrylength > $vba_options['dyna_maxdesclength'])
				{
					eval('$errors[$i][] = "' . fetch_error(ADV_DYNA_PREFIX . '_x_too_long', $vbphrase['post'], vb_number_format($entrylength), vb_number_format($vba_options['dyna_maxdesclength'])) . '";');
					$errorhighlight[$i]['message'] = true;
				}

				// Max images
				if ($vba_options['dyna_maxentryimages'])
				{
					$imagecount = fetch_character_count($bbcode_parser->parse($message, 'nonforum', $allowsmilies, true), '<img');

					if ($imagecount > $vba_options['dyna_maxentryimages'])
					{
						eval('$errors[$i][] = "' . fetch_error('toomanyimages', $imagecount, $vba_options['dyna_maxentryimages']) . '";');
						$errorhighlight[$i]['message'] = true;
					}
				}

				$bbcode_parser->cached['text'] = '';
				if (($vba_options['dyna_cachedlife'] OR $vbulletin->GPC['preview']) AND empty($errors))
				{
					$vbulletin->options['allowsmilies'] = $allowsmilies;

					// Parse pagetext
					$message_parsed[$i] = $bbcode_parser->parse(
						$message,
						'nonforum',
						$vbulletin->options['allowsmilies'],
						true,
						'',
						3,
						($vba_options['dyna_cachedlife'] AND $entry['dateline'] >= (TIMENOW - ($vba_options['dyna_cachedlife'] * 86400)) ? true : false)
					);

					if ($vbulletin->GPC['preview'])
					{
						exec_switch_bg();
						$message =& $message_parsed[$i];
						eval('$entrypreview .= "' . fetch_template(ADV_DYNA_PREFIX . '_add_edit_multipage_previewbit') . '";');
					}
				}

				if (empty($errors))
				{
					// entry_pages
					$epages_query .= '(
						' . $entryid . ',
						\'' . $db->escape_string($title) . '\',
						\'' . $db->escape_string($message) . '\',
						' . $i . ',
						' . intval($allowsmilies) . '
					), ';

					// Entry cache
					if ($bbcode_parser->cached['text'])
					{
						$ecache_query .= '(
							' . $entryid . ',
							' . $i . ',
							\'' . $db->escape_string($bbcode_parser->cached['text']) . '\',
							' . $entry['dateline'] . ',
							' . $vbulletin->userinfo['styleid'] . ',
							' . $vbulletin->userinfo['languageid'] . ',
							' . $bbcode_parser->cached['has_images'] . '
						), ';
					}
				}
			}
		}

		// ##### Errors
		$entryerrors = '';
		if (!empty($errors) OR $vbulletin->GPC['preview'])
		{
			if (!empty($errors))
			{
				foreach ($errors AS $errorpageid => $pageerrors)
				{
					$errorlist = '';
					foreach ($pageerrors AS $errormessage)
					{
						eval('$errorlist .= "' . fetch_template('newpost_errormessage') . '";');
					}

					exec_switch_bg();
					eval('$entryerrors .= "' . fetch_template(ADV_DYNA_PREFIX . '_add_edit_multipage_errorbit') . '";');
				}

				$entrypreview = '';
			}

			$_REQUEST['do'] = 'multipage';
		}
		else
		{
			// Adding a new page(s) after another
			if ($vbulletin->GPC['afterpage'] AND $vbulletin->GPC['afterpage'] != $pagecheck['count'])
			{
				$db->query_write("UPDATE " . ADV_DYNA_PREFIX . "_entries_pages SET pagenumber = pagenumber + " . $vbulletin->GPC['pagecount'] . " WHERE pagenumber > " . $vbulletin->GPC['afterpage']);
			}

			if ($epages_query)
			{
				$db->query_write("
					REPLACE INTO " . ADV_DYNA_TABLE_PREFIX . "entries_pages
						(entryid, title, pagetext, pagenumber, allowsmilie)
					VALUES
						" . substr($epages_query, 0, (strlen($epages_query) - 2))
				);
			}

			if ($ecache_query)
			{
				// Delete first since a replace into would not update all languages/styles
				$db->query_write("DELETE FROM " . ADV_DYNA_TABLE_PREFIX . "entryparsed WHERE entryid = $entryid");

				$db->query_write("
					INSERT INTO " . ADV_DYNA_TABLE_PREFIX . "entryparsed
						(entryid, pagenumber, pagetext_parsed, dateline, styleid, languageid, hasimages)
					VALUES
						" . substr($ecache_query, 0, (strlen($ecache_query) - 2))
				);
			}

			if ($vbulletin->GPC['afterpage'] OR $vbulletin->GPC['epage'] > 1)
			{
				$vbulletin->url = 'newentry.php?' . $vbulletin->session->vars['sessionurl'] . 'do=editentry&entryid=' . $entryid;
			}
			else
			{
				$vbulletin->url = $entry['url'];
			}

			if ($entry['valid'])
			{
				eval(print_standard_redirect(ADV_DYNA_PREFIX . '_addednew'));
			}
			else
			{
				eval(standard_error(fetch_error(
					ADV_DYNA_PREFIX . '_submitted',
					$vbphrase['entry_lwr'],
					$vbulletin->session->vars['sessionurl_q'],
					$vba_options['dyna_title']
				)));
			}
		}
	}

	// ##### Edit Multiple Pages ################################################
	if ($_REQUEST['do'] == 'multipage')
	{
		$vbulletin->input->clean_array_gpc('r', array(
			'afterpage' => TYPE_INT,
			'pagecount' => TYPE_INT
		));

		// ##### Editor
		$vbulletin->options['editormodes'] = serialize(array('fe' => $vba_options['dyna_editormode']));

		format_vb_text_editor();

		$editsmilie = cat_opt('allow_entry_smilies', $entry['catid']);
		$show['disablesmilies'] = $editsmilie;

		$vbulletin->options['allowbbimagecode'] = (cat_opt('allow_entry_bbimgcode', $entry['catid']) ? 1 : 0);

		$vbulletin->templatecache['editor_toolbar_off'] = str_replace(
			'name=\"message\"',
			'name=\"message[{$editorid}]\"',
			$vbulletin->templatecache['editor_toolbar_off']
		);

		$vbulletin->templatecache['editor_toolbar_on'] = str_replace(
			array(
				'name=\"message\"',
				'name=\"wysiwyg\"'
			),
			array(
				'name=\"message[{$editorid}]\"',
				'name=\"wysiwyg[{$editorid}]\"'
			),
			$vbulletin->templatecache['editor_toolbar_on']
		);

		$pagecount = min($vbulletin->GPC['pagecount'], $vba_options['dyna_multipage_limit']);
		$afterpage = $vbulletin->GPC['afterpage'];

		$epacecache = array();

		// Cache the page info if we're not adding more pages
		if (!$afterpage)
		{
			$getepages = $db->query_read("
				SELECT *
				FROM " . ADV_DYNA_TABLE_PREFIX . "entries_pages
				WHERE entryid = $entryid
			");
			while ($epages = $db->fetch_array($getepages))
			{
				$epagecache[$epages['pagenumber']] = $epages;
			}
		}

		$formonsubmit = '';
		$formatonsubmit = false;
		if (!is_browser('webtv'))
		{
			$formonsubmit = ' onsubmit="';
			$formatonsubmit = true;
		}

		// Figure out what we're doing
		if ($vbulletin->GPC['epage'] > 1)
		{
			$pagearray = array($vbulletin->GPC['epage']);
		}
		else if ($vbulletin->GPC['pagecount'])
		{
			if ($afterpage)
			{
				$pagearray = range(($afterpage + 1), ($vbulletin->GPC['pagecount'] + $afterpage));
			}
			else
			{
				$pagearray = range(1, $vbulletin->GPC['pagecount']);
			}
		}
		else
		{
			$pagearray = array_keys($epagecache);
		}

		// For the editor incase bbcode is not allowed by default
		$vbulletin->options['allowbbcode'] = cat_opt('allow_entry_bbcode', $entry['catid']);

		foreach ($pagearray AS $epage)
		{
			if ($vbulletin->GPC['preview'] OR !empty($errors))
			{
				$pagemessage = $vbulletin->GPC['message'][$epage];
			}
			else
			{
				$pagemessage = $epagecache[$epage]['pagetext'];
			}

			// Editor & message area
			$editorid = construct_edit_toolbar(
				$pagemessage,
				false,
				0,
				($vbulletin->GPC['disablesmilies'][$epage] ? 0 : 1),
				$editsmilie,
				false,
				'fe',
				$epage
			);

			// Kill the javascript after it's been called once
			$vbulletin->templatecache['editor_clientscript'] = '';

			if ($formatonsubmit)
			{
				$formonsubmit .= 'vB_Editor[\'' . $editorid . '\'].prepare_submit(0, 0);';
			}

			$title = iif($vbulletin->GPC['preview'] OR !empty($errors), htmlspecialchars($_POST['title_' . $epage]), $epagecache[$epage]['title']);

			$checked = array();

			if ($vbulletin->GPC['disablesmilies'][$epage])
			{
				$checked['disablesmilies'] = ' checked="checked"';
			}

			if ($_POST['do'] != 'savemultipage' OR $vbulletin->GPC['parseurl'][$epage])
			{
				$checked['parseurl'] = ' checked="checked"';
			}

			eval('$messageareabits .= "' . fetch_template(ADV_DYNA_PREFIX . '_add_edit_multipage_messagearea') . '";');
		}

		if ($formatonsubmit)
		{
			$formonsubmit .= '"';
		}

		$epage = $vbulletin->GPC['epage'];

		($hook = vBulletinHook::fetch_hook('vba_dyna_savemultipage_complete')) ? eval($hook) : false;

		$navbits[''] = $entry['title'];
		$navbits = construct_navbits($navbits);
		eval('$navbar = "' . fetch_template('navbar') . '";');

		require_once(DIR . '/includes/vba_dyna_include_modules.php');

		eval('print_output("' . fetch_template(ADV_DYNA_PREFIX_UPPER . '_ADD_EDIT_MULTIPAGE') . '");');
	}
}

// ##### Edit Multiple Pages ##################################################
if ($_REQUEST['do'] == 'deletepage' OR $_POST['do'] == 'dodeletepage')
{
	if (!$vba_options['dyna_multipage_limit'])
	{
		print_no_permission();
	}

	$vba_dyna->load_entry('', true, true, true, true);
	$vba_dyna->check_loaded_entry();

	$entry =& $vba_dyna->_entry;

	if (!$entry['pagenumber'])
	{
		eval(standard_error(fetch_error('noid', $vbphrase['page'])));
	}

	$is_category_mod = is_category_mod($entry['catid']);

	$vbulletin->input->clean_gpc('r', 'epage', TYPE_INT);

	// Permissions
	if (
		(!$vbulletin->userinfo['userid']
			OR ($vbulletin->userinfo['userid'] != $vba_dyna->_entry['userid'] AND !$vba_dyna->check_cat_perms('caneditothers'))
			OR ($vbulletin->userinfo['userid'] == $vba_dyna->_entry['userid'] AND !$vba_dyna->check_cat_perms('caneditentries'))
		) AND !$is_category_mod)
	{
		print_no_permission();
	}

	// Check time limit
	if (!$is_category_mod
		AND $vba_options['dyna_editentry_timelimit']
		AND !$vba_dyna->_entry['draft']
		AND (TIMENOW - ($vba_options['dyna_editentry_timelimit'] * 60)) > $vba_dyna->_entry['dateline']
	)
	{
		eval(standard_error(fetch_error('edittimelimit', $vba_options['dyna_editentry_timelimit'], $vbulletin->options['contactuslink'])));
	}

	($hook = vBulletinHook::fetch_hook('vba_dyna_deletepage')) ? eval($hook) : false;

	// ##### Do Delete Page #####################################################
	if ($_POST['do'] == 'dodeletepage')
	{
		$vbulletin->input->clean_gpc('p', 'confirmaction', TYPE_INT);

		if (!$vbulletin->GPC['confirmaction'])
		{
			eval(standard_error(fetch_error(ADV_DYNA_PREFIX . '_nodelete', $vbphrase['page'])));
		}

		$db->query_write("DELETE FROM " . ADV_DYNA_TABLE_PREFIX . "entries_pages WHERE pagenumber = " . $vbulletin->GPC['epage']);
		$db->query_write("UPDATE " . ADV_DYNA_TABLE_PREFIX . "entries_pages SET pagenumber = pagenumber-1 WHERE pagenumber > " . $vbulletin->GPC['epage']);

		$vbulletin->url = 'newentry.php?' . $vbulletin->session->vars['sessionurl'] . 'do=editentry&entryid=' . $entry['entryid'];
		eval(print_standard_redirect(ADV_DYNA_PREFIX . '_deleted'));
	}

	// ##### Confirm Deletion ###################################################
	else
	{
		$formaction = 'newentry';
		$dovalue = 'dodeletepage';
		$itemname = 'epage';
		$itemid =& $entry['pagenumber'];
		$itemtitle = $entry['title'] . ' - ' . construct_phrase($vbphrase['page_x'], $vbulletin->GPC['epage']);
		$titlephrase = construct_phrase($vbphrase['delete_this_x'], $vbphrase['page']);
		$confirmphrase = construct_phrase($vbphrase['delete_x_message_checkbox'], $vbphrase['page']);
		$buttonphrase = $titlephrase;
		$additionalhidden = '<input type="hidden" name="entryid" value="' . $entry['entryid'] . '" />';

		$navname = $titlephrase;

		$show['entryname'] = true;
		$show['check_confirm'] = true;

		fetch_entry_url($entry);

		$navbits = fetch_cat_navbits($entry['catid']);
		$navbits[$entry['url']] = $entry['title'];
		$navbits[$entry['url']] = construct_phrase($vbphrase['page_x'], $vbulletin->GPC['epage']);
		$navbits[''] = $navname;
		$navbits = construct_navbits($navbits);
		eval('$navbar = "' . fetch_template('navbar') . '";');

		eval('print_output("' . fetch_template(ADV_DYNA_PREFIX_UPPER . '_CONFORMATION') . '");');
	}

}

?>