<?php
// ++=========================================================================++
// || vBadvanced Dynamics v1.0.0 (vB 3.6 - vB 3.7)
// ||  2003-2007 vBadvanced.com - All Rights Reserved
// || This file may not be redistributed in whole or significant part.
// || http://vbadvanced.com
// ++ ========================================================================++

error_reporting(E_ALL & ~E_NOTICE);

$specialtemplates = array(
	'adv_dyna_attach',
	'adv_dyna_cats',
	'adv_dyna_mods',
	'adv_dyna_perms'
);

$phrasegroups = array(
	'adv_dyna_cp_mainten'
);

require_once('./vba_dyna_admin_global.php');

if (!$_REQUEST['do'])
{
	$_REQUEST['do'] = 'main';
}

($hook = vBulletinHook::fetch_hook('vba_dyna_cp_maintenance_start')) ? eval($hook) : false;

// ############################# Maintenance #########################
if ($_REQUEST['do'] == 'main')
{
	// Cancel Subscriptions
	echo '<a name="tool_cancelsubscribe"></a>';
	print_dyna_form_header('vba_dyna_admin_maintenance', 'cancelsubscribe');
	print_table_header($vbphrase['cancel_subscriptions']);
	print_description_row($vbphrase['cancel_subscriptions_desc']);
	print_input_row($vbphrase['username'], 'username');
	print_submit_row($vbphrase['cancel_subscriptions'], '');

	// Update Category Counters
	echo '<a name="tool_catcounts"></a>';
	print_dyna_form_header('vba_dyna_admin_maintenance', 'updatecounters');
	print_table_header($vbphrase['update_categories']);
	print_description_row($vbphrase['update_categories_counters_desc'] . '<br /><br />
		<div><input checked="checked" name="entrycount" type="checkbox" value="1" /> ' . construct_phrase($vbphrase['x_counts'], $vbphrase['entry']) . '</div>
		<div><input checked="checked" name="postcount" type="checkbox" value="1" /> ' . construct_phrase($vbphrase['x_counts'], $vbphrase['post']) . '</div>
		<div><input checked="checked" name="lastentries" type="checkbox" value="1" /> ' . construct_phrase($vbphrase['last_x_info'], $vbphrase['entry'])  . '</div>
		<div><input checked="checked" name="lastposts" type="checkbox" value="1" /> ' . construct_phrase($vbphrase['last_x_info'], $vbphrase['post']) . '</div>
	');
	print_submit_row($vbphrase['update_counters'], '');

	// Update Members' Categories
	echo '<a name="tool_membercatcounts"></a>';
	print_dyna_form_header('vba_dyna_admin_maintenance', 'memberscounts');
	print_table_header($vbphrase['update_members_categories']);
	print_description_row($vbphrase['update_members_categories_counters_desc']);
	print_input_row(construct_phrase($vbphrase['number_of_x_per_cycle'], $vbphrase['categories_lwr']), 'perpage', 25);
	print_submit_row($vbphrase['update_counters'], '');

	// Update entries last post
	echo '<a name="tool_lastpost"></a>';
	print_dyna_form_header('vba_dyna_admin_maintenance', 'updatelastpost');
	print_table_header($vbphrase['update_last_posts']);
	print_description_row(construct_phrase($vbphrase['update_last_posts_desc'], $vbphrase['entries_lwr']));
	print_submit_row($vbphrase['update_counters'], '');

	// Rebuild Attachment Thumbnails
	echo '<a name="tool_attachthumbs"></a>';
	print_dyna_form_header('vba_dyna_admin_maintenance', 'rebuildattachthumbs');
	print_table_header($vbphrase['rebuild_attachment_thumbnails']);
	print_description_row($vbphrase['rebuild_attachment_thumbnails_desc']);
	print_input_row(construct_phrase($vbphrase['number_of_x_per_cycle'], $vbphrase['attachments']), 'perpage', 50);
	print_submit_row($vbphrase['rebuild_attachment_thumbnails'], '');

	// Rebuild Attachment Counts
	echo '<a name="tool_attachcounts"></a>';
	print_dyna_form_header('vba_dyna_admin_maintenance', 'rebuildattachcount');
	print_table_header($vbphrase['rebuild_attachment_counters']);
	print_description_row($vbphrase['rebuild_attachment_counters_desc']);
	print_input_row(construct_phrase($vbphrase['number_of_x_per_cycle'], $vbphrase['attachments']), 'perpage', 1000);
	print_submit_row($vbphrase['rebuild_attachment_counters'], '');

	// Rebuild First Attachment
	echo '<a name="tool_firstattach"></a>';
	print_dyna_form_header('vba_dyna_admin_maintenance', 'rebuildfirstattach');
	print_table_header($vbphrase['rebuild_category_attachments']);
	print_description_row($vbphrase['rebuild_category_attachments_desc']);
	print_submit_row($vbphrase['rebuild_category_attachments'], '');

	// Rebuild Usernames
	echo '<a name="tool_usernames"></a>';
	print_dyna_form_header('vba_dyna_admin_maintenance', 'rebuildusernames');
	print_table_header($vbphrase['update_usernames']);
	print_description_row($vbphrase['update_usernames_desc']);
	print_submit_row($vbphrase['update_usernames'], '');

	// Update Entry Cache
	echo '<a name="tool_entrycache"></a>';
	print_dyna_form_header('vba_dyna_admin_maintenance', 'rebuildentrycache');
	print_table_header(construct_phrase($vbphrase['rebuild_x_cache'], $vbphrase['entry']));
	print_input_row(construct_phrase($vbphrase['number_of_x_per_cycle'], $vbphrase['entries_lwr']), 'perpage', 250);
	print_submit_row(construct_phrase($vbphrase['rebuild_x_cache'], $vbphrase['entry']), '');

	// Rebuild BB Code Modules
	echo '<a name="tool_bbmodules"></a>';
	print_dyna_form_header('vba_dyna_admin_maintenance', 'rebuildbbcodemodules');
	print_table_header(construct_phrase($vbphrase['rebuild_x_cache'], $vbphrase['module']));
	print_description_row(construct_phrase($vbphrase['update_bbcode_x_desc'], $vbphrase['modules_lwr']));
	print_input_row(construct_phrase($vbphrase['number_of_x_per_cycle'], $vbphrase['modules_lwr']), 'perpage', 250);
	print_submit_row(construct_phrase($vbphrase['rebuild_x_cache'], $vbphrase['modules']), '');
}

// ##### Rebuild Usernames ####################################################
if ($_POST['do'] == 'rebuildusernames')
{
	$updateusers = array();

	// Check entries
	$entries = $db->query_read("
		SELECT entries.userid, entries.username, user.username AS user_username
		FROM " . ADV_DYNA_TABLE_PREFIX . "entries AS entries
		LEFT JOIN " . TABLE_PREFIX . "user AS user ON (entries.userid = user.userid)
		GROUP BY entries.userid
	");
	while ($entry = $db->fetch_array($entries))
	{
		if ($entry['username'] != $entry['user_username'])
		{
			$updateusers[$entry['userid']] = $entry['user_username'];
		}
	}

	$postwhere = '';
	if (!empty($updateusers))
	{
		$postwhere = 'WHERE posts.userid NOT IN(' . implode(', ', array_keys($updateusers)) . ')';
	}

	// Check posts
	$posts = $db->query_read("
		SELECT posts.userid, posts.username, user.username AS user_username
		FROM " . ADV_DYNA_TABLE_PREFIX . "posts AS posts
		LEFT JOIN " . TABLE_PREFIX . "user AS user ON (posts.userid = user.userid)
		$postwhere
		GROUP BY posts.userid
	");
	while ($post = $db->fetch_array($posts))
	{
		if ($post['username'] != $post['user_username'])
		{
			$updateusers[$post['userid']] = $post['user_username'];
		}
	}

	$postwhere = '';
	if (!empty($updateusers))
	{
		$postwhere = 'WHERE posts.userid NOT IN(' . implode(', ', array_keys($updateusers)) . ')';
	}

	// Check guest book
	$posts = $db->query_read("
		SELECT posts.userid, posts.username, user.username AS user_username
		FROM " . ADV_DYNA_TABLE_PREFIX . "guestbook AS posts
		LEFT JOIN " . TABLE_PREFIX . "user AS user ON (posts.userid = user.userid)
		$postwhere
		GROUP BY posts.userid
	");
	while ($post = $db->fetch_array($posts))
	{
		if ($post['username'] != $post['user_username'])
		{
			$updateusers[$post['userid']] = $post['user_username'];
		}
	}

	// ##### Update Everything
	if (!empty($updateusers))
	{
		foreach ($updateusers AS $userid => $username)
		{
			// Entries
			$db->query_write("
				UPDATE " . ADV_DYNA_TABLE_PREFIX . "entries SET
					username = '" . $db->escape_string($username) . "'
				WHERE userid = $userid
			");

			// Last post column
			$db->query_write("
				UPDATE " . ADV_DYNA_TABLE_PREFIX . "entries SET
					lastpostusername = '" . $db->escape_string($username) . "'
				WHERE lastpostuserid = $userid
			");

			// Posts
			$db->query_write("
				UPDATE " . ADV_DYNA_TABLE_PREFIX . "posts SET
					username = '" . $db->escape_string($username) . "'
				WHERE userid = $userid
			");

			// Deletion log
			$db->query_write("
				UPDATE " . ADV_DYNA_TABLE_PREFIX . "deletionlog SET
					username = '" . $db->escape_string($username) . "'
				WHERE userid = $userid
			");

			// Categories (last post)
			$db->query_write("
				UPDATE " . ADV_DYNA_TABLE_PREFIX . "categories SET
					lastpostusername = '" . $db->escape_string($username) . "'
				WHERE lastpostuserid = $userid
			");

			// Categories (last entry)
			$db->query_write("
				UPDATE " . ADV_DYNA_TABLE_PREFIX . "categories SET
					lastentryusername = '" . $db->escape_string($username) . "'
				WHERE lastentryuserid = $userid
			");

			// Members Categories (last post)
			$db->query_write("
				UPDATE " . ADV_DYNA_TABLE_PREFIX . "memberscats  SET
					lastpostusername = '" . $db->escape_string($username) . "'
				WHERE lastpostuserid = $userid
			");

			// Members Categories (last entry)
			$db->query_write("
				UPDATE " . ADV_DYNA_TABLE_PREFIX . "memberscats  SET
					lastentryusername = '" . $db->escape_string($username) . "'
				WHERE lastentryuserid = $userid
			");

			// Guest Book
			$db->query_write("
				UPDATE " . ADV_DYNA_TABLE_PREFIX . "guestbook SET
					username = '" . $db->escape_string($username) . "'
				WHERE userid = $userid
			");
		}
	}

	// Rebuild cache
	require_once(DIR . '/includes/vba_dyna_functions_savecat.php');

	update_category_cache();
	update_dyna_moderator_cache();

	print_cp_redirect('vba_dyna_admin_maintenance.php?' . $vbulletin->session->vars['sessionurl'] . ADV_URL_PREFIX_HR, 0);

}

// ##### Rebuild Module Cache #################################################
if ($_REQUEST['do'] == 'rebuildbbcodemodules')
{
	$perpage = $vbulletin->input->clean_gpc('r', 'perpage', TYPE_INT);

	$pagedata = fetch_page_data(ADV_DYNA_PREFIX . '_modules_user', array('modid = 0'), array(), $perpage);

	$modulereplace = '';
	$getmodules = $db->query_read("
		SELECT *
		FROM " . ADV_DYNA_TABLE_PREFIX . "modules_user
		WHERE modid = 0
		ORDER BY modlinkid
		LIMIT " . ($pagedata['minlimit'] - 1) . ", $pagedata[perpage]
	");
	if ($db->num_rows($getmodules))
	{
		$bbcodetemps = $db->query_read("SELECT * FROM " . TABLE_PREFIX . "template WHERE title IN('bbcode_code', 'bbcode_html', 'bbcode_php', 'bbcode_quote') AND styleid = " . $vbulletin->options['styleid']);
		while ($temp = $db->fetch_array($bbcodetemps))
		{
			$vbulletin->templatecache[$temp['title']] = $temp['template'];
		}

		// Load BBcode parser
		require_once(DIR . '/includes/class_bbcode.php');
		$bbcode_parser =& new vB_BbCodeParser($vbulletin, fetch_tag_list());

		while ($mod = $db->fetch_array($getmodules))
		{
			$mod['code_parsed'] = $bbcode_parser->do_parse(
				$mod['code'],
				0,
				iif($vba_options['dyna_allow_module_smilie'], $mod['allowsmilie'], 0),
				$vba_options['dyna_allow_module_bbcode'],
				$vba_options['dyna_allow_module_img']
			);

			$mod['title'] = '\'' . $db->escape_string($mod['title']) . '\'';
			$mod['code'] = '\'' . $db->escape_string($mod['code']) . '\'';
			$mod['code_parsed'] = '\'' . $db->escape_string($mod['code_parsed']) . '\'';

			$modulereplace .= '(';
			$modulereplace .= implode(', ', $mod);
			$modulereplace .= '), ';
		}

		$modulereplace = substr($modulereplace, 0, (strlen($modulereplace) - 2));
		$db->query_write("REPLACE INTO " . ADV_DYNA_TABLE_PREFIX . "modules_user VALUES $modulereplace");
	}

	// All done or redirect
	if ($pagedata['pagenumber'] >= $pagedata['pagecount'])
	{
		define('CP_BACKURL', 'vba_dyna_admin_maintenance.php?' . $vbulletin->session->vars['sessionurl'] . 'do=main' . ADV_URL_PREFIX_HR);
		print_stop_message(ADV_DYNA_PREFIX . '_updated_x_cache_successfully', $vbphrase['module_lwr']);
	}
	else
	{
		print_cp_redirect('vba_dyna_admin_maintenance.php?' . $vbulletin->session->vars['sessionurl'] . 'do=rebuildbbcodemodules' . ADV_URL_PREFIX_HR . '&page=' . ($pagedata['pagenumber'] + 1) . '&perpage=' . $perpage, 0);
	}
}


// ##### Rebuild Entry Cache ##################################################
if ($_REQUEST['do'] == 'rebuildentrycache')
{
	$perpage = $vbulletin->input->clean_gpc('r', 'perpage', TYPE_INT);

	$pagedata = fetch_page_data(ADV_DYNA_PREFIX . '_entries', array(), array(), $perpage);

	$entryreplace = '';
	$getentries = $db->query_read("
		SELECT parsed.*, catid, pagetext
		FROM " . ADV_DYNA_TABLE_PREFIX . "entryparsed AS parsed
		LEFT JOIN " . ADV_DYNA_TABLE_PREFIX . "entries AS entry ON (parsed.entryid = entry.entryid)
		LEFT JOIN " . ADV_DYNA_TABLE_PREFIX . "entries_pages AS pages ON (parsed.entryid = pages.entryid)
		ORDER BY catid
		LIMIT " . ($pagedata['minlimit'] - 1) . ", $pagedata[perpage]
	");
	if ($db->num_rows($getentries))
	{
		$templatecache = array();
		$bbcodetemps = $db->query_read("SELECT * FROM " . TABLE_PREFIX . "template WHERE title IN('bbcode_code', 'bbcode_html', 'bbcode_php', 'bbcode_quote')");
		while ($temp = $db->fetch_array($bbcodetemps))
		{
			$templatecache[$temp['styleid']][$temp['title']] = $temp['template'];
		}

		// Load BBcode parser
		require_once(DIR . '/includes/class_bbcode.php');
		$bbcode_parser =& new vB_BbCodeParser($vbulletin, fetch_tag_list());

		while ($entry = $db->fetch_array($getentries))
		{
			$vbulletin->templatecache = ($templatecache[$entry['styleid']]) ? $templatecache[$entry['styleid']] : $templatecache['-1'];

			$entry['pagetext_parsed'] = $bbcode_parser->do_parse(
				$entry['pagetext'],
				cat_opt('allow_entry_html', $entry['catid']),
				iif(cat_opt('allow_entry_smilies', $entry['catid']), $entry['allowsmilie'], 0),
				cat_opt('allow_entry_bbcode', $entry['catid']),
				cat_opt('allow_entry_bbimgcode', $entry['catid'])
			);

			$entry['pagetext_parsed'] = '\'' . $db->escape_string($entry['pagetext_parsed']) . '\'';

			unset($entry['catid'], $entry['pagetext']);

			$entryreplace .= '(';
			$entryreplace .= implode(', ', $entry);
			$entryreplace .= '), ';
		}

		$entryreplace = substr($entryreplace, 0, (strlen($entryreplace) - 2));
		$db->query_write("REPLACE INTO " . ADV_DYNA_TABLE_PREFIX . "entryparsed VALUES $entryreplace");
	}

	// All done or redirect
	if ($pagedata['pagenumber'] >= $pagedata['pagecount'])
	{
		define('CP_BACKURL', 'vba_dyna_admin_maintenance.php?' . $vbulletin->session->vars['sessionurl'] . 'do=main' . ADV_URL_PREFIX_HR);
		print_stop_message(ADV_DYNA_PREFIX . '_updated_x_cache_successfully', $vbphrase['entry_lwr']);
	}
	else
	{
		print_cp_redirect('vba_dyna_admin_maintenance.php?' . $vbulletin->session->vars['sessionurl'] . 'do=rebuildentrycache&page=' . ($pagedata['pagenumber'] + 1) . '&perpage=' . $perpage . ADV_URL_PREFIX_HR, 0);
	}
}

// ##### Update Members' Categories Counts ####################################
if ($_REQUEST['do'] == 'memberscounts')
{
	$perpage = $vbulletin->input->clean_gpc('r', 'perpage', TYPE_INT);
	$catkey = $vbulletin->input->clean_gpc('r', 'catkey', TYPE_INT);

	$catkeys = array_keys($vbulletin->adv_dyna_cats);
	$catid = $catkeys[$catkey];

	echo '<div style="margin-bottom: 12px">' . construct_phrase($vbphrase['processing_x_y'], $vbphrase['category'], $vbulletin->adv_dyna_cats[$catid]['title']) . '</div>';

	$wherequery = 'valid = 1 AND draft = 0 AND private = 0 AND catid = ' . $catid;

	$duserids = array();
	$countusers = $db->query_read("SELECT DISTINCT userid FROM " . ADV_DYNA_TABLE_PREFIX . "entries WHERE $wherequery");
	$usercount = $db->num_rows($countusers);
	if ($_REQUEST['pagenumber'] <= 1)
	{
		while ($duser = $db->fetch_array($countusers))
		{
			$duserids[] = $duser['userid'];
		}
	}
	$db->free_result($countusers);

	$pagedata = fetch_page_data(ADV_DYNA_PREFIX . '_entries', array($wherequery . ' GROUP BY userid'), array(), $perpage, $usercount);

	$usercat = array();
	$users = $db->query_read("
		SELECT DISTINCT userid, username
		FROM " . ADV_DYNA_TABLE_PREFIX . "entries
		WHERE $wherequery
		ORDER BY userid
		LIMIT " . ($pagedata['minlimit'] - 1) . ", $pagedata[perpage]
	");
	while ($user = $db->fetch_array($users))
	{
		$ucat =& $usercat[$user['userid']];

		echo '<div>' . construct_phrase($vbphrase['processing_x_y'], $vbphrase['user'], $user['username']) . '</div>';
		vbflush();

		// Entry count
		$entrycount = $db->query_first("
			SELECT COUNT(*) AS count
			FROM " . ADV_DYNA_TABLE_PREFIX . "entries
			WHERE $wherequery
				AND userid = $user[userid]
		");
		$ucat['entrycount'] = $entrycount['count'];

		$postcount = $db->query_first("
			SELECT COUNT(*) AS count
			FROM " . ADV_DYNA_TABLE_PREFIX . "posts AS post
			LEFT JOIN " . ADV_DYNA_TABLE_PREFIX . "entries AS entry ON (post.entryid = entry.entryid)
			WHERE $wherequery
				AND entry.userid = $user[userid]
		");
		$ucat['postcount'] = $postcount['count'];

		// Last entry
		$lastentry = $db->query_first("
			SELECT entryid AS lastentryid, title AS lastentrytitle, dateline AS lastentrydateline, userid AS lastentryuserid, username AS lastentryusername
			FROM " . ADV_DYNA_TABLE_PREFIX . "entries
			WHERE $wherequery
				AND userid = $user[userid]
			ORDER BY dateline DESC
		");

		if (!empty($lastentry))
		{
			$ucat = array_merge($ucat, $lastentry);
		}

		// Last post
		$lastpost = $db->query_first("
			SELECT postid AS lastpostid, entry.title AS lastpostentrytitle, post.entryid AS lastpostentryid, post.dateline AS lastpostdateline, post.userid AS lastpostuserid, post.username AS lastpostusername
			FROM " . ADV_DYNA_TABLE_PREFIX . "posts AS post
			LEFT JOIN " . ADV_DYNA_TABLE_PREFIX . "entries AS entry ON (post.entryid = entry.entryid)
			WHERE $wherequery
				AND entry.userid = $user[userid]
			ORDER BY post.dateline DESC
		");

		if (!empty($lastpost))
		{
			$ucat = array_merge($ucat, $lastpost);
		}
	}

	// Delte them and we'll re-insert below
	if ($pagedata['pagenumber'] == 1)
	{
		$db->query_write("DELETE FROM " . ADV_DYNA_TABLE_PREFIX . "memberscats WHERE catid = $catid");

		// Check for child cats where there are no entries in the parent cat
		$mcchildren = array();
		$catusers = array();
		if ($vbulletin->adv_dyna_cats[$catid]['memberscat'])
		{
			$mcchildren = fetch_category_children($catid);

			foreach ($mcchildren AS $childid)
			{
				if ($vbulletin->adv_dyna_cats[$childid]['catuserid'])
				{
					$catusers[] = $vbulletin->adv_dyna_cats[$childid]['catuserid'];
				}
			}
		}

		$catusers = array_unique(array_diff($catusers, $duserids));

		if (!empty($catusers))
		{
			$catinsert = 'INSERT INTO ' . ADV_DYNA_TABLE_PREFIX . 'memberscats (catid, userid) VALUES ';

			foreach ($catusers AS $mcuserid)
			{
				$catinsert .= '(' . $catid . ', ' . $mcuserid . '), ';
			}
			$db->query_write(substr($catinsert, 0, (strlen($catinsert) - 2)));
		}
	}

	if (!empty($usercat))
	{
		$insertcount = 0;
		// Loop once for one big insert to make sure all members cats already exist
		foreach ($usercat AS $catuserid => $catinfo)
		{
			$insertcount++;

			if ($insertcount == 1)
			{
				$insertquery = '
					INSERT INTO ' . ADV_DYNA_TABLE_PREFIX . 'memberscats
						(catid, userid, entrycount, postcount, lastentryid, lastentrytitle, lastentrydateline, lastentryuserid, lastentryusername, lastpostid, lastpostentrytitle, lastpostentryid, lastpostdateline, lastpostuserid, lastpostusername)
					VALUES
				';
			}

			$insertquery .= "(
				$catid,
				$catuserid,
				'$catinfo[entrycount]',
				'$catinfo[postcount]',
				'$catinfo[lastentryid]',
				'" . $db->escape_string($catinfo['lastentrytitle']) . "',
				'$catinfo[lastentrydateline]',
				'$catinfo[lastentryuserid]',
				'" . $db->escape_string($catinfo['lastentryusername']) . "',
				'$catinfo[lastpostid]',
				'" . $db->escape_string($catinfo['lastpostentrytitle']) . "',
				'$catinfo[lastpostentryid]',
				'$catinfo[lastpostdateline]',
				'$catinfo[lastpostuserid]',
				'" . $db->escape_string($catinfo['lastpostusername']) . "'
			), ";

			// Make sure we're not inserting more than 500 at one time
			if ($insertcount == 500)
			{
				$insertcount = 0;
				$db->query_write(substr($insertquery, 0, (strlen($insertquery) - 2)));
			}
		}

		if ($insertcount)
		{
			$db->query_write(substr($insertquery, 0, (strlen($insertquery) - 2)));
		}
	}

	$nextpage = $pagedata['pagenumber'] + 1;

	if ($pagedata['pagenumber'] >= $pagedata['pagecount'])
	{
		if (isset($catkeys[($catkey + 1)]))
		{
			$catkey = $catkey + 1;
			$nextpage = 1;
		}
		else
		{
			define('CP_BACKURL', 'vba_dyna_admin_maintenance.php?' . $vbulletin->session->vars['sessionurl'] . 'do=main' . ADV_URL_PREFIX_HR);
			print_stop_message(ADV_DYNA_PREFIX . '_x_updated_successfully', $vbphrase['categories']);
		}
	}

	print_cp_redirect('vba_dyna_admin_maintenance.php?' . $vbulletin->session->vars['sessionurl'] . 'do=memberscounts&page=' . $nextpage . '&perpage=' . $perpage . '&catkey=' . $catkey . ADV_URL_PREFIX_HR, 0);

}

// #################### Update Counters #################
if ($_REQUEST['do'] == 'updatecounters')
{
	$entrycount = intval($_REQUEST['entrycount']);
	$postcount = intval($_REQUEST['postcount']);
	$lastentries = intval($_REQUEST['lastentries']);
	$lastposts = intval($_REQUEST['lastposts']);

	if (!$entrycount AND !$postcount AND !$lastentries AND !$lastposts)
	{
		print_stop_message(ADV_DYNA_PREFIX . '_must_choose_update');
	}

	require_once(DIR . '/includes/vba_dyna_functions_savecat.php');

	update_count(0, $entrycount, $postcount, $lastentries, $lastposts);

	print_stop_message(ADV_DYNA_PREFIX . '_x_updated_successfully', $vbphrase['categories']);
}

// ###################### Update Last Post #############################
if ($_REQUEST['do'] == 'updatelastpost')
{
	// Limit to only entries with posts
	$idlimit = array();
	$entryids = $db->query_read("SELECT DISTINCT entryid FROM " . ADV_DYNA_TABLE_PREFIX . "posts");
	while ($ids = $db->fetch_array($entryids))
	{
		$idlimit[] = $ids['entryid'];
	}

	$db->query_write("
		UPDATE " . ADV_DYNA_TABLE_PREFIX . "entries SET
			lastpostid = 0,
			lastpostdateline = 0,
			lastpostuserid = 0,
			lastpostusername = '',
			posts = 0
		" . iif(!empty($idlimit), "WHERE entryid NOT IN(" . implode(', ', $idlimit) . ")")
	);

	if (!empty($idlimit))
	{
		$entries = $db->query_read("
			SELECT entryid, lastpostid, lastpostdateline, lastpostuserid, lastpostusername, posts
			FROM " . ADV_DYNA_TABLE_PREFIX . "entries
			WHERE entryid IN(" . implode(',', $idlimit) . ")
		");
		while ($entry = $db->fetch_array($entries))
		{
			$posts = $db->query_first("
				SELECT postid, userid, dateline, username
				FROM " . ADV_DYNA_TABLE_PREFIX . "posts
				WHERE entryid = $entry[entryid]
					AND visible = 1
				ORDER BY dateline DESC
			");

			$pcount = $db->query_first("SELECT COUNT(*) AS count FROM " . ADV_DYNA_TABLE_PREFIX . "posts WHERE entryid = $entry[entryid] AND visible = 1");

			if (($entry['lastpostdateline'] != $posts['dateline'] AND $posts['dateline'])
				OR $entry['lastpostid'] != $posts['postid']
				OR $entry['posts'] != $pcount['count']
				OR $entry['lastpostusername'] != $posts['username']
			)
			{
				$db->query_write("
					UPDATE " . ADV_DYNA_TABLE_PREFIX . "entries SET
						posts = '$pcount[count]',
						lastpostid = '$posts[postid]',
						lastpostdateline = '$posts[dateline]',
						lastpostuserid = '$posts[userid]',
						lastpostusername = '" . $db->escape_string($posts['username']) . "'
					WHERE entryid = $entry[entryid]
				");
			}
			unset($posts);
		}
	}

	print_stop_message(ADV_DYNA_PREFIX . '_x_updated_successfully', $vbphrase['categories']);
}

// ##### Rebuild Attachment Thumbnails ########################################
if ($_REQUEST['do'] == 'rebuildattachthumbs')
{
	$perpage = $vbulletin->input->clean_gpc('r', 'perpage', TYPE_INT);

	$pagedata = fetch_page_data(ADV_DYNA_PREFIX . '_attachments', array(), array(), $perpage);

	// ##### All done or redirect
	if ($pagedata['pagenumber'] > $pagedata['pagecount'])
	{
		define('CP_BACKURL', 'vba_dyna_admin_maintenance.php?' . $vbulletin->session->vars['sessionurl'] . 'do=main' . ADV_URL_PREFIX_HR);
		print_stop_message(ADV_DYNA_PREFIX . '_updated_x_successfully', $vbphrase['attachments']);
	}

	// Load the $vba_image class
	require_once(DIR . '/includes/vba_dyna_class_image.php');

	$vba_image =& new vba_dyna_image();
	$vba_image->_vb =& $vbulletin;

	$vba_image->load_extensions();

	$attachupdate = array();
	$getattach = $db->query_read("
		SELECT *
		FROM " . ADV_DYNA_TABLE_PREFIX . "attachments
		ORDER BY attachmentid
		LIMIT " . ($pagedata['minlimit'] - 1) . ", $pagedata[perpage]
	");
	while ($attach = $db->fetch_array($getattach))
	{
		echo '<div>' . construct_phrase($vbphrase['processing_x_y'], $vbphrase['attachment'], $attach['attachmentid'] . ' (' . $attach['filename'] . ')') . '</div>';
		vbflush();

		$folderpath = $vba_options['dyna_attachpath'] . '/' . $vba_image->fetch_upload_folders($attach['userid']) . '/';
		$thumblocation = $folderpath . $attach['filename'] . '_' . $attach['dateline'] . '_thumb.' . $attach['extension'];

		$attach['location'] = $folderpath . $attach['filename'] . '_' . $attach['dateline'] . '.' . $attach['extension'];

		if (!$vba_image->_extcache[$attach['extension']]['thumbnail'])
		{
			if (@is_file($thumblocation))
			{
				unlink($thumblocation);
			}
		}
		else
		{
			$vba_image->_info =& $attach;

			$imagesize = @getimagesize($attach['location']);
			$attach['width'] = $imagesize[0];
			$attach['height'] = $imagesize[1];
			$attach['type'] = $imagesize[2];

			$vba_image->resize('thumb', $attach['attachmentid'], $thumblocation);

			$attachupdate[$attach['hasthumb']][] = $attach['attachmentid'];
		}
	}

	// Update the hasattach field
	if (!empty($attachupdate['0']))
	{
		$db->query_write("
			UPDATE " . ADV_DYNA_TABLE_PREFIX . "attachments SET
				hasthumb = 0
			WHERE attachmentid IN(" . implode(', ', $attachupdate['0']) . ")
		");
	}

	if (!empty($attachupdate['1']))
	{
		$db->query_write("
			UPDATE " . ADV_DYNA_TABLE_PREFIX . "attachments SET
				hasthumb = 1
			WHERE attachmentid IN(" . implode(', ', $attachupdate['1']) . ")
		");
	}

	print_cp_redirect('vba_dyna_admin_maintenance.php?' . $vbulletin->session->vars['sessionurl'] . 'do=rebuildattachthumbs&page=' . ($pagedata['pagenumber'] + 1) . '&perpage=' . $perpage . ADV_URL_PREFIX_HR, 0);
}

// ##### Rebuild Attachment Counts ############################################
if ($_POST['do'] == 'rebuildattachcount')
{
	$perpage = $vbulletin->input->clean_gpc('r', 'perpage', TYPE_INT);

	$pagedata = fetch_page_data(ADV_DYNA_PREFIX . '_entries', array(), array(), $perpage);

	$entryinfo = array();
	$getentries = $db->query_read("
		SELECT entryid, hasattach
		FROM " . ADV_DYNA_TABLE_PREFIX . "entries AS entry
		ORDER BY entryid
		LIMIT " . ($pagedata['minlimit'] - 1) . ", $pagedata[perpage]
	");
	while ($entry = $db->fetch_array($getentries))
	{
		$entryinfo[$entry['entryid']] = $entry['hasattach'];
	}

	if (!empty($entryinfo))
	{
		$entryids = array_keys($entryinfo);

		$attachinfo = array();
		$getattach = $db->query_read("
			SELECT entryid FROM " . ADV_DYNA_TABLE_PREFIX . "attachments
			WHERE entryid IN(" . implode(', ', $entryids) . ")
		");
		while ($attach = $db->fetch_array($getattach))
		{
			$attachinfo[$attach['entryid']]++;
		}

		foreach ($entryinfo AS $entryid => $hasattach)
		{
			$newattach = intval($attachinfo[$entryid]);
			if ($hasattach != $newattach)
			{
				$db->query_write("
					UPDATE " . ADV_DYNA_TABLE_PREFIX . "entries SET
						hasattach = $newattach
					WHERE entryid = $entryid
				");
			}
		}
	}

	// All done or redirect
	if ($pagedata['pagenumber'] >= $pagedata['pagecount'])
	{
		define('CP_BACKURL', 'vba_dyna_admin_maintenance.php?' . $vbulletin->session->vars['sessionurl'] . 'do=main' . ADV_URL_PREFIX_HR);
		print_stop_message(ADV_DYNA_PREFIX . '_updated_x_successfully', $vbphrase['attachments']);
	}
	else
	{
		print_cp_redirect('vba_dyna_admin_maintenance.php?' . $vbulletin->session->vars['sessionurl'] . 'do=rebuildentrycache&page=' . ($pagedata['pagenumber'] + 1) . '&perpage=' . $perpage . ADV_URL_PREFIX_HR, 0);
	}

}

// ##### Rebuild First Attachment #############################################
if ($_REQUEST['do'] == 'rebuildfirstattach')
{
	$entryids = array();
	$getids = $db->query_read("
		SELECT DISTINCT entryid
		FROM " . ADV_DYNA_TABLE_PREFIX . "attachments
		" . iif($vba_options['dyna_entrybit_showattach'] == 2, 'WHERE hasthumb = 1')
	);
	while ($ids = $db->fetch_array($getids))
	{
		$entryids[] = $ids['entryid'];
	}

	// ##### need to add a real option for this
	if ($_REQUEST['hasattach'])
	{
		foreach ($entryids AS $entryid)
		{
			$attach = $db->query_first("SELECT COUNT(*) AS count FROM " . ADV_DYNA_TABLE_PREFIX . "attachments WHERE entryid = $entryid");
			$db->query_write("UPDATE " . ADV_DYNA_TABLE_PREFIX . "entries SET hasattach = $attach[count] WHERE entryid = $entryid");
		}

		$db->query_write("UPDATE " . ADV_DYNA_TABLE_PREFIX . "entries SET hasattach = 0 WHERE entryid NOT IN(" . implode(',', $entryids) . ")");
	}


	$currentids = array();
	$getentries = $db->query_read("
		SELECT entries.entryid, attachid, hasthumb
		FROM " . ADV_DYNA_TABLE_PREFIX . "entries AS entries
		LEFT JOIN " . ADV_DYNA_TABLE_PREFIX . "attachments AS attachments ON (entries.attachid = attachments.attachmentid)
		WHERE attachid != 0
	");
	while ($entry = $db->fetch_array($getentries))
	{
		if ($vba_options['dyna_entrybit_showattach'] == 2 AND !$entry['hasthumb'])
		{
			continue;
		}
		$currentids[] = $entry['entryid'];
	}

	$entryids = array_diff($entryids, $currentids);

	$attachupdate = array();
	if (!empty($entryids))
	{
		$getattach = $db->query_read("
			SELECT attachmentid, entryid
			FROM " . ADV_DYNA_TABLE_PREFIX . "attachments
			WHERE entryid IN(" . implode(',', $entryids) . ")
				" . iif($vba_options['dyna_entrybit_showattach'] == 2, 'AND hasthumb = 1') . "
			GROUP BY entryid
			ORDER BY dateline ASC
		");
		while ($attach = $db->fetch_array($getattach))
		{
			$attachupdate[$attach['entryid']] = $attach['attachmentid'];
		}

		if (!empty($attachupdate))
		{
			foreach ($attachupdate AS $entryid => $attachid)
			{
				$db->query_write("UPDATE " . ADV_DYNA_TABLE_PREFIX . "entries SET attachid = $attachid WHERE entryid = $entryid");
			}
		}
	}

	$updatedids = array_merge($currentids, array_keys($attachupdate));

	// Set the rest to 0
	$db->query_write("
		UPDATE " . ADV_DYNA_TABLE_PREFIX . "entries SET
			attachid = 0
		" . iif(!empty($updatedids), "WHERE entryid NOT IN(" . implode(',', $updatedids) . ")")
	);

	print_stop_message(ADV_DYNA_PREFIX . '_x_updated_successfully', $vbphrase['attachments']);
}

// ##### Cancel User Subscriptions ############################################
if ($_POST['do'] == 'cancelsubscribe')
{
	$vbulletin->input->clean_gpc('p', 'username', TYPE_NOHTML);

	$user = $db->query_first("
		SELECT userid, username
		FROM " . TABLE_PREFIX . "user
		WHERE username = '" . $db->escape_string($vbulletin->GPC['username']) . "'
	");

	if (!$user['userid'])
	{
		print_stop_message('noid', $vbphrase['user']);
	}

	print_dyna_form_header('vba_dyna_admin_maintenance', 'docancelsubscribe');
	print_table_header($vbphrase['cancel_subscriptions'] . ' - ' . $user['username'], 4);
	construct_hidden_code('userid', $user['userid']);
	print_table_break();

	// Subscribed Entries
	print_table_header($vbphrase['entries'], 4);

	$getentries = $db->query_read("
		SELECT entry.*
		FROM " . ADV_DYNA_TABLE_PREFIX . "subscribeentry AS subentry
		LEFT JOIN " . ADV_DYNA_TABLE_PREFIX . "entries AS entry ON (subentry.entryid = entry.entryid)
		WHERE subentry.userid = $user[userid]
	");
	if ($db->num_rows($getentries))
	{
		print_cells_row(array($vbphrase['delete'], $vbphrase['title'], $vbphrase['username'], $vbphrase['category']), true, false, -4);

		while ($entry = $db->fetch_array($getentries))
		{
			fetch_entry_url($entry);

			echo '<tr class="' . exec_switch_bg() . '">
				<td width="2%"><input type="checkbox" name="deleteentries[]" value="' . $entry['entryid'] . '" checked="checked" /></td>
				<td width="70%">' . construct_link_code(
					$entry['title'],
					$vba_options['dyna_homeurl'] . '/' . $entry['url'],
					true
				)  . '</td>
				<td style="white-space: nowrap">' .
				construct_link_code(
					$entry['username'],
					$vbulletin->options['bburl'] . '/member.php?' . $vbulletin->session->vars['sessionurl'] . 'u=' . $entry['userid'],
					true
				) . '</td>
				<td style="white-space: nowrap"> ' .
				construct_link_code(
					$vbulletin->adv_dyna_cats[$entry['catid']]['title'],
					$vba_options['dyna_homeurl'] . '/' . $entry['caturl'],
					true
				) . '</td>
			</tr>';
		}
	}
	else
	{
		print_description_row(construct_phrase($vbphrase['no_x_to_display'], $vbphrase['entries']), false, 4);
	}

	print_table_break();

	// Subscribed Categories
	print_table_header($vbphrase['categories']);

	$getcats = $db->query_read("
		SELECT cats.*
		FROM " . ADV_DYNA_TABLE_PREFIX . "subscribecat AS subcat
		LEFT JOIN " . ADV_DYNA_TABLE_PREFIX . "categories AS cats ON (subcat.catid = cats.catid)
		WHERE subcat.userid = $user[userid]
	");
	if ($db->num_rows($getcats))
	{
		print_cells_row(array($vbphrase['delete'], $vbphrase['title']), true, false, -1);

		while ($cats = $db->fetch_array($getcats))
		{
			echo '<tr class="' . exec_switch_bg() . '">
				<td width="2%"><input type="checkbox" name="deletecats[]" value="' . $cats['catid'] . '" checked="checked" /></td>
				<td width="70%">' . construct_link_code(
					$cats['title'],
					$vba_options['dyna_homeurl'] . '/' . $cats['url'],
					true
				)  . '</td>
			</tr>';
		}
	}
	else
	{
		print_description_row(construct_phrase($vbphrase['no_x_to_display'], $vbphrase['categories']));
	}

	print_table_break();

	print_submit_row($vbphrase['delete'], '');
}

// ##### Do Cancel Subscriptions ##############################################
if ($_POST['do'] == 'docancelsubscribe')
{
	$vbulletin->input->clean_array_gpc('p', array(
		'userid' => TYPE_INT,
		'deletecats' => TYPE_ARRAY_INT,
		'deleteentries' => TYPE_ARRAY_INT
	));

	if (!$vbulletin->GPC['userid'])
	{
		print_stop_message('noid', $vbphrase['user']);
	}

	// Delete subscribed entries
	if (!empty($vbulletin->GPC['deleteentries']))
	{
		$db->query_write("
			DELETE FROM " . ADV_DYNA_TABLE_PREFIX . "subscribeentry
			WHERE entryid IN(" . implode(',', $vbulletin->GPC['deleteentries']) . ")
				AND userid = " . $vbulletin->GPC['userid']
		);
	}

	// Delete subscribed entries
	if (!empty($vbulletin->GPC['deletecats']))
	{
		$db->query_write("
			DELETE FROM " . ADV_DYNA_TABLE_PREFIX . "subscribecat
			WHERE catid IN(" . implode(',', $vbulletin->GPC['deletecats']) . ")
				AND userid = " . $vbulletin->GPC['userid']
		);
	}

	define('CP_BACKURL', 'vba_dyna_admin_maintenance.php?' . $vbulletin->session->vars['sessionurl'] . 'do=main' . ADV_URL_PREFIX_HR);
	print_stop_message('deleted_subscriptions_successfully');
}

print_cp_footer();

?>