<?php
// ++=========================================================================++
// || vBadvanced Dynamics v1.0.0 (vB 3.6 - vB 3.7)
// ||  2003-2007 vBadvanced.com - All Rights Reserved
// || This file may not be redistributed in whole or significant part.
// || http://vbadvanced.com
// ++ ========================================================================++

error_reporting(E_ALL & ~E_NOTICE);

$specialtemplates = array(
	'adv_dyna_cats',
	'adv_dyna_cfield',
	'adv_dyna_modpos',
	'adv_dyna_module',
	'bbcodecache'
);

$phrasegroups = array(
	'adv_dyna_cp_modules',
	'adv_dyna_modules'
);

if (in_array($_REQUEST['do'], array('editmodule', 'addmodule', 'copymodule', 'editusermodule')))
{
	$phrasegroups[] = 'posting';
}

// ##### Preview BB Code Module Ajax ##########################################
if ($_REQUEST['do'] == 'preview')
{
	chdir('../');

	$specialtemplates = array(
		'adv_dyna_attach',
		'adv_dyna_cats',
		'adv_dyna_cfield',
		'adv_dyna_featur',
		'adv_dyna_module',
		'adv_dyna_opts',
		'adv_dyna_perms',
		'adv_dyna_rand'
	);

	$globaltemplates = array();

	$phrasegroups = array(
		'adv_dyna',
		'adv_dyna_browsecat',
		'adv_dyna_moderate',
		'cprofilefield',
		'forumdisplay',
		'postbit'
	);

	require_once('./includes/vba_dyna_include_prefix.php');
	require_once('./global.php');

	$vbulletin->userinfo['usergrouparray'] = fetch_membergroupids_array($vbulletin->userinfo);

	require_once(DIR . '/includes/vba_dyna_functions.php');

	define('ADV_DYNA_TABLE_PREFIX', TABLE_PREFIX . ADV_DYNA_PREFIX . '_');

	convert_prefixed_datastore();

	$vba_options =& $vbulletin->adv_dyna_opts;

	// ##### Load the $vba_dyna class
	require_once(DIR . '/includes/vba_dyna_class.php');
	$vba_dyna =& new vba_dyna();
	$vba_dyna->vbulletin =& $vbulletin;

	fetch_option_phrases();

	// ##### Entries Permissions
	$vba_dyna->default_permissions();

	$vbulletin->input->clean_array_gpc('r', array(
		'setting' => TYPE_ARRAY,
		'altshell' => TYPE_STR,
		'customtitle' => TYPE_STR,
		'filename' => TYPE_STR,
		'identifier' => TYPE_STR,
		'message' => TYPE_STR,
		'template' => TYPE_STR,
		'templatesused' => TYPE_STR,
		'title' => TYPE_STR,
		'type' => TYPE_STR,
		'html' => TYPE_INT,
		'imgcode' => TYPE_INT,
		'load_bbcode' => TYPE_INT,
		'modid' => TYPE_INT,
		'smilies' => TYPE_INT,
		'useshell' => TYPE_INT
	));

	$modid = $vbulletin->GPC['modid'];

	require_once(DIR . '/includes/class_xml.php');

	// Head include replacements
	$headinclude = str_replace(
		array(
			'"clientscript',
			'url(images/'
		),
		array(
			'"' . $vbulletin->options['bburl'] . '/clientscript',
			'url(' . $vbulletin->options['bburl'] . '/images/'
		),
		$headinclude
	);

	$module_preview = $stylevar['htmldoctype'] . '<html dir="' . $stylevar['textdirection'] . '" lang="' . $stylevar['languagecode'] . '">
	<head>
		<base href="' . $vba_options['dyna_homeurl'] . '/" />
		' . $headinclude . '
		<title>' . $vbphrase['preview'] . '</title>
	</head>
	<body><div class="page" style="padding: ' . $stylevar['spacersize'] . 'px">';

	// Set $bgclass
	exec_switch_bg();

	$mods['modid'] = $modid;
	$mods['title'] = $vbulletin->GPC['title'];
	$mods['colspan'] = $vbulletin->GPC['colspan'];

	if ($vbulletin->GPC['load_bbcode'] OR $vbulletin->GPC['type'] == 'bb_code')
	{
		// Kill the wordwrap setting to avoid problems with HTML links/images
		$vbulletin->options['wordwrap'] = 0;

		// Load BBcode parser
		require_once(DIR . '/includes/class_bbcode.php');
		$bbcode_parser =& new vB_BbCodeParser($vbulletin, fetch_tag_list());
		$vbulletin->vba_bbcode_parser =& $bbcode_parser;
	}

	// Fetch templates
	if ($vbulletin->GPC['type'] == 'php_file' OR ($vbulletin->GPC['type'] == 'template' AND !$vbulletin->GPC['template']))
	{
		$gettemplates = '';

		if ($vbulletin->GPC['type'] == 'template')
		{
			$gettemplates = "'" . $vbulletin->GPC['filename'] . "'";
		}
		else
		{
			$tempsused = explode("\n", $vbulletin->GPC['templatesused']);

			if (!empty($tempsused))
			{
				$gettemplates = "'" . implode("', '", $tempsused) . "'";
			}
		}

		if ($gettemplates)
		{
			$gettemp = $vbulletin->db->query_read("
				SELECT title, template
				FROM " . TABLE_PREFIX . "template
				WHERE title IN($gettemplates)
					AND styleid IN(" . $vbulletin->userinfo['styleid'] . ", -1)
				ORDER BY styleid ASC
			");
			while ($temp = $vbulletin->db->fetch_array($gettemp))
			{
				$vbulletin->templatecache[$temp['title']] = $temp['template'];
			}
		}
	}

	switch ($vbulletin->GPC['type'])
	{
		// ##### Template Module
		case 'template':

			// Template content
			if ($vbulletin->GPC['template'])
			{
				require_once(DIR . '/includes/adminfunctions_template.php');

				$vbulletin->GPC['template'] = compile_template($vbulletin->GPC['template']);
				$templateerrors = check_template_errors($vbulletin->GPC['template']);

				if ($templateerrors)
				{
					$modulehtml = '<em>' . $templateerrors . '</em>';
					$show['tablerow'] = true;
				}
				else
				{
					eval('$modulehtml = "' . $vbulletin->GPC['template'] . '";');
				}
			}
			// Grab the template
			else
			{
				eval('$modulehtml = "' . fetch_template($vbulletin->GPC['filename']) . '";');
			}

		break;

		// ##### PHP File
		case 'php_file':

			// Get the settings
			$mod_options =& $vbulletin->adv_dyna_module[$modid]['settings'];

			require_once(DIR . '/includes/functions_bigthree.php');

			$adv_forumperms = array();
			$adv_canviewforums = array();
			$forumperms_query = '';

			// Current setting values
			if (!empty($vbulletin->GPC['setting']))
			{
				foreach ($vbulletin->GPC['setting'] AS $setting_var => $setting_val)
				{
					$mod_options[$setting_var] = $setting_val;
				}
			}

			if ($mods['options'] & $vba_php_modint['clean_output'])
			{
				ob_start();
				require(DIR . '/modules/' . $vbulletin->GPC['filename']);
				$home[$modid]['content'] = ob_get_contents();
				ob_end_clean();
			}
			else
			{
				require(DIR . '/vba_dyna_modules/' . $vbulletin->GPC['filename']);
			}

			$modulehtml = $home[$modid]['content'];

		break;

		// ##### BB Code Module
		case 'bb_code':

			if (!$vbulletin->GPC['wysiwyg'])
			{
				require_once(DIR . '/includes/functions_wysiwyg.php');
				$vbulletin->GPC['message'] = convert_wysiwyg_html_to_bbcode($vbulletin->GPC['message'], $vbulletin->GPC['html']);
			}

			$modulehtml = $bbcode_parser->do_parse(
				$vbulletin->GPC['message'],
				$vbulletin->GPC['html'],
				$vbulletin->GPC['smilies'],
				1,
				1
			);

			$show['tablerow'] = true;

		break;
	}

	if ($vbulletin->GPC['useshell'] AND !$mods['noshell'])
	{
		eval('$module_preview .= "' . fetch_template(($vbulletin->GPC['altshell'] ? $vbulletin->GPC['altshell'] : ADV_DYNA_PREFIX . '_module_wrapper')) . '";');
	}
	else
	{
		$module_preview .= $modulehtml;
	}

	$module_preview .= '</div></body></html>';

	$xml = new vB_AJAX_XML_Builder($vbulletin, 'text/xml');
	$xml->add_group('data');

	$xml->add_tag(
		'module_preview',
		$module_preview,
		array(),
		true
	);

	$xml->close_group();
	$xml->print_xml();

	exit;
}

require_once('./vba_dyna_admin_global.php');

if (!$_REQUEST['do'])
{
	$_REQUEST['do'] = 'listmodules';
}

// ##### Display a notice if on a module page and modules are not enabled
if (!$vbulletin->adv_dyna_opts['dyna_enablemodules'])
{
	print_dyna_form_header('', '');
	print_table_break();
	print_description_row($vbphrase['warning_modules_disabled']);
	print_table_break();
	print_table_footer();
}

($hook = vBulletinHook::fetch_hook('vba_dyna_cp_modules_start')) ? eval($hook) : false;



// ##### Download Module ######################################################
if ($_REQUEST['do'] == 'downloadmodule')
{
	$module = $db->query_first("
		SELECT title, description, inctype, filename, identifier, parent, useshell, colspan, useredit, formcode, templatelist, link, options
		FROM " . ADV_DYNA_TABLE_PREFIX . "modules
		WHERE modid = " . intval($_REQUEST['modid'])
	);
	if (empty($module))
	{
		print_stop_message('invalid_x_specified', $vbphrase['module']);
	}

	$moduleinfo = array(
		'module' => $module,
		'templates' => array()
	);

	// ##### Templates
	if (($module['inctype'] == 'php_file' OR $module['inctype'] == 'template') AND ($module['filename'] OR $module['templatelist']))
	{
		$tnames = ($module['templatelist']) ? explode("\r\n", $module['templatelist']) : array(ADV_DYNA_PREFIX . '_' . $module['filename']);

		if (!empty($tnames))
		{
			$prefixlen = '';
			if (ADV_DYNA_PREFIX != 'adv_dyna')
			{
				$prefixlen = strlen(ADV_DYNA_PREFIX);
			}

			$templates = $db->query_read("
				SELECT title, template_un
				FROM " . TABLE_PREFIX . "template
				WHERE title IN('" . implode("', '", $tnames) . "')
			");
			while ($temp = $db->fetch_array($templates))
			{
				if ($prefixlen)
				{
					if (substr($temp['title'], 0, $prefixlen) == ADV_DYNA_PREFIX)
					{
						$temp['title'] = 'adv_dyna' . substr($temp['title'], $prefixlen);
					}
				}
				$moduleinfo['templates'][$temp['title']] = stripslashes($temp['template_un']);
			}
		}
	}

	// ##### PHP File
	if ($module['inctype'] == 'php_file')
	{
		// Get module file
		if ($fp = @fopen('./vba_dyna_modules/' . $module['filename'], 'r'))
		{
			$moduleinfo['file'] = fread($fp, filesize('./vba_dyna_modules/' . $module['filename']));
			fclose($fp);
		}

		// Edit module file
		if ($module['useredit'])
		{
			if ($fp = @fopen('./vba_dyna_modules/edit_' . $module['filename'], 'r'))
			{
				$moduleinfo['file_edit'] = fread($fp, filesize('./vba_dyna_modules/edit_' . $module['filename']));
				fclose($fp);
			}
		}

		// Settings
		$settingphrase = fetch_settings_phrases();

		$modsettings = $db->query_read("SELECT * FROM " . TABLE_PREFIX . "adv_setting WHERE grouptitle = '" . ADV_DYNA_PREFIX . "_modules_$module[identifier]'");
		while ($setting = $db->fetch_array($modsettings))
		{
			$setting['title'] = $settingphrase['setting_' . $setting['varname'] . '_title'];
			$setting['description'] = $settingphrase['setting_' . $setting['varname'] . '_desc'];
			$moduleinfo['settings'][$setting['varname']] = $setting;
		}
	}

	$moduleinfo = serialize($moduleinfo);

	$filename = strtolower(preg_replace("/[^a-z_0-9]/i", '' , $module['title']));

	header('Content-Type: application/octetstream');
	header('Expires: ' . gmdate('D, d M Y H:i:s') . ' GMT');
	header('Content-Disposition: attachment; filename="' . $filename . '.module"');
	header('Content-Length: ' . strlen($moduleinfo));
	header('Cache-Control: must-revalidate, post-check=0, pre-check=0');
	header('Pragma: public');

	echo $moduleinfo;
	exit;
}

// ##### Grab the module info
if ($_REQUEST['do'] == 'editmodule' OR $_REQUEST['do'] == 'copymodule')
{
	$module = $db->query_first("SELECT * FROM " . ADV_DYNA_TABLE_PREFIX . "modules WHERE modid = " . intval($_REQUEST['modid']));

	if (!isset($type) AND !isset($_REQUEST['chtype']))
	{
		$type = $module['inctype'];
	}
}


// ##### Edit Layout ##########################################################
if ($_REQUEST['do'] == 'layout')
{
	$page = $vbulletin->input->clean_gpc('r', 'page', TYPE_NOHTML);
	$userid = $vbulletin->input->clean_gpc('r', 'userid', TYPE_NOHTML);

	require_once(DIR . '/includes/vba_dyna_functions_modules.php');

	if (!in_array($page, $vba_dyna->_dyna_pages))
	{
		print_stop_message('invalid_page_specified', $vbphrase['module']);
	}

	$pagetitle = get_page_phrase($page);

	if ($userid)
	{
		$userinfo = $db->query_first("
			SELECT user.userid, username, layout
			FROM " . TABLE_PREFIX . "user AS user
			LEFT JOIN " . ADV_DYNA_TABLE_PREFIX . "layout AS userlayout ON (user.userid = userlayout.userid AND userlayout.page = '" . $db->escape_string($page) . "')
			WHERE user.userid = $userid
		");

		$pagelayout = unserialize($userinfo['layout']);

		if (!$userinfo['userid'])
		{
			print_stop_message('invalid_x_specified', $vbphrase['user']);
		}
	}

	if (empty($userinfo['layout']))
	{
		$pagelayout =& $vbulletin->adv_dyna_modpos[$page];
	}

	print_dyna_form_header('vba_dyna_admin_modules', 'savelayout');
	construct_hidden_code('page', $page);
	construct_hidden_code('userid', $userid);
	print_table_header(construct_phrase(
			$vbphrase['inactive_x'],
			$vbphrase['modules'] . ': ' . $pagetitle . iif($userid, ' - ' . $userinfo['username'])
		), 3);
	print_cells_row(array($vbphrase['title'], $vbphrase['add_to_column'], $vbphrase['display_order']), true);

	// Find the active modids
	$activemodids = array();
	if (!empty($pagelayout))
	{
		foreach ($pagelayout AS $column => $mods)
		{
			$activemodids = array_merge($activemodids, array_keys($mods));
		}
	}

	// Print the inactive, and get the info for the active
	$activemods = array();
	$getmodules = $db->query_read("SELECT modid, title, active FROM " . ADV_DYNA_TABLE_PREFIX . "modules ORDER BY title");
	while ($module = $db->fetch_array($getmodules))
	{
		if (!$module['active'])
		{
			$module['title'] = '<i>' . $module['title'] . ' (' . $vbphrase['inactive'] . ')</i>';
		}

		if (in_array($module['modid'], $activemodids))
		{
			$activemods[$module['modid']] = $module;
		}
		else
		{
			$inactivemods = true;
			print_cells_row(array(
				$module['title'],
				'<select class="bginput" name="mods[' . $module['modid'] . '][column]" tabindex="1">
					<option value="0">' . $vbphrase['none'] . '</option>
					<option value="1">' . $vbphrase['left_column'] . '</option>
					<option value="2">' . $vbphrase['center_above_column'] . '</option>
					<option value="3">' . $vbphrase['center_below_column'] . '</option>
					<option value="4">' . $vbphrase['right_column'] . '</option>
				</select>',
				'<input class="bginput" type="text" name="mods[' . $module['modid'] . '][displayorder]" size="2" tabindex="1" />'
			));
		}
	}

	if (!$inactivemods)
	{
		print_description_row(construct_phrase($vbphrase['no_inactive_x'], $vbphrase['modules_lwr']), false, 3);
	}

	$submitrow = '<input type="submit" class="button" tabindex="1" value="  ' . $vbphrase['save'] . '  " accesskey="s" /> <input type="reset" class="button" tabindex="1" value="  ' . $vbphrase['reset'] . '  " accesskey="r" />';

	print_table_footer(3, $submitrow, '', false);

	print_table_break();

	// Print the active modules
	print_table_header(construct_phrase(
		$vbphrase['active_x'],
		$vbphrase['modules'] . ': ' . $pagetitle . iif($userid, ' - ' . $userinfo['username'])
		), 3);

	// Make sure each row is set
	foreach ($vba_dyna->_colnames AS $colname => $colkey)
	{
		if (!isset($pagelayout[$colname]))
		{
			$pagelayout[$colname] = array();
		}
	}

	$hasmods = array();

	echo '<tr>';
	foreach ($pagelayout AS $column => $colmods)
	{
		if ($column != 3)
		{
			echo '<td width="33%" valign="top" class="alt1">';
			print_table_start(false, '100%');
		}

		print_table_header($vbphrase[$vba_dyna->_colnames[$column] . '_column']);

		if (!empty($colmods))
		{
			print_cells_row(array(construct_phrase($vbphrase['x_title'], $vbphrase['module']), $vbphrase['order']), 1);

			$moveinputs = fetch_move_inputs($column);

			foreach ($colmods AS $modid => $order)
			{
				$module =& $activemods[$modid];
				
				if (empty($module))
				{
					continue;
				}

				$hasmods[$column] = true;
				print_input_row(
					$module['title'] . '<br />
					<select name="mods[' . $modid . '][column]" tabindex="1">
						<option value="' . $column . '">' . $vbphrase['move_to'] . ':</option>
						' . $moveinputs . '
						</select><div class="smallfont"><label for="remove_' . $modid . '"><input type="checkbox" id="remove_' . $modid . '" name="removemods[]" value="' . $modid . '" /> ' . $vbphrase['remove'] . '</label></div>',
					'mods[' . $modid . '][displayorder]',
					$order,
					true,
					2
				);
			}
		}

		// Check this afterwards since we could have a deleted module on the page
		if (!$hasmods[$column])
		{
			print_description_row(construct_phrase($vbphrase['no_x'], $vbphrase['modules']), false, 1);
		}

		if ($column == 2)
		{
			print_table_break();

			print_table_start(false, '100%');
			print_table_header($vbphrase['page_content']);
			print_description_row($vbphrase['page_content_desc']);
			print_table_break();

			print_table_start(false, '100%');
		}
		else
		{
			echo '</table><br /></td>';
		}
	}
	echo '</tr>';

	print_submit_row($vbphrase['save'], $vbphrase['reset'], 3);
}

// ##### Save Layout ##########################################################
if ($_POST['do'] == 'savelayout')
{
	$page = $vbulletin->input->clean_gpc('p', 'page', TYPE_NOHTML);
	$userid = $vbulletin->input->clean_gpc('p', 'userid', TYPE_NOHTML);

	if (!in_array($page, $vba_dyna->_dyna_pages))
	{
		print_stop_message('invalid_page_specified');
	}

	require_once(DIR . '/includes/vba_dyna_functions_modules.php');

	$layout = construct_dyna_page_layout();

	// Editing user
	if ($userid)
	{
		$db->query_write("
			UPDATE " . ADV_DYNA_TABLE_PREFIX . "layout SET
				layout = '" . $db->escape_string(serialize($layout)) . "'
			WHERE userid = $userid
				AND page = '" . $db->escape_string($page) . "'
		");

		$redirect = 'do=searchusermodules&userid=' . $userid;
	}
	// Editing default
	else
	{
		$vbulletin->adv_dyna_modpos[$page] =& $layout;

		build_datastore(ADV_DYNA_PREFIX . '_modpos', serialize($vbulletin->adv_dyna_modpos), 1);

		$redirect = 'do=layout&page=' . $page;
	}

	print_cp_redirect('vba_dyna_admin_modules.php?' . $vbulletin->session->vars['sessionurl'] . $redirect . ADV_URL_PREFIX_HR, 0);

}

// ##### List Modules #########################################################
if ($_REQUEST['do'] == 'listmodules' OR $_REQUEST['do'] == 'editlayouts')
{
	?>
	<script type="text/javascript">
	function js_mod_jump(modid)
	{
		action = eval("document.cpform.m" + modid + ".options[document.cpform.m" + modid + ".selectedIndex].value");
		switch (action)
		{
			case 'edit':
				paction = 'editmodule';
			break;
			case 'copy':
				paction = 'copymodule';
			break;
			case 'remove':
				paction = 'removemodule';
			break;
		}
		document.cpform.reset();
		window.location = "vba_dyna_admin_modules.php?do=" + paction + "&modid=" + modid + <?php echo iif(defined('ADV_URL_PREFIX'), '"&adv_dyna_prefix=' . ADV_DYNA_PREFIX . '" + '); ?>"&s=<?php echo $vbulletin->session->vars['sessionhash']; ?>";
	}
	</script>

	<?php

	$modoptions = array(
		'edit' => construct_phrase($vbphrase['edit_x'], $vbphrase['module']),
		'copy' => construct_phrase($vbphrase['copy_x'], $vbphrase['module']),
		'remove' => construct_phrase($vbphrase['delete_x'], $vbphrase['module'])
	);

	// Get a list of active pages for each module
	$activepage = array();
	if (!empty($vbulletin->adv_dyna_modpos))
	{
		foreach ($vbulletin->adv_dyna_modpos AS $pagename => $columns)
		{
			if (!empty($columns))
			{
				foreach ($columns AS $colid => $colmods)
				{
					if (!empty($colmods))
					{
						foreach ($colmods AS $amodid => $modorder)
						{
							$activepages[$amodid][] = $pagename;
							$activemods[$pagename][] = $amodid;
						}
					}
				}
			}
		}
	}

	print_dyna_form_header('vba_dyna_admin_modules', 'listmodules');

	if ($_REQUEST['do'] == 'listmodules')
	{
		$pagedata = fetch_page_data(ADV_DYNA_PREFIX . '_modules', array(), array(), 50);

		print_table_header('<span style="float:' . $stylevar['right'] . '">' .
			construct_phrase(
				$vbphrase['showing_w_x_to_y_of_z'],
				$vbphrase['modules'],
				$pagedata['minlimit'],
				$pagedata['maxlimit'],
				$pagedata['count']
			) . '</span>' .
			construct_phrase($vbphrase['edit_x'], $vbphrase['modules']),
			4
		);
		echo '<tr>
			<td class="thead" width="45%">' . $vbphrase['title'] . '</td>
			<td class="thead" width="20%" align="center">' . $vbphrase['controls'] . '</td>
			<td class="thead" width="10%" style="white-space: nowrap">' . $vbphrase['module_type'] . '</td>
			<td class="thead" width="25%" align="' . $stylevar['right'] . '">' . $vbphrase['pages_active_on'] . '</td>
		</tr>';

		$modules = array();
		$getmods = $db->query_read("
			SELECT modid, title, inctype, active
			FROM " . ADV_DYNA_TABLE_PREFIX . "modules
			ORDER BY title
			LIMIT " . ($pagedata['minlimit'] - 1) . ", $pagedata[perpage]
		");
		while ($mods = $db->fetch_array($getmods))
		{
			$activesel = '<div align="' . $stylevar['right'] . '">';

			$pagecount = sizeof($activepages[$mods['modid']]);

			if (!$pagecount)
			{
				$activesel .= $vbphrase['none'];
			}
			else
			{
				$activesel .= '<select name="active' . $mods['modid'] . '" style="width:155px" class="bginput" tabindex="1005">';

				if (sizeof($activepages[$mods['modid']]) > 1)
				{
					$activesel .= '<option value="0">' . $pagecount . ' ' . $vbphrase['pages'] . '</option>
					<option value="0">--------</option>';
					foreach ($activepages[$mods['modid']] AS $actpage)
					{
						$activesel .= '<option value="0">' . $vbphrase['pages_' . $actpage] . '</option>';
					}
				}
				else
				{
					$activesel .= '<option value="0">' . $vbphrase['pages_' . $activepages[$mods['modid']][0]] . '</option>';
				}

				$activesel .= '</select>';
			}

			$activesel .= '</div>';

			$inactive = '';
			if (!$mods['active'])
			{
				$mods['title'] = '<strike>' . $mods['title'] . '</strike>';
				$inactive = ' (' . $vbphrase['inactive'] . ')';
			}

			print_cells_row(
				array(
					construct_link_code(
						$mods['title'],
						'vba_dyna_admin_modules.php?' . $vbulletin->session->vars['sessionurl'] . 'do=editmodule&amp;modid=' . $mods['modid'] . ADV_URL_PREFIX
					) . $inactive,
					'<div style="white-space: nowrap"><select name="m' . $mods['modid'] . '" onchange="js_mod_jump(' . $mods['modid'] . ');" class="bginput" tabindex="1">' . construct_select_options($modoptions) . '</select><input type="button" class="button" value="' . $vbphrase['go'] . '" onclick="js_mod_jump(' . $mods['modid'] . ');" /></div>',
					$vbphrase[$mods['inctype']],
					$activesel
				)
			);
		}

		if (!print_cp_pagenav(4))
		{
			print_table_footer();
		}

		echo '<div align="center" style="font-weight: bold">' . construct_link_code(
				$vbphrase['add_remove_modules_from_pages'],
				'vba_dyna_admin_modules.php?' . $vbulletin->session->vars['sessionurl'] . 'do=editlayouts' . ADV_URL_PREFIX
			) . '</div>';
	}
	else
	{

		// ##### Layouts
		print_table_header(construct_phrase($vbphrase['edit_x_layouts'], $vbphrase['module']));
		print_description_row(construct_phrase($vbphrase['edit_x_layouts_desc'], $vbphrase['modules_lwr']));
		print_cells_row(array($vbphrase['page'], construct_phrase($vbphrase['active_x'], $vbphrase['modules'])), 1, false, -1);

		foreach ($vba_dyna->_dyna_pages AS $page)
		{
			$moduleselect = '';
			if (!empty($activemods[$page]))
			{
				$modcount = sizeof($activemods[$page]);
				$moduleselect = '<select name="pagemods[' . $page . ']" style="width:195px" tabindex="34">
					<option value="0">' . $modcount . ' ' . ($modcount == 1 ? $vbphrase['module'] : $vbphrase['modules']) . '</option>
				';
				foreach ($activemods[$page] AS $actmod)
				{
					$moduleselect .= '<option value="' . $actmod . '">' . $vbulletin->adv_dyna_module[$actmod]['title'] . '</option>';
				}
				$moduleselect .= '</select>';
			}
			else
			{
				$moduleselect = $vbphrase['none'];
			}

			print_label_row(
				construct_link_code(
					get_page_phrase($page),
					'vba_dyna_admin_modules.php?' . $vbulletin->session->vars['sessionurl'] . 'do=layout&amp;page=' . $page . ADV_URL_PREFIX
				),
				$moduleselect
			);

		}
		print_table_footer();
	}
}

// ##### New Module ###########################################################
if ($_REQUEST['do'] == 'newmodule')
{
	print_dyna_form_header('', '');

	print_table_header($vbphrase['module_type']);

	print_description_row($vbphrase['please_select_type_of_module_to_add'], '', 2, 'thead');

	$urlstart = 'vba_dyna_admin_modules.php?' . $vbulletin->session->vars['sessionurl'] . 'do=addmodule' . ADV_URL_PREFIX . '&amp;type=';

	print_label_row(construct_link_code($vbphrase['bb_code'], $urlstart . 'bb_code'), $vbphrase['module_desc_bbcode'], 0, 'middle');
	print_label_row(construct_link_code($vbphrase['template'], $urlstart . 'template'), $vbphrase['module_desc_template'], 0, 'middle');
	print_label_row(construct_link_code($vbphrase['php_file'], $urlstart . 'php_file'), $vbphrase['module_desc_file'], 0, 'middle');

	print_table_footer();
}

// ##### Add / Edit Module ####################################################
if ($_REQUEST['do'] == 'addmodule' OR $_REQUEST['do'] == 'editmodule' OR $_REQUEST['do'] == 'copymodule')
{

	if ($_REQUEST['do'] == 'addmodule' AND !$_REQUEST['type'])
	{
		print_stop_message(ADV_DYNA_PREFIX . '_must_choose_module_type');
	}

	?>
	<script type="text/javascript">

	function js_mod_tools(tool)
	{
		action = eval("document.vbform.tool_" + tool + ".options[document.vbform.tool_" + tool + ".selectedIndex].value");
		switch (action)
		{
			case 'copymodule':
				page = 'copymodule';
			break;
			case 'removemodule':
				page = 'removemodule';
			break;
			case 'chtype_template':
				page = 'editmodule&chtype=template';
			break;
			case 'chtype_php_file':
				page = 'editmodule&chtype=php_file';
			break;
			case 'chtype_bb_code':
				page = 'editmodule&chtype=bb_code';
			break;

		}
		document.vbform.reset();

		window.location = "vba_dyna_admin_modules.php?do=" + page + "&modid=<?php echo intval($_REQUEST['modid']); ?>&s=<?php echo $vbulletin->session->vars['sessionhash'] . iif(defined('ADV_URL_PREFIX'), '&adv_dyna_prefix=' . ADV_DYNA_PREFIX); ?>";
	}

	function js_template_edit(tempname)
	{
		thisstyleid = eval("document.vbform.edittemp.options[document.vbform.edittemp.selectedIndex].value");
		document.vbform.reset();

		window.location = "vba_dyna_admin_modules.php?do=edittemp&thisstyleid=" + thisstyleid + "&tempname=" + tempname +"&s=<?php echo $vbulletin->session->vars['sessionhash'] . ADV_URL_PREFIX; ?>";
	}

	</script>

	<?php

	$modid = $vbulletin->input->clean_gpc('r', 'modid', TYPE_INT);
	$type = $vbulletin->input->clean_gpc('r', 'type', TYPE_NOHTML);
	$chtype = $vbulletin->input->clean_gpc('r', 'chtype', TYPE_NOHTML);

	require_once(DIR . '/includes/adminfunctions_template.php');

	if ($_REQUEST['do'] == 'editmodule' OR $_REQUEST['do'] == 'copymodule')
	{
		/* $module has already been set at the top of this file */
		$headertitle = iif($_REQUEST['do'] == 'editmodule', construct_phrase($vbphrase['edit_x'], $vbphrase['modules']), construct_phrase($vbphrase['copy_x'], $vbphrase['module'])) . ': ' . $module['title'] . ' (' . $vbphrase['id'] . ': ' . $modid . ')';

		if (!$module['modid'])
		{
			print_stop_message('invalid_x_specified', $vbphrase['module']);
		}

		if ($chtype)
		{
			$module['filename'] = '';
			$type = $chtype;
		}
		else
		{
			$type = $module['inctype'];
		}
		$shellopts = convert_bits_to_array($module['useshell'], $vba_dyna->_shellint);
	}
	else
	{
		$headertitle = iif(empty($module),
			construct_phrase($vbphrase['add_x'], $vbphrase['module']) . ': ' . $vbphrase[$type],
			construct_phrase($vbphrase['copy_x'], $vbphrase['module']) . ': ' . $module['title']
		);
		$module['active'] = 1;
		$shellopts = array('enable' => 1);
	}

	$modtypes = array(
		'noaction' => $vbphrase['please_select_one'],
		'chtype_php_file' => $vbphrase['php_file'],
		'chtype_template' => $vbphrase['template'],
		'chtype_bb_code' => $vbphrase['bb_code']
	);

	($hook = vBulletinHook::fetch_hook('vba_dyna_admin_add_edit_module_start')) ? eval($hook) : false;

	// Main options
	echo '<form action="vba_dyna_admin_modules.php" name="vbform" method="post"' . iif($type == 'bb_code', ' onsubmit="return vB_Editor[\'vB_Editor_001\'].prepare_submit(0, 0)"') . '>
		<input type="hidden" name="do" value="do' . iif($_REQUEST['do'] == 'editmodule', 'editmodule', 'addmodule') . '" />
		<input type="hidden" name="adminhash" value="' . ADMINHASH . '" />' .
			iif(ADV_URL_PREFIX,
				'<input type="hidden" name="adv_dyna_prefix" value="' . ADV_DYNA_PREFIX . '" />'
			) .
			iif($vbulletin->session->vars['sessionhash'],
				'<input type="hidden" name="s" value="' . htmlspecialchars($vbulletin->session->vars['sessionhash']) . '" />'
			);

	print_table_start();

	print_table_header($headertitle);

	if ($_REQUEST['do'] == 'copymodule')
	{
		print_description_row(construct_phrase(
				$vbphrase['copying_x_note'],
				$vbphrase['module_lwr'],
				$module['title']
		));
	}
	else if ($_REQUEST['do'] == 'editmodule')
	{
		if ($chtype)
		{
			// Change module type note
			print_description_row(
				construct_phrase($vbphrase['change_x_type'], $vbphrase['module']),
				0, 2, 'thead'
			);
			print_description_row(construct_phrase(
					$vbphrase['change_x_type_note'],
					$vbphrase['module'],
					$vbphrase[$module['inctype']],
					$vbphrase[$type]
			));
		}
		else
		{
			// Module tools
			print_description_row(construct_phrase($vbphrase['x_tools'], $vbphrase['module']), 0, 2, 'thead');
			print_label_row($vbphrase['select_an_action'],
				'<select name="tool_def" onchange="js_mod_tools(\'def\');" class="bginput" tabindex="99">' .
					construct_select_options(array(
						'noaction' => $vbphrase['please_select_one'],
						'copymodule' => construct_phrase($vbphrase['copy_x'], $vbphrase['module']),
						'removemodule' => construct_phrase($vbphrase['delete_x'], $vbphrase['module'])
					)) . '</select><input type="button" class="button" value="' . $vbphrase['go'] . '" onclick="js_mod_tools(\'def\');" tabindex="100" />', '', 'top', '', true);

			unset($modtypes['chtype_' . $type]);

			print_label_row(
				construct_phrase($vbphrase['change_x_type'], $vbphrase['module']),
				'<select name="tool_chtype" onchange="js_mod_tools(\'chtype\');" class="bginput" tabindex="101">'
					. construct_select_options($modtypes) .
				'</select><input type="button" class="button" value="' . $vbphrase['go'] . '" onclick="js_mod_tools(\'chtype\');" tabindex="102" />'
			);

			// Template options
			if ($type == 'template')
			{
				cache_styles();

				$styles = array();
				foreach ($stylecache AS $sid => $sinfo)
				{
					$styles[$sid] = $sinfo['title'];
				}
				print_label_row(
					construct_phrase($vbphrase['edit_template_for_x_in_style'], $vbphrase['module']),
					'<select name="edittemp" onchange="js_template_edit(\'' . $module['filename'] . '\');" class="bginput" tabindex="103">' .
						construct_select_options($styles) . '
					</select><input type="button" class="button" value="' . $vbphrase['go'] . '" onclick="js_template_edit(\'' . $module['filename'] . '\');" tabindex="104" />'
				);
			}
		}
	}

	if ($_REQUEST['do'] != 'addmodule')
	{
		print_table_break();
	}

	print_table_break();
	print_table_break();

	// ##### Main options
	print_table_header($vbphrase['main_options']);

	construct_hidden_code('modid', $module['modid']);
	construct_hidden_code('module[inctype]', $type);

	print_input_row($vbphrase['title'], 'module[title]', $module['title']);
	print_textarea_row(construct_phrase($vbphrase['x_description'], $vbphrase['module']) . '<div class="smallfont">' . construct_phrase($vbphrase['x_description_visible_on_edit_x_page'], $vbphrase['module']) . '</div>', 'module[description]', $module['description'], 4, 40, true, false);
	print_yes_no_row($vbphrase['active_set_to_no_disable'], 'module[active]', $module['active']);

	if ($type == 'bb_code' OR $type == 'php_file')
	{
		$modopts = convert_bits_to_array($module['options'], ($type == 'php_file' ? $vba_dyna->_php_modint : $vba_dyna->_bbc_modint));
	}
	print_description_row(construct_phrase($vbphrase['x_y_options'], $vbphrase['module'], $vbphrase[$type]), false, 2, 'thead');

	// Specific type options
	switch ($type)
	{
		// ##### PHP File Module
		case 'php_file':

			// Get the filenames for the select box
			$filenames = array();

			$directory = opendir('./vba_dyna_modules');
			while ($modfile = readdir($directory))
			{
				if (ereg('[^.]+', $modfile) AND $modfile != 'index.html')
				{
					$filenames[$modfile] = $modfile;
				}
			}

			closedir($directory);
			asort($filenames);

			$filearray = array(0 => $vbphrase['choose_a_file'], '---------------' => $filenames);

			print_select_row($vbphrase['file_to_include'], 'module[filename]', $filearray, $module['filename']);

			$modselcache = array();
			$modselcache[''] = $vbphrase['none'];
			$getmodules = $db->query_read("
				SELECT identifier, title
				FROM " . ADV_DYNA_TABLE_PREFIX . "modules
				WHERE inctype = 'php_file' AND identifier != ''
				ORDER BY title, modid
			");
			while ($modules = $db->fetch_array($getmodules))
			{
				$modselcache[$modules['identifier']] = $modules['title'];
			}

			$db->free_result($getmodules);
			unset($modules);

			print_select_row($vbphrase['module_parent'], 'module[parent]', $modselcache, $module['parent']);

			// Identifier for adding/copying
			if ($_REQUEST['do'] == 'addmodule' OR $_REQUEST['do'] == 'copymodule')
			{
				if ($_REQUEST['do'] == 'copymodule')
				{
					$modidents = array();
					$modids = $db->query_read("
						SELECT identifier
						FROM " . ADV_DYNA_TABLE_PREFIX . "modules
						WHERE identifier LIKE '" . $db->escape_string($module['identifier']) . "%'
					");
					while ($modident = $db->fetch_array($modids))
					{
						$modidents[] = $modident['identifier'];
					}

					$idcount = 1;
					$foundident = false;
					$oldident = $module['identifier'];
					construct_hidden_code('oldident', $oldident);

					while (!$foundident)
					{
						$idcount++;
						if (!in_array($module['identifier'] . $idcount, $modidents))
						{
							$module['identifier'] = $module['identifier'] . $idcount;
							$foundident = true;
						}
					}
				}

				print_input_row($vbphrase['unique_identifier_desc'], 'module[identifier]', $module['identifier']);
			}
			else
			{
				construct_hidden_code('module[identifier]', $module['identifier']);
			}

			print_textarea_row($vbphrase['templates_used'], 'module[templatelist]', $module['templatelist'], 4, 40, 1, 0);
			print_yes_no_row(construct_phrase($vbphrase['user_editable'], $vbphrase['module_lwr']), 'module[useredit]', $module['useredit']);
			print_yes_no_row($vbphrase['initialize_bbcode_parser'], 'module[options][load_bbcode_parser]', $modopts['load_bbcode_parser']);
			print_yes_no_row($vbphrase['initialize_category_permissions'], 'module[options][load_cat_perms]', $modopts['load_cat_perms']);
			print_yes_no_row($vbphrase['initialize_ignored_users'], 'module[options][load_ignusers]', $modopts['load_ignusers']);
			print_yes_no_row($vbphrase['initialize_forum_permissions'], 'module[options][load_forum_perms]', $modopts['load_forum_perms']);
			print_yes_no_row($vbphrase['clean_file_output'], 'module[options][clean_output]', $modopts['clean_output']);
		break;

		// ##### Template module
		case 'template':

			echo '<tr><td class="alt2" width="100%">' . $vbphrase['template_to_include'] . '</td><td align="' . $stylevar['left'] . '" class="alt2"><span class="smallfont">' . ADV_DYNA_PREFIX . '_</span><input type="text" class="bginput" name="module[filename]" id="it_module[filename]" value="' . $module['filename'] . '" size="24" tabindex="1" /></td></tr>';

			if ($_REQUEST['do'] == 'addmodule')
			{
				cache_styles();

				$stylesel = array();
				foreach ($stylecache AS $cstyleid => $cstyle)
				{
					$stylesel[$cstyleid] = construct_depth_mark($cstyle['depth'], '--') . $cstyle['title'];
				}

				print_select_row(
					$vbphrase['style'] . '<div class="smallfont">' . $vbphrase['select_style_add_template_to'] . '</div>',
					'thisstyleid[]',
					$stylesel,
					'',
					false,
					(sizeof($stylecache) <= 6 ? sizeof($stylecache) : 6),
					true
				);
				print_textarea_row(construct_phrase($vbphrase['template_content'], $vbphrase['module']), 'template', '', 12, 32, true, true, 'ltr', 'code');
			}

		break;

		// ##### BB code module
		case 'bb_code':

			if ($_REQUEST['do'] == 'addmodule')
			{
				$modopts['allow_html'] = 1;
				$modopts['allow_smilies'] = 1;
				$modopts['allow_image_code'] = 1;
			}

			print_cp_text_editor($module['filename'], true, true, true, false, $modopts['allow_html'], $modopts['allow_smilies'], $modopts['allow_image_code']);

		break;

		default:
			($hook = vBulletinHook::fetch_hook('vba_dyna_admin_add_edit_module_switch_type')) ? eval($hook) : false;
	} // End switch($type)

	print_middle_submit_row('', 2, true);
	print_table_break();
	print_table_break();

	// ##### Module wrapper options
	print_table_header($vbphrase['module_wrapper_template_options']);
	print_description_row($vbphrase['options_apply_to_module_wrapper'] . ' ' .
		iif($type != 'bb_code', $vbphrase['note_templates_should_use_format'] . '<div style="border: 1px inset; width:380px">&lt;tr&gt;<br />&lt;td class=&quot;$bgclass&quot;&gt; &lt;!-- Your code here --&gt; &lt;/td&gt;<br />&lt;/tr&gt;</div>'
		)
	, 0, 2, 'tfoot');
	print_yes_no_row(construct_phrase($vbphrase['use_module_wrapper_template'], $vbphrase['module']), 'module[useshell][enable]', $shellopts['enable']);
	print_input_row($vbphrase['alternative_module_wrapper_template'], 'module[altshell]', $module['altshell'], 1, 40, '', '', 'bginput" onchange="wrapper_enabled();');
	print_input_row(construct_phrase($vbphrase['x_link'], $vbphrase['module']), 'module[link]', $module['link']);
	print_input_row($vbphrase['title_row_colspan'], 'module[colspan]', $module['colspan']);
	print_textarea_row($vbphrase['form_code'], 'module[formcode]', $module['formcode']);
	print_yes_no_row($vbphrase['collapse_module_by_default'], 'module[useshell][collapse]', $shellopts['collapse']);

	print_middle_submit_row();
	print_table_break();
	print_table_break();

	// ##### Usergroups
	print_table_header($vbphrase['usergroups'], 4);
	print_description_row(construct_phrase($vbphrase['here_specify_which_usergroups_view_module'], $vbphrase['module_lwr']), '', 4);

	print_module_permission_rows(unserialize($module['userperms']));
	print_middle_submit_row('', 4);


	print_table_break();
	print_table_break('<a name="settings"></a>');

	// ##### Module Settings
	if ($type == 'php_file' AND ($_REQUEST['do'] == 'editmodule' OR $_REQUEST['do'] == 'copymodule'))
	{
		if ($_REQUEST['do'] == 'copymodule')
		{
			$module['identifier'] = $oldident;
		}

		$grouptitle = ADV_DYNA_PREFIX . '_modules_' . $module['identifier'];

		$settings = $db->query_read("
			SELECT *
			FROM " . TABLE_PREFIX . "adv_setting
			WHERE grouptitle = '" . $db->escape_string($grouptitle) . "'
			ORDER BY displayorder
		");
		while ($setting = $db->fetch_array($settings))
		{
			if ($setting['serialize'])
			{
				$setting['value'] = unserialize($setting['value']);
				if (!is_array($setting['value']))
				{
					$setting['value'] = array();
				}
			}

			$settingscache[$setting['grouptitle']][$setting['varname']] = $setting;
		}

		if (!empty($settingscache))
		{
			$settingphrase = fetch_settings_phrases();
			$settingphrase['settinggroup_' . $grouptitle] = construct_phrase($vbphrase['x_options'], $module['title']);
			print_adv_setting_group($grouptitle, 'module');
		}

		if (!empty($settingscache[$grouptitle]))
		{
			$modulevars = array();
			foreach ($settingscache[$grouptitle] AS $varname => $modsetting)
			{
				$modulevars[] = $varname;
			}
			$modulevars = implode(',', $modulevars);
		}

		construct_hidden_code('modulevars', $modulevars);

		print_table_break();
	}


	if ($_REQUEST['do'] == 'editmodule' AND $type == 'php_file' AND $vbulletin->debug)
	{
		echo '<div align="center" style="margin-bottom:6px">' .
			construct_link_code(
				$vbphrase['add_setting'],
				'vba_dyna_admin_main.php?' . $vbulletin->session->vars['sessionurl'] . 'do=addsetting&amp;identifier=' . $module['identifier'] . '&amp;modid=' . $module['modid'] . ADV_URL_PREFIX)
			. '</div>';
	}
	($hook = vBulletinHook::fetch_hook('vba_dyna_admin_add_edit_module_end')) ? eval($hook) : false;

	print_submit_row();

}

// ##### Do Add / Edit Module #################################################
if ($_POST['do'] == 'doaddmodule' OR $_POST['do'] == 'doeditmodule')
{
	$modid = $vbulletin->input->clean_gpc('p', 'modid', TYPE_INT);
	$module = $vbulletin->input->clean_gpc('p', 'module', TYPE_ARRAY);
	$setting = $vbulletin->input->clean_gpc('p', 'setting', TYPE_ARRAY);
	$template = $vbulletin->input->clean_gpc('p', 'template', TYPE_STR);
	$userperms = $vbulletin->input->clean_gpc('p', 'userperms', TYPE_ARRAY);
	$thisstyleid = $vbulletin->input->clean_gpc('p', 'thisstyleid', TYPE_ARRAY_INT);
	$oldident = $vbulletin->input->clean_gpc('p', 'oldident', TYPE_STR);
	$message = $vbulletin->input->clean_gpc('p', 'message', TYPE_STR);
	$wysiwyg = $vbulletin->input->clean_gpc('p', 'wysiwyg', TYPE_STR);

	// Check errors
	if (!$module['title'])
	{
		print_stop_message(ADV_DYNA_PREFIX . '_must_choose_title_for_module');
	}

	if (!$module['filename'] AND $module['inctype'] != 'bb_code')
	{
		print_stop_message(ADV_DYNA_PREFIX . '_must_choose_' . $module['inctype'] . '_include');
	}

	if ($module['inctype'] == 'php_file' AND $_REQUEST['do'] == 'doaddmodule')
	{
		if ($checkidentifier = $db->query_first("SELECT modid FROM " . ADV_DYNA_TABLE_PREFIX . "modules WHERE identifier = '$module[identifier]'"))
		{
			print_stop_message(ADV_DYNA_PREFIX . '_duplicate_identifier', $vbphrase['module'], $module['identifier']);
		}
	}

	// Old module info
	if ($_POST['do'] == 'doeditmodule')
	{
		$oldmodule = $db->query_first("SELECT * FROM " . ADV_DYNA_TABLE_PREFIX . "modules WHERE modid = $modid");
	}

	require_once(DIR . '/includes/functions_misc.php');

	// Usergroup permissions
	$module['userperms'] = array();
	if (!empty($userperms))
	{
		foreach ($userperms AS $usergroupid => $groupperms)
		{
			$module['userperms'][$usergroupid] = convert_array_to_bits($groupperms, $vba_dyna->_modulepermbits, 1);
		}
	}

	$module['userperms'] = serialize($module['userperms']);

	// Things to do for specific types
	switch ($module['inctype'])
	{
		// ##### BB Code
		case 'bb_code':

			$gettemp = $db->query_read("
				SELECT * FROM " . TABLE_PREFIX . "template
				WHERE title IN('bbcode_code', 'bbcode_html', 'bbcode_php', 'bbcode_quote')
					AND styleid = '-1'
			");
			while ($temp = $db->fetch_array($gettemp))
			{
				$vbulletin->templatecache[$temp['title']] = $temp['template'];
			}

			include_once('./includes/class_bbcode.php');
			$bbcode_parser =& new vB_BbCodeParser($vbulletin, fetch_tag_list());

			$module['filename'] = $vbulletin->GPC['message'];
			if ($vbulletin->GPC['wysiwyg'])
			{
				require_once(DIR . '/includes/functions_wysiwyg.php');
				$module['filename'] = convert_wysiwyg_html_to_bbcode($vbulletin->GPC['message'], $setting['allowhtml']);
			}

			$module['code_parsed'] = $bbcode_parser->do_parse(
				$module['filename'],
				$module['options']['allow_html'],
				$module['options']['allow_smilies'],
				1,
				$module['options']['allow_image_code']
			);

		break;

		// ##### Template
		case 'template':

			// Insert new template
			if (trim($template))
			{
				if (empty($thisstyleid))
				{
					print_stop_message(ADV_DYNA_PREFIX . '_choose_style');
				}

				if ($checkexist = $db->query_first("
					SELECT *
					FROM " . TABLE_PREFIX . "template
					WHERE title = '" . ADV_DYNA_PREFIX . "_$module[filename]'
						AND styleid IN(" . implode(', ', $thisstyleid) . ")
				"))
				{
					print_stop_message(ADV_DYNA_PREFIX . '_template_exists', ADV_DYNA_PREFIX . '_' . $module['filename']);
				}

				require_once(DIR . '/includes/adminfunctions_template.php');

				$templateinsert = '';

				if (!empty($thisstyleid))
				{
					foreach ($thisstyleid AS $installstyleid)
					{
						$templateinsert .= "(
							'" . ADV_DYNA_PREFIX . "_$module[filename]',
							'" . $db->escape_string(compile_template($template)) . "',
							'" . $db->escape_string($template) ."',
							'$installstyleid',
							'template',
							" . TIMENOW . ",
							'" . $db->escape_string($vbulletin->userinfo['username']) . "',
							'" . $vbulletin->options['templateversion'] . "',
							'" . ADV_DYNA_PREFIX . "'
						),";
					}

					$db->query_write("
						INSERT INTO " . TABLE_PREFIX . "template
							(title, template, template_un, styleid, templatetype, dateline, username, version, product)
						VALUES
							" . substr($templateinsert, 0, (strlen($templateinsert) - 1))
					);
				}

				build_all_styles(0, 0, 'vba_dyna_admin_modules.php?' . $vbulletin->session->vars['sessionurl'] . 'do=editmodules' . ADV_URL_PREFIX);
			}
		break;

		// ##### PHP File
		case 'php_file':

			// Duplicate the settings if copying
			if ($oldident)
			{
				$repsettings = $db->query_read("SELECT * FROM " . TABLE_PREFIX . "adv_setting WHERE grouptitle = '" . ADV_DYNA_PREFIX . "_modules_$oldident'");
				while ($repsetting = $db->fetch_array($repsettings))
				{
					$repsetting['grouptitle'] = ADV_DYNA_PREFIX . '_modules_' . $module['identifier'];
					$db->query_write(fetch_query_sql($repsetting, 'adv_setting'));
				}

				// Switch the setting group for submitted settings with the new identifier
				$setting[ADV_DYNA_PREFIX . '_modules_' . $module['identifier']] = $setting[ADV_DYNA_PREFIX . '_modules_' . $oldident];
				unset($setting[ADV_DYNA_PREFIX . '_modules_' . $oldident]);
			}

			process_adv_settings(array(ADV_DYNA_PREFIX . '_modules_' . $db->escape_string($module['identifier'])), 'module');

			// Sanitize Templates Used
			if ($module['templatelist'])
			{
				$module['templatelist'] = explode("\r\n", $module['templatelist']);

				if (!empty($module['templatelist']))
				{
					$module['templatelist'] = array_map('trim', $module['templatelist']);
				}

				if (!empty($module['templatelist']))
				{
					$module['templatelist'] = implode("\r\n", $module['templatelist']);
				}
			}

		break;
	}

	require_once(DIR . '/includes/functions_misc.php');

	// Module shell template
	$module['useshell'] = convert_array_to_bits($module['useshell'], $vba_dyna->_shellint);

	// Options
	$newopts = 0;
	if ($module['inctype'] == 'php_file' OR $module['inctype'] == 'bb_code')
	{
		$newopts = convert_array_to_bits($module['options'], ($module['inctype'] == 'php_file' ? $vba_dyna->_php_modint : $vba_dyna->_bbc_modint));
	}
	$module['options'] = $newopts;

	($hook = vBulletinHook::fetch_hook('vba_dyna_admin_do_add_edit_module')) ? eval($hook) : false;

	if ($_POST['do'] == 'doaddmodule')
	{
		// Insert module
		$db->query_write(fetch_query_sql($module, ADV_DYNA_PREFIX . '_modules'));
		$modid = $db->insert_id();
	}
	else
	{
		// Update module
		$db->query_write(fetch_query_sql($module, ADV_DYNA_PREFIX . '_modules', 'WHERE modid = ' . $modid));
	}

	build_dyna_module_datastore();

	print_cp_redirect('vba_dyna_admin_modules.php?' . $vbulletin->session->vars['sessionurl'] . 'do=listmodules' . ADV_URL_PREFIX_HR, 0);
}

// ##### Remove Module ########################################################
if ($_REQUEST['do'] == 'removemodule')
{
	$modid = $vbulletin->input->clean_gpc('r', 'modid', TYPE_INT);

	$module = $db->query_first("
		SELECT modid, title, inctype, filename
		FROM " . ADV_DYNA_TABLE_PREFIX . "modules
		WHERE modid = $modid
	");

	if (!$module['modid'])
	{
		print_stop_message('invalid_x_specified', $vbphrase['module']);
	}

	print_dyna_form_header('vba_dyna_admin_modules', 'doremovemodule');
	construct_hidden_code('modid', $modid);
	print_table_header($vbphrase['confirm_deletion']);

	print_description_row(construct_phrase($vbphrase['are_you_sure_delete_module_called_x'], $module['title']));

	if (($module['inctype'] == 'php_file' OR $module['inctype'] == 'template') AND $module['filename'])
	{
		print_description_row('<input type="checkbox" name="removefile" value="1" id="removefile" /> <label for="removefile">' . construct_phrase(($module['inctype'] == 'php_file' ? $vbphrase['also_delete_module_file_x'] : $vbphrase['also_delete_template_x']), $module['filename']) . '</label>');
	}

	print_submit_row($vbphrase['yes'], '', 2, $vbphrase['no']);
}

// ##### Do Remove Module #####################################################
if ($_POST['do'] == 'doremovemodule')
{
	$modid = $vbulletin->input->clean_gpc('p', 'modid', TYPE_INT);
	$removefile = $vbulletin->input->clean_gpc('p', 'removefile', TYPE_INT);

	$module = $db->query_first("
		SELECT *
		FROM " . ADV_DYNA_TABLE_PREFIX . "modules
		WHERE modid = $modid
	");

	if (!$module['modid'])
	{
		print_stop_message('invalid_x_specified', $vbphrase['module']);
	}

	if ($module['inctype'] == 'php_file')
	{
		if ($removefile)
		{
			@unlink(DIR . '/vba_dyna_modules/' . $module['filename']);
		}
		// Get the settings
		$varnames = array();

		$modsettings = $db->query_read("
			SELECT varname
			FROM " . TABLE_PREFIX . "adv_setting
			WHERE grouptitle = '" . ADV_DYNA_PREFIX . "_modules_$module[identifier]'
		");
		while ($modsetting = $db->fetch_array($modsettings))
		{
			$varnames[] = $modsetting['varname'];
		}

		if (!empty($varnames))
		{
			$dupevar = array();
			$checkdupe = $db->query_read("
				SELECT varname
				FROM " . TABLE_PREFIX . "adv_setting
				WHERE grouptitle != '" . ADV_DYNA_PREFIX . "_modules_$module[identifier]'
					AND varname IN('" . implode("', '", $varnames) . "')
			");
			while ($dupes = $db->fetch_array($checkdupe))
			{
				$dupevar[] = $dupes['varname'];
			}

			$db->query_write("
				DELETE FROM " . TABLE_PREFIX . "adv_setting
				WHERE grouptitle = '" . ADV_DYNA_PREFIX . "_modules_$module[identifier]'
			");

			$varnames = array_diff($varnames, $dupevar);

			$killphrase = array();
			if (!empty($varnames))
			{
				foreach ($varnames AS $pvarname)
				{
					$killphrase[] = 'setting_' . $pvarname . '_title';
					$killphrase[] = 'setting_' . $pvarname . '_desc';
				}

				$db->query_write("DELETE FROM " . TABLE_PREFIX . "phrase WHERE varname IN('" . implode("', '", $killphrase) . "')");
			}
		}
	}
	else if ($module['inctype'] == 'template' AND $removefile)
	{
		$db->query_write("
			DELETE FROM " . TABLE_PREFIX . "template
			WHERE title = '" . ADV_DYNA_PREFIX . "_" . $db->escape_string($module['filename']) . "'
		");
	}

	($hook = vBulletinHook::fetch_hook('vba_dyna_admin_do_remove_module')) ? eval($hook) : false;

	$db->query_write("DELETE FROM " . ADV_DYNA_TABLE_PREFIX . "modules WHERE modid = $modid");

	build_dyna_module_datastore();

	print_cp_redirect('vba_dyna_admin_modules.php?' . $vbulletin->session->vars['sessionurl'] . 'do=listmodules' . ADV_URL_PREFIX_HR, 0);
}

// ##### Custom User Modules ##################################################
if ($_REQUEST['do'] == 'usermodules')
{
	// ##### Search box
	print_dyna_form_header('vba_dyna_admin_modules', 'searchusermodules');
	print_table_header($vbphrase['edit_a_members_modules_layout']);
	print_description_row($vbphrase['allows_you_to_edit_modules_layouts']);
	print_input_row($vbphrase['username'], 'username', $vbulletin->GPC['username']);
	print_submit_row($vbphrase['search'], '');

	// ##### Forcefully Add Module

	$modselect = array(construct_phrase($vbphrase['please_select_one']));
	$getmodules = $db->query_read("
		SELECT modid, title
		FROM " . ADV_DYNA_TABLE_PREFIX . "modules
		WHERE inctype = 'php_file' AND identifier != ''
		ORDER BY title, modid
	");
	while ($modules = $db->fetch_array($getmodules))
	{
		$modselect[$modules['modid']] = $modules['title'];
	}

	print_dyna_form_header('vba_dyna_admin_modules', 'forcemodule');
	print_table_header($vbphrase['forcefully_add_module']);
	print_description_row($vbphrase['forcefully_add_module_desc']);
	print_select_row($vbphrase['module'], 'modid', $modselect);
	print_input_row(construct_phrase($vbphrase['number_of_x_to_process_per_cycle'], $vbphrase['modules']), 'perpage', 500);
	print_submit_row($vbphrase['continue'], '');

	// Reset Members' Page Layouts
	echo '<a name="tool_resetlayouts"></a>';
	print_dyna_form_header('vba_dyna_admin_modules', 'resetlayouts');
	print_table_header($vbphrase['reset_module_layouts']);
	print_description_row($vbphrase['reset_module_layouts_desc']);
	print_label_row(
		$vbphrase['pages'] . ':',
		'<input type="checkbox" id="browse" name="pages[]" value="dyna_browsecategory" /><label for="browse">' . construct_phrase($vbphrase['pages_dyna_browsecategory'], $vbphrase['category']) . '</label><br />
		<input type="checkbox" id="showe" name="pages[]" value="dyna_showentry" /><label for="showe">' . construct_phrase($vbphrase['pages_dyna_showentry'], $vbphrase['entry']) . '</label><br />
	');
	print_submit_row($vbphrase['reset_module_layouts'], '');
}

// ##### Reset Layouts ########################################################
if ($_POST['do'] == 'resetlayouts')
{
	$vbulletin->input->clean_gpc('p', 'pages', TYPE_ARRAY);

	if (empty($vbulletin->GPC['pages']))
	{
		print_stop_message(ADV_DYNA_PREFIX . '_did_not_select_pages_reset');
	}

	$db->query_write("
		DELETE FROM " . ADV_DYNA_TABLE_PREFIX . "layout
		WHERE page IN('" . implode('\', \'', $vbulletin->GPC['pages']) . "')
	");

	print_cp_redirect('vba_dyna_admin_modules.php?' . $vbulletin->session->vars['sessionurl'] . 'do=usermodules' . ADV_URL_PREFIX_HR, 0);
}

// ##### Forcefully Add Module ################################################
if ($_POST['do'] == 'forcemodule')
{
	$modid = $vbulletin->input->clean_gpc('p', 'modid', TYPE_INT);
	$perpage = $vbulletin->input->clean_gpc('p', 'perpage', TYPE_INT);

	print_dyna_form_header('vba_dyna_admin_modules', 'doforcemodule');
	construct_hidden_code('modid', $modid);
	construct_hidden_code('perpage', $perpage);

	print_table_header($vbphrase['forcefully_add_module'] . ': ' . $vbulletin->adv_dyna_module[$modid]['title']);
	print_description_row($vbphrase['here_select_column_order_for_each_page']);
	print_cells_row(array($vbphrase['page'], $vbphrase['add_to_column'] . ' / ' . $vbphrase['order']), true, false, -1);

	foreach (array('dyna_browsecategory', 'dyna_showentry') AS $page)
	{
		$col = 0;
		$pos = 0;

		if (!empty($vbulletin->adv_dyna_modpos[$page]))
		{
			foreach ($vbulletin->adv_dyna_modpos[$page] AS $pagecol => $pagemods)
			{
				if (isset($pagemods[$modid]))
				{
					$col = $pagecol;
					$pos = $pagemods[$modid];
				}
			}
		}

		$right = '<select name="column[' . $page . ']" tabindex="1">';

		foreach ($vba_dyna->_colnames AS $colid => $colname)
		{
			$right .= '<option value="' . $colid . '">' . $vbphrase[$colname . '_column'] . '</option>';
		}

		$right .= '</select> <input type="text" class="bginput" name="order[' . $page . ']" value="' . $pos . '" size="2" tabindex="1" />';


		print_label_row(get_page_phrase($page), $right);
	}

	print_submit_row($vbphrase['continue'], '');
}

// ##### Do Forcefully Add Module #############################################
if ($_REQUEST['do'] == 'doforcemodule')
{
	$modid = $vbulletin->input->clean_gpc('p', 'modid', TYPE_INT);
	$columns = $vbulletin->input->clean_gpc('p', 'column', TYPE_ARRAY_INT);
	$orders = $vbulletin->input->clean_gpc('p', 'order', TYPE_ARRAY_INT);
	$perpage = $vbulletin->input->clean_gpc('p', 'perpage', TYPE_INT);

	$pagedata = fetch_page_data(ADV_DYNA_TABLE_PREFIX . 'layout', array(), array(), 1);

	if ($pagedata['pagenumber'] > 1)
	{
		$vbulletin->input->clean_array_gpc('p', array('colums_ser', 'orders_ser'), TYPE_STR);

		$columns = unserialize($vbulletin->GPC['columns_ser']);
		$orders = unserialize($vbulletin->GPC['orders_ser']);
	}

	$layoutreplace = '';

	$getlayouts = $db->query_read("
		SELECT *
		FROM " . ADV_DYNA_TABLE_PREFIX . "layout
		ORDER BY userid, page
		LIMIT " . ($pagedata['minlimit'] - 1) . ", $pagedata[perpage]
	");
	while ($layout = $db->fetch_array($getlayouts))
	{
		$layout['layout'] = unserialize($layout['layout']);

		$foundmod = false;
		if (!empty($layout['layout']))
		{
			foreach ($layout['layout'] AS $col => $mods)
			{
				if (is_array($mods))
				{
					if (in_array($modid, $mods))
					{
						$foundmod = true;
					}
				}
			}
		}

		if (!$foundmod)
		{
			if (empty($layout['layout'][$columns[$layout['page']]]))
			{
				$newcol = array();
			}
			else
			{
				$newcol = array_keys($layout['layout'][$columns[$layout['page']]]);
			}

			array_splice($newcol, intval(($orders[$layout['page']] - 1)), 0, $modid);

			$layout['layout'][$columns[$layout['page']]] = array_combine($newcol, range(1, sizeof($newcol)));;

			$layoutreplace .= '(
				' . $layout['userid'] . ',
				\'' . $layout['page'] . '\',
				\'' . $db->escape_string(serialize($layout['layout'])) . '\'
			), ';
		}

	}

	if ($layoutreplace)
	{
		$layoutreplace = substr($layoutreplace, 0, (strlen($layoutreplace) - 2));
		$db->query_write("REPLACE INTO " . ADV_DYNA_TABLE_PREFIX . "layout (userid, page, layout) VALUES $layoutreplace");
	}

	// All done or redirect
	if ($pagedata['pagenumber'] >= $pagedata['pagecount'])
	{
		define('CP_BACKURL', 'vba_dyna_admin_modules.php?' . $vbulletin->session->vars['sessionurl'] . 'do=usermodules' . ADV_URL_PREFIX_HR);
		print_stop_message(ADV_DYNA_PREFIX . '_updated_x_successfully', construct_phrase($vbphrase['x_layouts'], $vbphrase['user']));
	}
	else
	{
		print_dyna_form_header('vba_dyna_admin_modules', 'doforcemodule');
		construct_hidden_code('page', ($pagedata['pagenumber'] + 1));
		construct_hidden_code('columns_ser', serialize($columns));
		construct_hidden_code('orders_ser', serialize($orders));
		construct_hidden_code('perpage', $perpage);
		print_table_header($vbphrase['forcefully_add_module'] . ': ' . $vbulletin->adv_dyna_module[$modid]['title']);
		print_description_row(construct_phrase($vbphrase['page_x_of_y'], $pagedata['pagenumber'], $pagedata['pagecount']));

		print_submit_row($vbphrase['continue'], '');
	}
}

// ##### Search User Modules ##################################################
if ($_REQUEST['do'] == 'searchusermodules')
{
	$vbulletin->input->clean_array_gpc('r', array(
		'userid' => TYPE_INT,
		'username' => TYPE_NOHTML,
		'page' => TYPE_INT
	));

	$userids = array();

	// Username submitted
	if ($vbulletin->GPC['username'])
	{
		$querywhere = "username LIKE '%" . $db->escape_string($vbulletin->GPC['username']) . "%'";

		$pagedata = fetch_page_data('user', array($querywhere), array(), 50);

		$getusers = $db->query_read("
			SELECT userid, username
			FROM " . TABLE_PREFIX . "user
			WHERE $querywhere
			ORDER BY username
			LIMIT " . ($pagedata['minlimit'] - 1) . ", $pagedata[perpage]
		");
		while ($users = $db->fetch_array($getusers))
		{
			$userids[$users['userid']] = $users['username'];
		}

		if (empty($userids))
		{
			print_stop_message('invalid_user_specified');
		}
	}

	if (sizeof($userids) == 1)
	{
		$useridarray = array_keys($userids);
		$usernamearray = array_values($userids);
		$vbulletin->GPC['userid'] = $useridarray[0];
		$modusername = $usernamearray[0];
	}
	else if (sizeof($userids) > 1)
	{
		print_dyna_form_header('vba_dyna_admin_modules', 'usermodules');
		print_table_header(construct_phrase(
			$vbphrase['showing_w_x_to_y_of_z'],
			$vbphrase['users'],
			$pagedata['minlimit'],
			$pagedata['maxlimit'],
			$pagedata['count']
		));

		foreach ($userids AS $userid => $username)
		{
			print_description_row('<a href="vba_dyna_admin_modules.php?' . $vbulletin->session->vars['sessionurl'] . 'do=searchusermodules&amp;userid=' . $userid . ADV_URL_PREFIX . '">' . $username . '</a>');
		}

		if (!print_cp_pagenav())
		{
			print_table_footer();
		}
	}

	// Get a user's modules
	if ($vbulletin->GPC['userid'])
	{
		if (!$modusername)
		{
			$moduser = $db->query_first("SELECT username FROM " . TABLE_PREFIX . "user WHERE userid = " . $vbulletin->GPC['userid']);
			$modusername = $moduser['username'];
		}

		?>
		<script type="text/javascript">
		function js_opt_jump(modid)
		{
			action = eval("document.moduleform.m" + modid + ".options[document.moduleform.m" + modid + ".selectedIndex].value");
			switch (action)
			{
				case 'edit':
					page = 'editusermodule';
				break;
				case 'delete':
					page = 'deleteusermodule';
				break;
				case 'view':
					page = 'viewusermodule';
				break;
			}
			document.cpform.reset();

			window.location = "vba_dyna_admin_modules.php?do=" + page + "&modlinkid=" + modid + "&s=<?php echo $vbulletin->session->vars['sessionhash'] . ADV_URL_PREFIX_HR; ?>";
		}

		</script>

		<?php

		print_dyna_form_header('', '', false, true, 'moduleform');
		print_table_header($modusername);
		print_description_row(construct_phrase($vbphrase['edit_x_layouts'], fetch_possessive($modusername)), false, 2, 'thead');

		// Layouts
		$getpages = $db->query_read("SELECT page FROM " . ADV_DYNA_TABLE_PREFIX . "layout WHERE userid = " . $vbulletin->GPC['userid']);
		if ($db->num_rows($getpages))
		{
			while ($page = $db->fetch_array($getpages))
			{
				print_label_row(
					construct_link_code(
						$vbphrase['edit'],
						'vba_dyna_admin_modules.php?do=layout&amp;page=' . $page['page'] . '&amp;userid=' . $vbulletin->GPC['userid'] . ADV_URL_PREFIX_HR
					) .
					get_page_phrase($page['page'])
				);
			}
		}
		else
		{
			print_description_row(construct_phrase($vbphrase['no_x_to_display'], $vbphrase['layouts']));
		}

		print_description_row(construct_phrase($vbphrase['edit_x_custom_modules'], fetch_possessive($modusername)), false, 2, 'thead');

		// Custom Modules
		$getmodules = $db->query_read("SELECT modlinkid, title FROM " . ADV_DYNA_TABLE_PREFIX . "modules_user WHERE userid = " . $vbulletin->GPC['userid'] . " AND modid = 0");
		if ($db->num_rows($getmodules))
		{
			while ($module = $db->fetch_array($getmodules))
			{
				print_cells_row(array(
					$module['title'],
					'<select name="m' . $module['modlinkid'] . '" onchange="js_opt_jump(' . $module['modlinkid'] . ');" class="bginput" tabindex="1">' .
						construct_select_options(array(
							'view' => $vbphrase['view'],
							'edit' => $vbphrase['edit'],
							'delete' => $vbphrase['delete']
						)) . '</select><input class="button" type="button" value="' . $vbphrase['go'] . '" onclick="js_opt_jump(' . $module['modlinkid'] . ');" />'
				));
			}
		}
		else
		{
			print_description_row(construct_phrase($vbphrase['no_x_to_display'], $vbphrase['modules']));
		}

		print_table_footer();
	}
}

// ##### View User Module #####################################################
if ($_REQUEST['do'] == 'viewusermodule')
{
	$modlinkid = $vbulletin->input->clean_gpc('r', 'modlinkid', TYPE_INT);

	$module = $db->query_first("
		SELECT modules_user.*, user.username
		FROM " . ADV_DYNA_TABLE_PREFIX . "modules_user AS modules_user
		LEFT JOIN " . TABLE_PREFIX . "user AS user ON (modules_user.userid = user.userid)
		WHERE modlinkid = $modlinkid
	");

	print_dyna_form_header('vba_dyna_admin_modules', '');
	construct_hidden_code('modlinkid', $modlinkid);
	print_table_header('<a style="float:' . $stylevar['right'] . '" href="' . $vbulletin->options['bburl'] . '/member.php?' . $vbulletin->session->vars['sessionurl'] . 'u=' . $module['userid'] . '">' . $module['username'] . '</a> ' . $module['title']);
	print_description_row(construct_phrase($vbphrase['x_options'], $vbphrase['module']) . ': <select name="do" class="bginput" onchange="submit();">' . construct_select_options(array('editusermodule' => $vbphrase['edit'], 'deleteusermodule' => $vbphrase['delete'])) . '</select> <input class="button" type="submit" value="' . $vbphrase['go'] . '" />', 0, 1, '', 'center');

	print_table_break();

	print_table_header(construct_phrase($vbphrase['preview_x'], ''));
	print_description_row($module['code_parsed']);
	print_table_footer();
}

// ##### Edit User Module #####################################################
if ($_REQUEST['do'] == 'editusermodule')
{
	$modlinkid = $vbulletin->input->clean_gpc('r', 'modlinkid', TYPE_INT);

	$module = $db->query_first("
		SELECT modules_user.*, user.username
		FROM " . ADV_DYNA_TABLE_PREFIX . "modules_user AS modules_user
		LEFT JOIN " . TABLE_PREFIX . "user AS user ON (modules_user.userid = user.userid)
		WHERE modlinkid = $modlinkid
	");

	if (!$module['modlinkid'])
	{
		print_stop_message('invalid_x_specified', $vbphrase['module']);
	}

	echo '<form action="vba_dyna_admin_modules.php" name="vbform" method="post" onsubmit="return vB_Editor[\'vB_Editor_001\'].prepare_submit(0, 0)">';
	construct_hidden_code('do', 'doeditusermodule');
	construct_hidden_code('adminhash', ADMINHASH);
	construct_hidden_code('modlinkid', $vbulletin->GPC['modlinkid']);
	construct_hidden_code('userid', $module['userid']);

	if (ADV_URL_PREFIX)
	{
		construct_hidden_code('adv_dyna_prefix', ADV_DYNA_PREFIX);
	}

	print_table_start();
	print_table_header('<a style="float:' . $stylevar['right'] . '" href="' . $vbulletin->options['bburl'] . '/member.php?' . $vbulletin->session->vars['sessionurl'] . 'u=' . $module['userid'] . '">' . $module['username'] . '</a>' . construct_phrase($vbphrase['edit_x'], $vbphrase['module']) . ': ' . $module['title']);
	print_input_row($vbphrase['title'], 'title', $module['title']);
	print_cp_text_editor($module['code'], false, $vba_options['dyna_allow_module_smilie'], $vba_options['dyna_allow_module_img'], true, false, $module['allowsmilie']);
	print_submit_row();
}

// ##### Do Edit User Module ##################################################
if ($_POST['do'] == 'doeditusermodule')
{
	$vbulletin->input->clean_array_gpc('p', array(
		'wysiwyg' => TYPE_BOOL,
		'message' => TYPE_STR,
		'title' => TYPE_NOHTML,
		'parseurl' => TYPE_INT,
		'userid' => TYPE_INT,
		'modlinkid' => TYPE_INT,
		'disablesmilies' => TYPE_INT
	));

	require_once(DIR . '/includes/functions_misc.php');

	// Load BBcode parser
	require_once(DIR . '/includes/class_bbcode.php');
	$bbcode_parser =& new vB_BbCodeParser($vbulletin, fetch_tag_list());

	$vbulletin->GPC['message'] = fetch_censored_text($vbulletin->GPC['message']);

	$disablesmilies = (!$vba_options['dyna_allow_module_smilie']) ? 1 : $vbulletin->GPC['disablesmilies'];
	$allowsmilie = ($disablesmilies) ? 0 : 1;

	$module['title'] =& $vbulletin->GPC['title'];
	$module['message'] =& $vbulletin->GPC['message'];

	// WYSIWYG
	if ($vbulletin->GPC['wysiwyg'])
	{
		require_once(DIR . '/includes/functions_wysiwyg.php');
		$vbulletin->GPC['message'] = convert_wysiwyg_html_to_bbcode($vbulletin->GPC['message']);
	}

	if ($vbulletin->GPC['parseurl'])
	{
		require_once(DIR . '/includes/functions_newpost.php');
		$vbulletin->GPC['message'] = convert_url_to_bbcode($vbulletin->GPC['message']);
	}

	require_once(DIR . '/includes/functions_newpost.php');

	// Parse pagetext
	$module_parsed = $bbcode_parser->do_parse(
		$vbulletin->GPC['message'],
		0,
		$allowsmilie,
		$vba_options['dyna_allow_module_bbcode'],
		$vba_options['dyna_allow_module_img']
	);

	$db->query_write("
		UPDATE " . ADV_DYNA_TABLE_PREFIX . "modules_user SET
			title = '" . $db->escape_string($vbulletin->GPC['title']) . "',
			code = '" . $db->escape_string($vbulletin->GPC['message']) . "',
			code_parsed = '" . $db->escape_string($module_parsed) . "',
			allowsmilie = $allowsmilie
		WHERE modlinkid = " . $vbulletin->GPC['modlinkid']
	);

	print_cp_redirect('vba_dyna_admin_modules.php?' . $vbulletin->session->vars['sessionurl'] . 'do=usermodules&userid=' . $vbulletin->GPC['userid'] . ADV_URL_PREFIX_HR, 0);
}

// ##### Delete User Module ###################################################
if ($_REQUEST['do'] == 'deleteusermodule')
{
	$modlinkid = $vbulletin->input->clean_gpc('r', 'modlinkid', TYPE_INT);
	$module = $db->query_first("SELECT modlinkid, title, userid FROM " . ADV_DYNA_TABLE_PREFIX . "modules_user WHERE modlinkid = $modlinkid");
	print_dyna_form_header('vba_dyna_admin_modules', 'dodeleteusermodule');
	construct_hidden_code('userid', $module['userid']);
	construct_hidden_code('modlinkid', $module['modlinkid']);
	print_table_header($vbphrase['confirm_deletion']);

	print_description_row(construct_phrase($vbphrase['are_you_sure_delete_module_called_x'], $module['title']));
	print_submit_row($vbphrase['yes'], '', 2, $vbphrase['no']);
}

// ##### Do Delete User Module ################################################
if ($_REQUEST['do'] == 'dodeleteusermodule')
{
	$vbulletin->input->clean_array_gpc('p', array(
		'modlinkid' => TYPE_INT,
		'userid' => TYPE_INT
	));

	$db->query_write("DELETE FROM " . ADV_DYNA_TABLE_PREFIX . "modules_user WHERE modlinkid = " . $vbulletin->GPC['modlinkid']);
	print_cp_redirect('vba_dyna_admin_modules.php?' . $vbulletin->session->vars['sessionurl'] . 'do=usermodules&userid=' . $vbulletin->GPC['userid'] . ADV_URL_PREFIX_HR, 0);
}

// ##### Download / Upload Module #############################################
if ($_REQUEST['do'] == 'download')
{
	require_once(DIR . '/includes/adminfunctions_template.php');

	print_dyna_form_header('vba_dyna_admin_modules', 'uploadmodule', true);

	// Upload module
	print_table_header(construct_phrase($vbphrase['upload_x'], $vbphrase['module']));
	print_description_row($vbphrase['main_options'], 0, 2, 'thead');
	print_upload_row($vbphrase['select_module_upload'], 'modfile');
	print_yes_no_row($vbphrase['active_set_to_no_disable'], 'module[active]', 1);

	cache_styles();

	$stylesel = array();
	foreach($stylecache AS $style)
	{
		$stylesel[$style['styleid']] = str_repeat('--', ($style['depth'] + 1)) . ' ' . $style['title'];
	}
	$styles = array('' => $vbphrase['please_select_one'], '----------' => $stylesel);

	print_select_row($vbphrase['style_to_install_to'], 'thisstyleid', $styles);

	echo '</table>';
	print_table_start(false, '90%', 0, '" style="border-top: 0"');
	print_module_permission_rows();

	print_submit_row($vbphrase['submit'], '', 4);


	// Download module
	print_dyna_form_header('vba_dyna_admin_modules', 'downloadmodule');

	print_table_header($vbphrase['download_module']);
	print_description_row($vbphrase['tool_downloads_module'], '', 2, 'tfoot');

	$modules = $db->query_read("SELECT modid, title FROM " . ADV_DYNA_TABLE_PREFIX . "modules ORDER BY title");
	while ($module = $db->fetch_array($modules))
	{
		print_description_row('<input id="' . $module['modid'] . '" name="modid" type="radio" value="' . $module['modid'] . '" /> <label for="' . $module['modid'] . '">' . $module['title'] . '</label>', false);
	}

	print_submit_row($vbphrase['download'], '', 3);
}

// ##### Upload Module ########################################################
if ($_POST['do'] == 'uploadmodule')
{
	$vbulletin->input->clean_array_gpc('p', array(
		'userperms' => TYPE_ARRAY,
		'thisstyleid' => TYPE_INT,
		'haderrors' => TYPE_INT,
		'identifier' => TYPE_NOHTML,
		'filename' => TYPE_NOHTML,
		'edit_filename' => TYPE_NOHTML,
		'modulefilename' => TYPE_NOHTML,
		'overwrite_template' => TYPE_INT,
		'overwrite_edit_filename' => TYPE_INT,
		'overwrite_filename' => TYPE_INT,
		'userperms_serial' => TYPE_STR,
		'module_serial' => TYPE_STR
	));

	if (!is_writable('./vba_dyna_modules/'))
	{
		print_stop_message(ADV_DYNA_PREFIX . '_moddir_notwritable');
	}

	$module =& $_POST['module'];

	if (!$vbulletin->GPC['haderrors'])
	{
		$modfile =& $_FILES['modfile'];
		@chmod('./vba_dyna_modules', 0777);
		@move_uploaded_file($modfile['tmp_name'], './vba_dyna_modules/' . $modfile['name']);
	}
	else
	{
		$modfile['name'] = $vbulletin->GPC['modulefilename'];
	}

	// Incorrect extension
	if (substr($modfile['name'], -7) != '.module' AND substr($modfile['name'], -11) != '.module.php')
	{
		@unlink('./vba_dyna_modules/' . $modfile['name']);
		print_stop_message(ADV_DYNA_PREFIX . '_invalid_modfile');
	}

	// Open it up and get the info
	if ($fp = @fopen('./vba_dyna_modules/' . $modfile['name'], 'r'))
	{
		$moduleinfo = unserialize(fread($fp, filesize('./vba_dyna_modules/' . $modfile['name'])));
		fclose($fp);

		if ($vbulletin->GPC['haderrors'])
		{
			$vbulletin->GPC['module_serial'] = unserialize($vbulletin->GPC['module_serial']);
			$module =& $vbulletin->GPC['module_serial'];

			$vbulletin->GPC['userperms'] = unserialize($vbulletin->GPC['userperms_serial']);
		}
		else
		{
			// For old CMPS modules
			if (!is_array($moduleinfo['module']))
			{
				$moduleinfo['module'] = unserialize($moduleinfo['module']);
			}
			$module = array_merge($moduleinfo['module'], $module);
		}
	}

	if (empty($module))
	{
		@unlink('./vba_dyna_modules/' . $modfile['name']);
		print_stop_message(ADV_DYNA_PREFIX . '_invalid_modfile');
	}

	if ($vbulletin->GPC['identifier'])
	{
		$module['identifier'] = $vbulletin->GPC['identifier'];
	}

	if ($vbulletin->GPC['filename'])
	{
		$module['filename'] = $vbulletin->GPC['filename'];
	}

	$moderrors = array();

	// ##### PHP file erorr checks
	if ($module['inctype'] == 'php_file')
	{
		// Filename
		if (is_file('./vba_dyna_modules/' . $module['filename']) AND $moduleinfo['file'] AND !$vbulletin->GPC['overwrite_filename'])
		{
			$moderrors['duplicate_filename'] = $module['filename'];
		}

		// Edit filename
		if (is_file('./vba_dyna_modules/edit_' . $module['filename']) AND $moduleinfo['file_edit'] AND $module['useredit'] AND !$vbulletin->GPC['overwrite_edit_filename'])
		{
			$moderrors['duplicate_edit_filename'] = $module['filename'];
		}

		// Identifier
		if ($checkidentifier = $db->query_first("SELECT modid FROM " . ADV_DYNA_TABLE_PREFIX . "modules WHERE identifier = '" . $db->escape_string($module['identifier']) . "'"))
		{
			$moderrors['duplicate_module_identifier'] = $module['identifier'];
		}
	}

	// ##### Templates
	// For old CMPS modules
	if (!is_array($moduleinfo['templates']))
	{
		$moduleinfo['templates'] = unserialize($moduleinfo['templates']);
	}

	if (!empty($moduleinfo['templates']) AND !$vbulletin->GPC['haderrors'])
	{
		if (!$vbulletin->GPC['thisstyleid'])
		{
			print_stop_message(ADV_DYNA_PREFIX . '_choose_style');
		}

		if (ADV_DYNA_PREFIX != 'adv_dyna')
		{
			$newtemparray = array();

			foreach ($moduleinfo['templates'] AS $tempname => $temp)
			{
				if (substr($tempname, 0, 8) == 'adv_dyna')
				{
					$newtemparray[ADV_DYNA_PREFIX . substr($tempname, 8)] = $temp;
				}
			}

			$moduleinfo['templates'] =& $newtemparray;
		}

		$currenttemplates = array();
		$checktemps = $db->query_read("
			SELECT title
			FROM " . TABLE_PREFIX . "template
			WHERE title IN('" . implode('\',\'', array_keys($moduleinfo['templates'])) . "')
				AND styleid = " . $vbulletin->GPC['thisstyleid']
		);
		while ($template = $db->fetch_array($checktemps))
		{
			$moderrors['overwrite_templates'][] = $template['title'];
		}
		$db->free_result($checktemps);
		unset($template);
	}

	// ##### Have Errros
	if (sizeof($moderrors))
	{
		$moderrorkeys = array_keys($moderrors);
		print_dyna_form_header('vba_dyna_admin_modules', 'uploadmodule');
		construct_hidden_code('thisstyleid', $vbulletin->GPC['thisstyleid']);
		construct_hidden_code('haderrors', 1);
		construct_hidden_code('modulefilename', $modfile['name']);
		construct_hidden_code('userperms_serial', serialize($vbulletin->GPC['userperms']));
		construct_hidden_code('module_serial', serialize($module));

		if ($vbulletin->GPC['identifier'] AND !in_array('duplicate_module_identifier', $moderrorkeys))
		{
			construct_hidden_code('identifier', $identifier);
		}

		if ($vbulletin->GPC['filename'] AND !in_array('duplicate_filename', $moderrorkeys))
		{
			construct_hidden_code('filename', $vbulletin->GPC['filename']);
		}

		if ($vbulletin->GPC['edit_filename'] AND !in_array('duplicate_edit_filename', $moderrorkeys))
		{
			construct_hidden_code('edit_filename', $vbulletin->GPC['edit_filename']);
		}

		if ($vbulletin->GPC['overwrite_template'])
		{
			construct_hidden_code('overwrite_template', $vbulletin->GPC['overwrite_template']);
		}

		if ($vbulletin->GPC['overwrite_filename'])
		{
			construct_hidden_code('overwrite_filename', $vbulletin->GPC['overwrite_filename']);
		}

		if ($vbulletin->GPC['overwrite_edit_filename'])
		{
			construct_hidden_code('overwrite_edit_filename', $vbulletin->GPC['overwrite_edit_filename']);
		}

		print_table_header($vbphrase['error']);

		// Print the errors
		foreach ($moderrors AS $phrase => $value)
		{
			print_description_row($vbphrase[$phrase], '', 2, 'thead');

			switch ($phrase)
			{
				// ##### Overwrite templates?
				case 'overwrite_templates':
					print_yes_no_row(construct_phrase($vbphrase[$phrase . '_desc'], '<strong>' . implode('<br />', $value)) . '</strong>', 'overwrite_template', 0);
				break;

				// ##### Duplicate filename
				case 'duplicate_filename':
					if ($vbulletin->GPC['haderrors'])
					{
						$curfilesel[$vbulletin->GPC['overwrite_filename']] = ' checked="checked"';
					}
					else
					{
						$curfilesel['2'] = ' checked="checked"';
					}
					print_label_row(
						construct_phrase($vbphrase[$phrase . '_desc'], $value),
						'<div class="smallfont">
							<input type="radio" name="overwrite_filename" id="orf_2" value="2" ' . $curfilesel['2'] . '/><label for="orf_2">' . $vbphrase['use_current_file_instead'] . '</label><br />
							<input type="radio" name="overwrite_filename" id="orf_1" value="1" ' . $curfilesel['1'] . '/><label for="orf_1">' . $vbphrase['overwrite_file_with_new_file'] . '</label><br />
							<input type="radio" name="overwrite_filename" id="orf_0" value="0" ' . $curfilesel['0'] . '/><label for="orf_0">' . $vbphrase['rename_to_filename_entered_below'] . '</label><br />
							<input type="text" size="35" name="filename" class="bginput" value="' . $value . '" />
						</div>'
					);
				break;

				// ##### Duplicate Edit Filename
				case 'duplicate_edit_filename':
					if ($vbulletin->GPC['haderrors'])
					{
						$curfilesel[$vbulletin->GPC['overwrite_edit_filename']] = ' checked="checked"';
					}
					else
					{
						$curfilesel['2'] = ' checked="checked"';
					}

					print_label_row(
						construct_phrase($vbphrase['duplicate_filename_desc'], $value),
						'<div class="smallfont">
							<input type="radio" name="overwrite_edit_filename" id="oref_2" value="2" ' . $curfilesel['2'] . '/><label for="oref_2">' . $vbphrase['use_current_file_instead'] . '</label><br />
							<input type="radio" name="overwrite_edit_filename" id="oref_1" value="1" ' . $curfilesel['1'] . '/><label for="oref_1">' . $vbphrase['overwrite_file_with_new_file'] . '</label><br />
							<input type="radio" name="overwrite_edit_filename" id="oref_0" value="0" ' . $curfilesel['0'] . '/><label for="oref_0">' . $vbphrase['rename_to_filename_entered_below'] . '</label><br />
							edit_<input type="text" size="30" name="edit_filename" class="bginput" value="' . $value . '" />
						</div>'
					);
				break;

				// ##### Duplicate Identifier
				case 'duplicate_module_identifier':
					print_input_row(construct_phrase($vbphrase[$phrase . '_desc'], $value), 'identifier', $value);
				break;
			}
		}
		print_submit_row();
	}
	// ##### No errors, so let's process the module
	else
	{
		// ##### Usergroup permissions
		require_once(DIR . '/includes/functions_misc.php');

		$module['userperms'] = array();
		if (!empty($vbulletin->GPC['userperms']))
		{
			foreach ($vbulletin->GPC['userperms'] AS $usergroupid => $groupperms)
			{
				$module['userperms'][$usergroupid] = convert_array_to_bits($groupperms, $vba_dyna->_modulepermbits, 1);
			}
		}

		$module['userperms'] = serialize($module['userperms']);

		// ##### Process templates
		if ($moduleinfo['templates'] AND ($vbulletin->GPC['overwrite_template'] OR !$vbulletin->GPC['haderrors']))
		{
			require_once(DIR . '/includes/adminfunctions_template.php');

			$db->query_write("DELETE FROM " . TABLE_PREFIX . "template WHERE title IN('" . implode('\',\'', array_keys($moduleinfo['templates'])) . "') AND styleid = " . $vbulletin->GPC['thisstyleid']);

			foreach ($moduleinfo['templates'] AS $title => $template)
			{
				$db->query_write("
					INSERT INTO " . TABLE_PREFIX . "template
						(title, template, template_un, styleid, templatetype, dateline, username, version)
					VALUES (
						'$title',
						'" . $db->escape_string(compile_template($template)) . "',
						'" . $db->escape_string($template) ."',
						" . $vbulletin->GPC['thisstyleid'] . ",
						'template',
						" . TIMENOW . ",
						'" . $db->escape_string($bbuserinfo['username']) . "',
						'" . $vbulletin->options['version'] . "'
				)");

			}
			build_all_styles(0, 0);
		}

		// ##### Module settings
		// For old CMPS modules
		if (!is_array($moduleinfo['settings']))
		{
			$moduleinfo['settings'] = unserialize($moduleinfo['settings']);
		}
		// Clean output (from old CMPS modules)
		if (isset($module['cleanoutput']))
		{
			if ($module['cleanoutput'])
			{
				$module['options'] += $vba_dyna->_php_modint['clean_output'];
			}
			unset($module['cleanoutput']);
		}

		// ##### Settings
		if (!empty($moduleinfo['settings']))
		{
			foreach ($moduleinfo['settings'] AS $varname => $setting)
			{
				$db->query_write("
					INSERT IGNORE INTO " . TABLE_PREFIX . "phrase
						(languageid, varname, text, fieldname, product)
					VALUES (
						0,
						'setting_" . $varname . "_title',
						'" . $db->escape_string($setting['title']) ."',
						'vbsettings',
						'" . ADV_DYNA_PREFIX . "'
				)");
				$db->query_write("
					INSERT IGNORE INTO " . TABLE_PREFIX . "phrase
						(languageid, varname, text, fieldname, product)
					VALUES (
						0,
						'setting_" . $varname . "_desc',
						'" . $db->escape_string($setting['description']) . "',
						'vbsettings',
						'" . ADV_DYNA_PREFIX . "'
				)");

				$db->query_write("
					INSERT INTO " . TABLE_PREFIX . "adv_setting
						(varname, grouptitle, value, defaultvalue, optioncode, displayorder)
					VALUES (
						'$varname',
						'adv_dyna_modules_$module[identifier]',
						'" . $db->escape_string($setting['value']) . "',
						'" . $db->escape_string($setting['defaultvalue']) . "',
						'" . $db->escape_string($setting['optioncode']) . "',
						'$setting[displayorder]'
				)");
			}
		}

		// Insert module
		$db->query_write(fetch_query_sql($module, ADV_DYNA_PREFIX . '_modules'));
		$modid = $db->insert_id();

		// Write module file
		if ($module['inctype'] == 'php_file')
		{
			if ($vbulletin->GPC['overwrite_filename'] != 2)
			{
				if ($fp = fopen('./vba_dyna_modules/' . $module['filename'], 'w'))
				{
					fputs($fp, $moduleinfo['file']);
					fclose($fp);
				}
			}

			if ($vbulletin->GPC['overwrite_edit_filename'] != 2)
			{
				if ($module['useredit'] AND $moduleinfo['file_edit'])
				{
					if ($fp = fopen('./vba_dyna_modules/edit_' . $module['filename'], 'w'))
					{
						fputs($fp, $moduleinfo['file_edit']);
						fclose($fp);
					}
				}
			}
		}

		// Delete the .module file
		unlink('./vba_dyna_modules/' . $modfile['name']);

		build_dyna_module_datastore();

		print_dyna_form_header('vba_dyna_admin_modules', 'editlayouts');
		print_table_header($vbphrase['vbulletin_message']);
		print_description_row(fetch_error('adv_dyna_module_saved_add_to_pages', $vbulletin->session->vars['sessionurl']));

		print_submit_row($vbphrase['continue'], '', 2, '', construct_button_code($vbphrase['go_back'], 'vba_dyna_admin_modules.php?do=download'));
	}
}

// ##### Edit Template ########################################################
if ($_REQUEST['do'] == 'edittemp')
{
	$vbulletin->input->clean_array_gpc('r', array(
		'thisstyleid' => TYPE_INT,
		'tempname' => TYPE_STR
	));

	$tempname = ADV_DYNA_PREFIX . '_' . $vbulletin->GPC['tempname'];

	$template = $db->query_first("
		SELECT templateid
		FROM " . TABLE_PREFIX . "template
		WHERE title = '" . $db->escape_string($tempname) . "'
			AND styleid = " . $vbulletin->GPC['thisstyleid']
	);

	print_cp_redirect('template.php?' . iif($template['templateid'], 'do=edit&templateid=' . $template['templateid'], 'do=add&dostyleid=' . $vbulletin->GPC['thisstyleid'] . '&title=' . $tempname));
}

print_cp_footer();

?>