<?php
// ++=========================================================================++
// || vBadvanced Dynamics v1.0.0 (vB 3.6 - vB 3.7)
// ||  2003-2007 vBadvanced.com - All Rights Reserved
// || This file may not be redistributed in whole or significant part.
// || http://vbadvanced.com
// ++ ========================================================================++

error_reporting(E_ALL & ~E_NOTICE);
define('VBA_SETTING_VERSION', '1.0.0');

// ##### Setting Groups
// Put them in order here, then we'll use the key + 1 of the array
$adv_settinggroups = array(
	'adv_global',
	'adv_dyna_title_paths',
	'adv_dyna_main',
	'adv_dyna_index',
	'adv_dyna_categorybit',
	'adv_dyna_browsecategory',
	'adv_dyna_showentry',
	'adv_dyna_newentry',
	'adv_dyna_attach',
	'adv_dyna_posting',
	'adv_dyna_usercats',
	'adv_dyna_moduleopts',
	'adv_dyna_seo',
	'adv_dyna_external'
);



// ##### Settings #############################################################
$mainsettings['adv_global'] = array(
	'global_header_replace' => array(
		'title' => 'Header Replacements',
		'description' => 'Here you may enter a list of filenames that may appear in your header that should be prefixed with your Forum\'s URL.',
		'value' => '',
		'optioncode' => 'textarea',
		'displayorder' => '1'
	),
	'global_navbar_replace' => array(
		'title' => 'Navbar Replacements',
		'description' => 'Here you may enter a list of filenames that should be prefixed with your Forum\'s URL.',
		'value' => 'memberlist.php
usercp.php
register.php
faq.php
calendar.php
search.php
login.php
forumdisplay.php
profile.php
private.php
subscription.php
member.php
online.php',
		'optioncode' => 'textarea',
		'displayorder' => '2'
	),
	'global_footer_replace' => array(
		'title' => 'Footer Replacements',
		'description' => 'Here you may enter a list of filenames that may appear in your footer that should be prefixed with your Forum\'s URL.',
		'value' => 'archive
sendmessage.php
profile.php',
		'optioncode' => 'textarea',
		'displayorder' => '3'
	)
);

$mainsettings['adv_dyna_modules_aboutme'] = array(
	'dyna_aboutme_pfields' => array(
			'title' => 'Custom Profile Fields to Display',
			'description' => 'Here you may select any custom profile fields that you would like to display in this block.<div>Tip: To select more than one field, or to remove a field, hold down the \'Ctrl\' key while selecting with your mouse.',
			'value' => 'N;', 
			'optioncode' => 'userfield',
			'displayorder' => '10',
			'serialize' => 1
		),
		'dyna_aboutme_avatar' => array(
			'title' => 'Show Avatar',
			'description' => 'Turn this option on if you wish to display the member\'s avatar in this module.',
			'value' => '1', 
			'optioncode' => 'yesno',
			'displayorder' => '20',
			'serialize' => 0
		),
		'dyna_aboutme_showstats' => array(
			'title' => 'Show Dynamics Stats',
			'description' => 'Turn this option on to show the number of entries, replies to the users entries, and number of times the user\'s entries have been viewed.',
			'value' => '1', 
			'optioncode' => 'yesno',
			'displayorder' => '30',
			'serialize' => 0
		),
		'dyna_aboutme_signature' => array(
			'title' => 'Show Signature',
			'description' => 'Turn this option on to display the user\'s signature in this module.',
			'value' => '1', 
			'optioncode' => 'yesno',
			'displayorder' => '40',
			'serialize' => 0
		),
		'dyna_aboutme_imicons' => array(
			'title' => 'Show Instant Messaging Icons',
			'description' => 'Turn this option on to display images for Skype, ICQ, AIM, MSN, and Yahoo! Messenger if the user has those fields filled out in their profile.',
			'value' => '1', 
			'optioncode' => 'yesno',
			'displayorder' => '50',
			'serialize' => 0
		),
		'dyna_aboutme_onlinestatus' => array(
			'title' => 'Show Online Status',
			'description' => 'Turn this option on to display an image next to the user\'s name indicating whether that user is currently online.',
			'value' => '1', 
			'optioncode' => 'yesno',
			'displayorder' => '60',
			'serialize' => 0
		),
		'dyna_aboutme_usertitle' => array(
			'title' => 'Show User Title',
			'description' => 'Turn this option on to show the user\'s title in this module.',
			'value' => '1', 
			'optioncode' => 'yesno',
			'displayorder' => '70',
			'serialize' => 0
		),
		'dyna_aboutme_rank' => array(
			'title' => 'Show User Rank',
			'description' => 'Turn this option on if you would like to show the user\'s rank in this module.',
			'value' => '1', 
			'optioncode' => 'yesno',
			'displayorder' => '80',
			'serialize' => 0
		),
		'dyna_aboutme_reputation' => array(
			'title' => 'Show Reputation',
			'description' => 'Turn this option on to display the user\'s signature in this module.',
			'value' => '1', 
			'optioncode' => 'yesno',
			'displayorder' => '90',
			'serialize' => 0
		),
		'dyna_aboutme_birthday' => array(
			'title' => 'Show Birthday',
			'description' => 'Turn this option on to show the user\'s birthday in this module.',
			'value' => '1', 
			'optioncode' => 'yesno',
			'displayorder' => '100',
			'serialize' => 0
		),
		'dyna_aboutme_joindate' => array(
			'title' => 'Show Join Date',
			'description' => 'Turn this option on to display the date that the member joined this forum.',
			'value' => '1', 
			'optioncode' => 'yesno',
			'displayorder' => '110',
			'serialize' => 0
		),
		'dyna_aboutme_pic' => array(
			'title' => 'Show Profile Picture',
			'description' => 'Turn this option on if you would like to show the user\'s profile picture within this module.',
			'value' => '1', 
			'optioncode' => 'yesno',
			'displayorder' => '120',
			'serialize' => 0
		),
		'dyna_aboutme_rss' => array(
			'title' => 'Show RSS Link',
			'description' => 'Turn this option on to display an image linking to an RSS feed of the member\'s entries.',
			'value' => '1', 
			'optioncode' => 'yesno',
			'displayorder' => '130',
			'serialize' => 0
		)
);

$mainsettings['adv_dyna_modules_calendar'] = array(
	'dyna_calendar_maxentriesday' => array(
			'title' => 'Maximum Number of Entries Per Day',
			'description' => 'The maximum number of entries to display when your mouse is held over a date that contains entries in the calendar. Set this option to 0 to display all entries.',
			'value' => '5', 
			'optioncode' => '',
			'displayorder' => '10',
			'serialize' => 0
		)
);

$mainsettings['adv_dyna_modules_catlist'] = array(
	'dyna_catlist_maxdepth' => array(
			'title' => 'Maximum Depth of Categories',
			'description' => 'The depth of categories to show in the category listings. If you set this option to \'2\', only the lowest category level and any child categories one level below that will be displayed.',
			'value' => '4', 
			'optioncode' => '',
			'displayorder' => '10',
			'serialize' => 0
		),
		'dyna_catlist_indent' => array(
			'title' => 'Lower Level Category Indention Spacing',
			'description' => 'The amount of space (in pixels) to pad lower level categories with to indent them and help show the category structure.',
			'value' => '10', 
			'optioncode' => '',
			'displayorder' => '20',
			'serialize' => 0
		),
		'dyna_catlist_level1' => array(
			'title' => 'Level 1 Mark',
			'description' => 'This is what will be displayed next to a top level category.',
			'value' => '', 
			'optioncode' => '',
			'displayorder' => '30',
			'serialize' => 0
		),
		'dyna_catlist_level2' => array(
			'title' => 'Level 2+ Mark',
			'description' => 'This is what will be displayed next to a category that is 2 or more levels deep.',
			'value' => '', 
			'optioncode' => '',
			'displayorder' => '40',
			'serialize' => 0
		),
		'dyna_catlist_maxlastlength' => array(
			'title' => 'Maximum Characters of Last Entry',
			'description' => 'The maximum number of characters that should be displayed for the title of the last entry before being cut off. Set this to 0 to show the entire title. Note that the \'Show Last Entry\' or \'Show Last Post\' options below must be enabled for this to have any effect.',
			'value' => '25', 
			'optioncode' => '',
			'displayorder' => '50',
			'serialize' => 0
		),
		'dyna_catlist_lastentry' => array(
			'title' => 'Show Last Entry',
			'description' => 'Turn this option on to display the last entry that was added to a category, along with it\'s date and author.',
			'value' => '0', 
			'optioncode' => 'yesno',
			'displayorder' => '60',
			'serialize' => 0
		),
		'dyna_catlist_lastpost' => array(
			'title' => 'Show Last Post',
			'description' => 'Turn this option on to display the last post to an entry in a category, along with it\'s date and author.',
			'value' => '0', 
			'optioncode' => 'yesno',
			'displayorder' => '70',
			'serialize' => 0
		),
		'dyna_catlist_entrycount' => array(
			'title' => 'Show Number of Entries',
			'description' => 'Turn this option on to display the number of entries a category contains.',
			'value' => '1', 
			'optioncode' => 'yesno',
			'displayorder' => '80',
			'serialize' => 0
		),
		'dyna_catlist_replycount' => array(
			'title' => 'Show Number of Replies',
			'description' => 'Turn this option on to display the number of replies a category contains.',
			'value' => '1', 
			'optioncode' => 'yesno',
			'displayorder' => '90',
			'serialize' => 0
		),
		'dyna_catlist_privcounts' => array(
			'title' => 'Show Entry / Post Counts in Restricted Categories',
			'description' => 'This option will display the number of entries/posts and last post/entry information in restricted categories even if the user does not have permission to view that category. When set to "No", users will see 0 entries/posts for categories they do have permission to view. Note that this only applies if any of the options above to show entries or replies are enabled.',
			'value' => '0', 
			'optioncode' => 'yesno',
			'displayorder' => '100',
			'serialize' => 0
		),
		'dyna_catlist_showcatowner' => array(
			'title' => 'Display Category Owner\'s Username',
			'description' => 'If a category owned by a member, this option will allow that member\'s name to be displayed under the category title.',
			'value' => '1', 
			'optioncode' => 'yesno',
			'displayorder' => '110',
			'serialize' => 0
		),
		'dyna_catlist_showonoff' => array(
			'title' => 'Show On/Off Indicators',
			'description' => 'This option will display a small image  in your category listings that indicates whether a category has new entries/posts.',
			'value' => '1', 
			'optioncode' => 'yesno',
			'displayorder' => '120',
			'serialize' => 0
		),
		'dyna_catlist_caticon' => array(
			'title' => 'Display Category Icons',
			'description' => 'Turn this option on if you would like to display the category\'s icon (if available) next to it\'s title.',
			'value' => '1', 
			'optioncode' => 'yesno',
			'displayorder' => '130',
			'serialize' => 0
		),
		'dyna_catlist_hideemptycats' => array(
			'title' => 'Hide Empty Categories',
			'description' => 'Turn this option on if you would like to hide empty categories in the category list. Note that these categories will still be visible when submitting entries and other relevant places.',
			'value' => '0', 
			'optioncode' => 'yesno',
			'displayorder' => '140',
			'serialize' => 0
		),
		'dyna_catlist_subcats' => array(
			'title' => 'Only Display Sub-Categories When Browsing A Category',
			'description' => 'Turn this option on if you would like to limit this module to only display sub-categories (if applicable) when active in a main category. Otherwise, leave it off to display all categories.',
			'value' => '0', 
			'optioncode' => 'yesno',
			'displayorder' => '150',
			'serialize' => 0
		)
);

$mainsettings['adv_dyna_modules_dyna_gbook'] = array(
	'dyna_gbook_limit' => array(
			'title' => 'Maximum Number of Replies to Display',
			'description' => 'The maximum number of replies to display within the module. When a member\'s guest book contains more replies than the number set here, a \'View More\' link will be shown to allow the rest to be seen.',
			'value' => '5', 
			'optioncode' => '',
			'displayorder' => '10',
			'serialize' => 0
		),
		'dyna_gbook_viewmore_limit' => array(
			'title' => 'Maximum Replies Per Page on the \'View More\' Link',
			'description' => 'The maximum number of replies to display before splitting into multiple pages on the \'View More\' link.',
			'value' => '25', 
			'optioncode' => '',
			'displayorder' => '20',
			'serialize' => 0
		),
		'dyna_gbook_reply_length' => array(
			'title' => 'Maximum Length of Replies',
			'description' => 'The maximum number of characters (including BB Code) to allow in guest book replies. Set this option to 0 for no limit.',
			'value' => '1500', 
			'optioncode' => '',
			'displayorder' => '30',
			'serialize' => 0
		),
		'dyna_gbook_titles' => array(
			'title' => 'Allow Guest Book Titles',
			'description' => 'Turn this option on if you would like to allow users to enter a title with their replies.',
			'value' => '0', 
			'optioncode' => 'yesno',
			'displayorder' => '40',
			'serialize' => 0
		),
		'dyna_gbook_html' => array(
			'title' => 'Allow HTML in Replies',
			'description' => 'Allow HTML in guest book replies?
<div>(<storng>Strongly Not Recommended</strong>)</div>',
			'value' => '0', 
			'optioncode' => 'yesno',
			'displayorder' => '50',
			'serialize' => 0
		),
		'dyna_gbook_bbcode' => array(
			'title' => 'Allow BB Code in Replies',
			'description' => 'Turn this option on to allow BB code in guest book replies.',
			'value' => '1', 
			'optioncode' => 'yesno',
			'displayorder' => '60',
			'serialize' => 0
		),
		'dyna_gbook_bbimgcode' => array(
			'title' => 'Allow [IMG] Code in Replies',
			'description' => 'Turn this option on if you would like to allow your members to use the [IMG] BB Code tag in their replies.',
			'value' => '1', 
			'optioncode' => 'yesno',
			'displayorder' => '70',
			'serialize' => 0
		),
		'dyna_gbook_smilies' => array(
			'title' => 'Allow Smilies in Replies',
			'description' => 'Turn this option on if you would like to allow users to use smilies with their replies.',
			'value' => '1', 
			'optioncode' => 'yesno',
			'displayorder' => '80',
			'serialize' => 0
		),
		'dyna_gbook_icons' => array(
			'title' => 'Allow Icons in Replies',
			'description' => 'Turn this option on if you would like to allow your users to select an icon with their posts.',
			'value' => '1', 
			'optioncode' => 'yesno',
			'displayorder' => '90',
			'serialize' => 0
		),
		'dyna_gbook_update_postcount' => array(
			'title' => 'Count Replies in Guest Books Towards Postcounts',
			'description' => 'Turn this option on if you would like replies made in this module to affect a user\'s postcount.',
			'value' => '0', 
			'optioncode' => 'yesno',
			'displayorder' => '100',
			'serialize' => 0
		),
		'dyna_gbook_catlimit' => array(
			'title' => 'Limit Replies By Category',
			'description' => 'Turn this option on if you would like to only display replies that were made within the same category the user is browing. Otherwise, all guest book replies will be displayed.',
			'value' => '1', 
			'optioncode' => 'yesno',
			'displayorder' => '110',
			'serialize' => 0
		),
		'dyna_gbook_catlimit_viewmore' => array(
			'title' => 'Limit Replies By Category in \'View More\' link',
			'description' => 'Turn this option on if you would still like to limit replies by category when clicking the \'View More\' link. Otherwise, turn it off to show all replies, regardless of what category they were made in.',
			'value' => '1', 
			'optioncode' => 'yesno',
			'displayorder' => '120',
			'serialize' => 0
		)
);

$mainsettings['adv_dyna_modules_dyna_mycats'] = array(
	'dyna_mycats_fields' => array(
			'title' => 'Fields to Display',
			'description' => 'Here you may select which items will be displayed with the category listings in this module.',
			'value' => 'a:6:{i:0;s:4:"desc";i:1;s:7:"entries";i:2;s:7:"replies";i:3;s:7:"caticon";i:4;s:10:"last_entry";i:5;s:10:"last_reply";}', 
			'optioncode' => '<table width=\\"100%\\">
<tr>
<td valign=\\"top\\" class=\\"smallfont\\" style=\\"white-space: nowrap\\">
	<input type=\\"checkbox\\" name=\\"" . $name . "[]\\" id=\\"setting_" . $grouptitle . "_$setting[varname]_desc\\"value=\\"desc\\" " . iif(in_array(\'desc\', $setting[\'value\']), \'checked=\\"checked\\"\') . " /> <label for=\\"setting_" . $grouptitle . "_$setting[varname]_desc\\">" . $vbphrase[description] . "</label><br />

	<input type=\\"checkbox\\" name=\\"" . $name . "[]\\" id=\\"setting_" . $grouptitle . "_$setting[varname]_entries\\" value=\\"entries\\" " . iif(in_array(\'entries\', $setting[\'value\']), \'checked=\\"checked\\"\') . " /> <label for=\\"setting_" . $grouptitle . "_$setting[varname]_entries\\">$vbphrase[entries]</label><br />

	<input type=\\"checkbox\\" name=\\"" . $name . "[]\\" id=\\"setting_" . $grouptitle . "_$setting[varname]_replies\\" value=\\"replies\\" " . iif(in_array(\'replies\', $setting[\'value\']), \'checked=\\"checked\\"\') . " /> <label for=\\"setting_" . $grouptitle . "_$setting[varname]_replies\\">$vbphrase[replies]</label><br />

</td>

<td valign=\\"top\\" class=\\"smallfont\\" style=\\"white-space: nowrap\\">

	<input type=\\"checkbox\\" name=\\"" . $name . "[]\\" id=\\"setting_" . $grouptitle . "_$setting[varname]_caticon\\" value=\\"caticon\\" " . iif(in_array(\'caticon\', $setting[\'value\']), \'checked=\\"checked\\"\') . " /> <label for=\\"setting_" . $grouptitle . "_$setting[varname]_caticon\\">" . construct_phrase($vbphrase[\'x_icon\'], $vbphrase[\'category\']) . "</label><br />

	<input type=\\"checkbox\\" name=\\"" . $name . "[]\\" id=\\"setting_" . $grouptitle . "_$setting[varname]_last_entry\\"value=\\"last_entry\\" " . iif(in_array(\'last_entry\', $setting[\'value\']), \'checked=\\"checked\\"\') . " /> <label for=\\"setting_" . $grouptitle . "_$setting[varname]_last_entry\\">" . construct_phrase($vbphrase[last_x], $vbphrase[\'entry\']) . "</label><br />

	<input type=\\"checkbox\\" name=\\"" . $name . "[]\\" id=\\"setting_" . $grouptitle . "_$setting[varname]_last_reply\\"value=\\"last_reply\\" " . iif(in_array(\'last_reply\', $setting[\'value\']), \'checked=\\"checked\\"\') . " /> <label for=\\"setting_" . $grouptitle . "_$setting[varname]_last_reply\\">" . $vbphrase[last_reply] . "</label><br />

</td>
</tr>
</table>',
			'displayorder' => '10',
			'serialize' => 1
		),
		'dyna_mycats_onlysubs' => array(
			'title' => 'Only Display Sub-Categories',
			'description' => 'Turn this option on if you would only like to display the sub-categories of the category being viewed that are also owned by the category owner. Otherwise, turn this option off to display all categories owned by the user.',
			'value' => '0', 
			'optioncode' => 'yesno',
			'displayorder' => '20',
			'serialize' => 0
		)
);

$mainsettings['adv_dyna_modules_dyna_stats'] = array(
	'dyna_stats_prefixtitle' => array(
			'title' => 'Prefix Module Title With vBa Dynamics Title',
			'description' => 'Turn this option on of you would like to prefix the title of this moudle with the title you have set for your \'Dynamics Title\' setting (under the &quot;Titles,  URL\'s, and Terms&quot; group in your main vBa Dynamics settings).',
			'value' => '1', 
			'optioncode' => 'yesno',
			'displayorder' => '10',
			'serialize' => 0
		)
);

$mainsettings['adv_dyna_modules_featured'] = array(
	'dyna_newrand_limit' => array(
			'title' => 'Number of Entries to Display',
			'description' => 'The maximum number of new entries you would like to display.',
			'value' => '5', 
			'optioncode' => '',
			'displayorder' => '10',
			'serialize' => 0
		),
		'dyna_newrand_maxchars' => array(
			'title' => 'Maximum Characters of Entry Title to Display',
			'description' => 'The maximum number of characters that should be displayed before the rest of a entry\'s title is replaced by \'...\'. Set this to 0 to display the entire title.',
			'value' => '25', 
			'optioncode' => '',
			'displayorder' => '20',
			'serialize' => 0
		),
		'dyna_newrand_maxwordchars' => array(
			'title' => 'Maximum Characters of Each Word',
			'description' => 'The maximum number of characters a word in the entry\'s title may contain. Any entries that contain a word longer than the value set here in their title will be trimmed to that value. This helps to prevent threads with extremely long words from stretching out the page.',
			'value' => '15', 
			'optioncode' => '',
			'displayorder' => '30',
			'serialize' => 0
		),
		'dyna_newrand_orderby' => array(
			'title' => 'Order Entries By',
			'description' => 'The field in which entries should be ordered by.',
			'value' => 'dateline', 
			'optioncode' => '<select name=\\"" . $name . "\\">
<option value=\\"dateline\\"" . iif($setting[\'value\'] == \'dateline\', \' selected="selected"\') . ">" . $vbphrase[\'date\'] . "</option>
<option value=\\"rand\\"" . iif($setting[\'value\'] == \'rand\', \' selected="selected"\') . " />" . $vbphrase[\'random\'] . "</option>
</select>',
			'displayorder' => '40',
			'serialize' => 0
		),
		'dyna_newrand_templatename' => array(
			'title' => 'Template to Use',
			'description' => 'By selecting the template type to use you can change the size of the module.',
			'value' => 'simple', 
			'optioncode' => 'entrybittemplate',
			'displayorder' => '50',
			'serialize' => 0
		),
		'dyna_newrand_dynatemp' => array(
			'title' => 'Enable Dynamic Template Resizing',
			'description' => 'When enabled, this option will automatically cause this module to use the \'Lean\' entrybits template if the module is placed in a column that is not wide enough to use the template specified above. This is especially useful if you allow your members to customize the modules on their pages.',
			'value' => '1', 
			'optioncode' => 'yesno',
			'displayorder' => '60',
			'serialize' => 0
		),
		'dyna_newrand_incsticky' => array(
			'title' => 'Include Sticky Entries',
			'description' => 'Turn this option on if you would also like to automatically include \'sticky\' entries.',
			'value' => '1', 
			'optioncode' => 'yesno',
			'displayorder' => '70',
			'serialize' => 0
		),
		'dyna_newrand_limituser' => array(
			'title' => 'Limit to Specific Member if Applicable',
			'description' => 'Turn this option on to only display entries submitted by a specific member when viewing that member\'s entries or categories.',
			'value' => '0', 
			'optioncode' => 'yesno',
			'displayorder' => '80',
			'serialize' => 0
		),
		'dyna_newrand_entrybitfields' => array(
			'title' => 'Entrybit Elements',
			'description' => 'Here you may select which items will be displayed within the entrybits for this module.',
			'value' => 'a:16:{i:0;s:7:"replies";i:1;s:5:"views";i:2;s:8:"category";i:3;s:6:"folder";i:4;s:7:"caticon";i:5;s:6:"rating";i:6;s:10:"last_reply";i:7;s:4:"icon";i:8;s:11:"firstattach";i:9;s:7:"preview";i:10;s:6:"avatar";i:11;s:13:"online_status";i:12;s:10:"user_title";i:13;s:9:"user_rank";i:14;s:12:"reply_button";i:15;s:11:"edit_button";}', 
			'optioncode' => 'entrybitelements',
			'displayorder' => '90',
			'serialize' => 1
		),
		'dyna_newrand_cfields' => array(
			'title' => 'Custom Fields to Display',
			'description' => 'Here you may select any custom fields that you wish to display within the entrybits.',
			'value' => 'N;', 
			'optioncode' => 'cfieldcheckbox',
			'displayorder' => '100',
			'serialize' => 1
		)
);

$mainsettings['adv_dyna_modules_generic_list'] = array(
	'dyna_list_inputs' => array(
			'title' => 'Number of Inputs to Show',
			'description' => 'The number of inputs to show for this list.',
			'value' => '20', 
			'optioncode' => '',
			'displayorder' => '10',
			'serialize' => 0
		),
		'dyna_list_allow_smilies' => array(
			'title' => 'Allow Smilies in List Items',
			'description' => 'Turn this option on if you would like to allow smilies in list items.',
			'value' => '1', 
			'optioncode' => 'yesno',
			'displayorder' => '20',
			'serialize' => 0
		),
		'dyna_list_allow_bbcode' => array(
			'title' => 'Allow BB Code in List Items',
			'description' => 'Turn this option on if you would like to allow BB code in list items.',
			'value' => '1', 
			'optioncode' => 'yesno',
			'displayorder' => '30',
			'serialize' => 0
		),
		'dyna_list_allow_img' => array(
			'title' => 'Allow [IMG] Tag in List Items',
			'description' => 'Turn this option on if you would like to allow the [IMG] BB code in list items.',
			'value' => '0', 
			'optioncode' => 'yesno',
			'displayorder' => '40',
			'serialize' => 0
		)
);

$mainsettings['adv_dyna_modules_mybuddies'] = array(
	'dyna_buddies_limit' => array(
			'title' => 'Maximum Number of Buddies to Display',
			'description' => 'The maximum number of buddies that you wish to display in this module.',
			'value' => '20', 
			'optioncode' => '',
			'displayorder' => '10',
			'serialize' => 0
		),
		'dyna_buddies_avatar' => array(
			'title' => 'Show Buddy\'s Avatar',
			'description' => 'Turn this option on if you wish to display avatars in this module.',
			'value' => '1', 
			'optioncode' => 'yesno',
			'displayorder' => '20',
			'serialize' => 0
		),
		'dyna_buddies_entrylink' => array(
			'title' => 'Show &quot;My Entries&quot; Link',
			'description' => 'Turn this option on if you wish to display a link to the user\'s entries.',
			'value' => '1', 
			'optioncode' => 'yesno',
			'displayorder' => '30',
			'serialize' => 0
		),
		'dyna_buddies_onlinestatus' => array(
			'title' => 'Show Online Status',
			'description' => 'Turn this option on to display an image next to the user\'s name indicating whether that user is currently online.',
			'value' => '1', 
			'optioncode' => 'yesno',
			'displayorder' => '40',
			'serialize' => 0
		),
		'dyna_buddies_usertitle' => array(
			'title' => 'Show User Title',
			'description' => 'Turn this option on to show the user\'s title in this module.',
			'value' => '1', 
			'optioncode' => 'yesno',
			'displayorder' => '50',
			'serialize' => 0
		)
);

$mainsettings['adv_dyna_modules_myfavorites'] = array(
	'dyna_newrand_limit' => array(
			'title' => 'Number of Entries to Display',
			'description' => 'The maximum number of new entries you would like to display.',
			'value' => '10', 
			'optioncode' => '',
			'displayorder' => '10',
			'serialize' => 0
		),
		'dyna_newrand_maxchars' => array(
			'title' => 'Maximum Characters of Entry Title to Display',
			'description' => 'The maximum number of characters that should be displayed before the rest of a entry\'s title is replaced by \'...\'. Set this to 0 to display the entire title.',
			'value' => '25', 
			'optioncode' => '',
			'displayorder' => '20',
			'serialize' => 0
		),
		'dyna_newrand_maxwordchars' => array(
			'title' => 'Maximum Characters of Each Word',
			'description' => 'The maximum number of characters a word in the entry\'s title may contain. Any entries that contain a word longer than the value set here in their title will be trimmed to that value. This helps to prevent threads with extremely long words from stretching out the page.',
			'value' => '15', 
			'optioncode' => '',
			'displayorder' => '30',
			'serialize' => 0
		),
		'dyna_newrand_orderby' => array(
			'title' => 'Order Entries By',
			'description' => 'The field in which entries should be ordered by.',
			'value' => 'dateline', 
			'optioncode' => '<select name=\\"" . $name . "\\">
<option value=\\"dateline\\"" . iif($setting[\'value\'] == \'dateline\', \' selected="selected"\') . ">" . $vbphrase[\'date\'] . "</option>
<option value=\\"rand\\"" . iif($setting[\'value\'] == \'rand\', \' selected="selected"\') . " />" . $vbphrase[\'random\'] . "</option>
</select>',
			'displayorder' => '40',
			'serialize' => 0
		),
		'dyna_newrand_excludecats' => array(
			'title' => 'Categories to Exclude',
			'description' => 'Here you may select any category(ies) that you wish to exclude from being displayed in this module.<br /><br />To select more than one category or to de-select a category, hold down your \'Ctrl\' key while selecting the categories with your mouse.',
			'value' => 'N;', 
			'optioncode' => 'catselect',
			'displayorder' => '50',
			'serialize' => 1
		),
		'dyna_newrand_templatename' => array(
			'title' => 'Template to Use',
			'description' => 'By selecting the template type to use you can change the size of the module.',
			'value' => 'expanded', 
			'optioncode' => 'entrybittemplate',
			'displayorder' => '60',
			'serialize' => 0
		),
		'dyna_newrand_dynatemp' => array(
			'title' => 'Enable Dynamic Template Resizing',
			'description' => 'When enabled, this option will automatically cause this module to use the \'Lean\' entrybits template if the module is placed in a column that is not wide enough to use the template specified above. This is especially useful if you allow your members to customize the modules on their pages.',
			'value' => '1', 
			'optioncode' => 'yesno',
			'displayorder' => '70',
			'serialize' => 0
		),
		'dyna_newrand_entrybitfields' => array(
			'title' => 'Entrybit Elements',
			'description' => 'Here you may select which items will be displayed within the entrybits for this module.',
			'value' => 'a:16:{i:0;s:7:"replies";i:1;s:5:"views";i:2;s:8:"category";i:3;s:6:"folder";i:4;s:7:"caticon";i:5;s:6:"rating";i:6;s:10:"last_reply";i:7;s:4:"icon";i:8;s:11:"firstattach";i:9;s:7:"preview";i:10;s:6:"avatar";i:11;s:13:"online_status";i:12;s:10:"user_title";i:13;s:9:"user_rank";i:14;s:12:"reply_button";i:15;s:11:"edit_button";}', 
			'optioncode' => 'entrybitelements',
			'displayorder' => '80',
			'serialize' => 1
		),
		'dyna_newrand_cfields' => array(
			'title' => 'Custom Fields to Display',
			'description' => 'Here you may select any custom fields that you wish to display within the entrybits.',
			'value' => 'N;', 
			'optioncode' => 'cfieldcheckbox',
			'displayorder' => '90',
			'serialize' => 1
		)
);

$mainsettings['adv_dyna_modules_mylinks'] = array(
	'dyna_mylinks_inputs' => array(
			'title' => 'Number of Inputs to Show',
			'description' => 'The number of inputs to show, and maximum number of links allowed in this module.',
			'value' => '20', 
			'optioncode' => '',
			'displayorder' => '10',
			'serialize' => 0
		),
		'dyna_mylinks_newwin' => array(
			'title' => 'Open Links in New Window',
			'description' => 'Turn this option on if you would like links added to this module to open in a new window.',
			'value' => '1', 
			'optioncode' => 'yesno',
			'displayorder' => '20',
			'serialize' => 0
		),
		'dyna_mylinks_allow_smilies' => array(
			'title' => 'Allow Smilies in Link Titles',
			'description' => 'Turn this option on if you would like to allow smilies in link titles.',
			'value' => '0', 
			'optioncode' => 'yesno',
			'displayorder' => '30',
			'serialize' => 0
		),
		'dyna_mylinks_allow_bbcode' => array(
			'title' => 'Allow BB Code in Link Titles',
			'description' => 'Turn this option on if you would like to allow BB code in link titles.',
			'value' => '0', 
			'optioncode' => 'yesno',
			'displayorder' => '40',
			'serialize' => 0
		),
		'dyna_mylinks_allow_img' => array(
			'title' => 'Allow [IMG] Tag in Link Titles',
			'description' => 'Turn this option on if you would like to allow the [IMG] BB code in link titles.',
			'value' => '0', 
			'optioncode' => 'yesno',
			'displayorder' => '50',
			'serialize' => 0
		)
);

$mainsettings['adv_dyna_modules_newposts'] = array(
	'dyna_newposts_limit' => array(
			'title' => 'Number of Posts to Display',
			'description' => 'The maximum number of new posts to display.',
			'value' => '5', 
			'optioncode' => '',
			'displayorder' => '10',
			'serialize' => 0
		),
		'dyna_newposts_maxchar' => array(
			'title' => 'Maximum Characters of Reply to Display',
			'description' => 'The maximum number of characters that should be displayed before the rest of the reply is replaced by \'...\'. Set this to 0 to display the entire message.',
			'value' => '200', 
			'optioncode' => '',
			'displayorder' => '20',
			'serialize' => 0
		),
		'dyna_newposts_excludecats' => array(
			'title' => 'Categories to Exclude',
			'description' => 'If you would like to exclude any of your categories from appearing in this module, you may do so by selecting those categories here.
<div>Tip: To select more than one field, or to remove a field, hold down the \'Ctrl\' key while selecting with your mouse.</div>',
			'value' => 'N;', 
			'optioncode' => 'catselect',
			'displayorder' => '30',
			'serialize' => 1
		),
		'dyna_newposts_limituser' => array(
			'title' => 'Limit to Specific Member if Applicable',
			'description' => 'Turn this option on to only display replies made by a specific member when viewing that member\'s entries or categories.',
			'value' => '0', 
			'optioncode' => 'yesno',
			'displayorder' => '40',
			'serialize' => 0
		),
		'dyna_newrand_limitcat' => array(
			'title' => 'Limit to Specific Category if Applicable',
			'description' => 'Turn this option on if you would like for this module to only display entries from the category you are viewing. When enabled outside of a cateogry, this module will still display entries from all allowed categories.',
			'value' => '0', 
			'optioncode' => 'yesno',
			'displayorder' => '50',
			'serialize' => 0
		)
);

$mainsettings['adv_dyna_modules_quicknav'] = array(
	'dyna_quicknav_actlinks' => array(
			'title' => 'Active Default Links',
			'description' => 'This option allows you to enable/disable the default links in this module.',
			'value' => 'a:8:{i:0;s:4:"home";i:1;s:7:"mystuff";i:2;s:11:"submitentry";i:3;s:10:"newentries";i:4;s:8:"newposts";i:5;s:10:"popentries";i:6;s:6:"search";i:7;s:10:"moderation";}', 
			'optioncode' => '<table width=\\"100%\\">
<tr>
<td valign=\\"top\\">
	<input type=\\"checkbox\\" name=\\"" . $name . "[]\\" id=\\"setting_" . $grouptitle . "_$setting[varname]_home\\" value=\\"home\\" " . iif(in_array(\'home\', $setting[\'value\']), \'checked=\\"checked\\"\') . " /> <span class=\\"smallfont\\"><label for=\\"setting_" . $grouptitle . "_$setting[varname]_home\\">" . $vbphrase[home] . "</label></span><br />

	<input type=\\"checkbox\\" name=\\"" . $name . "[]\\" id=\\"setting_" . $grouptitle . "_$setting[varname]_mystuff\\" value=\\"mystuff\\" " . iif(in_array(\'mystuff\', $setting[\'value\']), \'checked=\\"checked\\"\') . " /> <span class=\\"smallfont\\"><label for=\\"setting_" . $grouptitle . "_$setting[varname]_mystuff\\">$vbphrase[my_stuff]</label></span><br />

	<input type=\\"checkbox\\" name=\\"" . $name . "[]\\" id=\\"setting_" . $grouptitle . "_$setting[varname]_submitentry\\" value=\\"submitentry\\" " . iif(in_array(\'submitentry\', $setting[\'value\']), \'checked=\\"checked\\"\') . " /> <span class=\\"smallfont\\"><label for=\\"setting_" . $grouptitle . "_$setting[varname]_submitentry\\">" . construct_phrase($vbphrase[\'submit_x\'], $vbphrase[\'entry\']) . "</label></span><br />

	<input type=\\"checkbox\\" name=\\"" . $name . "[]\\" id=\\"setting_" . $grouptitle . "_$setting[varname]_newentries\\" value=\\"newentries\\" " . iif(in_array(\'newentries\', $setting[\'value\']), \'checked=\\"checked\\"\') . " /> <span class=\\"smallfont\\"><label for=\\"setting_" . $grouptitle . "_$setting[varname]_newentries\\">" . construct_phrase($vbphrase[\'new_x\'], $vbphrase[\'entries\']) . "</label></span><br />

</td>
<td valign=\\"top\\">

	<input type=\\"checkbox\\" name=\\"" . $name . "[]\\" id=\\"setting_" . $grouptitle . "_$setting[varname]_newposts\\" value=\\"newposts\\" " . iif(in_array(\'newposts\', $setting[\'value\']), \'checked=\\"checked\\"\') . " /> <span class=\\"smallfont\\"><label for=\\"setting_" . $grouptitle . "_$setting[varname]_newposts\\">" . construct_phrase($vbphrase[\'new_x\'], $vbphrase[\'posts\']) . "</label></span><br />

	<input type=\\"checkbox\\" name=\\"" . $name . "[]\\" id=\\"setting_" . $grouptitle . "_$setting[varname]_popentries\\" value=\\"popentries\\" " . iif(in_array(\'popentries\', $setting[\'value\']), \'checked=\\"checked\\"\') . " /> <span class=\\"smallfont\\"><label for=\\"setting_" . $grouptitle . "_$setting[varname]_popentries\\">$vbphrase[whats_popular]</label></span><br />


	<input type=\\"checkbox\\" name=\\"" . $name . "[]\\" id=\\"setting_" . $grouptitle . "_$setting[varname]_search\\"value=\\"search\\" " . iif(in_array(\'search\', $setting[\'value\']), \'checked=\\"checked\\"\') . " /> <span class=\\"smallfont\\"><label for=\\"setting_" . $grouptitle . "_$setting[varname]_search\\">$vbphrase[advanced_search]</label></span><br />

	<input type=\\"checkbox\\" name=\\"" . $name . "[]\\" id=\\"setting_" . $grouptitle . "_$setting[varname]_moderation\\"value=\\"moderation\\" " . iif(in_array(\'moderation\', $setting[\'value\']), \'checked=\\"checked\\"\') . " /> <span class=\\"smallfont\\"><label for=\\"setting_" . $grouptitle . "_$setting[varname]_moderation\\">$vbphrase[moderate_new]</label></span><br />

</td>
</tr>
</table>',
			'displayorder' => '10',
			'serialize' => 1
		),
		'dyna_quicknav_addlinks' => array(
			'title' => 'Additional Custom Links (Displayed Above Default Links)',
			'description' => 'Here you may enter any additional links which you would like to display in this module above the default links. Simply enter the title of the page in the first column and the URL it should link to in the second.<br />
Note that once you fill in the 5 spaces for links below, you may save the module to add more links.',
			'value' => 'a:0:{}', 
			'optioncode' => 'pageselect_add',
			'displayorder' => '20',
			'serialize' => 1
		),
		'dyna_quicknav_addlinks_below' => array(
			'title' => 'Additional Custom Links (Displayed Below Default Links)',
			'description' => 'Here you may enter any additional links which you would like to display in this module below the default links. Simply enter the title of the page in the first column and the URL it should link to in the second.<br />
Note that once you fill in the 5 spaces for links below, you may save the module to add more links.',
			'value' => 'a:0:{}', 
			'optioncode' => 'pageselect_add',
			'displayorder' => '30',
			'serialize' => 1
		),
		'dyna_quicknav_level1' => array(
			'title' => 'Level 1 Mark',
			'description' => 'This is what will be displayed next to a link if the &quot;Level&quot; setting is set to 1.',
			'value' => '', 
			'optioncode' => '',
			'displayorder' => '40',
			'serialize' => 0
		),
		'dyna_quicknav_level2' => array(
			'title' => 'Level 2+ Mark',
			'description' => 'This is what will be displayed next to a link if the &quot;Level&quot; setting is set to 2 or more.',
			'value' => '&rsaquo;', 
			'optioncode' => '',
			'displayorder' => '50',
			'serialize' => 0
		)
);

$mainsettings['adv_dyna_modules_randomentries'] = array(
	'dyna_newrand_limit' => array(
			'title' => 'Number of Entries to Display',
			'description' => 'The maximum number of new entries you would like to display.',
			'value' => '5', 
			'optioncode' => '',
			'displayorder' => '10',
			'serialize' => 0
		),
		'dyna_newrand_maxchars' => array(
			'title' => 'Maximum Characters of Entry Title to Display',
			'description' => 'The maximum number of characters that should be displayed before the rest of a entry\'s title is replaced by \'...\'. Set this to 0 to display the entire title.',
			'value' => '25', 
			'optioncode' => '',
			'displayorder' => '20',
			'serialize' => 0
		),
		'dyna_newrand_maxwordchars' => array(
			'title' => 'Maximum Characters of Each Word',
			'description' => 'The maximum number of characters a word in the entry\'s title may contain. Any entries that contain a word longer than the value set here in their title will be trimmed to that value. This helps to prevent threads with extremely long words from stretching out the page.',
			'value' => '15', 
			'optioncode' => '',
			'displayorder' => '30',
			'serialize' => 0
		),
		'dyna_newrand_orderby' => array(
			'title' => 'Order Entries By',
			'description' => 'The field in which entries should be ordered by.',
			'value' => 'rand', 
			'optioncode' => '<select name=\\"" . $name . "\\">
<option value=\\"dateline\\"" . iif($setting[\'value\'] == \'dateline\', \' selected="selected"\') . ">" . $vbphrase[\'date\'] . "</option>
<option value=\\"rand\\"" . iif($setting[\'value\'] == \'rand\', \' selected="selected"\') . " />" . $vbphrase[\'random\'] . "</option>
</select>',
			'displayorder' => '40',
			'serialize' => 0
		),
		'dyna_newrand_excludecats' => array(
			'title' => 'Categories to Exclude',
			'description' => 'Here you may select any category(ies) that you wish to exclude from being displayed in this module.<br /><br />To select more than one category or to de-select a category, hold down your \'Ctrl\' key while selecting the categories with your mouse.',
			'value' => 'N;', 
			'optioncode' => 'catselect',
			'displayorder' => '50',
			'serialize' => 1
		),
		'dyna_newrand_templatename' => array(
			'title' => 'Template to Use',
			'description' => 'By selecting the template type to use you can change the size of the module.',
			'value' => 'expanded', 
			'optioncode' => 'entrybittemplate',
			'displayorder' => '60',
			'serialize' => 0
		),
		'dyna_newrand_dynatemp' => array(
			'title' => 'Enable Dynamic Template Resizing',
			'description' => 'When enabled, this option will automatically cause this module to use the \'Lean\' entrybits template if the module is placed in a column that is not wide enough to use the template specified above. This is especially useful if you allow your members to customize the modules on their pages.',
			'value' => '1', 
			'optioncode' => 'yesno',
			'displayorder' => '70',
			'serialize' => 0
		),
		'dyna_newrand_limituser' => array(
			'title' => 'Limit to Specific Member if Applicable',
			'description' => 'Turn this option on to only display entries submitted by a specific member when viewing that member\'s entries or categories.',
			'value' => '0', 
			'optioncode' => 'yesno',
			'displayorder' => '80',
			'serialize' => 0
		),
		'dyna_newrand_entrybitfields' => array(
			'title' => 'Entrybit Elements',
			'description' => 'Here you may select which items will be displayed within the entrybits for this module.',
			'value' => 'a:15:{i:0;s:7:"replies";i:1;s:5:"views";i:2;s:8:"category";i:3;s:6:"folder";i:4;s:7:"caticon";i:5;s:6:"rating";i:6;s:10:"last_reply";i:7;s:4:"icon";i:8;s:11:"firstattach";i:9;s:7:"preview";i:10;s:6:"avatar";i:11;s:13:"online_status";i:12;s:13:"entry_options";i:13;s:12:"reply_button";i:14;s:11:"edit_button";}', 
			'optioncode' => 'entrybitelements',
			'displayorder' => '90',
			'serialize' => 1
		),
		'dyna_newrand_cfields' => array(
			'title' => 'Custom Fields to Display',
			'description' => 'Here you may select any custom fields that you wish to display within the entrybits.',
			'value' => 'N;', 
			'optioncode' => 'cfieldcheckbox',
			'displayorder' => '100',
			'serialize' => 1
		)
);

$mainsettings['adv_dyna_modules_search'] = array(
	'dyna_search_dfields' => array(
			'title' => 'Default Search Fields to Display',
			'description' => 'Here you may select any default fields that you would like to display within the search module, allowing your members to further limit their searches based on these fields.',
			'value' => 'N;', 
			'optioncode' => 'defsearchfields',
			'displayorder' => '10',
			'serialize' => 1
		),
		'dyna_search_cfields' => array(
			'title' => 'Custom Fields to Display',
			'description' => 'Here you may select any of your custom fields that you would like to display within the search module, allowing your members to further limit their searches based on these fields.',
			'value' => 'N;', 
			'optioncode' => 'cfieldcheckbox',
			'displayorder' => '20',
			'serialize' => 1
		)
);

$mainsettings['adv_dyna_modules_whatsnew'] = array(
	'dyna_newrand_limit' => array(
			'title' => 'Number of Entries to Display',
			'description' => 'The maximum number of new entries you would like to display.',
			'value' => '5', 
			'optioncode' => '',
			'displayorder' => '10',
			'serialize' => 0
		),
		'dyna_newrand_maxchars' => array(
			'title' => 'Maximum Characters of Entry Title to Display',
			'description' => 'The maximum number of characters that should be displayed before the rest of a entry\'s title is replaced by \'...\'. Set this to 0 to display the entire title.',
			'value' => '25', 
			'optioncode' => '',
			'displayorder' => '20',
			'serialize' => 0
		),
		'dyna_newrand_maxwordchars' => array(
			'title' => 'Maximum Characters of Each Word',
			'description' => 'The maximum number of characters a word in the entry\'s title may contain. Any entries that contain a word longer than the value set here in their title will be trimmed to that value. This helps to prevent threads with extremely long words from stretching out the page.',
			'value' => '15', 
			'optioncode' => '',
			'displayorder' => '30',
			'serialize' => 0
		),
		'dyna_newrand_orderby' => array(
			'title' => 'Order Entries By',
			'description' => 'The field in which entries should be ordered by.',
			'value' => 'dateline', 
			'optioncode' => '<select name=\\"" . $name . "\\">
<option value=\\"dateline\\"" . iif($setting[\'value\'] == \'dateline\', \' selected="selected"\') . ">" . $vbphrase[\'date\'] . "</option>
<option value=\\"rand\\"" . iif($setting[\'value\'] == \'rand\', \' selected="selected"\') . " />" . $vbphrase[\'random\'] . "</option>
</select>',
			'displayorder' => '40',
			'serialize' => 0
		),
		'dyna_newrand_templatename' => array(
			'title' => 'Template to Use',
			'description' => 'By selecting the template type to use you can change the size of the module.',
			'value' => 'simple', 
			'optioncode' => 'entrybittemplate',
			'displayorder' => '50',
			'serialize' => 0
		),
		'dyna_newrand_dynatemp' => array(
			'title' => 'Enable Dynamic Template Resizing',
			'description' => 'When enabled, this option will automatically cause this module to use the \'Lean\' entrybits template if the module is placed in a column that is not wide enough to use the template specified above. This is especially useful if you allow your members to customize the modules on their pages.',
			'value' => '1', 
			'optioncode' => 'yesno',
			'displayorder' => '60',
			'serialize' => 0
		),
		'dyna_newrand_excludecats' => array(
			'title' => 'Categories to Exclude',
			'description' => 'Here you may select any category(ies) that you wish to exclude from being displayed in this module.<br /><br />To select more than one category or to de-select a category, hold down your \'Ctrl\' key while selecting the categories with your mouse.',
			'value' => 'N;', 
			'optioncode' => 'catselect',
			'displayorder' => '70',
			'serialize' => 1
		),
		'dyna_newrand_limituser' => array(
			'title' => 'Limit to Specific Member if Applicable',
			'description' => 'Turn this option on to only display entries submitted by a specific member when viewing that member\'s entries or categories.',
			'value' => '1', 
			'optioncode' => 'yesno',
			'displayorder' => '80',
			'serialize' => 0
		),
		'dyna_newrand_limitcat' => array(
			'title' => 'Limit to Specific Category if Applicable',
			'description' => 'Turn this option on if you would like for this module to only display entries from the category you are viewing. When enabled outside of a cateogry, this module will still display entries from all allowed categories.',
			'value' => '0', 
			'optioncode' => 'yesno',
			'displayorder' => '90',
			'serialize' => 0
		),
		'dyna_newrand_entrybitfields' => array(
			'title' => 'Entrybit Elements',
			'description' => 'Here you may select which items will be displayed within the entrybits for this module.',
			'value' => 'a:17:{i:0;s:7:"replies";i:1;s:5:"views";i:2;s:8:"category";i:3;s:6:"folder";i:4;s:7:"caticon";i:5;s:6:"rating";i:6;s:10:"last_reply";i:7;s:4:"icon";i:8;s:11:"firstattach";i:9;s:7:"preview";i:10;s:6:"avatar";i:11;s:13:"online_status";i:12;s:10:"user_title";i:13;s:9:"user_rank";i:14;s:13:"entry_options";i:15;s:12:"reply_button";i:16;s:11:"edit_button";}', 
			'optioncode' => 'entrybitelements',
			'displayorder' => '100',
			'serialize' => 1
		),
		'dyna_newrand_cfields' => array(
			'title' => 'Custom Fields to Display',
			'description' => 'Here you may select any custom fields that you wish to display within the entrybits.',
			'value' => 'N;', 
			'optioncode' => 'cfieldcheckbox',
			'displayorder' => '110',
			'serialize' => 1
		)
);

$mainsettings['adv_dyna_title_paths'] = array(
	'dyna_title' => array(
			'title' => 'Dynamics Title',
			'description' => 'The title of your vBadvanced Dynamics program. This will be displayed in the navbar, &lt;title&gt; tags, and other places throughout the program.',
			'value' => 'vBadvanced Dynamics', 
			'optioncode' => '',
			'displayorder' => '10',
			'serialize' => 0
		),
		'dyna_homeurl' => array(
			'title' => 'Dynamics Home URL',
			'description' => 'The URL to your vBadvanced Dynamics folder, with NO trailing slash, filename, or anything else at the end.
<div class="smallfont">Ex: http://yoursite.com/dyna</div>',
			'value' => 'http://localhost/dynamics', 
			'optioncode' => '',
			'displayorder' => '20',
			'serialize' => 0
		),
		'dyna_attachpath' => array(
			'title' => 'Attachment File Path',
			'description' => 'The full path (NOT the URL!) to the folder on your server in which you wish to store attachments. <div class="smallfont">Example: /home/yoursite/public_html/dyna/attach</div>',
			'value' => '', 
			'optioncode' => '',
			'displayorder' => '30',
			'serialize' => 0
		),
		'dyna_attachurl' => array(
			'title' => 'Attachment URL',
			'description' => 'The full URL to the folder in which you wish to store attachments.
<div class="smallfont">Note: If you store your attachments below the document root for security purposes, you may leave this blank and it will use the attachment.php file instead to display your attachments.</div>',
			'value' => '', 
			'optioncode' => '',
			'displayorder' => '40',
			'serialize' => 0
		),
		'dyna_attach_ftppath' => array(
			'title' => 'FTP Attachment Directory Path',
			'description' => 'If you wish to allow users to FTP their attachment files to your server, enter the full path (NOT the URL!) to that folder here. Note that each user allowed to FTP files should have a sub-folder in this directory named according to their vBulletin userid.
<div class="smallfont">Example: /home/yoursite/public_html/dynamics/ftpuploads</div>',
			'value' => '', 
			'optioncode' => '',
			'displayorder' => '50',
			'serialize' => 0
		),
		'dyna_caticon_path' => array(
			'title' => 'Category Icons Path',
			'description' => 'If you wish to allow users to upload category icons or you wish to be able to upload category icons through the Admin CP, enter the full path (NOT the URL!) to your {dynamics}/images/caticon folder here. <div>Example: /home/yoursite/public_html/dynamics/images/caticon</div>',
			'value' => '', 
			'optioncode' => '',
			'displayorder' => '60',
			'serialize' => 0
		),
		'dyna_phrase_entry' => array(
			'title' => 'Term For "Entry"',
			'description' => 'The term that you would like to use for your entries.',
			'value' => 'Entry', 
			'optioncode' => '',
			'displayorder' => '70',
			'serialize' => 0
		),
		'dyna_phrase_entry_plural' => array(
			'title' => 'Term For Plural "Entries"',
			'description' => 'The plural form of term you would like to use for your entries.',
			'value' => 'Entries', 
			'optioncode' => '',
			'displayorder' => '80',
			'serialize' => 0
		),
		'dyna_phrase_category' => array(
			'title' => 'Term For "Category"',
			'description' => 'The term you would like to use for your categories.',
			'value' => 'Category', 
			'optioncode' => '',
			'displayorder' => '90',
			'serialize' => 0
		),
		'dyna_phrase_category_plural' => array(
			'title' => 'Term For Plural "Categories"',
			'description' => 'The plural form of term you would like to use for your categories.',
			'value' => 'Categories', 
			'optioncode' => '',
			'displayorder' => '100',
			'serialize' => 0
		),
		'dyna_phrase_module' => array(
			'title' => 'Term For "Module"',
			'description' => 'The term you would like to use for for your modules.',
			'value' => 'Module', 
			'optioncode' => '',
			'displayorder' => '110',
			'serialize' => 0
		),
		'dyna_phrase_module_plural' => array(
			'title' => 'Term For Plural "Modules"',
			'description' => 'The plural form of the term you would like to use for your modules.',
			'value' => 'Modules', 
			'optioncode' => '',
			'displayorder' => '120',
			'serialize' => 0
		)
);

$mainsettings['adv_dyna_main'] = array(
	'dyna_version' => array(
			'title' => 'Version',
			'description' => 'Leave this setting alone or bad things could happen.',
			'value' => '1.0.0', 
			'optioncode' => 'hidden',
			'displayorder' => '0',
			'serialize' => 0
		),
		'dyna_active' => array(
			'title' => 'Dynamics Active',
			'description' => 'From time to time, you may wish to turn vBa Dynamics off to the public for whatever reason. When you turn vBa Dynamics off, visitors (with the exception of administrators and moderators) will see the message you specify in the option below rather than vBa Dynamics.',
			'value' => '1', 
			'optioncode' => 'yesno',
			'displayorder' => '10',
			'serialize' => 0
		),
		'dyna_closedmessage' => array(
			'title' => 'Dynamics Closed Message',
			'description' => 'This is the message that will be displayed to visitors when vBa Dynamics is closed.',
			'value' => 'We are sorry, but the dyna is closed for maintenance. Please check back soon.', 
			'optioncode' => 'textarea',
			'displayorder' => '20',
			'serialize' => 0
		),
		'dyna_meta_keywords' => array(
			'title' => 'Meta Keywords',
			'description' => 'Here you may enter a list of meta keywords to use in your vBadvanced Dynamics pages. Leave this setting blank to use your vBulletin &quot;Meta Keywords&quot; setting instead.',
			'value' => '', 
			'optioncode' => '',
			'displayorder' => '30',
			'serialize' => 0
		),
		'dyna_meta_desc' => array(
			'title' => 'Meta Description',
			'description' => 'Here you may enter a meta description to use in your vBadvanced Dynamics pages. Leave this setting blank to use your vBulletin &quot;Meta Keywords&quot; setting instead.',
			'value' => '', 
			'optioncode' => '',
			'displayorder' => '40',
			'serialize' => 0
		),
		'dyna_newentrylimit' => array(
			'title' => '"What\'s New" Date Limits',
			'description' => 'Enter a list of days (separated by commas) that you would like to allow your users to search for new entries/posts from in the &quot;What\'s New&quot; section. Set this to 0 to disable the &quot;What\'s New&quot; section.',
			'value' => '1,3,7,14,30,60', 
			'optioncode' => '',
			'displayorder' => '50',
			'serialize' => 0
		),
		'dyna_popentrylimit' => array(
			'title' => 'Popular Entries Limit',
			'description' => 'The number of entries to display in the &quot;What\'s Popluar&quot; section. Set this to 0 to disable the &quot;What\'s Popular&quot; section.',
			'value' => '25', 
			'optioncode' => '',
			'displayorder' => '60',
			'serialize' => 0
		),
		'dyna_popentries_votelimit' => array(
			'title' => 'Minimum Votes for Top Rated',
			'description' => 'The minimum number of votes that an entry must have before being shown as a top rated entry in the "What\'s Popular" section.',
			'value' => '2', 
			'optioncode' => '',
			'displayorder' => '70',
			'serialize' => 0
		),
		'dyna_cachedlife' => array(
			'title' => 'Cached Entries Lifespan',
			'description' => 'The number of days to store a cached copy of an entry. This makes entries display faster, but means that each entry takes approximately twice the storage space. Set this option to 0 to disable caching.',
			'value' => '30', 
			'optioncode' => '',
			'displayorder' => '80',
			'serialize' => 0
		),
		'dyna_disablecats' => array(
			'title' => 'Disable Categories (by forcing all entries into one category)',
			'description' => 'If you intend to use this program as more of a dyna, or otherwise have no use for categories, you may use this option to force all newly submitted entries into a specific category. This will allow you to still set specific category options while removing all references to categories throughout the user side of the program.',
			'value' => '0', 
			'optioncode' => '<select name=\\"" . $name . "\\">
<option value=\\"0\\">" . $vbphrase[do_not_disable_categories] . "</option>
<optgroup label=\\"" . $vbphrase[\'force_all_entries_into\'] . ":\\">
" . print_cat_select($setting[\'value\'], \'admin\') . "
</optgroup>
</select>',
			'displayorder' => '90',
			'serialize' => 0
		),
		'dyna_styleid' => array(
			'title' => 'Default vBa Dynamics Style',
			'description' => 'Select the default style for your vBadvanced Dynamics pages. This style will be used for all guests, and any members who have not expressed a style preference in their options.',
			'value' => '-1', 
			'optioncode' => 'styleselect',
			'displayorder' => '100',
			'serialize' => 0
		),
		'dyna_forcestyle' => array(
			'title' => 'Force Selected Style to be Used',
			'description' => 'If you have selected a specific style in the setting above, turn this option on to override a user\'s selected style. Otherwise, if a user has changed thier style settings in the User CP then their setting will override the above.',
			'value' => '0', 
			'optioncode' => 'yesno',
			'displayorder' => '110',
			'serialize' => 0
		),
		'dyna_allowrating' => array(
			'title' => 'Enable Ratings',
			'description' => 'Turn this option on to allow ratings. Note that you may also enable/disable ratings on a per-category basis by editing specific categories.',
			'value' => '1', 
			'optioncode' => 'yesno',
			'displayorder' => '120',
			'serialize' => 0
		),
		'dyna_allowfav' => array(
			'title' => 'Enable User Favorites',
			'description' => 'This option will enable the &quot;My Favorites&quot; section and allow your members to add entries to their favorites for quick access later.',
			'value' => '1', 
			'optioncode' => 'yesno',
			'displayorder' => '130',
			'serialize' => 0
		),
		'dyna_allowsubscribe' => array(
			'title' => 'Enable Entry Subscriptions',
			'description' => 'Turn this option on if you would like to allow users to subscribe to entries/categories and receive email updates when a new post or entry is added.',
			'value' => '1', 
			'optioncode' => 'yesno',
			'displayorder' => '140',
			'serialize' => 0
		),
		'dyna_enable_dirjump' => array(
			'title' => 'Enable Category Jump',
			'description' => 'This will display a &quot;Category Jump&quot;, similar to vBulletin\'s Forum Jump.',
			'value' => '1', 
			'optioncode' => 'yesno',
			'displayorder' => '150',
			'serialize' => 0
		),
		'enable_printerfriendly' => array(
			'title' => 'Show Printer Friendly Version Links',
			'description' => 'Turn this option on if you would like to show a link to a printer friendly version of entries on the showentry.php page and with the expanded entrybit template.',
			'value' => '1', 
			'optioncode' => 'yesno',
			'displayorder' => '160',
			'serialize' => 0
		),
		'dyna_navbarhomelink' => array(
			'title' => 'Navbar Beginning Link',
			'description' => 'Here you may choose to start the breadcrumbs in your navbar off with either a link back to your homepage or forums.',
			'value' => '0', 
			'optioncode' => '<div class=\\"smallfont\\">
<input name=\\"$name\\" id=\\"$setting[varname]_0\\" type=\\"radio\\" " . iif($setting[value] == 0, \'checked=\\"checked\\"\'). " value=\\"0\\"><label for=\\"$setting[varname]_0\\">" . $vbphrase[\'none\'] . "</label><br />
<input name=\\"$name\\" id=\\"$setting[varname]_1\\" type=\\"radio\\" " . iif($setting[value] == 1, \'checked=\\"checked\\"\'). " value=\\"1\\"><label for=\\"$setting[varname]_1\\">" . $vbphrase[\'home_page\'] . "</label><br />
<input name=\\"$name\\" id=\\"$setting[varname]_2\\" type=\\"radio\\" " . iif($setting[value] == 2, \'checked=\\"checked\\"\'). " value=\\"2\\"><label for=\\"$setting[varname]_2\\">" . $vbphrase[\'forums_home\'] . "</label></div>',
			'displayorder' => '170',
			'serialize' => 0
		),
		'dyna_imageverify' => array(
			'title' => 'Enable Image Verification for Guests',
			'description' => 'This option will display a random image which users will have to copy the content from into a text box to ensure that it is not an automated bot. It is strongly suggested that this option be enabled if you allow guests to do any of the activities listed to the right.',
			'value' => 'a:5:{i:0;s:8:"newentry";i:1;s:5:"reply";i:2;s:6:"search";i:3;s:6:"report";i:4;s:12:"sendtofriend";}', 
			'optioncode' => '<table width=\\"100%\\">
<tr>
<td valign=\\"top\\">
	<input type=\\"checkbox\\" name=\\"" . $name . "[]\\" id=\\"setting_" . $grouptitle . "_$setting[varname]_newentry\\" value=\\"newentry\\" " . iif(in_array(\'newentry\', $setting[\'value\']), \'checked=\\"checked\\"\') . " /> <span class=\\"smallfont\\"><label for=\\"setting_" . $grouptitle . "_$setting[varname]_newentry\\">" . construct_phrase($vbphrase[new_x], $vbphrase[entry]) . "</label></span><br />

	<input type=\\"checkbox\\" name=\\"" . $name . "[]\\" id=\\"setting_" . $grouptitle . "_$setting[varname]_reply\\" value=\\"reply\\" " . iif(in_array(\'reply\', $setting[\'value\']), \'checked=\\"checked\\"\') . " /> <span class=\\"smallfont\\"><label for=\\"setting_" . $grouptitle . "_$setting[varname]_reply\\">$vbphrase[reply]</label></span><br />

	<input type=\\"checkbox\\" name=\\"" . $name . "[]\\" id=\\"setting_" . $grouptitle . "_$setting[varname]_search\\" value=\\"search\\" " . iif(in_array(\'search\', $setting[\'value\']), \'checked=\\"checked\\"\') . " /> <span class=\\"smallfont\\"><label for=\\"setting_" . $grouptitle . "_$setting[varname]_search\\">$vbphrase[search]</label></span><br />
</td>

<td valign=\\"top\\">
	<input type=\\"checkbox\\" name=\\"" . $name . "[]\\" id=\\"setting_" . $grouptitle . "_$setting[varname]_report\\"value=\\"report\\" " . iif(in_array(\'report\', $setting[\'value\']), \'checked=\\"checked\\"\') . " /> <span class=\\"smallfont\\"><label for=\\"setting_" . $grouptitle . "_$setting[varname]_report\\">" . construct_phrase($vbphrase[report_x], $vbphrase[entry]) . "</label></span><br />

	<input type=\\"checkbox\\" name=\\"" . $name . "[]\\" id=\\"setting_" . $grouptitle . "_$setting[varname]_sendtofriend\\"value=\\"sendtofriend\\" " . iif(in_array(\'sendtofriend\', $setting[\'value\']), \'checked=\\"checked\\"\') . " /> <span class=\\"smallfont\\"><label for=\\"setting_" . $grouptitle . "_$setting[varname]_sendtofriend\\">$vbphrase[send_to_friend]</label></span><br />
</td>
</tr>
</table>',
			'displayorder' => '180',
			'serialize' => 1
		),
		'dyna_admincatcollapse' => array(
			'title' => 'Enable Collapsible Categories in Admin CP',
			'description' => 'This option will allow you to collapse/expand categories in the &quot;Manage Categories&quot; section of the Admin CP. Web sites with a large number of categories should turn this on for performance reasons.',
			'value' => '0', 
			'optioncode' => 'yesno',
			'displayorder' => '190',
			'serialize' => 0
		)
);

$mainsettings['adv_dyna_index'] = array(
	'dyna_catdepth_index' => array(
			'title' => 'Depth of Categories on Index',
			'description' => 'The depth of categories to show on your main index page. If you set this option to \'2\', the current category level and any child categories one level below that will be displayed.',
			'value' => '2', 
			'optioncode' => '',
			'displayorder' => '10',
			'serialize' => 0
		),
		'dyna_home_memberscats' => array(
			'title' => 'Enable Members\' Categories',
			'description' => 'This option will display a list of users who have submitted entries in the same fashion that normal categories are displayed, but with the username as the title and a link to a page showing all entries by that user.',
			'value' => '1', 
			'optioncode' => 'yesno',
			'displayorder' => '20',
			'serialize' => 0
		),
		'dyna_home_disablecats' => array(
			'title' => 'Disable Category Display',
			'description' => 'If you wish to disable the display of categories on your main index page, turn this option on. This is most useful for those who wish to use the product as a blog type software and have the "Display Members\' Categories" option below enabled.',
			'value' => '0', 
			'optioncode' => 'yesno',
			'displayorder' => '30',
			'serialize' => 0
		)
);

$mainsettings['adv_dyna_categorybit'] = array(
	'dyna_catsorder' => array(
			'title' => 'Order Categories By',
			'description' => 'Here you may choose to order categories by either the display order specified for each category, or alphabetically.',
			'value' => 'displayorder', 
			'optioncode' => '<select class=\\"bginput\\" name=\\"$name\\"> <option " . iif($setting[value] == \'displayorder\', \'selected=\\"selected\\"\'). " value=\\"displayorder\\">" . $vbphrase[\'display_order\'] . "</option> <option " . iif($setting[value] == \'title\', \'selected=\\"selected\\"\'). " value=\\"title\\">" . $vbphrase[\'alphabetically\'] . "</option></select>',
			'displayorder' => '10',
			'serialize' => 0
		),
		'dyna_catsdir' => array(
			'title' => 'Category Display Direction',
			'description' => 'The default direction that categories should appear in.',
			'value' => 'ASC', 
			'optioncode' => '<select class=\\"bginput\\" name=\\"$name\\">
<option " . iif($setting[value] == \'DESC\', \'selected=\\"selected\\"\'). " value=\\"DESC\\">" . $vbphrase[\'descending\'] . "</option>
<option " . iif($setting[value] == \'ASC\', \'selected=\\"selected\\"\'). " value=\\"ASC\\">" . $vbphrase[\'ascending\'] . "</option>
</select>',
			'displayorder' => '20',
			'serialize' => 0
		),
		'dyna_catdepth' => array(
			'title' => 'Depth of Categories',
			'description' => 'The depth of categories to show in the category listings. If you set this option to \'2\', the current category level and any child categories one level below that will be displayed.',
			'value' => '2', 
			'optioncode' => '',
			'displayorder' => '30',
			'serialize' => 0
		),
		'dyna_memberscatsperpage' => array(
			'title' => 'Members\' Categories Per Page',
			'description' => 'The maximum number of Members\' Categories to display before splitting into multiple pages. Note that this option only has any effect if you have the "Display Members\' Categories" option above enabled, or you have any of your categories set to act as a Members\' Category.',
			'value' => '25', 
			'optioncode' => '',
			'displayorder' => '40',
			'serialize' => 0
		),
		'dyna_lastentry_maxlength' => array(
			'title' => 'Maximum Characters of Last Entry',
			'description' => 'The maximum number of characters that should be displayed for the title of the last entry before being cut off. Set this to 0 to show the entire title.',
			'value' => '20', 
			'optioncode' => '',
			'displayorder' => '50',
			'serialize' => 0
		),
		'dyna_showsubcats' => array(
			'title' => 'Display Smaller Sub-Category Columns',
			'description' => 'This option will allow you to display links to a category\'s sub-categories in the category listings.',
			'value' => '0', 
			'optioncode' => '',
			'displayorder' => '60',
			'serialize' => 0
		),
		'dyna_showmodcolumn' => array(
			'title' => 'Show Moderator Column',
			'description' => 'Turn this option on if you would like to display a column listing the moderator(s) for each category.',
			'value' => '1', 
			'optioncode' => 'yesno',
			'displayorder' => '70',
			'serialize' => 0
		),
		'dyna_showentrycount' => array(
			'title' => 'Show Entry / Post Counts in Restricted Categories',
			'description' => 'This option will display the number of entries/posts and last post/entry information in restricted categories even if the user does not have permission to view that category. When set to "No", users will see 0 entries/posts for categories they do have permission to view.',
			'value' => '0', 
			'optioncode' => 'yesno',
			'displayorder' => '80',
			'serialize' => 0
		),
		'dyna_showcatowner' => array(
			'title' => 'Display Category Owner\'s Username',
			'description' => 'If a category owned by a member, this option will allow that member\'s name to be displayed under the category title.',
			'value' => '1', 
			'optioncode' => 'yesno',
			'displayorder' => '90',
			'serialize' => 0
		),
		'dyna_showonoff' => array(
			'title' => 'Show On/Off Indicators',
			'description' => 'This option will display a small image  in your category listings that indicates whether a category has new entries/posts.',
			'value' => '1', 
			'optioncode' => 'yesno',
			'displayorder' => '100',
			'serialize' => 0
		),
		'dyna_showalphacats' => array(
			'title' => 'Display Alphabet Links for Members\' Categories',
			'description' => 'Similar to the "Display Alphabet Links" option above, this option will allow you to display a row of letters across the top of your pages allowing users to quickly search for Members\' Categories starting with a specific letter.',
			'value' => '1', 
			'optioncode' => 'yesno',
			'displayorder' => '110',
			'serialize' => 0
		),
		'dyna_hideemptycats' => array(
			'title' => 'Hide Empty Categories',
			'description' => 'Turn this option on if you would like to hide empty categories in the category list. Note that these categories will still be visible when submitting entries and other relevant places.',
			'value' => '0', 
			'optioncode' => 'yesno',
			'displayorder' => '120',
			'serialize' => 0
		)
);

$mainsettings['adv_dyna_browsecategory'] = array(
	'dyna_deforder' => array(
			'title' => 'Default Entries Order',
			'description' => 'The default order that entries should appear in. This affects entries displayed in categories, favorites section, and search results (if no order is specified).',
			'value' => 'dateline', 
			'optioncode' => '<select class=\\"bginput\\" name=\\"$name\\">
<option " . iif($setting[value] == \'title\', \'selected=\\"selected\\"\'). " value=\\"title\\">" . $vbphrase[\'title\'] . "</option>
<option " . iif($setting[value] == \'dateline\', \'selected=\\"selected\\"\'). " value=\\"dateline\\">" . $vbphrase[\'date_posted\'] . "</option>
<option " . iif($setting[value] == \'lastpostdateline\', \'selected=\\"selected\\"\'). " value=\\"lastpostdateline\\">" . $vbphrase[\'last_post\'] . "</option>
<option " . iif($setting[value] == \'rating\', \'selected=\\"selected\\"\'). " value=\\"rating\\">" . $vbphrase[\'rating\'] . "</option>
<option " . iif($setting[value] == \'views\', \'selected=\\"selected\\"\'). " value=\\"views\\">" . $vbphrase[\'number_of_views\'] . "</option>
<option " . iif($setting[value] == \'posts\', \'selected=\\"selected\\"\'). " value=\\"posts\\">" . $vbphrase[\'number_of_replies\'] . "</option>
</select>
',
			'displayorder' => '10',
			'serialize' => 0
		),
		'dyna_defdirection' => array(
			'title' => 'Default Entries Order Direction',
			'description' => 'The default direction that entries should be ordered by. This affects entries displayed in categories, favorites section, and search results (if no order is specified).',
			'value' => 'DESC', 
			'optioncode' => '<select class=\\"bginput\\" name=\\"$name\\">
<option " . iif($setting[value] == \'DESC\', \'selected=\\"selected\\"\'). " value=\\"DESC\\">" . $vbphrase[\'descending\'] . "</option>
<option " . iif($setting[value] == \'ASC\', \'selected=\\"selected\\"\'). " value=\\"ASC\\">" . $vbphrase[\'ascending\'] . "</option>
</select>',
			'displayorder' => '20',
			'serialize' => 0
		),
		'dyna_perpage' => array(
			'title' => 'Entries Per Page',
			'description' => 'The maximum number of entries to display before splitting into multiple pages.',
			'value' => '25', 
			'optioncode' => '',
			'displayorder' => '30',
			'serialize' => 0
		),
		'dyna_desclength_browse' => array(
			'title' => 'Maximum Characters of Description to Display',
			'description' => 'The maximum number of characters of the entries description that should be displayed before being cut off. Set this to 0 to disable it.',
			'value' => '500', 
			'optioncode' => '',
			'displayorder' => '40',
			'serialize' => 0
		),
		'dyna_hotviews' => array(
			'title' => 'Views to qualify as a hot entry',
			'description' => 'The number of views an entry must receive before being marked as a "hot entry". Set this option and the one below it to 0 to disable hot entries.',
			'value' => '150', 
			'optioncode' => '',
			'displayorder' => '50',
			'serialize' => 0
		),
		'dyna_hotposts' => array(
			'title' => 'Posts to qualify as a hot entry',
			'description' => 'The number of posts an entry must receive before being marked as a "hot entry". Set this option and the option above to 0 to disable hot entries.',
			'value' => '15', 
			'optioncode' => '',
			'displayorder' => '60',
			'serialize' => 0
		),
		'dyna_entrybit_showattach' => array(
			'title' => 'Show Attachments in Categories',
			'description' => 'This option will allow you to display an attachment associated with the entry in the category display. If no attachment is specified by the user, the first attachment in the entry will be used.',
			'value' => '1', 
			'optioncode' => '<select class=\\"bginput\\" name=\\"$name\\">
<option " . iif(!$setting[value], \'selected=\\"selected\\"\'). " value=\\"0\\">" . $vbphrase[\'no\'] . "</option>
<option " . iif($setting[value] == \'1\', \'selected=\\"selected\\"\'). " value=\\"1\\">" . $vbphrase[\'yes_all_types\'] . "</option>
<option " . iif($setting[value] == \'2\', \'selected=\\"selected\\"\'). " value=\\"2\\">" . $vbphrase[\'yes_thumbs_only\'] . "</option>
</select>
',
			'displayorder' => '70',
			'serialize' => 0
		),
		'dyna_showalpha' => array(
			'title' => 'Display Alphabet Links',
			'description' => 'This option will enable a row of letters across the top of your browsecategory pages allowing users to quickly search for entries beginning with a specific letter.',
			'value' => '1', 
			'optioncode' => 'yesno',
			'displayorder' => '80',
			'serialize' => 0
		),
		'dyna_entrybitexpanded' => array(
			'title' => 'Use Expanded Entrybit Template',
			'description' => 'This option will use the expanded entrybits template (adv_dyna_entrybits_expanded) instead of the default simple template (adv_dyna_entrybits_simple). The simple template displays entries in a more compact fashion without the entry\'s message, while the expanded version displays the message and other optional items.',
			'value' => '1', 
			'optioncode' => 'yesno',
			'displayorder' => '90',
			'serialize' => 0
		),
		'dyna_entrybitfields' => array(
			'title' => 'Entrybit Elements',
			'description' => 'Here you may select which items will be displayed within the entrybits.',
			'value' => 'a:15:{i:0;s:7:"replies";i:1;s:5:"views";i:2;s:6:"folder";i:3;s:7:"caticon";i:4;s:6:"rating";i:5;s:10:"last_reply";i:6;s:4:"icon";i:7;s:7:"preview";i:8;s:6:"avatar";i:9;s:13:"online_status";i:10;s:10:"user_title";i:11;s:9:"user_rank";i:12;s:13:"entry_options";i:13;s:12:"reply_button";i:14;s:11:"edit_button";}', 
			'optioncode' => 'entrybitelements',
			'displayorder' => '100',
			'serialize' => 1
		),
		'dyna_browsecat_cfields' => array(
			'title' => 'Custom Fields to Display',
			'description' => 'Here you may select any custom fields that you wish to display within the entrybits.',
			'value' => 'N;', 
			'optioncode' => 'cfieldcheckbox',
			'displayorder' => '110',
			'serialize' => 1
		)
);

$mainsettings['adv_dyna_showentry'] = array(
	'dyna_repliesperpage' => array(
			'title' => 'Replies Per Page',
			'description' => 'The maximum number of replies to be displayed before splitting into multiple pages.
<div class="smallfont">Please note that if a user has changed the value for "Number of Posts to Show Per Page" in their User CP then that value will override this option.</div>',
			'value' => '5', 
			'optioncode' => '',
			'displayorder' => '10',
			'serialize' => 0
		),
		'dyna_quickreply_width' => array(
			'title' => 'Quick Reply Box Width',
			'description' => 'If you would like, you may specify a different width (in pixels) for your \'Quick Reply\' box here. Leave this setting blank to use the default vBulletin style setting.<br />Ex: 480px',
			'value' => '480px', 
			'optioncode' => '',
			'displayorder' => '20',
			'serialize' => 0
		),
		'dyna_attachpos' => array(
			'title' => 'Position of Attachments',
			'description' => 'This option will allow you to change the location where attachments are displayed.',
			'value' => '0', 
			'optioncode' => '<select class=\\"bginput\\" name=\\"$name\\">
<option " . iif(!$setting[value], \'selected=\\"selected\\"\'). " value=\\"0\\">$vbphrase[below_message]</option>
<option " . iif($setting[value] == \'showentry_belowmessage\', \'selected=\\"selected\\"\'). " value=\\"showentry_belowmessage\\">$vbphrase[below_message_table_above_replies]</option>
<option " . iif($setting[value] == \'left\', \'selected=\\"selected\\"\'). " value=\\"left\\">$vbphrase[left_column]</option>
<option " . iif($setting[value] == \'center_above\', \'selected=\\"selected\\"\'). " value=\\"center_above\\">$vbphrase[center_above_column]</option>
<option " . iif($setting[value] == \'center_below\', \'selected=\\"selected\\"\'). " value=\\"center_below\\">$vbphrase[center_below_column]</option>
<option " . iif($setting[value] == \'right\', \'selected=\\"selected\\"\'). " value=\\"right\\">$vbphrase[right_column]</option>
</select>',
			'displayorder' => '30',
			'serialize' => 0
		),
		'dyna_showentry_pagebox' => array(
			'title' => 'Show Multi-Page Navigation Box',
			'description' => 'If you have enbled multiple page entries, this option will enable a \'Navigtion\' box to the right of the entries message with links to each page of the entry.',
			'value' => '0', 
			'optioncode' => 'yesno',
			'displayorder' => '40',
			'serialize' => 0
		),
		'dyna_reply_orderby' => array(
			'title' => 'Display Newest Replies First',
			'description' => 'Turn this option on to show the newest replies made to an entry on top. Otherwise, replies will be displayed in order from oldest to newest.',
			'value' => '0', 
			'optioncode' => 'yesno',
			'displayorder' => '50',
			'serialize' => 0
		),
		'dyna_showquickreply' => array(
			'title' => 'Show Quick Reply?',
			'description' => 'This option will dispaly the quickreply box when viewing an entry and allow users to quickly reply to entries.',
			'value' => '1', 
			'optioncode' => 'yesno',
			'displayorder' => '60',
			'serialize' => 0
		),
		'dyna_convertkeywords' => array(
			'title' => 'Convert Tags to Links',
			'description' => 'Turn this option on if you would like to automatically convert tags to links, allowing users to quickly search for a tag by clicking it.',
			'value' => '1', 
			'optioncode' => 'yesno',
			'displayorder' => '70',
			'serialize' => 0
		),
		'dyna_matchonly_keywords' => array(
			'title' => 'Only Search Tags When Clicking a Tag',
			'description' => 'If you have the option to convert tags into links above turned on, you may use this option to limit tag searching so it will only return results from other entries with the same keywords. Otherwise, clicking a tag will search entire entries and return results where the keyword appears anywhere in the entry.',
			'value' => '0', 
			'optioncode' => 'yesno',
			'displayorder' => '80',
			'serialize' => 0
		),
		'dyna_showentry_avatar' => array(
			'title' => 'Show Avatar',
			'description' => 'Turn this option on if you wish to display the entry author\'s avatar with the entry.',
			'value' => '1', 
			'optioncode' => 'yesno',
			'displayorder' => '90',
			'serialize' => 0
		),
		'dyna_showentry_views' => array(
			'title' => 'Show Times Viewed',
			'description' => 'Turn this option on if you wish to display the number of times the entry has been viewed.',
			'value' => '1', 
			'optioncode' => 'yesno',
			'displayorder' => '100',
			'serialize' => 0
		),
		'dyna_showentry_replies' => array(
			'title' => 'Show Replies',
			'description' => 'Turn this option on if you wish to display the number of replies the entry has.',
			'value' => '1', 
			'optioncode' => 'yesno',
			'displayorder' => '110',
			'serialize' => 0
		),
		'dyna_showentry_imicons' => array(
			'title' => 'Show Instant Messaging Icons',
			'description' => 'Turn this option on to display images for Skype, ICQ, AIM, MSN, and Yahoo! Messenger if the user has those fields filled out in their profile.',
			'value' => '1', 
			'optioncode' => 'yesno',
			'displayorder' => '120',
			'serialize' => 0
		),
		'dyna_showentry_onlinestatus' => array(
			'title' => 'Show Online Status',
			'description' => 'Turn this option on to display an image next to the user\'s name indicating whether that user is currently online.',
			'value' => '1', 
			'optioncode' => 'yesno',
			'displayorder' => '130',
			'serialize' => 0
		),
		'dyna_showentry_usertitle' => array(
			'title' => 'Show User Title',
			'description' => 'Turn this option on to show the user\'s title below their username.',
			'value' => '1', 
			'optioncode' => 'yesno',
			'displayorder' => '140',
			'serialize' => 0
		),
		'dyna_showentry_rank' => array(
			'title' => 'Show User Rank',
			'description' => 'Turn this option on to show the user\'s rank below their username.',
			'value' => '1', 
			'optioncode' => 'yesno',
			'displayorder' => '150',
			'serialize' => 0
		),
		'dyna_formatmeta_showentry' => array(
			'title' => 'Generate Meta Tags From Entry Content',
			'description' => 'Turn this option on to automatically generate meta keywords and description from the entry\'s tags and message. Turn this option off to use your default meta keywords when viewing an entry.',
			'value' => '1', 
			'optioncode' => 'yesno',
			'displayorder' => '160',
			'serialize' => 0
		)
);

$mainsettings['adv_dyna_newentry'] = array(
	'dyna_multipage_limit' => array(
			'title' => 'Maximum Number of Pages',
			'description' => 'If you would like to allow your users to submit entries with multiple pages, enter the maximum number of pages here. Otherwise, set this option to 0 or 1 to limit submissions to single page entries.',
			'value' => '1', 
			'optioncode' => '',
			'displayorder' => '10',
			'serialize' => 0
		),
		'dyna_maxtitlelength' => array(
			'title' => 'Maximum Length of Title',
			'description' => 'The maximum number of characters allowed in the title of entries submitted.',
			'value' => '100', 
			'optioncode' => '',
			'displayorder' => '20',
			'serialize' => 0
		),
		'dyna_maxdesclength' => array(
			'title' => 'Maximum Length of Message',
			'description' => 'The maximum number of characters allowed in the message part of entries.',
			'value' => '20000', 
			'optioncode' => '',
			'displayorder' => '30',
			'serialize' => 0
		),
		'dyna_maxentryimages' => array(
			'title' => 'Maximum Images Per Entry',
			'description' => 'The maximum number of images and smilies to allow in an entry. Set this option to 0 to for unlimited.',
			'value' => '15', 
			'optioncode' => '',
			'displayorder' => '40',
			'serialize' => 0
		),
		'dyna_editentry_timelimit' => array(
			'title' => 'Time Limit For Editing Entries',
			'description' => 'The maximum amount of time (in minutes) to impose on editing of entries. After this time limit, only moderators will be able to edit/delete the entry. Note that this will not apply to entries saved as drafts.<br /><br />
Set this option to 0 to allow users to edit entries indefinitely.',
			'value' => '60', 
			'optioncode' => '',
			'displayorder' => '50',
			'serialize' => 0
		),
		'dyna_newentryemail' => array(
			'title' => 'Email Address to Notify of New Entries',
			'description' => 'Enter a list of email addresses here (separated by spaces) that you would like to have an email sent to when a new entry is added.',
			'value' => '', 
			'optioncode' => '',
			'displayorder' => '60',
			'serialize' => 0
		),
		'dyna_newentryemail_all' => array(
			'title' => 'Notify of All Entries',
			'description' => 'If you would like to only be notified of entries submitted which are awaiting validation, set this option to \'No\'. Otherwise you will be notified of any entries submitted whether they are awaiting validation or not.',
			'value' => '0', 
			'optioncode' => 'yesno',
			'displayorder' => '70',
			'serialize' => 0
		),
		'dyna_entry_editmoderation' => array(
			'title' => 'Send Entries Back to Moderation Que if Modified',
			'description' => 'Turning this option on will cause entries to be sent back to the moderation que when edited if the member does not belong to a usergroup that does not require moderation for entries. Turn this option off to allow entries to be edited without sending them back to the moderation que.',
			'value' => '0', 
			'optioncode' => 'yesno',
			'displayorder' => '80',
			'serialize' => 0
		),
		'dyna_allowdrafts' => array(
			'title' => 'Allow Drafts',
			'description' => 'This option will allow your members to save their entries as &quot;drafts&quot;, which will not be visible to the public until they publish them at a later time.',
			'value' => '1', 
			'optioncode' => 'yesno',
			'displayorder' => '90',
			'serialize' => 0
		),
		'dyna_buddyentries' => array(
			'title' => 'Allow Private (Buddy List Only) Entries',
			'description' => 'This option will allow your members to mark their entries as &quot;private&quot;, meaning that only the owner of that entry and users on their buddy list will be able to view the entry.',
			'value' => '1', 
			'optioncode' => 'yesno',
			'displayorder' => '100',
			'serialize' => 0
		),
		'dyna_entry_icons' => array(
			'title' => 'Allow Icons in Entries',
			'description' => 'Turn this option on if you would like to allow your users to select an icon with their entries.',
			'value' => '1', 
			'optioncode' => 'yesno',
			'displayorder' => '110',
			'serialize' => 0
		),
		'dyna_entry_sigs' => array(
			'title' => 'Allow Signatures in Entries',
			'description' => 'Turn this option on if you would like to allow your members to include their signature with their entries.',
			'value' => '1', 
			'optioncode' => 'yesno',
			'displayorder' => '120',
			'serialize' => 0
		),
		'dyna_allowkeywords' => array(
			'title' => 'Allow Tags (keywords)',
			'description' => 'Turn this option on if you would like to allow your users to enter tags (keywords) for their entries.',
			'value' => '1', 
			'optioncode' => 'yesno',
			'displayorder' => '130',
			'serialize' => 0
		),
		'dyna_keyword_separator' => array(
			'title' => 'Separate Tags With Commas',
			'description' => 'Turn this option on if you would like to require that your users separate their tags with a comma, thus allowing for tags with multiple words. Otherwise, turn this option off to separate keywords with spaces.',
			'value' => '1', 
			'optioncode' => 'yesno',
			'displayorder' => '140',
			'serialize' => 0
		),
		'dyna_update_postcount_entries' => array(
			'title' => 'Count Entries Towards User Post Counts',
			'description' => 'Turn this option on if you would like entries submitted in vBadvanced Dynamics to affect a user\'s postcount.',
			'value' => '0', 
			'optioncode' => 'yesno',
			'displayorder' => '150',
			'serialize' => 0
		),
		'dyna_editormode' => array(
			'title' => 'Enable Editors',
			'description' => 'This option allows you to control what kind of editor your members may use when submitting new entries.',
			'value' => '2', 
			'optioncode' => '<select class=\\"bginput\\" name=\\"$name\\">
<option " . iif(!$setting[value], \'selected=\\"selected\\"\'). " value=\\"0\\">$vbphrase[disable_controls]</option>
<option " . iif($setting[value] == 1, \'selected=\\"selected\\"\'). " value=\\"1\\">$vbphrase[enable_standard_controls]</option>
<option " . iif($setting[value] == 2, \'selected=\\"selected\\"\'). " value=\\"2\\">$vbphrase[enable_standard_and_wysiwyg_controls]</option>
</select>
',
			'displayorder' => '160',
			'serialize' => 0
		),
		'dyna_attachlocation' => array(
			'title' => 'Attachment Box Location',
			'description' => 'If you allow attachments with your entries, you may select where to display the &quot;Manage Attachments&quot; box here.',
			'value' => 'above', 
			'optioncode' => '<select class=\\"bginput\\" name=\\"$name\\">
<option " . iif($setting[value] == \'addit\', \'selected=\\"selected\\"\'). " value=\\"addit\\">$vbphrase[additional_options]</option>
<option " . iif($setting[value] == \'above\', \'selected=\\"selected\\"\'). " value=\\"above\\">$vbphrase[above_message]</option>
<option " . iif($setting[value] == \'below\', \'selected=\\"selected\\"\'). " value=\\"below\\">$vbphrase[below_message]</option>
</select>
',
			'displayorder' => '170',
			'serialize' => 0
		),
		'dyna_add_dateformat' => array(
			'title' => 'Date Format',
			'description' => 'This option will control the format for dates when submitting entries in places like the \'Entry Date\' setting and entry publishing options.',
			'value' => 'm-d-y', 
			'optioncode' => '<select class=\\"bginput\\" name=\\"$name\\">
<option " . iif($setting[value] == \'m-d-y\', \'selected=\\"selected\\"\'). " value=\\"m-d-y\\">M-D-Y (Month - Day - Year)</option>
<option " . iif($setting[value] == \'d-m-y\', \'selected=\\"selected\\"\'). " value=\\"d-m-y\\">D-M-Y (Day - Month - Year</option>
</select>
',
			'displayorder' => '180',
			'serialize' => 0
		),
		'dyna_add_timeformat' => array(
			'title' => 'Time Format',
			'description' => 'This option will control the format for times when submitting entries in places like the \'Entry Date\' setting and entry publishing options.',
			'value' => '12hour', 
			'optioncode' => '<select class=\\"bginput\\" name=\\"$name\\">
<option " . iif($setting[value] == \'12hour\', \'selected=\\"selected\\"\'). " value=\\"12hour\\">12 Hour</option>
<option " . iif($setting[value] == \'24hour\', \'selected=\\"selected\\"\'). " value=\\"24hour\\">24 Hour</option>
</select>
',
			'displayorder' => '190',
			'serialize' => 0
		)
);

$mainsettings['adv_dyna_attach'] = array(
	'dyna_require_attach' => array(
			'title' => 'Require Attachments With Entries',
			'description' => 'If you would like to require that each entry have at least a set number of attachments included, enter that number here. Otherwise, enter 0 to make attachments optional.',
			'value' => '0', 
			'optioncode' => '',
			'displayorder' => '10',
			'serialize' => 0
		),
		'dyna_attachmax' => array(
			'title' => 'Maximum Number of Attachments Per Entry',
			'description' => 'The maximum number of attachments that a user may include with a single entry.',
			'value' => '5', 
			'optioncode' => '',
			'displayorder' => '20',
			'serialize' => 0
		),
		'dyna_attachinputs' => array(
			'title' => 'Number of Attachment Inputs',
			'description' => 'This option controlls the number of upload inputs that will be displayed on the attachment upload page.',
			'value' => '3', 
			'optioncode' => '',
			'displayorder' => '30',
			'serialize' => 0
		),
		'dyna_attachinputs_url' => array(
			'title' => 'Number of Attachment URL Inputs',
			'description' => 'This option controlls the number of URL inputs that will be displayed on the attachment upload page.',
			'value' => '2', 
			'optioncode' => '',
			'displayorder' => '40',
			'serialize' => 0
		),
		'dyna_attach_filenamelength' => array(
			'title' => 'Maximum Length of Filenames',
			'description' => 'Enter the maximum number of characters that you would like to allow in attachment filenames. Any attachments with a filename longer than the value specified here will be trimmed to that length. Note that this limit does not include the extension.',
			'value' => '30', 
			'optioncode' => '',
			'displayorder' => '50',
			'serialize' => 0
		),
		'dyna_thumbqlty' => array(
			'title' => 'Thumbnail Quality',
			'description' => 'The quality of thumbnails generated for attachments. Note that higher quality will equal larger file sizes. The recommended setting for good quality without inflated filesize is 95.',
			'value' => '95', 
			'optioncode' => '',
			'displayorder' => '60',
			'serialize' => 0
		),
		'dyna_thumbsize' => array(
			'title' => 'Thumbnail Size',
			'description' => 'The maximum width and/or height of thumbnails for attachments.',
			'value' => '100', 
			'optioncode' => '',
			'displayorder' => '70',
			'serialize' => 0
		),
		'dyna_myattach_perpage' => array(
			'title' => 'Number of Attachments Per Page in "My Attachments" Section',
			'description' => 'The maximum number of attachments to display in the &quot;My Attachments&quot; section before splitting into multiple pages.',
			'value' => '25', 
			'optioncode' => '',
			'displayorder' => '80',
			'serialize' => 0
		),
		'dyna_attach_maxexectime' => array(
			'title' => 'Maximum Script Execution Time',
			'description' => 'Here you may enter the maximum amount of time (in seconds) that the attachment uploading file may spend trying to process the attachments. If you allow large file uploads and have problems with the attachment page timing out, this setting may allow you to change the timeout. Note that this may not work on all server configurations. Leave the setting blank to use your default PHP configuration settings.',
			'value' => '', 
			'optioncode' => '',
			'displayorder' => '90',
			'serialize' => 0
		),
		'dyna_attach_maxfilesize' => array(
			'title' => 'Maximum Upload Filesize',
			'description' => 'Here you may enter the maximum filesize (in MB) for attachment uploads. If your server\'s PHP configuration does not allow for uploads as large as your attachment settings, you may attempt to change that setting for just the attachment upload page here. Note this may not work on all server configurations. Leave the setting blank to use your default PHP configuration settings.',
			'value' => '', 
			'optioncode' => '',
			'displayorder' => '100',
			'serialize' => 0
		)
);

$mainsettings['adv_dyna_posting'] = array(
	'dyna_allowreplies' => array(
			'title' => 'Enable Replies to Entries',
			'description' => 'Turning this option on will allow users to post replies to entries.
Please note that the users must have permission to post replies which can be modified in the &quot;Modify Permissions&quot; section in the &quot;vBa Dynamics&quot; section of the Admin CP.',
			'value' => '1', 
			'optioncode' => 'yesno',
			'displayorder' => '10',
			'serialize' => 0
		),
		'dyna_update_postcount' => array(
			'title' => 'Count Posts Towards Postcounts?',
			'description' => 'Turn this option on if you would like posts made in vBadvanced Dynamics to affect a user\'s postcount.',
			'value' => '0', 
			'optioncode' => 'yesno',
			'displayorder' => '20',
			'serialize' => 0
		),
		'dyna_post_icons' => array(
			'title' => 'Allow Icons in Posts',
			'description' => 'Turn this option on if you would like to allow your users to select an icon with their posts.',
			'value' => '1', 
			'optioncode' => 'yesno',
			'displayorder' => '30',
			'serialize' => 0
		),
		'dyna_allow_post_title' => array(
			'title' => 'Allow Post Titles',
			'description' => 'Turn this option on if you would like to allow users to enter a title with their replies.',
			'value' => '1', 
			'optioncode' => 'yesno',
			'displayorder' => '40',
			'serialize' => 0
		),
		'dyna_quotetitle' => array(
			'title' => 'Quote Titles in Replies',
			'description' => 'Turning this option on will automatically fill the title of new posts with either the entry title, or the post title (if replying to a specific post), prefixed by \'Re: \'. The user may still specify their own title if they wish to do so.',
			'value' => '1', 
			'optioncode' => 'yesno',
			'displayorder' => '50',
			'serialize' => 0
		),
		'dyna_post_editmoderation' => array(
			'title' => 'Send Posts Back to Moderation Que if Modified',
			'description' => 'Turning this option on will cause posts to be sent back to the moderation que when edited if the member does not belong to a usergroup that does not require moderation for posts. Turn this option off to allow posts to be edited without sending them back to the moderation que.',
			'value' => '0', 
			'optioncode' => 'yesno',
			'displayorder' => '60',
			'serialize' => 0
		),
		'dyna_editpost_timelimit' => array(
			'title' => 'Time Limit For Editing Posts',
			'description' => 'The maximum amount of time (in minutes) to impose on editing of replies. After this time limit, only moderators will be able to edit/delete the post. Note that this will also affect the time limit of editing guest book replies if the guest book module is enabled.<br /><br />
Set this option to 0 to allow users to edit entries indefinitely.',
			'value' => '0', 
			'optioncode' => '',
			'displayorder' => '70',
			'serialize' => 0
		)
);

$mainsettings['adv_dyna_usercats'] = array(
	'dyna_allow_user_cats' => array(
			'title' => 'Allow Users to Create Categories',
			'description' => 'Turning this on will allow your users to create their own categories. If you would like to give your users any control over the category once it is created, select the "Yes (User owns the category)" option. Otherwise, select the "Yes (User does NOT own the category)" option to treat it as a normal cateogry once submitted.
<div>Note that you must have the &quot;Can Create Categories&quot; usergroup permission setting enabled as well in order for users to be allowed to create categories.',
			'value' => '0', 
			'optioncode' => '<div class=\\"smallfont\\"><input " . iif($setting[\'value\'] == 0, \'checked="checked"\'). " type=\\"radio\\" id=\\"allow_user_cats_0\\" name=\\"$name\\" value=\\"0\\" /> <label for=\\"allow_user_cats_0\\">" . $vbphrase[\'no\'] . "</label><br />
<input " . iif($setting[\'value\'] == 1, \'checked="checked"\'). "type=\\"radio\\" id=\\"allow_user_cats_1\\" name=\\"$name\\" value=\\"1\\" /> <label for=\\"allow_user_cats_1\\">" . $vbphrase[\'yes_user_owns_cat\'] . "</label><br />
<input " . iif($setting[\'value\'] == 2, \'checked="checked"\'). "type=\\"radio\\" id=\\"allow_user_cats_2\\" name=\\"$name\\" value=\\"2\\" /> <label for=\\"allow_user_cats_2\\">" . $vbphrase[\'yes_user_does_not_own_cat\'] . "</label></div>',
			'displayorder' => '10',
			'serialize' => 0
		),
		'dyna_usercats_defaultopts' => array(
			'title' => 'Default Category Options',
			'description' => 'Here you may choose a default setting for each available option user created categories, or set it to allow the user to choose.',
			'value' => 'a:4:{s:10:"allow_view";s:1:"2";s:16:"allow_newentries";s:1:"2";s:11:"allow_reply";s:1:"2";s:12:"allow_rating";s:1:"2";}', 
			'optioncode' => '<div class=\\"smallfont\\">
<div><strong>" . construct_phrase($vbphrase[\'allow_other_users_view_x\'], $vbphrase[\'entries\']) . "</strong></div>
	<div style=\\"padding-bottom:8px\\"><label for=\\"allow_view1\\"><input id=\\"allow_view1\\" " . iif($setting[\'value\'][\'allow_view\'] == 1, \'checked="checked"\'). " name=\\"" . $name . "[allow_view]\\" type=\\"radio\\" value=\\"1\\" />Yes</label> <label for=\\"allow_view0\\"><input id=\\"allow_view0\\" " . iif($setting[\'value\'][\'allow_view\'] == 0, \'checked="checked"\'). " name=\\"" . $name . "[allow_view]\\" type=\\"radio\\" value=\\"0\\" />" . $vbphrase[\'no\'] . "</label> <label for=\\"allow_view2\\"><input id=\\"allow_view2\\" " . iif($setting[\'value\'][\'allow_view\'] == 2, \'checked="checked"\'). " name=\\"" . $name . "[allow_view]\\" type=\\"radio\\" value=\\"2\\" />" . $vbphrase[\'user_choice\'] . "</label>

</div>
<div><strong>" . construct_phrase($vbphrase[\'allow_other_users_add_x\'], $vbphrase[\'entries\']) . "</strong></div>
<div style=\\"padding-bottom:8px\\">
	<label for=\\"allow_newentries1\\"><input id=\\"allow_newentries1\\" " . iif($setting[\'value\'][\'allow_newentries\'] == 1, \'checked="checked"\'). " name=\\"" . $name . "[allow_newentries]\\" type=\\"radio\\" value=\\"1\\" />Yes</label> <label for=\\"allow_newentries0\\"><input id=\\"allow_newentries0\\" " . iif($setting[\'value\'][\'allow_newentries\'] == 0, \'checked="checked"\'). " name=\\"" . $name . "[allow_newentries]\\" type=\\"radio\\" value=\\"0\\" />" . $vbphrase[\'no\'] . "</label> <label for=\\"allow_newentries2\\"><input id=\\"allow_newentries2\\" " . iif($setting[\'value\'][\'allow_newentries\'] == 2, \'checked="checked"\'). " name=\\"" . $name . "[allow_newentries]\\" type=\\"radio\\" value=\\"2\\" />" . $vbphrase[\'user_choice\'] . "</label>

</div>
<div><strong>" . construct_phrase($vbphrase[\'allow_other_users_reply_x\'], $vbphrase[\'entries\']) . "</strong></div>
<div style=\\"padding-bottom:8px\\">
	<label for=\\"allow_reply1\\"><input id=\\"allow_reply1\\" " . iif($setting[\'value\'][\'allow_reply\'] == 1, \'checked="checked"\'). " name=\\"" . $name . "[allow_reply]\\" type=\\"radio\\" value=\\"1\\" />Yes</label> <label for=\\"allow_reply0\\"><input id=\\"allow_reply0\\" " . iif($setting[\'value\'][\'allow_reply\'] == 0, \'checked="checked"\'). " name=\\"" . $name . "[allow_reply]\\" type=\\"radio\\" value=\\"0\\" />" . $vbphrase[\'no\'] . "</label> <label for=\\"allow_reply2\\"><input id=\\"allow_reply2\\" " . iif($setting[\'value\'][\'allow_reply\'] == 2, \'checked="checked"\'). " name=\\"" . $name . "[allow_reply]\\" type=\\"radio\\" value=\\"2\\" />" . $vbphrase[\'user_choice\'] . "</label>

</div>
<div><strong>" . construct_phrase($vbphrase[\'allow_other_users_rate_x\'], $vbphrase[\'entries\']) . "</strong></div>
<div>
	<label for=\\"allow_rating1\\"><input id=\\"allow_rating1\\" " . iif($setting[\'value\'][\'allow_rating\'] == 1, \'checked="checked"\'). " name=\\"" . $name . "[allow_rating]\\" type=\\"radio\\" value=\\"1\\" />Yes</label> <label for=\\"allow_rating0\\"><input id=\\"allow_rating0\\" " . iif($setting[\'value\'][\'allow_rating\'] == 0, \'checked="checked"\'). " name=\\"" . $name . "[allow_rating]\\" type=\\"radio\\" value=\\"0\\" />" . $vbphrase[\'no\'] . "</label> <label for=\\"allow_rating2\\"><input id=\\"allow_rating2\\" " . iif($setting[\'value\'][\'allow_rating\'] == 2, \'checked="checked"\'). " name=\\"" . $name . "[allow_rating]\\" type=\\"radio\\" value=\\"2\\" />" . $vbphrase[\'user_choice\'] . "</label>
</div>
</div>',
			'displayorder' => '20',
			'serialize' => 1
		),
		'dyna_usercat_titlemax' => array(
			'title' => 'Maximum Length of Title',
			'description' => 'The maximum number of characters allowed in the title for user created categories.',
			'value' => '100', 
			'optioncode' => '',
			'displayorder' => '30',
			'serialize' => 0
		),
		'dyna_usercat_descmax' => array(
			'title' => 'Maximum Length of Description',
			'description' => 'The maximum number of characters allowed in the description for user created categories.',
			'value' => '250', 
			'optioncode' => '',
			'displayorder' => '40',
			'serialize' => 0
		),
		'dyna_caticon_ext' => array(
			'title' => 'Allowed Category Icon Extensions',
			'description' => 'If you allow any usergroups to upload category icons, you may restrict what types of images they may upload here. Separate each extension with a space.',
			'value' => 'jpg gif png', 
			'optioncode' => '',
			'displayorder' => '50',
			'serialize' => 0
		),
		'dyna_caticon_dimensions' => array(
			'title' => 'Category Icons Maximum Width/Height',
			'description' => 'The maximum width and/or height (in pixels) allowed for category icons.',
			'value' => '50', 
			'optioncode' => '',
			'displayorder' => '60',
			'serialize' => 0
		),
		'dyna_caticon_filesize' => array(
			'title' => 'Category Icons Maximum Filesize',
			'description' => 'The maximum filesize (in bytes) allowed for category icons.',
			'value' => '20480', 
			'optioncode' => '',
			'displayorder' => '70',
			'serialize' => 0
		),
		'dyna_newcatsattop' => array(
			'title' => 'New Category Display Order',
			'description' => 'When enabled, this option will add newly created user categories to the top of the list. Otherwise the categories will be added at the end.',
			'value' => '2', 
			'optioncode' => '<div class=\\"smallfont\\">
	<input " . iif($setting[\'value\'] == 2, \'checked="checked"\'). "type=\\"radio\\" id=\\"newcatsattop_2\\" name=\\"$name\\" value=\\"2\\" /><label for=\\"newcatsattop_2\\">" . $vbphrase[\'user_choice\'] . "</label><br />
	<input " . iif($setting[\'value\'] == 1, \'checked="checked"\'). "type=\\"radio\\" id=\\"newcatsattop_1\\" name=\\"$name\\" value=\\"1\\" /><label for=\\"newcatsattop_1\\">" . $vbphrase[\'top\'] . "</label><br />
		<input " . iif($setting[\'value\'] == 0, \'checked="checked"\'). " type=\\"radio\\" id=\\"newcatsattop_0\\" name=\\"$name\\" value=\\"0\\" /><label for=\\"newcatsattop_0\\">" . $vbphrase[\'bottom\'] . "</label><br />
</div>',
			'displayorder' => '80',
			'serialize' => 0
		),
		'dyna_cats_editmoderation' => array(
			'title' => 'Send Categories Back to Moderation Que if Modified',
			'description' => 'Turning this option on will cause categories to be sent back to the moderation que when edited if the member does not belong to a usergroup that does not require moderation for categories. Turn this option off to allow categories to be edited without sending them back to the moderation que.',
			'value' => '0', 
			'optioncode' => 'yesno',
			'displayorder' => '90',
			'serialize' => 0
		)
);

$mainsettings['adv_dyna_moduleopts'] = array(
	'dyna_enablemodules' => array(
			'title' => 'Enable Module System',
			'description' => 'Modules are different boxes that can be added throughout the vBadvanced Dynamics system. This option will allow you to completely disable the use of modules.',
			'value' => '1', 
			'optioncode' => 'yesno',
			'displayorder' => '10',
			'serialize' => 0
		),
		'dyna_leftcolwidth' => array(
			'title' => 'Left Column Width',
			'description' => 'The width (in pixels or percentage) of your left column.',
			'value' => '200', 
			'optioncode' => '',
			'displayorder' => '20',
			'serialize' => 0
		),
		'dyna_rightcolwidth' => array(
			'title' => 'Right Column Width',
			'description' => 'The width (in pixels or percentage) of your right column.',
			'value' => '200', 
			'optioncode' => '',
			'displayorder' => '30',
			'serialize' => 0
		),
		'dyna_colspacing' => array(
			'title' => 'Horizontal Spacing Between Columns',
			'description' => 'This is the amount of space (in pixels) that is between the different columns.',
			'value' => '15', 
			'optioncode' => '',
			'displayorder' => '40',
			'serialize' => 0
		),
		'dyna_vspace' => array(
			'title' => 'Verticle Spacing Between Modules',
			'description' => 'The amount of verticle space (in pixels) between each module.',
			'value' => '15', 
			'optioncode' => '',
			'displayorder' => '50',
			'serialize' => 0
		),
		'dyna_blockbullet' => array(
			'title' => 'Module Title Bullet',
			'description' => 'Here you may enter any HTML code which you would like to appear next to the title of each block.',
			'value' => '&raquo;', 
			'optioncode' => '',
			'displayorder' => '60',
			'serialize' => 0
		),
		'dyna_collapsemods' => array(
			'title' => 'Enable Collapsable Modules',
			'description' => 'This option will allow your modules to be collapsed/expanded by your users.',
			'value' => '1', 
			'optioncode' => 'yesno',
			'displayorder' => '70',
			'serialize' => 0
		),
		'dyna_allow_module_smilie' => array(
			'title' => 'Allow Smilies in Custom Modules',
			'description' => 'Turn this option on to allow your members to use smilies in their custom modules.',
			'value' => '1', 
			'optioncode' => 'yesno',
			'displayorder' => '80',
			'serialize' => 0
		),
		'dyna_allow_module_bbcode' => array(
			'title' => 'Allow BB Code in Custom Modules',
			'description' => 'Turn this option on to allow your members to use BB code in their custom modules.',
			'value' => '1', 
			'optioncode' => 'yesno',
			'displayorder' => '90',
			'serialize' => 0
		),
		'dyna_allow_module_img' => array(
			'title' => 'Allow [IMG] Tag in Custom Modules',
			'description' => 'Turn this option on to allow your members to use the [IMG] BB code tag in their modules.',
			'value' => '1', 
			'optioncode' => 'yesno',
			'displayorder' => '100',
			'serialize' => 0
		)
);

$mainsettings['adv_dyna_seo'] = array(
	'dyna_spiderurls' => array(
			'title' => 'Enable Spider Friendly URL\'s',
			'description' => 'This option will replace your normal URL\'s (Ex: /{dyna}/browsecategory.php?c=2) with more spider friendly URL\'s (Ex: /{dyna}/main-category/). Please note that you must upload the .htaccess file that comes in the "Extras (do not upload)" folder of the download package to your {dyna} folder if you intend to use this option.',
			'value' => '0', 
			'optioncode' => 'yesno',
			'displayorder' => '10',
			'serialize' => 0
		),
		'dyna_spider_cattext' => array(
			'title' => 'Category URL Override',
			'description' => 'By default, the software will use the category title within the URL when spider friendly links are enabled. If you would like to use a static phrase in your category URL\'s instead, enter the text that you would like to use here.',
			'value' => '', 
			'optioncode' => '',
			'displayorder' => '20',
			'serialize' => 0
		),
		'dyna_spider_entrytext' => array(
			'title' => 'Entry URL Override',
			'description' => 'By default, the software will use the entry title within the URL when spider friendly links are enabled. If you would like to use a static phrase in your entry URL\'s instead, enter the text that you would like to use here.',
			'value' => '', 
			'optioncode' => '',
			'displayorder' => '30',
			'serialize' => 0
		),
		'dyna_spider_memberscattext' => array(
			'title' => 'Members Category Username URL Override',
			'description' => 'By default, the software will use the members\' username within the URL for members\' categories when spider friendly links are enabled. If you would like to use a static phrase in your members\' category URL\'s instead, enter the text that you would like to use here.',
			'value' => '', 
			'optioncode' => '',
			'displayorder' => '40',
			'serialize' => 0
		)
);

$mainsettings['adv_dyna_external'] = array(
	'dyna_exter_rss' => array(
			'title' => 'Enable RSS Syndication',
			'description' => 'Turn this option on to allow your members to subscribe to your members\' entries via RSS syndication.',
			'value' => '1', 
			'optioncode' => 'yesno',
			'displayorder' => '10',
			'serialize' => 0
		),
		'dyna_exter_cachelife' => array(
			'title' => 'Cache Lifespan',
			'description' => 'The amount of time (in minutes) between updates for the cache.',
			'value' => '30', 
			'optioncode' => '',
			'displayorder' => '20',
			'serialize' => 0
		),
		'dyna_exter_deflimit' => array(
			'title' => 'Default Number of Entries to Display',
			'description' => 'The default number of entries to display within the RSS feed.',
			'value' => '15', 
			'optioncode' => '',
			'displayorder' => '30',
			'serialize' => 0
		),
		'dyna_exter_maxlimit' => array(
			'title' => 'Maximum Number of Entries to Display',
			'description' => 'This option will allow users to add &quot;&count=X&quot; (without the quotes) to the RSS feed\'s URL to display more than the default number of entries, up to the limit specified here.',
			'value' => '50', 
			'optioncode' => '',
			'displayorder' => '40',
			'serialize' => 0
		),
		'dyna_extr_subcats' => array(
			'title' => 'Include Sub-Categories In Results',
			'description' => 'Turn this option on if you would like to include entries made in sub-categories when viewing an RSS feed.',
			'value' => '1', 
			'optioncode' => 'yesno',
			'displayorder' => '50',
			'serialize' => 0
		)
);

?>