<?php
// ++=========================================================================++
// || vBadvanced Dynamics v1.0.0 (vB 3.6 - vB 3.7)
// ||  2003-2007 vBadvanced.com - All Rights Reserved
// || This file may not be redistributed in whole or significant part.
// || http://vbadvanced.com
// ++ ========================================================================++

error_reporting(E_ALL & ~E_NOTICE);

// Load the $vba_dyna class
require_once(DIR . '/includes/vba_dyna_class.php');
require_once(DIR . '/includes/vba_dyna_functions.php');

$vba_dyna =& new vba_dyna($vbulletin);
$vba_dyna->vbulletin =& $vbulletin;

$getinstances = $vbulletin->db->query_read("SELECT grouptitle FROM " . TABLE_PREFIX . "adv_setting WHERE varname = 'dyna_version'");
while ($instance = $vbulletin->db->fetch_array($getinstances))
{
	$dyna_prefix = substr($instance['grouptitle'], 0, (strlen($instance['grouptitle']) - 5));

	$datastore = array();
	$getdatastore = $vbulletin->db->query_read("SELECT title, data FROM " . TABLE_PREFIX . "datastore WHERE title IN(
		'" . $dyna_prefix . "_cats',
		'" . $dyna_prefix . "_perms'
	)");
	while ($dstore = $vbulletin->db->fetch_array($getdatastore))
	{
		$vbulletin->$dstore['title'] = unserialize($dstore['data']);
	}

	$mod_options = array();
	$getoptions = $vbulletin->db->query_read("
		SELECT varname, value, serialize FROM " . TABLE_PREFIX . "adv_setting
		WHERE grouptitle = '" . $dyna_prefix . "_modules_randomentries'
	");
	while ($options = $vbulletin->db->fetch_array($getoptions))
	{
		if ($options['serialize'])
		{
			$options['value'] = unserialize($options['value']);
		}

		$mod_options[$options['varname']] = $options['value'];
	}

	if ($mod_options['dyna_newrand_limit'] AND $mod_options['dyna_newrand_orderby'])
	{
		$randlimit = $mod_options['dyna_newrand_limit'] * 10;

		if ($randlimit < 50)
		{
			$randlimit = 50;
		}
		else if ($randlimit > 200)
		{
			$randlimit = 200;
		}

		$entryids = array();
		$catids = array();

		convert_prefixed_datastore($dyna_prefix);

		foreach ($vbulletin->usergroupcache AS $groupid => $group)
		{
			// Find categories that guests can view and try to pull from those first
			$vba_dyna->default_permissions(array($groupid));

			$vba_dyna->fetch_category_perms(0, $groupid);

			$catids[$groupid] = array();
			foreach ($vbulletin->adv_dyna_cats AS $catid => $catinfo)
			{
				if ($vba_dyna->check_cat_perms('canviewentries', $catinfo))
				{
					$catids[$groupid][] = $catid;
				}
			}

			if ($mod_options['dyna_exclude_cats'])
			{
				$catids[$groupid] = array_diff($catids[$groupid], $mod_options['dyna_exclude_cats']);
			}

			if (!empty($catids))
			{
				foreach ($catids AS $catgroupid => $catgroup)
				{
					if ($catgroupid != $groupid AND !empty($entryids[$groupid]['entries']) AND !array_diff($catids[$catgroupid], $catids[$groupid]))
					{
						$entryids[$groupid]['entrygroup'] = $catgroupid;
						unset($catids[$groupid]);
					}
				}
			}

			if ($entryids[$groupid]['entrygroup'])
			{
				continue;
			}

			// Fetch some random entryids
			if (!empty($catids[$groupid]))
			{
				$getentries = $vbulletin->db->query_read("
					SELECT entryid
					FROM " . TABLE_PREFIX . $dyna_prefix . "_entries
					WHERE catid IN(" . implode(',', $catids[$groupid]) . ")
						AND draft = 0
						AND valid = 1
						AND private = 0
					ORDER BY RAND()
					LIMIT " . ($mod_options['dyna_newrand_limit'] * 10)
				);
				while ($entry = $vbulletin->db->fetch_array($getentries))
				{
					$entryids[$groupid]['entries'][] = $entry['entryid'];
				}
			}
		}

		build_datastore($dyna_prefix . '_rand', serialize($entryids), 1);

		$vbulletin->db->free_result($getentries);
		unset($entry);
	}
}

log_cron_action('', $nextitem, 1);

?>