<?php
// ++=========================================================================++
// || vBadvanced Dynamics v1.0.0 (vB 3.6 - vB 3.7)
// ||  2003-2007 vBadvanced.com - All Rights Reserved
// || This file may not be redistributed in whole or significant part.
// || http://vbadvanced.com
// ++ ========================================================================++

error_reporting(E_ALL & ~E_NOTICE);

// ##### Build Stats ##########################################################
function build_stats(&$vba_cats)
{
	global $stats, $cat;

	if (!$cat)
	{
		$stats['categories']++;
		$stats['entries'] += $vba_cats['entrycount'];
		$stats['posts'] += $vba_cats['postcount'];
	}
}

// ##### Order Members Categories #############################################
// Simple functions for entry/postcount ordering
function order_memcats_desc($a, $b)
{
	global $memorder;
	return ($a[$memorder] > $b[$memorder]) ? -1 : 1;
}

function order_memcats_asc($a, $b)
{
	global $memorder;
	return ($a[$memorder] < $b[$memorder]) ? -1 : 1;
}

// ##### Print Categories #####################################################
function print_categories($cat = 0, $type = 'normal')
{
	global $db, $vbulletin, $vba_dyna, $vba_options, $vbcollapse, $stylevar, $vbphrase, $show, $stats, $catpagedata, $catpagenav;

	if ($cat)
	{
		$maincatinfo =& $vbulletin->adv_dyna_cats[$cat];
	}

	if ($maincatinfo['memberscat'] AND !$vbulletin->GPC['entryuserid'])
	{
		$type = 'catmember';
	}

	$catinfo = array();
	$catcounters = array();

	($hook = vBulletinHook::fetch_hook('vba_dyna_functions_print_categories_start')) ? eval($hook) : false;

	switch ($type)
	{
		// ##### Subscriptions
		case 'subscriptions':

			$getsubcats = $db->query("
				SELECT categories.*
				FROM " . ADV_DYNA_TABLE_PREFIX . "subscribecat AS subscribecat
				INNER JOIN " . ADV_DYNA_TABLE_PREFIX . "categories AS categories ON (categories.catid = subscribecat.catid)
				WHERE subscribecat.userid = " . $vbulletin->userinfo['userid'] . "
					AND subscribecat.entryuserid = 0
				ORDER BY displayorder
			");
			if ($db->num_rows($getsubcats))
			{
				$show['subcats'] = true;

				while ($subcats = $db->fetch_array($getsubcats))
				{
					$subcats['level'] = 1;

					$catinfo[$subcats['catid']] = $subcats;
				}
			}

			$db->free_result($getsubcats);
			unset($subcats);

			// Subscribed Members Categories
			$getsubcats = $db->query("
				SELECT memberscats.*, hasentries, categories.valid, categories.active, subscribecat.catid, subscribecat.entryuserid, user.username
				FROM " . ADV_DYNA_TABLE_PREFIX . "subscribecat AS subscribecat
				LEFT JOIN " . ADV_DYNA_TABLE_PREFIX . "memberscats AS memberscats ON (memberscats.catid = subscribecat.catid AND subscribecat.entryuserid = memberscats.userid)
				LEFT JOIN " . ADV_DYNA_TABLE_PREFIX . "categories AS categories ON (memberscats.catid = categories.catid)
				LEFT JOIN " . TABLE_PREFIX . "user AS user ON (subscribecat.entryuserid = user.userid)
				WHERE subscribecat.userid = " . $vbulletin->userinfo['userid'] . "
					AND subscribecat.entryuserid != 0
				ORDER BY username
			");
			if ($db->num_rows($getsubcats))
			{
				$show['submembercats'] = true;

				while ($subcats = $db->fetch_array($getsubcats))
				{
					$subcats['level'] = 1;

					$subcats['memberscat'] = true;
					$subcats['ismembercat'] = true;
					$subcats['hasentries'] = true;
					$subcats['userid'] = $subcats['entryuserid'];
					$subcats['title'] = $subcats['username'];
					$subcats['cattitle'] = $vbulletin->adv_dyna_cats[$subcats['catid']]['title'];
					$subcats['mainlink'] = fetch_cat_url($subcats['catid']);
					$catinfo[$subcats['catid'] . '-' . $subcats['entryuserid']] = $subcats;
				}
			}

			$db->free_result($getsubcats);
			unset($subcats);
		break;

		// ##### Members' Category
		case 'member':
		case 'catmember':

			global $alphabet, $ltr, $memorder;

			$membercats = true;
			$show['notbody'] = true;

			$memberwhere = array();
			// Limit to the catid if specified
			if ($cat)
			{
				$memberwhere[] = 'catid IN(' . implode(',', fetch_category_children($cat)) . ')';
			}

			// Specific letter
			if ($ltr)
			{
				if ($ltr AND ($ltr == 'nonalpha' OR in_array($ltr, $alphabet)))
				{
					$memberwhere[] = iif($ltr == 'nonalpha', 'username NOT REGEXP("^[a-zA-Z]")', 'username LIKE(\'' . $ltr . '%\')');
				}
			}

			// Ignored users
			if (!$ignusers AND $ignusers !== false)
			{
				$ignusers = fetch_ignored_users();
			}
			if ($ignusers)
			{
				$memberwhere[] = 'memberscats.userid NOT IN(' . $ignusers . ')';
			}

			if (!empty($memberwhere))
			{
				$wherequery = 'WHERE ' . implode(' AND ', $memberwhere);
			}

			$usercategories = false;
			if ($maincatinfo['memberscat'])
			{
				foreach ($vbulletin->adv_dyna_cats AS $ckcatid => $ckcat)
				{
					if ($ckcat['parent'] == $cat AND $ckcat['catuserid'])
					{
						$usercategories = true;
					}
				}
			}

			$catordernav = '';

			if ($vbulletin->GPC['catdir'] OR $memorder != 'username')
			{
				if ($vba_options['dyna_spiderurls'])
				{
					$catordernav .= '?';
				}

				$memdir = 'ASC';
				if ($vbulletin->GPC['catdir'] == 'ASC' OR $vbulletin->GPC['catdir'] == 'DESC')
				{
					$memdir = $vbulletin->GPC['catdir'];
					$catordernav .= 'catdir=' . $memdir;
				}

				if ($memorder != 'username')
				{
					$catordernav .= iif($catordernav, '&amp;') . 'catorder=' . $memorder;
				}
			}

			// Query members' categories
			$getcats = $db->query_read("
				SELECT memberscats.*, user.username
				FROM " . ADV_DYNA_TABLE_PREFIX . "memberscats AS memberscats
				LEFT JOIN " . TABLE_PREFIX . "user AS user ON (memberscats.userid = user.userid)
	  		$wherequery
	  		ORDER BY $memorder $memdir
			");
			if ($db->num_rows($getcats))
			{
				while ($vba_cats = $db->fetch_array($getcats))
				{
					// Prevent entries posted to sub-categories in another member's
					// category from creating a new category for the author of that entry
					if ($realcatinfo['catuserid'] AND $type == 'catmember')
					{
						$vba_cats['userid'] = $realcatinfo['catuserid'];
						$vba_cats['username'] = $realcatinfo['username'];
					}

					$catrowid = $vba_cats['userid'];

					if (!isset($catinfo[$catrowid]))
					{
						if (!$vba_cats['userid'] OR !$vba_cats['entrycount'])
						{
							continue;
						}

						if ($vba_cats['title'] AND $type == 'catmember')
						{
							$catinfo[$catrowid]['title'] = $vba_cats['title'];
							$catinfo[$catrowid]['catuserid'] = $vba_cats['userid'];
							$catinfo[$catrowid]['username'] = $vba_cats['username'];
						}
						else
						{
							$catinfo[$catrowid]['title'] = $vba_cats['username'];
						}
						$catinfo[$catrowid]['description'] = $vba_cats['description'];
						$catinfo[$catrowid]['memberscat'] = 1;
						$catinfo[$catrowid]['parent'] = $cat;
						$catinfo[$catrowid]['catid'] = $vba_cats['catid'];
						$catinfo[$catrowid]['userid'] = $vba_cats['userid'];
						$catinfo[$catrowid]['active'] = 1;
						$catinfo[$catrowid]['valid'] = 1;
						$catinfo[$catrowid]['hasentries'] = 1;
					}

					$catinfo[$catrowid]['entrycount'] += $vba_cats['entrycount'];
					$catinfo[$catrowid]['postcount'] += $vba_cats['postcount'];

					// Last entry
					if ($vba_cats['lastentrydateline'] > $catinfo[$catrowid]['lastentrydateline'])
					{
						$catinfo[$catrowid]['lastentryrealcatid'] = $vba_cats['catid'];
						$catinfo[$catrowid]['lastentrydateline'] = $vba_cats['lastentrydateline'];
						$catinfo[$catrowid]['lastentrytitle'] = $vba_cats['lastentrytitle'];
						$catinfo[$catrowid]['lastentryid'] = $vba_cats['lastentryid'];
						$catinfo[$catrowid]['lastentryusername'] = $vba_cats['lastentryusername'];
						$catinfo[$catrowid]['lastentryuserid'] = $vba_cats['lastentryuserid'];
					}

					// Last post
					if ($vba_cats['lastpostdateline'] > $catinfo[$catrowid]['lastpostdateline'])
					{
						$catinfo[$catrowid]['lastpostrealcatid'] = $vba_cats['catid'];
						$catinfo[$catrowid]['lastpostid'] = $vba_cats['lastpostid'];
						$catinfo[$catrowid]['lastpostentryid'] = $vba_cats['lastpostentryid'];
						$catinfo[$catrowid]['lastpostdateline'] = $vba_cats['lastpostdateline'];
						$catinfo[$catrowid]['lastpostentrytitle'] = $vba_cats['lastpostentrytitle'];
						$catinfo[$catrowid]['lastpostusername'] = $vba_cats['lastpostusername'];
						$catinfo[$catrowid]['lastpostuserid'] = $vba_cats['lastpostuserid'];
					}
				}

				// entry/post count sorting
				if ($memorder != 'username')
				{
					usort($catinfo, 'order_memcats_' . strtolower($memdir));
				}

				$membercatcount = sizeof($catinfo);

				$catpagedata = fetch_page_data(
					'',
					array(),
					array(),
					$vba_options['dyna_memberscatsperpage'],
					$membercatcount
				);

				replace_page_nav_links();

				$catpagenav = construct_page_nav(
					$catpagedata['pagenumber'],
					$catpagedata['perpage'],
					$catpagedata['count'],
					fetch_cat_url($cat, array(), iif(!$cat, 'memberpagenav')),
					$catordernav
				);

				$splice1 = $catpagedata['minlimit'] - 1;
				$splice2 = $catpagedata['perpage'];
				$catinfo = array_slice($catinfo, $splice1, $splice2);
			}
			else if (!$usercategories)
			{
				return '<tr><td class="alt1" colspan="6">' . construct_phrase($vbphrase['no_x_to_display'], $vbphrase['categories']) . '</td></tr>';
			}

			$db->free_result($getcats);
			unset($vba_cats);

		break;

		// ##### Main category listing
		case 'main':

			$catinfo =& $vbulletin->adv_dyna_cats;

		break;

		// ##### User Categories
		case 'usercats':

			global $catsinfo;

			$catinfo =& $catsinfo;

		break;

		// ##### Normal Category
		default:
			$catinfo = construct_categories($vbulletin->adv_dyna_cats, $cat);

			if ($vbulletin->GPC['entryuserid'] AND !empty($catinfo))
			{
				$removedparents = array();
				foreach ($catinfo AS $cats)
				{
					if ($cats['catuserid'] != $vbulletin->GPC['entryuserid'])
					{
						if ($cats['level'] == 1 OR in_array($cats['parent'], $removedparents))
						{
							$removedparents[] = $cats['catid'];
							unset($catinfo[$cats['catid']]);
						}
					}
				}
			}

			$catids = array();
			if (!empty($catinfo))
			{
				foreach ($catinfo AS $cats)
				{
					if ($cats['catid'] != $cat)
					{
						$catids[] = $cats['catid'];
					}
				}
			}

			$catids = implode(',', $catids);

			if (!$catids)
			{
				return false;
			}
	}
	// End switch($type)

	if ($vba_options['dyna_catdepth'] > 2)
	{
		$vba_options['dyna_catdepth'] = 2;
	}

	// Add up the counters and last entry/post stuff
	if (!$membercats AND $type != 'subscriptions')
	{
		$catcounters = fetch_category_counts($catids, (($type == 'normal' AND !$cat) OR $type == 'members' ? true : false));
	}

	if (empty($catinfo))
	{
		return false;
	}

	$vbulletin->templatecache['forumhome_moderator'] = str_replace('"member.php', '"' . $vbulletin->options['bburl'] . '/member.php', $vbulletin->templatecache['forumhome_moderator']);

	$subcatcolsize = 0;
	if ($vba_options['dyna_showsubcats'] > 1)
	{
		$subcatcolsize = floor(100 / $vba_options['dyna_showsubcats']);
	}

	// ##### Process the array and print out the categories
	foreach ($catinfo AS $cinfoid => $catquery)
	{
		if ($membercats OR $type == 'subscriptions' OR $type == 'usercats')
		{
			$cats =& $catquery;
		}
		else
		{
			// Make sure we're using the proper level since we could be viewing sub-cats
			if (!$catcounters[$cinfoid]['level'] AND $catquery['level'])
			{
				$catcounters[$cinfoid]['level'] = $catquery['level'];
			}
			$cats = $vbulletin->adv_dyna_cats[$cinfoid];
			$catquery =& $catcounters[$cinfoid];
		}

		($hook = vBulletinHook::fetch_hook('vba_dyna_functions_print_categories_loop')) ? eval($hook) : false;

		if (!$catquery['level'] AND $cats['level'])
		{
			$catquery['level'] = $cats['level'];
		}

		// Check permissions
		if (
			($cats['catid'] AND (!$vba_dyna->check_cat_perms('canviewdyna', $cats) OR !$cats['active'] OR !$cats['valid'] OR $catquery['level'] > 2 OR $catquery['level'] > $vba_options['dyna_catdepth']))
			OR ($vba_options['dyna_hideemptycats'] AND !$catquery['entrycount'] AND $type != 'subscriptions')
			OR ($vbulletin->adv_dyna_cats[$cats['parent']]['memberscat'] AND $type != 'usercats' AND (($cat != $cats['parent']) OR !$cats['parent']))
		)
		{
			continue;
		}

		$catcount++;

		if ($membercats)
		{
			$cats['catid'] = $cat;
		}

		// Link
		$cats['link'] = fetch_cat_url(
			$cats['catid'],
			iif($type == 'member' OR $cats['memberscat'] OR $maincatinfo['memberscat'], $cats, array()),
			$type
		);

		if (!$cats['hasentries'])
		{
			$catcollapse = $vbcollapse['collapseobj_catbit_' . $cats['catid']];
			$catimgcollapse = $vbcollapse['collapseimg_catbit_' . $cats['catid']];

			eval('$categorybits .= "' . fetch_template(ADV_DYNA_PREFIX . '_categorybit_main') . '";');
		}
		else
		{
			// Sub categories
			$subcatbits = '';
			$subcatcomma = '';
			$subcatsperrow = '';
			$subcatrowcount = '';
			$firstsubcat = true;
			if (!empty($catquery['subcats']))
			{
				foreach ($catquery['subcats'] AS $subcatid => $subcats)
				{
					if (!$vba_dyna->check_cat_perms('canviewdyna', $subcats))
					{
						continue;
					}

					// Put them into columns if necessary
					if ($vba_options['dyna_showsubcats'] > 1)
					{
						if (!$subcatbits)
						{
							$subcatsperrow = ceil(sizeof($catquery['subcats']) / $vba_options['dyna_showsubcats']);
							$subcatbits = '<table width="100%" cellspacing="0" cellpadding="1"><tr><td width="' . $subcatcolsize . '%" valign="top">';
						}

						if ($subcatrowcount == $subcatsperrow)
						{
							$subcatbits .= '</td><td width="' . $subcatcolsize . '%" valign="top">';
							$subcatrowcount = 0;
						}

						$subcatrowcount++;
					}

					// On/off indicators
					if ($vba_options['dyna_showonoff'])
					{
						$subonoff = iif($subcats['lastentrydateline'] > $vbulletin->userinfo['lastvisit'] OR $subcats['lastpostdateline'] > $vbulletin->userinfo['lastvisit'], 'new', 'old');
					}

					// Link
					$subcats['link'] .= fetch_cat_url($subcats['catid']);

					eval('$subcatbits .= "$subcatcomma' . fetch_template(ADV_DYNA_PREFIX . '_categorybit_subcat') . '";');

					if ($vba_options['dyna_showsubcats'] < 2)
					{
						$subcatcomma = ', ';
					}
					else if ($subcatrowcount != $subcatsperrow)
					{
						$subcatcomma = '<br />';
					}
					else
					{
						$subcatcomma = '';
					}

					$firstsubcat = false;
				}

				if ($subcatbits AND $vba_options['dyna_showsubcats'] > 1)
				{
					$subcatbits .= '</td></tr></table>';
				}
			}

			// Moderators
			if ($show['modcolumn'] AND $type != 'members')
			{
				$cats['moderator'] = fetch_cat_moderators($cats['catid']);
			}

			// On/off indicators
			if ($vba_options['dyna_showonoff'])
			{
				if ($vbulletin->userinfo['lastvisit'] < $catquery['lastentrydateline'] OR $vbulletin->userinfo['lastvisit'] < $catquery['lastpostdateline'])
				{
					$onoff = 'new';
				}
				else
				{
					$onoff = 'old';
				}
			}

			if (!$vba_options['dyna_showentrycount'])
			{
				if (!check_category_password($cats['catid'], false))
				{
					$cats['nopass'] = true;
				}
			}

			if (!$cats['nopass'] AND ($vba_dyna->check_cat_perms('canviewentries', $cats)) OR $vba_options['dyna_showentrycount'])
			{
				$cats['entrycount'] = vb_number_format($catquery['entrycount']);

				// Last entry
				if ($catquery['lastentrydateline'])
				{
					$cats['lastentry'] = array(
						'catid' => $catquery['lastentryrealcatid'],
						'title' => $catquery['lastentrytitle'],
						'entryid' => $catquery['lastentryid']
					);

					fetch_entry_url($cats['lastentry']);
					$cats['lastentrylink'] = $cats['lastentry']['url'];

					$cats['lastentryid'] =& $catquery['lastentryid'];
					$cats['lastentryuserid'] =& $catquery['lastentryuserid'];
					$cats['lastentryusername'] =& $catquery['lastentryusername'];

					$cats['lastupdateddate'] = vbdate($vbulletin->options['dateformat'], $catquery['lastentrydateline']);
					$cats['lastupdatedtime'] = vbdate($vbulletin->options['timeformat'], $catquery['lastentrydateline']);
					$cats['lastentrytitle'] = fetch_trimmed_title($catquery['lastentrytitle'], $vba_options['dyna_lastentry_maxlength']);
				}
			}
			else
			{
				$cats['lastentryid'] = '';
				$cats['entrycount'] = 0;
			}

			// Last post
			if ((!$cats['nopass'] AND $vba_dyna->check_cat_perms('canviewreplies', $cats)) OR $vba_options['dyna_showentrycount'])
			{
				$cats['postcount'] = vb_number_format($catquery['postcount']);
				if ($catquery['lastpostdateline'])
				{

					$cats['lastpost'] = array(
						'catid' => $catquery['lastpostrealcatid'],
						'title' => $catquery['lastpostentrytitle'],
						'entryid' => $catquery['lastpostentryid']
					);

					fetch_entry_url($cats['lastpost'], '&amp;epostid=' . $catquery['lastpostid'] . '#post' . $catquery['lastpostid']);

					$cats['lastpostlink'] = $cats['lastpost']['url'];

					$cats['lastpostdateline'] =& $catquery['lastpostdateline'];
					$cats['lastpostid'] =& $catquery['lastpostid'];
					$cats['lastpostentryid'] =& $catquery['lastpostentryid'];
					$cats['lastpostuserid'] =& $catquery['lastpostuserid'];
					$cats['lastpostusername'] =& $catquery['lastpostusername'];

					$cats['lastpostentrytitle'] = fetch_trimmed_title($catquery['lastpostentrytitle'], $vba_options['dyna_lastentry_maxlength']);
					$cats['lastpostdate'] = vbdate($vbulletin->options['dateformat'], $catquery['lastpostdateline']);
					$cats['lastposttime'] = vbdate($vbulletin->options['timeformat'], $catquery['lastpostdateline']);
				}
			}
			else
			{
				$cats['postcount'] = 0;
				$cats['lastpostid'] = '';
			}

			if ($catquery['level'] == 0)
			{
				$catquery['level'] = 1;
			}

			eval('$categorybits .= "' . fetch_template(ADV_DYNA_PREFIX . '_categorybit_level' . $catquery['level']) . '";');
		}
	}
	unset($catinfo, $cats);


	return $categorybits;
}

// ##### Fetch Category Counters ##############################################
function fetch_category_counts($catids = false, $level = true)
{
	global $db, $vbulletin, $vba_dyna, $vba_options;

	$getcats = $db->query("
		SELECT catid, title, description, parent, parentlist, caticon, entrycount, postcount, active, valid, lastentryid, lastentrytitle, lastentryusername,lastentryuserid, lastentrydateline, lastpostid, lastpostentryid, lastpostuserid, lastpostusername, lastpostentrytitle, lastpostdateline
		FROM " . ADV_DYNA_TABLE_PREFIX . "categories
		" . iif($catids, "WHERE catid IN($catids)") . "
		ORDER BY $vba_options[dyna_catsorder] $vba_options[dyna_catsdir], hasentries
	");
	while ($vba_cats = $db->fetch_array($getcats))
	{
		if (!$vba_cats['valid'])
		{
			continue;
		}

		$catrowid =& $vba_cats['catid'];
		$maincat =& $vbulletin->adv_dyna_cats[$catrowid];

		if ($vba_cats['parent'] AND !$vbulletin->adv_dyna_cats[$vba_cats['parent']]['active'])
		{
			$maincat['active'] = 0;
			continue;
		}

		$maincat['description'] = $vba_cats['description'];
		$maincat['caticon'] = $vba_cats['caticon'];

		if ($level)
		{
			$catinfo[$catrowid]['level'] = $maincat['level'];
		}

		if ($vba_dyna->check_cat_perms('canviewdyna', $vba_cats) OR $vba_options['dyna_showentrycount'])
		{
			// Stats for the homepage
			build_stats($vba_cats);

			// Last entry
			if ($vba_cats['lastentrydateline'] > $catinfo[$catrowid]['lastentrydateline'])
			{
				$catinfo[$catrowid]['lastentryrealcatid'] = $vba_cats['catid'];
				$catinfo[$catrowid]['lastentrydateline'] = $vba_cats['lastentrydateline'];
				$catinfo[$catrowid]['lastentrytitle'] = $vba_cats['lastentrytitle'];
				$catinfo[$catrowid]['lastentryid'] = $vba_cats['lastentryid'];
				$catinfo[$catrowid]['lastentryusername'] = $vba_cats['lastentryusername'];
				$catinfo[$catrowid]['lastentryuserid'] = $vba_cats['lastentryuserid'];
			}

			// Last post
			if ($vba_cats['lastpostdateline'] > $catinfo[$catrowid]['lastpostdateline'])
			{
				$catinfo[$catrowid]['lastpostrealcatid'] = $vba_cats['catid'];
				$catinfo[$catrowid]['lastpostid'] = $vba_cats['lastpostid'];
				$catinfo[$catrowid]['lastpostentryid'] = $vba_cats['lastpostentryid'];
				$catinfo[$catrowid]['lastpostdateline'] = $vba_cats['lastpostdateline'];
				$catinfo[$catrowid]['lastpostentrytitle'] = $vba_cats['lastpostentrytitle'];
				$catinfo[$catrowid]['lastpostusername'] = $vba_cats['lastpostusername'];
				$catinfo[$catrowid]['lastpostuserid'] = $vba_cats['lastpostuserid'];
			}

			// Subcats
			if (
				$maincat['level'] == ($vba_options['dyna_catdepth'] + 1)
					AND $vba_options['dyna_showsubcats']
					AND $vba_dyna->check_cat_perms('canviewdyna', $vba_cats)
					AND $vbulletin->adv_dyna_cats[$vba_cats['parent']]['level']
					AND !$vbulletin->adv_dyna_cats[$vba_cats['parent']]['memberscat']
					AND $vba_cats['active']
					AND $vba_cats['valid']
			)
			{
				$catinfo[$vba_cats['parent']]['subcats'][$catrowid]['catid'] = $vba_cats['catid'];
				$catinfo[$vba_cats['parent']]['subcats'][$catrowid]['title'] = $vba_cats['title'];
				$catinfo[$vba_cats['parent']]['subcats'][$catrowid]['lastentrydateline'] = $vba_cats['lastentrydateline'];
				$catinfo[$vba_cats['parent']]['subcats'][$catrowid]['lastpostdateline'] = $vba_cats['lastpostdateline'];
			}

			// Figure out the entry/post counts & last entry/post stuff
			if ($vba_cats['parentlist'] AND $type != 'subscriptions')
			{
				foreach (explode(',', $vba_cats['parentlist']) AS $parid)
				{
					if ($vbulletin->adv_dyna_cats[$parid]['level'])
					{
						$catinfo[$parid]['entrycount'] += $vba_cats['entrycount'];
						$catinfo[$parid]['postcount'] += $vba_cats['postcount'];

						if ($vba_cats['lastentrydateline'] > $catinfo[$parid]['lastentrydateline'])
						{
							$catinfo[$parid]['lastentryrealcatid'] = $vba_cats['catid'];
							$catinfo[$parid]['lastentrydateline'] = $vba_cats['lastentrydateline'];
							$catinfo[$parid]['lastentrytitle'] = $vba_cats['lastentrytitle'];
							$catinfo[$parid]['lastentryid'] = $vba_cats['lastentryid'];
							$catinfo[$parid]['lastentryusername'] = $vba_cats['lastentryusername'];
							$catinfo[$parid]['lastentryuserid'] = $vba_cats['lastentryuserid'];
						}

						if ($vba_cats['lastpostdateline'] > $catinfo[$parid]['lastpostdateline'])
						{
							$catinfo[$parid]['lastpostrealcatid'] = $vba_cats['catid'];
							$catinfo[$parid]['lastpostid'] = $vba_cats['lastpostid'];
							$catinfo[$parid]['lastpostentryid'] = $vba_cats['lastpostentryid'];
							$catinfo[$parid]['lastpostdateline'] = $vba_cats['lastpostdateline'];
							$catinfo[$parid]['lastpostentrytitle'] = $vba_cats['lastpostentrytitle'];
							$catinfo[$parid]['lastpostusername'] = $vba_cats['lastpostusername'];
							$catinfo[$parid]['lastpostuserid'] = $vba_cats['lastpostuserid'];
						}
					}
				}
			}
			else
			{
				$catinfo[$catrowid]['entrycount'] += $vba_cats['entrycount'];
				$catinfo[$catrowid]['postcount'] += $vba_cats['postcount'];
			}
		}
	}

	return $catinfo;
}

// ##### Fetch Category Moderators ############################################
function fetch_cat_moderators($catid)
{
	global $vbulletin, $vba_options;

	if (!empty($vbulletin->adv_dyna_mods[$catid]) AND is_array($vbulletin->adv_dyna_mods[$catid]))
	{
		foreach ($vbulletin->adv_dyna_mods[$catid] AS $moduserid => $modusername)
		{
			$moderator = array(
				'userid' => $moduserid,
				'username' => $modusername
			);
			$moderator['musername'] = fetch_musername($moderator);

			eval('$catmods .= "$comma' . fetch_template('forumhome_moderator') . '";');

			$comma = ', ';
		}
	}

	return $catmods;
}

// ##### Construct Entrybits ##################################################
function construct_entrybits(&$entry, $usetemp = '', $customfieldvar = false)
{
	global $vbulletin, $vba_dyna, $vba_options, $vbphrase, $stylevar, $bbcode_parser;
	global $mods, $dyna_modid, $show, $returnto, $adv_sorturl, $catid, $highlight, $templatename;
	global $entrycount;

	$is_category_mod = is_category_mod($entry['catid']);

	$entrycount++;

	// Folder icon
	$entry['folder'] = 'thread';

	if (!$entry['open'])
	{
		$entry['folder'] = 'thread_lock';
	}
	else if (($vbulletin->userinfo['lastvisit'] < $entry['dateline'] OR $vbulletin->userinfo['lastvisit'] < $entry['lastpostdateline']) AND ($entry['views'] >= $vba_options['dyna_hotviews'] OR $entries['posts'] >= $vba_options['dyna_hotposts']) AND ($vba_options['dyna_hotviews'] OR $vba_options['dyna_hotposts']))
	{
		$entry['folder'] = 'thread_hot_new';
	}
	else if (($vbulletin->userinfo['lastvisit'] < $entry['dateline'] OR $vbulletin->userinfo['lastvisit'] < $entry['lastpostdateline']) AND $entry['views'] < $vba_options['dyna_hotviews'])
	{
		$entry['folder'] = 'thread_new';
	}
	else if (($entry['views'] >= $vba_options['dyna_hotviews'] AND $vba_options['dyna_hotviews']) OR ($entry['posts'] >= $vba_options['dyna_hotposts'] AND $vba_options['dyna_hotposts']))
	{
		$entry['folder'] = 'thread_hot';
	}

	$templatename = $usetemp;

	// Process the array after the folders so the number_format() function won't break them
	if (!$templatename)
	{
		$templatename = ($vba_options['dyna_entrybitexpanded']) ? 'expanded' : 'simple';
	}

	$vba_dyna->process_entry_array($entry);

	if (!$vba_options['dyna_buddyentries'])
	{
		$entry['private'] = 0;
	}

	// Inline mod bitfield for checkboxes
	$show['imod_disabled'] = true;
	$show['imod_intval'] = 0;
	if ($is_category_mod)
	{
		$show['imod_disabled'] = false;

		if (!$entry['open'])
		{
			$show['imod_intval'] += 1;
		}

		if ($entry['sticky'])
		{
			$show['imod_intval'] += 2;
		}

		if ($entry['hasattach'])
		{
			$show['imod_intval'] += 4;
		}
	}

	// Last post URL
	$entry['lastposturl'] = $entry['url'];

	if ($adv_sort_url)
	{
		$entry['lastposturl'] .= '&amp;';
	}
	else
	{
		$entry['lastposturl'] .= ($vba_options['dyna_spiderurls'] ? '?' : '&amp;');
	}

	$entry['lastposturl'] .= 'epostid=' . $entry['lastpostid'] . '#post' . $entry['lastpostid'];

	$entry['url'] .= $adv_sorturl;

	// Trimmed title from a module
	if ($entry['trimmedtitle'])
	{
		$entry['title'] = $entry['trimmedtitle'];
	}

	// Highlight search words in title
	if ($show['highlight_title'])
	{
		$entry['title'] = highlight_keywords($entry['title'], $highlight['string'], $highlight['wholeword']);
	}

	// First Attachment
	$show['firstattachment'] = false;

	$entry['canviewthumb'] = ($vba_dyna->check_cat_perms('canviewthumb', $entry) AND $vba_dyna->_attachperms[$entry['extension']]['canviewthumb']) ? true : false;

	if ($show['entrybit_attach']
		AND $entry['attachmentid']
		AND ($entry['hasthumb'] OR $vba_options['dyna_entrybit_showattach'] == 1)
		AND (($vba_dyna->check_cat_perms('canviewattach', $entry) AND $vba_dyna->_attachperms[$entry['extension']]['canviewattach'])
			OR ($entry['canviewthumb'] AND $entry['hasthumb'])
		)
	)
	{
		$show['firstattachment'] = true;

		$target_blank = ($vbulletin->adv_dyna_attach[$entry['extension']]['newwin']) ? ' target="_blank"' : '';

		if ($entry['hasthumb'] AND $entry['canviewthumb'])
		{
			$show['thumbs'] = true;
			$entry['thumburl'] = fetch_attach_thumb_url($entry);
		}
	}

	if ($entry['pubdateline'])
	{
		$entry['pubdateline'] = vbdate($vbulletin->options['dateformat'] . ' ' . $vbulletin->options['timeformat'], $entry['pubdateline']);
	}

	$show['editentry'] = false;

	// Typically used in the expanded template, but needed for deleted template too
	if ($vbulletin->userinfo['userid']
		AND ($vba_dyna->check_cat_perms('caneditothers')
			OR ($vbulletin->userinfo['userid'] == $entry['userid'] AND $vba_dyna->check_cat_perms('caneditentries'))
			OR $is_category_mod
		)
	)
	{
		$show['editentry'] = true;
	}

	($hook = vBulletinHook::fetch_hook('vba_dyna_functions_construct_entrybits')) ? eval($hook) : false;

	// ##### Expanded entrybit template
	if ($templatename == 'expanded')
	{
		if (!$entry['userid'])
		{
			$entry['usertitle'] = $vbphrase['guest'];
		}

		$show['report_button'] = ($vba_dyna->check_cat_perms('canreport', $entry) ? true : false);

		$entry['membercatlink'] = fetch_cat_url(0, array('title' => $entry['username'], 'userid' => $entry['userid']), 'member');

		$show['rating_ajax_js'] = true;

		$show['replyentry'] = false;
		if ($vba_options['dyna_allowreplies'] AND $vba_dyna->check_cat_perms('canreply') AND cat_user_opt('allow_reply', $entry['catid']))
		{
			$show['replyentry'] = true;
		}

		$show['whoratedentry'] = $vba_dyna->check_cat_perms('canseewhorated');

		// Check the length now before highlighting, then add below
		$readmore = false;
		if (strlen($entry['pagetext_parsed']) > $vba_options['dyna_desclength_browse'])
		{
			$readmore = true;
		}

		// Highlight search words in pagetext
		if ($show['highlight_pagetext'])
		{
			$entry['pagetext_preview'] = highlight_keywords($entry['pagetext_preview'], $highlight['string'], $highlight['wholeword']);
		}

		if ($readmore)
		{
			$entry['pagetext_preview'] .= construct_phrase($vbphrase['read_more_dyna'], $entry['url']);
		}

		/* Drop-down menus need to be spit out below the entrybits to avoide a
			 conflict wtih the inline moderation stuff */
		eval('$show[\'entrybit_dropdowns\'] .= "' . fetch_template(ADV_DYNA_PREFIX . '_entrybit_expanded_dropdowns') . '";');
	}
	// ##### Simple/lean entrybit template
	else
	{
		$entry['date_added'] = vbdate($vbulletin->options['dateformat'], $entry['dateline']);
		$entry['time_added'] = vbdate($vbulletin->options['timeformat'], $entry['dateline']);

		if ($vba_options['dyna_desclength_browse'])
		{
			$entry['pagetext_preview'] = fetch_trimmed_title(strip_bbcode(strip_tags($entry['pagetext'])), $vba_options['dyna_desclength_browse']);
		}
		else
		{
			$entry['pagetext_preview'] = '';
		}

		if ($templatename == 'lean')
		{
			$bgclass = exec_switch_bg();
		}
	}

	// Custom Fields
	if ($customfieldvar === false)
	{
		$customfieldvar =& $vba_options['dyna_browsecat_cfields'];
	}

	$entry['cfieldbits'] = '';
	if (!empty($customfieldvar))
	{
		foreach ($customfieldvar AS $cfieldid)
		{
			if (trim($entry['field' . $cfieldid]))
			{
				$cfield =& $vbulletin->adv_dyna_cfield[$cfieldid];
				$cfieldvalue = $entry['field' . $cfieldid];

				if (!check_custom_field_cats($cfield, $entry) OR ($cfield['private'] AND !$is_category_mod))
				{
					continue;
				}

				if ($cfield['type'] == 'multiple_select' OR $cfield['type'] == 'checkbox')
				{
					$cfieldvalue = unserialize($cfieldvalue);

					if (is_array($cfieldvalue) AND !empty($cfieldvalue))
					{
						$cfieldvalue = implode(', ', $cfieldvalue);
					}
					else
					{
						continue;
					}
				}
				else
				{
					$cfieldvalue = $bbcode_parser->do_parse(
						unhtmlspecialchars($cfieldvalue),
						cat_opt('allow_custom_html'),
						cat_opt('allow_custom_smilies'),
						cat_opt('allow_custom_bbcode'),
						cat_opt('allow_custom_bbimgcode')
					);
				}

				eval('$entry[cfieldbits] .= "' . fetch_template(ADV_DYNA_PREFIX . '_entrybit_custombits') . '";');
			}
		}
	}

	// Deleted entry
	if ($entry['valid'] == 2)
	{
		$entry['del_date'] = vbdate($vbulletin->options['dateformat'], $entry['del_dateline']);
		$entry['del_time'] = vbdate($vbulletin->options['timeformat'], $entry['del_dateline']);
	}

	eval('$entrybits = "' . fetch_template(ADV_DYNA_PREFIX . '_entrybit_' . ($entry['valid'] == 2 ? 'deleted' : $templatename)) . '";');
	return $entrybits;
}

?>