<?php
// ++=========================================================================++
// || vBadvanced Dynamics v1.0.0 (vB 3.6 - vB 3.7)
// ||  2003-2007 vBadvanced.com - All Rights Reserved
// || This file may not be redistributed in whole or significant part.
// || http://vbadvanced.com
// ++ ========================================================================++

error_reporting(E_ALL & ~E_NOTICE);
define('THIS_SCRIPT', 'dyna_external');

$globaltemplates = array(
	'bbcode_code',
	'bbcode_html',
	'bbcode_php',
	'bbcode_quote'
);
$specialtemplates = array();
$actiontemplates = array();
$phrasegroups = array();

require_once('./dyna_global.php');

// Kill the session hash since it only creates problems with RSS
$vbulletin->session->vars['sessionurl'] = '';
$vbulletin->session->vars['sessionurl_q'] = '';

($hook = vBulletinHook::fetch_hook('vba_dyna_external_start')) ? eval($hook) : false;

if (!$vba_options['dyna_exter_rss'])
{
	exit;
}

$vbulletin->input->clean_array_gpc('r', array(
	'userids' => TYPE_STR,
	'catids' => TYPE_STR,
	'count' => TYPE_INT
));

$catidlist = '';
$privcatlist = '';
$useridlist = '';
$exthash = '';

// Userids
if ($vbulletin->GPC['userids'])
{
	$userids = array_map('intval', explode(',', $vbulletin->GPC['userids']));
	sort($userids, SORT_NUMERIC);

	$useridlist = implode(',', $userids);
	$exthash .= 'u:' . $useridlist;
}

$privatecats = fetch_private_categories(false);

// Catids
if ($vbulletin->GPC['catids'])
{
	$catids = array_map('intval', explode(',', $vbulletin->GPC['catids']));
	$catids = array_diff($catids, $privatecats);

	sort($catids, SORT_NUMERIC);

	$catidlist = implode('-', $catids);
	$exthash .= 'c:' . $catidlist;
}
else
{
	if (!empty($privatecats))
	{
		$privcatlist = implode(',', $privatecats);
	}
	$exthash .= 'p:' . $privcatlist;
}

$limit = intval($vba_options['dyna_exter_deflimit']);

if ($vbulletin->GPC['count'] AND $vbulletin->GPC['count'] <= $vba_options['dyna_exter_maxlimit'])
{
	$limit = $vbulletin->GPC['count'];
}

$exthash .= 'l:' . $limit;

$exthash = md5($exthash);

$extcache = $db->query_first("
	SELECT output, dateline
	FROM " . ADV_DYNA_TABLE_PREFIX . "extcache
	WHERE exthash = '" . $db->escape_string($exthash) . "'
");

header('Content-Type: application/xml; charset=' . $stylevar['charset']);

if ($extcache['dateline'] >= TIMENOW - ($vba_options['dyna_exter_cachelife'] * 60))
{
	echo $extcache['output'];
	exit;
}

// Load the XML class
require_once(DIR . '/includes/class_xml.php');
$xml = new vB_XML_Builder($vbulletin);

$dynatitle = $vba_options['dyna_title'];
$dynalink = htmlspecialchars($vba_options['dyna_homeurl']);

if (sizeof($catids) == 1)
{
	$catid = $catids[0];
	$dynalink .= htmlspecialchars(fetch_cat_url($catid));
	$dynatitle .= ' - ' . $vbulletin->adv_dyna_cats[$catid]['title'];
}
else if (sizeof($userids) == 1)
{
	$userinfo = $db->query_first("SELECT userid, username FROM " . TABLE_PREFIX . "user WHERE userid = " . $userids[0]);
	$dynalink .= htmlspecialchars(fetch_cat_url(0, $userinfo['userid'], 'member'));
	$dynatitle .= ' - ' . fetch_possessive($userinfo['username']) . ' ' . $vbphrase['entries'];
}

$output = '<?xml version="1.0" encoding="' . $stylevar['charset'] . '" ?>' . "\r\n";

// RSS
$xml->add_group('rss', array(
	'version' => '2.0',
	'xmlns:dc' => 'http://purl.org/dc/elements/1.1/',
	'xmlns:syn' => 'http://purl.org/rss/1.0/modules/syndication/',
	'xmlns:admin' => 'http://webns.net/mvcb/',
	'xmlns:rdf' => 'http://www.w3.org/1999/02/22-rdf-syntax-ns#',
	'xmlns:content' => 'http://purl.org/rss/1.0/modules/content/'
));

// Channel
$xml->add_group('channel');
$xml->add_tag('title', $dynatitle);
$xml->add_tag('link', $dynalink);
$xml->add_tag('description', $vba_options['dyna_meta_desc']);
$xml->add_tag('language', $stylevar['languagecode']);
$xml->add_tag('ttl', 60);

// Image
$xml->add_group('image');
$xml->add_tag('title', $dynatitle);
$xml->add_tag('url', $stylevar['imgdir_misc'] . '/rss.jpg');
$xml->add_tag('link', $dynalink);
$xml->close_group('image');

// Load BBcode parser
require_once(DIR . '/includes/class_bbcode.php');
$bbcode_parser =& new vB_BbCodeParser($vbulletin, fetch_tag_list());

$catwhere = '';

if (!empty($catids))
{
	if ($vba_options['dyna_extr_subcats'])
	{
		$newcatids = array();
		foreach ($catids AS $rsscatid)
		{
			$newcatids = array_merge($newcatids, fetch_category_children($rsscatid));
		}

		$catidlist = implode(', ', array_diff($newcatids, $privatecats));
	}

	$catwhere = ' AND catid IN(' . $catidlist . ')';

	// $privcatlist would not have been set above if we have catids
	if ($vbulletin->GPC['catids'])
	{
		$privcatlist = implode(', ', $privatecats);
	}
}

if ($privcatlist)
{
	$catwhere = ' AND catid NOT IN(' . $privcatlist . ')';
}

$queryfields = '';
$queryjoin = '';

if ($vba_options['dyna_cachedlife'])
{
	$queryfields .= ', pagetext_parsed, hasimages';
	$queryjoin .= ' LEFT JOIN ' . ADV_DYNA_TABLE_PREFIX . 'entryparsed AS entryparsed ON (entries.entryid = entryparsed.entryid AND entryparsed.languageid= ' . $vbulletin->userinfo['languageid'] . ' AND entryparsed.styleid = ' . $vbulletin->userinfo['styleid'] . ')';
}

($hook = vBulletinHook::fetch_hook('vba_dyna_external_query')) ? eval($hook) : false;

// ##### Get the entries
$entries = $db->query_read("
	SELECT entries.entryid, entries.title, catid, pagetext, username, entries.dateline $queryfields
	FROM " . ADV_DYNA_TABLE_PREFIX . "entries AS entries
	$queryjoin
	LEFT JOIN " . ADV_DYNA_TABLE_PREFIX . "entries_pages AS entries_pages ON (entries.entryid = entries_pages.entryid AND entries_pages.pagenumber = 1)
	WHERE valid = 1 AND draft = 0 AND private = 0
		$catwhere
		" . iif($useridlist, 'AND userid IN(' . $useridlist . ')') . "
	ORDER BY dateline DESC
	LIMIT $limit
");
while ($entry = $db->fetch_array($entries))
{
	fetch_entry_url($entry);

	($hook = vBulletinHook::fetch_hook('vba_dyna_external_entryloop')) ? eval($hook) : false;

	$vbulletin->options['allowhtml'] = cat_opt('allow_entry_html', $entry['catid']);
	$vbulletin->options['allowbbcode'] = cat_opt('allow_entry_bbcode', $entry['catid']);
	$vbulletin->options['allowbbimagecode'] = cat_opt('allow_entry_bbimgcode', $entry['catid']);
	$vbulletin->options['allowsmilies'] = iif(cat_opt('allow_entry_smilies', $entry['catid']), $entry['allowsmilie'], 0);

	if (!$vba_options['dyna_cachedlife'])
	{
		$entry['pagetext_parsed'] = $bbcode_parser->do_parse(
			$entry['pagetext'],
			$vbulletin->options['allowhtml'],
			$vbulletin->options['allowsmilies'],
			$vbulletin->options['allowbbcode'],
			$vbulletin->options['allowbbimagecode']
		);
	}
	else
	{
		$entry['pagetext_parsed'] = $bbcode_parser->parse(
			$entry['pagetext'],
			'nonforum',
			$vbulletin->options['allowsmilies'],
			true,
			$entry['pagetext_parsed'],
			$entry['hasimages'],
			false
		);
	}

	$cattitle = unhtmlspecialchars($vbulletin->adv_dyna_cats[$entry['catid']]['title']);

	$xml->add_group('item');
	$xml->add_tag('title', unhtmlspecialchars($entry['title']));
	$xml->add_tag('link', $vba_options['dyna_homeurl'] . '/' . $entry['url']);
	$xml->add_tag('guid', $vba_options['dyna_homeurl'] . '/' . $entry['url']);
	$xml->add_tag('description', $entry['pagetext_parsed']);
	$xml->add_tag('pubDate', gmdate('D, j M Y H:i:s', $entry['dateline']));
	$xml->add_tag('category', $cattitle);
	$xml->add_tag('dc:subject', $cattitle);
	$xml->add_tag('dc:creator', unhtmlspecialchars($entry['username']));
	$xml->add_tag('language', $stylevar['languagecode']);
	$xml->close_group('item');
}

// Close 'em
$xml->close_group('channel');
$xml->close_group('rss');

$output .= $xml->output();

if ($extcache['dateline'])
{
	$db->query_write("
		REPLACE INTO " . ADV_DYNA_TABLE_PREFIX . "extcache VALUES (
			'" . $db->escape_string($exthash) . "',
			'" . $db->escape_string($output) . "',
			" . TIMENOW . "
		)
	");
}
else
{
	$db->query_write("
		INSERT INTO " . ADV_DYNA_TABLE_PREFIX . "extcache
			(exthash, output, dateline)
		VALUES (
			'" . $db->escape_string($exthash) . "',
			'" . $db->escape_string($output) . "',
			" . TIMENOW . "
		)
	");
}

($hook = vBulletinHook::fetch_hook('vba_dyna_external_end')) ? eval($hook) : false;

echo $output;

?>