<?php
// ++=========================================================================++
// || vBadvanced Dynamics v1.0.0 (vB 3.6 - vB 3.7)
// ||  2003-2007 vBadvanced.com - All Rights Reserved
// || This file may not be redistributed in whole or significant part.
// || http://vbadvanced.com
// ++ ========================================================================++

error_reporting(E_ALL & ~E_NOTICE);
define('NO_REGISTER_GLOBALS', 1);
define('THIS_SCRIPT', 'dyna_managecats');

$globaltemplates = array();

$specialtemplates = array();

$phrasegroups = array(
	'adv_dyna_managecats'
);

$actiontemplates = array(
	'manage' => array(
		'ADV_DYNA_CATMANAGER',
		'adv_dyna_catmanager_categorybits'
	),
	'addcat' => array(
		'ADV_DYNA_CATMANAGER_ADDEDIT'
	),
	'editcat' => array(
		'ADV_DYNA_CATMANAGER_ADDEDIT'
	),
	'deletecat' => array(
		'ADV_DYNA_CONFORMATION'
	),
	'emptycat' => array(
		'ADV_DYNA_CONFORMATION'
	),
	'forgotcatpass' => array(
		'ADV_DYNA_CONFORMATION'
	)
);

$actiontemplates['none'] = &$actiontemplates['manage'];

require_once('./dyna_global.php');

if (!$vba_dyna->check_perms('cancreatecats') OR !$vbulletin->userinfo['userid'] OR !$vba_options['dyna_allow_user_cats'])
{
	print_no_permission();
}

if (empty($_REQUEST['do']))
{
  $_REQUEST['do'] = 'manage';
}

($hook = vBulletinHook::fetch_hook('vba_dyna_managecats_start')) ? eval($hook) : false;

// ######################### Main Manage Cats Page ###########################
if ($_REQUEST['do'] == 'manage')
{
	require_once(DIR . '/includes/vba_dyna_functions_savecat.php');

	($hook = vBulletinHook::fetch_hook('vba_dyna_managecats_manage')) ? eval($hook) : false;

	$allowedparents = fetch_allowed_parents();

	$catcount = $db->query_first("
		SELECT COUNT(*) AS count
		FROM " . ADV_DYNA_TABLE_PREFIX . "categories
		WHERE catuserid = " . $vbulletin->userinfo['userid']
	);

	$maxcats = ($vba_dyna->check_perms('maxcats')) ? $vba_dyna->check_perms('maxcats') : $vbphrase['unlimited'];

	// Now print out the categories
	$haveusercats = false;
	if (!empty($vbulletin->adv_dyna_cats))
	{
		if ($vba_dyna->check_perms('caneditcats'))
		{
			$show['editcat'] = true;
		}

		if ($vba_dyna->check_perms('candeletecats'))
		{
			$show['deletecat'] = true;
		}

		if ($vba_dyna->check_perms('canemptycats'))
		{
			$show['emptycat'] = true;
		}

		// Members' categories
		$mcats = array();
		$getmcats = $db->query_read("
			SELECT catid, title
			FROM " . ADV_DYNA_TABLE_PREFIX . "memberscats
			WHERE userid = " . $vbulletin->userinfo['userid']
		);
		while ($mcat = $db->fetch_array($getmcats))
		{
			$mcats[$mcat['catid']] = $mcat['title'];
		}

		foreach ($vbulletin->adv_dyna_cats AS $category)
		{
			if ($category['catuserid'] == $vbulletin->userinfo['userid'] OR in_array($category['catid'], $allowedparents))
			{
				$haveusercats = true;

		    $dashes = str_repeat('--', $category['level'] - 1);
				$category['link'] = fetch_cat_url($category['catid']);
				eval('$categorybits .= "' . fetch_template(ADV_DYNA_PREFIX . '_catmanager_categorybits') . '";');
			}
			else if ($category['memberscat'])
			{
				$haveusercats = true;

				// Members category
		    $dashes = str_repeat('--', $category['level'] - 1);
				eval('$categorybits .= "' . fetch_template(ADV_DYNA_PREFIX . '_catmanager_categorybits') . '";');

				// Users category
				$category['catuserid'] = $vbulletin->userinfo['userid'];
				$category['link'] = fetch_cat_url($category['catid'], $vbulletin->userinfo);
				$category['title'] = ($mcats[$category['catid']]) ? $mcats[$category['catid']] : $vbulletin->userinfo['username'];

		    $dashes = str_repeat('--', $category['level']);
				eval('$categorybits .= "' . fetch_template(ADV_DYNA_PREFIX . '_catmanager_categorybits') . '";');

			}
		}
	}

	if (!$haveusercats)
	{
		$categorybits .= construct_phrase($vbphrase['you_do_not_have_any_x'], $vbphrase['categories_lwr']);
	}

	$navbits[''] = construct_phrase($vbphrase['x_manager'], $vbphrase['category']);
	$navbits = construct_navbits($navbits);
	eval('$navbar = "' . fetch_template('navbar') . '";');

	eval('print_output("' . fetch_template(ADV_DYNA_PREFIX_UPPER . '_CATMANAGER') . '");');
}

// ##### Add / Edit Category ##################################################
if ($_REQUEST['do'] == 'addcat' OR $_REQUEST['do'] == 'editcat')
{
	require_once(DIR . '/includes/vba_dyna_functions_savecat.php');

	($hook = vBulletinHook::fetch_hook('vba_dyna_managecats_addeditcat')) ? eval($hook) : false;

	$defcatopts =& $vba_options['dyna_usercats_defaultopts'];

	// Default options
	foreach ($vba_options['dyna_usercats_defaultopts'] AS $varname => $value)
	{
		if ($value == 2)
		{
			$show['catopts'] = true;
		}
		else
		{
			$hiddenbits .= '<input type="hidden" name="useropts[' . $varname . ']" value="' . $value . '" />';
		}
	}

	$navbits['managecats.php' . $vbulletin->session->vars['sessionurl_q']] = construct_phrase($vbphrase['x_manager'], $vbphrase['category']);

	// ##### Editing a category
	if ($_REQUEST['do'] == 'editcat')
	{
		if (!$vba_dyna->check_perms('caneditcats'))
		{
			print_no_permission();
		}

		$show['memberscat'] = false;

		// Members' category
		if ($vbulletin->adv_dyna_cats[$catid]['memberscat'])
		{
			$show['memberscat'] = true;

			$category = $db->query_first("
				SELECT catid, title, description
				FROM " . ADV_DYNA_TABLE_PREFIX . "memberscats
				WHERE catid = $catid
					AND userid = " . $vbulletin->userinfo['userid']
			);

			if (!$category['title'])
			{
				$category['title'] = $vbulletin->userinfo['username'];
			}
		}
		// Normal category
		else
		{
			$category = $db->query_first("
				SELECT catid, title, description, parent, styleid, catuserid, memberscat, password, displayorder, caticon, useroptions
				FROM " . ADV_DYNA_TABLE_PREFIX . "categories
				WHERE catid = $catid
			");
		}

		if ($category['catuserid'] != $vbulletin->userinfo['userid'] AND !$show['memberscat'])
		{
			print_no_permission();
		}

		$useropts = convert_bits_to_array($category['useroptions'], $vba_dyna->_catuseropts);

		foreach ($useropts AS $option => $value)
		{
			if ($value == 1)
			{
				$checked["$option"] = 'checked="checked"';
			}
		}
		$navbits['browsecategory.php?' . $vbulletin->session->vars['sessionurl'] . "c=$category[catid]"] = $category['title'];
		$navbits[''] = construct_phrase($vbphrase['edit_x'], $vbphrase['category']);
	}
	// ##### Add new category
	else
	{
		// Check to see how many categories they've created
		if ($vba_dyna->check_perms('maxcats'))
		{
			$catcount = $db->query_first("SELECT COUNT(*) AS count FROM " . ADV_DYNA_TABLE_PREFIX . "categories WHERE catuserid = " . $vbulletin->userinfo['userid']);
			if ($catcount['count'] >= $vba_dyna->check_perms('maxcats'))
			{
				eval(standard_error(fetch_error(ADV_DYNA_PREFIX . '_too_many_categories', $vba_dyna->check_perms('maxcats'), $vbphrase['categories_lwr'])));
			}
		}

		foreach ($vba_dyna->_catuseropts AS $useropt => $value)
		{
			$checked[$useropt] = 'checked="checked"';
		}

		$navbits[''] = construct_phrase($vbphrase['add_x'], $vbphrase['category']);
	}

	// Don't need any of this for members' categories
	if (!$show['memberscat'])
	{
		$allowedparents = fetch_allowed_parents('submitcat');
	
		$catoptions = print_cat_select($category['parent'], 'managecats');
	
		if (!$catoptions)
		{
			eval(standard_error(fetch_error(ADV_DYNA_PREFIX . '_no_x_accept_sub_x', $vbphrase['categories_lwr'])));
		}
	
		// Password
		if ($vba_dyna->check_perms('canpasswordcats'))
		{
			$show['catpassword'] = true;
		}
	
		// Cat Icon
		if ($vba_dyna->check_perms('cancaticon'))
		{
			$show['caticon'] = true;
		}
	
		// Style
		$stylebits = '';
		if ($vba_dyna->check_perms('cancatstyle'))
		{
			$getstyles = $db->query_read("
				SELECT styleid, title
				FROM " . TABLE_PREFIX . "style
				WHERE userselect = 1
				ORDER BY displayorder
			");
			while ($style = $db->fetch_array($getstyles))
			{
				$stylebits .= '<option value="' . $style['styleid'] . '"' . iif($category['styleid'] == $style['styleid'], ' selected="selected"') . '>' . $style['title'] . '</option>';
			}
		}
	}

	$navbits = construct_navbits($navbits);
	eval('$navbar = "' . fetch_template('navbar') . '";');

	eval('print_output("' . fetch_template(ADV_DYNA_PREFIX_UPPER . '_CATMANAGER_ADDEDIT') . '");');
}

// ########################### Do Add / Edit Category #########################
if ($_POST['do'] == 'doaddcat' OR $_POST['do'] == 'doeditcat')
{
	$useropts = $vbulletin->input->clean_gpc('p', 'useropts', TYPE_ARRAY_STR);
	$category = $vbulletin->input->clean_gpc('p', 'category', TYPE_ARRAY_STR);
	$caticon = $vbulletin->input->clean_gpc('f', 'caticon', TYPE_FILE);
	$delcaticon = $vbulletin->input->clean_gpc('p', 'delcaticon', TYPE_INT);

	$category['parent'] = intval($category['parent']);
	$category['catid'] = intval($category['catid']);
	$category['thisparent'] = intval($category['thisparent']);
	$category['styleid'] = intval($category['styleid']);

	$memberscat = false;
	if ($vbulletin->adv_dyna_cats[$category['catid']]['memberscat'])
	{
		$memberscat = true;
	}

	// ##### Error checking
	if (empty($category['title']))
	{
		eval(standard_error(fetch_error(ADV_DYNA_PREFIX . '_cant_have_category_without_title')));
	}

	if (strlen($category['title']) > $vba_options['dyna_usercat_titlemax'])
	{
		eval(standard_error(fetch_error(ADV_DYNA_PREFIX . '_x_too_long', $vbphrase['title'], vb_number_format(strlen($category['title'])), $vba_options['dyna_usercat_titlemax'])));
	}

	if (strlen($category['description']) > $vba_options['dyna_usercat_descmax'])
	{
		eval(standard_error(fetch_error(ADV_DYNA_PREFIX . '_x_too_long', $vbphrase['description'], vb_number_format(strlen($category['description'])), $vba_options['dyna_usercat_descmax'])));
	}

	if (!$memberscat)
	{
		if (empty($category['parent']))
		{
			eval(standard_error(fetch_error(ADV_DYNA_PREFIX . '_must_choose_parent_for_x', $vbphrase['category_lwr'])));
		}
	
		if ($category['password'] != $category['confirmpassword'])
		{
			eval(standard_error(fetch_error('passwordmismatch')));
		}
	
		if ($category['parent'] == $category['catid'])
		{
			eval(standard_error(fetch_error(ADV_DYNA_PREFIX . '_cant_parent_category_self')));
		}
	
		if ($_POST['do'] == 'doaddcat' AND $vba_dyna->check_perms('maxcats'))
		{
			$catcount = $db->query_first("SELECT COUNT(*) AS count FROM " . ADV_DYNA_TABLE_PREFIX . "categories WHERE catuserid = '" . $vbulletin->userinfo['userid'] . "'");
			if ($catcount['count'] >= $vba_dyna->check_perms('maxcats'))
			{
				eval(standard_error(fetch_error(ADV_DYNA_PREFIX . '_too_many_categories', $vba_dyna->check_perms('maxcats'), $vbphrase['categories_lwr'])));
			}
		}
	}

	require_once(DIR . '/includes/vba_dyna_functions_savecat.php');

	($hook = vBulletinHook::fetch_hook('vba_dyna_managecats_doaddeditcat')) ? eval($hook) : false;

	if (!$memberscat)
	{
		// Old category info
		if ($_POST['do'] == 'doeditcat')
		{
			$oldcat = $db->query_first("SELECT * FROM " . ADV_DYNA_TABLE_PREFIX . "categories WHERE catid = $category[catid]");
		}
	
		// Delete cat icon
		if ($delcaticon AND $oldcat['caticon'])
		{
			@unlink($vba_options['dyna_caticon_path'] . '/' . $oldcat['caticon']);
		}
	
		// ##### Upload Category Icon
		$category['caticon'] = '';
		$havcaticon = false;
		if ($caticon['tmp_name'] AND $vba_dyna->check_perms('cancaticon'))
		{
			if (!is_writable($vba_options['dyna_caticon_path']))
			{
				eval(standard_error(fetch_error(ADV_DYNA_PREFIX . '_caticon_dir_notwritable')));
			}
	
			// Load the $vba_image class
			require_once(DIR . '/includes/vba_dyna_class_image.php');
	
			$vba_image =& new vba_dyna_image();
			$vba_image->_vb =& $vbulletin;
	
			$vba_image->_info = array(
				'filename' => $caticon['name'],
				'type' => $caticon['type'],
				'location' => $caticon['tmp_name']
			);
	
			$vba_image->fetch_upload_info();
	
			$validext = explode(' ', $vba_options['dyna_caticon_ext']);
	
			// Check Extension
			if (!in_array($vba_image->_info['extension'], $validext))
			{
				eval(standard_error(fetch_error('upload_invalid_image_extension', $vba_image->_info['extension'])));
			}
	
			// Set the limits
			$vba_image->_extkeys[] = $vba_image->_info['extension'];
			$vba_image->_extcache[$vba_image->_info['extension']] = array(
				'size' => $vba_options['dyna_caticon_filesize'],
				'width' => $vba_options['dyna_caticon_dimensions'],
				'height' => $vba_options['dyna_caticon_dimensions'],
				'enabled' => 1
			);
	
			// Filetype
			if (in_array($vba_image->_info['extension'], $validext) AND $vba_image->_imagetypes[$vba_image->_info['type']] != $vba_image->_info['extension'])
			{
				eval(standard_error(fetch_error('upload_invalid_image_extension', $vba_image->_info['extension'])));
			}
	
			// Filesize
			if ($vba_image->_info['filesize'] > $vba_options['dyna_caticon_filesize'])
			{
				eval(standard_error(fetch_error(
					'upload_file_exceeds_forum_limit',
					fetch_rfilesize($vba_image->_info['filesize']),
					fetch_rfilesize($vba_options['dyna_caticon_filesize'])
				)));
			}
	
			$havecaticon = true;
	
			$vba_image->resize('original', 0);
	
			// Could have errors after resizing
			if (!empty($vba_image->_errors['0']))
			{
				$errormessage = '';
				foreach ($vba_image->_errors['0'] AS $errorkey => $error)
				{
					$errormessage .= '<div>' . $error['error'] . '</div>';
				}
				eval(standard_error($errormessage));
			}
	
			// Only move if editing since we won't have a catid yet when adding
			if ($_POST['do'] == 'doeditcat')
			{
				$category['caticon'] = 'cat_' . $category['catid'] . '.' . $vba_image->_info['extension'];
				@move_uploaded_file($caticon['tmp_name'], $vba_options['dyna_caticon_path'] . '/' . $category['caticon']);
			}
		}
		else if (!$delcaticon AND $oldcat['caticon'])
		{
			$category['caticon'] = $oldcat['caticon'];
		}
	
		// Styleid
		if (!$vba_dyna->check_perms('cancatstyle'))
		{
			$category['styleid'] = 0;
		}
	
		// Password
		if (!$vba_dyna->check_perms('canpasswordcats'))
		{
			$category['password'] = '';
			$category['confirmpassword'] = '';
		}
	
		// Options
		foreach ($vba_options['dyna_usercats_defaultopts'] AS $varname => $value)
		{
			$useropts["$varname"] = iif($value == 2, $useropts["$varname"], $value);
		}
	
		require_once(DIR . '/includes/functions_misc.php');
		$useroptions = convert_array_to_bits($useropts, $vba_dyna->_catuseropts);
	}

	// ##### Editing the category
	if ($_POST['do'] == 'doeditcat')
	{
		// Members' category
		if ($memberscat)
		{
			// Try to insert
			$vbulletin->db->query_write("
				INSERT IGNORE INTO " . ADV_DYNA_TABLE_PREFIX . "memberscats
					(catid, userid, title, description)
				VALUES (
					$category[catid],
					" . $vbulletin->userinfo['userid'] . ",
					'" . $db->escape_string(htmlspecialchars($category['title'])) . "',
					'" . $db->escape_string(htmlspecialchars($category['description'])) . "'
			)");

			// Update members' cat
			$db->query_write("
				UPDATE " . ADV_DYNA_TABLE_PREFIX . "memberscats SET
					title = '" . $db->escape_string(htmlspecialchars($category['title'])) . "',
					description = '" . $db->escape_string(htmlspecialchars($category['description'])) . "'
				WHERE catid = $category[catid]
					AND userid = " . $vbulletin->userinfo['userid']
			);

		}
		// Normal category
		else
		{
			$checkuser = $db->query_first("
				SELECT password, catuserid
				FROM " . ADV_DYNA_TABLE_PREFIX . "categories
				WHERE catid = $category[catid]
			");
			if ($checkuser['catuserid'] != $vbulletin->userinfo['userid'])
			{
				print_no_permission();
			}
	
			if ($checkuser['password'] != $category['currentpass'] AND $category['password'])
			{
				eval(standard_error(fetch_error(ADV_DYNA_PREFIX . '_wrongpassword', $vbulletin->session->vars['sessionurl'], $category['catid'])));
			}
	
			if ($vba_options['dyna_newcatsattop'] != 2)
			{
				$category['displayorder'] = $vbulletin->adv_dyna_cats[$category['catid']]['displayorder'];
			}
	
			$vbulletin->db->query_write("
				UPDATE " . ADV_DYNA_TABLE_PREFIX . "categories SET
					title = '" . $db->escape_string(htmlspecialchars($category['title'])) . "',
					description = '" . $db->escape_string(htmlspecialchars($category['description'])) . "',
					parent = $category[parent],
					displayorder = " . intval($category['displayorder']) . ",
					caticon = '" . $db->escape_string($category['caticon']) . "',
					styleid = $category[styleid],
					valid = " . iif($vba_options['dyna_cats_editmoderation'] AND $vba_dyna->check_perms('moderatecats'), 0, 1) . ",
					" . iif($category['currentpass'], "password = '" . $db->escape_string(htmlspecialchars($category['password'])) . "',") . "
					useroptions = '$useroptions'
				WHERE catid = $category[catid]
			");
	
			if ($category['parent'] != $category['thisparent'])
			{
				rebuild_parents($category['catid']);
			}
		}
	}
	// ##### Adding a category
	else
	{
		// Find the order
		switch ($vba_options['dyna_newcatsattop'])
		{
			case 2:
				$order = $db->query_first("SELECT MAX(displayorder) AS displayorder FROM " . ADV_DYNA_TABLE_PREFIX . "categories WHERE parent = $category[parent]");
				$category['displayorder'] = $order['displayorder'] + 1;
			break;

			case 1:
				$vbulletin->db->query_write("UPDATE " . ADV_DYNA_TABLE_PREFIX . "categories SET displayorder = displayorder+1 WHERE parent = $category[parent]");
				$category['displayorder'] = 1;
			break;

			default:
				$category['displayorder'] = intval($category['displayorder']);
		}

		// ##### Parent category opts
		$parentcat = $db->query_first("SELECT * FROM " . ADV_DYNA_TABLE_PREFIX . "categories WHERE catid = $category[parent]");
		$parentcat['subcatopts'] = unserialize($parentcat['subcatopts']);

		// Has specific options set
		if (!empty($parentcat['subcatopts']))
		{
			$category = array_merge($category, $parentcat['subcatopts']['catinfo']);
			$newcatopts = $parentcat['subcatopts']['options'];
		}
		// Use settings from parent category
		else
		{
			$newcatopts = $parentcat['options'];

			if (!cat_opt('open_for_entries', $category['parent']))
			{
				$newcatopts += $vba_dyna->_categoryopts['open_for_entries'];
			}

			$category['newentryemail'] = '';
			$category['newpostemail'] = '';
		}

	  $db->query_write("
	  	INSERT INTO " . ADV_DYNA_TABLE_PREFIX . "categories
	  		(title, description, parent, catuserid, displayorder, hasentries, styleid, active, valid, password, options, useroptions, newentryemail, newpostemail)
	  	VALUES (
	  		'" . $db->escape_string(htmlspecialchars($category['title'])) . "',
	  		'" . $db->escape_string(htmlspecialchars($category['description'])) . "',
	  		$category[parent],
	  		" . iif($vba_options['dyna_allow_user_cats'] == 2, 0, $vbulletin->userinfo['userid']) . ",
	  		$category[displayorder],
	  		1,
	  		" . intval($category['styleid']) . ",
	  		1,
	  		" . iif($vba_dyna->check_perms('moderatecats'), 0, 1) . ",
	  		'" . $db->escape_string(htmlspecialchars($category['password'])) . "',
	  		'$newcatopts',
	  		'$useroptions',
	  		'" . $db->escape_string($category['newentryemail']) . "',
	  		'" . $db->escape_string($category['newpostemail']) . "'
	  )");

		$newcatid = $db->insert_id();

		insert_category_parentlist($category['parent']);

		// Category Icon - Need to update here now that we have the catid
		if ($havecaticon)
		{
			$category['caticon'] = 'cat_' . $newcatid . '.' . $vba_image->_info['extension'];
			@move_uploaded_file($caticon['tmp_name'], $vba_options['dyna_caticon_path'] . '/' . $category['caticon']);

			$db->query_write("
				UPDATE " . ADV_DYNA_TABLE_PREFIX . "categories SET
					caticon = '" . $db->escape_string($category['caticon']) . "'
				WHERE catid = $newcatid
			");
		}

		// Members' category, so make sure they have an entry in the memberscat table
		if ($vbulletin->adv_dyna_cats[$category['parent']]['memberscat'])
		{
			$checkmc = $db->query_first("
				SELECT catid
				FROM " . ADV_DYNA_TABLE_PREFIX . "memberscats
				WHERE userid = " . $vbulletin->userinfo['userid'] . "
					AND catid = $category[parent]
			");

			if (!$checkmc['catid'])
			{
				$db->query_write("
					INSERT INTO " . ADV_DYNA_TABLE_PREFIX . "memberscats
						(catid, userid)
					VALUES (
						$category[parent],
						" . $vbulletin->userinfo['userid'] . "
				)");
			}
		}

		// Group set to make members moderators of their own categories
		if ($vba_dyna->check_perms('cancatmoderate'))
		{
			$db->query_write("
				INSERT INTO " . ADV_DYNA_TABLE_PREFIX . "moderator
					(userid, catid)
				VALUES (
					" . $vbulletin->userinfo['userid'] . ",
					$newcatid)
			");

			update_dyna_moderator_cache();
		}
	}

	update_category_cache();

	$vbulletin->url = 'managecats.php' . $vbulletin->session->vars['sessionurl_q'];
	eval(print_standard_redirect(ADV_DYNA_PREFIX . '_cat_saved'));
}

// ####################### Delete / Empty Category ############################
if ($_REQUEST['do'] == 'deletecat' OR $_REQUEST['do'] == 'emptycat')
{
	$cat = $vbulletin->adv_dyna_cats[$catid];

	if (!$cat['catid'])
	{
		eval(standard_error(fetch_error('noid', $vbphrase['category'], $vbulletin->options['webmasteremail'])));
	}

	if ($cat['catuserid'] != $vbulletin->userinfo['userid'])
	{
		print_no_permission();
	}

	($hook = vBulletinHook::fetch_hook('vba_dyna_managecats_deleteemptycat')) ? eval($hook) : false;

	$itemname = 'catid';
	$itemid = $cat['catid'];
	$formaction = 'managecats';
	$dovalue = 'do' . $_REQUEST['do'];
	$itemtitle = $cat['title'];
	$show['check_confirm'] = true;

	$navbits = fetch_cat_navbits($catid);

	if ($_REQUEST['do'] == 'emptycat')
	{
		if (!$vba_dyna->check_perms('canemptycats'))
		{
			print_no_permission();
		}
		$titlephrase = construct_phrase($vbphrase['empty_this_x'], $vbphrase['category']);
		$buttonphrase = $vbphrase['empty'];
		$confirmphrase = construct_phrase($vbphrase['are_you_sure_empty_x'], $vbphrase['category_lwr'], $vbphrase['entries']);
		$navname = construct_phrase($vbphrase['empty_x'], $vbphrase['category']);
		$navbits[''] = $navname;
	}
	else
	{
		if (!$vba_dyna->check_perms('candeletecats'))
		{
			print_no_permission();
		}
		$titlephrase = construct_phrase($vbphrase['delete_this_x'], $vbphrase['category']);
		$buttonphrase = $vbphrase['delete'];
		$confirmphrase = construct_phrase($vbphrase['are_you_sure_delete_x'], $vbphrase['category_lwr'], $vbphrase['entries']);
		$navname = construct_phrase($vbphrase['delete_x'], $vbphrase['category']);;
		$navbits[''] = $navname;
	}

	$navbits = construct_navbits($navbits);
	eval('$navbar = "' . fetch_template('navbar') . '";');

	eval('print_output("' . fetch_template(ADV_DYNA_PREFIX_UPPER . '_CONFORMATION') . '");');
}

// ####################### Do Delete / Empty Category #########################
if ($_POST['do'] == 'dodeletecat' OR $_POST['do'] == 'doemptycat')
{
	$cat = $vbulletin->adv_dyna_cats[$catid];

	if (!$cat['catid'])
	{
		eval(standard_error(fetch_error('noid', $vbphrase['category'], $vbulletin->options['webmasteremail'])));
	}

	if ($cat['catuserid'] != $vbulletin->userinfo['userid'])
	{
		print_no_permission();
	}

	require_once(DIR . '/includes/vba_dyna_functions_savecat.php');

	($hook = vBulletinHook::fetch_hook('vba_dyna_managecats_dodeleteemptycat')) ? eval($hook) : false;

	$vbulletin->url = 'managecats.php' . $vbulletin->session->vars['sessionurl_q'];

	if ($_POST['do'] == 'doemptycat')
	{
		if (!$vba_dyna->check_perms('canemptycats'))
		{
			print_no_permission();
		}
		empty_category($catid);
		eval(print_standard_redirect(ADV_DYNA_PREFIX . '_cat_emptied'));
	}
	else
	{
		if (!$vba_dyna->check_perms('candeletecats'))
		{
			print_no_permission();
		}

		$catids = array($catid);
		if ($catinfo = construct_categories($vbulletin->adv_dyna_cats, $catid))
		{
			foreach ($catinfo AS $cats)
			{
				$catids[] = $cats['catid'];
			}
		}

		$catids = implode(',', $catids);

		remove_entries_in_cat($catids);

		$db->query_write("DELETE FROM " . ADV_DYNA_TABLE_PREFIX . "categories WHERE catid IN ($catids)");
		$db->query_write("DELETE FROM " . ADV_DYNA_TABLE_PREFIX . "subscribecat WHERE catid IN ($catids)");
		$db->query_write("DELETE FROM " . ADV_DYNA_TABLE_PREFIX . "moderator WHERE catid IN ($catids)");

		update_category_cache();

		eval(print_standard_redirect(ADV_DYNA_PREFIX . '_cat_deleted'));
	}
}

?>