<?php
// ++=========================================================================++
// || vBadvanced Dynamics v1.0.0 (vB 3.6 - vB 3.7)
// ||  2003-2007 vBadvanced.com - All Rights Reserved
// || This file may not be redistributed in whole or significant part.
// || http://vbadvanced.com
// ++ ========================================================================++

error_reporting(E_ALL & ~E_NOTICE);
define('THIS_SCRIPT', 'dyna_moderate');

$phrasegroups = array(
	'adv_dyna_moderate'
);

$globaltemplates = array();

$specialtemplates = array(
	'adv_dyna_attach',
	'adv_dyna_cfield'
);

$actiontemplates = array(
	'deleteentry' => array(
		'ADV_DYNA_CONFORMATION'
	),
	'deleteposts' => array(
		'ADV_DYNA_MASSDELETE_POSTS',
		'adv_dyna_massdelete_postbits'
	),
	'moderate' => array(
		'ADV_DYNA_MODERATE',
		'adv_dyna_moderate_attachbits',
		'adv_dyna_newentry_custombits',
		'adv_dyna_moderate_entrybits',
		'adv_dyna_moderate_entrybits_messagebit',
		'adv_dyna_moderate_postbits',
		'adv_dyna_moderate_catbits',
		'adv_dyna_add_edit_custombits',
		'newpost_attachmentbit'
	)
);

if ($_REQUEST['action'] == 'viewselected' AND $_REQUEST['type'] == 'post')
{
	$globaltemplates = array(
		'ADV_DYNA_MODERATE_VIEWPOSTS',
		'bbcode_code',
		'bbcode_html',
		'bbcode_php',
		'bbcode_quote',
		'im_aim',
		'im_icq',
		'im_msn',
		'im_skype',
		'im_yahoo',
		'postbit',
		'postbit_buttons',
		'postbit_ip',
		'postbit_onlinestatus',
		'postbit_reputation',
		'postbit_wrapper'
	);

	$specialtemplates = array(
		'bbcodecache',
		'iconcache',
		'smiliecache'
	);

	$phrasegroups = array_merge(array(
		'postbit'
	), $phrasegroups);
}
else if ($_REQUEST['action'] == 'delete')
{
	$globaltemplates = array(
		'ADV_DYNA_CONFORMATION',
		'adv_dyna_moderate_deletebit'
	);

	$phrasegroups = array_merge(array(
		'threadmanage'
	), $phrasegroups);
}
else if ($_REQUEST['action'] == 'move')
{
	if (!$_REQUEST['type'] OR $_REQUEST['type'] == 'entry')
	{
		$globaltemplates = array(
			'ADV_DYNA_CONFORMATION',
			'adv_dyna_moderate_move_entries'
		);
	}
	else
	{
		$globaltemplates = array(
			'ADV_DYNA_CONFORMATION',
			'adv_dyna_moderate_move_posts'
		);
	}
}

$actiontemplates['none'] = &$actiontemplates['moderate'];

if (!isset($_REQUEST['do']))
{
	$_REQUEST['do'] = 'moderate';
}

require_once('./dyna_global.php');
require_once(DIR . '/includes/vba_dyna_functions_moderate.php');

if (!$vbulletin->userinfo['userid'])
{
	print_no_permission();
}

if (!empty($_POST))
{
	$entryid = $vbulletin->input->clean_gpc('p', 'entryid', TYPE_INT);
}

if ($entryid)
{
	$vba_dyna->load_entry();
	$entry =& $vba_dyna->_entry;
}

($hook = vBulletinHook::fetch_hook('vba_dyna_moderate_start')) ? eval($hook) : false;

// ##### Do Delete Entry ######################################################
if ($_POST['do'] == 'dodeleteentry')
{
	$vba_dyna->check_loaded_entry();

	$vbulletin->input->clean_array_gpc('p', array(
		'confirmaction' => TYPE_INT,
		'reason' => TYPE_NOHTML
	));

	if ((($entry['userid'] != $vbulletin->userinfo['userid'] AND !$vba_dyna->check_cat_perms('catdeleteothers'))
			OR ($entry['userid'] == $vbulletin->userinfo['userid'] AND !$vba_dyna->check_cat_perms('candelete')))
			AND !is_category_mod($entry['catid'])
	)
	{
		print_no_permission();
	}

	($hook = vBulletinHook::fetch_hook('vba_dyna_moderate_dodeleteentry')) ? eval($hook) : false;

	$updatecounts = false;
	$updatereason = 'update';
	$plusminus = '-';

	switch ($vbulletin->GPC['confirmaction'])
	{
		// Restore
		case 3:

			if ($entry['valid'] == 2)
			{
				$db->query_write("
					UPDATE " . ADV_DYNA_TABLE_PREFIX . "entries SET
						valid = 1
					WHERE entryid = $entry[entryid]
				");

				$updatecounts = true;
				$updatereason = 'delete';
				$plusminus = '+';
			}

		break;

		// Physically remove
		case 2:

			if ($vba_dyna->check_cat_perms('canharddelete'))
			{
				delete_entries($entry['entryid']);

				if ($entry['valid'] == 1)
				{
					$updatecounts = true;
				}

				$updatereason = 'delete';
			}

		break;

		// Soft delete
		case 1:

			if ($entry['valid'] != 2)
			{
				$db->query_write("UPDATE " . ADV_DYNA_TABLE_PREFIX . "entries SET valid = 2 WHERE entryid = $entry[entryid]");
				$updatecounts = true;
			}

		break;

		default:

			eval(standard_error(fetch_error(ADV_DYNA_PREFIX . '_nodelete', $vbphrase['entry'])));
	}

	// ##### Reason
	if ($updatereason == 'delete')
	{
		$db->query_write("
			DELETE FROM " . ADV_DYNA_TABLE_PREFIX . "deletionlog
			WHERE deletedid = $entry[entryid]
				AND type = 'entry'
		");
	}
	else
	{
		$db->query_write("
			REPLACE INTO " . ADV_DYNA_TABLE_PREFIX . "deletionlog
				(deletedid, type, userid, username, dateline, reason)
			VALUES (
				$entry[entryid],
				'entry',
				" . $vbulletin->userinfo['userid'] . ",
				'" . $db->escape_string($vbulletin->userinfo['username']) . "',
				" . TIMENOW . ",
				'" . $db->escape_string($vbulletin->GPC['reason']) . "'
			)
		");
	}

	if ($updatecounts)
	{
		require_once(DIR . '/includes/vba_dyna_functions_savecat.php');
		update_cat_lasts($entry, $plusminus);

		if ($vba_options['dyna_update_postcount_entries'])
		{
			$db->query_write("UPDATE " . TABLE_PREFIX . "user SET posts = posts-1 WHERE userid = $entry[userid]");
		}
	}

	$vbulletin->url = 'browsecategory.php?' . $vbulletin->session->vars['sessionurl'] . 'c=' . $entry['catid'];
	eval(print_standard_redirect(ADV_DYNA_PREFIX . '_deleted'));
}

// ##### Delete Entry #########################################################
if ($_POST['do'] == 'deleteentry')
{
	$vba_dyna->check_loaded_entry();

	if ((($entry['userid'] != $vbulletin->userinfo['userid'] AND !$vba_dyna->check_cat_perms('catdeleteothers')) OR !$vba_dyna->check_cat_perms('candelete')) AND !is_category_mod($entry['catid']))
	{
		print_no_permission();
	}

	$formaction = 'moderate';
	$dovalue = 'dodeleteentry';
	$itemname = 'entryid';
	$itemid =& $entry['entryid'];
	$itemtitle =& $entry['title'];
	$titlephrase = construct_phrase($vbphrase['delete_this_x'], $vbphrase['entry']);
	$buttonphrase = $vbphrase['delete'];
	$confirmphrase = construct_phrase($vbphrase['delete_x_message'], $vbphrase['entry_lwr']);

	$navname = construct_phrase($vbphrase['delete_this_x'], $vbphrase['entry']);

	$show['entryname'] = true;
	$show['check_confirm'] = true;

	fetch_entry_url($entry);

	($hook = vBulletinHook::fetch_hook('vba_dyna_moderate_deleteentry')) ? eval($hook) : false;

	$navbits = fetch_cat_navbits($entry['catid']);
	$navbits[$entry['url']] = $entry['title'];
	$navbits[''] = $navname;
	$navbits = construct_navbits($navbits);
	eval('$navbar = "' . fetch_template('navbar') . '";');

	eval('print_output("' . fetch_template(ADV_DYNA_PREFIX_UPPER . '_CONFORMATION') . '");');
}

// ##### Stick/Un-stick entry #################################################
if ($_POST['do'] == 'stickentry' OR $_POST['do'] == 'unstickentry')
{
	$vba_dyna->check_loaded_entry();

	if (!is_category_mod($entry['catid']))
	{
		print_no_permission();
	}

	if ($_POST['do'] == 'unstickentry')
	{
		$stick = 0;
		$redirectmessage = 'unstuckentry';
	}
	else
	{
		$stick = 1;
		$redirectmessage = 'stuckentry';
	}

	($hook = vBulletinHook::fetch_hook('vba_dyna_moderate_sticky')) ? eval($hook) : false;

	$db->query_write("UPDATE " . ADV_DYNA_TABLE_PREFIX . "entries SET sticky = $stick WHERE entryid = $entryid");

	fetch_entry_url($entry);

	$vbulletin->url = $entry['url'];
	eval(print_standard_redirect(ADV_DYNA_PREFIX . '_' . $redirectmessage));
}

// ##### Open/Close entry #####################################################
if ($_POST['do'] == 'closeentry' OR $_POST['do'] == 'openentry')
{
	$vba_dyna->check_loaded_entry();

	if (!is_category_mod($entry['catid']))
	{
		print_no_permission();
	}

	if ($_POST['do'] == 'closeentry')
	{
		$closeit = 0;
		$redirectmessage = 'closed';
	}
	else
	{
		$closeit = 1;
		$redirectmessage = 'opened';
	}

	($hook = vBulletinHook::fetch_hook('vba_dyna_moderate_close')) ? eval($hook) : false;

	$db->query_write("UPDATE " . ADV_DYNA_TABLE_PREFIX . "entries SET open = '$closeit' WHERE entryid = '$entryid'");

	fetch_entry_url($entry);

	$vbulletin->url = $entry['url'];
	eval(print_standard_redirect(ADV_DYNA_PREFIX . '_' . $redirectmessage));
}

// ##### Feature / Un-feature Entry ###########################################
if ($_POST['do'] == 'feature' OR $_POST['do'] == 'unfeature')
{
	$vba_dyna->check_loaded_entry();

	if (!$vba_dyna->check_cat_perms('cansetfeatured'))
	{
		print_no_permission();
	}

	if (!is_array($vbulletin->adv_dyna_featur))
	{
		$vbulletin->adv_dyna_featur = array();
	}

	if ($_POST['do'] == 'feature')
	{
		if (!in_array($entryid, $vbulletin->adv_dyna_featur))
		{
			$vbulletin->adv_dyna_featur[] = $entryid;
		}
		$redirectmessage = 'featured';
	}
	else
	{
		if (in_array($entryid, $vbulletin->adv_dyna_featur))
		{
			$featurekey = array_search($entryid, $vbulletin->adv_dyna_featur);
			unset($vbulletin->adv_dyna_featur[$featurekey]);
		}
		$redirectmessage = 'unfeatured';
	}

	($hook = vBulletinHook::fetch_hook('vba_dyna_moderate_feature')) ? eval($hook) : false;

	build_datastore(ADV_DYNA_PREFIX . '_featur', serialize($vbulletin->adv_dyna_featur), 1);

	fetch_entry_url($entry);

	$vbulletin->url = $entry['url'];
	eval(print_standard_redirect(ADV_DYNA_PREFIX . '_' . $redirectmessage));
}

// ##### IP Address For Post ##################################################
if ($_REQUEST['do'] == 'getip')
{
	$vbulletin->input->clean_gpc('r', 'type', TYPE_STR);

	if ($vbulletin->GPC['type'] == 'gbook')
	{
		$modid = $vbulletin->input->clean_gpc('p', 'modid', TYPE_INT);

		$gbuser = $db->query_first("
			SELECT user.userid, user.username
			FROM " . ADV_DYNA_TABLE_PREFIX . "guestbook AS posts
			LEFT JOIN " . TABLE_PREFIX . "user AS user ON (posts.masteruserid = user.userid)
			WHERE postid = $epostid
		");

		if (!$gbuser['userid'])
		{
			eval(standard_error(fetch_error('noid', $vbphrase['post'])));
		}

		$masteruserid = $gbuser['userid'];

		$postinfo = $db->query_first("
			SELECT ipaddress
			FROM " . ADV_DYNA_TABLE_PREFIX . "guestbook
			WHERE postid = " . $epostid
		);
	}
	else
	{
		if ($entryid)
		{
			$vba_dyna->check_loaded_entry();

			$postinfo =& $entry;
		}
		else
		{
			$postinfo = $db->query_first("
				SELECT posts.ipaddress, entries.catid
				FROM " . ADV_DYNA_TABLE_PREFIX . "posts AS posts
				LEFT JOIN " . ADV_DYNA_TABLE_PREFIX . "entries AS entries ON (posts.entryid = entries.entryid)
				WHERE postid = " . $epostid
			);
		}

		if (!is_category_mod($postinfo['catid']))
		{
			print_no_permission();
		}
	}

	($hook = vBulletinHook::fetch_hook('vba_dyna_moderate_getip')) ? eval($hook) : false;

	eval(standard_error(fetch_error('thread_displayip', $postinfo['ipaddress'], @gethostbyaddr($postinfo['ipaddress']))));
}

// ##### Validate New Entries #################################################
if ($_REQUEST['do'] == 'moderate')
{
	if ($_REQUEST['type'] == 'entries' OR !$_REQUEST['type'])
	{
		require_once(DIR . '/includes/vba_dyna_functions_saveentry.php');
	}

	$type = $vbulletin->input->clean_gpc('r', 'type', TYPE_NOHTML);
	$page = $vbulletin->input->clean_gpc('r', 'page', TYPE_INT);
	$pagecount = $vbulletin->input->clean_gpc('r', 'pagecount', TYPE_INT);
	$itemcount = $vbulletin->input->clean_gpc('r', 'itemcount', TYPE_INT);
	$lastitemid = $vbulletin->input->clean_gpc('r', 'lastitemid', TYPE_INT);
	$checkall = $vbulletin->input->clean_gpc('r', 'checkall', TYPE_INT);
	$allbox = $vbulletin->input->clean_gpc('r', 'allbox', TYPE_INT);
	$attach_checkall = $vbulletin->input->clean_gpc('r', 'attach_checkall', TYPE_INT);

	if ($type != 'posts' AND $type != 'categories' AND $type != 'attachments')
	{
		$type = 'entries';
	}

	$modcats = fetch_moderator_cats();

	$tableheader = construct_phrase($vbphrase['x_awaiting_moderation'], $vbphrase[$type]);

	$condition = array();
	$wherequery = array();

	($hook = vBulletinHook::fetch_hook('vba_dyna_moderate_validate_start')) ? eval($hook) : false;

	switch ($type)
	{
		// ##### Approving entries
		case 'entries':

			// Custom fields
			$custominfo =& $vbulletin->adv_dyna_cfield;

			$condition['fromtable'] = ADV_DYNA_PREFIX . '_entries AS entries';
			$wherequery = array('valid = 0');

			if (!empty($modcats))
			{
				$wherequery[] = 'entries.catid IN(' . implode(',', $modcats) . ')';
			}

			if ($lastitemid)
			{
				$wherequery[] = 'entryid > ' . $lastitemid;
			}

			($hook = vBulletinHook::fetch_hook('vba_dyna_moderate_validate_entries_start')) ? eval($hook) : false;

		break;

		// ##### Approving posts
		case 'posts':

			$condition['fromtable'] = ADV_DYNA_PREFIX . '_posts AS posts';
			$condition['jointable'] = ADV_DYNA_PREFIX . '_entries AS entries ON (posts.entryid = entries.entryid)';
			$wherequery = array('visible = 0');

			if (!empty($modcats))
			{
				$wherequery[] = 'entries.catid IN(' . implode(',', $modcats) . ')';
			}

			if ($lastitemid)
			{
				$wherequery[] = 'postid > ' . $lastitemid;
			}

			($hook = vBulletinHook::fetch_hook('vba_dyna_moderate_validate_posts_start')) ? eval($hook) : false;

		break;

		// ##### Approving categories
		case 'categories':

			$condition['fromtable'] = ADV_DYNA_PREFIX . '_categories AS categories';
			$wherequery = array('valid = 0');

			if ($catquery)
			{
				$wherequery[] = 'parent' . $catquery;
			}

			if ($lastitemid)
			{
				$wherequery[] = 'catid > ' . $lastitemid;
			}

			($hook = vBulletinHook::fetch_hook('vba_dyna_moderate_validate_categories_start')) ? eval($hook) : false;

		break;

		// ##### Approving attachments
		case 'attachments':
			$condition['fromtable'] = ADV_DYNA_PREFIX . '_attachments AS attachments';
			$condition['jointable'] = ADV_DYNA_PREFIX . '_entries AS entries ON (attachments.entryid = entries.entryid)';
			$wherequery = array('attachments.valid = 0');

			if (!empty($modcats))
			{
				$wherequery[] = 'entries.catid IN(' . implode(',', $modcats) . ')';
			}

			($hook = vBulletinHook::fetch_hook('vba_dyna_moderate_validate_attachments_start')) ? eval($hook) : false;
		break;
	}

	if (!$page)
	{
		$page = 1;
	}

	$perpage = 40;

	$pagedata = fetch_page_data($condition['fromtable'], $wherequery, array($condition['jointable']), $perpage, iif($page > 1, $itemcount, false));

	$itemcount = $pagedata['count'];
	$pagecount = $pagedata['pagecount'];

	$pageinfo = '';
	if ($itemcount)
	{
		$pageinfo = construct_phrase($vbphrase['page_x_of_y'], $page, $pagedata['pagecount']);
	}

	switch ($type)
	{
		// ##### Get the entries
		case 'entries':
			$entryids = array();

			$getentries = $db->query_read("
				SELECT entryid FROM " . ADV_DYNA_TABLE_PREFIX . "entries AS entries
				WHERE " . implode(' AND ', $wherequery) . "
				ORDER BY entryid
				LIMIT $perpage
			");
			while ($entries = $db->fetch_array($getentries))
			{
				$entryids[] = $entries['entryid'];
			}

			if (!empty($entryids))
			{
				$entryids_str = implode(',', $entryids);
				// Attachments
				$entryattach = array();
				$getattach = $db->query_read("
					SELECT attach.*
					FROM " . ADV_DYNA_TABLE_PREFIX . "attachments AS attach
					LEFT JOIN " . ADV_DYNA_TABLE_PREFIX . "attachmenttype AS attachtype ON(attach.extension = attachtype.extension)
					WHERE entryid IN($entryids_str)
						AND valid = 0
					ORDER BY attachtype.displayorder ASC, attach.dateline ASC
				");
				while ($attach = $db->fetch_array($getattach))
				{
					$entryattach[$attach['entryid']][$attach['attachmentid']] = $attach;
				}

				if ($vba_options['dyna_multipage_limit'])
				{
					$epages = array();

					$getepages = $db->query_read("
						SELECT entryid, pagenumber, pagetext
						FROM " . ADV_DYNA_TABLE_PREFIX . "entries_pages
						WHERE entryid IN($entryids_str)
					");
					while ($epage = $db->fetch_array($getepages))
					{
						$epages[$epage['entryid']][$epage['pagenumber']] = $epage['pagetext'];
					}
				}

			  $getrows = $db->query_read("
					SELECT entries.*, pagetext, user.email, cfields.*
					FROM " . ADV_DYNA_TABLE_PREFIX . "entries AS entries
					LEFT JOIN " . ADV_DYNA_TABLE_PREFIX . "entries_pages AS entries_pages ON (entries.entryid = entries_pages.entryid AND pagenumber = 1)
					LEFT JOIN " . TABLE_PREFIX . "user AS user ON (entries.userid = user.userid)
					LEFT JOIN " . ADV_DYNA_TABLE_PREFIX . "cfields_entries AS cfields ON (entries.entryid = cfields.eid)
					WHERE entries.entryid IN (" . implode(', ', $entryids) . ")
					ORDER BY entryid
					LIMIT $perpage
			  ");
			}
		 break;

		// ##### Get the posts
		case 'posts':
			$getrows = $db->query_read("
				SELECT posts.*, entries.catid, entries.title AS entrytitle, entries.userid AS entryuserid
				FROM " . ADV_DYNA_TABLE_PREFIX . "posts AS posts
				LEFT JOIN " . ADV_DYNA_TABLE_PREFIX . "entries AS entries ON (posts.entryid = entries.entryid)
				WHERE " . implode(' AND ', $wherequery) . "
				ORDER BY dateline
				LIMIT $perpage
			");
		break;

		// ##### Get the categories
		case 'categories':
			$getrows = $db->query_read("
				SELECT catid, title, description, parent, parentlist, catuserid, username
				FROM " . ADV_DYNA_TABLE_PREFIX . "categories AS categories
				LEFT JOIN " . TABLE_PREFIX . "user AS user ON (categories.catuserid = user.userid)
				WHERE " . implode(' AND ', $wherequery) . "
				ORDER BY catid DESC
				LIMIT $perpage
			");
		break;

		// ##### Get the attachments
		case 'attachments':
			$getrows = $db->query_read("
				SELECT attachmentid, attachments.entryid, filename, attachments.dateline, extension, hasthumb, attachments.userid, user.username, entries.title, entries.catid
				FROM " . ADV_DYNA_TABLE_PREFIX . "attachments AS attachments
				LEFT JOIN " . ADV_DYNA_TABLE_PREFIX . "entries AS entries ON (attachments.entryid = entries.entryid)
				LEFT JOIN " . TABLE_PREFIX . "user AS user ON (attachments.userid = user.userid)
				WHERE " . implode(' AND ', $wherequery) . "
				ORDER BY attachmentid DESC
				LIMIT $perpage
			");
		break;

	}

	if ($db->num_rows($getrows))
	{
		$show['validate'] = true;

		// Checkboxes
		if ($page == 1 OR $allbox)
		{
			$checkedemail = 'checked="checked"';
		}
		if ($page == 1 OR $attach_checkall)
		{
			$checkedattach = 'checked="checked"';
		}
		if ($page == 1)
		{
			$checkedaction['1'] = 'checked="checked"';
		}
		else
		{
			$checkedaction[$checkall] = 'checked="checked"';
		}

		// Actions row
		$action_sprint = iif($type == 'entries', '<div style="float:' . $stylevar['right'] . '">
			<label for="sendmail_%1$d">' . $vbphrase['send_email'] . ' <input ' . $checkedemail . ' id="sendmail_%1$d" name="sendmail[%1$d]" type="checkbox" value="1" /></label></div>')
			 . '<label for="val_%1$d">
				<input ' . $checkedaction['1'] . ' id="val_%1$d" name="%2$s[%1$d]" type="radio" value="1" />' . $vbphrase['validate'] . '</label>
			<label for="del_%1$d">
				<input ' . $checkedaction['2'] . ' id="del_%1$d" name="%2$s[%1$d]" type="radio" value="2" />' . $vbphrase['delete'] . '</label>
			<label for="ign_%1$d">
				<input ' . $checkedaction['0'] . ' id="ign_%1$d" name="%2$s[%1$d]" type="radio" value="0" />' . $vbphrase['ignore'] . '</label>';

		// ##### Print out the rows depending on which section we're dealing with
		switch ($type)
		{
			// ##### Entries
			case 'entries':

			  while ($entry = $db->fetch_array($getrows))
			  {
					$rowactions = sprintf($action_sprint, $entry['entryid'], 'validateentry');

					($hook = vBulletinHook::fetch_hook('vba_dyna_moderate_validate_entries_loop')) ? eval($hook) : false;

					$attachments = '';
					if (!empty($entryattach[$entry['entryid']]))
					{
						$show['attachrow'] = true;

						foreach ($entryattach[$entry['entryid']] AS $attachid => $attach)
						{
							$attach['imgpath'] = $stylevar['imgdir_attach'] . '/' . $attach['extension'] . '.gif';
							$attach['filesize'] = fetch_rfilesize($attach['filesize']);
							eval('$attachments .= "' . fetch_template('newpost_attachmentbit') . '";');
						}
					}

					$entry['dateadded'] = vbdate($vbulletin->options['dateformat'], $entry['dateline']);
					$entry['timeadded'] = vbdate($vbulletin->options['timeformat'], $entry['dateline']);
					$catoptions = print_cat_select($entry['catid'], 'submitentry');
					$customfieldbits = construct_custom_fieldbits($entry, $custominfo, true, false, true);

					if ($vba_options['dyna_multipage_limit'])
					{
						foreach ($epages[$entry['entryid']] AS $epageid => $pagetext)
						{
							eval('$messagebits .= "' . fetch_template(ADV_DYNA_PREFIX . '_moderate_entrybits_messagebit') . '";');
						}
					}
					else
					{
						$epageid = 1;
						$pagetext = htmlspecialchars($entry['pagetext']);
						eval('$messagebits = "' . fetch_template(ADV_DYNA_PREFIX . '_moderate_entrybits_messagebit') . '";');
					}

					eval('$moderationbits .= "' . fetch_template(ADV_DYNA_PREFIX . '_moderate_entrybits') . '";');

					$lastitemid = $entry['entryid'];
				}
			break;

			// ##### Posts
			case 'posts':

				while ($post = $db->fetch_array($getrows))
				{
					$rowactions = sprintf($action_sprint, $post['postid'], 'validatepost');

					($hook = vBulletinHook::fetch_hook('vba_dyna_moderate_validate_posts_loop')) ? eval($hook) : false;

					$fakeentryarray = array('title' => $post['entrytitle'], 'entryid' => $post['entryid'], 'catid' => $post['catid']);
					fetch_entry_url($fakeentryarray);

					$post['url'] = $fakeentryarray['url'];

					$post['dateadded'] = vbdate($vbulletin->options['dateformat'], $post['dateline']);
					$post['timeadded'] = vbdate($vbulletin->options['timeformat'], $post['dateline']);
					$post['pagetext'] = htmlspecialchars($post['pagetext']);

					eval('$moderationbits .= "' . fetch_template(ADV_DYNA_PREFIX . '_moderate_postbits') . '";');

					$lastitemid = $post['postid'];
				}
			break;

			// ##### Categories
			case 'categories':

				while ($cat = $db->fetch_array($getrows))
				{
					$rowactions = sprintf($action_sprint, $cat['catid'], 'validatecat');

					($hook = vBulletinHook::fetch_hook('vba_dyna_moderate_validate_categories_loop')) ? eval($hook) : false;

					eval('$moderationbits .= "' . fetch_template(ADV_DYNA_PREFIX . '_moderate_catbits') . '";');
					$lastitemid = $cat['catid'];
				}

			break;

			// ##### Attachments
			case 'attachments':

				while ($attach = $db->fetch_array($getrows))
				{
					$rowactions = sprintf($action_sprint, $attach['attachmentid'], 'validateattach');

					($hook = vBulletinHook::fetch_hook('vba_dyna_moderate_validate_attachments_loop')) ? eval($hook) : false;

					$attach['thumburl'] = fetch_attach_thumb_url($attach);
					$attach['dateadded'] = vbdate($vbulletin->options['dateformat'], $attach['dateline']);
					$attach['timeadded'] = vbdate($vbulletin->options['timeformat'], $attach['dateline']);
					fetch_entry_url($attach);

					eval('$moderationbits .= "' . fetch_template(ADV_DYNA_PREFIX . '_moderate_attachbits') . '";');
					$lastitemid = $attach['attachmentid'];
				}
			break;
		}
	}

	($hook = vBulletinHook::fetch_hook('vba_dyna_moderate_validate_end')) ? eval($hook) : false;

	$invalidentry = $db->query_first("SELECT COUNT(*) AS count FROM " . ADV_DYNA_TABLE_PREFIX . "entries WHERE valid = 0");
	$invalidpost = $db->query_first("SELECT COUNT(*) AS count FROM " . ADV_DYNA_TABLE_PREFIX . "posts WHERE visible = 0");
	$invalidcat = $db->query_first("SELECT COUNT(*) AS count FROM " . ADV_DYNA_TABLE_PREFIX . "categories WHERE valid = 0");
	$invalidattach = $db->query_first("SELECT COUNT(*) AS count FROM " . ADV_DYNA_TABLE_PREFIX . "attachments WHERE valid = 0");

	$navbits[''] = $vbphrase['moderate_new'];
	$navbits = construct_navbits($navbits);
	eval('$navbar = "' . fetch_template('navbar') . '";');

	eval('print_output("' . fetch_template(ADV_DYNA_PREFIX_UPPER . '_MODERATE') . '");');
}

// ##### Do Validate New Entries ##############################################
if ($_POST['do'] == 'dovalidate')
{
	require_once(DIR . '/includes/vba_dyna_functions_moderate.php');

	$page = $vbulletin->input->clean_gpc('p', 'page', TYPE_INT);
	$pagecount = $vbulletin->input->clean_gpc('p', 'pagecount', TYPE_INT);
	$itemcount = $vbulletin->input->clean_gpc('p', 'itemcount', TYPE_INT);
	$lastitemid = $vbulletin->input->clean_gpc('p', 'lastitemid', TYPE_INT);
	$checkall = $vbulletin->input->clean_gpc('p', 'checkall', TYPE_INT);
	$allbox = $vbulletin->input->clean_gpc('p', 'allbox', TYPE_INT);
	$type = $vbulletin->input->clean_gpc('p', 'type', TYPE_NOHTML);
	$attach_checkall = $vbulletin->input->clean_gpc('p', 'attach_checkall', TYPE_INT);

	($hook = vBulletinHook::fetch_hook('vba_dyna_moderate_dovalidate_start')) ? eval($hook) : false;

	if ($type != 'entries' AND $type != 'posts' AND $type != 'categories' AND $type != 'attachments')
	{
		eval(standard_error(fetch_error('invalid_action')));
	}

	switch ($type)
	{
		// ##### Process entries
		case 'entries':
			require_once(DIR . '/includes/vba_dyna_functions_saveentry.php');

			$validateentry = $_POST['validateentry'];

			$checkentries = array_map('intval', array_keys($validateentry));

			$vbulletin->input->clean_array_gpc('p', array(
				'sendmail' => TYPE_ARRAY_INT,
				'validateattach' => TYPE_ARRAY_INT
			));

			$noupdate = array();
			if (!empty($checkentries))
			{
				$chkentries = $db->query_read("
					SELECT entryid, valid, draft
					FROM " . ADV_DYNA_TABLE_PREFIX . "entries
					WHERE entryid IN(" . implode(',', $checkentries) . ")
						AND (valid = 1 OR draft = 1)
				");
				while ($chkentry = $db->fetch_array($chkentries))
				{
					$noupdate[$chkentry['entryid']] = 1;
				}
			}

			if ($vba_options['dyna_cachedlife'])
			{
				// Load BBcode parser
				require_once(DIR . '/includes/class_bbcode.php');
				$bbcode_parser =& new vB_BbCodeParser($vbulletin, fetch_tag_list());
			}

			$deleteentries = array();
			$updatecats = array();
			$validateattach = array();
			$killparsed = array();
			$ecache_query = '';

			$attachentryids = array_keys($vbulletin->GPC['validateattach']);

			// Time to sort the entries
			if (is_array($validateentry) AND !empty($validateentry))
			{
				$entryuserids = array();
				$entryuserids_multi = array();

				foreach ($validateentry AS $entryid => $action)
				{
					if (!$action)
					{
						continue;
					}

					$entry =& $_POST['entry'][$entryid];

					$entry['title'] = htmlspecialchars($entry['title']);
					$entry['keywords'] = htmlspecialchars($entry['keywords']);
					$entry['catid'] = intval($entry['catid']);
					$entry['views'] = intval($entry['views']);

					($hook = vBulletinHook::fetch_hook('vba_dyna_moderate_dovalidate_entries')) ? eval($hook) : false;

					if (in_array($entryid, $attachentryids))
					{
						$validateattach[] = $entryid;
					}

					switch($action)
					{
						// Delete
						case 2:
							$deleteentries[] = $entryid;

							if ($vbulletin->GPC['sendmail'][$entryid] AND !empty($entry['email']))
							{
								eval(fetch_email_phrases(ADV_DYNA_PREFIX . '_deletion', 0));

								vbmail($entry['email'], $subject, $message);
							}
						break;

						// Validate
						case 1:

							if (in_array($entry['userid'], $entryuserids))
							{
								$entryuserids_multi[$entry['userid']]++;
							}
							else
							{
								$entryuserids[] = $entry['userid'];
							}

							if ($vbulletin->GPC['sendmail'][$entryid] AND !empty($email[$entryid]))
							{
								construct_entry_url($entry);
								eval(fetch_email_phrases(ADV_DYNA_PREFIX . '_validation', 0));

								vbmail($entry['email'], $subject, $message);
							}

							if (!$noupdate[$entryid])
							{
								$updatecats[$entry['catid']]['entrycount']++;

								if ($entry['dateline'] > $updatecats[$entry['catid']]['lastentrydateline'])
								{
									$updatecats[$entry['catid']]['lastentryid'] = $entryid;
									$updatecats[$entry['catid']]['lastentryusername'] = $entry['username'];
									$updatecats[$entry['catid']]['lastentryuserid'] = $entry['userid'];
									$updatecats[$entry['catid']]['lastentrydateline'] = $entry['dateline'];
									$updatecats[$entry['catid']]['lastentrytitle'] = $entry['title'];
								}

								$updateusercats[$entry['userid']][$entry['catid']] = $updatecats[$entry['catid']];
							}

						// Do nothing, but still update since the entries could have changed
						default:

							$db->query_write("
								UPDATE " . ADV_DYNA_TABLE_PREFIX . "entries SET
									title = '" . $db->escape_string($entry['title']) . "',
									keywords = '" . $db->escape_string($entry['keywords']) . "',
									views = $entry[views],
									catid = $entry[catid],
									notes = '" . $db->escape_string($entry['notes']) . "',
									valid = " . iif($action == 1, 1, 0) . "
								WHERE entryid = $entryid
							");

							if ($vba_options['dyna_cachedlife'])
							{
								$killparsed[] = $entryid;
							}

							// Update pages
							foreach ($entry['pagetext'] AS $epageid => $pagetext)
							{
								$db->query_write("
									UPDATE " . ADV_DYNA_TABLE_PREFIX . "entries_pages SET
										pagetext = '" . $db->escape_string($pagetext) . "'
									WHERE entryid = $entryid
										AND pagenumber = $epageid
								");

								// Entry cache
								if ($vba_options['dyna_cachedlife'])
								{
									$bbcode_parser->cached['text'] = '';

									// Parse pagetext
									$pagetext_parsed = $bbcode_parser->parse(
										$pagetext,
										'nonforum',
										$vbulletin->options['allowsmilies'],
										true,
										'',
										3,
										($entry['dateline'] >= (TIMENOW - ($vba_options['dyna_cachedlife'] * 86400)) ? true : false)
									);

									// Entry cache
									if ($bbcode_parser->cached['text'])
									{
										$ecache_query .= '(
											' . $entryid . ',
											' . $epageid . ',
											\'' . $db->escape_string($bbcode_parser->cached['text']) . '\',
											' . TIMENOW . ',
											' . $vbulletin->userinfo['styleid'] . ',
											' . $vbulletin->userinfo['languageid'] . ',
											' . $bbcode_parser->cached['has_images'] . '
										), ';
									}
								}
							}

							construct_customfields_sql($entryid, false, true);
					}
				}

				// Delete old parsed entries
				if (!empty($killparsed))
				{
					$db->query_write("DELETE FROM " . ADV_DYNA_TABLE_PREFIX . "entryparsed WHERE entryid IN(" . implode(',', $killparsed) . ")");
				}

				// Insert new parsed
				if ($ecache_query)
				{
					$db->query_write("
						INSERT INTO " . ADV_DYNA_TABLE_PREFIX . "entryparsed
							(entryid, pagenumber, pagetext_parsed, dateline, styleid, languageid, hasimages)
						VALUES
							" . substr($ecache_query, 0, (strlen($ecache_query) - 2))
					);
				}

				// Update user post counts
				if (!empty($entryuserids) AND $vba_options['dyna_update_postcount_entries'])
				{
					$db->query_write("UPDATE " . TABLE_PREFIX . "user SET posts = posts+1 WHERE userid IN(" . implode(', ', $entryuserids) . ")");

					// Users with more than one entry validated
					if (!empty($entryuserids_multi))
					{
						foreach ($entryuserids_multi AS $euserid => $eposts)
						{
							$db->query_write("UPDATE " . TABLE_PREFIX . "user SET posts = posts+$eposts WHERE userid = $euserid");
						}
					}
				}

				// Update the category counts and info
				if (!empty($updatecats))
				{
					$curdateline = array();
					$getcurcats = $db->query_read("
						SELECT catid, lastentrydateline
						FROM " . ADV_DYNA_TABLE_PREFIX . "categories
						WHERE catid IN(" . implode(',', array_keys($updatecats)) . ")
					");
					while ($ccat = $db->fetch_array($getcurcats))
					{
						$curdateline[$ccat['catid']] = $ccat['lastentrydateline'];
					}

					foreach ($updatecats AS $ucatid => $ucat)
					{
						$db->query_write("
							UPDATE " . ADV_DYNA_TABLE_PREFIX . "categories SET
								entrycount = entrycount+$ucat[entrycount] " .
								iif($ucat['lastentrydateline'] > $curdateline[$ucatid], ",
									lastentryid = $ucat[lastentryid],
									lastentryusername = '" . $db->escape_string($ucat['lastentryusername']) . "',
									lastentrytitle = '" . $db->escape_string($ucat['lastentrytitle']) . "',
									lastentryuserid = $ucat[lastentryuserid],
									lastentrydateline = $ucat[lastentrydateline]")
								. "
							WHERE catid = '$ucatid'
						");
					}
				}

				// Update members cat info
				if (!empty($updateusercats))
				{
					$curdateline = array();
					$getcurcats = $db->query_read("
						SELECT catid, userid, lastentrydateline
						FROM " . ADV_DYNA_TABLE_PREFIX . "memberscats
						WHERE catid IN(" . implode(',', array_keys($updatecats)) . ")
					");
					while ($ccat = $db->fetch_array($getcurcats))
					{
						$curdateline[$ccat['userid']][$ccat['catid']] = $ccat['lastentrydateline'];
					}

					foreach ($updateusercats AS $catuserid => $userscats)
					{
						foreach ($userscats AS $usercatid => $usercat)
						{
							// Try to insert
							$db->query_write("
								INSERT IGNORE INTO " . ADV_DYNA_TABLE_PREFIX . "memberscats
									(catid, userid, entrycount, lastentryid, lastentrytitle, lastentrydateline, lastentryuserid, lastentryusername)
								VALUES (
									$usercatid,
									$catuserid,
									0,
									$usercat[lastentryid],
									'" . $db->escape_string($usercat['lastentrytitle']) . "',
									" . TIMENOW . ",
									$usercat[lastentryuserid],
									'" . $db->escape_string($usercat['lastentryusername']) . "'
							)");

							$db->query_write("
								UPDATE " . ADV_DYNA_TABLE_PREFIX . "memberscats SET
									entrycount = entrycount+$usercat[entrycount] " .
									iif($usercat['lastentrydateline'] > $curdateline[$ucatid], ",
										lastentryid = $usercat[lastentryid],
										lastentrytitle = '" . $db->escape_string($usercat['lastentrytitle']) . "',
										lastentrydateline = $usercat[lastentrydateline],
										lastentryusername = '" . $db->escape_string($usercat['lastentryusername']) . "',
										lastentryuserid = $usercat[lastentryuserid]")
									. "
								WHERE catid = $usercatid AND userid = $catuserid
							");
						}
					}
				}

				if (!empty($deleteentries))
				{
					delete_entries($deleteentries);
				}
			}

			// Attachments
			if (!empty($validateattach))
			{
				$db->query_write("UPDATE " . ADV_DYNA_TABLE_PREFIX . "attachments SET valid = 1 WHERE entryid IN(" . implode(',', $validateattach) . ")");
				update_entry_attach_count($validateattach);
			}
		break;

		// ##### Process posts
		case 'posts':
			require_once(DIR . '/includes/vba_dyna_functions_posting.php');

			$validatepost = $_POST['validatepost'];

			if (is_array($validatepost))
			{
				$postuserids = array();
				$postuserids_multi = array();

				foreach ($validatepost AS $postid => $action)
				{
					$postid = intval($postid);

					// Delete
					if ($action == 2)
					{
						$db->query_write("DELETE FROM " . ADV_DYNA_TABLE_PREFIX . "posts WHERE postid = $postid");
					}
					// Not deleting
					else
					{
						$post = $_POST['post'][$postid];

						$post['catid'] = intval($post['catid']);
						$post['entryid'] = intval($post['entryid']);
						$post['dateline'] = intval($post['dateline']);
						$post['userid'] = intval($post['userid']);
						$post['entryuserid'] = intval($post['entryuserid']);

						($hook = vBulletinHook::fetch_hook('vba_dyna_moderate_dovalidate_posts')) ? eval($hook) : false;

						$db->query_write("
							UPDATE " . ADV_DYNA_TABLE_PREFIX . "posts SET
								title = '" . $db->escape_string(htmlspecialchars($post['title'])) . "',
								pagetext = '" . $db->escape_string($post['message']) . "',
								visible = " . intval($action) . "
							WHERE postid = '$postid'
						");

						// Approved
						if ($action == 1)
						{
							if (in_array($post['userid'], $postuserids))
							{
								$postuserids_multi[$post['userid']]++;
							}
							else
							{
								$postuserids[] = $post['userid'];
							}

							// Update entry info
							$entry = $db->query_first("SELECT lastpostdateline FROM " . ADV_DYNA_TABLE_PREFIX . "entries WHERE entryid = $post[entryid]");

							$db->query_write("
								UPDATE " . ADV_DYNA_TABLE_PREFIX . "entries SET
									posts = posts+1 " .
										iif($entry['lastpostdateline'] < $post['dateline'], ",
											lastpostid = $postid,
											lastpostuserid = $post[userid],
											lastpostusername = '" . $db->escape_string($post['username']) . "',
											lastpostdateline = $post[dateline]
										") . "
								WHERE entryid = $post[entryid]
							");

							// Send email to subscribed users
							send_subscribed_posts($post['entryid'], true, $post['userid'], $post['username'], $post['message']);

							// Update category info
							$cat = $db->query_first("SELECT lastpostdateline FROM " . ADV_DYNA_TABLE_PREFIX . "categories WHERE catid = '$post[catid]'");

							$db->query_write("
								UPDATE " . ADV_DYNA_TABLE_PREFIX . "categories SET
									postcount = postcount+1 " .
									iif($cat['lastpostdateline'] < $post['dateline'], ",
										lastpostid = $postid,
										lastpostuserid = $post[userid],
										lastpostusername = '" . $db->escape_string($post['username']) . "',
										lastpostdateline = $post[dateline],
										lastpostentrytitle = '" . $db->escape_string($post['entryname']) . "'
									") . "
								WHERE catid = $post[catid]
							");

							// Update members' category info
							$membercat = $db->query_first("SELECT lastpostdateline FROM " . ADV_DYNA_TABLE_PREFIX . "memberscats WHERE catid = $post[catid] AND userid = $post[entryuserid]");

							$db->query_write("
								UPDATE " . ADV_DYNA_TABLE_PREFIX . "memberscats SET
									postcount = postcount+1 " .
									iif($membercat['lastpostdateline'] < $post['dateline'], ",
										lastpostid = $postid,
										lastpostuserid = $post[userid],
										lastpostusername = '" . $db->escape_string($post['username']) . "',
										lastpostdateline = $post[dateline],
										lastpostentrytitle = '" . $db->escape_string($post['entryname']) . "'
									") . "
								WHERE catid = $post[catid]
									AND userid = $post[entryuserid]
							");

						}
					}
				}

				// Update user post counts
				if (!empty($postuserids) AND $vba_options['dyna_update_postcount'])
				{
					$db->query_write("UPDATE " . TABLE_PREFIX . "user SET posts = posts+1 WHERE userid IN(" . implode(', ', $postuserids) . ")");

					// Users with more than one post validated
					if (!empty($postuserids_multi))
					{
						foreach ($postuserids_multi AS $puserid => $pposts)
						{
							$db->query_write("UPDATE " . TABLE_PREFIX . "user SET posts = posts+$pposts WHERE userid = $puserid");
						}
					}
				}
			}

		break;

		// ##### Process categories
		case 'categories':
			$validatecat = $_POST['validatecat'];
			$catinfo = $_POST['cats'];

			if (is_array($validatecat))
			{
				foreach ($validatecat AS $catid => $action)
				{
					($hook = vBulletinHook::fetch_hook('vba_dyna_moderate_dovalidate_categories')) ? eval($hook) : false;

					// Delete
					if ($action == 2)
					{
						$db->query_write("DELETE FROM " . ADV_DYNA_TABLE_PREFIX . "categories WHERE catid = $catid");
					}
					else
					{
						$cat = $catinfo[$catid];

						$db->query_write("
							UPDATE " . ADV_DYNA_TABLE_PREFIX . "categories SET
								title = '" . $db->escape_string(htmlspecialchars($cat['title'])) . "',
								description = '" . $db->escape_string($cat['description']) . "',
								valid = " . intval($action) . "
							WHERE catid = $catid
						");
					}
				}
			}

			require_once(DIR . '/includes/vba_dyna_functions_savecat.php');

			update_category_cache();
			break;

		// ##### Process attachments
		case 'attachments':

			$validateattach = $vbulletin->input->clean_gpc('p', 'validateattach', TYPE_ARRAY_INT);

			$validate = array();
			$delete = array();
			// Sort them into an array for validating and deleting
			if (!empty($validateattach))
			{
				foreach ($validateattach AS $attachid => $action)
				{
					($hook = vBulletinHook::fetch_hook('vba_dyna_moderate_dovalidate_attachments')) ? eval($hook) : false;

					switch ($action)
					{
						case 2:
							$delete[] = $attachid;
						break;

						case 1:
							$validate[] = $attachid;
						break;
					}
				}
			}

			if (!empty($validate) OR !empty($delete))
			{
				// ##### Validate
				if (!empty($validate))
				{
					$db->query_write("
						UPDATE " . ADV_DYNA_TABLE_PREFIX . "attachments SET
							valid = 1
						WHERE attachmentid IN(" . implode(',', $validate) . ")
					");
				}

				// ##### Delete
				if (!empty($delete))
				{
					// Load the $vba_image class
					require_once(DIR . '/includes/vba_dyna_class_image.php');

					$vba_image =& new vba_dyna_image();
					$vba_image->_vb =& $vbulletin;

					$killattach = $db->query_read("
						SELECT entryid, userid, filename, dateline, extension, hasthumb
						FROM " . ADV_DYNA_TABLE_PREFIX . "attachments
						WHERE attachmentid IN(" . implode(',', $delete) . ")
					");
					while ($kattach = $db->fetch_array($killattach))
					{
						$folderpath = $vba_options['dyna_attachpath'] . '/' . $vba_image->fetch_upload_folders($kattach['userid']) . '/' . $kattach['filename'] . '_' . $kattach['dateline'];

						@unlink('.' . $kattach['extension']);

						if ($kattach['hasthumb'])
						{
							@unlink('_thumb.' . $kattach['extension']);
						}
					}

					$db->query_write("DELETE FROM " . ADV_DYNA_TABLE_PREFIX . "attachments WHERE attachmentid IN(" . implode(',', $delete) . ")");
				}

				// ##### Update the hasattach count for entries
				$updateentries = array_merge($validate, $delete);

				if (!empty($updateentries))
				{
					update_entry_attach_count($updateentries);
				}
			break;
		}
	}

	($hook = vBulletinHook::fetch_hook('vba_dyna_moderate_dovalidate_end')) ? eval($hook) : false;

	if ($page < $pagecount)
	{
		$nextpage .= "&page=" . ($page + 1) . "&lastitemid=$lastitemid&pagecount=$pagecount&itemcount=$itemcount&allbox=$allbox&checkall=$checkall&attach_checkall=$attach_checkall";
	}

	$vbulletin->url = 'moderate.php?' . $vbulletin->session->vars['sessionurl'] . 'do=moderate&type=' . $type . $nextpage;
	eval(print_standard_redirect(ADV_DYNA_PREFIX . '_new_x_validated'));
}

// ##### Quick Moderation #####################################################
if ($_POST['do'] == 'inlinemoderation')
{
	$vbulletin->input->clean_array_gpc('p', array(
		'action' => TYPE_STR,
		'plist' => TYPE_ARRAY_STR,
		'tlist' => TYPE_ARRAY_STR,
		'type' => TYPE_STR,
		'url' => TYPE_NOHTML
	));

	$cookiename = 'vbulletin_inline' . iif($vba_options['dyna_entrybitexpanded'] OR $vbulletin->GPC['type'] == 'post', 'post', 'thread');

	// ##### Clear Quick Moderation Cookies
	if ($vbulletin->GPC['action'] == 'deselectall')
	{
		setcookie($cookiename, '', (TIMENOW - 3600), '/');
		eval(print_standard_redirect('redirect_inline_threadlist_cleared'));
	}

	require_once(DIR . '/includes/vba_dyna_functions_moderate.php');

	$limitcats = fetch_moderator_cats();

	$catquery = '';
	if (!empty($limitcats))
	{
		$catquery = 'AND catid IN(' . implode(',', $limitcats) . ')';
	}

	$cookielist = $vbulletin->input->clean_gpc('c', $cookiename, TYPE_STR);

	($hook = vBulletinHook::fetch_hook('vba_dyna_moderate_inlinemod_start')) ? eval($hook) : false;

	// ####################
	// ##### Posts
	if ($vbulletin->GPC['type'] == 'post')
	{
		$postids = process_cookie_list();

		$redirphrase = $vbphrase['posts'];

		$validposts = array();
		$entrycats = array();
		$entryusercats = array();
		$entrylist = array();
		$getposts = $db->query_read("
			SELECT postid, post.entryid, catid, entry.userid AS entryuserid
			FROM " . ADV_DYNA_TABLE_PREFIX . "posts AS post
			LEFT JOIN " . ADV_DYNA_TABLE_PREFIX . "entries AS entry ON (post.entryid = entry.entryid)
			WHERE postid IN(" . implode(',', $postids) . ")
				$catquery
		");
		while ($post = $db->fetch_array($getposts))
		{
			$validposts[] = $post['postid'];
			$entrycats[] = $post['catid'];
			$entryusercats[$post['catid']][] = $post['entryuserid'];
			$entrylist[] = $post['entryid'];
		}

		$entrylist = array_unique($entrylist);

		$db->free_result($getposts);
		unset($post);

		// Nothing left after the category check
		if (empty($validposts))
		{
			eval(standard_error(fetch_error(ADV_DYNA_PREFIX . '_no_valid_x', $vbphrase['posts'])));
		}

		$entrycats = array_unique($entrycats);

		$updateentries = false;

		switch ($vbulletin->GPC['action'])
		{
			// ##### Delete Post Conformation
			case 'delete':

				$formaction = 'moderate';
				$dovalue = 'inlinemoderation';
				$itemname = 'action';
				$itemid = 'dodelete';
				$additionalhidden = '<input name="type" type="hidden" value="post" />';
				$additionalhidden .= '<input type="hidden" name="url" value="' . $vbulletin->GPC['url'] . '" />';

				$titlephrase = $buttonphrase = construct_phrase($vbphrase['delete_x'], $vbphrase['posts']);

				// Delete note
				$entrycount = sizeof($entrylist);
				$postcount = sizeof($validposts);

				$deletenote = construct_phrase(
					$vbphrase['deleting_w_x_in_y_z'],
					$postcount,
					$vbphrase['posts'],
					$entrycount,
					$vbphrase['entries']
				);

				$show['physremove'] = $vba_dyna->check_cat_perms('canharddeleteposts');

				eval('$confirmphrase = "' . fetch_template(ADV_DYNA_PREFIX . '_moderate_deletebit') . '";');

				$show['check_confirm'] = false;

				$navbits[''] = $titlephrase;
				$navbits = construct_navbits($navbits);
				eval('$navbar = "' . fetch_template('navbar') . '";');

				eval('print_output("' . fetch_template(ADV_DYNA_PREFIX_UPPER . '_CONFORMATION') . '");');

			break;

			// ##### Do delete post
			case 'dodelete':

				$vbulletin->input->clean_array_gpc('p', array(
					'confirmaction' => TYPE_INT,
					'reason' => TYPE_NOHTML
				));

				$postid_str = implode(', ', $validposts);

				$updatereason = 'update';

				switch ($vbulletin->GPC['confirmaction'])
				{
					// Physically remove
					case 2:

						if ($vba_dyna->check_cat_perms('canharddeleteposts'))
						{
							$db->query_write("DELETE FROM " . ADV_DYNA_TABLE_PREFIX . "posts WHERE postid IN($postid_str)");
							$updatereason = 'delete';
						}

					break;

					// Soft Delete
					case 1:

						$db->query_write("UPDATE " . ADV_DYNA_TABLE_PREFIX . "posts SET visible = 2 WHERE postid IN($postid_str)");

					break;

					default:

						eval(standard_error(fetch_error(ADV_DYNA_PREFIX . '_nodelete', $vbphrase['message'])));
				}

				// ##### Reason
				if ($updatereason == 'delete')
				{
					$db->query_write("
						DELETE FROM " . ADV_DYNA_TABLE_PREFIX . "deletionlog
						WHERE deletedid IN($postid_str)
							AND type = 'post'
					");
				}
				else
				{
					$insertdellog = '
						REPLACE INTO ' . ADV_DYNA_TABLE_PREFIX . 'deletionlog
							(deletedid, type, userid, username, dateline, reason)
						VALUES
					';

					foreach ($validposts AS $postid)
					{
						$insertdellog .= '(
							' . $postid . ',
							\'post\',
							' . $vbulletin->userinfo['userid'] . ',
							\'' . $db->escape_string($vbulletin->userinfo['username']) . '\',
							' . TIMENOW . ',
							\'' . $db->escape_string($vbulletin->GPC['reason']) . '\'
						), ';
					}

					$db->query_write(substr($insertdellog, 0, (strlen($insertdellog) - 2)));
				}

				$updateentries = true;

			break;

			// ##### Restore Posts
			case 'restore':

				$postid_str = implode(', ', $validposts);

				$db->query_write("
					DELETE FROM " . ADV_DYNA_TABLE_PREFIX . "deletionlog
					WHERE deletedid IN($postid_str)
						AND type = 'post'
				");

				$db->query_write("
					UPDATE " . ADV_DYNA_TABLE_PREFIX . "posts SET
						visible = 1
					WHERE postid IN($postid_str)
				");

				$updateentries = true;

			break;

			// ##### Unapprove Posts
			case 'unapprove':

				$db->query_write("UPDATE " . ADV_DYNA_TABLE_PREFIX . "posts SET visible = 0 WHERE postid IN(" . implode(',', $validposts) . ")");

			break;

			// ##### Do Copy / Move Posts
			case 'domove':

				$vbulletin->input->clean_array_gpc('p', array(
					'entryurl' => TYPE_STR,
					'subaction' => TYPE_NOHTML
				));

				if ($vba_options['dyna_spiderurls'])
				{
					$newentryid = intval(substr(strrchr($vbulletin->GPC['entryurl'], '-'), 1));
				}
				else
				{
					preg_match('/(e=)([0-9]+)/', $vbulletin->GPC['entryurl'], $matches);
					$newentryid = intval($matches[2]);
				}

				if (!$newentryid)
				{
					eval(standard_error(fetch_error(ADV_DYNA_PREFIX . '_invalid_url')));
				}

				$newentry = $vbulletin->db->query_first("SELECT catid FROM " . ADV_DYNA_TABLE_PREFIX . "entries WHERE entryid = $newentryid");

				if (!is_category_mod($newentry['catid']))
				{
					print_no_permission();
				}

				// Moving
				if ($vbulletin->GPC['subaction'] == 'move')
				{
					$db->query_write("
						UPDATE " . ADV_DYNA_TABLE_PREFIX . "posts
						SET entryid = $newentryid
						WHERE postid IN(" . implode(',', $validposts) . ")
					");
				}
				// Copying
				else
				{
					$insertposts = '';
					$getposts = $db->query_read("
						SELECT *
						FROM " . ADV_DYNA_TABLE_PREFIX . "posts
						WHERE postid IN(" . implode(',', $validposts) . ")
					");
					while ($posts = $db->fetch_array($getposts))
					{
						unset($posts['postid']);
						if (!$insertposts)
						{
							$insertposts = 'INSERT INTO ' . ADV_DYNA_TABLE_PREFIX . 'posts (' . implode(', ', array_keys($posts)) . ') VALUES ';
						}

						$insertposts .= '(';

						$posts['entryid'] = $newentryid;

						foreach ($posts AS $postcol => $postval)
						{
							$insertposts .= '\'' . $db->escape_string($postval) . '\', ';
						}

						$insertposts = substr($insertposts, 0, (strlen($insertposts) - 2)) . '), ';
					}

					$db->free_result($getposts);
					unset($posts);

					$db->query_write(substr($insertposts, 0, (strlen($insertposts) - 2)));
				}

			break;

			// ##### Copy / Move Posts
			case 'move':

				$movecount['posts'] = sizeof($validposts);
				$movecount['entries'] = sizeof($entrycats);

				$formaction = 'moderate';
				$dovalue = 'inlinemoderation';
				$itemname = 'action';
				$itemid = 'domove';
				$additionalhidden = '<input name="type" type="hidden" value="post" />';
				$additionalhidden .= '<input type="hidden" name="url" value="' . $vbulletin->GPC['url'] . '" />';

				$titlephrase = $buttonphrase = construct_phrase($vbphrase['move_x'], $vbphrase['posts']);

				$navbits[''] = $titlephrase;
				$navbits = construct_navbits($navbits);
				eval('$navbar = "' . fetch_template('navbar') . '";');

				eval('$confirmphrase = "' . fetch_template(ADV_DYNA_PREFIX . '_moderate_move_posts') . '";');
				eval('print_output("' . fetch_template(ADV_DYNA_PREFIX_UPPER . '_CONFORMATION') . '");');

			break;

			// ##### View Selected Posts
			case 'viewselected':

				// Per page stuff
				if ($vbulletin->userinfo['maxposts'] != -1)
				{
					$perpage = $vbulletin->userinfo['maxposts'];
				}

				if (!intval($perpage))
				{
					$perpage = $vba_options['dyna_repliesperpage'];
				}

				$perpage = intval($perpage);

				$wherequery = 'postid IN(' . implode(',', $validposts) . ') AND posts.visible = 1 ' . $catquery;
				$replypagedata = fetch_page_data(ADV_DYNA_PREFIX . '_posts AS posts', array($wherequery), '', $perpage);

				// We have replies
				if ($replypagedata['count'])
				{
					require_once(DIR . '/includes/vba_dyna_functions_posting.php');
					require_once(DIR . '/includes/class_postbit.php');

					// Load BBcode parser
					require_once(DIR . '/includes/class_bbcode.php');
					$bbcode_parser =& new vB_BbCodeParser($vbulletin, fetch_tag_list());

					$postcount = ($replypagedata['pagenumber'] - 1) * $perpage;

					$show['postcount'] = true;
					$show['reputationlink'] = false;
					$show['inlinemod'] = true;

					replace_page_nav_links();

					$pagenav = construct_page_nav($replypagedata['pagenumber'], $perpage, $replypagedata['count'], $entry['url'], construct_adv_sort_url(array('page')));

					postbit_template_replace();

					$queryfields = '';
					$queryjoin = '';

					fetch_post_query_fields();

					// kill postid here since it's used in the postbit template
					unset($postid);

					$posts = $db->query("
							SELECT $queryfields
							FROM " . ADV_DYNA_TABLE_PREFIX . "posts AS posts
							LEFT JOIN " . ADV_DYNA_TABLE_PREFIX . "entries AS entry ON (posts.entryid = entry.entryid)
							$queryjoin
							WHERE $wherequery
							ORDER BY posts.dateline
							LIMIT " . ($replypagedata['minlimit'] - 1) . ", $replypagedata[perpage]
					");
					while ($post = $db->fetch_array($posts))
					{
						$postbit .= fetch_dyna_postbit($post);
					}

					$db->free_result($posts);
					unset($post);
				}

				$navbits[''] = construct_phrase($vbphrase['moderate_x'], $vbphrase['posts']);
				$navbits = construct_navbits($navbits);
				eval('$navbar = "' . fetch_template('navbar') . '";');

				eval('print_output("' . fetch_template(ADV_DYNA_PREFIX_UPPER . '_MODERATE_VIEWPOSTS') . '");');

			break;

			default:

				$hookaction = false;
				// When using this hook, be sure to set $hookaction = true; to prevent the error below
				($hook = vBulletinHook::fetch_hook('vba_dyna_moderate_inlinemod_posts_actions')) ? eval($hook) : false;

				if (!$hookaction)
				{
					eval(standard_error(fetch_error('invalid_action_specified')));
				}

		}

		// Update entries post info
		if ($updateentries AND !empty($entrylist))
		{
			foreach ($entrylist AS $updateid)
			{
				$pcount = $db->query_first("
					SELECT COUNT(*) AS count
					FROM " . ADV_DYNA_TABLE_PREFIX . "posts
					WHERE entryid = $updateid
						AND visible = 1
				");

				$lasts = $db->query_first("
					SELECT postid, dateline, userid, username
					FROM " . ADV_DYNA_TABLE_PREFIX . "posts
					WHERE entryid = $updateid
						AND visible = 1
					ORDER BY dateline DESC
				");

				$db->query_write("
					UPDATE " . ADV_DYNA_TABLE_PREFIX . "entries SET
						posts = '$pcount[count]',
						lastpostid = '$lasts[postid]',
						lastpostdateline = '$lasts[dateline]',
						lastpostuserid = '$lasts[userid]',
						lastpostusername = '" . $db->escape_string($lasts['username']) . "'
					WHERE entryid = $updateid
				");
			}
		}
	}
	// ####################
	// ##### Entries
	else
	{
		$entryids = process_cookie_list();

		$redirphrase = $vbphrase['entries_lwr'];

		$validentries = array();
		$entrycats = array();
		$entryusercats = array();
		$getentries = $db->query_read("
			SELECT entryid, catid, userid FROM " . ADV_DYNA_TABLE_PREFIX . "entries
			WHERE entryid IN(" . implode(',', $entryids) . ")
				$catquery
		");
		while ($entries = $db->fetch_array($getentries))
		{
			$validentries[] = $entries['entryid'];

			// We'll use an array for each at least for now for the sake of simplicity
			$entrycats[] = $entries['catid'];
			$entryusercats[$entries['catid']][] = $entries['userid'];
		}

		$db->free_result($getentries);
		unset($entries);

		$entrycats = array_unique($entrycats);

		// Nothing left after the category check
		if (empty($validentries))
		{
			eval(standard_error(fetch_error(ADV_DYNA_PREFIX . '_no_valid_x', $vbphrase['entries_lwr'])));
		}

		switch ($vbulletin->GPC['action'])
		{
			// ##### Delete Entry Conformation
			case 'delete':

				$formaction = 'moderate';
				$dovalue = 'inlinemoderation';
				$itemname = 'action';
				$itemid = 'dodelete';
				$additionalhidden = '<input name="type" type="hidden" value="entries" />';
				$additionalhidden .= '<input type="hidden" name="url" value="' . $vbulletin->GPC['url'] . '" />';

				$titlephrase = $buttonphrase = construct_phrase($vbphrase['delete_x'], $vbphrase['entries']);

				// Delete note
				$entrycount = sizeof($validentries);
				$catcount = sizeof($entrycats);

				$deletenote = construct_phrase(
					$vbphrase['deleting_w_x_in_y_z'],
					$entrycount,
					$vbphrase['entries'],
					$catcount,
					$vbphrase['categories']
				);

				$show['physremove'] = $vba_dyna->check_cat_perms('canharddelete');

				eval('$confirmphrase = "' . fetch_template(ADV_DYNA_PREFIX . '_moderate_deletebit') . '";');

				$show['check_confirm'] = false;

				$navbits[''] = $titlephrase;
				$navbits = construct_navbits($navbits);
				eval('$navbar = "' . fetch_template('navbar') . '";');

				eval('print_output("' . fetch_template(ADV_DYNA_PREFIX_UPPER . '_CONFORMATION') . '");');
			break;


			// ##### Do Delete
			case 'dodelete':

				$vbulletin->input->clean_array_gpc('p', array(
					'confirmaction' => TYPE_INT,
					'reason' => TYPE_NOHTML
				));

				$entryid_str = implode(',', $validentries);

				$updatereason = 'update';

				switch ($vbulletin->GPC['confirmaction'])
				{
					// Physically remove
					case 2:

						if ($vba_dyna->check_cat_perms('canharddelete'))
						{
							delete_entries($validentries);
							$updatereason = 'delete';
						}

					break;

					// Soft delete
					case 1:

						$db->query_write("
							UPDATE " . ADV_DYNA_TABLE_PREFIX . "entries SET
								valid = 2
							WHERE entryid IN(" . $entryid_str . ")
						");

					break;

					default:

						eval(standard_error(fetch_error(ADV_DYNA_PREFIX . '_nodelete', $vbphrase['entry'])));
				}

				// ##### Reason
				if ($updatereason == 'delete')
				{
					$db->query_write("
						DELETE FROM " . ADV_DYNA_TABLE_PREFIX . "deletionlog
						WHERE deletedid IN($entryid_str)
							AND type = 'entry'
					");
				}
				else
				{
					$insertdellog = '
						REPLACE INTO ' . ADV_DYNA_TABLE_PREFIX . 'deletionlog
							(deletedid, type, userid, username, dateline, reason)
						VALUES
					';

					foreach ($validentries AS $entid)
					{
						$insertdellog .= '(
							' . $entid . ',
							\'entry\',
							' . $vbulletin->userinfo['userid'] . ',
							\'' . $db->escape_string($vbulletin->userinfo['username']) . '\',
							' . TIMENOW . ',
							\'' . $db->escape_string($vbulletin->GPC['reason']) . '\'
						), ';
					}

					$db->query_write(substr($insertdellog, 0, (strlen($insertdellog) - 2)));
				}

			break;

			// ##### Restore
			case 'restore':

				$entryid_str = implode(',', $validentries);

				$db->query_write("
					DELETE FROM " . ADV_DYNA_TABLE_PREFIX . "deletionlog
					WHERE deletedid IN($entryid_str)
						AND type = 'entry'
				");

				$db->query_write("
					UPDATE " . ADV_DYNA_TABLE_PREFIX . "entries SET
						valid = 1
					WHERE entryid IN($entryid_str)
				");

			break;

			// ##### Open / Close
			case 'open':
			case 'close':

				$db->query_write("
					UPDATE " . ADV_DYNA_TABLE_PREFIX . "entries
					SET open = " . iif($vbulletin->GPC['action'] == 'open', 1, 0) . "
					WHERE entryid IN (" . implode(',', $validentries) . ")
				");

			break;

			// ##### Stick / Unstick
			case 'stick':
			case 'unstick':

				$db->query_write("
					UPDATE " . ADV_DYNA_TABLE_PREFIX . "entries
					SET sticky = " . iif($vbulletin->GPC['action'] == 'stick', 1, 0) . "
					WHERE entryid IN (" . implode(',', $validentries) . ")
				");
			break;

			// ##### Feature
			case 'feature':

				if (!is_array($vbulletin->adv_dyna_featur))
				{
					$vbulletin->adv_dyna_featur = array();
				}

				$vbulletin->adv_dyna_featur = array_unique(array_merge($validentries, $vbulletin->adv_dyna_featur));

				build_datastore(ADV_DYNA_PREFIX . '_featur', serialize($vbulletin->adv_dyna_featur), 1);

			break;

			// ##### Un-Feature
			case 'unfeature':

				if (!is_array($vbulletin->adv_dyna_featur))
				{
					$vbulletin->adv_dyna_featur = array();
				}

				$vbulletin->adv_dyna_featur = array_diff($validentries, $vbulletin->adv_dyna_featur);

				build_datastore(ADV_DYNA_PREFIX . '_featur', serialize($vbulletin->adv_dyna_featur), 1);

			break;

			// ##### Unapprove
			case 'unapprove':

				$db->query_write("
					UPDATE " . ADV_DYNA_TABLE_PREFIX . "entries
					SET valid = 0
					WHERE entryid IN (" . implode(',', $validentries) . ")
				");

			break;

			// ##### Do Move Entries
			case 'domove':

				$newcatid = $vbulletin->input->clean_gpc('p', 'newcatid', TYPE_INT);

				if (!is_category_mod($newcatid))
				{
					print_no_permission();
				}

				$entrycats[] = $newcatid;

				$db->query_write("
					UPDATE " . ADV_DYNA_TABLE_PREFIX . "entries
					SET catid = $newcatid
					WHERE entryid IN (" . implode(',', $validentries) . ")
				");

			break;

			// ##### Move Entries
			case 'move':

				$allowedparents = array();

				if (!empty($limitcats) AND !empty($vbulletin->adv_dyna_cats))
				{
					foreach ($vbulletin->adv_dyna_cats AS $cats)
					{
						if (in_array($cats['catid'], $limitcats))
						{
							$plist = explode(',', $cats['parentlist']);
							if (!empty($plist))
							{
								foreach ($plist AS $parentid)
								{
									if ($vbulletin->adv_dyna_cats[$parentid]['valid'])
									{
										$allowedparents[] = $parentid;
									}
								}
							}
						}
					}
				}

				$allowedparents = array_unique($allowedparents);

				$catmoveselect = print_cat_select(0, 'moderation');

				$movecount['entries'] = sizeof($validentries);
				$movecount['cats'] = sizeof($entrycats);

				$formaction = 'moderate';
				$dovalue = 'inlinemoderation';
				$itemname = 'action';
				$itemid = 'domove';
				$additionalhidden = '<input name="type" type="hidden" value="entries" />';
				$additionalhidden .= '<input type="hidden" name="url" value="' . $vbulletin->GPC['url'] . '" />';

				$titlephrase = $buttonphrase = construct_phrase($vbphrase['move_x'], $vbphrase['entries']);

				$navbits[''] = $titlephrase;
				$navbits = construct_navbits($navbits);
				eval('$navbar = "' . fetch_template('navbar') . '";');

				eval('$confirmphrase = "' . fetch_template(ADV_DYNA_PREFIX . '_moderate_move_entries') . '";');
				eval('print_output("' . fetch_template(ADV_DYNA_PREFIX_UPPER . '_CONFORMATION') . '");');

			break;

			// ##### View Selected
			case 'viewselected':

				$vbulletin->url = 'browsecategory.php?' . $vbulletin->session->vars['sessionurl'] . 'do=viewmodselected';
				eval(print_standard_redirect('search'));

			break;

			// ##### ?
			default:

				$hookaction = false;
				// When using this hook, be sure to set $hookaction = true; to prevent the error below
				($hook = vBulletinHook::fetch_hook('vba_dyna_moderate_inlinemod_entries_actions')) ? eval($hook) : false;

				if (!$hookaction)
				{
					eval(standard_error(fetch_error('invalid_action_specified')));
				}

		}
	}

	// Update the category counts
	if (!empty($entrycats))
	{
		require_once(DIR . '/includes/vba_dyna_functions_savecat.php');

		foreach ($entrycats AS $updatecat)
		{
			update_count($updatecat);
		}
	}

	if (!empty($entryusercats))
	{
		foreach ($entryusercats AS $usercatid => $catusers)
		{
			if (!empty($catusers))
			{
				foreach ($catusers AS $catuserid)
				{
					$lastentry = $db->query_first("
						SELECT entryid, title, dateline, userid, username
						FROM " . ADV_DYNA_TABLE_PREFIX . "entries
						WHERE catid = $usercatid AND userid = $catuserid
							AND valid = 1
							AND draft = 0
							AND private = 0
						ORDER BY dateline DESC
					");

					if ($lastentry['entryid'])
					{
						$entrycount = $db->query_first("
							SELECT COUNT(*) AS count
							FROM " . ADV_DYNA_TABLE_PREFIX . "entries
							WHERE catid = $usercatid AND userid = $catuserid
						");

						$postcount = $db->query_first("
							SELECT COUNT(*) AS count
							FROM " . ADV_DYNA_TABLE_PREFIX . "posts AS post
							LEFT JOIN " . ADV_DYNA_TABLE_PREFIX . "entries AS entry ON (post.entryid = entry.entryid)
							WHERE entry.catid = $usercatid
								AND entry.userid = $catuserid
								AND entry.valid = 1
								AND entry.draft = 0
								AND entry.private = 0
								AND post.visible = 1
						");

						if ($postcount['count'])
						{
							$lastpost = $db->query_read("
								SELECT postid, post.entryid, post.dateline, post.userid, post.username, entry.title AS entrytitle
								FROM " . ADV_DYNA_TABLE_PREFIX . "posts AS post
								LEFT JOIN " . ADV_DYNA_TABLE_PREFIX . "entries AS entry ON (post.entryid = entry.entryid)
								WHERE entry.catid = $usercatid
									AND entry.userid = $catuserid
									AND entry.valid = 1
									AND entry.draft = 0
									AND entry.private = 0
									AND post.visible = 1
								ORDER BY post.dateline DESC
							");
						}

						$db->query_write("
							UPDATE " . ADV_DYNA_TABLE_PREFIX . "memberscats SET
								entrycount = '$entrycount[count]',
								postcount = '$postcount[count]',
								lastentryid = '$lastentry[entryid]',
								lastentrytitle = '" . $db->escape_string($lastentry['title']) . "',
								lastentryuserid = '$lastentry[userid]',
								lastentryusername = '" . $db->escape_string($lastentry['username']) . "',
								lastentrydateline = '$lastentry[dateline]',
								lastpostid = '$lastpost[postid]',
								lastpostentrytitle = '" . $db->escape_string($lastpost['entrytitle']) . "',
								lastpostuserid = '$lastpost[userid]',
								lastpostusername = '" . $db->escape_string($lastpost['username']) . "',
								lastpostdateline = '$lastpost[dateline]'
							WHERE catid = $usercatid
								AND userid = $catuserid
						");

					}
					// No entries, so delete the user cat
					else
					{
						$db->query_write("DELETE FROM " . ADV_DYNA_TABLE_PREFIX . "memberscats WHERE catid = $usercatid AND userid = $catuserid");
					}
				}
			}
		}
	}

	($hook = vBulletinHook::fetch_hook('vba_dyna_moderate_inlinemod_end')) ? eval($hook) : false;

	setcookie($cookiename, '', (TIMENOW - 3600), '/');

	$vbulletin->url = $vbulletin->GPC['url'];
	eval(print_standard_redirect(ADV_DYNA_PREFIX . '_inlinemod_redirect'));

}

?>