<?php
// ++=========================================================================++
// || vBadvanced Dynamics v1.0.0 (vB 3.6 - vB 3.7)
// ||  2003-2007 vBadvanced.com - All Rights Reserved
// || This file may not be redistributed in whole or significant part.
// || http://vbadvanced.com
// ++ ========================================================================++

error_reporting(E_ALL & ~E_NOTICE);
define('GET_EDIT_TEMPLATES', true);
define('THIS_SCRIPT', 'dyna_newreply');

$specialtemplates = array(
	'smiliecache',
	'bbcodecache',
	'iconcache'
);

$globaltemplates = array(
	'ADV_DYNA_REPLY',
	'newreply_reviewbit',
	'bbcode_code',
	'bbcode_html',
	'bbcode_php',
	'bbcode_quote',
	'humanverify',
	'imagereg',
	'im_aim',
	'im_icq',
	'im_msn',
	'im_yahoo',
	'postbit',
	'postbit_buttons',
	'postbit_ip',
	'postbit_onlinestatus',
	'postbit_reputation',
	'postbit_wrapper'
);

$phrasegroups = array(
	'adv_dyna_add_entpost',
	'posting',
	'threadmanage'
);

require_once('./dyna_global.php');
require_once(DIR . '/includes/functions_newpost.php');

if (!$_REQUEST['do'])
{
	$_REQUEST['do'] = 'newreply';
}

$haderrors = false;

($hook = vBulletinHook::fetch_hook('vba_dyna_newreply_start')) ? eval($hook) : false;

// ########################## Do Reply to Entry #############################
if ($_POST['do'] == 'postreply' OR $_POST['do'] == 'doedit')
{
	if (!$vba_options['dyna_allowreplies'])
	{
		print_no_permission();
	}

	$entryid = $vbulletin->input->clean_gpc('p', 'entryid', TYPE_INT);
	$catid = $vbulletin->input->clean_gpc('p', 'catid', TYPE_INT);
	$vote = $vbulletin->input->clean_gpc('p', 'vote', TYPE_INT);
	$wysiwyg = $vbulletin->input->clean_gpc('p', 'wysiwyg', TYPE_BOOL);
	$message = $vbulletin->input->clean_gpc('p', 'message', TYPE_STR);
	$ajax = $vbulletin->input->clean_gpc('p', 'ajax', TYPE_BOOL);
	$ajax_lastpost = $vbulletin->input->clean_gpc('p', 'ajax_lastpost', TYPE_INT);
	$iconid = $vbulletin->input->clean_gpc('p', 'iconid', TYPE_INT);
	$signature = $vbulletin->input->clean_gpc('p', 'signature', TYPE_INT);
	$imagehash = $vbulletin->input->clean_gpc('p', 'imagehash', TYPE_STR);
	$imagestamp = $vbulletin->input->clean_gpc('p', 'imagestamp', TYPE_STR);

	$vbulletin->input->clean_array_gpc('p', array(
		'customdate' => TYPE_ARRAY,
		'favorite' => TYPE_INT,
		'fromquickreply' => TYPE_INT,
		'subscribe' => TYPE_INT
	));

	require_once(DIR . '/includes/vba_dyna_functions_posting.php');
	require_once(DIR . '/includes/functions_misc.php');

	$vba_dyna->load_entry();
	$entry =& $vba_dyna->_entry;

	$catid = $entry['catid'];

	// Edit post permissions
	if ($_POST['do'] == 'doedit')
	{
		if (!$vbulletin->userinfo['userid'])
		{
			print_no_permission();
		}

		$oldpost = $db->query_first("SELECT userid, dateline FROM " . ADV_DYNA_TABLE_PREFIX . "posts WHERE postid = $epostid");

		if (!is_category_mod($entry['catid']))
		{
			if (($vbulletin->userinfo['userid'] != $oldpost['userid'] AND !$vba_dyna->check_cat_perms('caneditothersposts')) OR ($vbulletin->userinfo['userid'] == $oldpost['userid'] AND !$vba_dyna->check_cat_perms('caneditposts')))
			{
				print_no_permission();
			}

			// Check time limit
			if ($vba_options['dyna_editpost_timelimit'] AND (TIMENOW - ($vba_options['dyna_editpost_timelimit'] * 60)) > $oldpost['dateline'])
			{
				eval(standard_error(fetch_error('edittimelimit', $vba_options['dyna_editpost_timelimit'], $vbulletin->options['contactuslink'])));
			}
		}

		($hook = vBulletinHook::fetch_hook('vba_dyna_newreply_doedit')) ? eval($hook) : false;

	}
	// New reply permissions
	else
	{
		if (($entry['userid'] == $vbulletin->userinfo['userid'] AND !$vba_dyna->check_cat_perms('canreply'))
		 OR ($entry['userid'] != $vbulletin->userinfo['userid'] AND !$vba_dyna->check_cat_perms('canreplyothers'))
		 OR !cat_user_opt('allow_reply')
		)
		{
			print_no_permission();
		}
		if (!cat_opt('open_for_posts'))
		{
			eval(standard_error(fetch_error(ADV_DYNA_PREFIX . '_not_open_for_x', $vbphrase['posts'])));
		}
		// Check to see if it's open
		if (!is_category_mod($entry['catid']) AND !$entry['open'])
		{
			print_no_permission();
		}

		($hook = vBulletinHook::fetch_hook('vba_dyna_newreply_doreply')) ? eval($hook) : false;
	}

	$post['title'] = htmlspecialchars(fetch_censored_text($_POST['title']));
	$post['username'] = $_POST['username'];

	// WYSIWYG
	if ($wysiwyg)
	{
		require_once(DIR . '/includes/functions_wysiwyg.php');
		$post['message'] = convert_wysiwyg_html_to_bbcode($message);
	}

	// Normal editor
	else
	{
		$post['message'] = $message;
	}

	// Insert title if necessary
	if (!$post['title'] AND $vbulletin->GPC['fromquickreply'] AND $vba_options['dyna_quotetitle'])
	{
		$vbulletin->options['quotetitle'] = 1;
		$post['title'] = fetch_quote_title($post['title'], $entry['title']);
	}

	// Smilies
	$post['disablesmilies'] = $_POST['disablesmilies'];

	$post['enablesmilies'] = 0;
	if (!$post['disablesmilies'])
	{
		$post['enablesmilies'] = 1;
	}

	// ##### Check for errors
	$errors = array();

	// Image verification
	$imagereg = '';
	$imageerror = check_human_verify('reply');
	
	if ($imageerror)
	{
		eval('$errors[] = "' . $imageerror . '";');
	}

	$postlength = strlen($post['message']);

	// Check message length
	if (!$post['message'] AND $vbulletin->options['postminchars'])
	{
		eval('$errors[] = "' . fetch_error('nosubject') . '";');
	}

	if ($vbulletin->options['postminchars'] AND $postlength < $vbulletin->options['postminchars'])
	{
		eval('$errors[] = "' . fetch_error('tooshort', vb_number_format($postlength), vb_number_format($vbulletin->options['postminchars'])) . '";');
	}
	else if ($vbulletin->options['postmaxchars'] AND $postlength > $vbulletin->options['postmaxchars'])
	{
		eval('$errors[] = "' . fetch_error('toolong', vb_number_format($postlength), vb_number_format($vbulletin->options['postmaxchars'])) . '";');
	}

	// Guest username check
	if (!$vbulletin->userinfo['userid'])
	{
		if (!$post['username'])
		{
			eval('$errors[] = "' . fetch_error('nousername') . '";');
		}
		else if (strlen($post['username']) < $vbulletin->options['minuserlength'])
		{
			eval('$errors[] = "' . fetch_error('usernametooshort', $vbulletin->options['minuserlength']) . '";');
		}
		else if (strlen($post['username']) > $vbulletin->options['maxuserlength'])
		{
			eval('$errors[] = "' . fetch_error('usernametoolong', $vbulletin->options['maxuserlength']) . '";');
		}
		else if ($dupecheck = $db->query_first("SELECT userid FROM " . TABLE_PREFIX . "user WHERE username = '" . $db->escape_string(htmlspecialchars($post['username'])) . "'"))
		{
			eval('$errors[] = "' . fetch_error('usernametaken', addslashes(htmlspecialchars($post['username'])), $vbulletin->session->vars['sessionurl']) . '";');
		}
	}

	$post['message'] = fetch_censored_text($post['message']);

	if ($_POST['parseurl'])
	{
		$post['message'] = convert_url_to_bbcode($post['message']);
	}

	// Duplicate post / flood check
	if ($_REQUEST['do'] == 'postreply' AND $vbulletin->userinfo['userid'] AND !($permissions['adminpermissions'] & $vbulletin->bf_ugp_adminpermissions['cancontrolpanel']) AND !can_moderate())
	{
		$lpost = $db->query_first("
			SELECT postid, title, pagetext, dateline
			FROM " . ADV_DYNA_TABLE_PREFIX . "posts
			WHERE userid = " . $vbulletin->userinfo['userid'] . "
			ORDER BY dateline DESC
		");

		// Have the same post, so just redirect the user
		if ($post['message'] == $lpost['pagetext'] AND $post['title'] == $lpost['title'])
		{
			$vbulletin->url = fetch_entry_url($entry, 'epostid=' . $lpost['postid'] . '#post' . $lpost['postid']);
			eval(print_standard_redirect('redirect_postthanks'));
		}

		// Have flooding, so display error
		if ($vbulletin->options['floodchecktime'] AND !$_POST['preview'] AND (TIMENOW - $lpost['dateline']) <= $vbulletin->options['floodchecktime'])
		{
			eval('$errors[] = "' . fetch_error('postfloodcheck', $vbulletin->options['floodchecktime'], ($vbulletin->options['floodchecktime'] - (TIMENOW - $lpost['dateline']))) . '";');
		}
	}

	// Max images
	if ($vbulletin->options['maximages'])
	{
		require_once(DIR . '/includes/class_bbcode_alt.php');
		$bbcode_parser_img =& new vB_BbCodeParser_ImgCheck($vbulletin, fetch_tag_list());

		$imagecount = fetch_character_count($bbcode_parser_img->parse($post['message'], 'nonforum', $post['enablesmilies'], true), '<img');
		if ($imagecount > $vbulletin->options['maximages'])
		{
			eval('$errors[] = "' . fetch_error('toomanyimages', $imagecount, $vbulletin->options['maximages']) . '";');
		}
	}

	// Format the dateline for am/pm
	if ($vbulletin->GPC['customdate']['meridiem'] == 'PM' AND $vbulletin->GPC['customdate']['hour'] != 12)
	{
		$vbulletin->GPC['customdate']['hour'] += 12;
	}
	else if ($vbulletin->GPC['customdate']['meridiem'] == 'AM' AND $vbulletin->GPC['customdate']['hour'] == 12)
	{
		$vbulletin->GPC['customdate']['hour'] = 0;
	}

	$post['dateline'] = ($_POST['do'] == 'doedit') ? $oldpost['dateline'] : TIMENOW;
	if ($vba_dyna->check_cat_perms('caneditpostdateline') AND !$vbulletin->GPC['fromquickreply'])
	{
		$post['dateline'] = fetch_custom_datestamp();
		check_custom_dateline_value();
	}

	// Errors!
	if (!empty($errors))
	{
		$postpreview = construct_errors($errors);
		construct_checkboxes($_POST);
		$newpost['message'] = htmlspecialchars($post['message']);

		$haderrors = true;
		if ($_POST['do'] == 'doedit')
		{
			$_REQUEST['do'] = 'editpost';
		}
		else
		{
			$_REQUEST['do'] = 'newreply';
		}
	}

	// Just previewing
	else if ($_POST['preview'])
	{
		if (!cat_opt('allow_post_smilies'))
		{
			$post['disablesmilies'] = 1;
		}

		$postpreview = process_post_preview($post);
		$newpost['message'] = $post['message'];
		construct_checkboxes($_POST);

		if ($_POST['do'] == 'doedit')
		{
			$_REQUEST['epostid'] = $epostid;
			$_REQUEST['do'] = 'editpost';
		}
		else
		{
			$_REQUEST['do'] = 'newreply';
		}
	}
	else
	{
		// Everything's good, so get ready to insert or update

		if ($ajax)
		{
			$post['message'] = convert_urlencoded_unicode($post['message']);
		}

		// New reply
		if ($_REQUEST['do'] == 'postreply')
		{
			if ($vba_dyna->check_cat_perms('moderateposts'))
			{
				$visible = 0;
			}
			else
			{
				$visible = 1;
			}

			// Insert the post
			$db->query_write("
				INSERT INTO " . ADV_DYNA_TABLE_PREFIX . "posts
					(entryid, title, pagetext, userid, username, dateline, ipaddress, iconid, allowsmilie, showsignature, visible)
				VALUES (
					$entryid,
					'" . $db->escape_string($post['title']) . "',
					'" . $db->escape_string($post['message']) . "',
					" . $vbulletin->userinfo['userid'] . ",
					'" . $db->escape_string($vbulletin->userinfo['username']) . "',
					" . $post['dateline'] . ",
					'" . $db->escape_string(IPADDRESS) . "',
					" . $iconid . ",
					$post[enablesmilies],
					$signature,
					$visible
			)");

			$newpostid = $db->insert_id();

			// Moderation email
			if (!$visible OR $vba_options['dyna_newentryemail_all'])
			{
				$catemail = $db->query_first("SELECT newpostemail, title FROM " . ADV_DYNA_TABLE_PREFIX . "categories WHERE catid = $entry[catid]");
				$sendmailto = explode(' ', $catemail['newpostemail']);

				if (!empty($sendmailto))
				{
					fetch_entry_url($entry, 'goto=lastpost&amp;epostid=' . $newpostid . '#post' . $newpostid);

					foreach ($sendmailto AS $email)
					{
						eval(fetch_email_phrases(ADV_DYNA_PREFIX . '_newpost', 0));
						vbmail(trim($email), $subject, $message);
					}
				}
			}

			if ($visible == 1)
			{
				send_subscribed_posts($entryid);

				// Update entry info
				$db->query_write("
					UPDATE " . ADV_DYNA_TABLE_PREFIX . "entries SET
						posts = posts+1,
						lastpostid = $newpostid,
						lastpostuserid = " . $vbulletin->userinfo['userid'] . ",
						lastpostusername = '" . $db->escape_string($vbulletin->userinfo['username']) . "',
						lastpostdateline = " . TIMENOW . "
					WHERE entryid = $entryid
				");

				$catupdatequery = "
					postcount = postcount+1,
					lastpostid = $newpostid,
					lastpostentryid = $entryid,
					lastpostentrytitle = '" . $db->escape_string($entry['title']) . "',
					lastpostuserid = " . $vbulletin->userinfo['userid'] . ",
					lastpostusername = '" . $db->escape_string($vbulletin->userinfo['username']) . "',
					lastpostdateline = " . TIMENOW . "
				";

				// Update category info
				if ($entry['catid'])
				{
					$vbulletin->db->query_write("
						UPDATE " . ADV_DYNA_TABLE_PREFIX . "categories SET
						$catupdatequery
						WHERE catid = $entry[catid]
					");
				}

				// Update members' cat info
				$vbulletin->db->query_write("
					UPDATE " . ADV_DYNA_TABLE_PREFIX . "memberscats SET
					$catupdatequery
					WHERE catid = $entry[catid] AND userid = $entry[userid]
				");

				// Update user post counts
				if ($vba_options['dyna_update_postcount'])
				{
					$db->query_write("UPDATE " . TABLE_PREFIX . "user SET posts = posts+1 WHERE userid = " . $vbulletin->userinfo['userid']);
				}
			}

			// Add vote if necessary
			if ($vote)
			{
				require_once(DIR . '/includes/vba_dyna_functions_saveentry.php');
				rate_entry($vote, $entryid, 'post');
			}

			// Add to favorites
			if ($vbulletin->GPC['favorite'])
			{
				$db->query_write("
					INSERT IGNORE INTO " . ADV_DYNA_TABLE_PREFIX . "favorites
						(userid, entryid, dateline)
					VALUES (
						'" . $vbulletin->userinfo['userid'] . "',
						'$entryid',
						" . TIMENOW . "
				)");
			}

			// Add subscription
			if ($vbulletin->GPC['subscribe'])
			{
				$db->query_write("
					INSERT IGNORE INTO " . ADV_DYNA_TABLE_PREFIX . "subscribeentry
						(userid, entryid)
					VALUES (
						" . $vbulletin->userinfo['userid'] . ",
						$entryid
				)");
			}
		}

		// Editing a post
		else
		{
			$db->query_write("
				UPDATE " . ADV_DYNA_TABLE_PREFIX . "posts SET
					title = '" . $db->escape_string($post['title']) . "',
					pagetext = '" . $db->escape_string($post['message']) . "',
					dateline = '" . $post['dateline'] . "',
					iconid = $iconid,
					allowsmilie = $post[enablesmilies],
					showsignature = $signature,
					visible = " . iif($vba_options['dyna_post_editmoderation'] AND $vba_dyna->check_cat_perms('moderateposts'), 0, 1) . "
				WHERE postid = $epostid
			");
			$newpostid = $epostid;
		}

		// ##### Ajax
		if ($ajax)
		{
			$queryfields = '';
			$queryjoin = '';

			fetch_post_query_fields();

			$pagedata = fetch_page_data(
				ADV_DYNA_PREFIX . '_posts',
				array("entryid = $entryid AND visible = 1"), '',
				iif($vbulletin->userinfo['maxposts'] != -1, $vbulletin->userinfo['maxposts'], $vba_options['dyna_repliesperpage'])
			);

			require_once(DIR . '/includes/class_xml.php');
			$xml = new vB_AJAX_XML_Builder($vbulletin, 'text/xml');

			require_once(DIR . '/includes/class_postbit.php');
			require_once(DIR . '/includes/functions_bigthree.php');

			require_once(DIR . '/includes/class_bbcode.php');
			$bbcode_parser =& new vB_BbCodeParser($vbulletin, fetch_tag_list());

			postbit_template_replace();

			$xml->add_group('postbits');

			$getposts = $db->query_read("
				SELECT $queryfields
				FROM " . ADV_DYNA_TABLE_PREFIX . "posts AS posts
				$queryjoin
				WHERE posts.entryid = $entryid AND (posts.visible = 1 OR posts.userid = " . $vbulletin->userinfo['userid'] . ") AND posts.dateline > $ajax_lastpost
				ORDER BY posts.dateline
			");
			$newpostcount = $db->num_rows($getposts);

			$show['postcount'] = true;
			$postcount = $pagedata['count'] - $newpostcount;

			if ($_REQUEST['kill_spacer'])
			{
				$spacer_open = '';
				$spacer_close = '';
			}

			while ($posts = $db->fetch_array($getposts))
			{
				$xml->add_tag('postbit', fetch_dyna_postbit($posts));
			}

			$db->free_result($getposts);
			unset($posts);

			$xml->add_tag('time', TIMENOW);
			$xml->close_group();
			$xml->print_xml();
		}

		$vbulletin->url = fetch_entry_url($entry, 'epostid=' . $newpostid . '#post' . $newpostid);

		if ($_POST['do'] == 'postreply')
		{
			eval(print_standard_redirect('redirect_postthanks'));
		}
		else
		{
			eval(print_standard_redirect('redirect_editthanks'));
		}
	}
}

// ########################## Reply to Entry #############################
if ($_REQUEST['do'] == 'newreply' OR $_REQUEST['do'] == 'editpost')
{
	if (!$vba_options['dyna_allowreplies'])
	{
		print_no_permission();
	}

	$vote = $vbulletin->input->clean_gpc('r', 'vote', TYPE_INT);
	$iconid = $vbulletin->input->clean_gpc('r', 'iconid', TYPE_INT);

	// Get post info for quoting or editing
	if ($epostid)
	{
		$post = $db->query_first("
			SELECT postid, entryid, title, pagetext, posts.dateline, posts.username, posts.userid, showsignature, allowsmilie, iconid, visible, reason
			FROM " . ADV_DYNA_TABLE_PREFIX . "posts AS posts
			LEFT JOIN " . ADV_DYNA_TABLE_PREFIX . "deletionlog AS dellog ON (posts.postid = dellog.deletedid AND type = 'post')
			WHERE postid = $epostid
		");
		$entryid = $post['entryid'];
	}

	$vba_dyna->load_entry();
	$entry =& $vba_dyna->_entry;

	$catid = $entry['catid'];

	$navbits = fetch_cat_navbits($entry['catid']);

	// Check permissions
	if ($_REQUEST['do'] == 'newreply')
	{
		if (($entry['userid'] == $vbulletin->userinfo['userid'] AND !$vba_dyna->check_cat_perms('canreply'))
			OR ($entry['userid'] != $vbulletin->userinfo['userid'] AND !$vba_dyna->check_cat_perms('canreplyothers'))
			OR !cat_user_opt('allow_reply')
			OR !cat_opt('open_for_posts')
		)
		{
			print_no_permission();
		}

		// Check to see if it's open
		if (!is_category_mod($entry['catid']) AND !$entry['open'])
		{
			print_no_permission();
		}

		$titlephrase = construct_phrase($vbphrase['reply_to_x'], $vbphrase['entry']);

		($hook = vBulletinHook::fetch_hook('vba_dyna_newreply_reply')) ? eval($hook) : false;

	}
	else
	{
		$show['editpost'] = true;

		if (!is_category_mod($catid))
		{
			if (!$vbulletin->userinfo['userid']
					OR ($vbulletin->userinfo['userid'] != $post['userid'] AND !$vba_dyna->check_cat_perms('caneditothersposts'))
					OR ($vbulletin->userinfo['userid'] == $post['userid'] AND !$vba_dyna->check_cat_perms('caneditposts'))
					OR !$post['visible']
			)
			{
				print_no_permission();
			}

			// Check time limit
			if ($vba_options['dyna_editpost_timelimit'] AND (TIMENOW - ($vba_options['dyna_editpost_timelimit'] * 60)) > $post['dateline'])
			{
				eval(standard_error(fetch_error('edittimelimit', $vba_options['dyna_editpost_timelimit'], $vbulletin->options['contactuslink'])));
			}
		}

		// Delete options
		if (($vba_dyna->check_cat_perms('candeleteposts') AND $vbulletin->userinfo['userid'] == $post['userid']) OR $vba_dyna->check_cat_perms('candeleteothersposts') OR is_category_mod($entry['catid']))
		{
			$show['deleteopt'] = true;
			$show['reason'] = true;
			$show['physremove'] = $vba_dyna->check_cat_perms('canharddeleteposts');
		}

		$titlephrase = $vbphrase['edit_post'];

		($hook = vBulletinHook::fetch_hook('vba_dyna_newreply_edit')) ? eval($hook) : false;
	}

	// Have a post with no errors, so start processing
	if (!empty($post) AND !$haderrors)
	{
		if ($_REQUEST['do'] == 'editpost')
		{
			if (!$_REQUEST['preview'])
			{
				$newpost['message'] = $post['pagetext'];
				if (!$post['allowsmilie'])
				{
					$checked['disablesmilies'] = 'checked="checked"';
				}

				$checked['signature'] = '';
				if ($post['showsignature'])
				{
					$checked['signature'] = 'checked="checked"';
				}
			}
		}
		// Go Advanced
		else if ($_REQUEST['preview'])
		{
			$pagetext = $post['pagetext'];
		}
		// Quoting post
		else if (!$_REQUEST['quickreply'])
		{
			$originalposter = fetch_quote_username($post['username']);
			$pagetext = trim(htmlspecialchars(strip_quotes($post['pagetext'])));
			eval('$newpost[\'message\'] = "' . fetch_template('newpost_quote', 1, 0) . '";');
		}
	}

	if (!isset($post['title']))
	{
		$post['title'] = $entry['title'];
	}

	// Construct voting box for preview
	$votesel = array();
	$votesel[$vote] = 'selected="selected"';

	$navbits = fetch_cat_navbits($vba_dyna->_cat['parentlist']);
	$navbits[$entry['url']] = $entry['title'];
	$navbits[''] = $titlephrase;

	if ($_REQUEST['do'] == 'editpost')
	{
		if (!isset($checked['parseurl']))
		{
			$checked['parseurl'] = 'checked="checked"';
		}

		if ($post['showsignature'])
		{
			$checked['signature'] = 'checked="checked"';
		}

		if (!$post['allowsmilie'])
		{
			$checked['disablesmilies'] = 'checked="checked"';
		}
	}
	else
	{
		// Get title if necessary
		$vbulletin->options['quotetitle'] = 0;
		if ($vba_options['dyna_quotetitle'])
		{
			$vbulletin->options['quotetitle'] = 1;
		}
		$post['title'] = fetch_quote_title($post['title'], $entry['title']);

		// Check URL box if isn't set
		if (!isset($checked['parseurl']))
		{
			$checked['parseurl'] = 'checked="checked"';
		}

		// Signature check box
		if (trim($vbulletin->userinfo['signature']) AND !$preview AND !isset($checked['signature']))
		{
			$checked['signature'] = 'checked="checked"';
		}

		// Favorites
		if ($vbulletin->GPC['favorite'])
		{
			$checked['favorite'] = 'checked="checked"';
		}

		// Subscribe
		if ($vbulletin->GPC['subscribe'])
		{
			$checked['subscribe'] = 'checked="checked"';
		}

		// Rating option
		if ($vba_options['dyna_allowrating'] AND $vba_dyna->check_cat_perms('canrate', $entry) AND cat_user_opt('allow_rating') AND cat_opt('allow_ratings', $entry['catid']))
		{
			$show['ratingopts'] = true;
		}

		// Get replies for topic review
		if ($vba_dyna->check_cat_perms('canviewreplies'))
		{
			$countposts = $db->query_first("SELECT COUNT(*) AS count FROM " . ADV_DYNA_TABLE_PREFIX . "posts WHERE entryid = $entryid");
		}

		if (cat_opt('allow_post_smilie'))
		{
			$query['getsmilie'] = true;
		}

		if ($countposts['count'])
		{
			$getposts = $db->query("
				SELECT pagetext, username, dateline " . iif($query['getsmilie'], ', allowsmilie') . "
				FROM " . ADV_DYNA_TABLE_PREFIX . "posts
				WHERE entryid = $entryid
					AND visible != 0
				ORDER BY dateline DESC
				LIMIT " . $vbulletin->options['maxposts']
			);
			if ($db->num_rows($getposts))
			{
				require_once(DIR . '/includes/class_bbcode.php');
				$bbcode_parser =& new vB_BbCodeParser($vbulletin, fetch_tag_list());
				$show['reviewbits'] = true;

				while ($posts = $db->fetch_array($getposts))
				{
					$posttime = vbdate($vbulletin->options['timeformat'], $posts['dateline']);
					$postdate = vbdate($vbulletin->options['dateformat'], $posts['dateline']);
					$username = $posts['username'];

					$reviewmessage = $bbcode_parser->do_parse(
						$posts['pagetext'],
						cat_opt('allow_post_html'),
						$posts['allowsmilie'],
						cat_opt('allow_post_bbcode'),
						cat_opt('allow_post_bbimgcode')
					);
					eval('$reviewbits .= "' . fetch_template('newreply_reviewbit') . '";');
				}
			}
			if ($countposts['count'] > $vbulletin->options['maxposts'])
			{
				$show['reviewmore'] = true;
			}
			$db->free_result($getposts);
			unset($posts);
		}
	}

	format_vb_text_editor();

	$iconbits = construct_icons($iconid, iif($vba_options['dyna_post_icons'] AND cat_opt('allow_post_icons'), 1, 0));

	$editsmilie = cat_opt('allow_post_smilies');

	if (!empty($post) AND !$post['allowsmilie'])
	{
		$editsmilie = 0;
	}

	$vbulletin->options['allowbbimagecode'] = (cat_opt('allow_post_bbimgcode') ? 1 : 0);

	// Editor & message area
	$editorid = construct_edit_toolbar(
		$newpost['message'],
		false,
		0,
		cat_opt('allow_post_smilies'),
		$editsmilie,
		0
	);

	$selectedicon['src'] = str_replace(
		$vbulletin->options['cleargifurl'],
		$vbulletin->options['bburl'] . '/' . $vbulletin->options['cleargifurl'],
		$selectedicon['src']
	);

	eval('$usernamecode = "' . fetch_template('newpost_usernamecode') . '";');

	$imagereg = fetch_human_verify('reply');

	// ##### Time Stamp
	$show['editdate'] = false;
	if ($vba_dyna->check_cat_perms('caneditpostdateline'))
	{
		$show['editdate'] = true;

		$datelinesel = construct_date_select('customdate', $post['dateline']);
	}

	$navbits = construct_navbits($navbits);
	eval('$navbar = "' . fetch_template('navbar') . '";');

	eval('print_output("' . fetch_template(ADV_DYNA_PREFIX_UPPER . '_REPLY') . '");');
}

// ##### Delete Post ##########################################################
if ($_POST['do'] == 'dodeletepost')
{
	$vbulletin->input->clean_array_gpc('p', array(
		'epostid' => TYPE_INT,
		'confirmaction' => TYPE_INT,
		'reason' => TYPE_NOHTML
	));

	$post = $db->query_first("
		SELECT postid, posts.userid, posts.entryid, posts.visible, entries.catid, entries.title
		FROM " . ADV_DYNA_TABLE_PREFIX . "posts AS posts
		INNER JOIN " . ADV_DYNA_TABLE_PREFIX . "entries AS entries ON (posts.entryid = entries.entryid)
		WHERE postid = " . $vbulletin->GPC['epostid']
	);

	if (!$post['postid'])
	{
		eval(standard_error(fetch_error('noid', $vbphrase['post'])));
	}

	$catid = $post['catid'];

	if (!is_category_mod($post['catid'])
		AND (!$vbulletin->userinfo['userid']
			OR ($post['userid'] != $vbulletin->userinfo['userid'] AND !$vba_dyna->check_cat_perms('candeleteothersposts', $post))
			OR (!$vba_dyna->check_cat_perms('candeleteposts', $post))
		)
	)
	{
		print_no_permission();
	}

	($hook = vBulletinHook::fetch_hook('vba_dyna_newreply_dodelete')) ? eval($hook) : false;

	$updatecounts = false;
	$updatereason = 'update';
	$plusminus = '-';

	switch ($vbulletin->GPC['confirmaction'])
	{
		// Restore
		case 3:

			if ($post['visible'] == 2)
			{
				$db->query_write("
					UPDATE " . ADV_DYNA_TABLE_PREFIX . "posts SET
						visible = 1
					WHERE postid = $post[postid]
				");

				$updatecounts = true;
				$updatereason = 'delete';
				$plusminus = '+';
			}

		break;

		// Physically remove
		case 2:

			if ($vba_dyna->check_cat_perms('canharddeleteposts'))
			{
				$db->query_write("DELETE FROM " . ADV_DYNA_TABLE_PREFIX . "posts WHERE postid = $post[postid]");

				if ($post['visible'] == 1)
				{
					$updatecounts = true;
				}

				$updatereason = 'delete';
			}

		break;

		// Soft Delete
		case 1:

			if ($post['visible'] != 2)
			{
				$db->query_write("UPDATE " . ADV_DYNA_TABLE_PREFIX . "posts SET visible = 2 WHERE postid = $post[postid]");
				$updatecounts = true;
			}

		break;

		default:

			eval(standard_error(fetch_error(ADV_DYNA_PREFIX . '_nodelete', $vbphrase['message'])));
	}

	// ##### Reason
	if ($updatereason == 'delete')
	{
		$db->query_write("
			DELETE FROM " . ADV_DYNA_TABLE_PREFIX . "deletionlog
			WHERE deletedid = $post[postid]
				AND type = 'post'
		");
	}
	else
	{
		$db->query_write("
			REPLACE INTO " . ADV_DYNA_TABLE_PREFIX . "deletionlog
				(deletedid, type, userid, username, dateline, reason)
			VALUES (
				$post[postid],
				'post',
				" . $vbulletin->userinfo['userid'] . ",
				'" . $db->escape_string($vbulletin->userinfo['username']) . "',
				" . TIMENOW . ",
				'" . $db->escape_string($vbulletin->GPC['reason']) . "'
			)
		");
	}

	// ##### Update Counters
	if ($updatecounts)
	{
		$lastpost = $db->query_first("
			SELECT postid, dateline, userid, username
			FROM " . ADV_DYNA_TABLE_PREFIX . "posts
			WHERE entryid = $post[entryid]
				AND visible = 1
			ORDER BY dateline DESC
		");

		$db->query_write("
			UPDATE " . ADV_DYNA_TABLE_PREFIX . "entries SET
				posts = posts $plusminus 1,
				lastpostid = '$lastpost[postid]',
				lastpostdateline = '$lastpost[dateline]',
				lastpostuserid = '$lastpost[userid]',
				lastpostusername = '" . $db->escape_string($lastpost['username']) . "'
			WHERE entryid = $post[entryid]
		");

		// Last cateogry post
		$catlast = $db->query_first("
			SELECT lastpostid
			FROM " . ADV_DYNA_TABLE_PREFIX . "categories
			WHERE catid = $post[catid]
		");

		$lastpostquery = '';
		if ($plusminus == '+'
			OR ($plusminus == '-' AND $catlast['lastpostid'] == $post['postid'])
		)
		{
			$lastcatpost = $db->query_first("
				SELECT post.postid, post.entryid, post.dateline, post.userid, post.username, entry.title
				FROM " . ADV_DYNA_TABLE_PREFIX . "posts AS post
				LEFT JOIN " . ADV_DYNA_TABLE_PREFIX . "entries AS entry ON (post.entryid = entry.entryid)
				WHERE entry.catid = $post[catid]
					AND visible = 1
					AND entry.valid = 1
					AND entry.private = 0
				ORDER BY post.dateline DESC
			");

			$lastpostquery = ",
				lastpostid = '$lastcatpost[postid]',
				lastpostentryid = '$lastcatpost[entryid]',
				lastpostuserid = '$lastcatpost[userid]',
				lastpostusername = '" . $db->escape_string($lastcatpost['username']) . "',
				lastpostentrytitle = '" . $db->escape_string($lastcatpost['title']) . "'
			";
		}

		$db->query_write("
			UPDATE " . ADV_DYNA_TABLE_PREFIX . "categories SET
				postcount = postcount $plusminus 1
				$lastpostquery
			WHERE catid = $post[catid]
		");
		
		if ($vba_options['dyna_update_postcount'])
		{
			$db->query_write("UPDATE " . TABLE_PREFIX . "user SET posts = posts-1 WHERE userid = $post[userid]");
		}

	}

	fetch_entry_url($post);

	$vbulletin->url = $post['url'];
	eval(print_standard_redirect(ADV_DYNA_PREFIX . '_posts_deleted'));
}

// ############################### Do Rate Entry ###############################
if ($_POST['do'] == 'rate')
{
	$vote = $vbulletin->input->clean_gpc('p', 'vote', TYPE_INT);
	$entryid = $vbulletin->input->clean_gpc('p', 'entryid', TYPE_INT);
	$redirpage = $vbulletin->input->clean_gpc('p', 'redirpage', TYPE_NOHTML);

	require_once(DIR . '/includes/vba_dyna_functions_saveentry.php');
	rate_entry($vote, $entryid, $redirpage);
}

?>