<?php
// ++=========================================================================++
// || vBadvanced Dynamics v1.0.0 (vB 3.6 - vB 3.7)
// ||  2003-2007 vBadvanced.com - All Rights Reserved
// || This file may not be redistributed in whole or significant part.
// || http://vbadvanced.com
// ++ ========================================================================++

error_reporting(E_ALL & ~E_NOTICE);
define('THIS_SCRIPT', 'dyna_search');

$globaltemplates = array();

$specialtemplates = array(
	'adv_dyna_cfield',
	'adv_dyna_modpos',
	'adv_dyna_module'
);

$actiontemplates = array(
	'search' => array(
		'ADV_DYNA_SEARCH',
		'adv_dyna_search_custombits',
		'adv_dyna_search_custombits_selection',
		'adv_dyna_search_options',
		'humanverify',
		'imagereg'
	)
);

$actiontemplates['none'] = &$actiontemplates['search'];

$phrasegroups = array(
	'adv_dyna_search',
	'search'
);

require_once('./dyna_global.php');

if (empty($_REQUEST['do']))
{
	$_REQUEST['do'] = 'search';
}

($hook = vBulletinHook::fetch_hook('vba_dyna_search_start')) ? eval($hook) : false;

// ############################### Search results ###############################
if ($_REQUEST['do'] == 'searchresults')
{
	$searchid = $vbulletin->input->clean_gpc('r', 'searchid', TYPE_INT);
	$pagenumber = $vbulletin->input->clean_gpc('r', 'pagenumber', TYPE_INT);

	$catids = $vbulletin->input->clean_gpc('r', 'catids', TYPE_ARRAY);
	$fields = $vbulletin->input->clean_gpc('r', 'fields', TYPE_ARRAY);
	$cfields = $vbulletin->input->clean_gpc('r', 'cfields', TYPE_ARRAY);
	$cselectfields = $vbulletin->input->clean_gpc('r', 'cselectfields', TYPE_ARRAY);
	$string = $vbulletin->input->clean_gpc('r', 'string', TYPE_NOHTML);
	$orderby = $vbulletin->input->clean_gpc('r', 'orderby', TYPE_NOHTML);
	$direction = $vbulletin->input->clean_gpc('r', 'direction', TYPE_NOHTML);
	$username = $vbulletin->input->clean_gpc('r', 'username', TYPE_NOHTML);
	$subcats = $vbulletin->input->clean_gpc('r', 'subcats', TYPE_INT);
	$quicksearch = $vbulletin->input->clean_gpc('r', 'quicksearch', TYPE_INT);
	$quicksearch = $vbulletin->input->clean_gpc('r', 'quicksearch', TYPE_INT);
	$tag = $vbulletin->input->clean_gpc('r', 'tag', TYPE_INT);
	$dateline = $vbulletin->input->clean_gpc('r', 'dateline', TYPE_INT);
	
	$validfields = array(
		'title',
		'keywords',
		'pagetext',
		'posts'
	);

	require_once(DIR . '/includes/functions_search.php');
	require_once(DIR . '/includes/functions_misc.php');

	$starttimecounter = microtime();

	// Image verification
	check_human_verify('search');

	// Find last search
	if ($vbulletin->options['searchfloodtime'] AND !($permissions['adminpermissions'] & $vbulletin->bf_ugp_adminpermissions['cancontrolpanel']) AND !can_moderate())
	{
		if ($checksearch = $db->query_first("SELECT dateline FROM " . ADV_DYNA_TABLE_PREFIX . "search WHERE userid = '" . $vbulletin->userinfo['userid'] . "' AND dateline > " . (TIMENOW - $vbulletin->options['searchfloodtime']) . ""))
		{
			eval(standard_error(fetch_error(
				'searchfloodcheck',
				$vbulletin->options['searchfloodtime'],
				($vbulletin->options['searchfloodtime'] - (TIMENOW - $checksearch['dateline']))
			)));
		}
	}

	// Quick search
	if ($quicksearch OR $tag)
	{
		if ($tag)
		{
			$string = str_replace('_', ' ', $string);
		}
		$quicksearch = 1;

		$fields = ($tag AND $vba_options['dyna_matchonly_keywords']) ? array('keywords') : array('title', 'keywords', 'pagetext', 'posts');
		$subcats = 1;
		$catids = array('0');
	}
	// Clean fields if not from quick search
	else
	{
		$fields = array_intersect($fields, $validfields);
		
		if ($vba_options['dyna_disablecats'])
		{
			$catids = array($vba_options['dyna_disablecats']);
		}
	}

	// ##### Sanitize Custom fields
	if (!empty($cfields) OR !empty($cselectfields))
	{
		$customcache = array();
		if (!empty($vbulletin->adv_dyna_cfield))
		{
			foreach ($vbulletin->adv_dyna_cfield AS $cfieldid => $custom)
			{
				if (!$custom['searchable'] OR (!$show['modoptions'] AND $custom['private']))
				{
					continue;
				}
				if ($cselectfields['field' . $custom['fieldid']] == array(0 => ''))
				{
					unset($cselectfields['field' . $custom['fieldid']]);
				}

				$customcache['field' . $custom['fieldid']] = $custom;
			}
		}

		$validcustom = array_keys($customcache);

		$cfields = array_intersect($cfields, $validcustom);

		if (array_diff(array_keys($cselectfields), $validcustom))
		{
			trigger_error('Invalid custom field input.', E_USER_ERROR);
		}

		$fields = array_merge($fields, $cfields);
		$cfjoin = 'LEFT JOIN ' . ADV_DYNA_TABLE_PREFIX . 'cfields_entries AS customfields ON (entries.entryid = customfields.eid)';
	}

  if (!$string AND !$username AND empty($cselectfields))
  {
		eval(standard_error(fetch_error('searchspecifyterms')));
	}

	if (empty($fields) AND empty($cfields) AND empty($cselectfields))
	{
		eval(standard_error(fetch_error(ADV_DYNA_PREFIX . '_error_no_search_fields')));
	}

	// ##### Search string
	if ($string)
	{
		$condition = '(';

		$strcount = false;
		foreach (explode(' ', $string) AS $sstring)
		{
			$concount = false;

			if ($strcount)
			{
				$condition .= '(';
			}
			foreach ($fields AS $fieldname)
			{
				switch ($fieldname)
				{
					case 'posts':
						$fieldname = 'posts.pagetext';
					break;

					case 'pagetext':
						$fieldname = 'entries_pages.pagetext';
					break;

					case 'title':
						$fieldname = 'entries.title';
					break;
				}

				if ($concount)
				{
					$condition .= ' OR ';
				}

				if ($_REQUEST['matchwholeword'])
				{
					$condition .= "$fieldname LIKE '% " . sanitize_word_for_sql($sstring) . " %'";
				}
				else
				{
					$condition .= "$fieldname LIKE '%" . sanitize_word_for_sql($sstring) . "%'";
				}

				$concount = true;
			}
			$condition .= ') AND ';

			$strcount = true;
		}
	}

	// What tables do we need to join?
	$searchjoin = '';

	if (in_array('pagetext', $fields))
	{
		$searchjoin .= ' LEFT JOIN ' . ADV_DYNA_TABLE_PREFIX . 'entries_pages AS entries_pages ON (entries.entryid = entries_pages.entryid)';
	}
	if (in_array('posts', $fields))
	{
		$searchjoin .= ' LEFT JOIN ' . ADV_DYNA_TABLE_PREFIX . 'posts AS posts ON (posts.entryid = entries.entryid)';
	}

	// ##### Limited custom fields
	if (!empty($cselectfields))
	{
		$cfieldandstring = '';
		foreach ($cselectfields AS $selfield => $selopts)
		{
			if (!empty($selopts))
			{
				$selopts = array_map('sanitize_word_for_sql', $selopts);
				$selopts = array_map('htmlspecialchars', $selopts);

				if ($cfieldandstring)
				{
					$cfieldandstring .= ' AND (';
				}

				switch ($customcache[$selfield]['type'])
				{
					// Max of 1 selection
					case 'select':
					case 'radio':
							$cfieldandstring .= $selfield . " IN('" . implode("', '", $selopts) . "')";
					break;

					// Multiple choices, so data is serialized
					case 'multiple_select':
					case 'checkbox':
						$cfieldandstring .= $selfield . " LIKE '%\"" . implode("\"%' OR $selfield LIKE '%\"", $selopts) . "\"%'";
					break;
				}

				$cfieldandstring .= ') ';

			}
		}

		if ($cfieldandstring)
		{
			$condition .= ($strcount ? ' (' : '(') . $cfieldandstring . ' AND ';
		}
	}

	// ##### Search Username
	if ($username OR $entryuserid)
	{
		if ($username)
		{
			$username = sanitize_word_for_sql($username);

			if (!$exactname AND strlen($username) < 3)
			{
				eval(standard_error(fetch_error('searchnametooshort')));
			}

			$useridquery = 'username ' . iif($exactname, "= '$username'", "LIKE '%$username%'");
		}
		else
		{
			$useridquery = 'userid = ' . $entryuserid;
		}

		$getuserids = $db->query_read("
			SELECT userid, username
			FROM " . TABLE_PREFIX . "user
			WHERE $useridquery
		");
		if ($db->num_rows($getuserids))
		{
			$searchusers = array();
			while ($userinfo = $db->fetch_array($getuserids))
			{
				$searchusers["$userinfo[userid]"] = $userinfo['username'];
			}
		}
		else
		{
			eval(standard_error(fetch_error('invalidid', $vbphrase['user'])));
		}
		$userids = implode(',', array_keys($searchusers));
		$condition .= ' (entries.userid IN(' . $userids . ')' . iif (in_array('posts', $fields), ' OR posts.userid IN(' . $userids . ')') . ') AND';
	}

	// #####  Date limits
	if ($dateline)
	{
		$dateline = ($dateline == 'lastvisit') ? $vbulletin->userinfo['lastvisit'] : (TIMENOW - ($dateline * 86400));

		$condition .= ' entries.dateline ' . iif($_POST['new_old'] == 'older', '<=', '>=') . $dateline . ' AND';
	}

	// Replycount
	if ($_POST['replycount'] OR $_POST['leastmost'] == 'most')
	{
		$condition .= ' posts ' . iif($_POST['leastmost'] == 'least', '>=', '=<') . ' ' . intval($_POST['replycount']) . ' AND';
	}

	// No cats
	if (empty($catids) AND $catids != 0)
	{
		eval(standard_error(fetch_error(ADV_DYNA_PREFIX . '_search_nocat', $vbphrase['category_lwr'])));
	}

	require_once(DIR . '/includes/vba_dyna_functions_cats.php');

	// Searching favorites category
	if (!empty($catids) AND in_array('favorites', $catids))
	{
		$searchquery = "
			SELECT favorites.entryid
			FROM " . ADV_DYNA_TABLE_PREFIX . "favorites AS favorites
			LEFT JOIN " . ADV_DYNA_TABLE_PREFIX . "entries AS entries ON (favorites.entryid = entries.entryid)
			$searchjoin
			$cfjoin
			WHERE draft = 0 AND $condition valid = 1
		";
	}
	else
	{
		$catids = array_map('intval', $catids);

		$privcats = fetch_private_categories(false, 'cansearch');

		if (!empty($catids) AND $catids != array(0))
		{
			if ($subcats)
			{
				foreach ($catids AS $scats)
				{
					$catids = array_merge($catids, fetch_category_children($scats));
				}
			}

			$catids = array_diff($catids, $privcats);

			if (empty($catids))
			{
				eval(standard_error(fetch_error(ADV_DYNA_PREFIX . '_search_nocat', $vbphrase['category_lwr'])));
			}

			$condition .= ' entries.catid IN(' . implode(',', $catids) . ') AND ';
		}

		($hook = vBulletinHook::fetch_hook('vba_dyna_search_processresults')) ? eval($hook) : false;

		if (!empty($privcats) AND empty($catids))
		{
			$privatecats = 'AND entries.catid NOT IN(' . $privcats . ')';
		}

		$searchquery = "
			SELECT entries.entryid
			FROM " . ADV_DYNA_TABLE_PREFIX . "entries AS entries
			$searchjoin
			$cfjoin
			WHERE draft = 0 AND $condition valid = 1 $privatecats
		";
	}

	if ($vbulletin->options['maxresults'])
	{
		$searchquery .= 'LIMIT ' . $vbulletin->options['maxresults'];
	}

	// Get Entry ids
	$entryidarray = array();
	$getentries = $db->query_read($searchquery);
	while ($entries = $db->fetch_array($getentries))
	{
		$entryidarray[] = $entries['entryid'];
	}
	$db->free_result($getentries);
	unset($entries);

	$entrycount = sizeof($entryidarray);

	if (!$entrycount)
	{
		eval(standard_error(fetch_error('searchnoresults', '')));
	}

	// Insert to the search table
	$db->query_write("
		INSERT INTO " . ADV_DYNA_TABLE_PREFIX . "search
			(string, username, sfields, catids, dateline, userid, entryids, orderby, direction, wholeword, numresults, searchtime)
		VALUES (
			'" . $db->escape_string($string) . "',
			'" . iif(!empty($searchusers), $db->escape_string(serialize($searchusers))) . "',
			'" . implode(',', $fields) . "',
			'$catids',
			" . TIMENOW . ",
			" . $vbulletin->userinfo['userid'] . ",
			'" . implode(',', $entryidarray) . "',
			'" . $db->escape_string($orderby) . "',
			'" . $db->escape_string($direction) . "',
			" . intval($_REQUEST['matchwholeword']) . ",
			$entrycount,
			'" . number_format(fetch_microtime_difference($starttimecounter), 3) . "')
	");

	$searchid = $db->insert_id();

	$vbulletin->url = 'browsecategory.php?do=searchresults&amp;searchid=' . $searchid;
	eval(print_standard_redirect('search'));

}

// ############################### Main search page ###############################
if ($_REQUEST['do'] == 'search')
{
	if (!$catid)
	{
		$selected[0] = 'selected="selected"';
	}

	$fieldcount = iif($vba_options['dyna_allowreplies'], 1, 0);

	// #### Custom field stuff
	$selections_count = 0;
	$customfieldboxes = '';
	$customfield_selections = '';
	if (!empty($vbulletin->adv_dyna_cfield))
	{
		foreach ($vbulletin->adv_dyna_cfield AS $cfieldid => $field)
		{
			if (!$field['searchable'] OR (!$show['modoptions'] AND $field['private']))
			{
				continue;
			}
			switch ($field['type'])
			{
				// Lump them with the other free text fields
				case 'text':
				case 'textarea':
					$fieldcount++;
					if ($fieldcount == 2)
					{
						$customfieldboxes .= '</tr><tr>';
						$fieldcount = 0;
					}
					eval('$customfieldboxes .= "' . fetch_template(ADV_DYNA_PREFIX . '_search_custombits') . '";');
				break;

				// Throw them into a new fieldset
				default:

					$inputbits = '';
					$selections_count++;
					switch ($field['type'])
					{
						// Multiple Select
						case 'multiple_select':
						case 'select':

							if (!$field['size'])
							{
								$field['size'] = (sizeof($field['options']) > 5) ? 6 : (sizeof($field['options']) + 1);
							}

							$inputbits = '<select name="cselectfields[field' . $field['fieldid'] . '][]" multiple="multiple" size="' . $field['size'] . '" style="width:220px">';
							$inputbits .= '<option value="" selected="selected">' . $vbphrase['any'] . '</option>';

							foreach ($field['options'] AS $option)
							{
								$inputbits .= '<option value="' . $option . '">' . $option . '</option>';
							}
							$inputbits .= '</select>';
						break;

						// Checkboxes
						case 'radio':
						case 'checkbox':

							$checkrowcount = 0;
							$inputbits = '<table width="100%" cellpadding="1" cellspacing="0"><tr>';
							foreach ($field['options'] AS $key => $option)
							{
								$checkrowcount++;
								$inputbits .= '<td width="50%"><label for="field' . $field['fieldid'] . '_' . $key . '"><input id="field' . $field['fieldid'] . '_' . $key . '" name="cselectfields[field' . $field['fieldid'] . '][]" type="checkbox" value="' . $option . '">' . $option . '</label></td>';

								if ($checkrowcount == 2)
								{
									$inputbits .= '</tr>';
									$checkrowcount = 0;
								}
							}

							if ($checkrowcount)
							{
								$inputbits .= '</tr>';
							}

							$inputbits .= '</table>';

						break;
					}

					eval('$customfield_selections .= "' . fetch_template(ADV_DYNA_PREFIX . '_search_custombits_selection') . '";');
			}
		}
	}

	// Throw the options into a template so they can be moved around easily
	eval('$search_options = "' . fetch_template(ADV_DYNA_PREFIX . '_search_options') . '";');

	$categorylist = print_cat_select($catid, 'search');

	if (empty($categorylist))
	{
		print_no_permission();
	}

	$imagereg = fetch_human_verify('search');

	($hook = vBulletinHook::fetch_hook('vba_dyna_search_main')) ? eval($hook) : false;

	$navbits[''] = $vbphrase['search'];
	$navbits = construct_navbits($navbits);
	eval('$navbar = "' . fetch_template('navbar') . '";');

	require_once(DIR . '/includes/vba_dyna_include_modules.php');

	eval('print_output("' . fetch_template(ADV_DYNA_PREFIX_UPPER . '_SEARCH') . '");');
}

?>