<?php
// ++=========================================================================++
// || vBadvanced Dynamics v1.0.0 (vB 3.6 - vB 3.7)
// ||  2003-2007 vBadvanced.com - All Rights Reserved
// || This file may not be redistributed in whole or significant part.
// || http://vbadvanced.com
// ++ ========================================================================++

error_reporting(E_ALL & ~E_NOTICE);

$specialtemplates = array();

switch ($_REQUEST['do'])
{
	case 'menu':
		$phrasegroups = array('cphome');
	break;

	case 'modifysettings':
		$phrasegroups = array(
			'adv_dyna',
			'adv_dyna_modules',
			'cpoption',
			'adv_dyna_managecats'
		);
		$specialtemplates = array(
			'adv_dyna_cats',
			'adv_dyna_cfield',
			'adv_dyna_module'
		);
	break;

	case 'addcustomfield':
	case 'editcustomfield':
	case 'doaddcustomfield':
	case 'doeditcustomfield':
		$specialtemplates = array(
			'adv_dyna_cats'
		);
	break;

	case 'attachments':
	case 'editext':
	case 'addext':
	case 'deleteext':
		$phrasegroups = array('attachment_image');
	break;
}

if (!isset($_REQUEST['do']))
{
  $_REQUEST['do'] = 'frameset';
}

require_once('./vba_dyna_admin_global.php');

($hook = vBulletinHook::fetch_hook('vba_dyna_cp_main_start')) ? eval($hook) : false;

// ############################# Build frameset ###############################
if ($_REQUEST['do'] == 'frameset')
{
	$navframe = '<frame src="vba_dyna_admin_main.php?do=menu' . ADV_URL_PREFIX . '" name="nav" scrolling="yes" border="no" />';
	$mainframe = '<frame src="vba_dyna_admin_main.php?do=main' . ADV_URL_PREFIX . '" name="main" scrolling="yes" border="no" />';

	echo '<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Frameset//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-frameset.dtd">
	<html dir="' . $stylevar['textdirection'] . '" lang="'. $stylevar['languagecode'] . '">
	<head>
		<title>' . $vbphrase['vba_dyna'] . '</title>
		<script type="text/javascript">
		<!-- //
		if (self.parent.frames.length != 0)
		{
			document.write(\'Get me out of this frame set!\');
			self.parent.location.replace(document.location.href);
		}
		// -->
		</script>
	</head>
	<frameset cols="' . iif($stylevar['textdirection'] == 'ltr', '195,*', '*,195') . '"  framespacing="0" border="0" frameborder="0" frameborder="no" border="0">
			' . iif($stylevar['textdirection'] == 'ltr', $navframe . $mainframe, $mainframe . $navframe);
	exit;
}

// ################################# Nav menu #################################
if ($_REQUEST['do'] == 'menu')
{
	define('IS_NAV_PANEL', true);
	print_cp_header();
	require_once(DIR . '/includes/adminfunctions_navpanel.php');

	echo '<div><img alt="" border="" src="../cpstyles/vba_cp_logo.gif" title="' . $vbphrase['admin_control_panel'] . '" hspace="4" vspace="4" /></div><div style="width:168px; padding:4px">';

	echo '<br /><div class="navtitle">' . $vbphrase['vbadvanced_dynamics'] . '</div><div class="navgroup">';

	construct_nav_option($vbphrase['modify_settings'], 'vba_dyna_admin_main.php?do=modifysettings' . ADV_URL_PREFIX);
	construct_nav_option($vbphrase['usergroup_permissions'], 'vba_dyna_admin_permissions.php?do=permissions' . ADV_URL_PREFIX);
	construct_nav_option($vbphrase['manage_categories'], 'vba_dyna_admin_categories.php' . ADV_URL_PREFIX);
	construct_nav_option($vbphrase['add_category'], 'vba_dyna_admin_categories.php?do=addcat' . ADV_URL_PREFIX);
	construct_nav_option($vbphrase['category_permissions'], 'vba_dyna_admin_permissions.php?do=categorypermissions' . ADV_URL_PREFIX);

	construct_nav_option($vbphrase['edit_modules'], 'vba_dyna_admin_modules.php?do=listmodules' . ADV_URL_PREFIX);
	construct_nav_option($vbphrase['add_module'], 'vba_dyna_admin_modules.php?do=newmodule' . ADV_URL_PREFIX);
	construct_nav_option($vbphrase['download_upload_module'], 'vba_dyna_admin_modules.php?do=download' . ADV_URL_PREFIX);
	construct_nav_option($vbphrase['edit_module_layouts'], 'vba_dyna_admin_modules.php?do=editlayouts' . ADV_URL_PREFIX);
	construct_nav_option($vbphrase['manage_custom_user_modules'], 'vba_dyna_admin_modules.php?do=usermodules' . ADV_URL_PREFIX);

	construct_nav_option($vbphrase['custom_fields'], 'vba_dyna_admin_main.php?do=customfields' . ADV_URL_PREFIX);
	construct_nav_option($vbphrase['attachments'], 'vba_dyna_admin_main.php?do=attachments' . ADV_URL_PREFIX);
	construct_nav_option($vbphrase['attachment_permissions'], 'vba_dyna_admin_permissions.php?do=attachperms' . ADV_URL_PREFIX);
	construct_nav_option($vbphrase['maintenance'], 'vba_dyna_admin_maintenance.php' . ADV_URL_PREFIX);

	foreach ($options AS $entries)
	{
		echo $entries;
	}
	exit;
}

// ##### Custom Field Types
$customfieldtypes = array(
	'text' => 'text_input',
	'textarea' => 'textarea',
	'select' => 'select_menu',
	'multiple_select' => 'multiple_select',
	'radio' => 'radio_options',
	'checkbox' => 'checkbox'
);

// ######################## Add / Edit Setting ###########################
if ($_REQUEST['do'] == 'addsetting' OR $_REQUEST['do'] == 'editsetting')
{
	$varname = $vbulletin->input->clean_gpc('r', 'varname', TYPE_NOHTML);
	$identifier = $vbulletin->input->clean_gpc('r', 'identifier', TYPE_NOHTML);
	$modid = $vbulletin->input->clean_gpc('r', 'modid', TYPE_INT);

	// Get setting phrases
	$settingphrase = fetch_settings_phrases();

	$settinggroups = array();
	$groups = $db->query("
		SELECT grouptitle
		FROM " . TABLE_PREFIX . "adv_settinggroup
		WHERE grouptitle LIKE '" . ADV_DYNA_PREFIX . "%'
			OR grouptitle = 'adv_global'
		ORDER BY displayorder
	");
	while ($group = $db->fetch_array($groups))
	{
		$settinggroups[$group['grouptitle']] = $settingphrase['settinggroup_' . $group['grouptitle']];
	}

	print_dyna_form_header('vba_dyna_admin_main', 'do' . $_REQUEST['do']);
	print_table_header(iif($_REQUEST['do'] == 'editsetting', $vbphrase['edit_setting'] . ': ' . $varname, $vbphrase['add_setting']));
	construct_hidden_code('modid', $modid);

	if ($_REQUEST['do'] == 'editsetting')
	{
		$setting = $db->query_first("
			SELECT *
			FROM " . TABLE_PREFIX . "adv_setting
			WHERE varname = '" . $db->escape_string($varname) . "'
				AND grouptitle LIKE '" . ADV_DYNA_PREFIX . iif($identifier, '_modules_' . $db->escape_string($identifier), '%') . "'
		");

		construct_hidden_code('setting[varname]', $setting['varname']);
		print_label_row($vbphrase['varname'], '<b>' . $setting['varname'] . '</b>');

		$phrases = $db->query_read("SELECT varname, text FROM " . TABLE_PREFIX . "phrase WHERE varname IN ('setting_$setting[varname]_title', 'setting_$setting[varname]_desc') AND fieldname = 'vbsettings'");
		while ($phrase = $db->fetch_array($phrases))
		{
			if ($phrase['varname'] == "setting_$setting[varname]_title")
			{
				$setting['title'] = $phrase['text'];
			}
			else
			{
				$setting['description'] = $phrase['text'];
			}
		}
	}
	else
	{
		print_input_row($vbphrase['varname'], 'setting[varname]', $setting['varname']);
	}

	construct_hidden_code('oldgrouptitle', $setting['grouptitle']);

	print_input_row($vbphrase['title'], 'title', $setting['title']);

	if ($modid OR $identifier)
	{
		construct_hidden_code('setting[grouptitle]', ADV_DYNA_PREFIX . '_modules_' . $identifier);
	}
	else
	{
		print_select_row($vbphrase['setting_group'], 'setting[grouptitle]', $settinggroups, iif($_REQUEST['do'] == 'addsetting', $_REQUEST['grouptitle'], $setting['grouptitle']));
	}
	print_textarea_row($vbphrase['description'], 'desc', $setting['description']);
	print_textarea_row($vbphrase['option_code'], 'setting[optioncode]', $setting['optioncode'], 4, 50);
	print_textarea_row($vbphrase['default'], 'setting[defaultvalue]', $setting['defaultvalue'], 4, 50);
	print_input_row($vbphrase['display_order'], 'setting[displayorder]', $setting['displayorder']);
	print_yes_no_row($vbphrase['serialize'], 'setting[serialize]', $setting['serialize']);
	print_submit_row();
}

// ######################## Do Add Setting ###########################
if ($_POST['do'] == 'doaddsetting')
{
	$vbulletin->input->clean_array_gpc('p', array(
		'modid' => TYPE_INT,
		'setting' => TYPE_ARRAY,
		'title' => TYPE_STR,
		'desc' => TYPE_STR,
		'oldgrouptitle' => TYPE_STR
	));

	if (!$checkphrase = $db->query_first("
		SELECT varname FROM " . TABLE_PREFIX . "phrase
		WHERE varname = 'setting_" . $vbulletin->GPC['setting']['varname'] . "_title'
			OR varname = 'setting_" . $vbulletin->GPC['setting']['varname'] . "_desc'
	"))
	{
		$vbulletin->db->query_write("
			INSERT INTO " . TABLE_PREFIX . "phrase
				(languageid, varname, text, fieldname, product)
			VALUES (
				-1,
				'setting_" . $vbulletin->GPC['setting']['varname'] . "_title',
				'" . $db->escape_string(htmlspecialchars($vbulletin->GPC['title'])) ."',
				'vbsettings',
				'" . ADV_DYNA_PREFIX . "'
		)");

		$vbulletin->db->query_write("
			INSERT INTO " . TABLE_PREFIX . "phrase
				(languageid, varname, text, fieldname, product)
			VALUES (
				-1,
				'setting_" . $vbulletin->GPC['setting']['varname'] . "_desc',
				'" . $db->escape_string($vbulletin->GPC['desc']) . "',
				'vbsettings',
				'" . ADV_DYNA_PREFIX . "'
		)");
	}

	$setting['value'] = $setting['defaultvalue'];

	$vbulletin->db->query_write(fetch_query_sql($vbulletin->GPC['setting'], 'adv_setting'));

	require_once(DIR . '/includes/adminfunctions_language.php');
	build_language(-1);

	if ($vbulletin->GPC['modid'])
	{
		print_cp_redirect('vba_dyna_admin_modules.php?' . $vbulletin->session->vars['sessionurl'] . 'do=editmodule&modid=' . $vbulletin->GPC['modid'] . ADV_URL_PREFIX_HR . '#settings', 0);
	}
	else
	{
		print_cp_redirect('vba_dyna_admin_main.php?' . $vbulletin->session->vars['sessionurl'] . 'do=modifysettings&grouptitle=' . $setting['grouptitle'] . ADV_URL_PREFIX_HR, 0);
	}
}

// ######################## Do Edit Setting ###########################
if ($_POST['do'] == 'doeditsetting')
{
	$vbulletin->input->clean_array_gpc('p', array(
		'modid' => TYPE_INT,
		'setting' => TYPE_ARRAY,
		'title' => TYPE_STR,
		'desc' => TYPE_STR,
		'oldgrouptitle' => TYPE_NOHTML
	));

	$vbulletin->db->query_write(fetch_query_sql(
		$vbulletin->GPC['setting'],
		'adv_setting',
		"WHERE varname = '" . $db->escape_string($vbulletin->GPC['setting']['varname']) . "'
			AND grouptitle = '" . $db->escape_string($vbulletin->GPC['oldgrouptitle']) . "'"
	));

	// Try to insert just incase
	$vbulletin->db->query_write("
		INSERT IGNORE INTO " . TABLE_PREFIX . "phrase
			(varname, text, fieldname)
		VALUES (
			'setting_" . $db->escape_string($vbulletin->GPC['setting']['varname']) . "_desc',
			'" . $db->escape_string($vbulletin->GPC['desc']) . "',
			'vbsettings'
		)
	");

	$vbulletin->db->query_write("
		INSERT IGNORE INTO " . TABLE_PREFIX . "phrase
			(varname, text, fieldname)
		VALUES (
			'setting_" . $db->escape_string($vbulletin->GPC['setting']['varname']) . "_title',
			'" . $db->escape_string($vbulletin->GPC['title']) . "',
			'vbsettings'
		)
	");

	$vbulletin->db->query_write("
		UPDATE " . TABLE_PREFIX . "phrase SET
			text = '" . $db->escape_string($vbulletin->GPC['desc']) . "'
		WHERE varname = 'setting_" . $db->escape_string($vbulletin->GPC['setting']['varname']) . "_desc'
	");

	$vbulletin->db->query_write("
		UPDATE " . TABLE_PREFIX . "phrase SET
			text = '" . $db->escape_string($vbulletin->GPC['title']) . "'
		WHERE varname = 'setting_" . $db->escape_string($vbulletin->GPC['setting']['varname']) . "_title'
	");

	require_once(DIR . '/includes/adminfunctions_language.php');
	build_language(-1);

	if ($vbulletin->GPC['modid'])
	{
		print_cp_redirect('vba_dyna_admin_modules.php?' . $vbulletin->session->vars['sessionurl'] . 'do=editmodule&modid=' . $vbulletin->GPC['modid'] . ADV_URL_PREFIX_HR . '#settings', 0);
	}
	else
	{
		print_cp_redirect('vba_dyna_admin_main.php?' . $vbulletin->session->vars['sessionurl'] . 'do=modifysettings&grouptitle=' . $vbulletin->GPC['setting']['grouptitle'] . ADV_URL_PREFIX_HR, 0);
	}
}

// ########################## Remove Setting ###########################
if ($_REQUEST['do'] == 'removesetting')
{
	$varname = htmlspecialchars($_REQUEST['varname']);
	$grouptitle = htmlspecialchars($_REQUEST['grouptitle']);

	print_dyna_form_header('vba_dyna_admin_main', 'doremovesetting');
	construct_hidden_code('varname', $varname);
	construct_hidden_code('grouptitle', $grouptitle);
	print_table_header($vbphrase['confirm_deletion']);
	print_description_row(construct_phrase($vbphrase['are_you_sure_delete_x_y'], $vbphrase['setting'], $varname));
	print_submit_row($vbphrase['yes'], '', 2, $vbphrase['no']);
}

// ######################### Do Remove Setting ############################
if ($_POST['do'] == 'doremovesetting')
{
	$varname = $db->escape_string($_POST['varname']);
	$grouptitle = $db->escape_string($_POST['grouptitle']);

	$db->query_write("DELETE FROM " . TABLE_PREFIX . "adv_setting WHERE varname = '$varname' AND grouptitle = '$grouptitle'");

	$dupecheck = $db->query_first("SELECT varname FROM " . TABLE_PREFIX . "adv_setting WHERE varname = '$varname'");
	if (!$dupecheck['varname'])
	{
		$db->query_write("DELETE FROM " . TABLE_PREFIX . "phrase WHERE varname = 'setting_" . $varname . "_desc'");
		$db->query_write("DELETE FROM " . TABLE_PREFIX . "phrase WHERE varname = 'setting_" . $varname . "_title'");
	}

	print_cp_redirect('vba_dyna_admin_main.php?' . $vbulletin->session->vars['sessionurl'] . 'do=modifysettings' . ADV_URL_PREFIX_HR, 0);
}

// ####################### Modify Settings ############################
if ($_REQUEST['do'] == 'modifysettings')
{
	$grouptitle = $vbulletin->input->clean_gpc('r', 'grouptitle', TYPE_NOHTML);

	$settingphrase = fetch_settings_phrases();

	$grouptitlecache = array();

	// Start printing the settinggroup select box
	$grouptitles = array('all' => '-- ' . $vbphrase['show_all_settings'] . ' --');

	$optionlabel = construct_phrase($vbphrase['x_options'], $vbphrase['default']);

	$groups = $db->query_read("
		SELECT grouptitle FROM " . TABLE_PREFIX . "adv_settinggroup
		WHERE grouptitle LIKE '" . ADV_DYNA_PREFIX . "%' OR grouptitle = 'adv_global'
		ORDER BY displayorder
	");
	while ($group = $db->fetch_array($groups))
	{
		$grouptitles[$optionlabel][$group['grouptitle']] = $settingphrase['settinggroup_' . $group['grouptitle']];
		$grouptitlecache["$group[grouptitle]"] = $group['grouptitle'];
	}

	// Figure out which modules we need
	$moduleident = array();
	foreach ($vbulletin->adv_dyna_module AS $modid => $module)
	{
		if ($module['identifier'])
		{
			$moduleident[ADV_DYNA_PREFIX . '_modules_' . $module['identifier']] = $modid;
		}
	}

	if (!empty($moduleident))
	{
		$modsettings = array();
		$gettitles = $db->query_read("
			SELECT grouptitle
			FROM " . TABLE_PREFIX . "adv_setting
			WHERE grouptitle IN('" . implode("', '", array_keys($moduleident)) . "')
		");
		while ($titles = $db->fetch_array($gettitles))
		{
			$modsettings[] = $moduleident[$titles['grouptitle']];
		}
	}

	if (!empty($modsettings))
	{
		$modulelabel = construct_phrase($vbphrase['x_options'], $vbphrase['module']);

		$modules = $db->query_read("
			SELECT title, identifier
			FROM " . ADV_DYNA_TABLE_PREFIX . "modules AS module
			WHERE modid IN(" . implode(',', $modsettings) . ")
			ORDER BY title
		");
		while ($module = $db->fetch_array($modules))
		{
			$gtitle = ADV_DYNA_PREFIX . '_modules_' . $module['identifier'];
			$grouptitles[$modulelabel][$gtitle] = $module['title'];

			$settingphrase['settinggroup_' . $gtitle] = $module['title'] . ' ' . $vbphrase['module'];

			$grouptitlecache[$gtitle] = $gtitle;
		}
	}

	// Print it out
	print_dyna_form_header('vba_dyna_admin_main', 'modifysettings', false, true, 'cpform', '90%', '', true, 'get');
	if ($grouptitle)
	{
		print_table_header($vbphrase['setting_group'] . ' <select tabindex="99" name="grouptitle" onchange="this.form.submit();" class="bginput" style="width:350px">' .
			construct_select_options($grouptitles, $grouptitle) . '</select> <input tabindex="100" type="submit" class="button" value="' . $vbphrase['go'] . '" />'
		);
		print_table_footer();
	}
	else
	{
		print_table_header(construct_phrase($vbphrase['x_options'], $vbphrase['vbadvanced_dynamics']));
		print_label_row($vbphrase['settings_to_edit'], '<select name="grouptitle" ondblclick="this.form.submit();" class="bginput" style="width:350px" size="20">' .
			construct_select_options($grouptitles, 'all') . '</select>'
		);
		print_submit_row($vbphrase['edit_settings'], '');
	}

	// Get options for specific group, or all
	if ($grouptitle)
	{
		$settingscache = array();
		$settings = $db->query_read("
			SELECT adv_setting.*
			FROM " . TABLE_PREFIX . "adv_setting AS adv_setting
			LEFT JOIN " . TABLE_PREFIX . "adv_settinggroup AS adv_settinggroup USING (grouptitle)
			WHERE optioncode != 'hidden' AND
				" . iif($grouptitle == 'all',
					"(adv_settinggroup.grouptitle LIKE '" . ADV_DYNA_PREFIX . "%' OR adv_settinggroup.grouptitle = 'adv_global')",
					"adv_setting.grouptitle = '" . $db->escape_string($grouptitle) . "'"
				) . "
			ORDER BY adv_settinggroup.displayorder, adv_setting.displayorder
		");

		while ($setting = $db->fetch_array($settings))
		{
			if ($setting['serialize'])
			{
				$setting['value'] = unserialize($setting['value']);
				if (!is_array($setting['value']))
				{
					$setting['value'] = array();
				}
			}

			$settingscache["$setting[grouptitle]"]["$setting[varname]"] = $setting;
		}

		$db->free_result($settings);
		unset($setting);

		// Module settings
		if ($grouptitle == 'all' AND !empty($modsettings))
		{

			$settings = $db->query_read("
				SELECT adv_setting.*
				FROM " . TABLE_PREFIX . "adv_setting AS adv_setting
				LEFT JOIN " . TABLE_PREFIX . "adv_settinggroup AS adv_settinggroup ON (adv_setting.grouptitle = adv_settinggroup.grouptitle)
				WHERE adv_setting.grouptitle IN('" . implode("', '", array_keys($moduleident)) . "')
				ORDER BY adv_settinggroup.displayorder, adv_setting.displayorder
			");

			while ($setting = $db->fetch_array($settings))
			{
				if ($setting['serialize'])
				{
					$setting['value'] = unserialize($setting['value']);
					if (!is_array($setting['value']))
					{
						$setting['value'] = array();
					}
				}

				$settingscache["$setting[grouptitle]"]["$setting[varname]"] = $setting;
				$grouptitlecache["$setting[grouptitle]"] = $setting['grouptitle'];
			}
		}

		$db->free_result($settings);
		unset($setting);
		print_dyna_form_header('vba_dyna_admin_main', 'saveopts');

		$modulestrip = strlen(ADV_DYNA_PREFIX);

		$moduleprinted = (sizeof($settingscache) > 1) ? false : true;

		foreach ($grouptitlecache AS $grouptitle)
		{
			$ismodcheck = substr($grouptitle, 0, ($modulestrip + 9));

			$ismodgroup = ($ismodcheck == ADV_DYNA_PREFIX . '_modules_') ? true : false;
			if ($ismodgroup)
			{
				$module['identifier'] = substr($grouptitle, strlen($ismodcheck));
				if (!$moduleprinted)
				{
					print_table_break();
					print_table_break();
					print_table_break();
					print_table_header(construct_phrase($vbphrase['x_options'], $vbphrase['vbadvanced_dynamics'] . ' ' . $vbphrase['module']));
					print_table_break();
					$moduleprinted = true;
				}
			}

			print_adv_setting_group($grouptitle);
		}
		print_submit_row();
	}
}

// ####################### Save Settings ############################
if ($_POST['do'] == 'saveopts')
{
	require_once(DIR . '/includes/functions_misc.php');

	$notices = array();

	$grouptitles = $vbulletin->input->clean_gpc('p', 'grouptitles', TYPE_ARRAY);

	process_adv_settings(array_keys($grouptitles));

	$vba_options = build_dyna_settings_datastore();

	build_dyna_module_datastore();

	// Category order changed
	if ($updatecatcache)
	{
		require_once(DIR . '/includes/vba_dyna_functions_savecat.php');
		update_category_cache();
	}

	// Notices
	if (!empty($notices))
	{
		$printnotice = '<ul>';
		foreach ($notices AS $notice)
		{
			$printnotice .= '<li>' . $notice . '</li>';
		}
		$printnotice .= '</ul>';

		print_stop_message(ADV_DYNA_PREFIX . '_settings_saved_but_problems_found', $printnotice);
	}
	else
	{
		if (sizeof($grouptitles) == 1)
		{
			$groupkeys = array_keys($grouptitles);
			$groupredirect = $groupkeys[0];
		}
		else
		{
			$groupredirect = 'all';
		}

		print_cp_redirect('vba_dyna_admin_main.php?' . $vbulletin->session->vars['sessionurl'] . 'do=modifysettings&grouptitle=' . $groupredirect . ADV_URL_PREFIX_HR, 0);
	}
}

// ##### List Attachment Extensions ###########################################
if ($_REQUEST['do'] == 'attachments')
{
	print_dyna_form_header('vba_dyna_admin_main', 'addext');
	print_table_header($vbphrase['attachment_manager'], 7);
	print_cells_row(
		array(
			$vbphrase['extension'],
			$vbphrase['maximum_filesize'],
			$vbphrase['maximum_width'],
			$vbphrase['maximum_height'],
			$vbphrase['enabled'],
			$vbphrase['thumb'],
			$vbphrase['controls']
		),
		1
	);

	// Current attachment types
	$attachtypes = $db->query_read("SELECT * FROM " . ADV_DYNA_TABLE_PREFIX . "attachmenttype ORDER BY extension");
	while ($type = $db->fetch_array($attachtypes))
	{
		$cell = array();

		$cell[] = ($type['enabled']) ? $type['extension'] : '<strike>' . $type['extension'] . '</strike>';
		$cell[] = fetch_rfilesize($type['size']);
		$cell[] = vb_number_format($type['width']);
		$cell[] = vb_number_format($type['height']);
		$cell[] = ($type['enabled']) ? $vbphrase['yes'] : $vbphrase['no'];
		$cell[] = ($type['thumbnail']) ? $vbphrase['yes'] : $vbphrase['no'];

		$cell[] = construct_link_code($vbphrase['edit'], 'vba_dyna_admin_main.php?do=editext&amp;ext=' . $type['extension'] . ADV_URL_PREFIX) . ' ' .
			construct_link_code($vbphrase['delete'], 'vba_dyna_admin_main.php?do=deleteext&amp;ext=' . $type['extension'] . ADV_URL_PREFIX);

		print_cells_row($cell);
	}

	print_submit_row($vbphrase['add_new_extension'], '', 7);
}

// ##### Edit Attachment Extension ############################################
if ($_REQUEST['do'] == 'editext' OR $_REQUEST['do'] == 'addext')
{
	if ($_REQUEST['do'] == 'editext')
	{
		$ext = $vbulletin->input->clean_gpc('r', 'ext', VAR_NOHTML);
		$attach = $db->query_first("SELECT * FROM " . ADV_DYNA_TABLE_PREFIX . "attachmenttype WHERE extension = '" . $db->escape_string($ext) . "'");
	}
	else
	{
		$attach['enabled'] = true;
	}

	print_dyna_form_header('vba_dyna_admin_main', 'do' . $_REQUEST['do']);

	if ($_REQUEST['do'] == 'editext')
	{
		construct_hidden_code('currentext', $ext);
	}

	print_table_header(construct_phrase($vbphrase['attachment_type'], $attach['extension']));
	print_input_row($vbphrase['extension'], 'attach[extension]', $attach['extension']);
	print_input_row($vbphrase['maximum_filesize_dfn'], 'attach[size]', $attach['size']);
	print_input_row($vbphrase['max_width_dfn'], 'attach[width]', $attach['width']);
	print_input_row($vbphrase['max_height_dfn'], 'attach[height]', $attach['height']);
	print_input_row($vbphrase['display_order'] . '<div class="smallfont">' . $vbphrase['display_order_affects_showentry_and_newattachment'], 'attach[displayorder]', $attach['displayorder']);
	print_yes_no_row($vbphrase['thumbnail_image'], 'attach[thumbnail]', $attach['thumbnail']);
	print_yes_no_row($vbphrase['open_in_new_window'], 'attach[newwin]', $attach['newwin']);
	print_yes_no_row($vbphrase['enabled'], 'attach[enabled]', $attach['enabled']);
	print_submit_row();
}

// ##### Do Add/Edit Extension ################################################
if ($_POST['do'] == 'doaddext' OR $_POST['do'] == 'doeditext')
{
	$attach = $vbulletin->input->clean_gpc('p', 'attach', TYPE_ARRAY);
	$currentext = $vbulletin->input->clean_gpc('p', 'currentext', TYPE_NOHTML);

	if (!$attach['extension'])
	{
		print_stop_message('please_complete_required_fields');
	}

	$attach['extension'] = strtolower($attach['extension']);

	// Check duplicates
	if ($_POST['do'] == 'doaddext' OR ($_POST['do'] == 'doeditext' AND $attach['extension'] != $currentext))
	{
		$checkit = $db->query_first("SELECT extension FROM " . ADV_DYNA_TABLE_PREFIX . "attachmenttype WHERE extension = '" . $db->escape_string($attach['extension']) . "'");

		if ($checkit['extension'])
		{
			print_stop_message('name_exists', $vbphrase['filetype'], $attach['extension']);
		}
	}

	$db->query_write(fetch_query_sql(
		$attach,
		ADV_DYNA_PREFIX . '_attachmenttype',
		($_POST['do'] == 'doeditext') ? 'WHERE extension = \'' . $db->escape_string($currentext) . '\'' : ''
	));

	build_dyna_attach_datastore();

	print_cp_redirect('vba_dyna_admin_main.php?' . $vbulletin->session->vars['sessionurl'] . 'do=attachments' . ADV_URL_PREFIX_HR, 0);

}

// ##### Delete Extension #####################################################
if ($_REQUEST['do'] == 'deleteext')
{
	$ext = $vbulletin->input->clean_gpc('r', 'ext', TYPE_STR);

	print_dyna_form_header('vba_dyna_admin_main', 'dodeleteext');
	print_table_header($vbphrase['confirm_deletion']);
	construct_hidden_code('ext', $ext);
	print_description_row(
		construct_phrase($vbphrase['are_you_sure_delete_x_y'],
			$vbphrase['extension'],
			$ext
	));
	print_submit_row($vbphrase['yes'], $vbphrase['no']);
}

// ##### Do Delete Extension ##################################################
if ($_POST['do'] == 'dodeleteext')
{
	$ext = $vbulletin->input->clean_gpc('r', 'ext', TYPE_STR);

	$db->query_write("
		DELETE FROM " . ADV_DYNA_TABLE_PREFIX . "attachmenttype
		WHERE extension = '" . $db->escape_string($ext) . "'
	");

	build_dyna_attach_datastore();

	print_cp_redirect('vba_dyna_admin_main.php?' . $vbulletin->session->vars['sessionurl'] . 'do=attachments' . ADV_URL_PREFIX_HR, 0);
}

// ##### Manage Custom Fields #################################################
if ($_REQUEST['do'] == 'customfields')
{
	print_dyna_form_header('vba_dyna_admin_main', 'addcustomfield', false, true, 'cpform', '90%', '', true, 'get');
	print_table_header($vbphrase['add_custom_field']);

	$cfieldselect = array();
	foreach ($customfieldtypes AS $ftype => $fphrase)
	{
		$cfieldselect[$ftype] = $vbphrase[$fphrase] . ' ' . $vbphrase[$fphrase . '_desc'];
	}

	print_select_row($vbphrase['custom_field_type'], 'type', $cfieldselect);
	print_submit_row($vbphrase['continue'], '');

	print_dyna_form_header('vba_dyna_admin_main', 'ordercustom');
	print_table_header($vbphrase['custom_fields'], 5);
	print_cells_row(array(
		$vbphrase['title'],
		$vbphrase['type'],
		$vbphrase['id'],
		$vbphrase['display_order'],
		$vbphrase['controls']
	), 0, 'thead', -1);

	$getfields = $db->query_read("SELECT * FROM " . ADV_DYNA_TABLE_PREFIX . "cfields ORDER BY displayorder");
	if ($db->num_rows($getfields))
	{
		while ($fields = $db->fetch_array($getfields))
		{
			$cells = array();
			$cells[] = $fields['title'] . iif($fields['private'], '<div class="smallfont">(' . $vbphrase['private'] . ')</div>');
			$cells[] = '<span class="smallfont">' . $vbphrase[$customfieldtypes[$fields['type']]] . '</span>';
			$cells[] = 'field' . $fields['fieldid'];
			$cells[] = '<input class="bginput" tabindex="1" name="order[' . $fields['fieldid'] . ']" size="3" type="text" value="'  . $fields['displayorder'] . '" />';
			$cells[] = 	construct_link_code($vbphrase['edit'], 'vba_dyna_admin_main.php?' . $vbulletin->session->vars['sessionurl'] . 'do=editcustomfield&amp;fieldid=' . $fields['fieldid'] . ADV_URL_PREFIX) . construct_link_code($vbphrase['delete'], 'vba_dyna_admin_main.php?' . $vbulletin->session->vars['sessionurl'] . 'do=removecustomfield&amp;fieldid=' . $fields['fieldid'] . ADV_URL_PREFIX);
			print_cells_row($cells, '', '', -1);
		}

		print_submit_row($vbphrase['save_display_order'], $vbphrase['reset'], 5);

	}
	else
	{
		print_description_row($vbphrase['not_added_custom_fields'], '', 6);
	}
	print_table_footer();

}

// ##### Re-Order Custom Fields ###############################################
if ($_POST['do'] == 'ordercustom')
{
  foreach ($_POST['order'] AS $fieldid => $disorder)
  {
		$db->query_write("UPDATE " . ADV_DYNA_TABLE_PREFIX . "cfields SET displayorder = " . intval($disorder) . " WHERE fieldid = '" . $db->escape_string($fieldid) . "'");
  }

	build_dyna_cfield_datastore();

	print_cp_redirect('vba_dyna_admin_main.php?' . $vbulletin->session->vars['sessionurl'] . 'do=customfields' . ADV_URL_PREFIX_HR, 0);
}

// ############################## Add Custom Field ##########################
if ($_REQUEST['do'] == 'addcustomfield' OR $_REQUEST['do'] == 'editcustomfield')
{
	$type = htmlspecialchars($_REQUEST['type']);
	$fieldid = intval($_REQUEST['fieldid']);

	print_dyna_form_header('vba_dyna_admin_main', 'do' . $_REQUEST['do']);

	// Edit Field
	if ($_REQUEST['do'] == 'editcustomfield')
	{
		$custom = $db->query_first("SELECT * FROM " . ADV_DYNA_TABLE_PREFIX . "cfields WHERE fieldid = $fieldid");
		construct_hidden_code('custom[fieldid]', $custom['fieldid']);
		$type = $custom['type'];

		$headertitle = $vbphrase['edit_custom_field'] . ' - ' . $custom['title'] . ' (' . $vbphrase['id'] . ': field' . $custom['fieldid'] . ')';
	}
	// Add Field
	else
	{
		$headertitle = $vbphrase['add_custom_field'] . ' - ' . $vbphrase[$customfieldtypes[$type]];
		$custom['size'] = 35;
		$custom['width'] = '';
		$custom['searchable'] = 1;
	}

	$posarray = array(
		'above_message' => $vbphrase['above_message'],
		'below_message' => $vbphrase['below_message']
	);

	// Main Options
	construct_hidden_code('custom[type]', $type);
	print_table_header($headertitle, 4);
	print_input_row($vbphrase['title'], 'custom[title]', $custom['title']);
	print_textarea_row($vbphrase['description'], 'custom[description]', $custom['description']);
	print_input_row($vbphrase['display_order'], 'custom[displayorder]', $custom['displayorder']);
	print_select_row(
		construct_phrase($vbphrase['submit_x_position'], $vbphrase['entry']),
		'custom[position_submit]',
		$posarray,
		$custom['position_submit']
	);
	print_select_row(
		construct_phrase($vbphrase['view_x_position'], $vbphrase['entry'], $vbphrase['a_entry']),
		'custom[position_display]',
		$posarray,
		$custom['position_display']
	);

	if ($type == 'text' OR $type == 'textarea')
	{
		print_input_row($vbphrase['max_length_of_allowed_user_input'], 'custom[maxlength]', $custom['maxlength']);
		print_input_row($vbphrase['field_length'], 'custom[size]', $custom['size']);
		if ($type == 'textarea')
		{
			print_input_row($vbphrase['textarea_height'], 'custom[height]', $custom['height']);
		}
	}
	else
	{
		if ($type == 'multiple_select')
		{
			print_input_row($vbphrase['select_box_size'], 'custom[size]', $custom['size']);
		}
		if ($type == 'multiple_select' OR $type == 'select')
		{
			print_input_row($vbphrase['select_box_width'], 'custom[maxlength]', $custom['maxlength']);
		}
		if ($type == 'multiple_select' OR $type == 'checkbox')
		{
			print_input_row($vbphrase['maximum_number_of_choices'], 'custom[maxchoices]', $custom['maxchoices']);
		}
		print_textarea_row(
			construct_phrase($vbphrase['x_enter_the_options_that_the_user_can_choose_from'], $vbphrase['options']),
			'custom[options]',
			unhtmlspecialchars($custom['options']),
			8,
			40
		);
	}

	print_yes_no_row($vbphrase['field_required'], 'custom[required]', $custom['required']);
	print_yes_no_row($vbphrase['field_is_searchable'], 'custom[searchable]', $custom['searchable']);
	print_yes_no_row($vbphrase['private_field'], 'custom[private]', $custom['private']);

	if ($_REQUEST['do'] == 'addcustomfield' OR $custom['catids'] == 'all')
	{
		$custom['catids'] = array('all');
	}
	else
	{
		$custom['catids'] = explode(',', $custom['catids']);
	}

	$cselect = array();
	$cselect['all'] = $vbphrase['all_categories'];
	$cselect['---'] = '--------------------------';

	foreach ($vbulletin->adv_dyna_cats AS $catids => $catinfo)
	{
		$cselect[$catids] = $catinfo['title'];
	}

	$selectbox = '<select class="bginput" tabindex="1" name="custom[catids][]" multiple="multiple" style="width:275px" size="' . iif(sizeof($vbulletin->adv_dyna_cats) + 2 >= 10, 10, sizeof($vbulletin->adv_dyna_cats) + 2) . '">
		<option value="all"' . iif($custom['catids'] == array('all'), ' selected="selected"') . '>' . $vbphrase['all_categories'] . '</option>
		<optgroup label="------------------">';

	foreach ($vbulletin->adv_dyna_cats AS $catids => $catinfo)
	{
		$selectbox .= '<option value="' . $catids . '" ' . iif(in_array($catids, $custom['catids']),'selected="selected"') . '>' . str_repeat('--', $catinfo['level']) . $catinfo['title'] . '</option>';
	}

	$selectbox .= '</optgroup></select><div class="smallfont"><input name="custom[incsubs]" id="incsubs" value="1" type="checkbox" ' . iif($custom['incsubs'], 'checked="checked" ') . '/> <label for="incsubs">' . $vbphrase['also_apply_to_subcategories'] . '</label></div>';

	print_label_row($vbphrase['categories_to_appear_in_custom_fields'], $selectbox);

	print_submit_row();
}

// ##### Do Add Custom Field ##################################################
if ($_POST['do'] == 'doaddcustomfield' OR $_POST['do'] == 'doeditcustomfield')
{
	$custom = $_POST['custom'];

	if (!trim($custom['title']))
	{
		print_stop_message(ADV_DYNA_PREFIX . '_must_choose_title_for_custom');
	}

	if (sizeof($custom['catids']) > 1 AND in_array('all', $custom['catids']))
	{
		print_stop_message(ADV_DYNA_PREFIX . '_custom_chosen_all');
	}

	$custom['catids'] = implode(',', $custom['catids']);
	$custom['options'] = htmlspecialchars($custom['options']);

	// Trim any spaces
	if ($custom['options'])
	{
		$custom['options'] = implode("\r\n", array_map('trim', explode("\r\n", $custom['options'])));
	}

	$db->query_write(fetch_query_sql($custom, ADV_DYNA_PREFIX . '_cfields', iif($_POST['do'] == 'doeditcustomfield', 'WHERE fieldid =  ' . $custom['fieldid'])));

	if ($_POST['do'] == 'doaddcustomfield')
	{
		$newfieldid = $db->insert_id();
		$db->query_write("ALTER TABLE " . ADV_DYNA_TABLE_PREFIX . "cfields_entries ADD field$newfieldid MEDIUMTEXT NOT NULL");
	}

	build_dyna_cfield_datastore();

	print_cp_redirect('vba_dyna_admin_main.php?' . $vbulletin->session->vars['sessionurl'] . 'do=customfields' . ADV_URL_PREFIX_HR, 0);
}

// ##### Delete Custom Field ##################################################
if ($_REQUEST['do'] == 'removecustomfield')
{
	$fieldid = intval($_REQUEST['fieldid']);

	$custom = $db->query_first("SELECT * FROM " . ADV_DYNA_TABLE_PREFIX . "cfields WHERE fieldid = $fieldid");

	print_dyna_form_header('vba_dyna_admin_main', 'doremovecustomfield');
	print_table_header($vbphrase['confirm_deletion']);
	construct_hidden_code('fieldid', $custom['fieldid']);
	print_description_row(
		construct_phrase($vbphrase['are_you_sure_delete_x_y'],
			$vbphrase['custom_field'],
			$custom['title'],
			$vbphrase['id'],
			$custom['fieldid']
	));
	print_submit_row($vbphrase['yes'], $vbphrase['no']);
}

// ##### Do Delete Custom Field ###############################################
if ($_POST['do'] == 'doremovecustomfield')
{
	$fieldid = intval($_POST['fieldid']);

	$db->query_write("DELETE FROM " . ADV_DYNA_TABLE_PREFIX . "cfields WHERE fieldid = $fieldid");
	$db->query_write("ALTER TABLE " . ADV_DYNA_TABLE_PREFIX . "cfields_entries DROP field$fieldid");

	build_dyna_cfield_datastore();

	print_cp_redirect('vba_dyna_admin_main.php?' . $vbulletin->session->vars['sessionurl'] . 'do=customfields' . ADV_URL_PREFIX_HR, 0);
}

// ##### Rebuild Parent Lists #################################################
if ($_REQUEST['do'] == 'rebuildparents')
{
	require_once(DIR . '/includes/vba_dyna_functions_savecat.php');
	rebuild_parents();
	update_category_cache();

	echo 'Category parents rebuilt.';
}

// ##### Update Category Cache ###############################################
if ($_REQUEST['do'] == 'updatecache')
{
	require_once(DIR . '/includes/vba_dyna_functions_savecat.php');
	update_category_cache();
	echo 'Category cache updated.';
}

print_cp_footer();

?>