<?php
// ++=========================================================================++
// || vBadvanced Dynamics v1.0.0 (vB 3.6 - vB 3.7)
// ||  2003-2007 vBadvanced.com - All Rights Reserved
// || This file may not be redistributed in whole or significant part.
// || http://vbadvanced.com
// ++ ========================================================================++

error_reporting(E_ALL & ~E_NOTICE);

$specialtemplates = array(
	'adv_dyna_attach',
	'adv_dyna_cats',
	'adv_dyna_perms'
);

$phrasegroups = array(
	'cppermission',
	'adv_dyna_cp_perms'
);

if ($_REQUEST['do'] == 'editattachperms')
{
	$phrasegroups[] = 'attachment_image';
}

require_once('./vba_dyna_admin_global.php');

if (!$_REQUEST['do'])
{
	$_REQUEST['do'] = 'permissions';
}

$permsdata = array(
	'main' => array(
		'canviewdyna' => array(
			'text' => $vbphrase['can_view_dynamics'],
			'cat' => 1,
			'guest' => 1
		),
		'canviewentries' => array(
			'text' => construct_phrase($vbphrase['can_view_x'], $vbphrase['entries']),
			'cat' => 1,
			'guest' => 1
		),
		'cansearch' => array(
			'text' => construct_phrase($vbphrase['can_search_x'], $vbphrase['entries']),
			'cat' => 1,
			'guest' => 1
		),
		'cansendtofriend' => array(
			'text' => construct_phrase($vbphrase['can_send_x_friend'], $vbphrase['entries']),
			'cat' => 1,
			'guest' => 1
		),
		'canreport' => array(
			'text' => construct_phrase($vbphrase['can_report_x_posts'], $vbphrase['entries']),
			'cat' => 1,
			'guest' => 1
		),
		'canrate' => array(
			'text' => construct_phrase($vbphrase['can_rate_x'], $vbphrase['entries']),
			'cat' => 1,
			'guest' => 1
		),
		'canseewhorated' => array(
			'text' => $vbphrase['can_see_who_rated'],
			'cat' => 1,
			'guest' => 1
		),
		'canviewdeleted' => array(
			'text' => $vbphrase['can_see_deletion_notices'],
			'cat' => 1,
			'guest' => 1
		)
	),
	'entry' => array(
		'canaddentries' => array(
			'text' => construct_phrase($vbphrase['can_add_x'], $vbphrase['entries']),
			'cat' => 1,
			'guest' => 1
		),
		'moderateentries' => array(
			'text' => construct_phrase($vbphrase['moderate_this_groups_x'], $vbphrase['entries']),
			'cat' => 1,
			'guest' => 1
		),
		'caneditentries' => array(
			'text' => construct_phrase($vbphrase['can_edit_own_x'], $vbphrase['entries']),
			'cat' => 1
		),
		'caneditothers' => array(
			'text' => construct_phrase($vbphrase['can_edit_others_x'], $vbphrase['entries']),
			'cat' => 1
		),
		'candelete' => array(
			'text' => construct_phrase($vbphrase['can_delete_own_x'], $vbphrase['entries']),
			'cat' => 1
		),
		'catdeleteothers' => array(
			'text' => construct_phrase($vbphrase['can_delete_others_x'], $vbphrase['entries']),
			'cat' => 1
		),
		'canharddelete' => array(
			'text' => construct_phrase($vbphrase['can_physically_remove_x'], $vbphrase['entries']),
			'cat' => 1
		),
		'canopenclose' => array(
			'text' => construct_phrase($vbphrase['can_open_close_own_x'], $vbphrase['entries']),
			'cat' => 1
		),
		'caneditdateline' => array(
			'text' => construct_phrase($vbphrase['can_modify_x_date'], $vbphrase['entries']),
			'cat' => 1
		),
		'cansetfeatured' => array(
			'text' => construct_phrase($vbphrase['can_set_featured_x'], $vbphrase['entries']),
			'cat' => 1
		),
		'cansubmitothers' => array(
			'text' => construct_phrase($vbphrase['can_submit_x_as_other_members'], $vbphrase['entries']),
			'cat' => 1
		)
	),
	'attach' => array(
		'canviewattach' => array(
			'text' => $vbphrase['can_view_attachments'],
			'cat' => 1,
			'guest' => 1
		),
		'canviewthumb' => array(
			'text' => $vbphrase['can_view_thumbnails'],
			'cat' => 1,
			'guest' => 1
		),
		'canattach' => array(
			'text' => $vbphrase['can_upload_attachments'],
			'cat' => 1,
			'guest' => 1
		),
		'moderateattach' => array(
			'text' => construct_phrase($vbphrase['moderate_this_groups_x'], $vbphrase['attachments']),
			'cat' => 1,
			'guest' => 1
		),
		'canftpattach' => array(
			'text' => $vbphrase['can_upload_via_ftp'],
			'guest' => 1
		),
		'attachspace' => array(
			'text' => $vbphrase['total_space_attachments_may_consume'],
			'text_desc' => $vbphrase['total_space_attachments_may_consume_desc'],
			'limit' => 1,
			'noattach' => 1
		),
		'maxdownloadsize' => array(
			'text' => $vbphrase['maximum_attachment_download_size'],
			'text_desc' => $vbphrase['maximum_attachment_download_size_desc'],
			'guest' => 1,
			'limit' => 1
		)
	),
	'category' => array(
		'cancreatecats' => array(
			'text' => construct_phrase($vbphrase['can_create_x'], $vbphrase['categories']),
			'guest' => 1
		),
		'maxcats' => array(
			'text' => $vbphrase['maximum_number_of_categories'],
			'text_desc' => $vbphrase['maximum_number_of_categories_desc'],
			'limit' => 1
		),
		'moderatecats' => array(
			'text' => construct_phrase($vbphrase['moderate_this_groups_x'], $vbphrase['categories']),
			'guest' => 1
		),
		'caneditcats' => array(
			'text' => construct_phrase($vbphrase['can_edit_own_x'], $vbphrase['categories'])
		),
		'canemptycats' => array(
			'text' => construct_phrase($vbphrase['can_empty_x'], $vbphrase['categories'])
		),
		'candeletecats' => array(
			'text' => construct_phrase($vbphrase['can_delete_own_x'], $vbphrase['categories'])
		),
		'cancatmoderate' => array(
			'text' => construct_phrase($vbphrase['give_x_owners_moderator_abilites'], $vbphrase['category'])
		),
		'canpasswordcats' => array(
			'text' => construct_phrase($vbphrase['can_set_password'], $vbphrase['categories']),
			'guest' => 1
		),
		'cancaticon' => array(
			'text' => construct_phrase($vbphrase['can_upload_x_icons'], $vbphrase['category']),
			'guest' => 1
		),
		'cancatstyle' => array(
			'text' => construct_phrase($vbphrase['can_choose_style_for_x'], $vbphrase['categories']),
			'guest' => 1
		)
	),
	'posting' => array(
		'canviewreplies' => array(
			'text' => construct_phrase($vbphrase['can_view_replies_to_x'], $vbphrase['entries']),
			'cat' => 1,
			'guest' => 1
		),
		'canreply' => array(
			'text' => construct_phrase($vbphrase['can_reply_to_own_x'], $vbphrase['entries']),
			'cat' => 1,
			'guest' => 1
		),
		'canreplyothers' => array(
			'text' => construct_phrase($vbphrase['can_reply_to_others_x'], $vbphrase['entries']),
			'cat' => 1,
			'guest' => 1
		),
		'moderateposts' => array(
			'text' => construct_phrase($vbphrase['moderate_this_groups_x'], $vbphrase['posts']),
			'cat' => 1,
			'guest' => 1
		),
		'caneditposts' => array(
			'text' => $vbphrase['can_edit_own_posts'],
			'cat' => 1
		),
		'caneditothersposts' => array(
			'text' => $vbphrase['can_edit_others_posts'],
			'cat' => 1
		),
		'caneditpostdateline' => array(
			'text' => construct_phrase($vbphrase['can_modify_x_date'], $vbphrase['post']),
			'cat' => 1
		),
		'candeleteposts' => array(
			'text' => $vbphrase['can_delete_own_posts'],
			'cat' => 1
		),
		'candeleteothersposts' => array(
			'text' => $vbphrase['can_delete_others_posts'],
			'cat' => 1
		),
		'canharddeleteposts' => array(
			'text' => construct_phrase($vbphrase['can_physically_remove_x'], $vbphrase['posts']),
			'cat' => 1
		)
	),
	'module' => array(
		'canmodule' => array(
			'text' => construct_phrase($vbphrase['can_customize_x'], $vbphrase['modules'])
		),
		'canaddmodule' => array(
			'text' => construct_phrase($vbphrase['can_add_custom_x'], $vbphrase['modules'])
		)
	),
	'guestbook' => array(
		'gb_canview' => array(
			'text' => $vbphrase['can_view_others_guest_book'],
			'guest' => 1
		),
		'gb_canreply' => array(
			'text' => $vbphrase['can_reply_to_others_guest_book'],
			'guest' => 1
		),
		'gb_caneditown' => array(
			'text' => $vbphrase['can_edit_own_replies_in_others_guest_book']
		),
		'gb_candeleteown' => array(
			'text' => $vbphrase['can_delete_own_replies_in_others_guest_book']
		),
		'gb_candeleteothersinown' => array(
			'text' => $vbphrase['can_delete_replies_in_own_guest_book']
		),
		'gb_caneditothersinown' => array(
			'text' => $vbphrase['can_edit_others_replies_in_own_guest_book']
		),
		'gb_canphysremove' => array(
			'text' => construct_phrase($vbphrase['can_physically_remove_x'], $vbphrase['posts'])
		)
	)
);

$permgroupphrase = array(
	'main' => $vbphrase['main_options'],
	'entry' => construct_phrase($vbphrase['x_adding_editing_options'], $vbphrase['entry']),
	'attach' => construct_phrase($vbphrase['x_options'], $vbphrase['attachment']),
	'category' => construct_phrase($vbphrase['x_options'], $vbphrase['category']),
	'posting' => $vbphrase['posting_options'],
	'module' => construct_phrase($vbphrase['x_options'], $vbphrase['module']),
	'guestbook' => $vbphrase['guest_book']
);

($hook = vBulletinHook::fetch_hook('vba_dyna_cp_perms_start')) ? eval($hook) : false;

// ################## Edit Permissions For Usergroup ##########################
if ($_REQUEST['do'] == 'permissions')
{
	$groupid = intval($_REQUEST['u']);

	// Make an array for the select options
	foreach ($vbulletin->usergroupcache AS $ugroupid => $group)
	{
		$grouparray[$ugroupid] = $group['title'];
	}

	// Editing a specific group
	if ($groupid)
	{
		$usergroup = $vbulletin->adv_dyna_perms[$groupid];
		$grouptitle = $grouparray[$groupid];
	}

	print_dyna_form_header('vba_dyna_admin_permissions', 'permissions', false, true, 'cpform', '90%', '', true, 'get');
	print_table_header(iif($groupid, $grouptitle, $vbphrase['modify_permissions']));

	print_description_row($vbphrase['usergroup'] . ': <select name="u" class="bginput" onchange="submit();">' . construct_select_options($grouparray, $groupid) . '</select> <input class="button" type="submit" value="' . $vbphrase['go'] . '" />', 0, 1, '', 'center');
	print_table_footer();

	// ##### Main page, no user group
	if (!$groupid)
	{
		print_dyna_form_header('', '');
		print_table_header(construct_phrase($vbphrase['x_tools'], $vbphrase['permissions']));
		print_description_row('<strong>' .
			construct_link_code(
				$vbphrase['duplicate_permissions'],
				'vba_dyna_admin_permissions.php?' . $vbulletin->session->vars['sessionurl'] . 'do=duplicateperms' . ADV_URL_PREFIX_HR
			) .
			' - ' .
			construct_link_code(
				$vbphrase['view_permissions'],
				'vba_dyna_admin_permissions.php?' . $vbulletin->session->vars['sessionurl'] . 'do=viewperms' . ADV_URL_PREFIX_HR
			) . '</strong>',
			false, 2, '', 'center'
		);
		print_table_footer();
	}
	// ##### Editing usergroup
	else
	{
		print_dyna_form_header('vba_dyna_admin_permissions', 'updateperms');
		construct_hidden_code('groupid', $groupid);

		$perms = array();
		foreach ($vba_dyna->_permbits AS $permgroup => $permarray)
		{
			$perms = array_merge($perms, convert_bits_to_array($usergroup['dyna_perms'][$permgroup], $permarray));
		}

		print_label_row('<b>' . $grouptitle . '</b>',
			'<input id="checkall2" name="checkall" onclick="js_check_all_option(this.form, 1);" type="button" value="' . $vbphrase['all_yes'] . '" />
			 <input id="checkall2" name="checkall" onclick="js_check_all_option(this.form, 0);" type="button" value="' . $vbphrase['all_no'] . '" />',
			'tcat'
		);

		print_permission_rows();

		print_submit_row($vbphrase['save']);
	}
}

// ######################## Do Update Permissions #####################
if ($_POST['do'] == 'updateperms')
{
	$vbulletin->input->clean_array_gpc('p', array(
		'usergroup' => TYPE_ARRAY,
		'groupid' => TYPE_INT
	));

	require_once(DIR . '/includes/functions_misc.php');

	$newperms = array();
	foreach ($vbulletin->GPC['usergroup'] AS $permgroup => $permarray)
	{
		if ($permgroup == 'limit')
		{
			$newperms['limit'] = $permarray;
		}
		else
		{
			$newperms['dyna_perms'][$permgroup] = convert_array_to_bits($permarray, $vba_dyna->_permbits[$permgroup], 1);
		}
	}

	$vbulletin->adv_dyna_perms[$vbulletin->GPC['groupid']] = $newperms;

	build_datastore(ADV_DYNA_PREFIX . '_perms', serialize($vbulletin->adv_dyna_perms), 1);

	define('CP_REDIRECT', 'vba_dyna_admin_permissions.php?' . $vbulletin->session->vars['sessionurl'] . 'do=permissions' . ADV_URL_PREFIX_HR);
	print_stop_message('saved_usergroup_x_successfully', $usergrouptitle);
}

// ##### View Permissions #####################################################
if ($_REQUEST['do'] == 'viewperms')
{
	$vbulletin->input->clean_gpc('r', 'showcats', TYPE_INT);

	// Usergroup row
	$titlerow = array($vbphrase['permissions']);
	foreach ($vbulletin->usergroupcache AS $groupid => $group)
	{
		$titlerow[] = '<div class="smallfont">' . $group['title'] . '</span>';
	}

	$tableoutput = array();
	foreach ($permsdata AS $permvar => $perminfo)
	{
		$tableoutput[$permvar][] = $perminfo['text'];
	}

	echo '<style type="text/css"><!--
		.redx { color: #D00000; }
		.grnc { color: #00D020; }
		.inset { border:2px inset }
		.bold { font-weight: bold; font-style: italic; }
	--></style>';

	$groupcolspan = sizeof($vbulletin->usergroupcache) + 1;


	// ##### Main Usergroup Permissions

	print_dyna_form_header('', '');
	print_table_header($vbphrase['view_permissions'], $groupcolspan);
	print_cells_row($titlerow, 1);

	foreach ($permgroupphrase AS $permgroup => $permtitle)
	{
		print_table_header('<span class="smallfont">' . $permgroupphrase[$permgroup] . '</span>', $groupcolspan, false, '', $stylevar['left']);

		foreach ($permsdata[$permgroup] AS $permvar => $pinfo)
		{
			exec_switch_bg();
			echo '<tr><td class="' . $bgclass . '" style="white-space: nowrap">' . $pinfo['text'] . '</td>';

			foreach ($vbulletin->usergroupcache AS $groupid => $group)
			{
				echo '<td class="' . $bgclass . '" align="center">';
				switch ($permvar)
				{
					case 'maxcats':
						echo '<span style="white-space: nowrap">' . ($vbulletin->adv_dyna_perms[$groupid]['limit']['maxcats'] ? intval($vbulletin->adv_dyna_perms[$groupid]['limit']['maxcats']) : $vbphrase['unlimited']) . '</span>';
					break;

					case 'attachspace':
						echo ($vbulletin->adv_dyna_perms[$groupid]['limit']['attachspace']) ? '<span style="white-space: nowrap">' . fetch_rfilesize($vbulletin->adv_dyna_perms[$groupid]['limit']['attachspace']) . '</span>' : $vbphrase['unlimited'];
					break;

					default:

						// Format into an array so it can be used to compare category perms below
						$defperms[$groupid][$permgroup] = convert_bits_to_array(
							$vbulletin->adv_dyna_perms[$groupid]['dyna_perms'][$permgroup],
							$vba_dyna->_permbits[$permgroup]
						);

						echo iif($defperms[$groupid][$permgroup][$permvar], '<span class="grnc">&radic;</span>', '<span class="redx">X</span>');
				}

				echo '</td>';
			}
			echo '</tr>';
		}
	}

	print_table_footer();

	// ##### Category Permissions

	// Get the specific cat perms
	$catpermcache = array();
	$catperms = $db->query_read("SELECT catid, usergroupid, permissions FROM " . ADV_DYNA_TABLE_PREFIX . "categoryperms");
	while ($catperm = $db->fetch_array($catperms))
	{
		$catpermcache[$catperm['catid']][$catperm['usergroupid']] = unserialize($catperm['permissions']);
	}

	print_dyna_form_header('', '');
	print_table_header(construct_phrase($vbphrase['x_permissions'], $vbphrase['category']), $groupcolspan);
	print_description_row(
		construct_phrase(
			$vbphrase['permissions_color_key'],
			$vbphrase['permissions_color_key_inherited'] . '<li class="col-g" style="padding-top: 8px">' . $vbphrase['brackets_permission_setting_different_from_default'] . '</li>'
		),
		false,
		$groupcolspan
	);
	print_table_break();

	foreach ($vbulletin->adv_dyna_cats AS $catid => $catinfo)
	{
		print_table_header(str_repeat(' -- ', $catinfo['level']) . $catinfo['title'], $groupcolspan, false, '', $stylevar['left']);

		// No custom permissions
		if (!$catinfo['permissions'])
		{
			print_description_row($vbphrase['using_default_permissions'], false, $groupcolspan);
		}
		// Custom permission, print out the title
		else
		{
			$titlerow = array('');
			foreach ($vbulletin->usergroupcache AS $groupid => $group)
			{
				if ($catpermcache[$catid][$groupid])
				{
					$class = ' col-c bold';
				}
				else if ($catinfo['parent'] AND $catpermcache[$catinfo['parent']][$group['usergroupid']])
				{
					$class = ' col-i bold';
					$catpermcache[$catid][$groupid] = true;
				}
				else
				{
					$class = ' col-g';
				}

				$titlerow[] = '<div class="smallfont' . $class . '">' . $group['title'] . '</div>';
			}

			print_cells_row($titlerow, false, 'darkbg inset', 1);

			// Loop through the permission groups
			foreach ($permgroupphrase AS $permgroup => $permtitle)
			{
				if ($permgroup == 'category' OR $permgroup == 'module' OR $permgroup == 'guestbook')
				{
					continue;
				}

				// Loop through the permissions
				foreach ($permsdata[$permgroup] AS $permvar => $pinfo)
				{
					if (!$pinfo['cat'])
					{
						continue;
					}

					exec_switch_bg();

					echo '<tr align="center"><td class="' . $bgclass . '" style="white-space: nowrap" align="' . $stylevar['left'] . '">' . $pinfo['text'] . '</td>';

					// Loop through the usergroups
					foreach ($vbulletin->usergroupcache AS $groupid => $group)
					{
						echo '<td class="' . $bgclass . '">';

						$perms = convert_bits_to_array(
							iif($catinfo['permissions'][$groupid],
								$catinfo['permissions'][$groupid][$permgroup],
								$vbulletin->adv_dyna_perms[$groupid]['dyna_perms'][$permgroup]
							),
							$vba_dyna->_permbits[$permgroup]
						);

						$boldclass = '';
						$bracket_start = '';
						$bracket_end = '';

						if ($perms[$permvar] != $defperms[$groupid][$permgroup][$permvar])
						{
							$bracket_start = '[';
							$bracket_end = ']';
							$boldclass = ' bold';
						}

						echo $bracket_start . iif($perms[$permvar],
							'<span class="grnc' . $boldclass . '">&radic;',
							'<span class="redx' . $boldclass . '">X'
						) . '</span>' . $bracket_end . '</td>';
					}
					echo '</tr>';
				}
			}
		}
		print_table_break();
	}

	print_table_footer();
}

// ##### Duplicate Permissions ################################################
if ($_REQUEST['do'] == 'duplicateperms')
{
	$usergroups = array();
	$groupinputs = '';
	foreach ($vbulletin->usergroupcache AS $groupid => $group)
	{
		$usergroups[$groupid] = $group['title'];
		$groupinputs .= '<div><input name="togroups[]" type="checkbox" value="' . $groupid . '" id="togroup_' . $groupid . '" /> <label for="togroup_' . $groupid . '">' . $group['title'] . '</label></div>';
	}

	print_dyna_form_header('vba_dyna_admin_permissions', 'doduplicate');
	print_table_header($vbphrase['duplicate_permissions']);
	print_select_row($vbphrase['copy_permissions_from_group'], 'fromgroup', $usergroups);
	print_label_row($vbphrase['copy_permissions_to_groups'], $groupinputs);
	print_yes_no_row($vbphrase['copy_main_permissions'], 'copymain', 1);
	print_yes_no_row($vbphrase['copy_category_permissions'], 'copycat', 1);
	print_submit_row($vbphrase['submit']);
}

// ##### Do Duplicate Permissions #############################################
if ($_POST['do'] == 'doduplicate')
{
	$vbulletin->input->clean_array_gpc('p', array(
		'fromgroup' => TYPE_INT,
		'togroups' => TYPE_ARRAY_INT,
		'copymain' => TYPE_INT,
		'copycat' => TYPE_INT
	));

	// ##### Check for problems
	if (empty($vbulletin->GPC['togroups']))
	{
		print_stop_message(ADV_DYNA_PREFIX . '_did_not_choose_groups_copy_to');
	}

	if (empty($vbulletin->adv_dyna_perms[$vbulletin->GPC['fromgroup']]))
	{
		print_stop_message(ADV_DYNA_PREFIX . '_group_has_no_permissions');
	}

	if (!$vbulletin->GPC['copymain'] AND !$vbulletin->GPC['copycat'])
	{
		print_stop_message(ADV_DYNA_PREFIX . '_did_not_choose_any_permissions_to_update');
	}

	// ##### Copy main permissions
	if ($vbulletin->GPC['copymain'])
	{
		foreach ($vbulletin->GPC['togroups'] AS $copygroupid)
		{
			$vbulletin->adv_dyna_perms[$copygroupid] = $vbulletin->adv_dyna_perms[$vbulletin->GPC['fromgroup']];
		}
		build_datastore(ADV_DYNA_PREFIX . '_perms', serialize($vbulletin->adv_dyna_perms), 1);
	}

	// ##### Copy category permissions
	if ($vbulletin->GPC['copycat'])
	{
		$db->query_write("
			DELETE FROM " . ADV_DYNA_TABLE_PREFIX . "categoryperms
			WHERE usergroupid IN(" . implode(', ', $vbulletin->GPC['togroups']) . ")
		");

		$havecatperms = false;
		$catinsert = 'INSERT INTO ' . ADV_DYNA_TABLE_PREFIX . 'permissions (catid, usergroupid, permissions) VALUES ';
		$getcatperms = $db->query_read("
			SELECT catid, permissions
			FROM " . ADV_DYNA_TABLE_PREFIX . "categoryperms
			WHERE usergroupid = " . $vbulletin->GPC['fromgroup']
		);
		while ($catperms = $db->fetch_array($getcatperms))
		{
			$havecatperms = true;

			foreach ($vbulletin->GPC['togroups'] AS $togroupid)
			{
				$catinsert .= ' (' . $catperms['catid'] . ', ' . $togroupid . ', \'' . $db->escape_string($catperms['permissions']) . '\'),';
			}
		}

		if ($havecatperms)
		{
			$db->query_write(substr($catinsert, 0, (strlen($catinsert) - 1)));
		}
	}

	define('CP_REDIRECT', 'vba_dyna_admin_permissions.php?' . $vbulletin->session->vars['sessionurl'] . 'do=permissions' . ADV_URL_PREFIX_HR);
	print_stop_message('duplicated_permissions_successfully');
}

// ##### Edit Cateogry Permissions ############################################
if ($_REQUEST['do'] == 'categorypermissions')
{
	$catinfo = array();

	$getcats = $db->query_read("
		SELECT catid, title, parent, hasentries, displayorder
		FROM " . ADV_DYNA_TABLE_PREFIX . "categories
		ORDER BY $vba_options[dyna_catsorder] $vba_options[dyna_catsdir], hasentries
	");
	while ($categories = $vbulletin->db->fetch_array($getcats))
	{
		$catinfo[] = $categories;
	}

	$db->free_result($getcats);
	unset($categories);

	$usergroupperms = $db->query_read("SELECT * FROM " . ADV_DYNA_TABLE_PREFIX . "categoryperms");
	while ($uperms = $vbulletin->db->fetch_array($usergroupperms))
	{
		$usergroup['title'] = $vbulletin->usergroupcache[$groupid]['title'];
		$hasperms[$uperms['usergroupid']][$uperms['catid']] = true;
	}

	print_dyna_form_header('', '');
	print_table_header(construct_phrase($vbphrase['x_permissions'], $vbphrase['category']));
	print_description_row(construct_phrase($vbphrase['permissions_color_key'], $vbphrase['permissions_color_key_inherited']));
	print_table_break();

	print_description_row('<div class="darkbg" style="border: 2px inset">' . print_category_perm_rows($catinfo, 0) . '</div>');
	print_table_footer();
}

// ######################## Edit Permissions for Category #####################
if ($_REQUEST['do'] == 'editcategoryperms')
{
	$groupid = intval($_REQUEST['u']);
	$catid = intval($_REQUEST['c']);

	?>
	<script type="text/javascript">
	<!--
	function js_set_custom()
	{
		if (document.cpform.useusergroup[1].checked == false)
		{
			if (confirm("<? echo $vbphrase['for_setting_to_have_effect_custom_permissions_must_be_enabled']; ?>"))
			{
				document.cpform.useusergroup[1].checked = true;
				return true;
			}
			else
			{
				return false;
			}
		}
		else
		{
			return true;
		}
	}
	// -->
	</script>
	<?php

	$vba_dyna->default_permissions(array($groupid));

	if ($usergroup = $db->query_first("SELECT * FROM " . ADV_DYNA_TABLE_PREFIX . "categoryperms WHERE usergroupid = $groupid AND catid = $catid"))
	{
		$usergroup['permissions'] = unserialize($usergroup['permissions']);
		$perms = array();
		foreach ($vba_dyna->_permbits AS $permgroup => $permarray)
		{
			$perms = array_merge($perms, convert_bits_to_array($usergroup['permissions'][$permgroup], $permarray));
		}
	}
	else
	{
		$vba_dyna->fetch_category_perms($catid, $groupid);
		$perms = $vba_dyna->_catperms[$catid];
	}

	$grouptitle = $vbulletin->usergroupcache[$groupid]['title'];
	$cattitle = $vbulletin->adv_dyna_cats[$catid]['title'];

	print_dyna_form_header('vba_dyna_admin_permissions', 'doeditcatperms');
	construct_hidden_code('usergroupid', $groupid);
	construct_hidden_code('catid', $catid);
	construct_hidden_code('usergrouptitle', $grouptitle);

	print_table_header(construct_phrase($vbphrase['edit_category_permissions_for_usergroup_x_in_category_y'], $grouptitle, $cattitle));

	print_description_row('
		<label for="useusergroup_0"><input ' . iif(!isset($usergroup['permissions']), ' checked="checked"') . ' id="useusergroup_0" name="useusergroup" onclick="this.form.reset(); this.checked=true;" type="radio" value="0" />' . $vbphrase['use_default_permissions_note_delete_previous_permissions_set'] . '</label>
		<br />
		<label for="useusergroup_1"><input id="useusergroup_1" ' . iif(isset($usergroup['permissions']), ' checked="checked"') . ' name="useusergroup" type="radio" value="1" />' . $vbphrase['use_custom_permissions'] . '</label>
	', 0, 2, 'tfoot', '' , 'mode');
	print_table_break();

	print_table_break();

	print_label_row('<b>' . $grouptitle . '</b>',
		'<input id="checkall" name="checkall" onclick="if (js_set_custom()) { js_check_all_option(this.form, 1); }" type="button" value="' . $vbphrase['all_yes'] . '" />
		<input id="checkall" name="checkall" onclick="if (js_set_custom()) { js_check_all_option(this.form, 0); }" type="button" value="' . $vbphrase['all_no'] . '" />', 'tcat');

	$permsdata['main']['canviewdyna']['text'] = construct_phrase($vbphrase['can_view_x'], $vbphrase['category']);

	print_permission_rows('category');

	print_submit_row($vbphrase['save']);
}

// ###################### Do Add/Edit Category Permissions ####################
if ($_POST['do'] == 'doeditcatperms')
{
	$vbulletin->input->clean_array_gpc('p', array(
		'usergroup' => TYPE_ARRAY,
		'usergroupid' => TYPE_INT,
		'useusergroup' => TYPE_INT,
		'catid' => TYPE_INT
	));

	require_once(DIR . '/includes/functions_misc.php');

	$perms = array();
	foreach ($vbulletin->GPC['usergroup'] AS $permgroup => $permarray)
	{
		$perms[$permgroup] = convert_array_to_bits($permarray, $vba_dyna->_permbits[$permgroup], 1);
	}

	$checkexists = $db->query_first("
		SELECT permissionid
		FROM " . ADV_DYNA_TABLE_PREFIX . "categoryperms
		WHERE catid = " . $vbulletin->GPC['catid'] . "
			AND usergroupid = " . $vbulletin->GPC['usergroupid']
	);

	if (!$vbulletin->GPC['useusergroup'] AND $checkexists['permissionid'])
	{
		$db->query_write("
			DELETE FROM " . ADV_DYNA_TABLE_PREFIX . "categoryperms
			WHERE usergroupid = " . $vbulletin->GPC['usergroupid'] . "
				AND catid = " . $vbulletin->GPC['catid']
		);
	}

	if ($vbulletin->GPC['useusergroup'])
	{
		if ($checkexists['permissionid'])
		{
			$db->query_write("
				UPDATE " . ADV_DYNA_TABLE_PREFIX . "categoryperms SET
					permissions = '" . $db->escape_string(serialize($perms)) . "'
				WHERE usergroupid = " . $vbulletin->GPC['usergroupid'] . "
					AND catid = " . $vbulletin->GPC['catid']
			);
		}
		else
		{
			$db->query_write("
				INSERT INTO " . ADV_DYNA_TABLE_PREFIX . "categoryperms
					(catid, usergroupid, permissions)
				VALUES (
					" . $vbulletin->GPC['catid'] . ",
					" . $vbulletin->GPC['usergroupid'] . ",
					'" . $db->escape_string(serialize($perms)) . "'
			)");
		}
	}

	require_once(DIR . '/includes/vba_dyna_functions_savecat.php');
	update_category_cache();

	print_cp_redirect('vba_dyna_admin_permissions.php?' . $vbulletin->session->vars['sessionurl'] . 'do=categorypermissions' . ADV_URL_PREFIX_HR, 0);
}

// ######################### Reset Category Permissions ######################
if ($_REQUEST['do'] == 'resetperms')
{
	$catid = intval($_REQUEST['catid']);

	$db->query_write("DELETE FROM " . ADV_DYNA_TABLE_PREFIX . "categoryperms WHERE catid = $catid");

	require_once(DIR . '/includes/vba_dyna_functions_savecat.php');
	update_category_cache();

	print_cp_redirect('vba_dyna_admin_permissions.php?' . $vbulletin->session->vars['sessionurl'] . 'do=categorypermissions' . ADV_URL_PREFIX_HR, 0);
}

// ############################ Deny All Permission ###########################
if ($_REQUEST['do'] == 'denyperms')
{
	$usergroups = $db->query_read("SELECT usergroupid FROM " . TABLE_PREFIX . "usergroup");
	while ($usergroup = $vbulletin->db->fetch_array($usergroups))
	{
		$db->query_write("
			INSERT INTO " . ADV_DYNA_TABLE_PREFIX . "categoryperms
				(catid, usergroupid, permissions)
			VALUES (
				" . intval($_REQUEST['catid']) . ",
				'$usergroup[usergroupid]',
				0
		)");
	}

	require_once(DIR . '/includes/vba_dyna_functions_savecat.php');
	update_category_cache();

	print_cp_redirect('vba_dyna_admin_permissions.php?' . $vbulletin->session->vars['sessionurl'] . 'do=categorypermissions' . ADV_URL_PREFIX_HR, 0);
}

// ##### Attachment Permissions ###############################################
if ($_REQUEST['do'] == 'attachperms')
{
	$hasperms = array();
	$usergroupperms = $db->query_read("SELECT * FROM " . ADV_DYNA_TABLE_PREFIX . "attachmentperms");
	while ($uperms = $vbulletin->db->fetch_array($usergroupperms))
	{
		$usergroup['title'] = $vbulletin->usergroupcache[$uperms['usergroupid']]['title'];
		$hasperms[$uperms['extension']][$uperms['usergroupid']] = true;
	}

	print_dyna_form_header('', '');
	print_table_header(construct_phrase($vbphrase['x_permissions'], $vbphrase['category']));
	print_description_row(construct_phrase($vbphrase['permissions_color_key'], ''));
	print_table_break();

	$permbits = '<ul class="lsq">';

	if (!empty($vbulletin->adv_dyna_attach))
	{
		foreach ($vbulletin->adv_dyna_attach AS $ext => $attach)
		{
			$permbits .= '<li><strong>.' . strtoupper($ext) . '</strong> <span class="smallfont">( ' .
				construct_link_code(
					$vbphrase['reset'],
					'vba_dyna_admin_permissions.php?do=resetattachperms&amp;ext=' . $ext . ADV_URL_PREFIX
				) .
				construct_link_code(
					$vbphrase['deny_all'],
					'vba_dyna_admin_permissions.php?do=denyattachperms&amp;ext=' . $ext . ADV_URL_PREFIX
				) .
			' )</li>';

			$permbits .= '<ul class="usergroups">';

			foreach ($vbulletin->usergroupcache AS $group)
			{
				$permclass = '';
				if ($hasperms[$ext][$group['usergroupid']])
				{
					$permclass = ' class="col-c"';
				}

				$permbits .= '<li' . $permclass . '>' .
					construct_link_code(
						$vbphrase['edit'],
						'vba_dyna_admin_permissions.php?do=editattachperms&amp;ext=' . $ext . '&amp;groupid=' . $group['usergroupid'] . ADV_URL_PREFIX
					) .
				$group['title'] . '</li>';
			}

			$permbits .= '</ul><br />';

		}
	}

	$permbits .= '</ul>';

	print_description_row('<div class="darkbg" style="border: 2px inset">' . $permbits . '</div>');
	print_table_footer();
}

// ##### Edit Permissions For Extension #######################################
if ($_REQUEST['do'] == 'editattachperms')
{
	$vbulletin->input->clean_array_gpc('r', array(
		'groupid' => TYPE_INT,
		'ext' => TYPE_NOHTML
	));

	?>
	<script type="text/javascript">
	<!--
	function js_set_custom()
	{
		if (document.cpform.useusergroup[1].checked == false)
		{
			if (confirm("<? echo $vbphrase['for_setting_to_have_effect_custom_permissions_must_be_enabled']; ?>"))
			{
				document.cpform.useusergroup[1].checked = true;
				return true;
			}
			else
			{
				return false;
			}
		}
		else
		{
			return true;
		}
	}
	// -->
	</script>
	<?php

	$vba_dyna->default_permissions(array($vbulletin->GPC['groupid']));

	if ($usergroup = $db->query_first("
			SELECT *
			FROM " . ADV_DYNA_TABLE_PREFIX . "attachmentperms
			WHERE usergroupid = " . $vbulletin->GPC['groupid'] . "
				AND extension = '" . $db->escape_string($vbulletin->GPC['ext']) . "'
	"))
	{
		$usergroup['permissions'] = unserialize($usergroup['permissions']);
		$usergroup['limit'] = $usergroup['permissions']['limit'];
		$usergroup['setting'] = $usergroup['permissions']['setting'];

		$perms = convert_bits_to_array($usergroup['permissions']['attach'], $vba_dyna->_permbits['attach']);
	}
	else
	{
		$vba_dyna->fetch_attachment_perms($vbulletin->GPC['ext'], $vbulletin->GPC['groupid']);

		$usergroup['limit']['attachspace'] = $vba_dyna->_permissions['attachspace'];
		$usergroup['limit']['maxdownloadsize'] = $vba_dyna->_permissions['maxdownloadsize'];

		$usergroup['setting'] = $vbulletin->adv_dyna_attach[$vbulletin->GPC['ext']];

		$perms = $vba_dyna->_attachperms[$vbulletin->GPC['ext']];
	}

	$grouptitle = $vbulletin->usergroupcache[$vbulletin->GPC['groupid']]['title'];

	print_dyna_form_header('vba_dyna_admin_permissions', 'doeditattachperms');
	construct_hidden_code('usergroupid', $vbulletin->GPC['groupid']);
	construct_hidden_code('ext', $vbulletin->GPC['ext']);
	construct_hidden_code('usergrouptitle', $grouptitle);

	print_table_header(construct_phrase($vbphrase['edit_attachment_permissions_for_usergroup_x_and_extension_y'], $grouptitle, strtoupper($vbulletin->GPC['ext'])));

	print_description_row('
		<label for="useusergroup_0"><input ' . iif(!isset($usergroup['permissions']), ' checked="checked"') . ' id="useusergroup_0" name="useusergroup" onclick="this.form.reset(); this.checked=true;" type="radio" value="0" />' . $vbphrase['use_default_permissions_note_delete_previous_permissions_set'] . '</label>
		<br />
		<label for="useusergroup_1"><input id="useusergroup_1" ' . iif(isset($usergroup['permissions']), ' checked="checked"') . ' name="useusergroup" type="radio" value="1" />' . $vbphrase['use_custom_permissions'] . '</label>
	', 0, 2, 'tfoot', '' , 'mode');
	print_table_break();

	print_table_break();

	print_label_row('<b>' . $grouptitle . '</b>',
		'<input id="checkall" name="checkall" onclick="if (js_set_custom()) { js_check_all_option(this.form, 1); }" type="button" value="' . $vbphrase['all_yes'] . '" />
		<input id="checkall" name="checkall" onclick="if (js_set_custom()) { js_check_all_option(this.form, 0); }" type="button" value="' . $vbphrase['all_no'] . '" />', 'tcat');

	print_permission_rows('attach');

	print_input_row(
		$vbphrase['maximum_filesize_dfn'],
		'usergroup[setting][size]',
		$usergroup['setting']['size'],
		true,
		'35" onchange="js_set_custom();"'
	);
	print_input_row(
		$vbphrase['max_width_dfn'],
		'usergroup[setting][width]',
		$usergroup['setting']['width'],
		true,
		'35" onchange="js_set_custom();"'
	);
	print_input_row(
		$vbphrase['max_height_dfn'],
		'usergroup[setting][height]',
		$usergroup['setting']['height'],
		true,
		'35" onchange="js_set_custom();"'
	);

	print_submit_row($vbphrase['save']);
}

// ##### Do Add/Edit Permissions for Extension ################################
if ($_POST['do'] == 'doeditattachperms')
{
	$vbulletin->input->clean_array_gpc('p', array(
		'usergroup' => TYPE_ARRAY,
		'usergroupid' => TYPE_INT,
		'useusergroup' => TYPE_INT,
		'ext' => TYPE_NOHTML
	));

	require_once(DIR . '/includes/functions_misc.php');

	$perms = array();
	$perms['attach'] = convert_array_to_bits($vbulletin->GPC['usergroup']['attach'], $vba_dyna->_permbits['attach'], 1);
	$perms['limit'] = $vbulletin->GPC['usergroup']['limit'];
	$perms['setting'] = $vbulletin->GPC['usergroup']['setting'];

	$checkexists = $db->query_first("
		SELECT permissionid
		FROM " . ADV_DYNA_TABLE_PREFIX . "attachmentperms
		WHERE extension = '" . $db->escape_string($vbulletin->GPC['ext']) . "'
			AND usergroupid = " . $vbulletin->GPC['usergroupid']
	);

	if (!$vbulletin->GPC['useusergroup'] AND $checkexists['permissionid'])
	{
		$db->query_write("
			DELETE FROM " . ADV_DYNA_TABLE_PREFIX . "attachmentperms
			WHERE usergroupid = " . $vbulletin->GPC['usergroupid'] . "
				AND extension = '" . $db->escape_string($vbulletin->GPC['ext']) . "'
		");
	}

	if ($vbulletin->GPC['useusergroup'])
	{
		if ($checkexists['permissionid'])
		{
			$db->query_write("
				UPDATE " . ADV_DYNA_TABLE_PREFIX . "attachmentperms SET
					permissions = '" . $db->escape_string(serialize($perms)) . "'
				WHERE usergroupid = " . $vbulletin->GPC['usergroupid'] . "
					AND extension = '" . $db->escape_string($vbulletin->GPC['ext']) . "'
			");
		}
		else
		{
			$db->query_write("
				INSERT INTO " . ADV_DYNA_TABLE_PREFIX . "attachmentperms
					(extension, usergroupid, permissions)
				VALUES (
					'" . $db->escape_string($vbulletin->GPC['ext']) . "',
					" . $vbulletin->GPC['usergroupid'] . ",
					'" . $db->escape_string(serialize($perms)) . "'
			)");
		}
	}

	build_dyna_attach_datastore();

	print_cp_redirect('vba_dyna_admin_permissions.php?' . $vbulletin->session->vars['sessionurl'] . 'do=attachperms' . ADV_URL_PREFIX_HR, 0);
}

// ######################### Reset Category Permissions ######################
if ($_REQUEST['do'] == 'resetattachperms')
{
	$ext = $vbulletin->input->clean_gpc('r', 'ext', TYPE_NOHTML);

	$db->query_write("DELETE FROM " . ADV_DYNA_TABLE_PREFIX . "attachmentperms WHERE extension = '" . $db->escape_string($ext) . "'");

	build_dyna_attach_datastore();

	print_cp_redirect('vba_dyna_admin_permissions.php?' . $vbulletin->session->vars['sessionurl'] . 'do=attachperms' . ADV_URL_PREFIX_HR, 0);
}

// ############################ Deny All Permission ###########################
if ($_REQUEST['do'] == 'denyattachperms')
{
	$ext = $vbulletin->input->clean_gpc('r', 'ext', TYPE_NOHTML);

	$groupinsert = '';

	$denyarray = serialize(array('attach' => array()));

	foreach ($vbulletin->usergroupcache AS $groupid => $group)
	{
		$groupinsert .= '(\'' . $ext . '\', ' . $groupid . ', \'' . $db->escape_string($denyarray) . '\'),';
	}

	if ($groupinsert)
	{
		$db->query_write("
			INSERT INTO " . ADV_DYNA_TABLE_PREFIX . "attachmentperms
				(extension, usergroupid, permissions)
			VALUES
				" . substr($groupinsert, 0, (strlen($groupinsert) - 1))
		);
	}

	build_dyna_attach_datastore();

	print_cp_redirect('vba_dyna_admin_permissions.php?' . $vbulletin->session->vars['sessionurl'] . 'do=attachperms' . ADV_URL_PREFIX_HR, 0);
}

print_cp_footer();

?>