<?php
// ++=========================================================================++
// || vBadvanced Dynamics v1.0.0 (vB 3.6 - vB 3.7)
// ||  2003-2007 vBadvanced.com - All Rights Reserved
// || This file may not be redistributed in whole or significant part.
// || http://vbadvanced.com
// ++ ========================================================================++

error_reporting(E_ALL & ~E_NOTICE);

// ##### Print Middle Submit Row ##############################################
function print_middle_submit_row($phrase = '', $colspan = 2, $previewtype = false)
{
	global $stylevar, $vbphrase;
	if (!$phrase)
	{
		$phrase = $vbphrase['save'];
	}

	print_description_row(
		'<span style="float:' . $stylevar['right'] . '">
			<input type="submit" value="' . $phrase . '" class="button" tabindex="1" />
		</span>' .
		iif ($previewtype,
			'<div><input type="button" class="button" name="preview" value="  ' . $vbphrase['preview'] . '  " onclick="preview_dyna_module();" tabindex="1" />'
		) .
		'</div>',
		false, $colspan, 'tfoot'
	);
}

// ##### Print Input Row w/ js option #########################################
function print_input_row_js($title, $name, $value, $onclick)
{
	print_label_row($title,
		'<input name="' . $name . '"' . iif($onclick, ' onclick="' . $onclick . '"') . ' class="bginput" tabindex="1" value="' . $value . '" size="35" />'
	);
}

// ##### Print Select Row w/ js option ########################################
function print_select_row_js($title, $name, $selected, $options, $onchange)
{
	print_label_row($title,
		'<select name="' . $name . '"' . iif($onchange, ' onchange="' . $onchange . '"') . ' class="bginput" tabindex="1">'
		. construct_select_options($options, $selected)
		. '</select>'
	);
}

// ######################## Make Category Select Field ########################
function print_category_select($selectname, $title = '', $selectedid = 0, $nonevalue = '', $disablecat = false, $nonele = 0)
{
	global $catselect, $vbulletin, $vbphrase;

	if (!$nonevalue)
	{
		$nonevalue = $vbphrase['none'];
	}

  echo '<tr class="' . fetch_row_bgclass() . '" valign="top">';
  echo '<td>' . $title . '</td>';
  echo '<td>';

  echo '<select class="bginput" name="' . $selectname . '" size="1" tabindex="1">';
	if ($nonevalue)
	{
	  echo '<option value="' . $nonele . '">' . $nonevalue . '</option>';
	}

	$options = print_cat_select($selectedid, 'admin');

	echo $options;

  echo '</select>';
 	echo '</td></tr>';
	unset($options);
}

// ######################## Print Permission Rows #############################
function print_permission_rows($type = 'normal')
{
	global $vba_dyna, $permsdata, $permgroupphrase, $perms, $vbphrase, $usergroup, $groupid;

	$jscustom = '';
	if ($type != 'normal')
	{
		$jscustom = 'js_set_custom();';
	}

	foreach ($permgroupphrase AS $permgroup => $permtitle)
	{
		if (($permgroup == 'module' AND $groupid == 1)
			OR ($type == 'category' AND ($permgroup == 'category' OR $permgroup == 'module' OR $permgroup == 'guestbook'))
			OR ($type == 'attach' AND $permgroup != 'attach')
		)
		{
			continue;
		}

		print_description_row($permtitle, 0, 2, 'thead');

		foreach ($permsdata[$permgroup] AS $pvar => $pinfo)
		{
			if (($groupid == 1 AND !$pinfo['guest'])
				OR (!$pinfo['cat'] AND $type == 'category')
				OR ($type == 'attach' AND $pinfo['noattach'])
			)
			{
				continue;
			}

			$pdata =& $permsdata[$permgroup][$pvar];

			if ($pinfo['limit'])
			{
				print_input_row(
					$pdata['text'] . $pdata['text_desc'],
					'usergroup[limit][' . $pvar . ']',
					$usergroup['limit'][$pvar],
					true,
					'35" onchange="' . $jscustom
				);
			}
			else
			{
				print_yes_no_row(
					$pdata['text'],
					'usergroup[' . $permgroup . '][' . $pvar . ']',
					$perms[$pvar],
					$jscustom
				);
			}
		}
	}
}

// ###################### Print Category Permissions Rows #####################
function print_category_perm_rows($catinfo, $cat = 0)
{
	global $counter, $vbulletin, $vbphrase, $categories, $hasperms;

	if ($catinfo)
	{
		$catarray = array();
		foreach ($catinfo AS $cats)
		{
			if ($cats['parent'] == $cat)
			{
				$counter++;
				$cats['level'] = $counter;

				$categories .= '<ul class="lsq"><li><b>' . $cats['title'] . '</b> <span class="smallfont">( ' .
					construct_link_code(
						$vbphrase['reset'],
						'vba_dyna_admin_permissions.php?do=resetperms&amp;catid=' . $cats['catid'] . ADV_URL_PREFIX
					) .
					construct_link_code(
						$vbphrase['deny_all'],
						'vba_dyna_admin_permissions.php?do=denyperms&amp;catid=' . $cats['catid'] . ADV_URL_PREFIX
					) . '</li>';

				$categories .= '<ul class="usergroups">';

				foreach ($vbulletin->usergroupcache AS $group)
				{
					$permclass = '';
					if ($hasperms[$group['usergroupid']][$cats['catid']])
					{
						$permclass = ' class="col-c"';
					}
					else if ($cats['parent'] AND $hasperms[$group['usergroupid']][$cats['parent']])
					{
						$hasperms[$group['usergroupid']][$cats['catid']] = true;
						$permclass .= ' class="col-i"';
					}

					$categories .= '<li' . $permclass . '>' .
						construct_link_code(
							$vbphrase['edit'],
							'vba_dyna_admin_permissions.php?do=editcategoryperms&amp;c=' . $cats['catid'] . '&amp;u=' . $group['usergroupid'] . ADV_URL_PREFIX
						) . $group['title'] . '</li>';
				}

				$categories .=  '</ul><br />';

				print_category_perm_rows($catinfo, $cats['catid']);
				$categories .=  '</ul>';
				$counter--;
			}
		}
	}
	return $categories;
}

// ##### Print Module Permissions #############################################
function print_module_permission_rows($permissions = array())
{
	global $db, $vbphrase, $vba_dyna;

	echo '<tr><td width="100%" class="thead">' . $vbphrase['usergroup_permissions'] . '</td>
		<td class="thead" style="white-space: nowrap"><input name="checkall_view" value="1" onclick="check_all_array(this, \'canview\');" type="checkbox" id="checkall_view" title="' . $vbphrase['check_all'] . '" tabindex="858" /> ' . $vbphrase['view'] . '&nbsp;</td>
		<td class="thead" style="white-space: nowrap"><input name="checkall_enable" value="1" onclick="check_all_array(this, \'canenable\');" type="checkbox" id="checkall_enable" title="' . $vbphrase['check_all'] . '" tabindex="858" /> ' . $vbphrase['enable'] . '</td>
		<td class="thead" style="white-space: nowrap"><input name="checkall_disable" value="1" onclick="check_all_array(this, \'candisable\');" type="checkbox" id="checkall_disable" title="' . $vbphrase['check_all'] . '" tabindex="858" /> ' . $vbphrase['disable'] . '</td>
	</tr>';

	$usergroups = $db->query_read("SELECT usergroupid, title FROM " . TABLE_PREFIX . "usergroup ORDER BY usergroupid");
	while ($usergroup = $db->fetch_array($usergroups))
	{
		if ($_REQUEST['do'] == 'addmodule' OR $_REQUEST['do'] == 'download')
		{
			$permissions[$usergroup['usergroupid']] = array_sum(array_values($vba_dyna->_modulepermbits));
		}

		$perms = convert_bits_to_array($permissions[$usergroup['usergroupid']], $vba_dyna->_modulepermbits);

		print_cells_row(array(
			$usergroup['title'],
			'<input type="checkbox" name="userperms[' . $usergroup['usergroupid'] . '][canview]" value="1" ' . iif($perms['canview'], 'checked="checked"') . ' />',
			iif ($usergroup['usergroupid'] == 1,
				'',
				'<input type="checkbox" name="userperms[' . $usergroup['usergroupid'] . '][canenable]" value="1" ' .  iif($perms['canenable'], 'checked="checked"') . ' />'
			),
			iif ($usergroup['usergroupid'] == 1,
				'',
				'<input type="checkbox" name="userperms[' . $usergroup['usergroupid'] . '][candisable]" value="1" ' . iif($perms['candisable'], 'checked="checked"') . ' />'
			)
		), false, false, -3);

	}
}

// ##### Fetch Settings Phrases ###############################################
function fetch_settings_phrases()
{
	global $db;

	$return = array();
	$getphrases = $db->query_read("SELECT varname, text FROM " . TABLE_PREFIX . "phrase WHERE fieldname = 'vbsettings' ORDER BY languageid ASC");
	while($phrase = $db->fetch_array($getphrases))
	{
		$return[$phrase['varname']] = $phrase['text'];
	}

	return $return;
}

// ##### Order Navigation Links ###############################################
function order_nav($a, $b)
{
	return ($a['order'] < $b['order']) ? -1 : 1;
}

// ##### Process Submitted Settings ###########################################
function process_adv_settings($grouptitles, $type = '')
{
	global $db, $_POST, $vba_options;
	global $notices, $updatecatcache;

	$notices = array();

	$getsettings = $db->query_read("
		SELECT *
		FROM " . TABLE_PREFIX . "adv_setting
		WHERE grouptitle IN('" . implode("', '", $grouptitles) . "')
	");
	while ($adv_setting = $db->fetch_array($getsettings))
	{
		$varname =& $adv_setting['varname'];

		if ($type == 'module')
		{
			$postvalue =& $_POST['setting'][$varname];
		}
		else
		{
			$postvalue =& $_POST['setting'][$adv_setting['grouptitle']][$varname];
		}

		if ($adv_setting['optioncode'] == 'hidden')
		{
			$postvalue = $adv_setting['value'];
		}

		// Navigation links (has to be done before serialization, and before switch($varname))
		if ($adv_setting['optioncode'] == 'pageselect_add')
		{
			$pagelinks = array();
			if ($postvalue)
			{
				foreach ($postvalue AS $key => $array)
				{
					if ($array['text'])
					{
						$pagelinks[$key] = $array;
					}
				}
			}
			usort($pagelinks, 'order_nav');

			$postvalue = $pagelinks;
		}

		if ($adv_setting['serialize'])
		{
			$postvalue = serialize($postvalue);
		}

		// Check problematic settings
		if ($adv_setting['value'] != $postvalue)
		{
			switch ($varname)
			{
				// Attachment path
				case 'dyna_attachpath':

					if ($postvalue)
					{
						if (!is_dir($postvalue))
						{
							$notices[] = fetch_error(ADV_DYNA_PREFIX . '_attach_folder_invalid', $postvalue);
						}
						else if (!is_writable($postvalue))
						{
							$notices[] = fetch_error(ADV_DYNA_PREFIX . '_attach_folder_not_writable', $postvalue);
						}
					}

				break;

				// Changing first attachment, may need to rebuild
				case 'dyna_entrybit_showattach':

					$notices[] = fetch_error(
						ADV_DYNA_PREFIX . '_first_attach_changed',
						$vbulletin->session->vars['sessionurl'],
						ADV_DYNA_PREFIX
					);

				break;

				// Thumbnail size
				case 'dyna_thumbsize':
					$notices[] = fetch_error(
						ADV_DYNA_PREFIX . '_thumb_size_changed',
						$vbulletin->session->vars['sessionurl'],
						ADV_DYNA_PREFIX
					);
				break;

				// Empty the rss cache since allow sub-cats option is changing
				case 'dyna_extr_subcats':
					$db->query_write("TRUNCATE TABLE " . ADV_DYNA_TABLE_PREFIX . "extcache");
				break;

				// Spider URLs
				case 'dyna_spiderurls':
					$vba_options['dyna_spiderurls'] = $postvalue;

				// Category display order
				case 'dyna_catsdir':
				case 'dyna_catsorder':

					$updatecatcache = true;

				break;
			}

			$db->query_write("
				UPDATE " . TABLE_PREFIX . "adv_setting
				SET value = '" . $db->escape_string($postvalue) . "'
				WHERE varname = '" . $db->escape_string($varname) . "'
					AND grouptitle = '" . $db->escape_string($adv_setting['grouptitle']) . "'
			");
		}
	}
}

// ##### Update Settings Datastore ############################################
function build_dyna_settings_datastore()
{
	global $db;

	$adv_options = array();
	$settings = $db->query_read("
		SELECT adv_setting.*
		FROM " . TABLE_PREFIX . "adv_setting AS adv_setting
		LEFT JOIN " . TABLE_PREFIX . "adv_settinggroup AS adv_settinggroup ON (adv_setting.grouptitle = adv_settinggroup.grouptitle)
		WHERE (adv_setting.grouptitle LIKE '" . ADV_DYNA_PREFIX . "%' OR adv_setting.grouptitle = 'adv_global')
			AND adv_setting.grouptitle NOT LIKE '" . ADV_DYNA_PREFIX . "_modules_%'
	");
	while ($setting = $db->fetch_array($settings))
	{
		if ($setting['serialize'])
		{
			$setting['value'] = unserialize($setting['value']);
			if (!is_array($setting['value']))
			{
				$setting['value'] = array();
			}
		}

		$adv_options[$setting['varname']] = $setting['value'];
	}

	$db->free_result($settings);
	unset($setting);

	$adv_options['dyna_simpleversion'] = str_replace(
		array(' ', '.'),
		array('_', ''),
		$adv_options['dyna_version']
	);

	build_datastore(ADV_DYNA_PREFIX . '_opts', serialize($adv_options), 1);

	return $adv_options;
}

// ######################### Print Settings ###########################
function print_adv_setting_group($grouptitle)
{
	global $vbulletin, $settingscache, $grouptitlecache, $session, $vbphrase, $settingphrase, $stylevar, $module, $ismodgroup;

	if (empty($settingscache[$grouptitle]))
	{
		return;
	}

	if ($module['modid'] OR $ismodgroup)
	{
		$identifylink = '&amp;identifier=' . $module['identifier'] . '&amp;modid=' . $module['modid'];
	}

	construct_hidden_code('grouptitles[' . $grouptitle . ']', 1);

	print_table_header('<a name="#' . $grouptitle . '"></a>' . $settingphrase['settinggroup_' . $grouptitle] .
			construct_link_code($vbphrase['add_setting'], 'vba_dyna_admin_main.php?' . $vbulletin->session->vars['sessionurl'] . 'do=addsetting&amp;grouptitle=' . $grouptitle . $identifylink . ADV_URL_PREFIX) .
			'</span>'
	);

	foreach ($settingscache[$grouptitle] AS $settingid => $setting)
	{
		if ($setting['type'] == 'hidden')
		{
			continue;
		}

		$settingtext = '<div class="smallfont" style="float:' . $stylevar['right'] . '">';

		if ($vbulletin->debug)
		{
			$settingtext .=
				construct_link_code(
					$vbphrase['edit'],
					'vba_dyna_admin_main.php?' . $vbulletin->session->vars['sessionurl'] . 'do=editsetting&varname=' . $setting['varname'] . $identifylink . ADV_URL_PREFIX) .
				construct_link_code(
					$vbphrase['delete'],
					'vba_dyna_admin_main.php?' . $vbulletin->session->vars['sessionurl'] . 'do=removesetting&varname=' . $setting['varname'] . '&amp;grouptitle=' . $grouptitle . $identifylink . ADV_URL_PREFIX);
		}

		$settingtext .= '</div><div>' . $settingphrase["setting_$setting[varname]_title"] . '<a name="' . $setting['varname'] . '"></a></div>';

		print_description_row($settingtext, 0, 2, 'optiontitle" title="$vba_options[' . $setting['varname'] . ']"');

		$description = '<div class="smallfont" title="$vba_options[' . $setting['varname'] . ']">' . $settingphrase["setting_$setting[varname]_desc"] . '</div>';
		$name = 'setting' . iif(!$module['modid'], '[' . $grouptitle . ']') . '[' . $setting['varname'] . ']';

		switch ($setting['optioncode'])
		{
			// ##### Input
			case '':
				print_input_row($description, $name, $setting['value']);
			break;

			// ##### Textarea
			case 'textarea':
				print_textarea_row($description, $name, $setting['value']);
			break;

			// ##### Yes/No
			case 'yesno':
				print_yes_no_row($description, $name, $setting['value']);
			break;

			// ##### Category Select
			case 'catselect':

				$selectbox = '<select class="bginput" tabindex="1" name="' . $name . '[]" multiple="multiple" style="width:275px" size="' . iif(sizeof($vbulletin->adv_dyna_cats) > 10, 10, sizeof($vbulletin->adv_dyna_cats)) . '">';

				foreach ($vbulletin->adv_dyna_cats AS $cat)
				{
					$selectbox .= '<option value="' . $cat['catid'] . '" ' . iif(in_array($cat['catid'], $setting['value']),'selected="selected"') . '>' . str_repeat('--', $cat['level']) . $cat['title'] . '</option>';
				}
				$selectbox .= '</select>';

				print_label_row($description, $selectbox);
			break;

			// ##### Custom User Fields
			case 'userfield':

				$cphrases = array();
				$phrases = $vbulletin->db->query_read("SELECT varname, text FROM " . TABLE_PREFIX . "phrase WHERE fieldname = 'cprofilefield' ORDER BY languageid DESC");
				while ($phrase = $vbulletin->db->fetch_array($phrases))
				{
					$cphrases[$phrase['varname']] = $phrase['text'];
				}

				$fields = $vbulletin->db->query_read("SELECT profilefieldid FROM " . TABLE_PREFIX . "profilefield");

				$boxsize = $vbulletin->db->num_rows($fields);
				$selectbox = '<select class="bginput" tabindex="1" name="' . $name . '[]" multiple="multiple" style="width:275px" size="' . iif($boxsize > 10, 10, $boxsize) . '">';

				while ($field = $vbulletin->db->fetch_array($fields))
				{
					$selectbox .= '<option value="' . $field['profilefieldid'] . '" ' . iif(in_array($field['profilefieldid'], $setting['value']), 'selected="selected"') . '>' . $cphrases['field' . $field['profilefieldid'] . '_title'] . '</option>';
				}

				print_label_row($description, $selectbox);
			break;

			// ##### Style Select
			case 'styleselect':
				require_once(DIR . '/includes/adminfunctions_template.php');
				print_style_chooser_row($name, $setting['value'], $vbphrase['use_vbulletin_default'], $description, 1);
			break;

			// ##### Additional page inputs
			case 'pageselect_add':

				$pagecount = 0;

				$inputs = '';
				if (!empty($setting['value']))
				{
					foreach ($setting['value'] AS $key => $navlinks)
					{
						$pagecount++;
						$inputs .= '<tr>
							<td><input class="bginput" name="' . $name . '[' . $pagecount . '][order]" value="' . $navlinks['order'] . '" size="4" tabindex="1" /></td>
							<td><input class="bginput" name="' . $name . '[' . $pagecount . '][level]" value="' . $navlinks['level'] . '" size="4" tabindex="1" /></td>
							<td><input class="bginput" name="' . $name . '[' . $pagecount . '][link]" value="' . $navlinks['link'] . '" size="26" tabindex="1" /></td>
							<td><input class="bginput" name="' . $name . '[' . $pagecount . '][text]" value="' . $navlinks['text'] . '" size="18" tabindex="1" /></td>
						</tr>';
					}
				}

				$curcount = $pagecount + 3;

				while ($curcount > $pagecount)
				{
					$pagecount++;
					$inputs .= '<tr>
						<td><input class="bginput" name="' . $name . '[' . $pagecount . '][order]" value="" size="4" tabindex="1" /></td>
						<td><input class="bginput" name="' . $name . '[' . $pagecount . '][level]" value="" size="4" tabindex="1" /></td>
						<td><input class="bginput" name="' . $name . '[' . $pagecount . '][link]" value="" size="26" tabindex="1" /></td>
						<td><input class="bginput" name="' . $name . '[' . $pagecount . '][text]" value="" size="18" tabindex="1" /></td>
						</tr>';
				}

				$setting_ident = $grouptitle . '_' . $setting['varname'];

				print_description_row($description . '<br />
					<table align="center" cellpadding="2" cellspacing="0" class="tborder">
						<tr>
							<td class="thead">' . $vbphrase['order'] . '</td>
							<td class="thead">' . $vbphrase['level'] . '</td>
							<td class="thead">' . $vbphrase['link'] . '</td>
							<td class="thead">' . $vbphrase['text'] . '</td>
						</tr>' .
						$inputs .
						'<tr>
							<td colspan="4"><input type="hidden" value="' . $pagecount . '" id="theValue_' . $setting_ident . '" />
								<div id="moreinputs_' . $setting_ident . '"> </div>
								<div style="padding: 4px">[<a href="javascript:;" onclick="add_input_field(\'' . $name . '\', \'' . $setting_ident . '\')">' . $vbphrase['add_more'] . '</a>]</div>
							</td>
						</tr>
					</table>');
			break;


			// ##### Entrybit Template
			case 'entrybittemplate':

				$settingid = $grouptitle . '_' . $setting['varname'];

				print_label_row($description, '<div class="smallfont">
					<input type="radio" name="' . $name . '" id="' . $settingid . '_exp" value="expanded" tabindex="1"' . iif($setting['value'] == 'expanded', ' checked="checked"') . '><label for="' . $settingid . '_exp">' . $vbphrase['expanded'] . '</label><br />
					<input type="radio" name="' . $name . '" id="' . $settingid . '_sim" value="simple" tabindex="1"' . iif($setting['value'] == 'simple', ' checked="checked"') . '><label for="' . $settingid . '_sim">' . $vbphrase['simple'] . '</label><br />
					<input type="radio" name="' . $name . '" id="' . $settingid . '_lea" value="lean" tabindex="1"' . iif($setting['value'] == 'lean', ' checked="checked"') . '><label for="' . $settingid . '_lea">' . $vbphrase['extra_lean'] . '</label></div>'
				);

			break;


			// ##### Entrybit Elements
			case 'entrybitelements':

				print_label_row($description, '<table width="100%">
<tr>
<td valign="top" class="smallfont">
	<input type="checkbox" name="' . $name . '[]" id="setting_' . $grouptitle . '_' . $setting['varname'] . '_replies" value="replies" ' . iif(in_array('replies', $setting['value']), 'checked="checked"') . ' /> <label for="setting_' . $grouptitle . '_' . $setting['varname'] . '_replies">' . $vbphrase['replies'] . '</label><br />

	<input type="checkbox" name="' . $name . '[]" id="setting_' . $grouptitle . '_' . $setting['varname'] . '_views" value="views" ' . iif(in_array('views', $setting['value']), 'checked="checked"') . ' /> <label for="setting_' . $grouptitle . '_' . $setting['varname'] . '_views">' . $vbphrase['views'] . '</label><br />

	' . iif($grouptitle != ADV_DYNA_PREFIX . '_browsecategory', '<input type="checkbox" name="' . $name . '[]" id="setting_' . $grouptitle . '_' . $setting['varname'] . '_category" value="category" ' . iif(in_array('category', $setting['value']), 'checked="checked"') . ' /> <label for="setting_' . $grouptitle . '_' . $setting['varname'] . '_category">' . $vbphrase['category'] . '</label><br />') . '

	<input type="checkbox" name="' . $name . '[]" id="setting_' . $grouptitle . '_' . $setting['varname'] . '_folder" value="folder" ' . iif(in_array('folder', $setting['value']), 'checked="checked"') . ' /> <label for="setting_' . $grouptitle . '_' . $setting['varname'] . '_folder">' . $vbphrase['folder'] . '</label><br />

	<input type="checkbox" name="' . $name . '[]" id="setting_' . $grouptitle . '_' . $setting['varname'] . '_caticon" value="caticon" ' . iif(in_array('caticon', $setting['value']), 'checked="checked"') . ' /> <label for="setting_' . $grouptitle . '_' . $setting['varname'] . '_caticon">' . construct_phrase($vbphrase['x_icon'], $vbphrase['category']) . '</label><br />

</td>

<td valign="top" class="smallfont">
	<input type="checkbox" name="' . $name . '[]" id="setting_' . $grouptitle . '_' . $setting['varname'] . '_rating" value="rating" ' . iif(in_array('rating', $setting['value']), 'checked="checked"') . ' /> <label for="setting_' . $grouptitle . '_' . $setting['varname'] . '_rating">' . $vbphrase['rating'] . '</label><br />

	<input type="checkbox" name="' . $name . '[]" id="setting_' . $grouptitle . '_' . $setting['varname'] . '_last_reply" value="last_reply" ' . iif(in_array('last_reply', $setting['value']), 'checked="checked"') . ' /> <label for="setting_' . $grouptitle . '_' . $setting['varname'] . '_last_reply">' . $vbphrase['last_reply'] . '</label><br />

	<input type="checkbox" name="' . $name . '[]" id="setting_' . $grouptitle . '_' . $setting['varname'] . '_icon" value="icon" ' . iif(in_array('icon', $setting['value']), 'checked="checked"') . ' /> <label for="setting_' . $grouptitle . '_' . $setting['varname'] . '_icon">' . $vbphrase['icon'] . '</label><br />

	' . iif($grouptitle != ADV_DYNA_PREFIX . '_browsecategory', '<input type="checkbox" name="' . $name . '[]" id="setting_' . $grouptitle . '_' . $setting['varname'] . '_firstattach" value="firstattach" ' . iif(in_array('firstattach', $setting['value']), 'checked="checked"') . ' /> <label for="setting_' . $grouptitle . '_' . $setting['varname'] . '_firstattach">' . $vbphrase['attachment'] . '</label><br />') . '

	<input type="checkbox" name="' . $name . '[]" id="setting_' . $grouptitle . '_' . $setting['varname'] . '_preview" value="preview" ' . iif(in_array('preview', $setting['value']), 'checked="checked"') . ' /> <label for="setting_' . $grouptitle . '_' . $setting['varname'] . '_preview">' . construct_phrase($vbphrase['preview_x'], '') . '</label><br />


</td>
</tr>

<tr>
<td colspan="2" class="smallfont" style="white-space: nowrap"><div style="padding-top:5px"><strong>' . $vbphrase['expanded_entrybit_template_only'] . '</strong></div></td>
</tr>
<tr>
<td valign="top" class="smallfont">
	<input type="checkbox" name="' . $name . '[]" id="setting_' . $grouptitle . '_' . $setting['varname'] . '_avatar" value="avatar" ' . iif(in_array('avatar', $setting['value']), 'checked="checked"') . ' /> <label for="setting_' . $grouptitle . '_' . $setting['varname'] . '_avatar">' . $vbphrase[avatar] . '</label><br />

	<input type="checkbox" name="' . $name . '[]" id="setting_' . $grouptitle . '_' . $setting['varname'] . '_online_status" value="online_status" ' . iif(in_array('online_status', $setting['value']), 'checked="checked"') . ' /> <label for="setting_' . $grouptitle . '_' . $setting['varname'] . '_online_status">' . $vbphrase['online_status'] . '</label><br />

	<input type="checkbox" name="' . $name . '[]" id="setting_' . $grouptitle . '_' . $setting['varname'] . '_user_title" value="user_title" ' . iif(in_array('user_title', $setting['value']), 'checked="checked"') . ' /> <label for="setting_' . $grouptitle . '_' . $setting['varname'] . '_user_title">' . $vbphrase['user_title'] . '</label><br />

	<input type="checkbox" name="' . $name . '[]" id="setting_' . $grouptitle . '_' . $setting['varname'] . '_user_rank" value="user_rank" ' . iif(in_array('user_rank', $setting['value']), 'checked="checked"') . ' /> <label for="setting_' . $grouptitle . '_' . $setting['varname'] . '_user_rank">' . $vbphrase['user_rank'] . '</label><br />

</td>

<td valign="top" class="smallfont">

	<input type="checkbox" name="' . $name . '[]" id="setting_' . $grouptitle . '_' . $setting['varname'] . '_entry_options" value="entry_options" ' . iif(in_array('entry_options', $setting['value']), 'checked="checked"') . ' /> <label for="setting_' . $grouptitle . '_' . $setting['varname'] . '_entry_options">' . construct_phrase($vbphrase['x_options'], $vbphrase['entry']) . '</label><br />

	<input type="checkbox" name="' . $name . '[]" id="setting_' . $grouptitle . '_' . $setting['varname'] . '_reply_button" value="reply_button" ' . iif(in_array('reply_button', $setting['value']), 'checked="checked"') . ' /> <label for="setting_' . $grouptitle . '_' . $setting['varname'] . '_reply_button">' . $vbphrase['reply_button'] . '</label><br />

	<input type="checkbox" name="' . $name . '[]" id="setting_' . $grouptitle . '_' . $setting['varname'] . '_edit_button" value="edit_button" ' . iif(in_array('edit_button', $setting['value']), 'checked="checked"') . ' /> <label for="setting_' . $grouptitle . '_' . $setting['varname'] . '_edit_button">' . $vbphrase['edit_button'] . '</label><br />
</td>
</tr>

</table>');
			break;

			// ##### Default search fields
			case 'defsearchfields':
				$fields = array(
					'title' => $vbphrase['title'],
					'keywords' => $vbphrase['tags'],
					'pagetext' => $vbphrase['message'],
					'posts' => $vbphrase['posts']
				);

				$settingid = $grouptitle . '_' . $setting['varname'];

				$cfieldbits = '';
				foreach ($fields AS $fieldid => $fieldtitle)
				{
					$fieldcount++;
					$cfieldbits .= '<input type="checkbox" name="' . $name . '[]" value="' . $fieldid . '" id="' . $settingid . '_' . $fieldid . '"' . iif(in_array($fieldid, $setting['value']), ' checked="checked"') . ' /><label for="' . $settingid . '_' . $fieldid . '">' . $fieldtitle . '</label><br />';

					if ($fieldcount == 2)
					{
						$cfieldbits .= '</td><td valign="top" class="smallfont">';
					}
				}

				print_label_row($description, '<table align="center" cellpadding="2" cellspacing="0" width="275"><tr><td valign="top" class="smallfont">' . $cfieldbits . '</td></tr></table>');

			break;

			// ##### Custom field checkboxes
			case 'cfieldcheckbox':

				$cfieldbits = '';
				if (!empty($vbulletin->adv_dyna_cfield))
				{
					$colsplit = ceil(sizeof($vbulletin->adv_dyna_cfield) / 2);
					$fieldcount = 0;

					$settingid = $grouptitle . '_' . $setting['varname'];

					foreach ($vbulletin->adv_dyna_cfield AS $fieldid => $field)
					{
						$fieldcount++;
						$cfieldbits .= '<input type="checkbox" name="' . $name . '[]" value="' . $fieldid . '" id="' . $settingid . '_' . $fieldid . '"' . iif(in_array($fieldid, $setting['value']), ' checked="checked"') . ' /><label for="' . $settingid . '_' . $fieldid . '">' . $field['title'] . '</label><br />';

						if ($fieldcount == $colsplit)
						{
							$cfieldbits .= '</td><td valign="top" class="smallfont">';
						}
					}
				}

				print_label_row($description, '<table align="center" cellpadding="2" cellspacing="0" width="275"><tr><td valign="top" class="smallfont">' . $cfieldbits . '</td></tr></table>');

			break;

			// ##### Start CMPS optioncodes

			// Forum select box
			case 'forumselect':
			case 'forumselect_random':

				if (!is_array($setting['value']))
				{
					$setting['value'] = array();
				}

				$selectbox = '<select name="' . $name . '[]" multiple="multiple" style="width:275px" size="' . iif(sizeof($vbulletin->forumcache) > 10, 10, sizeof($vbulletin->forumcache)) . '" class="bginput" tabindex="1">';

				foreach ($vbulletin->forumcache AS $forum)
				{
					$selectbox .= '<option value="' . $forum['forumid'] . '" ' . iif(in_array($forum['forumid'], $setting['value']), 'selected="selected"') . '>' . str_repeat('--', $forum['depth']) . $forum['title'] . '</option>';
				}
				$selectbox .= '</select>';

				print_label_row($description, $selectbox);

			break;


			// Calendar select box (CMPS)
			case 'calendarselect':
				$selectbox = '<select name="' . $name . '" class="bginput" tabindex="1">';
				$selectbox .= '<option value="-1">' . $vbphrase['simple_calendar'] . '</option>';
				$getcalendars = $vbulletin->db->query_read("SELECT calendarid, title FROM " . TABLE_PREFIX . "calendar");
				while ($calendar = $vbulletin->db->fetch_array($getcalendars))
				{
					$selectbox .= '<option ' . iif($calendar['calendarid'] == $setting['value'], 'selected="selected"') . ' value="' . $calendar['calendarid']. '">' . $calendar['title'] . '</option>';
				}
				$selectbox .= '</select>';

				print_label_row($description, $selectbox);
			break;

			default:
				eval("\$right = \"<div id=\\\"ctrl_setting[$setting[varname]]\\\">$setting[optioncode]</div>\";");
				print_label_row($description, $right, '', 'top', $name);
		}
	}

	if ($type == 'module' OR $_REQUEST['grouptitle'] == 'all')
	{
		print_middle_submit_row();
	}
	print_table_break();

}

// ##### Update Custom Fields Cache ###########################################
function build_dyna_cfield_datastore()
{
	global $db;

	$custominfo = array();
	$customfields = $db->query_read("SELECT * FROM " . ADV_DYNA_TABLE_PREFIX . "cfields ORDER BY displayorder");
	while ($field = $db->fetch_array($customfields))
	{
		if ($field['options'])
		{
			$field['options'] = array_map('trim', explode("\r\n", $field['options']));
		}

		if ($field['catids'] != 'all')
		{
			$field['catids'] = explode(',', $field['catids']);

			if ($field['incsubs'])
			{
				$subcats = array();
				foreach ($field['catids'] AS $fcat)
				{
					$subcats = array_merge($subcats, fetch_category_children($fcat));
				}
				$field['subcats'] = $subcats;
			}
		}

		$custominfo[$field['fieldid']] = $field;
	}

	build_datastore(ADV_DYNA_PREFIX . '_cfield', serialize($custominfo), 1);
}

// ##### Update Module Cache ##################################################
function build_dyna_module_datastore()
{
	global $db;

	$modopts = array();
	$modsettings = $db->query_read("
		SELECT varname, grouptitle, value, serialize
		FROM " . TABLE_PREFIX . "adv_setting
		WHERE grouptitle LIKE '" . ADV_DYNA_PREFIX . "_modules_%'
	");
	while ($setting = $db->fetch_array($modsettings))
	{
		if ($setting['serialize'])
		{
			$setting['value'] = unserialize($setting['value']);

			if (!is_array($setting['value']))
			{
				$setting['value'] = array();
			}
		}
		$modopts[$setting['grouptitle']][$setting['varname']] = $setting['value'];
	}

	$module = array();
	$mods = $db->query_read("SELECT * FROM " . ADV_DYNA_TABLE_PREFIX . "modules WHERE active = 1 ORDER BY title");
	while ($mod = $db->fetch_array($mods))
	{
		if ($mod['inctype'] == 'php_file')
		{
			$mod['settings'] = $modopts[ADV_DYNA_PREFIX . '_modules_' . $mod['identifier']];
		}
		else if ($mod['inctype'] == 'bb_code')
		{
			// No need for the unparsed bb code to be stored
			$mod['filename'] = '';
		}

		$mod['templatelist'] = explode("\r\n", $mod['templatelist']);

		$mod['userperms'] = unserialize($mod['userperms']);

		($hook = vBulletinHook::fetch_hook('vba_dyna_modulecache_loop')) ? eval($hook) : false;

		$module[$mod['modid']] = $mod;
	}

	build_datastore(ADV_DYNA_PREFIX . '_module', serialize($module), 1);
}

// ##### Build Attachment Datastore ###########################################
function build_dyna_attach_datastore()
{
	global $db;

	$aperms = array();
	$getperms = $db->query_read("SELECT * FROM " . ADV_DYNA_TABLE_PREFIX . "attachmentperms");
	while ($perms = $db->fetch_array($getperms))
	{
		$aperms[$perms['extension']][$perms['usergroupid']] = unserialize($perms['permissions']);
	}

	$acache = array();
	$getattach = $db->query_read("SELECT * FROM " . ADV_DYNA_TABLE_PREFIX . "attachmenttype");
	while ($attach = $db->fetch_array($getattach))
	{
		if ($aperms[$attach['extension']])
		{
			$attach['permissions'] = $aperms[$attach['extension']];
		}

		$acache[$attach['extension']] = $attach;
	}

	build_datastore(ADV_DYNA_PREFIX . '_attach', serialize($acache), 1);
}

// ##### Get Phrases for Blog Pages ###########################################
function get_page_phrase($page)
{
	global $vbphrase;
	switch ($page)
	{
		case 'dyna_browsecategory':
			return construct_phrase($vbphrase['pages_' . $page], $vbphrase['category']);
		break;

		case 'dyna_showentry':
		case 'dyna_newentry':
			return construct_phrase($vbphrase['pages_' . $page], $vbphrase['entry']);
		break;

		default:
			return $vbphrase['pages_' . $page];
	}
}

// ##### Print Blog Form Header ###############################################
// (adds the hidden adv_dyna_index field)
function print_dyna_form_header($phpscript = '', $do = '', $uploadform = false, $addtable = true, $name = 'cpform', $width = '90%', $target = '', $echobr = true, $method = 'post')
{
	print_form_header($phpscript, $do, $uploadform, $addtable, $name, $width, $target, $echobr, $method);
	construct_hidden_code('adv_dyna_prefix', ADV_DYNA_PREFIX);
}

// ##### Print CP Page Navigation #############################################
function print_cp_pagenav($colspan = 1, $hidden = false)
{
	global $pagedata, $vbulletin, $vbphrase;

	if ($pagedata['pagecount'] == 1)
	{
		return false;
	}

	if ($hidden)
	{
		construct_hidden_code($hidden, $vbulletin->GPC[$hidden]);
	}
	if ($pagedata['pagenumber'] < $pagedata['pagecount'])
	{
		construct_hidden_code('page', $pagedata['pagenumber'] + 1);
		print_submit_row($vbphrase['next_page'], '', $colspan, iif($pagedata['pagenumber'] != 1, $vbphrase['last_page']), '', true);
	}
	else
	{
		construct_hidden_code('page', 1);
		print_submit_row($vbphrase['first_page'], '', $colspan, $vbphrase['last_page'], '', true);
	}
}

// ##### Print CP Text Editor #################################################
function print_cp_text_editor($text, $allowhtml, $allowsmilies, $allowimg, $allowurl, $htmlchecked, $smilieschecked)
{
	global $vbulletin, $vbphrase, $stylevar, $style, $istyles, $show, $messagearea, $smiliebox, $disablesmiliesoption, $checked, $vBeditTemplate;

	$gettemp = $vbulletin->db->query_read("
		SELECT *
		FROM " . TABLE_PREFIX . "template
		WHERE title IN('editor_toolbar_on', 'editor_smilie', 'editor_clientscript','editor_toolbar_off', 'editor_jsoptions_font', 'editor_jsoptions_size','editor_smiliebox', 'editor_smiliebox_category', 'editor_smiliebox_row', 'editor_smiliebox_straggler')
			AND styleid = '-1'
	");
	while ($temp = $vbulletin->db->fetch_array($gettemp))
	{
		$vbulletin->templatecache[$temp['title']] = $temp['template'];
	}

	$style = $vbulletin->db->query_first("SELECT * FROM " . TABLE_PREFIX . "style WHERE styleid = " . $vbulletin->options['styleid']);
	$stylevar = array_merge($stylevar, unserialize($style['stylevars']));

	$stycolor = unserialize($style['csscolors']);

	format_vb_text_editor();

	echo '<style type="text/css"><!--
		.wysiwyg
		{
			background-color: ' . $stycolor['wysiwyg_bgcolor'] . ';
			color: ' . $stycolor['wysiwyg_fgcolor'] . ';
			font: 10pt verdana, geneva, lucida, \'lucida grande\', arial, helvetica, sans-serif;
		}
	-->
	</style>';

	// Editor & message area
	$vbulletin->options['allowbbcode'] = 1;
	$vbulletin->options['allowbbimagecode'] = $allowimg;
	construct_edit_toolbar(htmlspecialchars($text), false, 'nonforum', true, $smilieschecked);

	print_description_row($messagearea);

	if ($allowhtml)
	{
		print_yes_no_row($vbphrase['allow_html'], 'module[options][allow_html]', $htmlchecked);
	}
	if ($allowsmilies)
	{
		print_yes_no_row($vbphrase['allow_smilies'], 'module[options][allow_smilies]', $smilieschecked);
	}
	if ($allowimg)
	{
		print_yes_no_row($vbphrase['allow_img_code'], 'module[options][allow_image_code]', $allowimg);
	}
	if ($allowurl)
	{
		print_yes_no_row($vbphrase['automatically_parse_links_in_text'], 'module[options][parseurl]', true);
	}
}

// ##### Print Category Options ###############################################
function print_category_options($members = false)
{
	global $vbphrase, $vba_options, $cat, $options, $useropts, $headertitle, $stylecache;

	require_once(DIR . '/includes/adminfunctions_template.php');

	$jscustom = '';
	if ($members)
	{
		$jscustom = 'js_set_custom();';
	}

	print_table_header($headertitle);

	if (!$members)
	{
		print_input_row($vbphrase['title'], 'catinfo[title]', $cat['title']);
		print_textarea_row($vbphrase['description'], 'catinfo[description]', $cat['description']);
		print_input_row($vbphrase['display_order'], 'catinfo[displayorder]', $cat['displayorder']);
		print_category_select('catinfo[parent]', $vbphrase['category_parent'], $cat['parent']);
	}

	cache_styles();

	$styleopts = array(0 => $vbphrase['none']);
	foreach ($stylecache AS $style)
	{
		$styleopts[$style['styleid']] = str_repeat('--', ($style['depth'] + 1)) . $style['title'];
	}

	print_select_row_js(construct_phrase($vbphrase['custom_style_for_this_x'], $vbphrase['category']), 'catinfo[styleid]', $cat['styleid'], $styleopts, $jscustom);

	if (!$members)
	{
		print_upload_row(construct_phrase($vbphrase['upload_x_icon'] . '<div class="smallfont">' . construct_phrase($vbphrase['upload_x_icon_desc'], $vbphrase['category_lwr']) . '</div>', $vbphrase['category'], $vbphrase['category_lwr']), 'caticon_upload');
		print_input_row(
			construct_phrase($vbphrase['x_icon'], $vbphrase['category']) . '<div class="smallfont">' .
				construct_phrase($vbphrase['x_icon_desc'], $vbphrase['category_lwr'], $vba_options['dyna_homeurl']) . '</div>' .
				iif($cat['caticon'], '<div style="padding-top: 4px">
					<fieldset class="fieldset">
						<legend>' . construct_phrase($vbphrase['preview_x'], $vbphrase['icon']) . '</legend>
						<img src="' . $vba_options['dyna_homeurl'] . '/images/caticon/' . $cat['caticon'] . '" alt="" style="padding: 4px" />
					</fieldset>
					<div><input type="checkbox" name="delcaticon" id="delcaticon" value="1" /> <label for="delcaticon">' . construct_phrase($vbphrase['delete_x'], $vbphrase['icon']) . '</label></div>
				</div>'
				),
			'catinfo[caticon]',
			$cat['caticon']
		);
	}

	print_input_row_js(construct_phrase($vbphrase['email_address_notify_new_x'], $vbphrase['entry']), 'catinfo[newentryemail]', $cat['newentryemail'], $jscustom);
	print_input_row_js(construct_phrase($vbphrase['email_address_notify_new_x'], $vbphrase['post']), 'catinfo[newpostemail]', $cat['newpostemail'], $jscustom);

	print_table_header(construct_phrase($vbphrase['x_options'], $vbphrase['category']));

	if (!$members)
	{
		print_yes_no_row($vbphrase['act_as_category'], 'catinfo[hasentries]', $cat['hasentries']);
		print_yes_no_row(construct_phrase($vbphrase['act_as_members_category'], $vbphrase['entries']), 'catinfo[memberscat]', $cat['memberscat']);
		print_yes_no_row($vbphrase['category_is_valid_not_awaiting_moderation'], 'catinfo[valid]', $cat['valid']);
		print_yes_no_row($vbphrase['category_is_active_will_not_appear_ramians_accessible'], 'catinfo[active]', $cat['active']);
	}

	print_yes_no_row(construct_phrase($vbphrase['category_is_open_for_x'], $vbphrase['entries']), 'options[open_for_entries]', $options['open_for_entries'], $jscustom);
	print_yes_no_row(construct_phrase($vbphrase['category_is_open_for_x'], $vbphrase['posts']), 'options[open_for_posts]', $options['open_for_posts'], $jscustom);
	print_yes_no_row($vbphrase['allow_ratings'], 'options[allow_ratings]', $options['allow_ratings'], $jscustom);
	print_yes_no_row(
		$vbphrase['allow_users_create_subcats'] .
		iif(!$members,
			'<div class="smallfont">' . construct_link_code(
				$vbphrase['edit_default_settings_for_sub_cats'],
				'vba_dyna_admin_categories.php?' . $vbulletin->session->vars['sessionurl']  . 'do=subcatopts&amp;cw=1&amp;catid=' . $cat['catid'],
				true
			) . '</div>'
		),
		'catinfo[allowusercats]',
		$cat['allowusercats']
	);

	if (!$members)
	{
		print_table_header($vbphrase['user_options']);
		print_input_row($vbphrase['category_owner_enter_username'], 'catinfo[catusername]', $cat['username']);
		print_yes_no_row(construct_phrase($vbphrase['allow_other_users_view_x'], $vbphrase['entries']), 'useropts[allow_view]', $useropts['allow_view']);
		print_yes_no_row(construct_phrase($vbphrase['allow_other_users_add_x'], $vbphrase['entries']), 'useropts[allow_newentries]', $useropts['allow_newentries']);
		print_yes_no_row(construct_phrase($vbphrase['allow_other_users_reply_x'], $vbphrase['entries']), 'useropts[allow_reply]', $useropts['allow_reply']);
		print_yes_no_row(construct_phrase($vbphrase['allow_other_users_rate_x'], $vbphrase['entries']), 'useropts[allow_rating]', $useropts['allow_rating']);

		print_table_header($vbphrase['access_options']);
		print_input_row($vbphrase['category_password_acts_in_addition_other_permissions'], 'catinfo[password]', $cat['password']);
		print_yes_no_row($vbphrase['apply_this_password_to_child_categories'], 'options[childpass]', $options['childpass']);
		print_yes_no_row($vbphrase['can_have_password'], 'options[canhavepassword]', $options['canhavepassword']);
	}

	print_table_header(construct_phrase($vbphrase['x_message'], $vbphrase['entry']));
	print_yes_no_row($vbphrase['allow_html'], 'options[allow_entry_html]', $options['allow_entry_html'], $jscustom);
	print_yes_no_row($vbphrase['allow_bbcode'], 'options[allow_entry_bbcode]', $options['allow_entry_bbcode'], $jscustom);
	print_yes_no_row($vbphrase['allow_smilies'], 'options[allow_entry_smilies]', $options['allow_entry_smilies'], $jscustom);
	print_yes_no_row($vbphrase['allow_img_code'], 'options[allow_entry_bbimgcode]', $options['allow_entry_bbimgcode'], $jscustom);
	print_yes_no_row($vbphrase['allow_icons'], 'options[allow_entry_icons]', $options['allow_entry_icons'], $jscustom);

	print_table_header($vbphrase['custom_fields']);
	print_yes_no_row($vbphrase['allow_html'], 'options[allow_custom_html]', $options['allow_custom_html'], $jscustom);
	print_yes_no_row($vbphrase['allow_bbcode'], 'options[allow_custom_bbcode]', $options['allow_custom_bbcode'], $jscustom);
	print_yes_no_row($vbphrase['allow_smilies'], 'options[allow_custom_smilies]', $options['allow_custom_smilies'], $jscustom);
	print_yes_no_row($vbphrase['allow_img_code'], 'options[allow_custom_bbimgcode]', $options['allow_custom_bbimgcode'], $jscustom);
	print_yes_no_row($vbphrase['automatically_parse_links_in_text'], 'options[allow_custom_links]', $options['allow_custom_links'], $jscustom);

	print_table_header($vbphrase['posting_options']);
	print_yes_no_row($vbphrase['allow_html'], 'options[allow_post_html]', $options['allow_post_html'], $jscustom);
	print_yes_no_row($vbphrase['allow_bbcode'], 'options[allow_post_bbcode]', $options['allow_post_bbcode'], $jscustom);
	print_yes_no_row($vbphrase['allow_smilies'], 'options[allow_post_smilies]', $options['allow_post_smilies'], $jscustom);
	print_yes_no_row($vbphrase['allow_img_code'], 'options[allow_post_bbimgcode]', $options['allow_post_bbimgcode'], $jscustom);
	print_yes_no_row($vbphrase['allow_icons'], 'options[allow_post_icons]', $options['allow_post_icons'], $jscustom);

	print_table_break();

	print_submit_row($vbphrase['save'], $vbphrase['reset'], 6);
}

?>