<?php
// ++=========================================================================++
// || vBadvanced Dynamics v1.0.0 (vB 3.6 - vB 3.7)
// ||  2003-2007 vBadvanced.com - All Rights Reserved
// || This file may not be redistributed in whole or significant part.
// || http://vbadvanced.com
// ++ ========================================================================++

error_reporting(E_ALL & ~E_NOTICE);

class vba_dyna
{
	var $_permbits = array(
		'main' => array(
			'canviewdyna' => 1,
			'canviewentries' => 2,
			'cansearch' => 4,
			'canrate' => 8,
			'canseewhorated' => 16,
			'cansendtofriend' => 32,
			'canreport' => 64,
			'canviewdeleted' => 128
		),
		'attach' => array(
			'canviewattach' => 1,
			'canattach' => 2,
			'canftpattach' => 4,
			'moderateattach' => 8,
			'canviewthumb' => 16
		),
		'entry' => array(
			'canaddentries' => 1,
			'moderateentries' => 2,
			'caneditentries' => 4,
			'caneditothers' => 8,
			'candelete' => 16,
			'catdeleteothers' => 32,
			'caneditdateline' => 64,
			'canopenclose' => 128,
			'canharddelete' => 256,
			'cansetfeatured' => 512,
			'cansubmitothers' => 1024
		),
		'category' => array(
			'cancreatecats' => 1,
			'moderatecats' => 2,
			'caneditcats' => 4,
			'candeletecats' => 8,
			'canemptycats' => 16,
			'canpasswordcats' => 32,
			'cancatmoderate' => 64,
			'cancaticon' => 128,
			'cancatstyle' => 256
		),
		'posting' => array(
			'canviewreplies' => 1,
			'canreply' => 2,
			'moderateposts' => 4,
			'caneditposts' => 8,
			'caneditothersposts' => 16,
			'candeleteposts' => 32,
			'candeleteothersposts' => 64,
			'canreplyothers' => 128,
			'caneditpostdateline' => 256,
			'canharddeleteposts' => 512
		),
		'module' => array(
			'canmodule' => 1,
			'canaddmodule' => 2
		),
		'guestbook' => array(
			'gb_canview' => 1,
			'gb_canreply' => 2,
			'gb_caneditown' => 4,
			'gb_candeleteown' => 16,
			'gb_caneditothersinown' => 32,
			'gb_candeleteothersinown' => 64,
			'gb_canphysremove' => 128
		)
	);

	// Category options
	var $_categoryopts = array(
		'open_for_entries' 				=> 1,
		'open_for_posts' 					=> 2,
		'allow_post_html' 				=> 4,
		'allow_post_bbcode' 			=> 8,
		'allow_post_smilies' 			=> 16,
		'allow_post_icons' 				=> 32,
		'allow_post_bbimgcode' 		=> 64,
		'allow_post_icons' 				=> 128,
		'allow_custom_html' 			=> 256,
		'allow_custom_bbcode' 		=> 512,
		'allow_custom_smilies' 		=> 1024,
		'allow_custom_bbimgcode'	=> 2048,
		'canhavepassword' 				=> 4096,
		'childpass' 							=> 8192,
		'allow_ratings' 					=> 16384,
		'allow_entry_html' 				=> 32768,
		'allow_entry_bbcode' 			=> 65536,
		'allow_entry_bbimgcode' 	=> 131072,
		'allow_entry_smilies' 		=> 262144,
		'allow_entry_icons' 			=> 524288,
		'allow_custom_links'			=> 1048576
	);

	// User Category Options
	var $_catuseropts = array(
		'allow_view' => 			1,
		'allow_newentries' =>	2,
		'allow_reply' =>			4,
		'allow_rating' =>			8
	);

	// Module Pages
	var $_dyna_pages = array(
		'dyna_index',
		'dyna_browsecategory',
		'dyna_showentry',
		'dyna_newentry',
		'dyna_browsecategory_newentries',
		'dyna_browsecategory_popentries',
		'dyna_browsecategory_favorites',
		'dyna_browsecategory_subscriptions',
		'dyna_search'
	);

	// Column names
	var $_colnames = array(
		1 => 'left',
		2 => 'center_above',
		3 => 'center_below',
		4 => 'right'
	);

	// Module permissionsbit
	var $_modulepermbits = array(
		'canview' 		=> 1,
		'canenable' 	=> 2,
		'candisable'	=> 4
	);

	var $_php_modint = array(
		'load_bbcode_parser' => 1,
		'load_cat_perms' => 2,
		'load_ignusers' => 4,
		'clean_output' => 8,
		'load_forumperms' => 16
	);

	var $_bbc_modint = array(
		'allow_html' => 1,
		'allow_smilies' => 2,
		'allow_image_code' => 4
	);

	var $_shellint = array(
		'enable' => 1,
		'collapse' => 2
	);

	// Category sorting options and links
	var $_catsortoptions = array(
		'username' => 'ASC',
		'lastentrydateline' => 'DESC',
		'lastpostdateline' => 'DESC',
		'entrycount' => 'DESC',
		'postcount' => 'DESC'
	);

	var $_cat = array();
	var $_entry = array();

	var $_attachperms = array();
	var $_catperms = array();
	var $_permissions = array();

	var $_parsedentryids = array();
	var $_parsedinsert = null;

	var $_initload = array();

	// ##### Load entry ##########################################################
	/*
	 * Quick and easy way of loading an entry and running it through all permissions
	*/
	function load_entry($permvar = '', $pagetext = false, $customfields = false, $favorites = false, $subscribe = false, $cache = false, $dellog = false)
	{
		global $entryid, $vbulletin, $vba_options;

		if (!$entryid)
		{
			$this->construct_entry_error('noentryid');
			return;
		}

		// Custom fields
		if ($customfields)
		{
			$fields = ', cfields.*';
			$join = ' LEFT JOIN ' . ADV_DYNA_TABLE_PREFIX . 'cfields_entries AS cfields ON (entries.entryid = cfields.eid)';
		}

		if ($vbulletin->userinfo['userid'])
		{
			// Favorites
			if ($vba_options['dyna_allowfav'] AND $favorites)
			{
				$fields .= ', NOT ISNULL(favorites.entryid) AS isfavorite';
				$join .= ' LEFT JOIN ' . ADV_DYNA_TABLE_PREFIX . 'favorites AS favorites ON (favorites.entryid = entries.entryid AND favorites.userid = ' . $vbulletin->userinfo['userid'] . ')';
			}

			// Subscriptions
			if ($vba_options['dyna_allowsubscribe'] AND $subscribe)
			{
				$fields .= ', NOT ISNULL(subscribeentry.entryid) AS issubscribed';
				$join .= ' LEFT JOIN ' . ADV_DYNA_TABLE_PREFIX . 'subscribeentry AS subscribeentry ON (subscribeentry.entryid = entries.entryid AND subscribeentry.userid = ' . $vbulletin->userinfo['userid'] . ')';
			}
		}

		// Pagetext
		if ($pagetext)
		{
			$fields .= ', pagetext, pages.allowsmilie, pages.pagenumber, pages.title AS pagetitle';
			$join .= 'LEFT JOIN ' . ADV_DYNA_TABLE_PREFIX . 'entries_pages AS pages ON (entries.entryid = pages.entryid AND pages.pagenumber = ' . $vbulletin->GPC['epage'] . ')';

			if ($cache AND $vba_options['dyna_cachedlife'])
			{
				$fields .= ', pagetext_parsed, entryparsed.hasimages';
				$join .= ' LEFT JOIN ' . ADV_DYNA_TABLE_PREFIX . 'entryparsed AS entryparsed ON (entries.entryid = entryparsed.entryid AND entryparsed.languageid = ' . $vbulletin->userinfo['languageid'] . ' AND entryparsed.styleid = ' . $vbulletin->userinfo['styleid'] . ' AND entryparsed.pagenumber = ' . $vbulletin->GPC['epage'] . ')';
			}
		}

		// Deletion log
		if ($dellog)
		{
			$fields .= ', reason';
			$join .= ' LEFT JOIN ' . ADV_DYNA_TABLE_PREFIX . 'deletionlog AS dellog ON (entries.entryid = dellog.deletedid AND type = \'entry\')';
		}

		// showentry.php fields
		if (THIS_SCRIPT == 'dyna_showentry')
		{
			$fields .= ', user.*, IF(user.options & ' . $vbulletin->bf_misc_useroptions['invisible'] . ', 1, 0) AS invisible, rank, avatarpath, NOT ISNULL(customavatar.userid) AS hascustom, customavatar.dateline AS avatardateline, avatarrevision';
			$join .= ' LEFT JOIN ' . TABLE_PREFIX . 'user AS user ON (entries.userid = user.userid)
				LEFT JOIN ' . TABLE_PREFIX . 'avatar as avatar ON (avatar.avatarid = user.avatarid)
				LEFT JOIN ' . TABLE_PREFIX . 'customavatar as customavatar ON (customavatar.userid = user.userid)
			';

			if ($vba_options['dyna_entry_sigs'])
			{
				$fields .= ', usertextfield.signature, signatureparsed';
				$join .= ' LEFT JOIN ' . TABLE_PREFIX . 'sigparsed AS sigparsed ON (entries.userid = sigparsed.userid) ';
			}

			if ($vba_options['dyna_enablemodules'])
			{
				$fields .= ' ,layout';
				$join .= ' LEFT JOIN ' . ADV_DYNA_TABLE_PREFIX . 'layout AS layout ON (entries.userid = layout.userid AND page = \'dyna_showentry\')';
			}
		}

		if (THIS_SCRIPT == 'dyna_newentry')
		{
			$fields .= ', pubdateline';
			$join .= ' LEFT JOIN ' . ADV_DYNA_TABLE_PREFIX . 'entrypublish AS entrypublish ON (entries.entryid = entrypublish.entryid)';
		}

		// Keep entries.* last so info from the user table won't overwrite things
		$this->_entry = $this->vbulletin->db->query_first("
			SELECT buddylist $fields, entries.*, entries.posts AS entry_posts
			FROM " . ADV_DYNA_TABLE_PREFIX . "entries AS entries
			LEFT JOIN " . TABLE_PREFIX . "usertextfield AS usertextfield ON (entries.userid = usertextfield.userid)
			$join
			WHERE entries.entryid = $entryid
		");

		if (!$permvar)
		{
			$permvar = 'canviewentries';
		}

		fetch_entry_url($this->_entry);

		$this->check_entry($this->_entry, $permvar);

	}

	// ##### Check for loaded entry #############################################
	/*
	 * Checks to make sure that an entry has been loaded through
	 * $this->load_entry and prints out an error if not
	 *
	*/
	function check_loaded_entry()
	{
		if (empty($this->_entry))
		{
			global $vbphrase;
			eval(standard_error(fetch_error('noid', $vbphrase['entry_lwr'])));
		}
		return true;
	}

	// ##### Check Entry ########################################################
	/*
	 * Checks a entry to make sure the user has all permissions to view it
	 * Sets $this->_entry if $entry is specified in the params
	 * Also sets $this->_cat since it can be used outside of the load_entry function
 */
	function check_entry($entry = array(), $permvar = 'canviewentries')
	{
		global $vbphrase, $vba_options;

		if (!empty($entry))
		{
			$this->_entry =& $entry;
		}

		if (!$this->_entry['entryid'])
		{
			$this->construct_entry_error('noentryid');
		}

		// Private
		if ($this->_entry['private'] AND $vba_options['dyna_buddyentries'])
		{
			$buddylist = explode(' ', $this->_entry['buddylist']);

			if ($this->vbulletin->userinfo['userid'] != $entry['userid'] AND (!$this->vbulletin->userinfo['userid'] OR empty($buddylist) OR !in_array($this->vbulletin->userinfo['userid'], $buddylist)))
			{
				$this->construct_entry_error('nopermission');
			}
		}

		// Draft or awaiting moderation
		if (($this->_entry['draft'] OR !$this->_entry['valid'] OR $this->_entry['valid'] == 2)
			AND !is_category_mod($this->_entry['catid'])
			AND ($this->vbulletin->userinfo['userid'] != $this->_entry['userid'] OR $this->_entry['valid'] == 2))
		{
			$this->construct_entry_error('noentryid');
		}

		$this->_cat =& $this->vbulletin->adv_dyna_cats[$this->_entry['catid']];

		if ($this->_cat['catuserid'] AND $this->_cat['catuserid'] != $this->vbulletin->userinfo['userid'] AND !$this->_cat['valid'])
		{
			$this->construct_entry_error('nopermission');
		}

		if (!cat_user_opt('allow_view', $this->_entry['catid']) OR !$this->check_cat_perms($permvar, $this->_entry))
		{
			$this->construct_entry_error('nopermission');
		}

		check_category_password($this->_entry['catid']);

	}

	// ##### Construct Errors ###################################################
	function construct_entry_error($error)
	{
		global $vbphrase;

		if (THIS_SCRIPT == 'dyna_showentry')
		{
			define('SF_ERROR', $error);
		}
		else
		{
			if ($error == 'nopermission')
			{
				print_no_permission();
			}
			else
			{
				eval(standard_error(fetch_error('noid', $vbphrase['entry'])));
			}
		}
	}

	// ##### Process entry info ###################################################
	function process_entry_array(&$entry)
	{
		global $vbulletin, $bbcode_parser, $vba_options, $show, $vbphrase, $highlight, $templatename;

		$entry['category'] = $vbulletin->adv_dyna_cats[$entry['catid']]['title'];
		$entry['views'] = vb_number_format($entry['views']);
		$entry['posts'] = vb_number_format($entry['posts']);
		$entry['dateadded'] = vbdate($vbulletin->options['dateformat'], $entry['dateline']);
		$entry['timeadded'] = vbdate($vbulletin->options['timeformat'], $entry['dateline']);
		$entry['lastpostdate'] = vbdate($vbulletin->options['dateformat'], $entry['lastpostdateline']);
		$entry['lastposttime'] = vbdate($vbulletin->options['timeformat'], $entry['lastpostdateline']);
		$entry['statusicon'] = iif($entry['dateline'] > $vbulletin->userinfo['lastvisit'], 'new', 'old');
		$entry['musername'] = fetch_musername($entry);

		if (!$entry['url'])
		{
			fetch_entry_url($entry);
		}

		$show['replyentry'] = false;
		if ($vba_options['dyna_allowreplies'] AND $this->check_cat_perms('canreply', $entry) AND cat_opt('open_for_posts', $entry['catid']) AND cat_user_opt('allow_reply', $entry['catid']))
		{
			$show['replyentry'] = true;
		}

		$show['rateentry'] = false;
		if ($vba_options['dyna_allowrating'] AND $this->check_cat_perms('canrate', $entry) AND cat_opt('allow_ratings', $entry['catid']) AND cat_user_opt('allow_rating', $entry['catid']))
		{
			$show['rateentry'] = true;
		}

		$show['subscribed'] = ($entry['issubscribed']) ? true : false;

		$show['sendtofriend'] = ($this->check_cat_perms('cansendtofriend', $entry)) ? true : false;

		if ($templatename == 'SHOWENTRY' OR $templatename == 'expanded')
		{
			$entry['username_poss'] = fetch_possessive($entry['username']);

			$bbcode_parser->cached = array();

			$vbulletin->options['allowhtml'] = cat_opt('allow_entry_html', $entry['catid']);
			$vbulletin->options['allowbbcode'] = cat_opt('allow_entry_bbcode', $entry['catid']);
			$vbulletin->options['allowbbimagecode'] = cat_opt('allow_entry_bbimgcode', $entry['catid']);
			$vbulletin->options['allowsmilies'] = iif(cat_opt('allow_entry_smilies', $entry['catid']), $entry['allowsmilie'], 0);

			// Fake the URL while processing attachments in bb code
			$vburl = $vbulletin->options['bburl'];
			$vbulletin->options['bburl'] = $vba_options['dyna_homeurl'];

			if (!$vba_options['dyna_cachedlife'])
			{
				$entry['pagetext_parsed'] = $bbcode_parser->do_parse(
					$entry['pagetext'],
					$vbulletin->options['allowhtml'],
					$vbulletin->options['allowsmilies'],
					$vbulletin->options['allowbbcode'],
					$vbulletin->options['allowbbimagecode']
				);
			}
			else
			{
				$entry['pagetext_parsed'] = $bbcode_parser->parse(
					$entry['pagetext'],
					'nonforum',
					$vbulletin->options['allowsmilies'],
					true,
					$entry['pagetext_parsed'],
					$entry['hasimages'],
					($vba_options['dyna_cachedlife'] AND $entry['dateline'] >= (TIMENOW - ($vba_options['dyna_cachedlife'] * 86400)) ? true : false)
				);

				if ($templatename == 'expanded')
				{
					$entry['pagetext_preview'] = fetch_entry_preview($entry['pagetext_parsed']);
				}

				if ($bbcode_parser->cached['text'] AND !in_array($entry['entryid'], $this->_parsedentryids))
				{
					$this->_parsedentryids[] = $entry['entryid'];
					$this->_parsedinsert .= "(
						$entry[entryid],
						" . $vbulletin->GPC['epage'] . ",
						'" . $vbulletin->db->escape_string($bbcode_parser->cached['text']) . "',
						" . TIMENOW . ",
						" . $vbulletin->userinfo['styleid'] . ",
						" . $vbulletin->userinfo['languageid'] . ",
						" . $bbcode_parser->cached['has_images'] . "
					),";
				}
			}

			$vbulletin->options['bburl'] = $vburl;

			// Rank
			if ($entry['rank'])
			{
				$entry['rank'] = str_replace('src="', 'src="' . $vbulletin->options['bburl'] . '/', $entry['rank']);
			}
		}

		// Smilies
		if (!cat_opt('allow_entry_smilies'))
		{
			$entry['allowsmilie'] = 0;
		}

		fetch_full_avatar_url($entry);

		// Replies
		$show['replies'] = true;
		if (!$this->check_cat_perms('canviewreplies', $entry) OR !$vba_options['dyna_allowreplies'])
		{
			$show['replies'] = false;
			$entry['replies'] = 0;
		}

		// Post Icon
		$show['entryicon'] = false;
		if ($entry['iconid'] OR ($vbulletin->options['showdeficon'] AND cat_opt('allow_entry_icon')))
		{
			$show['entryicon'] = true;
		}
		if ($vbulletin->options['showdeficon'] AND !$entry['iconid'])
		{
			$entry['iconpath'] = $vbulletin->options['showdeficon'];
			$entry['icontitle'] = $vbphrase['default'];
		}

		// Rating
		$show['entry_rating'] = false;
		if ($vba_options['dyna_allowrating'] AND $entry['votetotal'] AND $entry['votenum'])
		{
			$entry['truerating'] = vb_number_format($entry['votetotal'] / $entry['votenum'], 2);
			$entry['roundrating'] = round($entry['truerating']);
			$show['entry_rating'] = true;
		}

		fetch_online_status($entry, true);
	}

	// ##### Insert parsed entries ##############################################
	function save_parsed_entries()
	{
		if (!$this->_parsedinsert OR empty($this->_parsedentryids))
		{
			return;
		}

		$this->vbulletin->db->query_write("
			REPLACE INTO " . ADV_DYNA_TABLE_PREFIX . "entryparsed
				(entryid, pagenumber, pagetext_parsed, dateline, styleid, languageid, hasimages)
			VALUES " . substr($this->_parsedinsert, 0, (strlen($this->_parsedinsert) - 1))
		);
	}

	// ##### Convert permissions bitfield to an array ###########################
	function permbits_to_array($usergroupids, $thiscatperms = '', $catid = 0)
	{

		foreach ($usergroupids AS $usergroupid)
		{
			if (!$catid)
			{
				$thiscatperms[$usergroupid] = $this->vbulletin->adv_dyna_perms[$usergroupid]['dyna_perms'];

				// Set this here since it should prevent bad permissions for new usergroups
				if (!isset($thiscatperms[$usergroupid]))
				{
					$usergroupid = 1;
				}
			}

			// Nothing's set, so continue and have it set to the default below
			if (!isset($thiscatperms[$usergroupid]))
			{
				continue;
			}

			foreach ($this->_permbits AS $permgroup => $permarray)
			{
				foreach ($permarray AS $option => $value)
				{
					if (($option == 'moderateentries' OR $option == 'moderateposts' OR $option == 'moderatecats' OR $option == 'moderateattach') AND $this->_catperms[$catid][$option] === 0)
					{
						continue;
					}

					if (!$this->_catperms[$catid][$option] OR $option == 'moderateentries' OR $opton == 'moderateposts' OR $option == 'moderatecats' OR $option == 'moderateattach')
					{
						$this->_catperms[$catid][$option] = 0;

						if ($thiscatperms[$usergroupid][$permgroup] & $value)
						{
							$this->_catperms[$catid][$option] = 1;
						}
					}
				}
			}
		}

		if (!isset($this->_catperms[$catid]))
		{
			$this->_catperms[$catid] = $this->_permissions;
		}
	}

	// ##### Fetch Category Permissions #########################################
	function fetch_category_perms($catid = 0, $ugid = false)
	{
		if ($ugid !== false)
		{
			$usergroupids = array($ugid);
		}
		else
		{
			$usergroupids = fetch_membergroupids_array($this->vbulletin->userinfo);
		}

		$catid = intval($catid);

		if ($catid == 0)
		{
			$idarray =& $this->vbulletin->adv_dyna_cats;
		}
		else
		{
			$idarray = array($catid => $this->vbulletin->adv_dyna_cats[$catid]);
		}

		$this->_catperms['0'] =& $this->_permissions;

		foreach ($idarray AS $catid => $categoryinfo)
		{
			$catperms =& $this->vbulletin->adv_dyna_cats[$catid]['permissions'];

			// Not set for this cat, so use the default
			if (empty($catperms))
			{
				$this->_catperms[$catid] =& $this->_permissions;
				continue;
			}

			$this->permbits_to_array($usergroupids, $catperms, $catid);
		}
	}

	// ##### Fetch Attachment Permissions #######################################
	function fetch_attachment_perms($ugid = false, $settings = false)
	{
		global $vba_image;

		// Already set from a previous call
		if (!empty($this->_attachperms))
		{
			return;
		}

		if ($ugid !== false)
		{
			$usergroupids = array($ugid);
		}
		else
		{
			$usergroupids = fetch_membergroupids_array($this->vbulletin->userinfo);
		}

		$defaultperms = array(
			'attachspace' => $this->_permissions['attachspace'],
			'maxdownloadsize' => $this->_permissions['maxdownloadsize']
		);

		foreach ($this->_permbits['attach'] AS $permvar => $permint)
		{
			$defaultperms[$permvar] = $this->_permissions[$permvar];
		}

		foreach ($this->vbulletin->adv_dyna_attach AS $ext => $attach)
		{
			if (!empty($attach['permissions']))
			{
				foreach ($usergroupids AS $usergroupid)
				{
					// Nothing's set, so continue and have it set to the default below
					if (!isset($attach['permissions'][$usergroupid]))
					{
						continue;
					}

					// Yes/no permissions
					foreach ($this->_permbits['attach'] AS $option => $value)
					{
						if ($option == 'moderateattach' AND $this->_attachperms[$ext][$option] === 0)
						{
							continue;
						}

						if (!$this->_attachperms[$ext][$option] OR $option == 'moderateattach')
						{
							$this->_attachperms[$ext][$option] = 0;

							if ($attach['permissions'][$usergroupid]['attach'] & $this->_permbits['attach'][$option])
							{
								$this->_attachperms[$ext][$option] = 1;
							}
						}
					}

					// Limits
					if (!empty($attach['permissions'][$usergroupid]['limit']))
					{
						foreach ($attach['permissions'][$usergroupid]['limit'] AS $option => $value)
						{
							if ($this->_attachperms[$ext][$option] !== 0 AND $value > $this->_attachperms[$ext][$option])
							{
								$this->_attachperms[$ext][$option] = $value;
							}
						}
					}

					// Settings
					if (!empty($attach['permissions'][$usergroupid]['setting']))
					{
						foreach ($attach['permissions'][$usergroupid]['setting'] AS $option => $value)
						{
							$vba_image->_extcache[$ext][$option] = $value;
						}
					}
				}

				if (!$this->_attachperms[$ext]['canattach'])
				{
					unset($vba_image->_extcache[$ext]);
				}
				else if ($this->_attachperms[$ext]['canftpattach'])
				{
					define('CAN_FTP_ATTACH', true);
				}
			}

			if (!isset($this->_attachperms[$ext]))
			{
				$this->_attachperms[$ext] = $defaultperms;
			}
		}
	}

	// ##### Get default permissions ############################################
	function default_permissions($groupid = false)
	{
		if ($groupid !== false)
		{
			$grouparray = $groupid;
		}
		else
		{
			$grouparray =& $this->vbulletin->userinfo['usergrouparray'];
		}

		$defperms =& $this->vbulletin->adv_dyna_perms;

		$this->permbits_to_array($grouparray);

		$this->_permissions = $this->_catperms['0'];

		unset($this->_catperms['0']);

		// Max categories, attachment space, and download size
		foreach ($grouparray AS $groupid)
		{
			if ($this->_permissions['maxcats'] !== 0 AND $defperms[$groupid]['limit']['maxcats'] > $this->_permissions['maxcats'])
			{
				$this->_permissions['maxcats'] = $defperms[$groupid]['limit']['maxcats'];
			}

			if ($this->_permissions['attachspace'] !== 0 AND $defperms[$groupid]['limit']['attachspace'] > $this->_permissions['attachspace'])
			{
				$this->_permissions['attachspace'] = $defperms[$groupid]['limit']['attachspace'];
			}

			if ($this->_permissions['maxdownloadsize'] !== 0 AND $defperms[$groupid]['limit']['maxdownloadsize'] > $this->_permissions['maxdownloadsize'])
			{
				$this->_permissions['maxdownloadsize'] = $defperms[$groupid]['limit']['maxdownloadsize'];
			}
		}
	}

	// ##### Check default permissions ##########################################
	function check_perms($permvar)
	{
		return $this->_permissions[$permvar];
	}

	// ##### Check Module Permissions ###########################################
	function module_perms($modid, $permbit, $grouparray = array())
	{
		if (empty($grouparray))
		{
			$grouparray =& $this->vbulletin->userinfo['usergrouparray'];
		}

		foreach ($grouparray AS $groupid)
		{
			if ($this->vbulletin->adv_dyna_module[$modid]['userperms'][$groupid] & $this->_modulepermbits[$permbit])
			{
				return true;
			}
		}

		return false;
	}

	// ##### Check category permissions #########################################
	function check_cat_perms($permvar, $iteminfo = array(), $errorout = false)
	{
		if (empty($this->_catperms))
		{
			$this->fetch_category_perms();
		}

		if (empty($iteminfo) AND !empty($this->_entry))
		{
			$iteminfo =& $this->_entry;
		}

		$catid = intval($iteminfo['catid']);

		if (!$this->_catperms[$catid][$permvar] AND $errorout)
		{
			print_no_permission();
		}

		return $this->_catperms[$catid][$permvar];
	}
}

?>