<?php
// ++=========================================================================++
// || vBadvanced Dynamics v1.0.0 (vB 3.6 - vB 3.7)
// ||  2003-2007 vBadvanced.com - All Rights Reserved
// || This file may not be redistributed in whole or significant part.
// || http://vbadvanced.com
// ++ ========================================================================++

error_reporting(E_ALL & ~E_NOTICE);

class vba_dyna_image
{
	// Image types
	var $_imagetypes = array(
		1 => 'gif',
		2 => 'jpg',
		3 => 'png',
		4 => 'swf',
		5 => 'psd',
		6 => 'bmp',
		7 => 'tiff',
		8 => 'tiff',
		9 => 'jpc',
		10 => 'jp2',
		11 => 'jpx',
		12 => 'jb2',
		13 => 'swc',
		14 => 'iff',
		15 => 'wbmp',
		16 => 'xbm'
	);

	var $_info = array();

	var $_errors = array();

	var $_extcache = array();
	var $_extkeys = array();

	// ##### Fetch Upload Info ##################################################
	/*
	 * Takes an array of $_FILE info and gathers needed info about the file
	*/
	function fetch_upload_info()
	{
		// Extension
		$pos = strrpos($this->_info['filename'], '.');
		$this->_info['extension'] = strtolower(substr($this->_info['filename'], $pos + 1));

		// Name
		$this->_info['name'] = str_replace(
			array(' ', '%20'),
			'-',
			substr($this->_info['filename'], 0, $pos)
		);

		$this->_info['name'] = preg_replace(
			"/[^a-z_0-9-]/i",
			'',
			$this->_info['name']
		);

		if ($this->_info['origin'] != 'url')
		{
			$this->_info['filesize'] = filesize($this->_info['location']);
		}

		// Height / width
		$imagesize = @getimagesize($this->_info['location']);
		$this->_info['width'] = $imagesize[0];
		$this->_info['height'] = $imagesize[1];
		$this->_info['type'] = $imagesize[2];
	}

	// ##### Fetch Upload Folders ###############################################
	function fetch_upload_folders($userid)
	{
		$patharray = fetch_upload_path($userid, false);
		$path = implode('/', $patharray);

		$makepath = $this->_vb->adv_dyna_opts['dyna_attachpath'];

		if (!is_dir($makepath . '/' . $path) AND !empty($patharray))
		{
			foreach ($patharray AS $folder)
			{
				$makepath .= '/' . $folder;

				if (!is_dir($makepath))
				{
					mkdir($makepath, 0777);
				}
			}
		}

		return $path;
	}

	// ##### Load attachment types ##############################################
	function load_extensions()
	{
		global $vba_dyna;

		if (empty($this->_vb->adv_dyna_attach))
		{
			return;
		}

		foreach ($this->_vb->adv_dyna_attach AS $extvar => $ext)
		{
			$this->_extcache[$extvar] = $ext;
			$this->_extkeys[] = $extvar;
		}
	}

	// ##### Check Errors #######################################################
	function check_errors($filekey)
	{
		global $vba_dyna, $vba_options, $vbphrase, $userspace, $attachcount;

		// Extension
		if (!in_array($this->_info['extension'], $this->_extkeys) OR ($this->_info['origin'] == 'ftp' AND !$vba_dyna->_attachperms[$this->_info['extension']]['canftpattach']))
		{
			$this->_errors[$filekey][] = array(
				'filename' => $this->_info['filename'],
				'error' => fetch_error('upload_invalid_image_extension', $this->_info['extension'])
			);
		}
		// Only need type and filesize check if extension check is passed
		else
		{
			// Filetype
			if (in_array($this->_info['extension'], array_keys($this->_imagetypes)) AND $this->_imagetypes[$this->_info['type']] != $this->_info['extension'])
			{
				$this->_errors[$filekey][] = array(
					'filename' => $this->_info['filename'],
					'error' => fetch_error('upload_invalid_image_extension', $this->_info['extension'])
				);
			}

			// Filesize
			$maxsize = $this->_extcache[$this->_info['extension']]['size'];
			if ($this->_info['filesize'] > $maxsize)
			{
				$this->_errors[$filekey][] = array(
					'filename' => $this->_info['filename'],
					'error' => fetch_error(
						'upload_file_exceeds_forum_limit',
						fetch_rfilesize($this->_info['filesize']),
						fetch_rfilesize($maxsize)
					)
				);
			}
		}

		// Attachment count
		if ($vba_options['dyna_attachmax'] AND $vba_options['dyna_attachmax'] <= $attachcount)
		{
			$this->_errors[$filekey][] = array(
				'filename' => $this->_info['filename'],
				'error' => fetch_error(ADV_DYNA_PREFIX . '_reached_max_x_attach_for_y',
					$vba_options['dyna_attachmax'],
					$vbphrase['entry_lwr']
				)
			);
		}

		// Total space used
		if ($vba_dyna->_permissions['attachspace'])
		{
			$userspace['used'] += $this->_info['filesize'];

			if ($userspace['used'] > $vba_dyna->_permissions['attachspace'])
			{
				$difference = fetch_rfilesize($userspace['used'] - $vba_dyna->_permissions['attachspace']);

				$this->_errors[$filekey][] = array(
					'filename' => $this->_info['filename'],
					'error' => fetch_error(
						ADV_DYNA_PREFIX . '_attach_quota_met',
						$difference,
						$this->_vb->session->vars['sessionurl']
					)
				);

				$userspace['used'] -= $this->_info['filesize'];
			}
		}
	}

	// ##### Resize Image #######################################################
	/*
	 * Function to resize an image.
	 * @param int $type resizing the original or thumb
	 * @param int $filekey array key for the file being resized - used for errors
	 * @param str $saveto Location & filename to save resized image to
	 *	will resize existing image if none is specified
	 * Based on code from Zoints Local, used with permission
	 * http://zoints.com
	*/
	function resize($type = 'thumb', $filekey, $saveto = '')
	{
		$extcache =& $this->_extcache[$this->_info['extension']];

		// What are we resizing to?
		if ($type == 'thumb')
		{
			$this->_info['hasthumb'] = 0;

			if (!$extcache['thumbnail'])
			{
				return;
			}

			$width = $this->_vb->adv_dyna_opts['dyna_thumbsize'];
			$height = $this->_vb->adv_dyna_opts['dyna_thumbsize'];
			$quality = $this->_vb->adv_dyna_opts['dyna_thumbqlty'];
		}
		else // Original
		{
			$type = 'original';
			$width = $extcache['width'];
			$height = $extcache['height'];
			$quality = 95;
		}

		if (!$this->_info['width'] AND !$this->_info['height'])
		{
			return;
		}

		// Image is already small enough
		if ($this->_info['height'] < $height AND $this->_info['width'] < $width)
		{
			if ($type == 'thumb')
			{
				$this->_info['hasthumb'] = 2;
			}
			return;
		}

		if ($saveto)
		{
			if ($type == 'thumb')
			{
				copy($this->_info['location'], $saveto);
			}
		}
		else
		{
			$saveto = $this->_info['location'];
		}

		if ($this->_info['width'] > $this->_info['height'])
		{
			$percent = $this->_info['width'] / $width;
			$newheight = round($this->_info['height'] / $percent);
			if ($newheight <= $height)
			{
				$height = $newheight;
			}
			else
			{
				$doheight = true;
			}
		}

		if ($doheight OR $this->_info['width'] < $this->_info['height'])
		{
			$percent = $this->_info['height'] / $height;
			$width = round($this->_info['width'] / $percent);
		}

		// ##### Image Magick
		if ($this->_vb->options['imagetype'] == 'Magick')
		{
			switch ($this->_info['type'])
			{
				// png
				case 3:
					/* No quality for png's since -quality compresses and isn't consistant with other extensions */
					$command = 'mogrify -filter Point -resize ' . $width . 'x' . $height . ' -quality 0 "' . $saveto . '"';
				break;

				// gif
				case 1:
					/* quality has no effect on gifs */
					$command = 'convert "' . $this->_info['location'] . '" -filter Point -size ' . $width . 'x' . $height . ' -coalesce -geometry ' . $width . 'x' . $height . ' -deconstruct "' . $saveto . '"';
				break;

				// jpg / rest
				default:
					/* quality '0' = no compression */
					$quality = max(1, min(100, $quality));
					$command = 'mogrify -resize ' . $width . 'x' . $height . ' -quality ' . $quality . ' "' . $saveto . '"';
					break;
			}

			$command = $this->_vb->options['magickpath'] . $command;
			system($command, $imerror);

			// Set the new dimensions / filesize
			if ($type == 'original')
			{
				// Error!
				if ($imerror)
				{
					$this->_errors[$filekey][] = array(
						'filename' => $this->_info['filename'],
						'error' => fetch_error('upload_exceeds_dimensions', $width, $height, $this->_info['width'], $this->_info['height'])
					);

					return;
				}

				$this->_info['width'] = $width;
				$this->_info['hight'] = $height;

				clearstatcache();
				$this->_info['filesize'] = filesize($saveto);
			}
		}

		// ##### GD
		else
		{
			switch ($this->_info['type'])
			{
				case 3:
					$im = imagecreatefrompng($saveto);
				break;

				case 1:
					$im = imagecreatefromgif($saveto);
				break;

				default:
					$im = imagecreatefromjpeg($saveto);
				break;
			}

			if (!$im)
			{
				return;
			}

			$im2 = imagecreatetruecolor($width, $height);
			imagecopyresized($im2, $im, 0, 0, 0, 0, $width, $height, $this->_info['width'], $this->_info['height']);

			switch ($this->type)
			{
				case 3:
					$im = imagepng($im2, $saveto);
				break;

				case 1:
					$im = imagegif($im2, $saveto);
				break;

				default:
					$im = imagejpeg($im2, $saveto);
				break;
			}

			unset($im, $im2);

			// Set the new dimensions / filesize
			if ($type == 'original')
			{
				$this->_info['width'] = $width;
				$this->_info['hight'] = $height;

				clearstatcache();
				$this->_info['filesize'] = filesize($saveto);
			}
		}

		if ($type == 'thumb')
		{
			$this->_info['hasthumb'] = 1;
		}

		return;
	}
}

?>