<?php
// ++=========================================================================++
// || vBadvanced Dynamics v1.0.0 (vB 3.6 - vB 3.7)
// ||  2003-2007 vBadvanced.com - All Rights Reserved
// || This file may not be redistributed in whole or significant part.
// || http://vbadvanced.com
// ++ ========================================================================++

error_reporting(E_ALL & ~E_NOTICE);

// ##### Fetch Moderator Categories ###########################################
function fetch_moderator_cats()
{
	global $vbulletin, $vba_options, $permissions;

	$modcats = array();

	if (!($permissions['adminpermissions'] & $vbulletin->bf_ugp_adminpermissions['cancontrolpanel']))
	{
		if (!empty($vbulletin->adv_dyna_mods))
		{
			foreach ($vbulletin->adv_dyna_mods AS $mcat => $mcatinfo)
			{
				if ($mcatinfo[$vbulletin->userinfo['userid']])
				{
					$modcats[] = $mcat;
				}
			}
		}

		if (empty($modcats))
		{
			print_no_permission();
		}
	}

	return $modcats;
}

// ##### Update attachment count ##############################################
function update_entry_attach_count($updateentries)
{
	global $db, $vba_options;

	$hasattach = array();
	$getattach = $db->query_read("
		SELECT attachment.attachmentid, attachment.entryid, attachid, hasthumb
		FROM " . ADV_DYNA_TABLE_PREFIX . "attachments AS attachment
		LEFT JOIN " . ADV_DYNA_TABLE_PREFIX . "attachmenttype AS attachtype ON(attachment.extension = attachtype.extension)
		LEFT JOIN " . ADV_DYNA_TABLE_PREFIX . "entries AS entry ON (attachment.entryid = entry.entryid)
		WHERE attachment.entryid IN(" . implode(',', $updateentries) . ")
			AND attachment.valid = 1
		ORDER BY attachtype.displayorder ASC, attachment.dateline ASC
	");
	while ($attach = $db->fetch_array($getattach))
	{
		$hasattach[$attach['entryid']]['count']++;

		if ($attach['attachid'])
		{
			$hasattach[$attach['entryid']]['attachid'] = $attach['attachid'];
		}
		else if ($vba_options['dyna_entrybit_showattach'] != 2 OR ($vba_options['dyna_entrybit_showattach'] == 2 AND $attach['hasthumb']))
		{
			$hasattach[$attach['entryid']]['attachid'] = $attach['attachmentid'];
		}
	}

	if (empty($hasattach))
	{
		return;
	}

	foreach ($hasattach AS $aentryid => $ainfo)
	{
		$db->query_write("
			UPDATE " . ADV_DYNA_TABLE_PREFIX . "entries SET
				hasattach = $ainfo[count],
				attachid = " . intval($ainfo['attachid']) . "
			WHERE entryid = $aentryid
		");
	}
}

// ##### Process Cookie List ##################################################
function process_cookie_list()
{
	global $vbulletin, $cookielist, $vbphrase;

	switch ($vbulletin->GPC['type'])
	{
		case 'post':
			$abbr = 'p';
			$listabbr = 'p';
			$errorphrase = 'posts';
		break;
		case 'attach':
			$abbr = 'a';
			$listabbr = 't';
			$errorphrase = 'attachments';
		break;
		default:
			$abbr = 'e';
			$listabbr = 't';
			$errorphrase = 'entries';
	}

	$cookielist = (trim($cookielist)) ? explode('-', $cookielist) : array();

	if (!empty($cookielist))
	{
		$cookielist = array_unique(array_merge($cookielist, array_keys($vbulletin->GPC[$listabbr . 'list'])));
	}

	if (empty($cookielist))
	{
		eval(standard_error(fetch_error(ADV_DYNA_PREFIX . '_no_valid_x', $vbphrase[$errorphrase])));
	}

	$ids = array();
	foreach ($cookielist AS $listid)
	{
		if (substr($listid, 0, 2) == $abbr . '_')
		{
			$ids[] = intval(substr($listid, 2));
		}
	}

	if (empty($ids))
	{
		eval(standard_error(fetch_error(ADV_DYNA_PREFIX . '_no_valid_x', $vbphrase[$errorphrase])));
	}

	return $ids;
}

// ##### Delete Entries #######################################################
function delete_entries($entryarray)
{
	global $db, $vba_options;

	if (is_array($entryarray))
	{
		$entryarray = implode(',', array_map('intval', $entryarray));
	}

	if (!$entryarray)
	{
		return;
	}

	$db->query_write("DELETE FROM " . ADV_DYNA_TABLE_PREFIX . "entries WHERE entryid IN ($entryarray)");
	$db->query_write("DELETE FROM " . ADV_DYNA_TABLE_PREFIX . "entries_pages WHERE entryid IN ($entryarray)");
	$db->query_write("DELETE FROM " . ADV_DYNA_TABLE_PREFIX . "entryparsed WHERE entryid IN ($entryarray)");
	$db->query_write("DELETE FROM " . ADV_DYNA_TABLE_PREFIX . "posts WHERE entryid IN ($entryarray)");
	$db->query_write("DELETE FROM " . ADV_DYNA_TABLE_PREFIX . "favorites WHERE entryid IN ($entryarray)");
	$db->query_write("DELETE FROM " . ADV_DYNA_TABLE_PREFIX . "subscribeentry WHERE entryid IN ($entryarray)");
	$db->query_write("DELETE FROM " . ADV_DYNA_TABLE_PREFIX . "cfields_entries WHERE eid IN ($entryarray)");

	$attachments = array();
	$getattach = $db->query_read("
		SELECT filename, attachments.dateline, extension, hasthumb, attachments.userid
		FROM " . ADV_DYNA_TABLE_PREFIX . "attachments AS attachments
		LEFT JOIN " . ADV_DYNA_TABLE_PREFIX . "entries AS entry ON (attachments.entryid = entry.entryid)
		WHERE attachments.entryid IN ($entryarray)
	");
	while ($attach = $db->fetch_array($getattach))
	{
		$folderpath = $vba_options['dyna_attachpath'] . '/' . fetch_upload_path($attach['userid']) . '/';

		@unlink($folderpath . $attach['filename'] . '_' . $attach['dateline'] . '.' . $attach['extension']);

		if ($attach['hasthumb'])
		{
			@unlink($folderpath . $attach['filename'] . '_' . $attach['dateline'] . '_thumb.' . $attach['extension']);
		}
	}

	$db->free_result($getattach);

	$db->query_write("DELETE FROM " . ADV_DYNA_TABLE_PREFIX . "attachments WHERE entryid IN ($entryarray)");
}

?>