<?php
// ++=========================================================================++
// || vBadvanced Dynamics v1.0.0 (vB 3.6 - vB 3.7)
// ||  2003-2007 vBadvanced.com - All Rights Reserved
// || This file may not be redistributed in whole or significant part.
// || http://vbadvanced.com
// ++ ========================================================================++

error_reporting(E_ALL & ~E_NOTICE);

// ##### Load User Module #####################################################
function load_user_module($editing = true)
{
	global $vbulletin, $vbphrase;

	if (!$vbulletin->GPC['modlinkid'] AND !$vbulletin->GPC['modid'])
	{
		eval(standard_error(fetch_error('noid', $vbphrase['module'])));
	}

	if ($vbulletin->GPC['modlinkid'])
	{
		$module = $vbulletin->db->query_first("
			SELECT modules.*, modules_user.modlinkid, modules_user.code, modules_user.userid, modules_user.title, allowsmilie
			FROM " . ADV_DYNA_TABLE_PREFIX . "modules_user AS modules_user
			LEFT JOIN " . ADV_DYNA_TABLE_PREFIX . "modules AS modules ON (modules_user.modid = modules.modid AND modules_user.userid = " . $vbulletin->userinfo['userid'] . ")
			WHERE modlinkid = " . $vbulletin->GPC['modlinkid']
		);

		if (!$module['modlinkid'])
		{
			eval(standard_error(fetch_error('noid', $vbphrase['module'])));
		}

		if ($module['userid'] != $vbulletin->userinfo['userid'])
		{
			print_no_permission();
		}
	}
	else
	{
		$module = $vbulletin->db->query_first("
			SELECT modules.*, modules_user.modlinkid, modules_user.code
			FROM " . ADV_DYNA_TABLE_PREFIX . "modules AS modules
			LEFT JOIN " . ADV_DYNA_TABLE_PREFIX . "modules_user AS modules_user ON (modules.modid = modules_user.modid AND modules_user.userid = " . $vbulletin->userinfo['userid'] . ")
			WHERE modules.modid = " . $vbulletin->GPC['modid']
		);

		if (!$module['modid'])
		{
			eval(standard_error(fetch_error('noid', $vbphrase['module'])));
		}

		if ($editing)
		{
			if (!@is_file(DIR . '/vba_dyna_modules/edit_' . $module['filename']))
			{
				eval(standard_error(fetch_error(ADV_DYNA_PREFIX . '_module_not_editable')));
			}
		}
	}

	return $module;
}

// ##### Function to save a layout ############################################
function construct_dyna_page_layout()
{
	global $vbulletin, $vba_dyna;

	$vbulletin->input->clean_array_gpc('p', array(
		'mods' => TYPE_ARRAY,
		'removemods' => TYPE_ARRAY
	));

	$layout = array();
	$colnames = array();
	foreach ($vba_dyna->_colnames AS $colno => $colname)
	{
		$colnames[] = $colno;
		$layout[$colno] = array();
	}

	// Cache the modules to get the user's modids
	cache_modules();
	$validmodids = array_keys($vbulletin->adv_dyna_module);

	$modarray = array_diff(array_keys($vbulletin->GPC['mods']), $vbulletin->GPC['removemods']);
	$modarray = array_intersect($modarray, $validmodids);

	if (!empty($modarray))
	{
		foreach ($modarray AS $modid)
		{
			$mod =& $vbulletin->GPC['mods'][$modid];
			// Check that the values are
			if ($mod['column'] AND in_array($mod['column'], $colnames))
			{
				$layout[$mod['column']][$modid] = intval($mod['displayorder']);
			}
		}
	}

	if (!empty($layout))
	{
		foreach ($layout AS $column => $mods)
		{
			asort($layout[$column], SORT_NUMERIC);
		}
	}
	return $layout;
}

// ##### Fetch All Modules ####################################################
function cache_modules()
{
	global $vbulletin;

	$getmods = $vbulletin->db->query_read("
		SELECT *
		FROM " . ADV_DYNA_TABLE_PREFIX . "modules_user
		WHERE userid = " . $vbulletin->userinfo['userid']
	);
	while ($mods = $vbulletin->db->fetch_array($getmods))
	{
		$id = $mods['modid'];

		if ($mods['modid'])
		{
			// Have to merge to keep permissions and etc from original array
			$mods = array_merge($vbulletin->adv_dyna_module[$id], $mods);
		}
		else
		{
			$id = 'u' . $mods['modlinkid'];
			$mods['custom'] = 1;
		}

		$vbulletin->adv_dyna_module[$id] = $mods;
	}
}

// ##### Fetch Move Module Inputs #############################################
function fetch_move_inputs($column)
{
	global $vbphrase;

	switch ($column)
	{
		case 1:
			return '<option value="2">' . $vbphrase['center_above_column'] . '</option>
				<option value="3">' . $vbphrase['center_below_column'] . '</option>
				<option value="4">' . $vbphrase['right_column'] . '</option>';
		break;

		case 2:
			return '<option value="1">' . $vbphrase['left_column'] . '</option>
				<option value="3">' . $vbphrase['center_below_column'] . '</option>
				<option value="4">' . $vbphrase['right_column'] . '</option>';
		break;

		case 3:
			return '<option value="1">' . $vbphrase['left_column'] . '</option>
				<option value="2">' . $vbphrase['center_above_column'] . '</option>
				<option value="4">' . $vbphrase['right_column'] . '</option>';
		break;
		case 4:
			return '<option value="1">' . $vbphrase['left_column'] . '</option>
				<option value="2">' . $vbphrase['center_above_column'] . '</option>
				<option value="3">' . $vbphrase['center_below_column'] . '</option>';
		break;
	}
}

// ##### Fetch User Layout ####################################################
function fetch_user_layout($page)
{
	global $vbulletin;

	$dynauser = $vbulletin->db->query_first("
		SELECT layout
		FROM " . ADV_DYNA_TABLE_PREFIX . "layout
		WHERE userid = " . $vbulletin->userinfo['userid'] . "
			AND page = '" . $vbulletin->db->escape_string($page) . "'
	");

	if ($dynauser['layout'])
	{
		return unserialize($dynauser['layout']);
	}

	return $vbulletin->adv_dyna_modpos[$page];
}

// ##### Fetch Inactive Modulebits ############################################
function fetch_inactive_modulebits()
{
	global $vbulletin, $vba_dyna, $vbphrase, $stylevar, $dyna_module_layout, $activemodules, $controls_endlink;
	global $show;

	$vbulletin->input->clean_gpc('c', 'inactivesize', TYPE_INT);

	$show['inactivesize'] = ($vbulletin->GPC['inactivesize']) ? max(50, $vbulletin->GPC['inactivesize']) : 150;

	// Get the descriptions
	$getmoddesc = $vbulletin->db->query_read("SELECT modid, description FROM " . ADV_DYNA_TABLE_PREFIX . "modules");
	while ($moddesc = $vbulletin->db->fetch_array($getmoddesc))
	{
		$vbulletin->adv_dyna_module[$moddesc['modid']]['description'] = $moddesc['description'];
	}

	$colopts = array(
		'left_column' => '',
		'center_above_column' => '',
		'center_below_column' => '',
		'right_column' => ''
	);

	// Format the select options for inactive modules
	if (!empty($dyna_module_layout))
	{
		foreach ($dyna_module_layout AS $dyna_column => $dyna_moduleids)
		{
			if (!empty($dyna_moduleids))
			{
				foreach ($dyna_moduleids AS $dyna_modid => $dyna_modorder)
				{
					$mods = $vbulletin->adv_dyna_module[$dyna_modid];
					$dyna_colname = $vba_dyna->_colnames[$dyna_column];

					$colopts[$dyna_colname] .= '<option value="' . $dyna_column . '-' . $dyna_modid . '">- ' . construct_phrase($vbphrase['after_x'], $mods['title']) . '</option>';
				}
			}
		}
	}

	// Inactive modules
	$inactivemodids = array_diff(array_keys($vbulletin->adv_dyna_module), $activemodules);

	foreach ($inactivemodids AS $modid)
	{
		$module = $vbulletin->adv_dyna_module[$modid];

		if (!$module['userid'] AND !$vba_dyna->module_perms($modid, 'canenable'))
		{
			continue;
		}

		$show['editmod'] = false;
		$show['trashmod'] = false;

		if ($module['userid'] OR $module['useredit'])
		{
			$show['editmod'] = true;

			if ($module['userid'])
			{
				$firstcustommod = true;
				$show['trashmod'] = true;
			}
		}

		$show['inactivemodules'] = true;

		eval('$modbits .= "' . fetch_template(ADV_DYNA_PREFIX . '_editmodules_inactivebits') . '";');

		$firstmodshown = true;
		if ($firstcustommod)
		{
			$firstcustomshown = true;
		}
	}

	return $modbits;
}

// ##### Fetch Layout Redirect URL ############################################
function fetch_layout_redirect($aname = true)
{
	global $vba_dyna, $vbulletin, $entryid, $catid, $entryuserid, $modid;

	if ($entryid)
	{
		$vba_dyna->load_entry();
		fetch_entry_url($vba_dyna->_entry, 'editmods=1');
		$redirect = $vba_dyna->_entry['url'];
	}
	else
	{
		$redirect = fetch_cat_url(
			$catid,
			iif($entryuserid,
				array('title' => $vbulletin->userinfo['username'], 'userid' => $vbulletin->userinfo['userid']),
				array()
			),
			iif(!intval($catid), 'member'),
			'editmods=1'
		);
	}

	if ($aname AND $modid)
	{
		$redirect .= '#dyna_mod_' . $modid;
	}

	return $redirect;
}

?>