<?php
// ++=========================================================================++
// || vBadvanced Dynamics v1.0.0 (vB 3.6 - vB 3.7)
// ||  2003-2007 vBadvanced.com - All Rights Reserved
// || This file may not be redistributed in whole or significant part.
// || http://vbadvanced.com
// ++ ========================================================================++

error_reporting(E_ALL & ~E_NOTICE);

// ###################### Function To Check Errors ############################
function check_entry_errors(&$entry)
{
	global $vbulletin, $vba_dyna, $entryid, $vba_options, $vbphrase, $posthash, $_POST;
	global $errorhighlight, $errors;

	$errors = array();
	$errorhighlight = array();

	// ##### Catid
	if (!$entry['catid'])
	{
		eval('$errors[] = "' . fetch_error(ADV_DYNA_PREFIX . '_must_choose_x_for_your_y', $vbphrase['category_lwr'], $vbphrase['entry_lwr']) . '";');
		$errorhighlight['category'] = true;
	}

	// ##### Image verification
	$imageerror = check_human_verify('newentry');
	
	if ($imageerror)
	{
		eval('$errors[] = "' . $imageerror . '";');
		$errorhighlight['imagereg'] = true;
	}

	// ##### Check title/pagetext
	if ($_POST['do'] != 'newentry' AND (!$entry['title'] OR !$entry['pagetext']))
	{
		eval('$errors[] = "' . addslashes(fetch_error('requiredfieldmissing', $vbphrase['message'])) . '";');
		if (!$entry['title'])
		{
			$errorhighlight['title'] = true;
		}
		if (!$entry['pagetext'])
		{
			$errorhighlight['message'] = true;
		}
	}

	// ##### Check max title length
	if ($vba_options['dyna_maxtitlelength'] AND strlen($entry['title']) > $vba_options['dyna_maxtitlelength'])
	{
		eval('$errors[] = "' . fetch_error(ADV_DYNA_PREFIX . '_x_too_long', $vbphrase['title'], vb_number_format(strlen($entry['title'])), vb_number_format($vba_options['dyna_maxtitlelength'])) . '";');
		$errorhighlight['title'] = true;
	}

	// ##### Check message length
	$entrylength = strlen($entry['pagetext']);
	if ($vba_options['dyna_maxdesclength'] AND $entrylength > $vba_options['dyna_maxdesclength'])
	{
		eval('$errors[] = "' . fetch_error(ADV_DYNA_PREFIX . '_x_too_long', $vbphrase['post'], vb_number_format($entrylength), vb_number_format($vba_options['dyna_maxdesclength'])) . '";');
		$errorhighlight['message'] = true;
	}

	// ##### Guest username check
	if (!$vbulletin->userinfo['userid'])
	{
		if (!$vbulletin->GPC['username'])
		{
			eval('$errors[] = "' . fetch_error('nousername') . '";');
			$errorhighlight['username'] = true;
		}
		else if (strlen($vbulletin->GPC['username']) < $vbulletin->options['minuserlength'])
		{
			eval('$errors[] = "' . fetch_error('usernametooshort', $vbulletin->options['minuserlength']) . '";');
			$errorhighlight['username'] = true;
		}
		else if (strlen($vbulletin->GPC['username']) > $vbulletin->options['maxuserlength'])
		{
			eval('$errors[] = "' . fetch_error('usernametoolong', $vbulletin->options['maxuserlength']) . '";');
			$errorhighlight['username'] = true;
		}
		else if ($dupecheck = $vbulletin->db->query_first("SELECT userid FROM " . TABLE_PREFIX . "user WHERE username = '" . $vbulletin->db->escape_string($vbulletin->GPC['username']) . "'"))
		{
			eval('$errors[] = "' . fetch_error('usernametaken', addslashes(htmlspecialchars($vbulletin->GPC['username'])), $vbulletin->session->vars['sessionurl']) . '";');
			$errorhighlight['username'] = true;
		}
	}

	// ##### Duplicate post / flood check
	if ($_POST['do'] == 'doaddentry' AND $vbulletin->userinfo['userid'] AND !($permissions['adminpermissions'] & $vbulletin->bf_ugp_adminpermissions['cancontrolpanel']) AND !can_moderate())
	{
		$lentry = $vbulletin->db->query_first("
			SELECT entry.entryid, entry.title, pagetext, dateline
			FROM " . ADV_DYNA_TABLE_PREFIX . "entries AS entry
			LEFT JOIN " . ADV_DYNA_TABLE_PREFIX . "entries_pages AS entry_pages ON(entry.entryid = entry_pages.entryid AND pagenumber = 1)
			WHERE userid = " . $vbulletin->userinfo['userid'] . "
			ORDER BY dateline
		");

		// Have the same entry, so redirect the user
		if ($lentry['entryid'] AND $entry['pagetext'] == $lentry['pagetext'] AND $entry['title'] == $lentry['title'])
		{
			$vbulletin->url = fetch_entry_url($lentry);
			eval(print_standard_redirect('redirect_postthanks'));
		}

		// Have flooding, display error
		if ($vbulletin->options['floodchecktime'] AND !$vbulletin->GPC['preview'] AND (TIMENOW - $lentry['dateline']) <= $vbulletin->options['floodchecktime'])
		{
			eval('$errors[] = "' . fetch_error('postfloodcheck', $vbulletin->options['floodchecktime'], ($vbulletin->options['floodchecktime'] - (TIMENOW - $lentry['dateline']))) . '";');
		}
	}

	// ##### Max images
	if ($vba_options['dyna_maxentryimages'])
	{
		require_once('./includes/class_bbcode_alt.php');
		$bbcode_parser =& new vB_BbCodeParser_ImgCheck($vbulletin, fetch_tag_list());

		$imagecount = fetch_character_count($bbcode_parser->parse($entry['pagetext'], 'nonforum', $entry['enablesmilies'], true), '<img');

		if ($imagecount > $vba_options['dyna_maxentryimages'])
		{
			eval('$errors[] = "' . fetch_error('toomanyimages', $imagecount, $vba_options['dyna_maxentryimages']) . '";');
			$errorhighlight['message'] = true;
		}
	}

	// ##### Custom fields
	$cfields = array();
	if (!empty($vbulletin->adv_dyna_cfield))
	{
		foreach ($vbulletin->adv_dyna_cfield AS $cfieldid => $custom)
		{
			if (!check_custom_field_cats($custom, $entry))
			{
				continue;
			}

			$postfield =& $_POST['field' . $custom['fieldid']];

			// Field required?
			if ($custom['required'] AND empty($postfield))
			{
				eval('$errors[] = "' . addslashes(fetch_error('requiredfieldmissing', $custom['title'])) . '";');
				$errorhighlight['custom_' . $custom['fieldid']] = true;
			}

			switch ($custom['type'])
			{
				// ##### Multiple select / checkbox
				case 'multiple_select':
				case 'checkbox':
					if (!is_array($postfield))
					{
						$postfield = array();
					}
					else
					{
						if (sizeof(array_intersect($custom['options'], array_map('htmlspecialchars', $postfield))) != sizeof($postfield))
						{
							trigger_error('Invalid custom field input.', E_USER_ERROR);
						}

						if ($custom['maxchoices'] AND sizeof($postfield) > $custom['maxchoices'])
						{
							eval('$errors[] = "' . fetch_error('checkboxsize', $custom['maxchoices'], addslashes($custom['title'])) . '";');
							$errorhighlight['custom_' . $custom['fieldid']] = true;
						}
					}
				break;

				// ##### Single select / radio
				case 'select':
				case 'radio':

					if ($postfield AND !in_array($postfield, $custom['options']))
					{
						trigger_error('Invalid custom field input.', E_USER_ERROR);
					}

				break;

				// ##### text / textarea
				default:

					// Check field length
					$postlength = strlen($postfield);
					if (($custom['type'] == 'text' OR $custom['type'] == 'textarea') AND $postlength > $custom['maxlength'] AND $custom['maxlength'])
					{
						eval('$errors[] = "<strong>$custom[title]</strong>: ' . fetch_error('toolong', vb_number_format($postlength), vb_number_format($custom['maxlength'])) . '";');
						$errorhighlight['custom_' . $custom['fieldid']] = true;
					}
				break;
			}
		}
	}

	// ##### Require attachments / counts
	if ($entry['attachcount'] < $vba_options['dyna_require_attach'])
	{
		$needed = $vba_options['dyna_require_attach'] - $entry['attachcount'];
		eval('$errors[] = "' . fetch_error(ADV_DYNA_PREFIX . '_must_include_attachment', $vba_options['dyna_require_attach'], $vbphrase['entry_lwr'], $needed) . '";');
		$errorhighlight['attach'] = true;
	}

	// Custom dateline
	if ($vba_dyna->check_cat_perms('caneditdateline'))
	{
		check_custom_dateline_value();
	}

	// Publish Date
	if ($vba_options['dyna_allowdrafts']
		AND
		($vbulletin->GPC['pubdate']['month']
			OR $vbulletin->GPC['pubdate']['day']
			OR $vbulletin->GPC['pubdate']['year']
		)
	)
	{
		if (!$vbulletin->GPC['draft'])
		{
			eval('$errors[] = "' . fetch_error(ADV_DYNA_PREFIX . '_must_check_draft_to_auto_publish', $vbphrase['entry_lwr']) . '";');
			$errorhighlight['pubdate'] = true;
		}
		else if ($entry['pubdateline'] AND $entry['pubdateline'] < TIMENOW)
		{
			eval('$errors[] = "' . fetch_error(ADV_DYNA_PREFIX . '_cannot_publish_in_the_past', $vbphrase['entry_lwr']) . '";');
			$errorhighlight['pubdate'] = true;
		}
		else
		{
			check_custom_dateline_value('pubdate');
		}
	}

	// Submit as user check
	if ($vbulletin->GPC['submitas'] AND !$entry['userid'])
	{
		eval('$errors[] = "' . fetch_error('invalid_username_specified') . '";');
		$errorhighlight['submitas'] = true;
	}

	($hook = vBulletinHook::fetch_hook('vba_dyna_functions_saveentry_errors')) ? eval($hook) : false;

	return $errors;
}

// ######################### Create Custom Fields #############################
function construct_custom_fieldbits($entry, $custominfo = '', $editing = false, $admin = false, $makearray = false)
{
	global $db, $vbphrase, $stylevar, $errorhighlight, $vbulletin;
	global $cfieldids;

	// Fetch the info, then loop through it incase we're dealing with multiple entries
	$custominfo =& $vbulletin->adv_dyna_cfield;

	$cfieldids = array();
	$cfbits = array(
		'above_message' => '',
		'below_message' => ''
	);

	($hook = vBulletinHook::fetch_hook('vba_dyna_functions_saveentry_cfieldbits_start')) ? eval($hook) : false;

	if (!empty($custominfo))
	{
		foreach ($custominfo AS $field)
		{
			// Make sure the field applies to this category
			if (!check_custom_field_cats($field, $entry))
			{
				continue;
			}

			$cfieldids[] = $field['fieldid'];

			if (!$field['position_submit'])
			{
				$field['position_submit'] = 'below_message';
			}

			$fieldname = 'field' . $field['fieldid'];
			$inputname = 'field' . $field['fieldid'] . iif($makearray, '[' . $entry['entryid'] . ']');

			if (($field['type'] == 'checkbox' OR $field['type'] == 'multiple_select') AND $entry[$fieldname])
			{
				if ($editing)
				{
					$entry[$fieldname] = unserialize($entry[$fieldname]);
				}
				else
				{
					$entry[$fieldname] = array_map('htmlspecialchars', $entry[$fieldname]);
				}
			}

			// String
			if (!is_array($entry[$fieldname]))
			{
				$entry[$fieldname] = htmlspecialchars($entry[$fieldname]);
			}

			switch ($field['type'])
			{
				// ##### Select
				case 'select':

					if (!empty($field['options']))
					{
						$inputbox = '<select name="' . $inputname . '" tabindex="1" id="' . $inputname . '"' . iif($field['maxlength'], ' style="width: ' . $field['maxlength'] . 'px"') . '>';
						$inputbox .= '<option value="">' . $vbphrase['please_select_one'] . '</option>';

						foreach ($field['options'] AS $option)
						{
							$inputbox .= '<option ' . iif($entry[$fieldname] == $option, 'selected="selected"') . ' value="' . $option . '">' . $option . '</option>';
						}
						$inputbox .= '</select>';
					}
				break;

				// ##### Multiple Select
				case 'multiple_select':

					if (!empty($field['options']))
					{
						$optioncount = sizeof($field['options']);

						if (!is_array($entry[$fieldname]))
						{
							$entry[$fieldname] = array();
						}

						$inputbox = '<select name="' . $inputname . '[]" size="' . ($optioncount < $field['size'] ? $optioncount : $field['size']) . '" multiple="multiple" tabindex="1" id="' . $inputname . '"' . iif($field['maxlength'], ' style="width: ' . $field['maxlength'] . 'px"') . '>';

						foreach ($field['options'] AS $option)
						{
							$inputbox .= '<option ' . iif(in_array($option, $entry[$fieldname]), 'selected="selected"') . ' value="' . $option . '">' . $option . '</option>';
						}
						$inputbox .= '</select>';
					}
				break;

				// ##### Radio
				case 'radio':
					foreach ($field['options'] AS $key => $option)
					{
						$inputbox .= '<div><label for="' . $inputname . '_' . $key . '"><input id="' . $inputname . '_' . $key . '" name="' . $inputname . '" ' . iif($entry[$fieldname] == $option, 'checked="checked"') . ' type="radio" value="' . $option . '"' . iif(!$key, ' tabindex="1"') . '>' . $option . '</label></div>';
					}
				break;

				// ##### Checkbox
				case 'checkbox':

					if (!empty($field['options']))
					{
						if (!is_array($entry[$fieldname]))
						{
							$entry[$fieldname] = array();
						}

						foreach ($field['options'] AS $key => $option)
						{
							$inputbox .= '<label for="' . $inputname . '_' . $key . '"><input id="' . $inputname . '_' . $key . '" name="' . $inputname . '[]" ' . iif(in_array($option, $entry[$fieldname]), 'checked="checked"') . ' type="checkbox" value="' . $option . '"' . iif(!$key, ' tabindex="1"') . '>' . $option . '</label><br />';
						}
					}
				break;

				// ##### Textarea
				case 'textarea':
					$inputbox = '<textarea class="bginput" cols="' . $field['size'] . '" name="' . $inputname . '" rows="' . $field['height'] . '" maxlength="' . $field['maxlength'] . '" tabindex="1" id="' . $inputname . '">' . $entry[$fieldname] . '</textarea>';
				break;

				// ##### Normal Input
				default:
					$inputbox = '<input class="bginput" name="' . $inputname . '" size="' . $field['size'] . '" value="' . $entry[$fieldname] . '" ' . iif($field['maxlength'], 'maxlength="' . $field['maxlength'] . '"') . 'tabindex="1" id="' . $inputname . '" />';

			}

			($hook = vBulletinHook::fetch_hook('vba_dyna_functions_saveentry_cfieldbits_loop')) ? eval($hook) : false;

			if ($admin)
			{
				print_label_row($field['title'], $inputbox);
			}
			else
			{
				eval('$cfbits[$field[\'position_submit\']] .= "' . fetch_template(ADV_DYNA_PREFIX . '_add_edit_custombits') . '";');
			}
			unset($inputbox);
		}
	}

	return $cfbits;
}

// ######################## Sort custom fields to insert into the db ####################
function construct_customfields_sql($entryid, $add = true, $makearray = false)
{
	global $db, $_POST, $entry;

	if (!$add AND !$check = $db->query_first("SELECT eid FROM " . ADV_DYNA_TABLE_PREFIX . "cfields_entries WHERE eid = $entryid"))
	{
		$add = true;
	}

	if (cat_opt('allow_custom_links', $entry['catid']))
	{
		require_once(DIR . '/includes/functions_newpost.php');
	}

	$insert = array('field' => '', 'values' => '');

	$customfields = $db->query_read("SELECT * FROM " . ADV_DYNA_TABLE_PREFIX . "cfields");
	if (!$db->num_rows($customfields))
	{
		return false;
	}
	while ($custom = $db->fetch_array($customfields))
	{
		$thisfield = 'field' . $custom['fieldid'];

		// Form an array if we have multiple entries
		if ($makearray)
		{
			$fieldname = $_POST[$thisfield][$entryid];
		}
		else
		{
			$fieldname = $_POST[$thisfield];
		}

		($hook = vBulletinHook::fetch_hook('vba_dyna_functions_saveentry_cfields_sql_loop')) ? eval($hook) : false;

		// Array from checkbox or multiple select
		if ($custom['type'] == 'checkbox' OR $custom['type'] == 'multiple_select')
		{
			if (is_array($fieldname))
			{
				$fieldname = array_map('htmlspecialchars', $fieldname);
			}
			$fieldname = serialize($fieldname);
		}
		// Text or textarea
		else if ($custom['type'] == 'text' OR $custom['type'] == '')
		{
			// Parse links
			if (cat_opt('allow_custom_links', $entry['catid']))
			{
				$fieldname = convert_url_to_bbcode($fieldname);
			}
		}

		if ($add)
		{
			$insert['fields'] .= ',' . $thisfield;
			$insert['values'] .= ", '" . $db->escape_string($fieldname) . "'";
		}
		else
		{
			$insert['fields'] .= ", $thisfield = '" . $db->escape_string($fieldname) . "'";
		}
	}

	if ($add)
	{
		$db->query_write("INSERT INTO " . ADV_DYNA_TABLE_PREFIX . "cfields_entries (eid $insert[fields]) VALUES ($entryid $insert[values])");
	}
	else if (!empty($insert))
	{
		$insert['fields'] = substr($insert['fields'], 1);
		$db->query_write("UPDATE " . ADV_DYNA_TABLE_PREFIX . "cfields_entries SET $insert[fields] WHERE eid = $entryid");
	}
}

// ##### Clean Keywords #######################################################
function clean_keywords($words)
{
	global $vba_options;

	if ($vba_options['dyna_keyword_separator'])
	{
		$separate = ',';
	}
	else
	{
		$separate = ' ';
		$words = str_replace(',', ' ', $words);
	}

	$words = explode(iif($vba_options['dyna_keyword_separator'], ',', ' '), htmlspecialchars($words));

	$words = array_map('trim', $words);
	if (empty($words))
	{
		return;
	}

	$cleanwords = array();
	foreach ($words AS $cleanword)
	{
		if (trim($cleanword) AND !in_array($cleanword, $cleanwords))
		{
			$cleanwords[] = $cleanword;
		}
	}

	return implode(',', $cleanwords);
}

// ##### Rate Entry ###########################################################
function rate_entry($vote, $entryid, $redirpage = '')
{
	global $vba_dyna, $vba_options, $db, $vbulletin, $newpostid, $adv_sorturl, $xml, $stylevar, $vbphrase;

	$entryid = intval($entryid);
	$vote = intval($vote);

	if (empty($vba_dyna->_entry))
	{
		$vba_dyna->load_entry();
	}

	if (!$vba_dyna->check_cat_perms('canrate') OR !$vba_options['dyna_allowrating'] OR !cat_opt('allow_ratings', $vba_dyna->_entry['catid']))
	{
		if (THIS_SCRIPT == 'dyna_ajax')
		{
			$xml->add_tag('error', fetch_error('nopermission'));
			$xml->print_xml();
		}

		print_no_permission();
	}

	$maxvote = 5;

	($hook = vBulletinHook::fetch_hook('vba_dyna_functions_saveentry_rate_entry')) ? eval($hook) : false;

	if ($vote < 1 or $vote > $maxvote)
	{
		if (THIS_SCRIPT == 'dyna_ajax')
		{
			$xml->add_tag('error', $vote);
			$xml->print_xml();
		}

		eval(standard_error(fetch_error('error_invalidvote')));
	}

	switch ($redirpage)
	{
		case 'post':
			$redirurl = fetch_entry_url($vba_dyna->_entry, 'epostid=' . $newpostid . '#post' . $newpostid);
		break;

		default :
			$redirurl = $vba_dyna->_entry['url'];
	}
	// Check For Duplicates
	if (fetch_bbarray_cookie('rating_entryid', $entryid))
	{
		if (THIS_SCRIPT == 'dyna_ajax')
		{
			$xml->add_tag('error', fetch_error(ADV_DYNA_PREFIX . '_entry_voted', $vbphrase['entry_lwr']));
			$xml->print_xml();
		}

		eval(standard_error(fetch_error(ADV_DYNA_PREFIX . '_entry_voted', $vbphrase['entry_lwr'])));
	}

	if ($rating = $db->query_first("
			SELECT rateid, rating
			FROM " . ADV_DYNA_TABLE_PREFIX . "rate
			WHERE entryid = $entryid
			AND " . iif($vbulletin->userinfo['userid'],
				'userid = ' . $vbulletin->userinfo['userid'],
				"ipaddress = '" . $db->escape_string(IPADDRESS) . "'"
	)))
	{
		if (!$vbulletin->options['votechange'])
		{
			if (THIS_SCRIPT == 'dyna_ajax')
			{
				$xml->add_tag('error', fetch_error(ADV_DYNA_PREFIX . '_entry_voted', $vbphrase['entry_lwr']));
				$xml->print_xml();
			}

			eval(standard_error(fetch_error(ADV_DYNA_PREFIX . '_entry_voted', $vbphrase['entry_lwr'])));
		}
		else
		{
			if ($vote != $rating['rating'])
			{
				$db->query_write("UPDATE " . ADV_DYNA_TABLE_PREFIX . "rate SET rating = $vote WHERE rateid = $rating[rateid]");
				$db->query_write("UPDATE " . ADV_DYNA_TABLE_PREFIX . "entries SET votetotal = votetotal + " . ($vote - $rating['rating']) . " WHERE entryid = $entryid");
			}
			$vbulletin->url = $redirurl;

			if (THIS_SCRIPT == 'dyna_ajax')
			{
				eval('$message = "' . fetch_phrase(ADV_DYNA_PREFIX . '_ratingupdated', 'frontredirect') . '";');
				$xml->add_tag('message', $message);
				$xml->print_xml();
			}

			eval(print_standard_redirect('redirect_threadrate_update'));
		}
	}
	else
	{
		// No duplicates, so insert the rating
		$db->query_write("
			INSERT INTO " . ADV_DYNA_TABLE_PREFIX . "rate
				(entryid, rating, userid, ipaddress)
			VALUES (
				$entryid,
				$vote,
				" . $vbulletin->userinfo['userid'] . ",
				'" . $db->escape_string(IPADDRESS) . "'
		)");

		$db->query_write("
			UPDATE " . ADV_DYNA_TABLE_PREFIX . "entries SET
				votetotal = votetotal + $vote,
				votenum = votenum + 1
			WHERE entryid = $entryid
		");

		set_bbarray_cookie('rating_entryid', $entryid, $vote, 1);

		$vbulletin->url = $redirurl;

		if (THIS_SCRIPT == 'dyna_ajax')
		{
			$xml->add_group('entryrating');

			require_once(DIR . '/includes/functions_misc.php');

			eval('$message = "' . fetch_phrase(ADV_DYNA_PREFIX . '_ratingadded', 'frontredirect') . '";');
			$xml->add_tag('message', $message);

			$vba_dyna->_entry['votenum'] += 1;
			$vba_dyna->_entry['votetotal'] += $vote;

			$vba_dyna->_entry['voteavg'] = $vba_dyna->_entry['votetotal'] / $vba_dyna->_entry['votenum'];

			$xml->add_tag('rating_box', $vbphrase['rating'] . ': <img src="' . $stylevar['imgdir_rating'] . '/rating_' . round($vba_dyna->_entry['voteavg']) . '.gif" title="' . construct_phrase($vbphrase['x_votes_y_average'], $vba_dyna->_entry['votenum'], $vba_dyna->_entry['voteavg']) . '" border="0" class="inline" />');

			$xml->close_group();

			$xml->print_xml();
		}

		eval(print_standard_redirect(ADV_DYNA_PREFIX . '_ratingadded'));
	}
}

// ##### Fetch Allowed Parents for Submitting #################################
function fetch_allowed_submit_parents()
{
	global $vbulletin;

	if (empty($vbulletin->adv_dyna_cats))
	{
		return array();
	}

	$allowedparents = array();
	foreach ($vbulletin->adv_dyna_cats AS $cats)
	{
		if (!cat_opt('open_for_entries', $cats['catid']))
		{
			$plist = explode(',', $cats['parentlist']);

			foreach ($plist AS $parentid)
			{
				if ($parentid != $cats['catid'] AND $vbulletin->adv_dyna_cats[$parentid]['valid'] AND $vbulletin->adv_dyna_cats[$parentid]['active'])
				{
					$allowedparents[] = $cats['catid'];
				}
			}
		}
	}

	return array_unique($allowedparents);
}

?>