<?php
// ++=========================================================================++
// || vBadvanced Dynamics v1.0.0 (vB 3.6 - vB 3.7)
// ||  2003-2007 vBadvanced.com - All Rights Reserved
// || This file may not be redistributed in whole or significant part.
// || http://vbadvanced.com
// ++ ========================================================================++

error_reporting(E_ALL & ~E_NOTICE);

require_once('./includes/functions_calendar.php');

($hook = vBulletinHook::fetch_hook('vba_dyna_modules_calendar_start')) ? eval($hook) : false;

$calendarinfo['showweekends'] = 1;

if ($vbulletin->userinfo['startofweek'] > 7 OR $vbulletin->userinfo['startofweek'] < 1)
{
	$vbulletin->userinfo['startofweek'] = 1;
}

$vbulletin->input->clean_array_gpc('r', array(
	'month' => TYPE_INT,
	'year' => TYPE_INT,
	'this_script' => TYPE_NOHTML
));

$today = getdate(TIMENOW - $vbulletin->options['hourdiff']);

$today['month'] = $vbphrase[strtolower($today['month'])];
$year = $today['year'];
$month = $today['mon'];

if ($vbulletin->GPC['month'] AND $vbulletin->GPC['month'] <= 12)
{
	$month = $vbulletin->GPC['month'];
}

if ($vbulletin->GPC['year'] AND $vbulletin->GPC['year'] <= 2037 AND $vbulletin->GPC['year'] >= 1970)
{
	$year = $vbulletin->GPC['year'];
}

$usertoday = array(
	'firstday' => gmdate('w', gmmktime(0, 0, 0, $month, 1, $year)),
	'month' => $month,
	'year' => $year
);

$vbulletin->templatecache['calendar_smallmonth_day'] = $vbulletin->templatecache[ADV_DYNA_PREFIX . '_module_calendar_day'];
$vbulletin->templatecache['calendar_smallmonth_week'] = $vbulletin->templatecache[ADV_DYNA_PREFIX . '_module_calendar_week'];
$vbulletin->templatecache['calendar_smallmonth_header'] = $vbulletin->templatecache[ADV_DYNA_PREFIX . '_module_calendar_header'];

$show['nextmonth'] = $month + 1;
$show['nextmonthyear'] = $year;

$show['lastmonth'] = $month - 1;
$show['lastmonthyear'] = $year;

if ($month == 12)
{
	$show['nextmonthyear']= $year + 1;
	$show['nextmonth'] = 1;
}
else if ($month == 1)
{
	$show['lastmonth'] = 12;
	$show['lastmonthyear'] = $year - 1;
}

$mintimequery = gmmktime(0, 0, 0, $month, 1, $year);
$maxtimequery = gmmktime(0, 0, 0, $show['nextmonth'], 1, $show['nextmonthyear']);

// Specific conditions for catid or userid
$calendarwhere = array("entries.valid = 1 AND draft = 0 AND private = 0 AND dateline > $mintimequery AND dateline < $maxtimequery");

$calendarwherequery = '';
if ($entry['userid'])
{
	$calendarwhere[] = 'userid = ' .  $entry['userid'];
}
else if ($entryuserid)
{
	if (!empty($catsinfo) AND !$eventdate)
	{
		$calendarwhere[] = 'entries.catid NOT IN(' . implode(',', array_keys($catsinfo)) . ')';
	}

	$calendarwhere[] = 'userid = ' .  $entryuserid;
}
if (intval($catid))
{
	$calendarwhere[] = 'entries.catid = ' . intval($catid);
}

if (!isset($condition['fromtable']))
{
	$condition['fromtable'] = ADV_DYNA_PREFIX . '_entries AS entries';
}

$getevents = $vbulletin->db->query_read("
	SELECT entries.entryid, dateline, entries.title
	FROM " . TABLE_PREFIX . $condition['fromtable'] . "
	" . iif($condition['join'], 'LEFT JOIN ' . TABLE_PREFIX . $condition['join']) . "
	$catjoin
	WHERE " . implode(' AND ', $calendarwhere)
);
while ($events = $vbulletin->db->fetch_array($getevents))
{
	$events['date'] = getdate($events['dateline'] - $vbulletin->options['hourdiff']);
	$dateline = gmmktime(0, 0, 0, $events['date']['mon'], $events['date']['mday'], $events['date']['year']);

	if (!$mod_options['dyna_calendar_maxentriesday'] OR sizeof($eventcache['singleday'][$dateline]) < $mod_options['dyna_calendar_maxentriesday'])
	{
		$calentry =& $eventcache['singleday'][$dateline][$events['entryid']];

		$calentry['eventid'] = $events['entryid'];
		$calentry['title'] = $events['title'];
		$calentry['eventid'] = $events['entryid'];
		$calentry['visible'] = 1;
	}
	else
	{
		$eventcache['singleday'][$dateline][0]['title'] = "\r\n.....";
	}
}

$show['calendarsorturl'] = construct_adv_sort_url(array('eventdate', 'week', 'month', 'year', 'page'), true);

if (THIS_SCRIPT == 'dyna_showentry' OR $vbulletin->GPC['this_script'] == 'dyna_showentry')
{
	$show['calendarsorturl'] .= '&amp;entryuserid=' . $entry['userid'];
}

$show['calendar_arrowlasturl'] = $_SERVER['PHP_SELF'] . '?' . $vbulletin->session->vars['sessionurl'] . 'month=' . $show['lastmonth'] . '&amp;year=' . $show['lastmonthyear'] . $show['calendarsorturl'];
$show['calendar_arrownexturl'] = $_SERVER['PHP_SELF'] . '?' . $vbulletin->session->vars['sessionurl'] . 'month=' . $show['nextmonth'] . '&amp;year=' . $show['nextmonthyear'] . $show['calendarsorturl'];

// Keep this above the finddate part or the "do=" in the URL will break things
$show['js_url'] = $show['calendarsorturl'] . '&amp;this_script=' . iif($vbulletin->GPC['this_script'], $vbulletin->GPC['this_script'], THIS_SCRIPT);

if (THIS_SCRIPT == 'dyna_index' OR $vbulletin->GPC['this_script'] == 'dyna_index' OR $_REQUEST['do'] == 'finddate')
{
	$show['calendarsorturl'] .= '&amp;do=finddate';
}

$stylevar['oldcellpadding'] = $stylevar['cellpadding'];
$stylevar['cellpadding'] = 4;

$calendarrowbits = construct_calendar_output($today, $usertoday, $calendarinfo, 0, '');

$monthname = $vbphrase[$months[$month]];

($hook = vBulletinHook::fetch_hook('vba_dyna_modules_calendar_end')) ? eval($hook) : false;


eval('$home[$mods[\'modid\']][\'content\'] = "' . fetch_template(ADV_DYNA_PREFIX . '_module_calendar_wrapper') . '";');

?>