<?php
// ++=========================================================================++
// || vBadvanced Dynamics v1.0.0 (vB 3.6 - vB 3.7)
// ||  2003-2007 vBadvanced.com - All Rights Reserved
// || This file may not be redistributed in whole or significant part.
// || http://vbadvanced.com
// ++ ========================================================================++

error_reporting(E_ALL & ~E_NOTICE);

require_once(DIR . '/includes/vba_dyna_functions_cats.php');

($hook = vBulletinHook::fetch_hook('vba_dyna_modules_categorylist_start')) ? eval($hook) : false;

// Cache the counters
if ($mod_options['dyna_catlist_lastentry'] OR $mod_options['dyna_catlist_lastpost'] OR $mod_options['dyna_catlist_entrycount'] OR $mod_options['dyna_catlist_replycount'] OR $mod_options['dyna_catlist_hideemptycats'])
{
	$catcounts = fetch_category_counts();
}

if ($catid AND $mod_options['dyna_catlist_subcats'])
{
	$catsarray = construct_categories($vbulletin->adv_dyna_cats, $catid);
}
else
{
	$catsarray =& $vbulletin->adv_dyna_cats;
}

foreach ($catsarray AS $modcatid => $modcat)
{
	$modcatcount =& $catcounts[$modcatid];

	// Check permissions
	if (
		($modcat['catid'] AND (!$vba_dyna->check_cat_perms('canviewdyna', $modcat) OR !$modcat['active'] OR !$modcat['valid'] OR $modcat['level'] > $mod_options['dyna_catlist_maxdepth']))
		OR ($mod_options['dyna_catlist_hideemptycats'] AND !$modcatcount['entrycount'])
	)
	{
		continue;
	}

	$modcat['caturl'] = fetch_cat_url($modcat['catid']);

	$navmark = $mod_options['dyna_catlist_level1'];
	$levelspacer = '0px';

	if ($modcat['level'] > 1 AND $mod_options['dyna_catlist_indent'])
	{
		$levelspacer = $mod_options['dyna_catlist_indent'] * ($modcat['level'] - 1) . 'px';
		$navmark = $mod_options['dyna_catlist_level2'];
	}

	// On/off indicators
	if ($mod_options['dyna_catlist_showonoff'])
	{
		if ($vbulletin->userinfo['lastvisit'] < $modcatcount['lastentrydateline'] OR $vbulletin->userinfo['lastvisit'] < $modcatcount['lastpostdateline'])
		{
			$modcat['onoff'] = 'new';
		}
		else
		{
			$modcat['onoff'] = 'old';
		}
	}

	if (!$mod_options['dyna_catlist_privcounts'])
	{
		if (!check_category_password($modcat['catid'], false))
		{
			$modcat['nopass'] = true;
		}
	}

	$canviewentries = false;
	if ((!$modcat['nopass'] AND $vba_dyna->check_cat_perms('canviewentries', $modcat)) OR $mod_options['dyna_catlist_privcounts'])
	{
		$canviewentries = true;
	}

	// Entry count
	$show['entrycount'] = false;
	$modcat['entrycount'] = 0;
	if ($mod_options['dyna_catlist_entrycount'] AND $canviewentries)
	{
		$show['entrycount'] = true;
		$modcat['entrycount'] = vb_number_format($modcatcount['entrycount']);
	}

	// Last entry
	if ($mod_options['dyna_catlist_lastentry'] AND $canviewentries)
	{
		if ($modcatcount['lastentrydateline'])
		{
			$modcat['lastentry'] = array(
				'catid' => $modcatcount['lastentryrealcatid'],
				'title' => $modcatcount['lastentrytitle'],
				'entryid' => $modcatcount['lastentryid']
			);

			fetch_entry_url($modcat['lastentry']);
			$modcat['lastentrylink'] = $modcat['lastentry']['url'];

			$modcat['lastentryid'] =& $modcatcount['lastentryid'];
			$modcat['lastentryuserid'] =& $modcatcount['lastentryuserid'];
			$modcat['lastentryusername'] =& $modcatcount['lastentryusername'];

			$modcat['lastupdateddate'] = vbdate($vbulletin->options['dateformat'], $modcatcount['lastentrydateline']);
			$modcat['lastupdatedtime'] = vbdate($vbulletin->options['timeformat'], $modcatcount['lastentrydateline']);
			$modcat['lastentrytitle'] = fetch_trimmed_title($modcatcount['lastentrytitle'], $mod_options['dyna_catlist_lastentry_maxlength']);
		}
	}
	else
	{
		$modcat['lastentryid'] = '';
	}

	$canviewreplies = false;
	if ($vba_options['dyna_allowreplies'] AND ((!$modcat['nopass'] AND $vba_dyna->check_cat_perms('canviewreplies', $modcat)) OR $mod_options['dyna_catlist_privcounts']))
	{
		$canviewreplies = true;
	}

	// Entry count
	$show['postcount'] = false;
	$modcat['postcount'] = 0;
	if ($mod_options['dyna_catlist_replycount'] AND $canviewreplies)
	{
		$show['postcount'] = true;
		$modcat['postcount'] = vb_number_format($modcatcount['postcount']);
	}

	// Last post
	if ($mod_options['dyna_catlist_lastpost'] AND $canviewreplies AND $modcatcount['lastpostdateline'])
	{
		$modcat['lastpost'] = array(
			'catid' => $modcatcount['lastpostrealcatid'],
			'title' => $modcatcount['lastpostentrytitle'],
			'entryid' => $modcatcount['lastpostentryid']
		);

		fetch_entry_url($modcat['lastpost'], '&amp;p=' . $modcatcount['lastpostid'] . '#post' . $modcatcount['lastpostid']);

		$modcat['lastpostlink'] = $modcat['lastpost']['url'];

		$modcat['lastpostdateline'] =& $modcatcount['lastpostdateline'];
		$modcat['lastpostid'] =& $modcatcount['lastpostid'];
		$modcat['lastpostentryid'] =& $modcatcount['lastpostentryid'];
		$modcat['lastpostuserid'] =& $modcatcount['lastpostuserid'];
		$modcat['lastpostusername'] =& $modcatcount['lastpostusername'];

		$modcat['lastpostentrytitle'] = fetch_trimmed_title($modcatcount['lastpostentrytitle'], $mod_options['dyna_catlist_lastentry_maxlength']);
		$modcat['lastpostdate'] = vbdate($vbulletin->options['dateformat'], $modcatcount['lastpostdateline']);
		$modcat['lastposttime'] = vbdate($vbulletin->options['timeformat'], $modcatcount['lastpostdateline']);
	}
	else
	{
		$modcat['lastpostid'] = '';
	}

	($hook = vBulletinHook::fetch_hook('vba_dyna_modules_categorylist_loop')) ? eval($hook) : false;

	eval('$home["$mods[modid]"][\'content\'] .= "' . fetch_template(ADV_DYNA_PREFIX . '_module_categorylistbits') . '";');
}

($hook = vBulletinHook::fetch_hook('vba_dyna_modules_categorylist_end')) ? eval($hook) : false;

$show['tablerow'] = true;

?>