<?php
// ++=========================================================================++
// || vBadvanced Dynamics v1.0.0 (vB 3.6 - vB 3.7)
// ||  2003-2007 vBadvanced.com - All Rights Reserved
// || This file may not be redistributed in whole or significant part.
// || http://vbadvanced.com
// ++ ========================================================================++

error_reporting(E_ALL & ~E_NOTICE);

$show['categorylink'] = true;
$show['entrybit_dropdowns'] = '';

if (!empty($vbulletin->adv_dyna_featur))
{
	require_once(DIR . '/includes/functions_bigthree.php');
	require_once(DIR . '/includes/vba_dyna_functions_cats.php');

	$querywhere = '(entries.entryid IN(' . implode(',', $vbulletin->adv_dyna_featur) . ')';

	if ($mod_options['dyna_newrand_incsticky'])
	{
		$querywhere .= ' OR sticky = 1';
	}

	$querywhere .= ') AND entries.valid = 1 AND draft = 0';

	// Order by
	switch ($mod_options['dyna_newrand_orderby'])
	{
		case 'rand':
			$queryorderby = 'RAND()';
		break;

		case 'lastpost':
			$queryorderby = 'lastpostdateline DESC';
		break;

		default:
		 	$queryorderby = 'dateline DESC';
	}

	fetch_entrybit_fields($mod_options['dyna_newrand_entrybitfields'], true);

	// Template
	$templatename = fetch_module_template_name();

	$show['header_rows'] = false;

	switch ($templatename)
	{
		case 'simple':
			$show['header_rows'] = true;
		break;

		case 'expanded':
			$mods['hide_tbody'] = true;
		break;
	}

	$querycols = 'entries.entryid, entries.title, entries.catid, entries.views, open, entries.valid, entries.dateline, hasattach, votenum, votetotal, entries.iconid, caticon, icon.title as icontitle, icon.iconpath, user.*, IF(user.options & ' . $vbulletin->bf_misc_useroptions['invisible'] . ', 1, 0) AS invisible, entries.posts AS posts, avatarpath, NOT ISNULL(customavatar.userid) AS hascustom, customavatar.dateline AS avatardateline, avatarrevision, customfields.* ';

	$queryjoin = '
		LEFT JOIN ' . ADV_DYNA_TABLE_PREFIX . 'categories AS categories ON (entries.catid = categories.catid)
		LEFT JOIN ' . TABLE_PREFIX . 'icon AS icon ON (entries.iconid = icon.iconid)
		LEFT JOIN ' . TABLE_PREFIX . 'user AS user ON (entries.userid = user.userid)
		LEFT JOIN ' . TABLE_PREFIX . 'avatar as avatar ON (avatar.avatarid = user.avatarid)
		LEFT JOIN ' . TABLE_PREFIX . 'customavatar as customavatar ON (customavatar.userid = user.userid)
		LEFT JOIN ' . ADV_DYNA_TABLE_PREFIX . 'cfields_entries AS customfields ON (entries.entryid = customfields.eid)
	';

	// Subscribed entries
	if ($vba_options['dyna_allowsubscribe'] AND $vbulletin->userinfo['userid'])
	{
		$querycols .= ', NOT ISNULL(subscribeentry.entryid) AS issubscribed';
		$queryjoin .= ' LEFT JOIN ' . ADV_DYNA_TABLE_PREFIX . 'subscribeentry AS subscribeentry ON (entries.entryid = subscribeentry.entryid AND ' . $vbulletin->userinfo['userid'] . ' = subscribeentry.userid)';
	}

	// Get post info if user has permission
	if ($vba_options['dyna_allowreplies'])
	{
		$querycols .= ', entries.lastpostid, entries.lastpostdateline, entries.lastpostuserid, entries.lastpostusername';
	}

	// Join favorites if userid
	if ($vbulletin->userinfo['userid'] AND $vba_options['dyna_allowfav'])
	{
		$querycols .= ', NOT ISNULL(favorites.entryid) AS isfavorite';
		$queryjoin .= ' LEFT JOIN ' . ADV_DYNA_TABLE_PREFIX . 'favorites AS favorites ON (favorites.entryid = entries.entryid AND favorites.userid = ' . $vbulletin->userinfo['userid'] . ')';
	}

	// Preview
	if ($show['entrybit_preview'] AND $vba_options['dyna_desclength_browse'])
	{
		$querycols .= ', pagetext';
		$queryjoin .= 'LEFT JOIN ' . ADV_DYNA_TABLE_PREFIX . 'entries_pages AS entries_pages ON (entries.entryid = entries_pages.entryid AND entries_pages.pagenumber = 1)';

		// Entry cache
		if ($vba_options['dyna_cachedlife'])
		{
			$querycols .= ', pagetext_parsed, hasimages';
			$queryjoin .= ' LEFT JOIN ' . ADV_DYNA_TABLE_PREFIX . 'entryparsed AS entryparsed ON (entries.entryid = entryparsed.entryid AND entryparsed.languageid = ' . $vbulletin->userinfo['languageid'] . ' AND entryparsed.styleid = ' . $vbulletin->userinfo['styleid'] . ')';
		}
	}

	// First Attachment
	if ($show['entrybit_firstattach'])
	{
		$vba_dyna->fetch_attachment_perms();

		$querycols  .= ', attachment.attachmentid, attachment.hasthumb, attachment.filename, attachment.dateline AS attachdateline, extension, attachment.userid AS attachuserid';
		$queryjoin .= 'LEFT JOIN ' . ADV_DYNA_TABLE_PREFIX . 'attachments AS attachment ON (entries.attachid = attachment.attachmentid)';
	}
	else
	{
		$show['entrybit_attach'] = false;
	}

	// Private categories
	if (!empty($privcats))
	{
		$querywhere .= ' AND entries.catid NOT IN(' . implode(',', $privcats) . ')';
	}

	// Specific user
	if ($entryuserid AND $mod_options['dyna_newrand_limituser'])
	{
		$querywhere .= ' AND entries.userid = ' . $entryuserid;
	}

	// Ignored users
	if ($ignusers)
	{
		$querywhere .= ' AND entries.userid NOT IN(' . $ignusers . ')';
	}

	($hook = vBulletinHook::fetch_hook('vba_dyna_modules_featured_query')) ? eval($hook) : false;

	$getnew = $db->query_read("SELECT $querycols
		FROM " . ADV_DYNA_TABLE_PREFIX . "entries AS entries
		$queryjoin
		WHERE $querywhere
		ORDER BY $queryorderby
		LIMIT $mod_options[dyna_newrand_limit]
	");
	if ($db->num_rows($getnew))
	{
		if ($templatename != 'lean')
		{
			eval('$home[$mods[\'modid\']][\'content\'] = "' . fetch_template(ADV_DYNA_PREFIX . '_module_newrand_header') . '";');
		}

		while ($entries = $db->fetch_array($getnew))
		{
			// Trim title
			if (strlen($entries['title']) > $mod_options['dyna_newrand_maxchars'] AND $mod_options['dyna_newrand_maxchars'])
			{
				$entries['title'] = fetch_trimmed_title($entries['title'], $mod_options['dyna_newrand_maxchars']);
			}

			// Check for long words that may stretch the page
			if ($mod_options['dyna_newrand_maxwordchars'])
			{
				$entries['titlecheck'] = explode(' ', $entries['title']);

				if (!empty($entries['titlecheck']))
				{
					$entries['title'] = '';

					foreach ($entries['titlecheck'] AS $key => $word)
					{
						if (!$entries['titletrimmed'])
						{
							if (strlen($word) > $mod_options['dyna_newrand_maxwordchars'])
							{
								$word = fetch_trimmed_title($word, $mod_options['dyna_newrand_maxwordchars']);
								$entries['titletrimmed'] = true;
							}

							if ($entries['title'])
							{
								$entries['title'] .= ' ';
							}

							$entries['title'] .= $word;
						}
					}
				}
			}

			$home[$mods['modid']]['content'] .= construct_entrybits($entries, $templatename, $mod_options['dyna_newrand_cfields']);
		}

		if ($templatename == 'expanded')
		{
			$home[$mods['modid']]['content'] .= $show['entrybit_dropdowns'];
		}

		eval('$home[$mods[\'modid\']][\'content\'] .= "' . fetch_template(ADV_DYNA_PREFIX . '_module_newrand_footer') . '";');
	}
}

?>