<?php
// ++=========================================================================++
// || vBadvanced Dynamics v1.0.0 (vB 3.6 - vB 3.7)
// ||  2003-2007 vBadvanced.com - All Rights Reserved
// || This file may not be redistributed in whole or significant part.
// || http://vbadvanced.com
// ++ ========================================================================++

error_reporting(E_ALL & ~E_NOTICE);

require_once(DIR . '/includes/functions_bigthree.php');
require_once(DIR . '/includes/vba_dyna_functions_cats.php');

$queryentries = true;

$querywhere = 'entries.valid = 1 AND draft = 0';

// Private categories
if (!empty($privcats))
{
	$mod_options['dyna_newposts_excludecats'] = array_merge($privcats, $mod_options['dyna_newposts_excludecats']);
}

// Excluded categories
if (!empty($mod_options['dyna_newposts_excludecats']))
{
	$querywhere .= ' AND entries.catid NOT IN(' . implode(',', $mod_options['dyna_newposts_excludecats']) . ')';
}

// Specific category
if ($mod_options['dyna_newposts_limitcat'] AND intval($catid))
{
	$querywhere .= ' AND entries.catid = ' . intval($catid);
}

// Specific user
if ($entryuserid AND $mod_options['dyna_newposts_limituser'])
{
	$querywhere .= ' AND entries.userid = ' . $entryuserid;
}

// Ignored users
if ($ignusers)
{
	$querywhere .= ' AND entries.userid NOT IN(' . $ignusers . ')';
}

($hook = vBulletinHook::fetch_hook('vba_dyna_modules_newposts_query')) ? eval($hook) : false;

$getnewposts = $db->query_read("
	SELECT entries.entryid, catid, entries.title, postid, posts.pagetext, posts.dateline, posts.userid, posts.username
	FROM " . ADV_DYNA_TABLE_PREFIX . "posts AS posts
	LEFT JOIN " . ADV_DYNA_TABLE_PREFIX . "entries AS entries ON (posts.entryid = entries.entryid)
	WHERE $querywhere
	ORDER BY posts.dateline DESC
	LIMIT $mod_options[dyna_newposts_limit]
");
if ($db->num_rows($getnewposts))
{
	while ($post = $db->fetch_array($getnewposts))
	{
		$post['pagetext'] = strip_bbcode($post['pagetext']);
		// Trim title
		if ($mod_options['dyna_newposts_maxchar'])
		{
			if (strlen($post['pagetext']) > $mod_options['dyna_newposts_maxchar'])
			{
				$post['pagetext'] = fetch_trimmed_title($post['pagetext'], $mod_options['dyna_newposts_maxchar']);
			}
		}

		fetch_entry_url($post, 'epostid=' . $post['postid'] . '#post' . $post['postid']);

		$post['date'] = vbdate($vbulletin->options['dateformat'], $post['dateline']);
		$post['time'] = vbdate($vbulletin->options['timeformat'], $post['dateline']);

		exec_switch_bg();

		eval('$home[$mods[\'modid\']][\'content\'] .= "' . fetch_template(ADV_DYNA_PREFIX . '_module_newpostbit') . '";');
	}
}
else
{
	
}

unset($post);
$db->free_result($getnewposts);

($hook = vBulletinHook::fetch_hook('vba_dyna_modules_newposts_end')) ? eval($hook) : false;

?>