<?php
// ----------------------------------------------------------------------
// Copyright (C) 2007 by Khaled Al-Shamaa.
// http://www.al-shamaa.com/
// ----------------------------------------------------------------------
// LICENSE
//
// This program is open source product; you can redistribute it and/or
// modify it under the terms of the GNU General Public License (GPL)
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// To read the license please visit http://www.gnu.org/copyleft/gpl.html
// ----------------------------------------------------------------------
// Class Name: Arabic Keyboard Swapping Language
// Filename:   ArKeySwap.class.php
// Original    Author(s): Khaled Al-Sham'aa <khaled.alshamaa@gmail.com>
// Purpose:    Convert keyboard language programmatically (English - Arabic)
// ----------------------------------------------------------------------

class ArKeySwap {
      var $swap_ae = array();
      var $swap_ea = array();

      function ArKeySwap(){
          $this->swap_ea['`'] = 'ذ';
          $this->swap_ea['q'] = 'ض';
          $this->swap_ea['w'] = 'ص';
          $this->swap_ea['e'] = 'ث';
          $this->swap_ea['r'] = 'ق';
          $this->swap_ea['t'] = 'ف';
          $this->swap_ea['y'] = 'غ';
          $this->swap_ea['u'] = 'ع';
          $this->swap_ea['i'] = 'ه';
          $this->swap_ea['o'] = 'خ';
          $this->swap_ea['p'] = 'ح';
          $this->swap_ea['['] = 'ج';
          $this->swap_ea[']'] = 'د';
          $this->swap_ea['a'] = 'ش';
          $this->swap_ea['s'] = 'س';
          $this->swap_ea['d'] = 'ي';
          $this->swap_ea['f'] = 'ب';
          $this->swap_ea['g'] = 'ل';
          $this->swap_ea['h'] = 'ا';
          $this->swap_ea['j'] = 'ت';
          $this->swap_ea['k'] = 'ن';
          $this->swap_ea['l'] = 'م';
          $this->swap_ea[';'] = 'ك';
          $this->swap_ea['\'']= 'ط';
          $this->swap_ea['z'] = 'ئ';
          $this->swap_ea['x'] = 'ء';
          $this->swap_ea['c'] = 'ؤ';
          $this->swap_ea['v'] = 'ر';
          $this->swap_ea['b'] = 'لا';
          $this->swap_ea['n'] = 'ى';
          $this->swap_ea['m'] = 'ة';
          $this->swap_ea[','] = 'و';
          $this->swap_ea['.'] = 'ز';
          $this->swap_ea['/'] = 'ظ';
          
          $this->swap_ea['~'] = 'ّ';
          $this->swap_ea['Q'] = 'َ';
          $this->swap_ea['W'] = 'ً';
          $this->swap_ea['E'] = 'ُ';
          $this->swap_ea['R'] = 'ٌ';
          $this->swap_ea['T'] = 'لإ';
          $this->swap_ea['Y'] = 'إ';
          $this->swap_ea['U'] = '‘';
          $this->swap_ea['I'] = '÷';
          $this->swap_ea['O'] = '×';
          $this->swap_ea['P'] = '؛';
          $this->swap_ea['{'] = '<';
          $this->swap_ea['}'] = '>';
          $this->swap_ea['A'] = 'ِ';
          $this->swap_ea['S'] = 'ٍ';
          $this->swap_ea['D'] = ']';
          $this->swap_ea['F'] = '[';
          $this->swap_ea['G'] = 'لأ';
          $this->swap_ea['H'] = 'أ';
          $this->swap_ea['J'] = 'ـ';
          $this->swap_ea['K'] = '،';
          $this->swap_ea['L'] = '/';
          $this->swap_ea[':'] = ':';
          $this->swap_ea['"'] = '"';
          $this->swap_ea['Z'] = '~';
          $this->swap_ea['X'] = 'ْ';
          $this->swap_ea['C'] = '}';
          $this->swap_ea['V'] = '{';
          $this->swap_ea['B'] = 'لآ';
          $this->swap_ea['N'] = 'آ';
          $this->swap_ea['M'] = '’';
          $this->swap_ea['<'] = ',';
          $this->swap_ea['>'] = '.';
          $this->swap_ea['?'] = '؟';

          $this->swap_ae['ذ'] = '`';
          $this->swap_ae['ض'] = 'q';
          $this->swap_ae['ص'] = 'w';
          $this->swap_ae['ث'] = 'e';
          $this->swap_ae['ق'] = 'r';
          $this->swap_ae['ف'] = 't';
          $this->swap_ae['غ'] = 'y';
          $this->swap_ae['ع'] = 'u';
          $this->swap_ae['ه'] = 'i';
          $this->swap_ae['خ'] = 'o';
          $this->swap_ae['ح'] = 'p';
          $this->swap_ae['ج'] = '[';
          $this->swap_ae['د'] = ']';
          $this->swap_ae['ش'] = 'a';
          $this->swap_ae['س'] = 's';
          $this->swap_ae['ي'] = 'd';
          $this->swap_ae['ب'] = 'f';
          $this->swap_ae['ل'] = 'g';
          $this->swap_ae['ا'] = 'h';
          $this->swap_ae['ت'] = 'j';
          $this->swap_ae['ن'] = 'k';
          $this->swap_ae['م'] = 'l';
          $this->swap_ae['ك'] = ';';
          $this->swap_ae['ط'] = '\'';
          $this->swap_ae['ئ'] = 'z';
          $this->swap_ae['ء'] = 'x';
          $this->swap_ae['ؤ'] = 'c';
          $this->swap_ae['ر'] = 'v';
          $this->swap_ae['لا']= 'b';
          $this->swap_ae['ى'] = 'n';
          $this->swap_ae['ة'] = 'm';
          $this->swap_ae['و'] = ',';
          $this->swap_ae['ز'] = '.';
          $this->swap_ae['ظ'] = '/';
          
          $this->swap_ae['ّ'] = '~';
          $this->swap_ae['َ'] = 'Q';
          $this->swap_ae['ً'] = 'W';
          $this->swap_ae['ُ'] = 'E';
          $this->swap_ae['ٌ'] = 'R';
          $this->swap_ae['لإ']= 'T';
          $this->swap_ae['إ'] = 'Y';
          $this->swap_ae['‘'] = 'U';
          $this->swap_ae['÷'] = 'I';
          $this->swap_ae['×'] = 'O';
          $this->swap_ae['؛'] = 'P';
          $this->swap_ae['<'] = '{';
          $this->swap_ae['>'] = '}';
          $this->swap_ae['ِ'] = 'A';
          $this->swap_ae['ٍ'] = 'S';
          $this->swap_ae[']'] = 'D';
          $this->swap_ae['['] = 'F';
          $this->swap_ae['لأ']= 'G';
          $this->swap_ae['أ'] = 'H';
          $this->swap_ae['ـ'] = 'J';
          $this->swap_ae['،'] = 'K';
          $this->swap_ae['/'] = 'L';
          $this->swap_ae[':'] = ':';
          $this->swap_ae['"'] = '"';
          $this->swap_ae['~'] = 'Z';
          $this->swap_ae['ْ'] = 'X';
          $this->swap_ae['}'] = 'C';
          $this->swap_ae['{'] = 'V';
          $this->swap_ae['لآ']= 'B';
          $this->swap_ae['آ'] = 'N';
          $this->swap_ae['’'] = 'M';
          $this->swap_ae[','] = '<';
          $this->swap_ae['.'] = '>';
          $this->swap_ae['؟'] = '?';
      }

      function swap_ea($text){
          $output = '';
          $chars  = preg_split('//', $text, -1, PREG_SPLIT_NO_EMPTY);

          foreach ($chars as $char){
              if($this->swap_ea[$char]){
                 $output .= $this->swap_ea[$char];
              }else{
                 $output .= $char;
              }
          }

          return $output;
      }

      function swap_ae($text){
          $output = '';

	  $text   = str_replace('لا', 'b', $text);
	  $text   = str_replace('لآ', 'B', $text);
	  $text   = str_replace('لأ', 'G', $text);
	  $text   = str_replace('لإ', 'T', $text);

          $chars  = preg_split('//', $text, -1, PREG_SPLIT_NO_EMPTY);

          foreach ($chars as $char){
              if($this->swap_ae[$char]){
                 $output .= $this->swap_ae[$char];
              }else{
                 $output .= $char;
              }
          }

          return $output;
      }
}

?>