<?php
// ----------------------------------------------------------------------
// Copyright (C) 2007 by Khaled Al-Shamaa.
// http://www.al-shamaa.com/php/arabic
// ----------------------------------------------------------------------
// LICENSE

// This program is open source product; you can redistribute it and/or
// modify it under the terms of the GNU General Public License (GPL)
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.

// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

// To read the license please visit http://www.gnu.org/copyleft/gpl.html
// ----------------------------------------------------------------------
// Class Name: Arabic-English Transliteration
// Filename:   EnTransliteration.class.php
// Original    Author(s): Khaled Al-Sham'aa <khaled.alshamaa@gmail.com>
// Purpose:    Transliterate Arabic words into English by render them
//             in the orthography of the English language
// ----------------------------------------------------------------------

class EnTransliteration {
    var $arPatterns = array();
    var $arReplacements = array();

    function EnTransliteration() {
        array_push($this->arPatterns, '/(.)ّ/');
        array_push($this->arReplacements, "\\1'\\1");
        array_push($this->arPatterns, '/^ال/');
        array_push($this->arReplacements, 'Al-');

        array_push($this->arPatterns, '/تة/');
        array_push($this->arReplacements, "t'h");
        array_push($this->arPatterns, '/ته/');
        array_push($this->arReplacements, "t'h");
        array_push($this->arPatterns, '/كة/');
        array_push($this->arReplacements, "k'h");
        array_push($this->arPatterns, '/كه/');
        array_push($this->arReplacements, "k'h");
        array_push($this->arPatterns, '/ده/');
        array_push($this->arReplacements, "d'h");
        array_push($this->arPatterns, '/دة/');
        array_push($this->arReplacements, "d'h");
        array_push($this->arPatterns, '/ضه/');
        array_push($this->arReplacements, "d'h");
        array_push($this->arPatterns, '/ضة/');
        array_push($this->arReplacements, "d'h");
        array_push($this->arPatterns, '/سه/');
        array_push($this->arReplacements, "s'h");
        array_push($this->arPatterns, '/سة/');
        array_push($this->arReplacements, "s'h");
        array_push($this->arPatterns, '/صه/');
        array_push($this->arReplacements, "s'h");
        array_push($this->arPatterns, '/صة/');
        array_push($this->arReplacements, "s'h");

        array_push($this->arPatterns, '/^إِي/');
        array_push($this->arReplacements, "ei");
        array_push($this->arPatterns, '/^عِي/');
        array_push($this->arReplacements, "ei");
        array_push($this->arPatterns, '/^عُو/');
        array_push($this->arReplacements, "ou");
        array_push($this->arPatterns, '/ْع$/');
        array_push($this->arReplacements, "a");

        array_push($this->arPatterns, '/ِي$/');
        array_push($this->arReplacements, 'i');
        array_push($this->arPatterns, '/َو$/');
        array_push($this->arReplacements, 'aw');
        array_push($this->arPatterns, '/َي$/');
        array_push($this->arReplacements, 'ay');

        array_push($this->arPatterns, '/َا/');
        array_push($this->arReplacements, 'a');
        array_push($this->arPatterns, '/َي/');
        array_push($this->arReplacements, 'a');
        array_push($this->arPatterns, '/ُو/');
        array_push($this->arReplacements, 'ou');
        array_push($this->arPatterns, '/ِي/');
        array_push($this->arReplacements, "ei");

        array_push($this->arPatterns, '/ً/');
        array_push($this->arReplacements, 'an');
        array_push($this->arPatterns, '/ٌ/');
        array_push($this->arReplacements, 'an');
        array_push($this->arPatterns, '/ٍ/');
        array_push($this->arReplacements, 'an');
        array_push($this->arPatterns, '/َ/');
        array_push($this->arReplacements, 'a');
        array_push($this->arPatterns, '/ِ/');
        array_push($this->arReplacements, 'i');
        array_push($this->arPatterns, '/ُ/');
        array_push($this->arReplacements, 'u');

        array_push($this->arPatterns, '/^ع/');
        array_push($this->arReplacements, 'a');

        array_push($this->arPatterns, '/ا/');
        array_push($this->arReplacements, 'a');
        array_push($this->arPatterns, '/ب/');
        array_push($this->arReplacements, 'b');
        array_push($this->arPatterns, '/ت/');
        array_push($this->arReplacements, 't');
        array_push($this->arPatterns, '/ث/');
        array_push($this->arReplacements, 'th');
        array_push($this->arPatterns, '/ج/');
        array_push($this->arReplacements, 'j');
        array_push($this->arPatterns, '/ح/');
        array_push($this->arReplacements, 'h');
        array_push($this->arPatterns, '/خ/');
        array_push($this->arReplacements, 'kh');
        array_push($this->arPatterns, '/د/');
        array_push($this->arReplacements, 'd');
        array_push($this->arPatterns, '/ذ/');
        array_push($this->arReplacements, 'dh');
        array_push($this->arPatterns, '/ر/');
        array_push($this->arReplacements, 'r');
        array_push($this->arPatterns, '/ز/');
        array_push($this->arReplacements, 'z');
        array_push($this->arPatterns, '/س/');
        array_push($this->arReplacements, 's');
        array_push($this->arPatterns, '/ش/');
        array_push($this->arReplacements, 'sh');
        array_push($this->arPatterns, '/ص/');
        array_push($this->arReplacements, 's');
        array_push($this->arPatterns, '/ض/');
        array_push($this->arReplacements, 'd');
        array_push($this->arPatterns, '/ط/');
        array_push($this->arReplacements, 't');
        array_push($this->arPatterns, '/ظ/');
        array_push($this->arReplacements, 'z');
        array_push($this->arPatterns, '/ع/');
        array_push($this->arReplacements, "'");
        array_push($this->arPatterns, '/غ/');
        array_push($this->arReplacements, 'gh');
        array_push($this->arPatterns, '/ف/');
        array_push($this->arReplacements, 'f');
        array_push($this->arPatterns, '/ق/');
        array_push($this->arReplacements, 'q');
        array_push($this->arPatterns, '/ك/');
        array_push($this->arReplacements, 'k');
        array_push($this->arPatterns, '/ل/');
        array_push($this->arReplacements, 'l');
        array_push($this->arPatterns, '/م/');
        array_push($this->arReplacements, 'm');
        array_push($this->arPatterns, '/ن/');
        array_push($this->arReplacements, 'n');
        array_push($this->arPatterns, '/ه/');
        array_push($this->arReplacements, 'h');
        array_push($this->arPatterns, '/ة/');
        array_push($this->arReplacements, 'h');
        array_push($this->arPatterns, '/و/');
        array_push($this->arReplacements, 'w');
        array_push($this->arPatterns, '/ي/');
        array_push($this->arReplacements, 'y');

        array_push($this->arPatterns, '/ى/');
        array_push($this->arReplacements, 'a');
        array_push($this->arPatterns, '/^أ/');
        array_push($this->arReplacements, 'a');
        array_push($this->arPatterns, '/ى/');
        array_push($this->arReplacements, 'a');
        array_push($this->arPatterns, '/أ/');
        array_push($this->arReplacements, "'a");
        array_push($this->arPatterns, '/إ/');
        array_push($this->arReplacements, 'i');
        array_push($this->arPatterns, '/ء/');
        array_push($this->arReplacements, "'a");
        array_push($this->arPatterns, '/ؤ/');
        array_push($this->arReplacements, "u'");
        array_push($this->arPatterns, '/ئ/');
        array_push($this->arReplacements, "'i");
        array_push($this->arPatterns, '/^آ/');
        array_push($this->arReplacements, "aa");
        array_push($this->arPatterns, '/آ/');
        array_push($this->arReplacements, "'aa");

        array_push($this->arPatterns, '/ْ/');
        array_push($this->arReplacements, '');
        array_push($this->arPatterns, "/'+/");
        array_push($this->arReplacements, "'");
        array_push($this->arPatterns, "/([\- ])'/");
        array_push($this->arReplacements, '\\1');
    }

    function ar2en($string) {
        $string = preg_replace('/ة ال/', 'tul', $string);
        $words = explode(' ', $string);
        $string = '';

        foreach($words as $word) {
            $string .= ' '.ucwords(preg_replace($this->arPatterns, $this
                ->arReplacements, $word));
        }

        return $string;
    }
}

?>
