<?php
// ++=========================================================================++
// || vBadvanced CMPS v3.0.1 (vB 3.6 - vB 3.7) - 84947
// ||  2003-2008 vBadvanced.com - All Rights Reserved
// || This file may not be redistributed in whole or significant part.
// || http://vbadvanced.com
// || Downloaded 05:27, Wed Jul 2nd 2008
// || 116084947_406111024415
// ++ ========================================================================++

error_reporting(E_ALL & ~E_NOTICE);

// ##### strripos function for PHP4- ##########################################
if (!function_exists('strripos'))
{
	function strripos($string, $needle)
	{
		$string = strtolower($string);
		$needle = strtolower($needle);

		$pos = strlen($string) - strpos(strrev($string), strrev($needle));

		if ($pos == strlen($string))
		{
			$pos = 0;
		}

		return $pos;
	}
}

// ##### Order Site Naviation links ###########################################
function order_site_nav($a, $b)
{
	return ($a['order'] < $b['order']) ? -1 : 1;
}

// ##### Construct Global Templates Function ##################################
if (!function_exists('construct_global_templates'))
{
	function construct_global_templates($mod)
	{
		global $globaltemplates;

		if ($mod['inctype'] == 'php_file' AND !empty($mod['templatelist']))
		{
			$globaltemplates = array_merge($globaltemplates, $mod['templatelist']);
		}
		else if ($mod['inctype'] == 'template' AND $mod['filename'])
		{
			$globaltemplates[] = 'adv_portal_' . $mod['filename'];
		}

		if ($mod['altshell'])
		{
			$globaltemplates[] = $mod['altshell'];
		}
	}
}

// ##### Template replacements function #######################################
if (!function_exists('replace_template_filenames'))
{
	function replace_template_filenames($tempname, $extrafiles = array())
	{
		global $vbulletin, $vba_options;

		global $repfiles;

		$repfiles = array('find' => array(), 'replace' => array());

		$optreplace = explode("\r\n", $vba_options['global_' . $tempname . '_replace']);
		if (!empty($optreplace))
		{
			foreach ($optreplace AS $filename)
			{
				if (trim($filename))
				{
					$repfiles['find'][] = '"' . $filename;
					$repfiles['replace'][] = '"' . $vbulletin->options['bburl'] . '/' . $filename;
				}
			}
		}

		if (!empty($extrafiles['find']))
		{
			$repfiles['find'] = array_merge($repfiles['find'], $extrafiles['find']);
		}

		if (!empty($extrafiles['replace']))
		{
			$repfiles['replace'] = array_merge($repfiles['replace'], $extrafiles['replace']);
		}

		if (empty($repfiles))
		{
			return;
		}

		cmps_template_alter($tempname,
			$repfiles['find'],
			$repfiles['replace']
		);
	}
}

// ##### Strip Body Tag #######################################################
function strip_body_tags($content)
{
	global $header, $navbar, $footer, $headinclude, $spacer_open, $spacer_close;

	$bodytag = strpos($content, '<body');

	if ($bodytag)
	{
		$bodycut = strpos($content, '>', $bodytag);

		// Find and add any js tags that might be in the content's <head> tag
		preg_match_all('@<script[^>]*?>.*?</script>@si', str_replace($headinclude, '', substr($content, 0, $bodycut)), $jstags);

		if (!empty($jstags[0]))
		{
			foreach ($jstags[0] AS $addtag)
			{
				$headinclude .= $addtag;
			}
		}

		$content = substr($content, $bodycut + 1);
	}

	$bodyendcut = strpos($content, '<!--start debug html-->');

	if (!$bodyendcut)
	{
		$bodyendcut = strpos($content, '</body>');
	}

	if ($bodyendcut)
	{
		$content = substr($content, 0, $bodyendcut);
	}

	return str_replace(array($header, $navbar, $footer, $headinclude, $spacer_open, $spacer_close) , '', $content);
}

// ##### Function to Print The Page Out #######################################
function print_portal_output(&$home, $nonindex = false, $from_print_output = false)
{
	global $vba_options, $pages, $vba_style, $cmps_options, $home, $modules, $vba_modcols;
	global $vba_shellint, $vba_php_modint, $vba_bbc_modint, $vba_initload;
	global $adv_forumperms, $adv_canviewforums, $adv_canviewforumscontent, $vba_colwidths, $modcol, $onlineprocesssed, $vb_read_cookies;

	global $vbulletin, $vbphrase, $stylevar, $show, $pagetitle, $vbcollapse, $tempusagecache;
	global $db, $permissions, $bgclass, $altbgclass, $bbcode_parser, $imodcache, $foruminfo;

	global $header, $headinclude, $footer, $navbar, $spacer_open, $spacer_close, $gobutton;
	global $ad_location, $notices, $notifications_total, $notifications_menubits, $pmbox, $template_hook;

	global $_CALENDARHOLIDAYS, $eventcache, $days, $months, $calendarinfo, $birthdaycache, $doublemonth, $doublemonth1, $doublemonth2, $_CALENDAROPTIONS;

	// Portal global output variables
	if ($vba_options['portal_outputglobals'])
	{
		foreach (explode("\r\n", $vba_options['portal_outputglobals']) AS $glob)
		{
			global ${$glob};
		}
	}

	$pagecache =& $vbulletin->adv_portal_page;

	// ##### Advanced page options
	if (!empty($pages['advanced']))
	{
		foreach ($pages['advanced'] AS $sgroup => $sgvalue)
		{
			foreach ($sgvalue AS $vname => $valu)
			{
				switch ($sgroup)
				{
					case 'adv_portal_main':
						$vba_options[$vname] = $valu;
					break;

					case 'adv_portal_style':
						$vba_style[$vname] = $valu;
					break;

					default:
						$cmps_options[$sgroup][$vname] = $valu;
				}
			}
		}
	}

	if (!USE_VBA_HOMECACHE)
	{
		// Reload BB code parser here if necessary since it could be unset in member.php or usercp.php
		if ($vba_initload & $vba_php_modint['load_bbcode_parser'] AND !isset($bbcode_parser) AND !$vba_options['portal_use_module_function'])
		{
			require_once(DIR . '/includes/class_bbcode.php');

			$bbcode_parser =& new vB_BbCodeParser($vbulletin, fetch_tag_list());
			$bbcode_parser->tag_list['no_option']['thread']['html'] = str_replace('"showthread.php', '"' . $vbulletin->options['bburl'] . '/showthread.php', $bbcode_parser->tag_list['no_option']['thread']['html']);
			$bbcode_parser->tag_list['no_option']['post']['html'] = str_replace('"showthread.php', '"' . $vbulletin->options['bburl'] . '/showthread.php', $bbcode_parser->tag_list['no_option']['thread']['html']);

			$bbcode_parser->tag_list['option']['thread']['html'] = str_replace('"showthread.php', '"' . $vbulletin->options['bburl'] . '/showthread.php', $bbcode_parser->tag_list['option']['thread']['html']);
			$bbcode_parser->tag_list['option']['post']['html'] = str_replace('"showthread.php', '"' . $vbulletin->options['bburl'] . '/showthread.php', $bbcode_parser->tag_list['option']['thread']['html']);
		}

		// Set for recent threads mod here instead of in the file, incase multiple copies are enabled
		$vb_read_cookies = array();

		// Set here for consistancy, incase they've already been set within a file
		$bgclass = 'alt2';
		$altbgclass = 'alt1';

		$getmemory = false;
		if ($vbulletin->debug AND function_exists('memory_get_usage'))
		{
			$getmemory = true;
		}

		// Process Active Modules
		if (!empty($pages['modules']))
		{
			if ($vbulletin->debug AND $_REQUEST['explain'])
			{
				$scriptstarted = explode(' ', TIMESTART);
				$scriptstarted = $scriptstarted[0] + $scriptstarted[1];
			}

			foreach ($pages['modules'] AS $modcol => $pagemodules)
			{
				foreach ($pagemodules AS $modid => $modorder)
				{
					$mods =& $vbulletin->adv_modules[$modid];

					if ($vbulletin->debug AND $_REQUEST['explain'])
					{
						$processtitle = $mods['title'];
						echo '<div class="explain"><div class="explaintitle">Processing Module: ' . $mods['title'] . '</div><div class="explainbody">';

						$starttime = explode(' ', microtime());
						$starttime = $starttime[0] + $starttime[1] - $scriptstarted;
						$startqueries = $vbulletin->db->querycount;
						$startquerytime = $vbulletin->db->time_total;

						if ($getmemory)
						{
							$memoryusagestart = memory_get_usage();
						}
					}

					if ($stylevar['oldcellpadding'])
					{
						$stylevar['cellpadding'] = $stylevar['oldcellpadding'];
						$stylevar['oldcellpadding'] = '';
					}

					$mod_options =& $cmps_options['adv_portal_' . $mods['identifier']];

					// Set $getbgrow just incase it's still used anywhere
					exec_switch_bg();
					$getbgrow =& $bgclass;

					$mods['collapse'] = $mods['modid'];

					$show['tablerow'] = false;

					// Link (placed before the switch() for modules that dynamically set a link)
					if ($mods['link'])
					{
						eval('$mods[\'link\'] = "' . addslashes($mods['link']) . '";');
					}

					switch ($mods['inctype'])
					{
						// PHP File Module
						case 'php_file':

							if ($vba_options['portal_use_module_function'])
							{
								fetch_vba_module($mods);
							}
							else if ($mods['options'] & $vba_php_modint['clean_output'])
							{
								ob_start();
								require(DIR . '/modules/' . $mods['filename']);
								$home[$modid]['content'] = ob_get_contents();
								ob_end_clean();
							}
							else
							{
								require(DIR . '/modules/' . $mods['filename']);
							}
						break;

						// Template Module
						case 'template':
							eval('$home[$mods[\'modid\']][\'content\'] = "' . fetch_template('adv_portal_' . $mods['filename']) . '";');
						break;

						// BB Code Module
						case 'bb_code':
							$home[$modid]['content'] =& $mods['code_parsed'];
							$show['tablerow'] = true;
						break;

						// ##### Custom page content
						case 'custom':
							$mods['useshell'] = $pages['useshell'];
							$mods['title'] = ($pages['custom_title']) ? $pages['custom_title'] : $pages['title'];
							$mods['colspan'] = $pages['colspan'];

							switch ($pages['type'])
							{
								// PHP File page
								case 'php_file':

									// Processed outside of the function now

								break;

								// HTML File Page
								case 'html_file':

									if (function_exists('file_get_contents'))
									{
										$home[$modid]['content'] = strip_body_tags(file_get_contents($pages['template']));
									}
									else
									{
										if ($handle = fopen($pages['template'], 'r'))
										{
											$home[$modid]['content'] = strip_body_tags(fread($handle, filesize($pages['template'])));
											fclose($handle);
										}
									}

								break;

								// Template page
								case 'template':
									if ($pages['template'])
									{
										eval('$home[$modid][\'content\'] = "' . fetch_template($pages['template']) . '";');
										$home[$modid]['content'] = strip_body_tags($home[$modid]['content']);
									}
								break;

								// BB code page
								case 'bb_code':
									$home[$modid]['content'] = $bbcode_parser->do_parse(
										$pages['template'],
										$cmps_options['custompage']['allow_html'],
										$cmps_options['custompage']['allow_smilies'],
										1,
										$cmps_options['custompage']['allow_image_code'],
										1
									);
								break;

								// Custom content from another page
								case 'module':
									if ($nonindex)
									{
										// Integrated content replacements
										$bodytag = strpos($nonindex, '<body');

										if ($bodytag)
										{
											// Work around for <body> tags that could contain js with >'s
											preg_match('#<body(\s+\w+\s*=\s*(("|\').*?(?<!\\\)\3))*>#s', $nonindex, $bmatches);  

											$bodycut = strlen($bmatches[0]) + $bodytag;
											$newheader = substr($nonindex, 0, $bodycut);
											$nonindex = substr($nonindex, $bodycut);
										}

										$bodyendcut = strpos($nonindex, '<!--start debug html-->');

										if (!$bodyendcut)
										{
											$bodyendcut = strpos($nonindex, '</body>');
										}

										if ($bodyendcut)
										{
											$nonindex = substr($nonindex, 0, $bodyendcut);
										}

										$nonindex = str_replace(
											array($header, $navbar, $footer, $headinclude, $spacer_open, $spacer_close),
											'',
											$nonindex
										);

										// adv_portal template replacements
										$ptemplate =& $vbulletin->templatecache['adv_portal'];

										$bodytag = strpos($ptemplate, '<body');

										if ($bodytag)
										{
											$bodycut = strpos($ptemplate, '>', $bodytag);
											$ptemplate = substr($ptemplate, $bodycut + 1);
										}

										$ptemplate = str_replace("\'", "'", addslashes($newheader)) . $ptemplate;

										$home[$mods['modid']]['content'] = $nonindex;
									}
								break;

								default:
		            	($hook = vBulletinHook::fetch_hook('vba_cmps_include_switch_pagetype')) ? eval($hook) : false;

							}

							$show['tablerow'] = true;

						break;

						default:

							($hook = vBulletinHook::fetch_hook('vba_cmps_include_switch_type')) ? eval($hook) : false;

					}

					// Module shell template
					if ($home[$modid]['content'] AND ($mods['useshell'] & $vba_shellint['enable']) AND !$mods['noshell'])
					{
						if ($mods['formcode'])
						{
							eval('$mods[\'formcode\'] = "' . addslashes($mods['formcode']) . '";');
						}

						if ($mods['useshell'] & $vba_shellint['collapse'])
						{
							$modcollapse = 'display: none';
							$modimgcollapse = '_collapsed';
						}
						else
						{
							$modcollapse = $vbcollapse['collapseobj_module_' . $mods['modid']];
							$modimgcollapse = $vbcollapse['collapseimg_module_' . $mods['collapse']];
						}

						$modulehtml = $home[$modid]['content'];
						eval('$home[$mods[\'modid\']][\'content\'] = "' . fetch_template(($mods['altshell'] ? $mods['altshell'] : 'adv_portal_module_wrapper')) . '";');
					}

					// Debug
					if ($vbulletin->debug AND $_REQUEST['explain'])
					{
						$finishtime = explode(' ', microtime());
						$finishtime = $finishtime[0] + $finishtime[1] - $scriptstarted;
						$finishqueries = $vbulletin->db->querycount;
						$finishquerytime = $vbulletin->db->time_total;
						$timetaken = $finishtime - $starttime;
						$querytimetaken = $finishquerytime - $startquerytime;

						echo '<div class="explainbody">Time Before: ' . vb_number_format($starttime, 5) . '<br />Time After: ' . vb_number_format($finishtime, 5) . '<br />Time Taken: ' . vb_number_format($timetaken, 5) . '<br /><br />';

						$module_memory_usage = '';
						if ($getmemory)
						{
							$memoryusageend = memory_get_usage();

							echo 'Memory Before: ' . vb_number_format($memoryusagestart / 1024, 3) . ' KB<br />Memory After: ' . vb_number_format($memoryusageend / 1024, 3) . ' KB<br />Memory Used: ' . vb_number_format(($memoryusageend - $memoryusagestart) / 1024, 3) . ' KB<br /><br />';
						}

						echo $processtitle . ' module generated in ' . vb_number_format($timetaken, 5) . ' seconds with ' . ($finishqueries - $startqueries) . ' queries.<br />' . vb_number_format($querytimetaken, 5) . ' seconds doing MySQL queries and ' . vb_number_format($timetaken - $querytimetaken, 5) . ' doing PHP things.</div></div></div><br />';
					}

					$home[$vba_modcols[$modcol] . 'blocks'] .= $home[$modid]['content'];
				}
			}
		}

		unset($forumperms, $mods);
	}

	// Page title
	if (!$pagetitle AND $pages['name'] != 'home')
	{
		$pagetitle = $pages['title'];
	}

	// Navbar
	if ($vba_style['portal_shownavbar'] AND empty($navbar))
	{
		if ($pages['name'] != 'home')
		{
			if ($pages['parentlist'])
			{
				foreach (array_reverse(explode(',', $pages['parentlist'])) AS $key => $parent)
				{
					if ($parent != $pages['pageid'])
					{
						$navpagename = $pagecache[$parent]['name'];
						$navbits[$vba_options['portal_homeurl'] . '?' . $vbulletin->session->vars['sessionurl'] . $vba_options['portal_pagevar'] . '=' . $navpagename] = $pagecache[$parent]['title'];
					}
				}
			}
			$navbits[''] = $pagetitle;
		}
		if ($navbits)
		{
			$navbits = construct_navbits($navbits);
		}
		eval('$navbar = "' . fetch_template('navbar') . '";');
	}
	else if (!$vba_style['portal_shownavbar'])
	{
		$navbar = '';
	}

	($hook = vBulletinHook::fetch_hook('vba_cmps_print_output')) ? eval($hook) : false;

	if ($from_print_output AND !$vbulletin->debug)
	{
		$vbulletin->options['addtemplatename'] = 0;
		eval('$output = "' . fetch_template('adv_portal') . '";');
		return process_replacement_vars($output);
	}
	else
	{
		// Rebuild the guest homepage cache
		if ($pages['name'] == 'home' AND !$vbulletin->userinfo['userid'] AND $vba_options['portal_guestcache'] AND ($vbulletin->adv_portal_pars['lastupdate'] + $vba_options['portal_guestcache']) <= TIMENOW)
		{
			$homecache = array();
			foreach ($vba_modcols AS $modcol => $modcolname)
			{
				if ($home[$modcolname . 'blocks'])
				{
					$homecache[$modcolname] = 1;
					$homecache[$modcolname . 'blocks'] = $home[$modcolname . 'blocks'];
				}
			}

			build_datastore(
				'adv_portal_pars',
				serialize(array('home' => $homecache, 'lastupdate' => TIMENOW)),
				1
			);
		}

		// Replace the tempusagecache variables with their original values for reformatting
		if ($vbulletin->debug)
		{
			foreach ($tempusagecache AS $tempname => $temptimes)
			{
				preg_match('/\(([0-9])\)/', $temptimes, $matches);
				if (intval($matches[1]))
				{
					$tempusagecache[$tempname] = $matches[1];
				}
			}
		}

		define('SKIP_OUTPUT', true);
		eval('print_output("' . fetch_template('adv_portal') . '");');
	}
}

// ##### run str_replace() on templates #######################################
function cmps_template_alter($name, $find, $replace)
{
	global $vbulletin;

	$processed = false;

	($hook = vBulletinHook::fetch_hook('vba_cmps_template_alter')) ? eval($hook) : false;

	if ($processed)
	{
		return;
	}

	$vbulletin->templatecache[$name] = str_replace(
		$find,
		$replace,
		$vbulletin->templatecache[$name]
	);
}

###############################################################################
// ##### End Functions
###############################################################################

$templatecache = array();

// ##### Merge the settings
$cmps_options =& $vbulletin->adv_portal_opts;

$portal_options = array_merge($cmps_options['adv_portal_main'], $cmps_options['adv_global']);

if (empty($vba_options))
{
	$vba_options =& $portal_options;
}
else
{
	$vba_options = array_merge($vba_options, $portal_options);
}

$vba_style =& $cmps_options['adv_portal_style'];

require_once(DIR . '/includes/vba_cmps_global.php');

// Figure out which page to grab
$pagevar = $vba_options['portal_pagevar'];

if (defined('VBA_PAGE'))
{
	$getpage = VBA_PAGE;
}
else if(isset($_REQUEST[$pagevar]))
{
	$getpage = $_REQUEST[$pagevar];
}
else
{
	$getpage = 'home';
}

($hook = vBulletinHook::fetch_hook('vba_cmps_include_getpage')) ? eval($hook) : false;

// ##### Now grab the page
if ($getpage == 'home')
{
	$pages =& $vbulletin->adv_portal_home;
}
else
{
	$pages = $db->query_first("
		SELECT * FROM " . TABLE_PREFIX . "adv_pages
		WHERE name = '" . $db->escape_string($getpage) . "'
			" . iif(!($permissions['adminpermissions'] & $vbulletin->bf_ugp_adminpermissions['cancontrolpanel']), 'AND active = 1')
	);

	$pages['userperms'] = explode(',', $pages['userperms']);
	$pages['modules'] = unserialize($pages['modules']);
	$pages['advanced'] = unserialize($pages['advanced']);
	$pages['meta'] = unserialize($pages['meta']);
}

if ($pages['styleid'] AND $pages['styleid'] != -1)
{
	$styleid = $pages['styleid'];
	$userselect = true;
}

// Meta tags
if ($pages['meta']['description'])
{
	$vbulletin->options['description'] = $pages['meta']['description'];
}
if ($pages['meta']['keywords'])
{
	$vbulletin->options['keywords'] = $pages['meta']['keywords'];
}

// Check user's groups against page permissions
$vbulletin->userinfo['usergrouparray'] = fetch_membergroupids_array($vbulletin->userinfo);

$allowview = false;

if ($pages['userperms'])
{
	$allowview = (array_intersect($vbulletin->userinfo['usergrouparray'], $pages['userperms'])) ? true : false;
}

define('USE_VBA_HOMECACHE', ($pages['name'] == 'home' AND !$vbulletin->userinfo['userid'] AND $vba_options['portal_guestcache'] AND $vbulletin->adv_portal_pars['lastupdate'] + $vba_options['portal_guestcache'] >= TIMENOW ? true : false));

if (USE_VBA_HOMECACHE)
{
	$home =& $vbulletin->adv_portal_pars['home'];

	foreach ($home AS $pagecol => $colcontent)
	{
		$show[$pagecol . '_column'] = true;
	}
}
else
{
	unset($vbulletin->adv_portal_pars);

	$modules = array();

	$vba_initload = 0;

	$vba_cusmodid = 0;
	// Sort through the modules to get the $globaltemplates and check perms
	if (!empty($pages['modules']))
	{
		foreach ($pages['modules'] AS $pagecol => $pagemodules)
		{
			if (!empty($pagemodules))
			{
				foreach ($pagemodules AS $advmodid => $advmodorder)
				{
					$vba_mod =& $vbulletin->adv_modules[$advmodid];

					if ($vba_mod['inctype'] == 'custom')
					{
						$vba_cusmodid = $advmodid;
					}

					// Check for perms first incase it's not set as an array
					if (!$vba_mod['userperms'] AND $vba_mod['inctype'] != 'custom')
					{
						unset($pages['modules'][$pagecol][$advmodid]);
						continue;
					}

					if ((array_intersect($vbulletin->userinfo['usergrouparray'], $vba_mod['userperms']) OR $vba_mod['inctype'] == 'custom'))
					{
						// Need an array of nothing but ids for the news/archive and online/buddy modules
						$modules[] = $advmodid;
						construct_global_templates($vba_mod);

						// Needs to be set at least for the news archive so we know which column we're dealing with
						$vba_mod['modcol'] = $pagecol;

						// Initialize variables
						$vba_initload |= $vba_mod['options'];

						($hook = vBulletinHook::fetch_hook('vba_cmps_include_preprocess_modules')) ? eval($hook) : false;
					}
					// No permission to view it
					else
					{
						unset($pages['modules'][$pagecol][$advmodid]);
					}
				}
			}

			if (!empty($pages['modules'][$pagecol]))
			{
				$show[$vba_modcols[$pagecol] . '_column'] = true;
			}
		}
	}

	// More global templates
	if ($pages['type'] == 'bb_code')
	{
		$vba_initload |= $vba_php_modint['load_bbcode_parser'];

		$globaltemplates[] = 'bbcode_quote';
		$globaltemplates[] = 'bbcode_php';
		$globaltemplates[] = 'bbcode_code';
	}

	$globaltemplates[] = 'adv_portal_module_wrapper';

	if ($pages['template'])
	{
		$globaltemplates[] = $pages['template'];
	}
}

?>