/*!======================================================================*\
|| #################################################################### ||
|| # vBulletin 2.0.1
|| # ---------------------------------------------------------------- # ||
|| # Copyright 2000-2009 Jelsoft Enterprises Ltd. All Rights Reserved. ||
|| # This file may not be redistributed in whole or significant part. # ||
|| # ---------------- VBULLETIN IS NOT FREE SOFTWARE ---------------- # ||
|| # http://www.vbulletin.com | http://www.vbulletin.com/license.html # ||
|| #################################################################### ||
\*======================================================================*/

// #############################################################################
// vB_Inline_Mod_Blog
// #############################################################################

/**
* Inline Moderation Class - extension of vB_Inline_Mod
* Handles Selection of Blog Comments / Trackbacks
*
* @param	string	Name of the instance of this class
* @param	string	Type of system (comment/trackback)
* @param	string	ID of the form containing all checkboxes
* @param	string	Phrase for use on Go button
* @param	string	Name of cookie
*/
function vB_Inline_Mod_Blog(varname, type, formobjid, go_phrase, cookieprefix)
{
	vB_Inline_Mod_Blog.baseConstructor.call(this, varname, type, formobjid, go_phrase, cookieprefix);
	this.id = this;
}

vBulletin.extend(vB_Inline_Mod_Blog, vB_Inline_Mod);

vB_Inline_Mod_Blog.prototype.highlight_comment = function(checkbox)
{
	this.highlight_table(checkbox);
}

vB_Inline_Mod_Blog.prototype.highlight_trackback = function(checkbox)
{
	this.highlight_table(checkbox);
}

vB_Inline_Mod_Blog.prototype.highlight_blog = function(checkbox)
{
	this.highlight_table(checkbox);
}

vB_Inline_Mod_Blog.prototype.highlight_pcomment = function(checkbox)
{
	this.highlight_table(checkbox);
}

vB_Inline_Mod_Blog.prototype.highlight_table = function(checkbox)
{
	var maincell = YAHOO.util.Dom.get("td_" + this.type + "_" + checkbox.id.substr(this.type.length + 5));
	if (maincell)
	{
		this.toggle_highlight(maincell, checkbox, true);
	}
}

	/**
	* Toggles an element's classname between original and 'inlinemod'
	*
	* @param	object	The element on which to work
	* @param	object	The checkbox corresponding to the cell element
	*/
vB_Inline_Mod_Blog.prototype.toggle_highlight_alt1 = function(element, checkbox)
	{
		if (element.tagName)
		{
			if (checkbox.checked)
			{
				YAHOO.util.Dom.addClass(element, "inlinemod");
				YAHOO.util.Dom.removeClass(element, "alt1");
			}
			else
			{
				YAHOO.util.Dom.addClass(element, "alt1");
				YAHOO.util.Dom.removeClass(element, "inlinemod");
			}
		}
	}

/*======================================================================*\
|| ####################################################################
|| # CVS: $RCSfile$ - $Revision: 28613 $
|| ####################################################################
\*======================================================================*/