<?php

/*======================================================================*\
|| #################################################################### ||
|| # Banner System Lite v.1.0									      # ||
|| # Author: Thinh Nguyen (tnguy3n)								      # ||
|| # Support site: http://www.vbviet.com						      # ||
|| # Copyright  2005 vBviet Network. All Rights Reserved. 		      # ||
|| # This file may not be redistributed in whole or significant part  # ||
|| #################################################################### ||
\*======================================================================*/

// ######################## SET PHP ENVIRONMENT ###########################
error_reporting(E_ALL & ~E_NOTICE);

// #################### DEFINE IMPORTANT CONSTANTS #######################
define('NO_REGISTER_GLOBALS', 1);
define('GET_EDIT_TEMPLATES', true);
define('THIS_SCRIPT', 'banneradmin');

require_once('./global.php');

// #################### Start main script ####################

if (empty($_REQUEST['do']))
{
	$_REQUEST['do'] = 'settings';
}

if($_REQUEST['do'] == 'settings'){

	header("Location: options.php?do=options&dogroup=bannersys");
}

// Banner Manager
if($_REQUEST['do'] == "manage")
{
	print_cp_header("Banner System Manager");
	print_table_start();
	print_table_header("  ", 4);
	print_form_header('banneradmin','addbanner');
	$banners = $db->query_read("SELECT * FROM " . TABLE_PREFIX . "bannersys_banners ORDER BY bannerid ASC");
	print_cells_row(array('', '', '',''), 1, 1, 1, 1, 'tcat');
	while($banner = $db->fetch_array($banners))
	{
		$bannerid = $banner['bannerid'];

		if($banner['status'] == '0')
		{
			$status = '<font color="red"> </font>';
			$linkopt = "<a href=\"banneradmin.php?do=activate&bannerid=$bannerid\"></a>";
		}
		elseif($banner['status'] == '1')
		{
			$status = '<font color="green"></font>';
			$linkopt = "<a href=\"banneradmin.php?do=deactivate&bannerid=$bannerid\"></a>";
		}
		elseif($banner['status'] == '2') 
		{ 
			$status = '<font color="yellow">Unapproved</font>'; 
			$linkopt = "<a href=\"banneradmin.php?do=approve&bannerid=$bannerid\">Approve</a>";
		}

		$cell = array();
		$cell[] = "<div align='center'>$banner[bannername]<br />$banner[bannerdesc] <br /><a href=\"$banner[bannerurl]\" title=\"$banner[bannername]\" target=\"_blank\"><img src=\"$banner[imgurl]\" alt=\"$banner[bannername]\" borde=\"0\"></a></div>";
		$cell[] = $banner['bwidth'] . ' x ' . $banner['bheight'];
		$cell[] = $status;
		$cell[] = "<div align='center'><a href=\"banneradmin.php?do=modify&bannerid=$bannerid\"></a> | <a href=\"banneradmin.php?do=delete&bannerid=$bannerid\" onClick=\"return confirm('Delete it?')\"></a><br />$linkopt</div>";
		print_cells_row($cell);
	}
	print_submit_row('  ', 0, 4);
	print_table_footer();
	print_cp_footer();
	exit;
}
if($_REQUEST['do']=="addbanner"){
	print_cp_header("  ");
	print_table_start();
	print_table_header(" ");
	print_form_header('banneradmin','insertbanner');
	print_input_row(" :<dfn>  .</dfn>", 'bannername');
	print_input_row(":<dfn> .</dfn>", 'bannerdesc');
	print_input_row(" :<dfn>  </dfn>", 'bannerurl');
	print_input_row(" :<dfn>  .</dfn>", 'imgurl');
	print_input_row(" :<dfn></dfn>", 'bwidth');
	print_input_row(" :<dfn></dfn>", 'bheight');
	print_yes_no_row("?:<dfn>Is it active?</dfn>", 'status');
	print_submit_row(' ', 0);
	print_table_footer();
	print_cp_footer();
	exit;
}

if($_POST['do'] == 'insertbanner')
{
	$vbulletin->input->clean_array_gpc('p', array('bannername' => TYPE_STR, 'bannerdesc' => TYPE_STR, 'bannerurl' => TYPE_STR, 'imgurl' => TYPE_STR, 'bwidth' => TYPE_INT, 'bheight' => TYPE_INT, 'status' => TYPE_INT));

	$db->query_write("
		INSERT INTO " . TABLE_PREFIX . "bannersys_banners(bannername, bannerdesc, bannerurl, imgurl, bwidth, bheight, status) 
		VALUES('" . addslashes(htmlspecialchars_uni($vbulletin->GPC[bannername])) . "', 
			'" . addslashes(htmlspecialchars_uni($vbulletin->GPC[bannerdesc])) . "', 
			'" . addslashes(htmlspecialchars_uni($vbulletin->GPC[bannerurl])) . "', 
			'" . addslashes(htmlspecialchars_uni($vbulletin->GPC[imgurl])) . "', 
			'" . intval($vbulletin->GPC[bwidth]) . "', 
			'" . intval($vbulletin->GPC[bheight]) . "',
			'" . intval($vbulletin->GPC[status]) . "')
		");
	define('CP_REDIRECT', "banneradmin.php?do=manage");
	print_stop_message('banner_added_successfully');
	exit;
}

if($_REQUEST['do']=="modify")
{
	$vbulletin->input->clean_array_gpc('r', array('bannerid' => TYPE_INT));

	$banner= $db->query_first("SELECT * FROM " . TABLE_PREFIX . "bannersys_banners WHERE bannerid = '" . $vbulletin->GPC['bannerid'] . "'");
	print_cp_header(" ");
	print_table_start();
	print_table_header(" : $banner[bannername]");
	print_form_header('banneradmin','update');
	construct_hidden_code('bannerid', $banner['bannerid']);
	print_input_row(" :<dfn>  .</dfn>", 'bannername', $banner['bannername']);
	print_input_row(":<dfn>   </dfn>", 'bannerdesc', $banner['bannerdesc']);
	print_input_row(":<dfn>  </dfn>", 'bannerurl', $banner['bannerurl']);
	print_input_row(" :<dfn>   .</dfn>", 'imgurl', $banner['imgurl']);
	print_input_row(":<dfn></dfn>", 'bwidth', $banner['bwidth']);
	print_input_row(":<dfn></dfn>", 'bheight', $banner['bheight']);
	print_yes_no_row("?:<dfn>  ?</dfn>", '', $banner['status']);
	print_submit_row($vbphrase['update']);
	print_table_footer();
	print_cp_footer();
	exit;
}

if($_POST['do'] == 'update')
{
	$vbulletin->input->clean_array_gpc('p', array(
							'bannerid'			=> TYPE_INT,
							'bannername'		=> TYPE_STR,
							'bannerdesc'		=> TYPE_STR,
							'bannerurl'			=> TYPE_STR,
							'imgurl'			=> TYPE_STR,
							'bwidth'			=> TYPE_INT,
							'bheight'			=> TYPE_INT,
							'status'			=> TYPE_INT
						));

	$db->query_write("UPDATE " . TABLE_PREFIX . "bannersys_banners
		SET bannername = '" . addslashes(htmlspecialchars_uni($vbulletin->GPC[bannername])) . "',
			bannerdesc = '" . addslashes(htmlspecialchars_uni($vbulletin->GPC[bannerdesc])) . "',
			bannerurl = '" . addslashes(htmlspecialchars_uni($vbulletin->GPC[bannerurl])) . "',
			imgurl = '" . addslashes(htmlspecialchars_uni($vbulletin->GPC[imgurl])) . "',	
			bwidth = '" . intval($vbulletin->GPC[bwidth]) . "',
			bheight = '" . intval($vbulletin->GPC[bheight]) . "',	
			status = '" . intval($vbulletin->GPC[status]) . "'	
		WHERE bannerid = '" . intval($vbulletin->GPC[bannerid]) . "'
		");
	define('CP_REDIRECT', "banneradmin.php?do=manage");
	print_stop_message('updated_banner_successfully');
	exit;
}

if ($_REQUEST['do'] == 'delete')
{
	$vbulletin->input->clean_array_gpc('r', array('bannerid' => TYPE_INT));
	$db->query_write("
		DELETE FROM " . TABLE_PREFIX . "bannersys_banners 
		WHERE bannerid = '" . intval($vbulletin->GPC[bannerid]) . "'
	");
	define('CP_REDIRECT', "banneradmin.php?do=manage");
	print_stop_message('deleted_banner_successfully');
	exit;
}

if ($_REQUEST['do'] == 'activate')
{
	$vbulletin->input->clean_array_gpc('r', array('bannerid' => TYPE_INT));
	$db->query_write("
		UPDATE " . TABLE_PREFIX . "bannersys_banners SET status = '1'
		WHERE bannerid = '" . intval($vbulletin->GPC[bannerid]) . "'
	");
	define('CP_REDIRECT', "banneradmin.php?do=manage");
	print_stop_message('activated_banner_successfully');
	exit;
}

if ($_REQUEST['do'] == 'deactivate')
{
	$vbulletin->input->clean_array_gpc('r', array('bannerid' => TYPE_INT));
	$db->query_write("
		UPDATE " . TABLE_PREFIX . "bannersys_banners SET status = '0'
		WHERE bannerid = '" . intval($vbulletin->GPC[bannerid]) . "'
	");
	define('CP_REDIRECT', "banneradmin.php?do=manage");
	print_stop_message('deactivated_banner_successfully');
	exit;
}


// banner stats
if($_REQUEST['do'] == 'stats')
{
	print_cp_header("Banner Stats Manager");
	print_table_start();
	print_table_header(" ", 4);
	print_cells_row(array('Banners', ' ', '',''), 1, 1, 1, 1, 'tcat');

	$getstats = $db->query_read("SELECT banners.bannerid, banners.bannername, banners.bannerurl, banners.status, stats.*, COUNT(stats.bannerid) AS totalhits
		FROM " . TABLE_PREFIX . "bannersys_stats AS stats
		LEFT JOIN " . TABLE_PREFIX . "bannersys_banners AS banners ON (banners.bannerid = stats.bannerid)
		GROUP BY stats.bannerid
		ORDER BY totalhits DESC	
	");
	while($stats = $db->fetch_array($getstats))
	{
		if($stats['status'] == '0')
		{
			$status = '<font color="red"> </font>';
		}
		elseif($stats['status'] == '1')
		{
			$status = '<font color="green">Active</font>';
		}
		elseif($stats['status'] == '2') 
		{ 
			$status = '<font color="yellow">Unapproved</font>'; 
		}
		
		// print results
		$cell = array();
		$cell[] = "<a href=\"$stats[bannerurl]\" target=\"_blank\">" . $stats['bannername'] . '</a>';
		$cell[] = $stats['totalhits'];
		$cell[] = $status;
		$cell[] = "<div align='center'><a href=\"banneradmin.php?do=viewstats&bannerid=$stats[bannerid]\"> </a></div>";
		print_cells_row($cell);
	}
	print_table_footer();
	print_cp_footer();
}


// view banner stats
if($_REQUEST['do'] == 'viewstats')
{
	$bannerid = $vbulletin->input->clean_gpc('r', 'bannerid', TYPE_INT);

	print_cp_header(" ");
	print_table_start();
	print_table_header("", 3);
	print_cells_row(array('', '', ''), 1, 1, 1, 'tcat');

	$getstats = $db->query_read("SELECT stats.*, banner.bannerid, user.userid, user.username
		FROM " . TABLE_PREFIX . "bannersys_stats AS stats
		LEFT JOIN " . TABLE_PREFIX . "bannersys_banners AS banner ON (banner.bannerid = stats.bannerid)
		LEFT JOIN " . TABLE_PREFIX . "user AS user ON (user.userid = stats.visitorid)
		WHERE stats.bannerid = '$bannerid'
		ORDER BY stats.visitdate DESC	
	");
	while($stats = $db->fetch_array($getstats))
	{
		$stats['visitdate'] = vbdate($vbulletin->options['dateformat'], $stats['visitdate']);

		if($stats['userid'])
		{
			$user = "<a href=\"../member.php?u=$stats[userid]\">" . $stats['username'] . '</a>';
		}
		else
		{
			$user = 'Guest';
		}

		// print results
		$cell = array();
		$cell[] = $user;
		$cell[] = $stats['visitdate'];
		$cell[] = $stats['visitorip'];
		print_cells_row($cell);
	}
	print_table_footer();
	print_cp_footer();
}


?>