<?php
/*======================================================================*\
|| #################################################################### ||
|| # MODCP User Administration - Nestaron
|| # ---------------------------------------------------------------- # ||
|| # Copyright 2009 Nestaron - Jason Lagasse
|| # This file may not be redistributed in whole or significant part. # ||
|| # Version 1.1													  # ||
|| #################################################################### ||
\*======================================================================*/

// ######################## SET PHP ENVIRONMENT ###########################
error_reporting(E_ALL & ~E_NOTICE);

// #################### PRE-CACHE TEMPLATES AND DATA ######################
$phrasegroups = array('cpuser');
$specialtemplates = array();

// ########################## REQUIRE BACK-END ############################
require_once('./global.php');

$vbulletin->input->clean_array_gpc('r', array('userid' => TYPE_INT));

// ########################################################################
// ######################### START MAIN SCRIPT ############################
// ########################################################################

print_cp_header($vbphrase['useradministration']);

// check permissions
if (!($permissions['adminpermissions'] & CANCONTROLPANEL) AND (!can_moderate(0, 'canviewprofile') AND ($vbulletin->options['modcpua_enabled'])))
{
	print_stop_message('ucm_no_permission_user_administration');
}

// ###################### Start find #######################
if ($_REQUEST['do'] == 'find')
{
	
	print_form_header('useradministration', 'findname');
	print_table_header($vbphrase['search_users']);
	print_input_row($vbphrase['username'], 'findname');
	print_yes_no_row($vbphrase['exact_match'], 'exact', 0);
	print_submit_row($vbphrase['search']);
}

// ###################### Start findname #######################
if ($_REQUEST['do'] == 'findname')
{
	$vbulletin->input->clean_array_gpc('r', array(
		'findname' => TYPE_NOHTML,
		'exact'    => TYPE_STR, // leave this as str because the main page sends a string value through
	));

	$editusername = can_moderate(0, 'canviewprofile');

	if (empty($vbulletin->GPC['findname']))
	{
		print_stop_message('please_complete_required_fields');
	}

	if ($vbulletin->GPC['exact'])
	{
		$condition = "username = '" . $db->escape_string($vbulletin->GPC['findname']) . "'";
	}
	else
	{
		$condition = "username LIKE '%" . $db->escape_string_like($vbulletin->GPC['findname']) . "%'";
	}

	$users = $db->query_read("
		SELECT userid, username
		FROM " . TABLE_PREFIX . "user
		WHERE $condition
		ORDER BY username
	");
	if ($db->num_rows($users) > 0)
	{
		print_form_header('', '', 0, 1, 'cpform', '70%');
		print_table_header(construct_phrase($vbphrase['showing_users_x_to_y_of_z'], '1', $db->num_rows($users), $db->num_rows($users)), 7);
		while ($user = $db->fetch_array($users))
		{
			$cell = array("<b>$user[username]</b>");
			$cell[] = iif($editusername, '<span class="smallfont">' . construct_link_code($vbphrase['ucm_edit_user'], 'useradministration.php?' . $vbulletin->session->vars['sessionurl'] . "do=edit_user&amp;u=$user[userid]") . '</span>');						
			print_cells_row($cell);
		}
		print_table_footer();
	}
	else
	{
		print_stop_message('no_matches_found');
	}
}
// ################### Start User Editor ###############################
// Check Permissions
if ($_REQUEST['do'] == 'edit_user')
{
	if (!can_moderate(0, 'canviewprofile'))
	{
		print_stop_message('no_permission');
	}

$user = $db->query_first("
		SELECT user.username, user.userid, user.membergroupids, user.usergroupid, user.displaygroupid, usergroup.usergroupid, usergroup.title
		FROM " . TABLE_PREFIX . "user AS user
		LEFT JOIN " . TABLE_PREFIX . "usergroup AS usergroup ON(usergroup.usergroupid = user.usergroupid)
		WHERE userid = " . $vbulletin->GPC['userid'] . "
	");

//	Create Form - Change Username
	print_form_header('useradministration', 'do_change_username');
	construct_hidden_code('userid', $vbulletin->GPC['userid']);
	print_table_header(construct_phrase($vbphrase['x_y_id_z'], $vbphrase['user'], $user['username'], $user['userid']));
	print_cells_row(array($vbphrase['ucm_current_username'], $user['username']));
	print_input_row($vbphrase['ucm_new_username'], 'newusername', $newusername);
	print_submit_row($vbphrase['ucm_save_username']);
	print_table_break('', $INNERTABLEWIDTH);

// Create Form - Usergroup Options
	print_form_header('useradministration', 'do_usergroup_update');
	construct_hidden_code('userid', $vbulletin->GPC['userid']);
	print_table_header(construct_phrase($vbphrase['x_y_id_z'], $vbphrase['user'], $user['username'], $user['userid']));
	print_chooser_row($vbphrase['primary_usergroup'], 'user[usergroupid]', 'usergroup', $user['usergroupid']);
	if (!empty($user['membergroupids']))
	{
		$usergroupids = $user['usergroupid'] . (!empty($user['membergroupids']) ? ',' . $user['membergroupids'] : '');
		print_chooser_row($vbphrase['display_usergroup'], 'user[displaygroupid]', 'usergroup', iif($user['displaygroupid'] == 0, -1, $user['displaygroupid']), $vbphrase['default'], 0, "WHERE usergroupid IN ($usergroupids)");
	}
	$tempgroup = $user['usergroupid'];
	$user['usergroupid'] = 0;
	print_membergroup_row($vbphrase['additional_usergroups'], 'user[membergroupids]', 0, $user);
	$user['usergroupid'] = $tempgroup;
	print_submit_row($vbphrase['ucm_save_usergroup']);
	print_table_break('', $INNERTABLEWIDTH);
}	

// ################### Start Username Update ###############################
// Save Username Change

if ($_POST['do'] == 'do_change_username')
{

//	Reverify Permissions
	if (!can_moderate(0, 'canviewprofile'))
	{
		print_stop_message('no_permission');
	}

// Clean Array	
	$vbulletin->input->clean_array_gpc('p', array(
		'newusername' => TYPE_STR
	));

// Check For Unalterable Users
	$noalter = explode(',', $vbulletin->config['SpecialUsers']['undeletableusers']);
	if (!empty($noalter[0]) AND in_array($vbulletin->GPC['userid'], $noalter))
	{
		print_stop_message('ucm_protected_user');
	}

	$superadmins = explode(',', $vbulletin->config['SpecialUsers']['superadministrators']);
	if (!empty($superadmins[0]) AND in_array($vbulletin->GPC['userid'], $superadmins))
	{
		print_stop_message('ucm_protected_user');
	}

	$protectedadmins = split(',', $vbulletin->options['modcpua_protectedadministrators']);
	if (!empty($protectedadmins[0]) AND in_array($vbulletin->GPC['userid'], $protectedadmins))
	{
		print_stop_message('ucm_protected_user');
	}
	
// Fetch Cached User Info
	$user = fetch_userinfo($vbulletin->GPC['userid']);

	if (empty($user))
	{
		print_stop_message('invalid_user_specified');
	}

// Process Database Entry
	$userdata =& datamanager_init('User', $vbulletin, ERRTYPE_CP);
	$userdata->adminoverride = true;
	$userdata->set_existing($user);
	$userdata->set('username', unhtmlspecialchars(trim($vbulletin->GPC['newusername'])));
	$userdata->save();
	unset($userdata);

	// Log Action to Control Panel Log
	log_admin_action(iif($vbulletin->GPC['userid']!=0, 'user id = ' . $vbulletin->GPC['userid'] . ', oldname = ' . $user['username'] . ', newname = ' . trim($vbulletin->GPC['newusername']), ''));

	define('CP_REDIRECT', "index.php?do=home");
	print_stop_message('ucm_changed_username_successfully');
}

// ################### Start Usergroup Update ###############################
// Save Usergroup Changes
if ($_POST['do'] == 'do_usergroup_update')
{

// Reverify Permissions	
	if (!can_moderate(0, 'canviewprofile'))
	{
		print_stop_message('no_permission');
	}

// Clean Array
	$vbulletin->input->clean_array_gpc('p', array(
			'userid'			=> TYPE_UINT,
			'user'              => TYPE_ARRAY,
			'usergroupid'		=> TYPE_INT,
			'olduser'           => TYPE_BINARY
			));
	
	 // init data manager
	$userdata =& datamanager_init('User', $vbulletin, ERRTYPE_CP);
	$userdata->adminoverride = true;
	
// Check For Unalterable Users
	$noalter = explode(',', $vbulletin->config['SpecialUsers']['undeletableusers']);
	if (!empty($noalter[0]) AND in_array($vbulletin->GPC['userid'], $noalter))
	{
		print_stop_message('ucm_no_permissions_change_usergroup');
	}

	$superadmins = explode(',', $vbulletin->config['SpecialUsers']['superadministrators']);
	if (!empty($superadmins[0]) AND in_array($vbulletin->GPC['userid'], $superadmins))
	{
		print_stop_message('ucm_no_permissions_change_usergroup');
	}		

	$protectedadmins = split(',', $vbulletin->options['modcpua_protectedadministrators']);
	if (!empty($protectedadmins[0]) AND in_array($vbulletin->GPC['userid'], $protectedadmins))
	{
		print_stop_message('ucm_protected_user');
	}
	
// Check to make sure Moderator has not assigned a Restricted Group
	
	$restrictedugroups = split(',', $vbulletin->options['modcpua_protectedusergroups']);
    if (!empty($restrictedugroups[0]) AND in_array($vbulletin->GPC['user']['usergroupid'], $restrictedugroups))
    {
		print_stop_message('ucm_no_permissions_restricted_usergroups');
    }

    if (!empty($vbulletin->GPC['user']['membergroupids']))
    {
		$restrictedugroups = explode(',', $vbulletin->options['modcpua_protectedusergroups']);
    	$newmembergroups = implode(',', $vbulletin->GPC['user']['membergroupids']);
   		if (!empty($restrictedugroups[0]) AND in_array($newmembergroups, $restrictedugroups) ? 'true' : 'false')
   			{
	   			foreach($restrictedugroups as $nmgids)
	   				{
		   				if (strstr($newmembergroups, $nmgids))
	   					{
							print_stop_message('ucm_no_permissions_restricted_usergroups');
   						}
					}
			}
	}
	
	// set existing info if this is an update
	if ($vbulletin->GPC['userid'])
	{
		$userinfo = fetch_userinfo($vbulletin->GPC['userid']);
		if (!$userinfo)
		{
			print_stop_message('invalid_user_specified');
		}
		$userinfo['posts'] = intval($vbulletin->GPC['user']['posts']);
		$userdata->set_existing($userinfo);
	}
	
	 $displaygroupid = ($vbulletin->GPC['user']['displaygroupid'] <= 0) ? $vbulletin->GPC['user']['usergroupid'] : $vbulletin->GPC['user']['displaygroupid'];
	// custom user title
	$userdata->set_usertitle(
		$vbulletin->GPC['user']['usertitle'],
		$vbulletin->GPC['user']['customtitle'] ? false : true,
		$vbulletin->usergroupcache["$displaygroupid"],
		true,
		$vbulletin->GPC['user']['customtitle'] == 1 ? true : false
	);
	unset($vbulletin->GPC['user']['usertitle'], $vbulletin->GPC['user']['customtitle']);

	// user fields
	foreach ($vbulletin->GPC['user'] AS $key => $val)
	{
		if (!$vbulletin->GPC['userid'] OR $olduser["$key"] != $val)
		{
			$userdata->set($key, $val);
		}
	}
	
	if (empty($vbulletin->GPC['user']['membergroupids']))
	{
		$userdata->set('membergroupids', '');
	} 
	
	// save data
	$userid = $userdata->save();
	if ($vbulletin->GPC['userid'])
	{
		$userid = $vbulletin->GPC['userid'];
	}
	
	// Log Action to Control Panel Log
	log_admin_action(iif($vbulletin->GPC['userid'] != 0, 'user id = ' . $vbulletin->GPC['userid']));
	
	define('CP_REDIRECT', "index.php?do=home");
	print_stop_message('ucm_usergroup_updated_Successfully');
}

print_cp_footer();
?>