<?php
// ######################## SET PHP ENVIRONMENT ###########################
error_reporting(E_ALL & ~E_NOTICE);

// #################### PRE-CACHE TEMPLATES AND DATA ######################
$phrasegroups = array('style');
$specialtemplates = array('products');

// ########################## REQUIRE BACK-END ############################
require_once('./global.php');
require_once(DIR . '/includes/adminfunctions_template.php');

$chatbox_table = 'chatbox'; //chatbox database table

define('THIS_SCRIPT', 'chatbox_admin');

print_cp_header();


# delete forms
if ( $_REQUEST['do'] == 'delete' ) {
	print_form_header(THIS_SCRIPT, 'deleteuser', 0, 1, 'deleteuserForm');
	print_table_header('Delete User Messages');
	print_input_row('User ID or Username', 'userid');
	print_submit_row('Delete Messages', 0);
	
	print_form_header(THIS_SCRIPT, 'deleteall', 0, 1, 'deleteallForm');
	print_table_header('Delete All Messages');
	print_input_row('Type "delete"', 'imsure');
	print_submit_row('Delete All Messages', 0);
	
	print_form_header(THIS_SCRIPT, 'deletedays', 0, 1, 'deletedaysForm');
	print_table_header('Delete Messages Older Than');
	print_input_row('Delete messages older than', 'days', 'days');
	print_submit_row('Delete Messages', 0);
}

# delete all messages
if ( $_REQUEST['do'] == 'deleteall' ) {
	if ( $_REQUEST['imsure'] == 'delete' ) {
		$db->query_write("TRUNCATE ".TABLE_PREFIX.$chatbox_table);
	}
	print_cp_redirect("chatbox_admin.php?" . $vbulletin->session->vars['sessionurl'] . "&do=delete", 1);
}

# delete user messages
if ( $_REQUEST['do'] == 'deleteuser' ) {
	if ( empty($_REQUEST['userid']) ) { chatboxadmin_print_stop_back('Need a User ID or Username.'); }
	
	if ( !is_numeric($_REQUEST['userid']) ) {
		$userid = chatboxadmin_username_exists($_REQUEST['userid']);
		if ( empty($userid) ) { chatboxadmin_print_stop_back('User '.$_REQUEST['userid'].' does not exist.'.$userid); }
	} else {
		if ( !chatboxadmin_user_exists($_REQUEST['userid']) ) { chatboxadmin_print_stop_back('User '.$_REQUEST['userid'].' does not exist.'); }
		$userid = $_REQUEST['userid'];
	}
	
	$db->query_write("DELETE FROM ".TABLE_PREFIX.$chatbox_table." WHERE userid = $userid");
	
	print_cp_redirect("chatbox_admin.php?" . $vbulletin->session->vars['sessionurl'] . "&do=delete", 1);
}

# delete messages older than
if ( $_REQUEST['do'] == 'deletedays' ) {
	if (empty($_REQUEST['days'])) {
		chatboxadmin_print_stop_back('Must specify days.');
	}
	if ( !is_numeric($_REQUEST['days']) ) {
		chatboxadmin_print_stop_back('Invalid input.');
	}

	$timestamp = time() - ($_REQUEST['days'] * 86400); //86400 is how many seconds a day has
	
	$db->query_write("DELETE FROM ".TABLE_PREFIX.$chatbox_table." WHERE dateline < $timestamp");
	
	print_cp_redirect("chatbox_admin.php?" . $vbulletin->session->vars['sessionurl'] . "&do=delete", 1);
}

print_cp_footer();


// functions

function chatboxadmin_print_stop_back ($text = 'error') {
	global $vbphrase;
	if (!defined('DONE_CPHEADER')) { print_cp_header($vbphrase['vbulletin_message']); }
	echo '<p>&nbsp;</p><p>&nbsp;</p>';
	print_form_header('', '', 0, 1, 'messageform', '65%');
	print_table_header($vbphrase['vbulletin_message']);
	print_description_row("<blockquote><br />$text<br /><br /></blockquote>");
	print_table_footer(2, construct_button_code($vbphrase['go_back'], 'javascript:history.back(1)'));
	print_cp_footer();
}

function chatboxadmin_username_exists ($username) {
	global $db;
	$exists = $db->query_first("SELECT userid FROM " . TABLE_PREFIX . "user WHERE LOWER(username) = LOWER('".$db->escape_string($username)."')");
	if ($exists) {return $exists['userid'];} else {return false;}
}

function chatboxadmin_user_exists ($userid) {
	global $db;
	$exists = $db->query_first("SELECT userid FROM " . TABLE_PREFIX . "user WHERE userid = $userid");
	if ($exists) {return true;} else {return false;}
}

?>