<?php
// ####################### SET PHP ENVIRONMENT ###########################
error_reporting(E_ALL & ~E_NOTICE);

// #################### DEFINE IMPORTANT CONSTANTS #######################
define('THIS_SCRIPT', 'chatbox');

// ######################### REQUIRE BACK-END ############################
require_once('./global.php');
require_once('./includes/class_bbcode.php');

// ############################ CONFIG VARS ##############################
$perpage = $vbulletin->options['dreamchatbox_perpage']; //shouts to show in a page
$moderator_usergroups = array(); //usergroup ids that can delete shouts
$junks = explode(',', $vbulletin->options['dreamchatbox_mod_usergroups']);
foreach ($junks AS $junk) {
	$moderator_usergroups[] = trim($junk);
}
$cantshout = array(); //usergroup ids that are not allowed to shout
$junks = explode(',', $vbulletin->options['dreamchatbox_cantshout_usergroups']);
foreach ($junks AS $junk) {
	$cantshout[] = trim($junk);
}
$cantview = array(); //usergroup ids that are not allowed to view shouts
$junks = explode(',', $vbulletin->options['dreamchatbox_cantview_usergroups']);
foreach ($junks AS $junk) {
	$cantview[] = trim($junk);
}
$bannedusers = array(); //banned user ids
$junks = explode(',', $vbulletin->options['dreamchatbox_bannedusers']);
foreach ($junks AS $junk) {
	$bannedusers[] = trim($junk);
}
$shoutstable = 'chatbox'; //database table
$pagenav = $vbulletin->options['dreamchatbox_showpages']; //wheter to show pages
$inverse_pagination = $vbulletin->options['dreamchatbox_invert_pages']; //wheter to invert pages, i.e. pages: 5 4 3 2 1, 5 has the last shouts
$autorefresh = $vbulletin->options['dreamchatbox_autorefresh']; //second interval to refresh the chatbox, or 0 to disable
$showtime = $vbulletin->options['dreamchatbox_showtime']; //wheter to show the current time
$maxpagelinks = $vbulletin->options['dreamchatbox_maxpagelinks']; //max page links to show before using  first/last  links
$input_size = $vbulletin->options['dreamchatbox_inputsize']; // size of the text input field
$inputontop = $vbulletin->options['dreamchatbox_inputontop']; // size of the text input field
$showcolornames = $vbulletin->options['dreamchatbox_showcolornames']; // shows linked and colored names
$tagarounduser = $vbulletin->options['dreamchatbox_tagarounduser']; // html tag for usernames
$smiliebutton = $vbulletin->options['dreamchatbox_smiliebutton']; // smilie popup button
$smiliecolumns = $vbulletin->options['dreamchatbox_smiliecolumns']; // smilie popup columns
$enablesmilies = $vbulletin->options['dreamchatbox_enablesmilies']; // enable smilies popup
$smiliepopupwidth = $vbulletin->options['dreamchatbox_smiliepopupwidth'];
$smiliepopupheight = $vbulletin->options['dreamchatbox_smiliepopupheight'];
$smiliepopupx = $vbulletin->options['dreamchatbox_smiliepopupx'];
$smiliepopupy = $vbulletin->options['dreamchatbox_smiliepopupy'];
$candeleteshouts = $vbulletin->options['dreamchatbox_candeleteshouts']; // enable users deleting own shouts
$parseurls = $vbulletin->options['dreamchatbox_parseurls']; // whether to parse urls in messages
$norefreshbutton = $vbulletin->options['dreamchatbox_norefreshbutton']; // whether to show refresh button
$changesmiliebutton = $vbulletin->options['dreamchatbox_changesmiliebutton']; // wheter to make smilies button not an image
$mecode = $vbulletin->options['dreamchatbox_mecode']; // the /me code
$refreshallshouts = $vbulletin->options['dreamchatbox_refreshallshouts']; // whether to only get new shouts or update all shouts
$enablemessagecolor = $vbulletin->options['dreamchatbox_enablecolor'];
$colors = explode("\r\n", $vbulletin->options['dreamchatbox_colors']); // available message colors
$disableguestrefresh = $vbulletin->options['dreamchatbox_disableguestrefresh']; // whether to not refresh for guests

// ############################ PARSE VARS ###############################
$allow_html = $vbulletin->options['dreamchatbox_allowhtml']; //wheter to allow html in shouts
$parse_smilies = $vbulletin->options['dreamchatbox_allowsmilies']; //wheter to parse vB smilies
$parse_bbcode = $vbulletin->options['dreamchatbox_allowbbcode']; //wheter to parse bbcodes
$parse_img = $vbulletin->options['dreamchatbox_allowimg']; //wheter to parse [img][/img] tags

// ############################# TEXT VARS ###############################
$text_send = $vbphrase['chatbox_send'];
$text_refresh = $vbphrase['chatbox_refresh'];
$text_pages = $vbphrase['chatbox_pages'];
$text_lastpage = $vbphrase['chatbox_last'];
$text_firstpage = $vbphrase['chatbox_first'];
$text_cantview = $vbphrase['chatbox_cantview'];
$text_smilies = $vbphrase['chatbox_smilies'];
$text_color = $vbphrase['chatbox_color'];
$text_default = $vbphrase['chatbox_default'];

// ############################# SYSTEM VARS ###############################
$lastshoutid = 0;

// #######################################################################
// ######################## START MAIN SCRIPT ############################
// #######################################################################


// can't view chatbox message
if (in_array($vbulletin->userinfo['usergroupid'], $cantview)) {
?>
<html><head><title>Chatbox</title><?php echo $headinclude; ?></head>
<body class="alt1">
<table border="0" width="100%" height="100%">
	<tr>
		<td align="center" valign="middle"><span class="smallfont"><?php echo $text_cantview; ?></span></td>
	</tr>
</table>
</body></html>
<?php
exit;
}

$secondarygroups = explode(',', $vbulletin->userinfo['membergroupids']);
$ismod = in_array($vbulletin->userinfo['usergroupid'], $moderator_usergroups);
foreach($secondarygroups AS $group) {
	if (!$ismod) {
		$ismod = in_array($group, $moderator_usergroups);
	}
}
$canshout = !in_array($vbulletin->userinfo['usergroupid'], $cantshout);
if ($canshout) {
	$canshout = !in_array($vbulletin->userinfo['userid'], $bannedusers);
}

// show smilie popup
if ($_GET['view'] == 'smilies' AND $enablesmilies AND $canshout) {
	$result = $db->query_read("SELECT * FROM ".TABLE_PREFIX."smilie ORDER BY displayorder ASC");
?>
<html><head><title>Chatbox</title><?php echo $headinclude; ?>
	<script type="text/javascript">
	<!--
	function writeSmilie(smilie) {
		window.opener.document.chatboxForm.elements['shout'].value = window.opener.document.chatboxForm.elements['shout'].value + smilie;
	}
	// -->
	</script>
</head>
<body class="alt1">
<table class="tborder" <?php echo "cellpadding=\"$stylevar[cellpadding]\" cellspacing=\"$stylevar[cellspacing]\""; ?> border="0" width="100%" height="100%">
	<tr><?php
	$i = 0;
	while( $smilie = $db->fetch_array( $result ) ) {
		echo '<td class="alt1" align="center">' . chatbox_make_smilie_link($smilie) . "</td>\n";
		$i++;
		if ($i >= $smiliecolumns) {
			echo "</tr><tr>\n";
			$i = 0;
		}
	}
?>	</tr>
</table>
</body></html>
<?php
exit;
}


// AJAX - get new shouts AND post new shout
if (($_REQUEST['ajax'] == 'getshouts' OR $_REQUEST['ajax'] == 'newshout') AND is_numeric($_REQUEST['lastshoutid'])) {
	if (!is_numeric($_REQUEST['lastshoutid'])) {
		echo 'invalid lastshoutid';
		exit;
	}
	if ($_REQUEST['ajax'] == 'newshout' AND empty($canshout)) {
		echo 'cantshout';
		exit;
	}
	if ($_REQUEST['ajax'] == 'newshout' AND !empty($_REQUEST['shout'])) {
		$color = '';
		if (!empty($_REQUEST['color']) AND $enablemessagecolor) {
			if (in_array($_REQUEST['color'], $colors)) {
				$color = $_REQUEST['color'];
			}
		}
		$shout = convert_urlencoded_unicode($_REQUEST['shout']);
		$db->query_write("INSERT INTO ".TABLE_PREFIX.$shoutstable." (userid, username, shout, dateline, ipaddress, color) 
	VALUES (".$vbulletin->userinfo['userid'].", '".$db->escape_string($vbulletin->userinfo['username'])."', '".$db->escape_string($shout)."', ".TIMENOW.", '".$db->escape_string(IPADDRESS)."', '".$db->escape_string($color)."')");
	}
	if (!empty($showtime)) {
		$date = '[<span class="time">' . vbdate($vbulletin->options['timeformat'], TIMENOW) . '</span>] ';
	}
	
	if ($inputontop) {
		$order = 'DESC';
	} else {
		$order = 'ASC';
	}
	
	if ($showcolornames) {
		$select = 'c.shoutid, c.userid, c.username, c.shout, c.dateline, c.ipaddress, c.color, u.usergroupid, u.displaygroupid';
		$join = ' AS c LEFT JOIN ' . TABLE_PREFIX . 'user AS u ON (c.userid = u.userid)';
	} else {
		$select = '*';
		$join = '';
	}
	
	if ($refreshallshouts) {
		$result = $db->query_read("SELECT $select FROM ".TABLE_PREFIX.$shoutstable."$join ORDER BY dateline ".$order." LIMIT 0, ".$perpage);
	} else {
		$result = $db->query_read("SELECT $select FROM ".TABLE_PREFIX.$shoutstable."$join WHERE shoutid > $_REQUEST[lastshoutid] ORDER BY dateline ".$order);
	}
	
	$response = chatbox_construct_shouts($result);
	
	if (!empty($response)) {
		$response = chatbox_clean_ajax_reply($response);
		$response = "var newshouts = '$response'; lastshoutid = $lastshoutid;";
	} else {
		$response = "var newshouts = '';";
	}
	if (!empty($date)) {
		$response .= " theTime = '$date';";
	}
	echo $response;
	exit;
}


// AJAX - delete shout
if ($_REQUEST['ajax'] == 'delete') {
	if (empty($_REQUEST['shoutid'])) {
		echo 'no id';
		exit;
	}
	if (!is_numeric($_REQUEST['shoutid'])) {
		echo 'invalid shoutid';
		exit;
	}
	$delete = false;
	if (empty($ismod) AND $candeleteshouts) {
		$result = $db->query_first("SELECT userid FROM ".TABLE_PREFIX.$shoutstable." WHERE shoutid = ".$_REQUEST['shoutid']);
		if ($result['userid'] == $vbulletin->userinfo['userid'] AND $vbulletin->userinfo['userid'] != 0) {
			$delete = true;
		}
	}
	if (!empty($ismod)) {
		$delete = true;
	}
	if ($delete) {
		$db->query_write("DELETE FROM ".TABLE_PREFIX.$shoutstable." WHERE shoutid = ".$_REQUEST['shoutid']);
	}
	echo $_REQUEST['shoutid'];
	exit;
}




//////////////////// process variables
// show time
$time = '';
if (!empty($showtime)) {
	$time = '[<span class="time">' . vbdate($vbulletin->options['timeformat'], TIMENOW) . '</span>] ';
	//$date .=  vbdate($vbulletin->options['dateformat'], TIMENOW) . '] ';
}

// page navigation
$limitfrom = 0;
$actualpage = 1;
$pagelinks = '';
if (!empty($pagenav)) {
	$total = $db->query_first("SELECT count(shoutid) AS total FROM ".TABLE_PREFIX.$shoutstable);
	if ($total['total'] > $perpage) {
		$totalpages = ceil($total['total'] / $perpage);
		empty($inverse_pagination) ? $actualpage = 1 : $actualpage=$totalpages;
		if (!empty($_REQUEST['from']) && is_numeric($_REQUEST['from'])) {
			if (empty($inverse_pagination)) {
				$actualpage = ceil($_REQUEST['from'] / $perpage) + 1;
			} else {
				$actualpage = $totalpages - ceil($_REQUEST['from'] / $perpage);
			}
			$limitfrom = $_REQUEST['from'];
		}
		$pagelinks = '<select name="page" onchange="changePage()"><optgroup label="'.$text_pages.'">';
		$i=0;
		empty($inverse_pagination) ? $start=1 : $start=$totalpages;
		empty($inverse_pagination) ? $stop=$totalpages+1 : $stop=0;
		$linkfirst = ''; $linklast = '';
		if (!empty($maxpagelinks) && $totalpages > $maxpagelinks) {
			$maxadjacent = floor($maxpagelinks/2);
			if (empty($inverse_pagination)) {
				if ($actualpage > $maxadjacent + 1) {
					if ($actualpage + $maxadjacent < $totalpages) {
						$start = $actualpage - $maxadjacent;
					} else {
						$start = $totalpages - $maxpagelinks + 1;
					}
					$linkfirst = ' <option value="0">'.$text_firstpage.'</option>';
				}
				if ($actualpage + $maxadjacent < $totalpages) {
					if ($actualpage > $maxadjacent + 1) {
						$stop = $actualpage + $maxadjacent + 1;
					} else {
						$stop = $maxpagelinks + 1;
					}
					$linklast = ' <option value="'.($perpage*($totalpages-1)).'">'.$text_lastpage.'</option>';
				}
				$i=$start-1;
			}
		}
		$pagelinks .= $linkfirst;
		while ($start!=$stop) {
			if ($start != $actualpage) {
				$link = ' <option value="'.($perpage*$i).'">'.$start.'</option>';
			} else {
				$link = ' <option value="'.($perpage*$i).'" selected="selected">'.$start.'</option>';
			}
			$pagelinks .= $link;
			$i++;
			empty($inverse_pagination) ? $start++ : $start--;
		}
		$pagelinks .= $linklast;
		$pagelinks .= '</select>';
	}
}

if ($inputontop) {
	$order = 'DESC';
	$real_limitfrom = $limitfrom;
} else {
	$order = 'ASC';
	$real_limitfrom = $total['total'] - ($perpage * $actualpage);
	if ($real_limitfrom < 0) {
		$real_limitfrom = 0;
	}
}

if ($showcolornames) {
	$select = 'c.shoutid, c.userid, c.username, c.shout, c.dateline, c.ipaddress, c.color, u.usergroupid, u.displaygroupid';
	$join = ' AS c LEFT JOIN ' . TABLE_PREFIX . 'user AS u ON (c.userid = u.userid)';
} else {
	$select = '*';
	$join = '';
}


$result = $db->query_read("SELECT $select FROM ".TABLE_PREFIX.$shoutstable."$join ORDER BY dateline ".$order." LIMIT ".$real_limitfrom.", ".$perpage);


// make smilies popup link
$smilieslink = '';
if ($enablesmilies AND $canshout) {
	if ($changesmiliebutton) {
		$smilieslink = ' <input type="button" name="smilies" value="'.$text_smilies.'" onclick="openSmilies()" class="button">';
	} else {
		$smilieslink = " &nbsp;<a href=\"javascript:openSmilies()\"><img src=\"$smiliebutton\" alt=\"\" border=\"0\" class=\"inlineimg\"></a>";
	}
}

// make refresh button
$refreshbutton = '';
if (!$norefreshbutton) {
	$refreshbutton = ' <input type="button" name="refresh" value="'.$text_refresh.'" onclick="getNewShouts()" class="button">';
}

// make color select box
if ($enablemessagecolor AND $canshout) {
	$colorselect = chatbox_construct_color_select();
} else {
	$colorselect = '<input type="hidden" name="color" value="">';
}


//////////////////// spit page

echo '<html><head><title>Chatbox</title>'.$headinclude;
?>
	<script type="text/javascript">
	<!--
	<?php
	if (empty($limitfrom)) {
		echo 'var limitfrom = "";';
	} else {
		echo 'var limitfrom = "'.$limitfrom.'";';
	} ?>
	
	function getNewShouts() {
		if (actualpage == 1) {
			if (isRefreshing == 0) {
				isRefreshing = 1;
				disableRefreshButton();
				hermes = YAHOO.util.Connect.asyncRequest('GET', 'chatbox.php?ajax=getshouts&lastshoutid=' + lastshoutid, 
				{
					success: processNewShouts,
					failure: function(o) { window.alert('AJAX error, please try again. (HTTP status: ' + o.status + ' / ' + o.statusText + ')'); }
				});
			}
		} else {
			refreshChatbox(0, 1, 1);
		}
	}
	
	function processNewShouts(o) {
		eval(o.responseText);
		updateChatbox(newshouts);
		enableRefreshButton();
		isRefreshing = 0;
	}
	
	function postShout() {
		isRefreshing = 1;
		document.chatboxForm.elements['shout'].disabled = true;
		document.chatboxForm.elements['submit'].disabled = true;
		var newshout = document.chatboxForm.elements['shout'].value;
		newshout = PHP.urlencode(newshout);
		var shoutcolor = PHP.urlencode(document.chatboxForm.elements['color'].value);
		hermes = YAHOO.util.Connect.asyncRequest('GET', 'chatbox.php?ajax=newshout&lastshoutid=' + lastshoutid + '&shout=' + newshout + '&color=' + shoutcolor, 
		{
			success: processPostShout,
			failure: function(o) { window.alert('AJAX error, please try again. (HTTP status: ' + o.status + ' / ' + o.statusText + ')'); }
		});
	}
	
	function processPostShout(o) {
		try {
			eval(o.responseText);
		} catch (e) {
			window.alert('Error: ' + e.description + ' ' + o.responseText);
			return;
		}
		updateChatbox(newshouts);
		isRefreshing = 0;
		document.chatboxForm.elements['shout'].value = '';
		document.chatboxForm.elements['shout'].disabled = false;
		document.chatboxForm.elements['submit'].disabled = false;
		document.chatboxForm.shout.focus();
	}
	
	function updateChatbox(newshouts) {
		if (refreshALL == 0) {
			if (inputontop == 1) {
				shoutsDiv.innerHTML = newshouts + shoutsDiv.innerHTML;
			} else {
				shoutsDiv.innerHTML = shoutsDiv.innerHTML + newshouts;
			}
		} else {
			shoutsDiv.innerHTML = newshouts;
		}
		if (inputontop == 0 && newshouts != '') {
			document.body.scrollTop = document.body.scrollHeight;
		}
		updateTimeNow();
	}
	
	function deleteMessage(shoutid) {
		hermes = YAHOO.util.Connect.asyncRequest('GET', 'chatbox.php?ajax=delete&shoutid=' + shoutid, 
		{
			success: processDeleteMessage,
			failure: function(o) { window.alert('AJAX error, please try again. (HTTP status: ' + o.status + ' / ' + o.statusText + ')'); }
		});
	}
	
	function processDeleteMessage(o) {
		var deletedShout = $('shout' + o.responseText);
		deletedShout.style.display = 'none';
	}
	
	function updateTimeNow() {
		if (showtime == 1) {
			var obj = $('timeNow');
			obj.innerHTML = theTime;
		}
	}
	
	function disableRefreshButton() {
		if (noRefreshButton == 0) {
			document.chatboxForm.elements['refresh'].disabled = true;
		}
	}
	
	function enableRefreshButton() {
		if (noRefreshButton == 0) {
			document.chatboxForm.elements['refresh'].disabled = false;
		}
	}
	
	function refreshChatbox(nofocus, isrefresh, repostshout) {
		if (nofocus == 1) {
			document.chatboxForm.elements['nofocus'].value = 1;
		}
		if (isrefresh == 1) {
			document.chatboxForm.elements['isrefresh'].value = 1;
		}
		if (repostshout == 1) {
			document.chatboxForm.elements['repostshout'].value = 1;
		}
		if (limitfrom != "") {
			document.chatboxForm.elements['from'].value = limitfrom;
		}
		//document.chatboxForm.submit();
		document.location.href = 'chatbox.php';
		return false;
	}
	
	function changePage() {
		from = document.forms[0].page.value;
		document.location.href='<?php echo THIS_SCRIPT; ?>.php?from=' + from;
	}
	
	function openSmilies() {
		thex = Math.round((screen.width / 100) * <?php echo $smiliepopupx;?>);
		they = Math.round((screen.height / 100) * <?php echo $smiliepopupy;?>);
		smilies = window.open('chatbox.php?view=smilies', 'smiliespopup', 'height=<?php echo $smiliepopupheight;?>,width=<?php echo $smiliepopupwidth;?>,directories=no,location=no,menubar=no,resizable=yes,status=no,toolbar=no,scrollbars=yes');
		smilies.moveTo(thex, they);
	}
	// -->
	</script>
<?php
if (!empty($autorefresh) && ($limitfrom == 0 || $limitfrom == '0') && !($disableguestrefresh && $vbulletin->userinfo['userid'] == 0)) {
?>
	<script type="text/javascript">
	<!--
	setInterval("getNewShouts()",<?php echo $autorefresh; ?> * 1000);
	// -->
	</script>
<?php
}
echo '</head><body class="alt1">';

if ($inputontop) {
	chatbox_echo_navigation();
}

echo '<div class="smallfont" id="shoutsDiv" align="left">';
echo chatbox_construct_shouts($result);
echo '</div>';

if (empty($inputontop)) {
	chatbox_echo_navigation();
?>

	<script type="text/javascript">
	<!--
	document.body.scrollTop = document.body.scrollHeight;
	// -->
	</script>
<?php
}

if (empty($_REQUEST['nofocus']) OR !empty($_POST['shout'])) {
?>

	<script type="text/javascript">
	<!--
	if (document.chatboxForm.elements['shout'].disabled == false) {
		document.chatboxForm.shout.focus();
	}
	// -->
	</script>
<?php
}

?>

	<script type="text/javascript">
	<!--
	var lastshoutid = <?php echo $lastshoutid; ?>;
	var inputontop = <?php echo $inputontop; ?>;
	var actualpage = <?php echo $actualpage; ?>;
	var showtime = <?php echo $showtime; ?>;
	var noRefreshButton = <?php echo $norefreshbutton; ?>;
	var refreshALL = "<?php echo $refreshallshouts; ?>";
	
	var hermes;
	var theTime;
	var isRefreshing = 0;
	var shoutsDiv = $('shoutsDiv');
	
	function $() {
		var elements = new Array();
		for (var i = 0; i < arguments.length; i++) {
			var element = arguments[i];
			if (typeof element == 'string')
				element = document.getElementById(element);
			if (arguments.length == 1)
				return element;
			elements.push(element);
		}
		return elements;
	}
	// -->
	</script>
<?php
echo '</body></html>';




function chatbox_echo_navigation() {
	global $time, $input_size, $text_send, $text_refresh, $pagelinks, $canshout, $smilieslink, $_POST, $_REQUEST, $refreshbutton, $colorselect;
	$disabled = ' disabled';
	if ($canshout) {
		$disabled = '';
	}
	$message = '';
	if (!empty($_REQUEST['repostshout'])) {
		$message = htmlentities($_POST['shout']);
	}
	echo "\n\n".'<div class="smallfont" align="left"><form action="javascript:postShout()" name="chatboxForm"><span id="timeNow">'.$time.'</span><input type="hidden" name="nofocus"><input type="hidden" name="isrefresh"><input type="hidden" name="repostshout"><input type="hidden" name="from"><input type="text" name="shout" size="'.$input_size.'" maxlength="255" class="smallfont"'.$disabled.' value="'.$message.'"> <input type="submit" name="submit" value="'.$text_send.'" class="button"'.$disabled.'>'.$refreshbutton.' '.$pagelinks.$colorselect.$smilieslink.'<br /></form></div>'."\n";
}

function chatbox_make_user_link($user) {
	$name = fetch_musername($user);
	return "<a href=\"member.php?u=$user[userid]\" target=\"blank\">$name</a>";
}

function chatbox_make_smilie_link($smilie) {
	return "<a href=\"javascript:writeSmilie('$smilie[smilietext]')\"><img src=\"$smilie[smiliepath]\" alt=\"\" border=\"0\"></a>";
}

function chatbox_parse_urls($shout) {
	$chars = '[-a-zA-Z0-9!#$%&\'*+/=?^_`{|}~.]+';
	return eregi_replace("([^]\"'=]|^)(http://$chars)|([^]\"'=/]|^)(www\\.$chars)", '\\1\\3[url]\\2\\4[/url]', $shout);
}

function chatbox_construct_shouts($query) {
	global $db, $parse_bbcode, $lastshoutid, $vbulletin, $ismod, $candeleteshouts, $parseurls, $showtime, $showcolornames, $_REQUEST, $mecode, $allow_html, $parse_smilies, $parse_img, $enablemessagecolor;
	$newline = "\n";
	if (!empty($_REQUEST['ajax'])) {
		$newline = '';
	}
	$response = '';
	if (!empty($parse_bbcode)) {
		$taglist = fetch_tag_list();
	} else {
		$taglist = array();
	}
	$parser =& new vB_BbCodeParser($vbulletin, $taglist);
	while( $shout = $db->fetch_array( $query ) ) {
		$del = '';
		if (!empty($ismod) OR ( $candeleteshouts AND $vbulletin->userinfo['userid'] == $shout['userid'] AND $shout['userid'] != 0 )) {
			$del = ' <a href="javascript:deleteMessage('.$shout['shoutid'].')">X</a>';
		}
		$parsed = $shout['shout'];
		if ($parseurls) {
			$parsed = chatbox_parse_urls($parsed);
		}
		$parsed = $parser->do_parse($parsed, $allow_html, $parse_smilies, $parse_bbcode, $parse_img, false, false);
		$time = vbdate($vbulletin->options['timeformat'], $shout['dateline']);
		if ($showtime) {
			$time = '<span class="time">' . $time . '</span>';
		}
		// if shout wasn't made today, show day
		if (vbdate('jny', $shout['dateline'], false, false) != vbdate('jny', TIMENOW, false, false)) {
			$time = vbdate($vbulletin->options['dateformat'], $shout['dateline'], true) . ' ' . $time;
		}
		$opentagtime = ''; $closetagtime = '';
		if ($showtime) {
			$time = '[' . $time . '] ';
		} else {
			$opentagtime = '<span title="' . $time . '">';
			$closetagtime = '</span>';
			$time = '';
		}
		$username = $shout['username'];
		if ($showcolornames AND $shout['userid'] != 0) {
			$username = chatbox_make_user_link($shout);
		}
		if ($tagarounduser) {
			$tagopen = "<$tagarounduser>";
			$tagclose = "</$tagarounduser>";
		}
		$coloropen = ''; $colorclose = '';
		if ($enablemessagecolor AND !empty($shout['color'])) {
			$coloropen = '<span style="color: '.$shout['color'].'">';
			$colorclose = '</span>';
		}
		if (!empty($mecode) AND strpos($parsed, "/$mecode ") === 0) {
			$parsed = substr($parsed, strlen("/$mecode "));
			$response .= $newline.'<span id="shout'.$shout['shoutid'].'">'.$time."$coloropen* $opentagtime$username$closetagtime $parsed *$colorclose".$del.'<br /></span>';
		} else {
			$response .= $newline.'<span id="shout'.$shout['shoutid'].'">'.$time.$tagopen.$opentagtime.$username.$closetagtime.$del."$tagclose: $coloropen".$parsed.$colorclose.'<br /></span>';
		}
		if ($shout['shoutid'] > $lastshoutid) {
			$lastshoutid = $shout['shoutid'];
		}
	}
	return $response;
}

function chatbox_construct_color_select() {
	global $colors, $text_color, $text_default;
	$response = ' <select name="color"><optgroup label="'.$text_color.'">';
	$response .= '<option value="">'.$text_default.'</option>';
	foreach ($colors AS $color) {
		$response .= "\n" . ' <option value="'.$color.'" style="color: '.$color.'">'.$color.'</option>';
	}
	$response .= '</select>';
	return $response;
}

function chatbox_clean_ajax_reply($reply) {
	$reply = str_replace('\\', '\\\\', $reply);
	$reply = str_replace("'", "\\'", $reply);
	$reply = str_replace("\r\n", "", $reply);
	$reply = str_replace("\n", "", $reply);
	return $reply;
}
?>