<?php
/* =============================================================== *\
|		Module name:      Functions									|
|																	|
\* =============================================================== */
if (!defined('IN_SITE')){
     die('Hacking attempt!');
}

class Func_Admin extends Func_Global
{
	function Func_Admin(){
		$this->check_gpc();
	}

	//Check user's login status
	function check_login($transfer = 1){
		global $Session, $Template, $Lang, $Info, $DB;

		$login_time		= CURRENT_TIME - $Info->option['time_login'];
		$cookie_time	= CURRENT_TIME - $Info->option['cookie_time'];
		$session_hash	= isset($_COOKIE['session_hash']) ? htmlspecialchars($_COOKIE['session_hash']) : '';

		//Don't check login if it is login module
		if ( $Info->mod == 'idx' ) return false;

		if ( !empty($Session->sid) ){
			//Check Session ID and Session Hash. Require cookie enabled
			$DB->query("SELECT U.*, S.user_groups, S.kicked_by, S.kicked_time FROM ". $DB->prefix ."user AS U, ". $DB->prefix ."session AS S WHERE S.session_id='". $Session->sid ."' AND S.session_hash='". $session_hash ."' AND S.user_id=U.user_id AND ((S.session_time >= $login_time) OR (S.session_time>$cookie_time AND S.auto_login=1))");
			if ( !$DB->num_rows() ){
				//Check Session ID and Client IP. In case client's browser does not support cookie
				$DB->query("SELECT U.*, S.user_groups, S.kicked_by, S.kicked_time FROM ". $DB->prefix ."user AS U, ". $DB->prefix ."session AS S WHERE S.session_id='". $Session->sid ."' AND U.user_ip='". $Session->ip ."' AND S.user_id=U.user_id AND ((S.session_time >= $login_time) OR (S.session_time>$cookie_time AND S.auto_login=1))");
			}

			if ($DB->num_rows()){
				$result = $DB->fetch_array();
				if ($result["user_id"]){
					if ( $result['kicked_time'] > 0){
						if ( $transfer ){
							$Template->page_transfer( sprintf($Lang->data["user_kicked_by"], $result['kicked_by'], $Info->option['kick_minutes']), $Session->append_sid(ACP_INDEX));
						}
						else{
							return false;
						}
					}
					return true;
				}
			}
		}
		$DB->free_result();

		if ( $transfer ){
			$Template->page_transfer($Lang->data["general_error_not_login"], $Session->append_sid(ACP_INDEX));
		}
		return false;
	}

	//Encode js codes
	function encode_js($str){
		$text		= array('/%/','/#/','/&/','/`/','/ /');
		$replace	= array('%25','%23','%26','%60','%20');
		return preg_replace($text, $replace, $str);
	}

	//Decode js codes
	function decode_js($str){
		$text		= array('/%25/','/%23/','/%26/','/%60/','/%20/');
		$replace	= array('%','#','&','`',' ');
		return preg_replace($text, $replace, $str);
	}

	//Remove js codes
	function clean_js($str){
		$text		= array('/%25/','/%23/','/%26/','/%60/','/%20/');
		$replace	= '_';
		return preg_replace($text, $replace, $str);
	}

	//Convert file size
	function compile_size($size){
		if ($size >= 1073741824){
			$size = round($size/1073741824,1). ' Gb';
		}
		else if ($size >= 1048576){
			$size = round($size/1048576,1). ' Mb';
		}
		else if ($size >= 1024){
			$size = round($size/1024,1). ' Kb';
		}
		else{
			$size .= ' bytes';
		}
		return $size;
	}

	//Make specific date time
	//We use constant 20 for checking timezone true or false
	function make_mydate($month, $day, $year, $time, $nowtime, $timezone = 20){
		if ( checkdate($month, $day, $year) ){
			$tmp	= explode(':', $time);
			if ( is_array($tmp) ){
				$hour		= ( isset($tmp[0]) && ($tmp[0]>=0) && ($tmp[0]<=24) ) ? $tmp[0] : 0;
				$minute		= ( isset($tmp[1]) && ($tmp[1]>=0) && ($tmp[1]<=60) ) ? $tmp[1] : 0;
			}
			else{
				$hour		= 0;
				$minute		= 0;
			}
			if ( $timezone != 20 ){
				return gmmktime($hour, $minute, 0, $month, $day, $year) - $timezone*3600;
			}
			else{
				return mktime($hour, $minute, 0, $month, $day, $year);
			}
		}
		return $nowtime;
	}

	function get_all_perms($func_name, $pause = 1){
		global $Info, $DB, $Template, $Lang;

		$perm_info	= array();

		//Check if user is in admin group
		$DB->query('SELECT U.group_id FROM '. $DB->prefix .'user_group AS G, '. $DB->prefix .'user_group_ids AS U WHERE U.group_id=G.group_id AND U.user_id='. $Info->user_info['user_id'] .' AND G.group_level=1');
		if ( $DB->num_rows() ){
			$perm_info['action']['all']		= 1;
			$perm_info['item']['all']		= 1;
			return $perm_info;
		}
		//-------------------------------

		$DB->query('SELECT * FROM '. $DB->prefix .'func WHERE func_name="'. $func_name .'"');
		if ( !$DB->num_rows() ){
			if ( $pause ){
				$Template->message_die($Lang->data['perm_error_not_all']);
			}
			return false;
		}
		$func_info	= $DB->fetch_array();

		//This function allow all actions and all items
		if ( $func_info['func_allow_all'] ){
			$perm_info['action']['all']		= 1;
			$perm_info['item']['all']		= 1;
			return $perm_info;
		}
		//---------------------------------------------

		//Get user groups and actions, items ---------
		$group_info		= explode(',', $Info->user_info['user_groups']);
		$where_sql		= ' WHERE func_code="'. $func_info['func_code'] .'" AND (ugroup_id=0';
		reset($group_info);
		while (list(, $gid) = each($group_info)){
			$where_sql	.= " OR ugroup_id=". intval($gid);
		}
		$where_sql		.= ') AND allow_actions!=""';

		$DB->query('SELECT allow_actions, allow_items FROM '. $DB->prefix .'func_auth '. $where_sql);
		if ( !$DB->num_rows() ){
			if ( $pause ){
				$Template->message_die($Lang->data['perm_error_not_all']);
			}
			return false;
		}

		$allow_actions	= "";
		$allow_items	= "";
		while ($result = $DB->fetch_array()){
			if ( !empty($result['allow_actions']) ){
				$allow_actions	.= !empty($allow_actions) ? ','. $result['allow_actions'] : $result['allow_actions'];
			}
			if ( !empty($result['allow_items']) ){
				$allow_items	.= !empty($allow_items) ? ','. $result['allow_items'] : $result['allow_items'];
			}
		}
		$action_info			= explode(',', $allow_actions);
		$item_info				= explode(',', $allow_items);
		$perm_info['action']	= array_flip(array_unique($action_info));
		$perm_info['item']		= array_flip(array_unique($item_info));
		//------------------------------------------------------------

		return $perm_info;
	}

	//Check user's permissions
	function check_user_perm($perm_info, $act, $pause = 1){
		global $Lang, $Template;

		if ( isset($perm_info['action']['all']) || isset($perm_info['action'][$act]) ){
			return true;
		}

		if ( $pause ){
			$Template->message_die($Lang->data['perm_error_not_'. $act]);
		}
		return false;
	}

	//Log user's actions
	function save_log($func_name, $func_act, $record_ids = '', $url_view = ''){
		global $Session, $DB, $Info;

		if ( !$Info->option['log_save'] ) return false;

		$DB->query("INSERT INTO ". $DB->prefix ."site_log(log_time, user_id, user_ip, func_name, func_action, func_url_view, record_ids) VALUES(". CURRENT_TIME .", ". $Info->user_info['user_id'] .", '". $Session->ip ."', '". $func_name ."', '". $func_act ."', '". $url_view ."', '". $record_ids ."')");
		return true;
	}

	//Delete logged actions
	function del_logs(){
		global $DB, $Info;

		if ( !$Info->option['log_save'] || !$Info->option['log_days'] ) return false;

		$time	= CURRENT_TIME - $Info->option['log_days'] * 86400;
		$DB->query('DELETE FROM '. $DB->prefix .'site_log WHERE log_time<'. $time);
		return true;
	}

	//Update schedules
	function set_update_schedule(){
		global $DB, $Info;

		$DB->query('DELETE FROM '. $DB->prefix .'update_schedule');

		$DB->query('SELECT posted_date FROM '. $DB->prefix .'article WHERE posted_date>'. CURRENT_TIME .' AND enabled='. SYS_ENABLED .' GROUP BY posted_date ORDER BY posted_date ASC');
		$time_count	= $DB->num_rows();
		$time_data	= $DB->fetch_all_array();
		$DB->free_result();

		//Update cache schedule for articles
		for ($i=0; $i<$time_count; $i++){
			$DB->query('INSERT INTO '. $DB->prefix .'update_schedule(update_time) VALUES('. $time_data[$i]['posted_date'] .')');
		}
	}

	//Get page codes and names
	function get_webpage_list($blockname = "webpagerow"){
		global $Template, $DB, $cfg_webpage_list, $Lang;

		reset($cfg_webpage_list);
		while ( list($page_code, $page_name) = each($cfg_webpage_list) ){
			$Template->set_block_vars($blockname, array(
				'CODE'		=> $page_code,
				'NAME'		=> isset($Lang->data[$page_name]) ? $Lang->data[$page_name] : $page_name,
			));
		}
	}

	//Check and get keys from an array
	function get_array_key($data, $type = 'number'){
		$result_info	= array();
		if ( is_array($data) ){
			reset($data);
			while (list($key,) = each($data)){
				$key	= ($type == 'number') ? intval($key) : htmlspecialchars(trim($key));
				if ( $key ){
					$result_info[]	= $key;
				}
			}
		}
		return $result_info;
	}

	//Check and get values from an array
	function get_array_value($data, $type = 'number'){
		$result_info	= array();
		if ( is_array($data) ){
			reset($data);
			while (list(, $val) = each($data)){
				$val	= ($type == 'number') ? intval(trim($val)) : htmlspecialchars(trim($val));
				if ( $val ){
					$result_info[]	= $val;
				}
			}
		}
		return $result_info;
	}

	//Get POST/GET/FILES values
	function get_request($var_name, $default_value = '', $gpc = ''){
		if ( (empty($gpc) || ($gpc == 'POST')) && isset($_POST[$var_name]) ){
			return $_POST[$var_name];
		}
		if ( (empty($gpc) || ($gpc == 'GET')) && isset($_GET[$var_name]) ){
			return $_GET[$var_name];
		}
		if ( (empty($gpc) || ($gpc == 'FILES')) && isset($_FILES[$var_name]['name']) ){
			return $_FILES[$var_name]['name'];
		}
		return $default_value;
	}

	//Create random letters/numbers
	function create_random($limit){
		$chars		= array('a', 'A', 'b', 'B', 'c', 'C', 'd', 'D', 'e', 'E', 'f', 'F', 'g', 'G', 'h', 'H', 'i', 'I', 'j', 'J',  'k', 'K', 'l', 'L', 'm', 'M', 'n', 'N', 'o', 'O', 'p', 'P', 'q', 'Q', 'r', 'R', 's', 'S', 't', 'T',  'u', 'U', 'v', 'V', 'w', 'W', 'x', 'X', 'y', 'Y', 'z', 'Z', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0');
		$max_chars	= sizeof($chars) - 1;
		$str_rand	= "";
		for ($i=0; $i<$limit; $i++){
		    $str_rand	.= $chars[rand(0, $max_chars)];
		}
		return $str_rand;
	}
}
?>