<?php
/* =============================================================== *\
|		Module name:      Home Index								|
\* =============================================================== */

define("IN_SITE", true);
define("IN_INDEX", true);
define("PHP_EX", ".php");
include("constant". PHP_EX);
include("config". PHP_EX);

error_reporting(E_ALL); // This will NOT report uninitialized variables
set_magic_quotes_runtime(0); // Disable magic_quotes_runtime

//Cache -------------------------------------------
include("./includes/cache". PHP_EX);
$Cache				= new Cache;
if ( isset($_REQUEST['no_cache']) && ($_REQUEST['no_cache'] == 'yes') ){
	//Turn off
	$Cache->cache_onoff(0);
}
$Cache->mod_cache	= $cfg_mod_cache;
$Cache->begin_cache();
//-------------------------------------------------

/*
//Executed time begin
//------------------------------
include("./includes/debug". PHP_EX);
$Debug	= new Debug;
$Debug->start_debug();
//------------------------------
*/

//Database
include("./includes/mysql". PHP_EX);
$DB		= new DBSql;

//Setting information
include("./includes/info_home". PHP_EX);
$Info	= new Info;
//$Cache->cache_onoff($Info->option['cache_enabled']);

//Template
include("./includes/template". PHP_EX);
$Info->option['template_path']	= './templates/'. $Info->option['template'];
$Template = new Template($Info->option['template_path']);

//Lang
include("./languages/". $Info->option['language'] ."/lang_main". PHP_EX);
include("./languages/". $Info->option['language'] ."/home/lang_home". PHP_EX);
$Lang	= new Lang_Home;
$Lang->Lang_Global();//Construction

//Set global vars
$Template->set_vars(array(
	'SITE_NAME'				=> $Info->option['site_name'],
	"SCRIPT_NAME"			=> $Info->option['script_name'],
	"TEMPLATE_PATH"			=> $Info->option['template_path'],
));

$Info->check_website_close();

//Functions
include("./includes/functions". PHP_EX);
include("./includes/functions_home". PHP_EX);
$Func	= new Func_Home;

$Info->get_common();

//Run the global file
include("./modules/global". PHP_EX);

//Run the module
$mod_file	= "./modules/". $Info->get_mod() . PHP_EX;
if ( file_exists($mod_file) ){
	include($mod_file);
}
//-----------------------------------------------------

//Ready Template to out put
if ( !empty($Info->tpl_header) ){
	$Template->set_files(array(
		"header"	=> $Info->tpl_header .".tpl",
	));
}
if ( !empty($Info->tpl_main) ){
	$Template->set_files(array(
		"main"	=> $Info->tpl_main .".tpl",
	));
}
if ( !empty($Info->tpl_footer) ){
	$Template->set_files(array(
		"footer"	=> $Info->tpl_footer .".tpl",
	));
}

/*
//Executed time end
//------------------------------
$Debug->end_debug();
//------------------------------

$Template->set_vars(array(
	"EXECUTED_TIME"			=> $Lang->data["stat_time_execute"] . round($Debug->exectime, 4) .'s',
	"USED_QUERIES"			=> $Lang->data["stat_queries_use"]. $DB->query_count,
	"GZIP"					=> ($Info->option['gzip']) ? $Lang->data["stat_gzip_enabled"] : $Lang->data["stat_gzip_disabled"],
	"SCRIPT_CACHING"		=> ($Info->option['cache_enabled']) ? $Lang->data["stat_cache_enabled"] : $Lang->data["stat_cache_disabled"],
));
*/

if ( $Cache->turn_on ){
	//Set cache php
	$Cache->end_cache();
}
else{
	//Close mysql
	$DB->close();
	$Template->show();
}
?>