
#=================== Article =============
DROP TABLE IF EXISTS {PREFIX}_article_category;
CREATE TABLE {PREFIX}_article_category (
  cat_id smallint(5) unsigned NOT NULL auto_increment,
  cat_parent_id smallint(5) unsigned NOT NULL default '0',
  cat_code varchar(32) default NULL,
  cat_name varchar(128) NOT NULL,
  cat_keywords varchar(255) default NULL,
  cat_desc text,
  cat_template varchar(64) NOT NULL,
  cat_order smallint(5) unsigned NOT NULL default '1',
  children_counter smallint(5) unsigned NOT NULL default '0',
  article_counter int(11) unsigned NOT NULL default '0',
  enabled tinyint(1) unsigned NOT NULL default '1',
  redirect_url varchar(255) default NULL,
  index_display tinyint(1) NOT NULL,
  PRIMARY KEY  (cat_id),
  KEY cat_code (cat_code),
  KEY cat_name (cat_name)
);

INSERT INTO {PREFIX}_article_category (cat_id, cat_parent_id, cat_code, cat_name, cat_keywords, cat_desc, cat_template, cat_order, children_counter, article_counter, enabled, redirect_url, index_display) VALUES (3, 0, 'Mashable', 'Mashable', 'Social Networking, Media, News, Blog', 'Mashable! - The #1 Social Networking and Social Media News Blog', 'default', 1, 0, 30, 1, '', 1);
INSERT INTO {PREFIX}_article_category (cat_id, cat_parent_id, cat_code, cat_name, cat_keywords, cat_desc, cat_template, cat_order, children_counter, article_counter, enabled, redirect_url, index_display) VALUES (4, 0, 'Ajaxian', 'Ajaxian', 'Ajaxian, Ajax, Javascript', 'Ajax Resources', 'default', 2, 0, 20, 1, '', 1);

DROP TABLE IF EXISTS {PREFIX}_article;
CREATE TABLE {PREFIX}_article (
  article_id int(11) unsigned NOT NULL auto_increment,
  cat_id smallint(5) unsigned NOT NULL,
  meta_keywords text NOT NULL,
  meta_desc text NOT NULL,
  topic_id int(11) unsigned default NULL,
  thumb_large varchar(64) default NULL,
  thumb_small varchar(64) default NULL,
  thumb_icon varchar(64) default NULL,
  title varchar(255) NOT NULL,
  content_desc text NOT NULL,
  content_url varchar(255) default NULL,
  poster_id int(11) unsigned default NULL,
  checker_id int(11) unsigned default NULL,
  posted_date int(11) unsigned default NULL,
  is_hot tinyint(1) unsigned NOT NULL default '0',
  article_type tinyint(1) unsigned NOT NULL default '0',
  page_counter smallint(5) unsigned NOT NULL default '0',
  enabled tinyint(1) unsigned default NULL,
  archived tinyint(1) NOT NULL,
  rating_marks int(11) default NULL,
  rating_count int(11) default NULL,
  PRIMARY KEY  (article_id),
  KEY cat_id (cat_id),
  FULLTEXT KEY title (title,content_desc)
);
# Article Type:
# 0: Full
# 1: Summary only
# 2: Summary & Link
ALTER TABLE {PREFIX}_article TYPE = MYISAM;
ALTER TABLE {PREFIX}_article ADD FULLTEXT (title, content_desc);

INSERT INTO {PREFIX}_article (article_id, cat_id, meta_keywords, meta_desc, topic_id, thumb_large, thumb_small, thumb_icon, title, content_desc, content_url, poster_id, checker_id, posted_date, is_hot, article_type, page_counter, enabled, archived, rating_marks, rating_count) VALUES (14, 3, '', '', 2, '', '', '', 'Will FriendFeed Forever Be a Niche Service?', '&lt;P&gt;Just to get this out of the way right from the start– I am a big fan of&lt;A title=FriendFeed href=&quot;http://friendfeed.com/&quot; target=_blank&gt;FriendFeed&lt;/A&gt;. It is one of the primary tools I use every day as a blogger. It is a tool that I would sorely miss if it ever went away for whatever reason. That said I don\'t think that FriendFeed as it is now will ever make it past being an excellent niche service and into the eyes of the mainstream Web user.&lt;/P&gt;', 'http://mashable.com/2008/07/21/friendfeed-a-niche-service/', 1, 0, 1216679220, 1, 0, 1, 1, 0, NULL, NULL);
INSERT INTO {PREFIX}_article (article_id, cat_id, meta_keywords, meta_desc, topic_id, thumb_large, thumb_small, thumb_icon, title, content_desc, content_url, poster_id, checker_id, posted_date, is_hot, article_type, page_counter, enabled, archived, rating_marks, rating_count) VALUES (13, 3, '', '', 2, '', '', '', 'Favtape Creates Mixtapes from Your Pandora and Last.fm Accounts', '&lt;P&gt;&lt;A href=&quot;http://favtape.com/&quot; target=_blank&gt;Favtape&lt;/A&gt;is another new mixtape creation site, but its standout feature is its automation process, which creates a mixtape based off songs you\'ve listened to on&lt;A href=&quot;http://www.pandora.com/&quot; target=_blank&gt;Pandora&lt;/A&gt;, or those you\'ve favorited on&lt;A href=&quot;http://www.last.fm/&quot; target=_blank&gt;Last.fm&lt;/A&gt;. Provide Favtape with your Pandora URL or your Last.fm username, and a mixtape will automatically be created for you with a unique URL that can be accessed anytime.&lt;/P&gt;', 'http://mashable.com/2008/07/21/favtape/', 1, 0, 1216682640, 1, 0, 1, 1, 0, NULL, NULL);
INSERT INTO {PREFIX}_article (article_id, cat_id, meta_keywords, meta_desc, topic_id, thumb_large, thumb_small, thumb_icon, title, content_desc, content_url, poster_id, checker_id, posted_date, is_hot, article_type, page_counter, enabled, archived, rating_marks, rating_count) VALUES (12, 3, '', '', 2, '', '', '', 'e-Gold Founders Face Prison for Money Laundering', '&lt;P&gt;&lt;A href=&quot;http://e-gold.com/&quot;&gt;&lt;/A&gt;&lt;/P&gt;\r\n&lt;P&gt;Everyone knows who PayPal is.&amp;nbsp; Do you know who competes against PayPal (and I use this term very loosely, since they dominate the market)? I did a search just a few minutes to see who\'s in business still, and which ones have gone by the wayside. It\'s a volatile market - very few companies that start up in that space are reputable, or if they are they aren\'t well funded enough to stay in business until they gain traction.&lt;/P&gt;', 'http://mashable.com/2008/07/21/e-gold/', 1, 0, 1216693680, 1, 0, 1, 1, 0, NULL, NULL);
INSERT INTO {PREFIX}_article (article_id, cat_id, meta_keywords, meta_desc, topic_id, thumb_large, thumb_small, thumb_icon, title, content_desc, content_url, poster_id, checker_id, posted_date, is_hot, article_type, page_counter, enabled, archived, rating_marks, rating_count) VALUES (15, 3, '', '', 2, '', '', '', 'Facebook Updates Platform Policies and Issues Ultimatum to Developers', '&lt;IMG alt=&quot;&quot; align=left src=&quot;http://www.mashable.com/images/facebooklogofresh.PNG&quot;&gt; \r\n&lt;P&gt;Fresh on the heels of rolling out the public beta for its&lt;A href=&quot;http://mashable.com/2008/07/20/new-facebook-launches/&quot;&gt;newly designed homepage and user profiles&lt;/A&gt;, Facebook has issued a new set of policies for application developers, many of which are related specifically to the site changes.&lt;/P&gt;', 'http://mashable.com/2008/07/21/facebook-platform-policies/', 1, 0, 1216675260, 0, 0, 1, 1, 0, NULL, NULL);
INSERT INTO {PREFIX}_article (article_id, cat_id, meta_keywords, meta_desc, topic_id, thumb_large, thumb_small, thumb_icon, title, content_desc, content_url, poster_id, checker_id, posted_date, is_hot, article_type, page_counter, enabled, archived, rating_marks, rating_count) VALUES (16, 3, '', '', 2, '', '', '', 'Will the iPhone Kill Radio? Will Qik Kill the Competition? (video)', '&lt;P&gt;Can a phone kill an industry? What\'s Qik offering, now that they\'re in public beta? These are the questions we tackle on today\'s Mashable Conversations.&amp;nbsp; Sean and I were both intrigued by the fervor and discussion generated around my recent editorial on whether I thought the&lt;A href=&quot;http://mashable.com/2008/07/14/iphone-radio/&quot; target=_self&gt;iPhone would kill terrestrial radio&lt;/A&gt;. The response to the article was thunderous and inconclusive.&amp;nbsp; Just as many folks thought that I was right as thought that terrestrial radio has done a decent enough job of killing itself.&lt;/P&gt;\r\n&lt;P&gt;It\'s a popular topic, too.&amp;nbsp; This weekend\'s Elite Tech News show focused on this topic as well for a good portion of the program, and most of the panel disagreed with me on my hypothesis, though for a number of reasons ranging from&lt;A href=&quot;http://louisgray.com/&quot; target=_blank&gt;Louis Gray&lt;/A&gt;\'s opinion that no technology ever truly kills another to&lt;A href=&quot;http://winextra.com/&quot; target=_blank&gt;Steven Hodson&lt;/A&gt;\'s proposition that mobile smartphone technology will never be truly ubiquitous.&lt;/P&gt;\r\n&lt;P&gt;Sean and I spend a good deal of time hashing out the various thesii put forth here and there before taking some time out to speak with Qik co-founder Bhaskar Roy about today\'s launch of Qik into open beta status.&lt;/P&gt;\r\n&lt;P&gt;He told us about a number of new upgrades that come out with this version of the service, including what was most exciting to us, a number of new distribution partners.&amp;nbsp; As we\'ve talked about before, CoverItLive now supports Qik (amongst a number of other live streaming ser', 'http://mashable.com/2008/07/21/iphone-qik/', 1, 0, 1216672860, 1, 0, 1, 1, 0, NULL, NULL);
INSERT INTO {PREFIX}_article (article_id, cat_id, meta_keywords, meta_desc, topic_id, thumb_large, thumb_small, thumb_icon, title, content_desc, content_url, poster_id, checker_id, posted_date, is_hot, article_type, page_counter, enabled, archived, rating_marks, rating_count) VALUES (17, 3, '', '', 2, '', '', '', 'Ori Brafman, Co-Author of \'Sway\' Live Q&A Tuesday at 2pm PDT', '<p>Tomorrow, Tuesday, July 22 at 2:00PM PDT (5:00PM EDT),<a href="http://mashable.com/authors-at-mashable/ori-rom-brafman-sway">Ori Brafman</a>, co-author of Sway, will be chatting live with Authors@Mashable on<a href="http://live.yahoo.com/mashable" target="_blank">Mashable&#8217;s Y! Live channel</a>.</p><p>This is the third installment of our Sway three part series. If you missed the first two be sure to check out Brafman&#8217;s<a href="http://mashable.com/2008/07/15/ori-brafman-introduction-sway/">personal introduction</a>and post on<a href="http://mashable.com/2008/07/18/exploring-vc-irrationality/">VC Irrationality</a>.</p><p>Anyone who has not yet read Sway, can check out the<a href="http://www.docstoc.com/docs/916375/Sway-extract">first chapter for free</a>or purchase it online<a href="http://www.amazon.com/Sway-Irresistible-Pull-Irrational-Behavior/dp/0385524382/">here</a>.</p><p>*The video will be broadcast live on Mashable, but you must log into<a href="http://live.yahoo.com/mashable" target="_blank">Mashable&#8217;s Y! Live Channel</a>to chat with Ori and Rom Brafman.</p><p>---Related Articles at Mashable! - The Social Networking Blog:<a href="http://mashable.com/2008/07/09/authors-at-mashable-series/">New Series: Authors @ Mashable [50 Book Giveaway]</a><a href="http://mashable.com/2007/06/21/cyworld-live-chat/">Cyworld Launches Live Chat</a><a href="http://mashable.com/authors-at-mashable/">Authors at Mashable</a><a href="http://mashable.com/2007/12/31/mozilla-live-chat-support/">Mozilla Adds Live Chat Support: Eroding Microsoft&#8217;s Stronghold?</a><a href="http://mashable.com/2008/07/18/exploring-vc-irrationality/">Exploring VC Irrationality [Authors @ Mashable]</a><a href="http://mashable.com/2007/03/26/ivillage-chat/">iVillage Does More Social Stuff - Adds Live Chat</a><a href="http://mashable.com/2007/04/09/xbox-messenger/">Windows Live Messenger Arrives on XBox</a></p><img src="http://mashable.com/wp-content/uploads/2008/07/ylive-sway-brafman.jpg" alt="" />', 'http://mashable.com/2008/07/21/sway-live-chat/', 1, 0, 1216672749, 0, 0, 1, 1, 0, NULL, NULL);
INSERT INTO {PREFIX}_article (article_id, cat_id, meta_keywords, meta_desc, topic_id, thumb_large, thumb_small, thumb_icon, title, content_desc, content_url, poster_id, checker_id, posted_date, is_hot, article_type, page_counter, enabled, archived, rating_marks, rating_count) VALUES (18, 3, '', '', 2, '', '', '', 'Docoloco Simplifies Location-Based Recommendations (The Startup Review)', '<p>Editor&#8217;s Note: This post is part of an ongoing series at Mashable - The Startup Review, Sponsored by Sun Microsystems Startup Essentials. If you would like to have your startup considered for inclusion, please see the details<a href="http://mashable.com/startup-review-sponsored-sun-startup-essentials/">here</a>.</p><p>STARTUP DETAILS:</p><p>Company Name:<a href="http://www.docoloco.com/" target="_blank">Docoloco</a></p><p>20 word description:   Recommendation lists written by friends and', 'http://mashable.com/2008/07/21/docoloco/', 1, 0, 1216670557, 0, 0, 1, 1, 0, NULL, NULL);
INSERT INTO {PREFIX}_article (article_id, cat_id, meta_keywords, meta_desc, topic_id, thumb_large, thumb_small, thumb_icon, title, content_desc, content_url, poster_id, checker_id, posted_date, is_hot, article_type, page_counter, enabled, archived, rating_marks, rating_count) VALUES (19, 3, '', '', 2, '', '', '', 'Web Directions Hits Sydney in September', '<p>Returning to Sydney Australia in September for the 5th year,<a href="http://south08.webdirections.org/" rel="nofollow">Web Directions South&#8216;08</a>once again features a two day conference of leading international and local experts in web design and development, two days of in depth workshops, parties, receptions and other networking events. Featured speakers this year include</p><p>Speakers include Jeffrey Veen, Derek Featherstone, Daniel Burka, Douglas Crockford,  Jeff Croft, and Lynne D Johnson, who will cover front and back end web development, web app security, web design, interaction design, and much more.</p><p>Come and join fellow web professionals from all over Australia and all over the world in Sydney.  The conference and expo will be held on September 25th and 26th at the Sydney Convention Centre, Darling Harbour Parkside.  There will be relevant workshops on September 23rd and 24th at the PowerHouse Museum.</p><p>Mashable readers will receive a further $50 off the already great value price, making it just $795 before July 23rd. Just use the code WDS08-Mash when registering.</p><p>---Related Articles at Mashable! - The Social Networking Blog:<a href="http://mashable.com/2008/03/24/south-park-free-episodes/">Watch All South Park Episodes Online for Free</a><a href="http://mashable.com/2008/01/03/askcom-voice-directions/">Ask.com&#8217;s Answer to GOO411? Voice-Activated Directions.</a><a href="http://mashable.com/2007/10/04/live-search-maps/">Live Search Maps to Introduce New Features</a><a href="http://mashable.com/2007/06/03/google-directions-api/">Google Launches Directions API</a><a href="http://mashable.com/2008/04/09/south-park-viral-videos/">Viral Videos Go Berserk, South Park Style!</a><a href="http://mashable.com/2008/02/20/free411-driving-directions/">FREE411 Now Has Voice-Activated Driving Directions</a><a href="http://mashable.com/2007/11/29/mtv-to-give-south-park-episodes-for-free/">MTV To Give South Park Episodes For Free</a></p><img src="http://mashable.com/wp-content/uploads/2008/07/webdirections.jpg" alt="" />', 'http://mashable.com/2008/07/21/web-directions-south-08/', 1, 0, 1216659724, 0, 0, 1, 1, 0, NULL, NULL);
INSERT INTO {PREFIX}_article (article_id, cat_id, meta_keywords, meta_desc, topic_id, thumb_large, thumb_small, thumb_icon, title, content_desc, content_url, poster_id, checker_id, posted_date, is_hot, article_type, page_counter, enabled, archived, rating_marks, rating_count) VALUES (20, 3, '', '', 0, '', '', '', 'Is Internet Radio on its Last Legs?', '<p>Choosing a radio station was once a right of passage for the American adolescence.  It was what bound you to your friends, disassociated you from your parents and attracted to you whatever partner had the misfortune to have you. Regional in range, determined by frequency, traditional radio was completely national in scope, cities to suburbs, Natick to Nashville.  And then, like with the overnight successes the medium helped popularize, everything seemed to decline.</p><p>Traditional radio has been in a steady fall for nearly a decade. While it still remains a 21 billion dollar industry, the time spent listening to radio has fallen somewhere to the tune of 8 percent since 2000, according to<a href="http://www.arbitron.com/home/content.stm" target="_blank">Arbitron</a>, a firm that measure radio audiences. This steady drop in listenership has forced terrestrial radio stations to program music that can appeal to the broadest of audiences, disenfranchising both music fans and emerging artists, and helping to foster the growth of satellite and Internet radio.</p><p>&#8220;Internet radio has redrawn the whole radio landscape,&#8221; said Tim Westergren, a founder of<a href="http://pandora.com/" target="_blank">Pandora</a>, a leading Internet radio company.&#8220;It provides a more fulfilling radio experience and a mass promotion for artists being shut out of terrestrial radio.&#8221;</p><p>The metrics are in agreement with Westergren, Internet radio captures 33 million listeners per week, according to Arbitron, and nearly 15 % of 18 to 49 year olds tune in to Internet radio on a weekly basis. Internet radio companies, such as Pandora,<a href="http://mashable.com/2008/07/13/lastfm-iphone/">Last.fm</a>and<a href="http://www.slacker.com/" target="_blank">Slacker</a>offer a personalized radio experience which gives its listeners ', 'http://mashable.com/2008/07/21/internet-radio/', 1, 0, 1216657204, 0, 0, 1, 1, 0, NULL, NULL);
INSERT INTO {PREFIX}_article (article_id, cat_id, meta_keywords, meta_desc, topic_id, thumb_large, thumb_small, thumb_icon, title, content_desc, content_url, poster_id, checker_id, posted_date, is_hot, article_type, page_counter, enabled, archived, rating_marks, rating_count) VALUES (21, 3, '', '', 0, '', '', '', 'GoDaddy on .ME: \'The Most Successful New Domain Launch in History\'', '<p>Talk about bravado.  Four days after launching the .me domain extension and inciting a virtual riot among customers,<a href="http://www.godaddy.com" target="_blank">GoDaddy</a>is toting the success of what it calls“the most successful new domain launch in GoDaddy\'s history.”  The basis for that claim?  More than 20,000 .Me domain names were registered in the first 24 hours of availability, according to the company.</p><p>As we reported last week, the<a href="http://mashable.com/2008/07/17/godaddy-offers-me-domain-names-it%e2%80%99s-a-big-fail-so-far/comment-page-4/#comments">.Me launch was riddled with technical problems</a>, including as many of 8 or 9 people claiming to hold receipts for the domain name Aweso.me.   To its credit, GoDaddy responded quickly to the problems, issuing refunds to effected customers and making personal phone calls to many of them (a voicemail from a GoDaddy rep left with<a href="http://www.marketingpilgrim.com" target="_blank">Andy Beal</a>can be heard<a href="http://www.grandcentral.com/forwarded_messages/?unique_key=3b2355db0750099a22cdb972f0a702b3&#038;mhash=a071ad3dfe894ba8dc1cb9847cd3b053" target="_blank">here</a>).  But that has done little to qualm the anger of many of those that thought they were the new owner of potentially lucrative .Me names.</p><p>In a press release this morning, the company acknowledges the technical issues they encountered upon launch, but actually uses the“it\'s a nice problem to have” cliché, with CEO Bob Parsons stating “In spite of a few early difficulties - GoDaddy.com successfully processed a huge, record-setting level of registrations.  To the best of our knowledge, there have never been more registrations handled in one day during theordinary course of businesses by any registrar in history.&#8221;</p><p>Realistically, I don\'t think there is that much GoDaddy could have done to prevent the issues it encountered as domain speculators raced to buy up premium .Me domains upon launch.  However, given the frustration and confusion caused on launch day, I think the celebration dance would\'ve best been kept internal.</p><p><a class="tradevibes_show_widget" href="http://www.tradevibes.com/company/profile/go-daddy">Go Daddy</a>company profile provided by<a class="tradevibes_home" href="http://www.tradevibes.com/">TradeVibes</a></p><p>---Related Articles at Mashable! - The Social Networking Blog:<a href="http://mashable.com/2007/11/13/godaddy-google/">GoDaddy Integrating Google Webmaster Tools</a><a href="http://mashable.com/2008/03/12/godaddy-poll/">The Daily Poll: What Do You Think of GoDaddy?</a><a href="http://mashable.com/2008/07/17/godaddy-offers-me-domain-names-it%e2%80%99s-a-big-fail-so-far/">GoDaddy Offers .Me Domain Names.  It\'s a Big .Fail So Far.</a><a href="http://mashable.com/2008/03/11/ratemycop-shutdown/">GoDaddy Pulls the Plug on RateMyCop</a><a href="http://mashable.com/2007/01/25/myspace-godaddy/">Who Sucks More - GoDaddy or MySpace?</a><a href="http://mashable.com/2008/03/14/ratemycop-rackspace-censorship/">RackSpace Censorship: The RateMyCop Saga Continues</a><a href="http://mashable.com/2008/03/12/godaddy-revolt/">GoDaddy: You Don&#8217;t Like Them. Can They Redeem Themselves?</a></p><img src="http://mashable.com/wp-content/uploads/2008/03/godaddy.gif" alt="" />', 'http://mashable.com/2008/07/21/godaddy-dotme-launch/', 1, 0, 1216654344, 0, 0, 1, 1, 0, NULL, NULL);
INSERT INTO {PREFIX}_article (article_id, cat_id, meta_keywords, meta_desc, topic_id, thumb_large, thumb_small, thumb_icon, title, content_desc, content_url, poster_id, checker_id, posted_date, is_hot, article_type, page_counter, enabled, archived, rating_marks, rating_count) VALUES (22, 3, '', '', 0, '', '', '', 'The Dark Knight: 25 Sites to Expand Your Batman Knowledge', '<p>In 1939, Bob Kane created&#8220;The Bat-Man&#8221; for issue #27 of Detective Comics, and as they say, the rest is history. This past weekend the highly anticipated film The Dark Knight was released in theaters, setting a record for biggest three-day take with $155.3M in tickets sold. To celebrate we&#8217;ve rounded up 25 sites where you can learn more about the Batman series and its characters.</p><p>Below you can find showtimes and buy tickets to the film, read about how the movie was made, explore close to 70 years of Batman&#8217;s history, and more.</p><p>Fan Sites</p><p><a href="http://batman-dark-knight.moviechronicles.com/" target="_blank">Batman-Dark-Knight.MovieChronicles.com</a>- An unofficial site following all the news related to the hot film&#8217;s release.</p><p><a href="http://www.batman-on-film.com/" target="_blank">Batman-on-Film.com</a>- For ten years, Batman-on-Film has covered all Batman film related projects as well as reviews of the comics.</p><p><a href="http://www.batmanfanfilms.com/" target="_blank">BatmanFanFilms.com</a>- A large collection of fan films based on the Caped Crusader with some being of amazingly high quality.</p><p><a href="http://www.batmanytb.com" target="_blank">BatmanYTB.com</a>- Batman Yesterday, Today&amp; Beyond gives you a history of Batman as well as information on collectibles, television shows, films and more.</p><p><a href="http://www.comicvine.com/batman/29-1699/" target="_blank">ComicVine.com</a>- ComicVine has a very detailed history of Batman comics, movies, television appearances and even touches on the 1950&#8217;s book, Seduction of the Innocent, which caused many to question Batman&#8217;s sexuality.</p><p><a href="http://en.dcdatabaseproject.com/Batman_(Bruce_Wayne)" target="_blank">DCDatabaseProject.com</a>- Part of the Wikia network, this wiki aims to index all of the DC Universe, but has lots of information on Batman.</p><p><a href="http://www.goldenagebatman.com/" target="_blank">GoldenAgeBatman.com</a>- A site dedicated to the Batman comics of the 1940&#8217;s, 50&#8217;s and 60&#8217;s.</p><p><a href="http://legionsofgotham.proboards70.com/index.cgi?board=bringonthebatman" target="_blank">Legions Of Gotham</a>- A large message forum dedicated to discussing every aspect of the Batman universe.</p><p>News</p><p><a href="http://www.aintitcool.com/" target="_blank">AintItCool.com</a>- Well known site for film gossip of all kinds.</p><p><a href="http://chud.com/articles/" target="_blank">Chud.com</a>- Short for&#8220;Cinematic Happenings Under Development&#8221;, CHUD is also the name of a 1980&#8217;s horror film, but this site is all about movie rumors and new', 'http://mashable.com/2008/07/21/the-dark-knight-batman-movie/', 1, 0, 1216652564, 0, 0, 1, 1, 0, NULL, NULL);
INSERT INTO {PREFIX}_article (article_id, cat_id, meta_keywords, meta_desc, topic_id, thumb_large, thumb_small, thumb_icon, title, content_desc, content_url, poster_id, checker_id, posted_date, is_hot, article_type, page_counter, enabled, archived, rating_marks, rating_count) VALUES (23, 3, '', '', 0, '', '', '', 'A Conversation with Widget Provider Outbrain (Israel Media Tour)', '<p>Company:<a href="http://www.outbrain.com/" target="_blank">Outbrain</a></p><p>Founded: 2006</p><p>Located: Netanya</p><p>I had the opportunity to meet with John LoGioco, VP of Business Development at Outbrain, the free service that offers bloggers and publishers a ratings widget that can be used by visitors of their sites to rate their content. The service, which serves as a recommendation engine for readers allowing them to discover new content they might like based on the ratings they give, recently announced an<a href="http://mashable.com/2008/07/10/outbrain-reports/">analytics dashboard</a>for bloggers and site publishers.  Outbrain is signaling a trend towards offering higher quality, more personalized Web content based on reader response and giving readers more power over the content they are viewing.</p><p>In our interview below, I speak with John about Outbrain&#8217;s philosophy and goals.</p><p><a rel="nofollow" href="http://www.blonde2dot0.com/" target="_blank"></a>Ayelet Noff, also known as blogger<a rel="nofollow" href="http://www.blonde2dot0.com/" target="_blank">Blonde 2.0</a>,  is a social marketing strategist and consultant who has been an influential force in the Israeli tech scene for many years. Noff specializes in helping companies strategically market their brands online.</p><p>[Disclosure: Outbrain is a past sponsor of Mashable events]</p><p>---Related Articles at Mashable! - The Social Networking Blog:', 'http://mashable.com/2008/07/21/mashables-guide-to-conferences/', 1, 0, 1216650594, 0, 0, 1, 1, 0, NULL, NULL);
INSERT INTO {PREFIX}_article (article_id, cat_id, meta_keywords, meta_desc, topic_id, thumb_large, thumb_small, thumb_icon, title, content_desc, content_url, poster_id, checker_id, posted_date, is_hot, article_type, page_counter, enabled, archived, rating_marks, rating_count) VALUES (25, 3, '', '', 0, '', '', '', 'AdBrite Launches Behavioral Targetting Network', '<p><a href="http://www.adbrite.com/" target="_blank">AdBrite</a>announced it will use its large online advertising marketplace (70,000 active websites) to unveil a new behavioral targeting product, currently available as invite-only to a select group of advertisers.</p><p>The new service allows advertisers to display ads to users based on their interests and habits, and however freakish this may seem to some users, we all know that it works well in practice. There are 14 major interest categories which are subdivided to over 3000 subcategories; these include Automotive, Business&#038; Finance, Careers, Consumer Electronics, Dating&#038; Singles, Health, Music, and Travel.</p><p>Prices for the behaviorally targeted ad inventory are determined through a real-time auction, and advertisers are able to view detailed reports on the performance of each subcategory, thus enabling them to precisely adjust bids and placements of their ads.</p><p>There is some serious competition in this field; one company that comes to mind is<a href="http://mashable.com/2007/11/01/exelate-the-behavioral-data-marketplace-raises-4-million/">eXelate</a>, which was funded with $4 million in 2007; also, pretty much every big player has its own behavioral ad network in stock already. AdBrite hopes to leverage its large inventory to draw advertisers; as Ignacio Fanlo, AdBrite CEO puts it,“AdBrite\'s mix of high-reach publisher brands and engaging specialty content sites is an unbeatable combination for advertisers and publishers alike.”</p><p><a class="tradevibes_show_widget" href="http://www.tradevibes.com/company/profile/adbrite">AdBrite</a>company profile provided by<a class="tradevibes_home" href="http://www.tradevibes.com/">TradeVibes</a></p><p>---Related Articles at Mashable! - The Social Networking Blog:<a href="http://mashable.com/2008/04/10/adbrite-otx/">AdBrite Opens Platform, So You Can Play with Targeting Ads</a><a href="http://mashable.com/2007/11/29/adbrite-funding/">Big Money for AdBrite: $23 Million from Sequoia and Others</a><a href="http://mashable.com/2007/10/14/adbrite-full-page-ads/">AdBrite Now Offers Full Page Ads</a><a href="http://mashable.com/2008/04/13/widgetbucks-2/">Widgetbuck&#8217;s Makes comScore&#8217;s List, Launches Hybrid Widget</a><a href="http://mashable.com/2007/10/30/adbrite-serves-ads-for-facebook-apps/">AdBrite Serves Ads For Facebook Apps</a><a href="http://mashable.com/2008/05/08/adbrite-seeks-more-clients-with-tailored-music-ads/">AdBrite Seeks More Clients, with Tailored Music Ads</a><a href="http://mashable.com/2008/02/18/uk-isps-behavioral-ad-networks-phorm/">British ISPs to Delve into Behavioral Ads, Too</a></p><img src="http://mashable.com/wp-content/uploads/2007/10/brite.png" alt="" />', 'http://mashable.com/2008/07/21/adbrite-behavioral-targetting-network/', 1, 0, 1216645225, 0, 0, 1, 1, 0, NULL, NULL);
INSERT INTO {PREFIX}_article (article_id, cat_id, meta_keywords, meta_desc, topic_id, thumb_large, thumb_small, thumb_icon, title, content_desc, content_url, poster_id, checker_id, posted_date, is_hot, article_type, page_counter, enabled, archived, rating_marks, rating_count) VALUES (26, 3, '', '', 0, '', '', '', 'Icahn Settles For Three Seats on Yahoo\'s Board', '<p>Yahoo! reached an agreement with Carl Icahn: eight members of Yahoo&#8217;s current board of directors will stand for re-election; the board will be expanded to 11 members, Icahn will take one, and the other two will be chosen based on his recommendation.</p><p>Yahoo! co-founder and CEO Jerry Yang said this of the agreement:</p><p>“This agreement will not only allow Yahoo! to put the distraction of the proxy contest behind us, it will allow the Company to continue pursuing its strategy of being the starting point for Internet users and a must buy for advertiser.”</p><p>Icahn&#8217;s statement is more revealing:“I am very pleased that this settlement will allow me to work in partnership with Yahoo!\'s Board and management team to help the Company achieve its full potential. While I continue to believe that the sale of the whole Company or the sale of its Search business in the right transaction must begiven full consideration, I share the view that Yahoo!\'s valuable collection of assets positions it well to continue expanding its online leadership and enhancing returns to stockholders.”</p><p>Bascially, Icahn backed down in exchange for three seats on the board; and will not be pushing for the sale of Yahoo or its search business&#8230;for a while. Does it mean that the Microhoo soap opera is finally at an end? Far from it: this is just one little (costly) victory for Yahoo. If there is a clear&#8220;winner&#8221; in this story when the dust settles in the end, I bet it will be a Pyrrhic victory.</p><p>Read the official statement by Yahoo<a href="http://finance.paidcontent.org/paidcontent?GUID=6060882&#038;Page=MediaViewer&#038;Ticker=YHOO">here</a>.</p><p>---Related Articles at Mashable! - The Social Networking Blog:<a href="http://mashable.com/2008/05/14/yahoo-carl-icahn/">The Microsoft-Yahoo Dream/Nightmare Lives On: Billionaire Icahn Makes a Move</a><a href="http://mashable.com/2008/05/16/pushed-by-icahn-yahoo-jumps-back-into-ad-deal-with-google/">Pushed By Icahn, Yahoo Jumps Back Into Ad Deal With Google?</a><a href="http://mashable.com/2008/05/23/yahoo-board-member-leaves-first-signs-of-disintegration/">Yahoo Board Member Leaves; First Sign Of Disintegration?</a><a href="http://mashable.com/2008/05/15/yahoo-responds-to-icahn/">More Love Notes: Yahoo Responds to Icahn&#8217;s Master Plan</a><a href="http://mashable.com/2008/05/18/yahoo-responds-to-microsoft-alternative/">@Yahoo is Twittering: @Microsoft: Sure, We\'ll Consider an Alternative</a><a href="http://mashable.com/2008/06/04/icahn-yang-yahoo/">Icahn Wants Yang Fired, Microsoft Chuckles Evilly</a><a href="http://mashable.com/2008/05/17/yahoo-shareholder-suit/">Yahoo Shareholders Claim Company Is Concealing Critical Documents</a></p><img src="http://mashable.com/wp-content/uploads/2008/05/icahn.gif" alt="" />', 'http://mashable.com/2008/07/21/icahn-three-seats-yahoo-board/', 1, 0, 1216642246, 0, 0, 1, 1, 0, NULL, NULL);
INSERT INTO {PREFIX}_article (article_id, cat_id, meta_keywords, meta_desc, topic_id, thumb_large, thumb_small, thumb_icon, title, content_desc, content_url, poster_id, checker_id, posted_date, is_hot, article_type, page_counter, enabled, archived, rating_marks, rating_count) VALUES (27, 3, '', '', 0, '', '', '', 'Jajah Now Comes with a Personal Assistant', '<p><a href="http://www.jajah.com/" target="_blank">Jajah</a>, which has been on the fast track to expansion by way of several partnerships, has just teamed up with<a href="http://www.pageonce.com/" target="_blank">Pageonce</a>&#8217;s Personal Internet Assistant service so users can keep track of their Jajah activity at any time.  This comes with additional alerts from Pageonce for account updates like a low balance or other changes that have occurred to their account.  As with all other service partnerships included in Pageonce, the Jajah account access and alerts are free.</p><p>This is different than most Jajah partnerships you hear about, as most announcements regarding Jajah integration involve the ability to make VoIP calls within a particular social network.  But the remote access to your Jajah account activity through Pageonce is an important  partnership as well.   As I<a href="http://mashable.com/2008/06/02/pageonc/">mentioned</a>in previous coverage of Pageonce, through its virtual service you can access your various accounts securely, without having to log in, once your account has been confirmed.</p><p>We&#8217;ve seen several developments moving towards just this type of a partnership, with advances from Pageonce, LiquidTalk, SkyDeck, Chase and also Jajah, to name a few.  So I&#8217;m not surprised to see Jajah make your account activity available through the Pageonce Personal Internet Assistant program, and extend it to all their users.  Not only are more companies making their content accessible remotely through plug-ins and third-party services, but others like Pageonce are turning this into a highly personalized service that aggregates nearly everything in your life, from your cable service account information to your checking account balance, your Netflix queue to your airline mileage points.</p><p>Pageonce is one of the most comprehensive tool of its kind that I&#8217;ve used so far, and the company has worked hard to make as many services as possible available directly through its service.  I think the next major step for this particular space is continued growth through user and B2B adoption, and we&#8217;ll likely see some indirect recommendations as a result, on a very personalized level.</p><p>As services like Pageonce become a platform for centralized custom content, we&#8217;ll also likely see some indirect marketing from third party services come about, as services find that Pageonce has the potential to become yet another way in which they can reach out to consumers, as well as an integrated service that can be offered as a perk for their existing customers.  The beauty of it is that it works across a myriad of services and industries, even those outside of the Web-based service realm.</p><p>---Related Articles at Mashable! - The Social Netwo', 'http://mashable.com/2008/07/21/jajah-pageonce/', 1, 0, 1216641835, 0, 0, 1, 1, 0, NULL, NULL);
INSERT INTO {PREFIX}_article (article_id, cat_id, meta_keywords, meta_desc, topic_id, thumb_large, thumb_small, thumb_icon, title, content_desc, content_url, poster_id, checker_id, posted_date, is_hot, article_type, page_counter, enabled, archived, rating_marks, rating_count) VALUES (28, 3, '', '', 0, '', '', '', 'How To Make Your Users Hate You', '<p>I loathe<a href="http://www.mtv.com/">MTV</a>. It&#8217;s not because they&#8217;ve gone from music television to let&#8217;s-hypnotize-teens-and-turn-them-into-some-sort-of-zombie-army television (they have), and it&#8217;s not because the music there sucks most of the time (it does); it&#8217;s because every time I find a link to some video that resides on their site I get the following message:</p><p>COPYRIGHT RESTRICTS US FROM PLAYING THIS VIDEO OUTSIDE OF THE US.</p><p>Now, I know all you US folks aren&#8217;t familiar with these sorts of messages, but can you please take a second and imagine how it is for the rest of us? You feel stupid: you&#8217;re willing to spend some of your precious time and see some content, and then you&#8217;re told that you can&#8217;t, because you&#8217;re located on the wrong spot of the globe.</p><p>If MTV was completely unavailable in my country (Croatia) and I were unfamiliar with the brand, it wouldn&#8217;t be a big deal. Don&#8217;t know them, don&#8217;t care. But I am a user; they&#8217;re very much available here (and pretty much everywhere else) on satellite TV, and I&#8217;m seeing those same videos I&#8217;m unable to see online on my telly every day (actually, I don&#8217;t, cause I rarely watch television; but you get the idea).</p><p>I know why this is: copyright problems. As I stated<a href="http://mashable.com/2008/03/11/hulu-europe/">many times before</a>: I don&#8217;t care. Solve it. Do something. I&#8217;m obviously able to see the content elsewhere (be it on YouTube or TV), so it&#8217;s not impossible.</p><p>Don&#8217;t do it because I tell you so, MTV. Do it because you&#8217;ve got millions of visitors hating you more and more each day; they&#8217;re your users because they&#8217;re familiar with your brand, and you&#8217;re telling them to buzz off? Gee, let me guess how that one is going to end up.</p><p>It&#8217;s one thing when you don&#8217;t let users see the video. It&#8217;s bad, but it can be worse. By chance, I&#8217;ve stumbled into some niche social network called<a href="http://www.virtualrush.com/">Virtual Rush</a>. I can&#8217;t even open the site, as I&#8217;m greeted with the message:&#8220;Sorry! Virtual Rush is only available within the United States.&#8221; They didn&#8217;t even create a nice&#8220;sorry&#8221; page, it&#8217;s just ugly, .85em sized, black Arial letters on white background. I can&#8217;t imagine why can it be necessary to keep users from even seeing the front page of a social network, regardless of how country-specific it may be.</p><p>Let&#8217;s do this once again for those companies who haven&#8217;t been paying attention: the internet is global. Anyone can be your user, regardless of where they physically are. Hiding stuff from users based on their location is stupid, and it&#8217;ll make your users hate you. Get it?</p><p>---Related Articles at ', 'http://mashable.com/2008/07/21/how-to-make-your-users-hate-you/', 1, 0, 1216635172, 0, 0, 1, 1, 0, NULL, NULL);
INSERT INTO {PREFIX}_article (article_id, cat_id, meta_keywords, meta_desc, topic_id, thumb_large, thumb_small, thumb_icon, title, content_desc, content_url, poster_id, checker_id, posted_date, is_hot, article_type, page_counter, enabled, archived, rating_marks, rating_count) VALUES (29, 3, '', '', 0, '', '', '', 'iLike Offers Free Full Track Streaming and Announces New Ad Platform', '<p><a href="http://www.ilike.com" target="_blank">iLike</a>, the music discovery service with a number of popular applications across social networks, has announced that it will now offer full track streaming through a partnership with Rhapsody.  That means that users of iLike\'s applications on Facebook, MySpace, Bebo, and hi5 will now be able to listen to complete tracks, as opposed to the 30 second samples offered previously.  Users can listen to up to 25 free tracks per month, at which point they can either subscribe to Rhapsody or will be reverted back to the samples.</p><p>The deal also has an interesting business model for artists– they earn revenue each time their music is played.  Hadi Partovi, President of iLike, told me in a conversation last week that “in the past, music social networks have been a promotional vehicle [for artists], but now it\'s also a way to help fund the music industry through our deal with Rhapsody.”  Competitor Last.fm rolled out a similar program earlier this month, dubbed the<a href="http://mashable.com/2008/07/09/lastfm-artist-royalty-program/">Artist Royalty Program</a>.</p><p>In addition to free streaming, iLike, which now claims 30 million users, has announced a new<a href="http://www.ilike.com/advertise" target="_blank">advertising platform</a>for concert promoters.  The self-service platform allows advertisers to target music fans based on their tastes, what events their friends are attending, and location.  Promoters can include multimedia in their ads, such as tracks and videos.</p><p>Finally, iLike has also announced that they plan to launch a developer platform later this year.  The platform will enable developers to access iLike\'s music catalog and stream songs in their own applications, and also allow them to integrate other features of the service.  Similarly, Imeem opened up its<a href="http://mashable.com/2008/03/24/imeem-open-platform/">music catalog</a>to developers back in March.</p><p>Overall, iLike, imeem, and Last.fm seem to be moving in very similar directions of offering free streaming music across social networks and relying on alternative business models– for iLike, concert promotion and now upselling users to Rhapsody.  Which one will win out?  The latest stats from Google Trends show Imeem in the lead, but the comparison isn\'t exactly apples-to-apples since much of iLike\'s userbase never visits the actual website and use the company&#8217;s applications within the social networks that it supports.</p><p>---Related Articles at Mashable! - The Social Networking Blog:<a href="http://mashable.com/2007/12/13/thumbplay-ilike/">Ringtones on iLike, Powered by Thumbplay</a><a href="http://mashable.com/2008/03/10/rem-new-album/">Hear The New R.E.M. Album on iLike Before it Hits the Stores</a><a href="http://mashable.com/2007/10/22/ilike-billboard-facebook-app/">iLike, Billboard Team Up for New Music Charts</a><a href="http://mashable.com/2007/11/12/rhapsody-wendys/">Free Music at Rhapsody.  Just Buy a Hot, Juicy Burger.</a><a href="http://mashable.com/2008/06/30/rhapsody-music-without-limit/">Rhapsody Does DRM-Free Music, Teams With Yahoo and Verizon</a><a href="http://mashable.com/2007/10/09/tivo-rhapsody/">Rhapsody Music Now Available Through TiVo</a><a href="http://mashable.com/2007/10/04/ilike-artist-services/">iLike Launches New Tools for Artists</a></p><img src="http://mashable.com/wp-content/uploads/2008/07/ilike-logo.gif" alt="" />', 'http://mashable.com/2008/07/20/ilike-rhapsody-full-track-streaming/', 1, 0, 1216612882, 0, 0, 1, 1, 0, NULL, NULL);
INSERT INTO {PREFIX}_article (article_id, cat_id, meta_keywords, meta_desc, topic_id, thumb_large, thumb_small, thumb_icon, title, content_desc, content_url, poster_id, checker_id, posted_date, is_hot, article_type, page_counter, enabled, archived, rating_marks, rating_count) VALUES (30, 3, '', '', 0, '', '', '', 'Minted Launches with Threadless-like Approach to Stationary Design', '<p>After working as an executive at The Body Shop and becoming an Internet entrepreneur in her own right as the co-founder of Eve.com, Mariam Naficy is a Web veteran known for her experience in the retail market.  Her latest project,<a href="http://www.minted.com" target="_blank">Minted.com</a>, launches today as both an online retail site and a community, targeting nearly every aspect of the stationary market.</p><p>Minted is angel-funded with more than a dozen private investors, most of which are other tech veterans including Ben Elowitz, Founder and CEO of WetPaint, as well as Toby Lenk, Founder of eToys and President of of Gap, Inc. Direct.  Minted has also managed to steal one of Facebook&#8217;s former employees, Biren Gandhi, as its new Vice-President, Engineering.</p><p>As a retailer and a community, Minted acts somewhat as an outsourcing tool for independent designers of paper products.  It&#8217;s the exclusive online retailer for about 17 top independent stationary brands in the US, and looking through Minted&#8217;s site, it&#8217;s clear that it would like to build on this foundation and connect designers and consumers through an olnine community.  Similar to<a href="http://www.threadless.com" target="_blank">Threadless</a>, designers can submit designs to the site, where they are voted on.  Top designs get to become part of the inventory available on Minted, and the community voting process acts as a filter for incoming content.</p><p>Such filtering is good for the consumers, as Nacify noted that they&#8217;re a busy group and would rather not have to sift through hoards of content in order to find the best designs.  But Nacify feels that the designers not only gain exposure through Minted&#8217;s online market, but that the contest approach as well.&#8220;The competitive format also creates an aspirational element that I think the designers appreciate– they like that the site is selective, and they enjoy the fun and challenge of the competition,&#8221; says Nacify.&#8220;I think there is a lot of respect among our designers for each other, so winning means a great deal to them.&#8221;</p><p>We&#8217;re seeing a number of retailers take the community approach to filtering content before it even reaches the marketplace, and others like<a href="http://mashable.com/2008/07/09/cameesa/">Cameesa</a>combining this with a micro-investment aspect for community members to become financially involved in the success of independent designers and freelancers as well.  The Web has certainly made such business models more viable, and with the experience behind Minted&#8217;s team, and its chosen $10 billion market in stationary products, it looks like the site will do quite well.</p><p>---Related Articles at Mashable! - The Social Networking Blog:<a href="http://mashable.com/2008/07/11/24-hours-iphone/">Leo Laporte Does 24 Hours of iPhone to Over', 'http://mashable.com/2008/07/20/minted/', 1, 0, 1216612829, 0, 0, 1, 1, 0, NULL, NULL);
INSERT INTO {PREFIX}_article (article_id, cat_id, meta_keywords, meta_desc, topic_id, thumb_large, thumb_small, thumb_icon, title, content_desc, content_url, poster_id, checker_id, posted_date, is_hot, article_type, page_counter, enabled, archived, rating_marks, rating_count) VALUES (31, 3, '', '', 0, '', '', '', 'San Francisco: Tune Your TVs to SummerMash SF', '<p>If you&#8217;re in SF, look out for coverage of this week&#8217;s massively successful SummerMash SF on<a href="http://www.kron4.com/global/Category.asp?c=142817">Kron4</a>, tonight at 9pm PT. Alternatively, check out the embedded clips below.</p><p>The latest photos from the SummerMash series of events are available on our<a href="http://flickr.com/photos/mashable">Flickr feed</a>or through Facebook (feel free to<a href="http://www.facebook.com/profile.php?id=500283591">add me</a>as a friend).</p><p>---Related Articles at Mashable! - The Social Networking Blog:<a href="http://mashable.com/2008/06/13/summermash-startups/">Get Your Startup on Mashable (If You\'re in a SummerMash City)</a><a href="http://mashable.com/2008/07/09/qik-mobile-live-streaming-straight-to-mashable-events-pages/">Qik Mobile Live Streaming Straight to Mashable Events Pages</a><a href="http://mashable.com/2008/07/15/summermash-san-francisco-streaming-live-summermash-tour-2008/">SummerMash San Francisco Streaming Live [SummerMash Tour 2008]</a><a href="http://mashable.com/2008/07/12/summermash-seattle-3/">U.S SummerMash Tour Opens In Seattle - Live Video Feed</a><a href="http://mashable.com/2008/07/15/personality-not-included-book-signing/">&#8220;Personality Not Included&#8221; Book Signing This Week at SummerMash SF and Los Angeles</a><a href="http://mashable.com/2008/07/14/seattle-summermash-wrapup/">Thank You Seattle!  SummerMash Rocked</a><a href="http://mashable.com/2008/07/11/yoono-social-media-camp-seattle/">Get Warmed Up for SummerMash Seattle with Yoono&#8217;s Social Media Camps</a></p><img src="http://mashable.com/wp-content/uploads/2008/07/pete-kron.gif" alt="" />', 'http://mashable.com/2008/07/20/san-francisco-tune-your-tvs-to-summermash-sf/', 1, 0, 1216611641, 0, 0, 1, 1, 0, NULL, NULL);
INSERT INTO {PREFIX}_article (article_id, cat_id, meta_keywords, meta_desc, topic_id, thumb_large, thumb_small, thumb_icon, title, content_desc, content_url, poster_id, checker_id, posted_date, is_hot, article_type, page_counter, enabled, archived, rating_marks, rating_count) VALUES (32, 3, '', '', 0, '', '', '', 'Facebook\'s Beta Re-Design Officially Launches at new.facebook.com', '<p>Update (9:55PM PT): Facebook has issued a<a href="http://www.new.facebook.com/press/releases.php?p=47448">press release</a>announcing the new design, indicating that&#8220;access to the new design will be limited at first and gradually become available to all.&#8221;</p><p>As<a href="http://mashable.com/2008/07/20/facebook-redesign/">expected</a>, Facebook has officially rolled out the beta for its new design this evening.  To get it, you can now go to<a href="http://www.new.facebook.com" target="_blank">www.new.facebook.com</a>, which will convert the site to the new look.  You can still roll back to the previous version by clicking a“Back to Old Facebook” link at the top of the site.</p><p>From top to bottom, the design is a lot cleaner than the current Facebook, and certainly is a big attempt to make the site less cluttered while placing an emphasis on a number of features– most notably the mini-feed and status updates.  This is immediately noticeable in the homepage, where the new Facebook features just two columns versus the three in the old version, with requests, links, and other current homepage features consolidates on the right, with your News Feed on', 'http://mashable.com/2008/07/20/new-facebook-launches/', 1, 0, 1216608692, 0, 0, 1, 1, 0, NULL, NULL);
INSERT INTO {PREFIX}_article (article_id, cat_id, meta_keywords, meta_desc, topic_id, thumb_large, thumb_small, thumb_icon, title, content_desc, content_url, poster_id, checker_id, posted_date, is_hot, article_type, page_counter, enabled, archived, rating_marks, rating_count) VALUES (33, 3, '', '', 0, '', '', '', 'Adobe Target FreshAIRapps Officially Moves to a New Home', '<p>Only two weeks have passed since we first reported on Adobe Inc\'s undertaking<a href="http://mashable.com/2008/07/06/adobe-air-tm/">to remove the FreshAIRapps</a>domain and nameplate from the Web. In short,<a href="http://freshairapps.com/" target="_blank">FreshAIRapps</a>was a compendium or directory of applications built upon the Adobe AIR platform. Users could rate codeworks and read relevant news and so forth in one central location. It would be accurate to have called it a fairly popular upstart.</p><p>Yes, called is the key word to keep in mind now. According to the founder of FreshAIRapps, James Whittaker, who alerted Mashable to the fact earlier today, the website is no more. An attempt to visit the URL shows a mostly bare white page, stating that the site has moved to a new location. Seconds later, the visitor is automatically transferred there.&#8220;There&#8221; being<a href="http://refreshingapps.com/" target="_blank">RefreshingApps.com</a>.</p><p>It sports a slightly different design, but its basic makeup is all very much intact. The one overt exception is a now-absent section originally seen at FreshAIRapps, labeled \'Tutorials.\'</p><p>There was a notable level of resentment and fury levied at Adobe for pushing forcefully for the removal of FreshAIRapps in name only. Some<a href="http://mashable.com/2008/07/06/adobe-air-tm/#comments">commenters</a>found it peculiar that the company would enforce a trademark of“AIR.” I myself seconded such objections. Still, the site\'s creator continued to converse with Adobe over the planned transfer to the RefreshingApps domain and has now officially announced the completion of the move.</p><p>Whittaker does note he and the RefreshingApps project“will be working closely with Adobe and their evangelists to further promote the Adobe AIR offering” as well as RefreshingApps.com. He also mentioned that word concerning “AIR stuff and RefreshingApps” will likely be delivered by Adobe sometime this week.</p><p>---Related Articles at Mashable! - The Social Networking Blog:<a href="http://mashable.com/2008/07/06/adobe-air-tm/">Adobe Lays Claim To AIR (In The Web Domain Space)</a><a href="http://mashable.com/2007/10/10/adobe-security-flaw/">Adobe Can&#8217;t Fix Security Flaw Until End of October</a><a href="http://mashable.com/2007/08/14/adobe-office-applications/">Adobe Building Office Apps to Go After Microsoft?</a><a href="http://mashable.com/2007/08/20/adobe-flash-player-9/">Adobe Launches Updated Flash Player 9:  Moviestar</a><a href="http://mashable.com/2007/10/01/adobe-buzzword/">Adobe to Acquire Makers of Web-Based Word Processor Buzzword</a><a href="http://mashable.com/2007/09/21/adobe-vulnerability/">Beware of PDF Files! Adobe Security Vulnerability Found.</a><a href="http://mashable.com/2007/05/30/adobe-delicious/">Adobe Illustrator Integrated with Del.icio.us</a></p><img src="http://mashable.com/wp-content/uploads/2008/07/refreshingapps.png" alt="" />', 'http://mashable.com/2008/07/20/adobe-refreshingapps/', 1, 0, 1216596114, 0, 0, 1, 1, 0, NULL, NULL);
INSERT INTO {PREFIX}_article (article_id, cat_id, meta_keywords, meta_desc, topic_id, thumb_large, thumb_small, thumb_icon, title, content_desc, content_url, poster_id, checker_id, posted_date, is_hot, article_type, page_counter, enabled, archived, rating_marks, rating_count) VALUES (34, 3, '', '', 0, '', '', '', 'NYT Pushing Back at WSJ With Boost to Business Coverage', '<p>This week\'s edition of<a href="http://adage.com/mediaworks/article?article_id=129774" target="_blank">Advertising Age</a>has a somewhat revealing piece concerning movements in Web media space by some old media titans. In particular,<a href="http://mashable.com/2008/04/20/wsj-vs-nyt/">The New York Times versus The Wall Street Journal</a>. We\'ve heard the WSJ talk adventurous talk in months past about conditioning itself to compete more effectively in the general news space with the NYT. Now it\'s being said that, in addition to the NYT\'s attempts to draw itself<a href="http://www.mashable.com/2008/06/18/nytimes-timespeople/">further into the social realm</a>online, the outfit is pressing to meet the WSJ in its own court: business.</p><p>Indeed, according to Vivian Schiller, senior vice president and general manager of the NYT\'s website, coverage will grow in the areas of “the economy, energy, small business, personal finance and enterprise technology,” all of it constructed into verticals in vein of the popular<a href="http://dealbook.blogs.nytimes.com/" target="_blank">DealBook</a>blog. This move was recently hinted at by John Markoff, a writer and reporter for the paper, while sitting as a guest on a recent episode of&#8220;<a href="http://www.crankygeeks.com/2008/07/episode_124_the_future_of_tech.php" target="_blank">Cranky Geeks</a>,&#8221; a weekly video podcast hosted by John C. Dvorak.</p><p>I mu', 'http://mashable.com/2008/07/20/nyt-wsj-business-war/', 1, 0, 1216590714, 0, 0, 1, 1, 0, NULL, NULL);
INSERT INTO {PREFIX}_article (article_id, cat_id, meta_keywords, meta_desc, topic_id, thumb_large, thumb_small, thumb_icon, title, content_desc, content_url, poster_id, checker_id, posted_date, is_hot, article_type, page_counter, enabled, archived, rating_marks, rating_count) VALUES (35, 3, '', '', 0, '', '', '', 'studiVZ Claims Facebook Suit is Meritless', '<p>As has been widely reported by tech media outlets for a few days now, Facebook filed a<a href="http://mashable.com/2008/07/19/fed-up-with-german-copycat-facebook-unleashes-the-lawyers/">lawsuit against studiVZ</a>Ltd. in California federal court on Friday claiming the German network had copied its“look, feel, features and services.” Today the recipient of the suit issued a public response on the matter. StudiVZ said that prior to Facebook\'s own filing in the U.S., lawyers representing Palo Alto-based network had communicated messages that “prompted studiVZ to file for a declaratory judgment at the District Court in Stuttgart, Germany” the same day.<a href="http://www.studivz.net/" target="_blank">StudiVZ</a>would not elaborate as of yet, however, saying that it had not been formally served with Facebook\'s complaint, and therefore “cannot comment in detail about the content of the claims.”</p><p><a href="http://mashable.com/wp-content/uploads/2008/07/marcus.png"></a>StudiVZ CEO Marcus Riecke delivered a statement along with the company\'s brief summary of Friday\'s events:</p><p>“Now that Facebook, despite trying hard, has not been successful in the German market, the company seeks to obstruct studiVZ through court action. Their strategy appears to be: If you can&#8217;t beat them, sue them.</p><p>“There are numerous social networks. Facebook was not the first and certainly isn&#8217;t the only one. By attempting to harm studiVZ through a meritless California lawsuit, Facebook is arrogantly laying claim to an international monopoly over social networking sites that the facts show it does not deserve.&#8221;</p><p>---Related Articles at Mashable! - The Social Networking Blog:<a href="http://mashable.com/2007/01/03/studivz/">StudiVZ Acquired For $112M</a><a href="http://mashable.com/2008/07/19/fed-up-with-german-copycat-facebook-unleashes-the-lawyers/">Fed Up With German Copycat, Facebook Unleashes the Lawyers</a><a href="http://mashable.com/2007/08/19/doktus/">Doktus, German Scribd Clone: Samwer Brothers At It Again?</a><a href="http://mashable.com/2006/11/15/studivz-controversy-surrounds-facebook-rip-off/">StudiVZ - Massive Controversy Surrounds Facebook Rip-Off</a><a href="http://mashable.com/2007/09/03/myvideode-acquired/">German YouTube Clone Acquired by TV Station</a><a href="http://mashable.com/2008/01/15/facebook-samwer-brothers/">Facebook Gets New Investors: Samwer Brothers for European Expansion</a><a href="http://mashable.com/2007/07/11/10-facebook-clones/">Copycats: Top 10 International Facebook Clones</a></p><img src="http://mashable.com/wp-content/uploads/2008/07/studivz.png" alt="" />', 'http://mashable.com/2008/07/20/studivz-facebook-lawsuit/', 1, 0, 1216582690, 0, 0, 1, 1, 0, NULL, NULL);
INSERT INTO {PREFIX}_article (article_id, cat_id, meta_keywords, meta_desc, topic_id, thumb_large, thumb_small, thumb_icon, title, content_desc, content_url, poster_id, checker_id, posted_date, is_hot, article_type, page_counter, enabled, archived, rating_marks, rating_count) VALUES (36, 3, '', '', 0, '', '', '', 'MixTurtle Music Search Is Fast. Real Fast.', '<p>Combine the element of Web search with music playback and a mohawk-sporting, ciggie-smoking dinosaur, and you get<a href="http://mixturtle.com/" target="_blank">MixTurtle</a>, a new service that works as you might expect it to. Just click and play.</p><p>Ajax is responsible making it behave as it does. Some might consider it bit too heavy on the large print. Everything but the topmost menu is sized big. But this is fairly easy to get accustomed to. And there\'s an upside to the design choice. The results are easy to make sense of. If your music search produces an especially large volume of material, this can really prove helpful in finding what you\'re looking for.</p><p>Most impressive with MixTurtle, whose content sources are absent the picture, is the sheer speed with which information is displayed. Begin to type a keyword, and you\'re immediately shown a selection of choices in a drop-down overlay. You can select one listed or continue with your query by manually inputting any desired text. Once you\'ve entered your search, the rate of return is all but instant. I don\'t recall testing any other engine with such alacrity.Not<a href="http://mashable.com/2008/02/04/songerize/">Seeqpod</a>, not<a href="http://www.mashable.com/2008/03/04/songza-profiles/">Songza</a>, not any other. This little reptile has one heck of a rocket affixed to its rear, for sure.</p><p>The rest of the engine is fairly self-explanatory. As noted directly above the results box, you can add songs to a playlist, which you can call on any subsequently visit once you sign up for a free account.</p><p>To play back music, you click the artist/track label. Click again to pause. A slim submenu emerges directly below the chosen song, which displays the buffer bar, the number of sources discovered to hold said track, and an option to browse other sources. That last item may not prove too useful, however, since MixTurtle automatically begins to plays a song. (Note: sometimes a request or a user name and password will surface for a particular track.)</p><img src="http://mashable.com/wp-content/uploads/2008/07/mixturtle.png" alt="" />', 'http://mashable.com/2008/07/20/mixturtle/', 1, 0, 1216579857, 0, 0, 1, 1, 0, NULL, NULL);
INSERT INTO {PREFIX}_article (article_id, cat_id, meta_keywords, meta_desc, topic_id, thumb_large, thumb_small, thumb_icon, title, content_desc, content_url, poster_id, checker_id, posted_date, is_hot, article_type, page_counter, enabled, archived, rating_marks, rating_count) VALUES (37, 3, '', '', 0, '', '', '', 'Some Startups Just Don\'t Need Starting', '<p>I\'ve been scrolling slowly down the list of items mentioned by Paul Graham, a partner at the startup micro-financier outfit<a href="http://ycombinator.com/" target="_blank">Y Combinator</a>, in a piece titled“<a href="http://ycombinator.com/ideas.html" target="_blank">Startup Ideas We\'d Like to Fund</a>.” It\'s an interesting write-up, and I think a whole lot of people should give it a look. Not necessarily because genius resides within. In fact, a lot of what Graham says will strike most any reader as fairly obviously wanting for the wand of progress.</p><p>There are some points raised, however, that either seem too vague or uninformative, or just plain unnecessary, to be worth a“new” attempt. Of course, I do recognize that Graham\'s post is only a soft invitation for startups to submit ideas to Y Combinator. And, well, it would be pretty senseless to object to the inclinations of the firm. That\'s not what I intend for here. Rather, I simply wish to parse some itemsthat I consider superfluous and unnecessary. The kind of stuff that invokes the “been there, done that” adage, in other words. Ideas that already have solid representation on the Web, and don&#8217;t require major fixes or alterations.</p><p>First, there is the idea posited by YC (I\'ll abbreviate it investor\'s name from here on out) for a fresh startup to compete with Microsoft. Now, a plan to take on Redmond is all good and well. An admirable goal for sure. But others are already working toward that objective.<a href="http://www.mashable.com/2008/04/13/salesforce-for-google-apps/">Google</a>is one.<a href="http://www.mashable.com/2008/05/14/zoho-openid/">Zoho</a>is another.<a href="http://www.mashable.com/2008/06/01/adobe-acrobat/">Adobe</a>recently introduced its own suite as well. And while they may ideally prefer to engineer a collective effort to bring down the software market\'s reigning cash cow, they will no doubt look after their own health above all other concerns. Save for an acquisition, new rising stars aren\'t likely to grow so tall, in other words. But with the tech sector feeling a few pangs of financial caution, the idea of buying only what you need would logically come to the fore. So at this point, I\'ll short any newbies to this particular segment of the Web applicatio', 'http://mashable.com/2008/07/20/ycombinator-startups/', 1, 0, 1216573148, 0, 0, 1, 1, 0, NULL, NULL);
INSERT INTO {PREFIX}_article (article_id, cat_id, meta_keywords, meta_desc, topic_id, thumb_large, thumb_small, thumb_icon, title, content_desc, content_url, poster_id, checker_id, posted_date, is_hot, article_type, page_counter, enabled, archived, rating_marks, rating_count) VALUES (38, 3, '', '', 0, '', '', '', 'Facebook Sets Second Redesign Launch Attempt for Tonight', '<p>Alright, so<a href="http://www.facebook.com" target="_blank">Facebook</a>kind of failed to accurately estimate when it would be taking long-talked-about profile redesign. The number last tossed around was<a href="http://mashable.com/2008/07/07/facebook-profiles-beta/">July 16</a>. The day came, the day went, and nothing. No changes made. That may have made for an anticlimactic Wednesday for some. So will the second try, scheduled for this evening, according to Justin Smith of<a href="http://www.insidefacebook.com/2008/07/19/facebook-redesign-beta-now-going-live-on-sunday-night/" target="_blank">Inside Facebook</a>, turn out to be the true charmer?</p><p>As you may be aware, Facebook has been<a href="http://mashable.com/2008/07/14/future-facebook-profiles/">teasing users</a>as of late with a<a href="http://www.new.facebook.com/" target="_blank">test page</a>to give a glimpse of what\'s to come. And the network began in Spring to<a href="http://mashable.com/2008/05/23/facebook-profile-redesign-sandbo/">allow developers</a>to familiarize themselves with the new layout. When doors officially open, all of Facebook\'s members will be access, albeit through a transitional, opt-in model.</p><p>The upgrade to the profile page isn\'t a whirlwind transformation. Most users will likely intuit for themselves how to manage their information in no time. But it\'s a welcome move all the same. The current design has been in place for quite a while. Lots of things in the social networking space have evolved with the seasons. Facebook would do well to alter itself a bit, too.</p><p>Of course, it\'s largest task has been bringing application developers into alignment. If you\'re counting on an entirely glitch-less upgrade, you may be in luck. Or you may not. Much may depend on your chosen third-party installs. In that respect, there\'s still some chance for a bit of disappointment. And as far as potential hiccups on Facebook\'s end, well, suffice it to say that the company acknowledged a problem with API performance days after days after the profile update was originally intended for public launch.</p><p>---Related Articles at Mashable! - The Social Networking Blog:<a href="http://mashable.com/2008/05/23/facebook-profile-redesign-sandbo/">Facebook Profile Redesign: Sandbox Now Open to Developers</a><a href="http://mashable.com/2008/04/13/facebook-delays-redesign/">Facebook Puts Off Early April Redesign</a><a href="http://mashable.com/2008/05/07/facebook-redesign-are-developers-ready/">Facebook Redesign: Are Developers Ready?</a><a href="http://mashable.com/2007/04/11/facebook-design/">Facebook Guy Dead at 3: Poke in Peace</a><a href="http://mashable.com/2008/07/07/facebook-profiles-beta/">Facebook Profile Redesign Beta Launches July 16th. Are Users Ready?</a><a href="http://mashable.com/2007/07/16/yellowpages-redesign/">YellowPages Redesigned to Better Accommodate Local Search</a><a href="http://mashable.com/2008/06/19/facebook-matt-cohler/">Facebook Loses Another Early Executive</a></p><img src="http://mashable.com/wp-content/uploads/2008/07/facebook-redesign.png" alt="" />', 'http://mashable.com/2008/07/20/facebook-redesign/', 1, 0, 1216563984, 0, 0, 1, 1, 0, NULL, NULL);
INSERT INTO {PREFIX}_article (article_id, cat_id, meta_keywords, meta_desc, topic_id, thumb_large, thumb_small, thumb_icon, title, content_desc, content_url, poster_id, checker_id, posted_date, is_hot, article_type, page_counter, enabled, archived, rating_marks, rating_count) VALUES (39, 3, '', '', 0, '', '', '', 'Why Does The Industry Standard Think Podcasting is Failing?', '<p>The short answer is that they want it to fail. There seems to be an underpinning of glee to get to deadpool it, and no one has told them it&#8217;s no longer trendy to call podcasting a failure anymore.</p><p>The long answer has to do with a lot of factors.  The subject is brought to my attention by Ian Lamont, who&#8217;s<a href="http://www.thestandard.com/news/2008/07/18/why-podcasting-failing-part-ii-lessons-podtech" target="_blank">written another weekend article that takes a hit out on podcasting</a>as an industry due to the failings of a few. In an editorial published today, Ian talks about the black eye podcasting as a whole has recieved as a result of the<a href="http://mashable.com/2008/07/17/podtech-sold/">failure of PodTech</a>to sell for more than half a million.</p><p>Just as I predicted at the end of that article, the myopic analysis on the&#8220;death of podcasting&#8221; is beginning anew. Ian pontificates:</p><p>&#8220;&#8230;[M]y original thesis: Podcasting is failing as a business platform, and has failed to make a mainstream impact [...] But even if the stars had stuck around to the end, and the management and board problems were addressed earlier, I have to wonder how well this venture would have done. This was a hyped business built on one of the most hyped technologies of 2005. Once the that faded, reality set in. As I pointed out in my original post, there are a lot of factors that are working against podcasting. Making programs is a labor-intensive process requiring special skills. In addition, there is no AdSense or AdWords equivalents for podcasts&#8212; advertising has to be sold, produced, and placed by humans.&#8221;</p><p>When it comes down to it, though, Ian only has a few points to prop up his diagnosis of podcasting: PodTech more or less failed in the end, podcasting was overhyped and his analysis of a podcasting survey', 'http://mashable.com/2008/07/19/podcasting-failure/', 1, 0, 1216527984, 0, 0, 1, 1, 0, NULL, NULL);
INSERT INTO {PREFIX}_article (article_id, cat_id, meta_keywords, meta_desc, topic_id, thumb_large, thumb_small, thumb_icon, title, content_desc, content_url, poster_id, checker_id, posted_date, is_hot, article_type, page_counter, enabled, archived, rating_marks, rating_count) VALUES (40, 3, '', '', 0, '', '', '', 'Lesson Writer Helps Teachers Quickly Conquer an Often Menial Task', '<p>If you\'re educator near the middle of the K-12 curriculum, and you\'re feeling a bit lacking in terms of online tools available to help increase your own efficiency in the case of schoolwork, this item may be worth a look. It\'s called Lesson Writer, and it\'s something that can aid you in cranking out a basic lesson (and plan) for particular course on a given day. If you\'re short for time, or consider the lesson-creation element of your workflow best left up to a series of code to piece together,<a href="http://www.lessonwriter.com/" target="_blank">Lesson Writer</a>may go far in getting you to crunch through your own set of tasks outside the classroom more quickly.</p><p>There isn\'t too much that needs explaining about Lesson Writer. If you stumble across a website whose content you\'d like to include in an agenda for a future day (or perhaps the very same school session that happens to call you to two or more places at once and leaves you with little time to manufacturepapers for class), you can select any interesting text and paste it into a draft page for a new lesson. Once you\'ve submitted said text to the Lesson Writer engine, you\'re taken through a process of choosing any that Lesson Writer deems pertinent. This goes for things like vocabulary, grammar and so forth. You can add your own custom critical thinking queries for students at the final step.</p><p>There\'s certainly a limit to what you can accomplish through Lesson Writer. Complex algebraic problems aren\'t part of the package. The extent to Lesson Writer\'s powers seems to be very plainly hinted in its title. It seems only some elementary Language Arts and perhaps some History and Civics lessons can be assembled through the service. And if you prefer to interact with lessons created by other teachers in well-engineered environment, you might do well to consult with the<a href="http://mashable.com/2007/08/23/yahoo-teachers/">Yahoo Teachers</a>beta program.</p><p>Yet, if you&#8217;re tasked with managing a variety of subjects in a given day as instructor/disciplinarian/mediator/etc., and are wanting terribly for a quick and easy backup lesson solution, and don\'t happen have your own personal living and breathing teaching assistant, Lesson Writer could very well work to complement your grind if/when the moment requires it.</p><p>---Related Articles at Mashable! - The Social Networking Blog:<a href="http://mashable.com/2007/05/30/windows-live-writer-new-release/">Windows Live Writer Launches Beta 2</a><a href="http://mashable.com/2007/08/23/yahoo-teachers/">Yahoo Teachers: Social Network for Teachers</a><a href="http://mashable.com/2007/09/18/trymango/">Learn Foreign Language for Free with Mango</a><a href="http://mashable.com/2007/10/17/kantalk/">How to Use YouTube to Learn English: FunTalk</a><a href="http://mashable.com/2008/02/27/zoho-writer-updates-2/">Zoho Writer Gets Thesaurus And File Export Upgrades</a><a href="http://mashable.com/2005/12/26/the-delicious-lesson-putting-personal-value-before-network-effect/">The Del.icio.us Lesson - Putting Personal Value Before Network Value</a><a href="http://mashable.com/2007/11/14/zoho-writer-updates/">Zoho Writer Gets More Professional</a></p><img src="http://mashable.com/wp-content/uploads/2008/07/lessonwriter.png" alt="" />', 'http://mashable.com/2008/07/19/lesson-writer/', 1, 0, 1216511556, 0, 0, 1, 1, 0, NULL, NULL);
INSERT INTO {PREFIX}_article (article_id, cat_id, meta_keywords, meta_desc, topic_id, thumb_large, thumb_small, thumb_icon, title, content_desc, content_url, poster_id, checker_id, posted_date, is_hot, article_type, page_counter, enabled, archived, rating_marks, rating_count) VALUES (41, 3, '', '', 0, '', '', '', 'Rediff Follows Facebook\'s Lead With Its Own Platform Launch', '<p><a href="http://www.rediff.com/" target="_blank"></a></p><p><a href="http://www.rediff.com/" target="_blank">Rediff</a>, one of the top online portals in India and one currently listed on the<a href="http://finance.yahoo.com/q?s=redf" target="_blank">NASDAQ</a>stock market, has evidently followed the past year progress of third-party developments within Facebook closely. Now it wants to stir a similar amount of interest in its own set of properties as well. Announced at Delhi\'s<a href="http://www.proto.in/" target="_blank">Proto.in</a>startup event, Rediff officially took the covers off its own developer program, called, plainly enough,<a href="http://developer.rediff.com/" target="_blank">The Rediff Platform</a>.</p><p>The reason for the Facebook reference is simple. The company states that its properties are“being made&#8230;to support<a href="http://developers.facebook.com/" target="_blank">FBML</a>,” Facebook\'s markup language.</p><p>Indeed,<a href="http://www.mashable.com/2007/07/15/google-yahoo-want-to-acquire-rediff/">Rediff</a>is pushing an idea eminently synonymous with Facebook\'s own. The phrase “apps economy” is writ large on the Rediff Developers page. But it\'s also an effort that the company hopes will align with multiple pieces of the Rediff puzzle. To kick off the developer program, Rediff is first opening<a href="http://www.mashable.com/2007/07/12/ishare/" target="_blank">iShare</a>, its music, video, and photo sharing service.</p><p>The company is promising grants to some students and entrepreneur developers through a basic submission program it is calling“Sociali.” The sum being touted by the company to fuel ideas thought promising ideas is 250,000 rupees, or US$5,800. A relatively small figure, it seems, especially if juxtaposed against Rediff\'s expected revenue report for Q2 2008 (roughly $17 million). All may depend on the supply of developers Rediff finds enticing enough to fund in the weeks and months ahead.</p><p>The company states that developers ready to begin fabricating can now do so with data provided through<a href="http://developer.rediff.com/" target="_blank">its new website</a>.</p><p>---Related Articles at Mashable! - The Social Networking Blog:<a href="http://mashable.com/2007/07/15/google-yahoo-want-to-acquire-rediff/">Google and Yahoo Looking to Acquire India-Based Rediff</a><a href="http://mashable.com/2007/07/12/ishare/">iShare, The Indian YouTube</a><a href="http://mashable.com/2007/07/18/yahoo-acquires-stake-in-tyroo/">Yahoo Takes Large Stake in India&#8217;s Tyroo Media</a><a href="http://mashable.com/2008/02/06/myspace-developer-platform-poll/">The Daily Poll: Would You Build Apps for the MySpace Developer Platform?</a><a href="http://mashable.com/2007/10/12/linkedin-platform/">LinkedIn Outlines Strategy for Upcoming Platform</a><a href="http://mashable.com/2007/06/13/clearspring-community-platform/">Clearspring Opens Community Platform for Developers</a><a href="http://mashable.com/2008/03/07/platform-poll/">The Daily Poll: Which Platform is the Best Opportunity for Developers?</a></p><img src="http://mashable.com/wp-content/uploads/2008/07/rediff.png" alt="" />', 'http://mashable.com/2008/07/19/rediff-platform/', 1, 0, 1216505142, 0, 0, 1, 1, 0, NULL, NULL);
INSERT INTO {PREFIX}_article (article_id, cat_id, meta_keywords, meta_desc, topic_id, thumb_large, thumb_small, thumb_icon, title, content_desc, content_url, poster_id, checker_id, posted_date, is_hot, article_type, page_counter, enabled, archived, rating_marks, rating_count) VALUES (42, 4, '', '', 0, '', '', '', 'WebMonkey\'s Five Best Firebug Extensions', 'Adam DuVander over at WebMonkey has compiled a list of their five favorite Firebug extensions. The ever-popular YSlow tops the list, but to that they add:\n\nFirecookie for easy access to cookie information\nFirePHP to integrating server-provided PHP debugging information with the Firebug UI\nPixel Perfect for overlaying mock-ups on top of the real thing to ensure you&#8217;ve [...]', 'http://feeds.feedburner.com/~r/ajaxian/~3/341564288/webmonkeys-five-best-firebug-extensions', 1, 0, 1216649210, 0, 0, 1, 1, 0, NULL, NULL);
INSERT INTO {PREFIX}_article (article_id, cat_id, meta_keywords, meta_desc, topic_id, thumb_large, thumb_small, thumb_icon, title, content_desc, content_url, poster_id, checker_id, posted_date, is_hot, article_type, page_counter, enabled, archived, rating_marks, rating_count) VALUES (43, 4, '', '', 0, '', '', '', 'Increase DOM Node Insertion Performance', 'John Resig continues his streak of compelling blog entries with "DOM DocumentFragments" where he shows that:\n\nA method that is largely ignored in modern web development can provide some serious (2-3x) performance improvements to your DOM manipulation.\n\nThe technique shown is compatible across a large swath of modern browsers, including our friend IE6. Here''s an example of [...]', 'http://feeds.feedburner.com/~r/ajaxian/~3/341559747/increase-dom-node-insertion-performance', 1, 0, 1216648807, 0, 0, 1, 1, 0, NULL, NULL);
INSERT INTO {PREFIX}_article (article_id, cat_id, meta_keywords, meta_desc, topic_id, thumb_large, thumb_small, thumb_icon, title, content_desc, content_url, poster_id, checker_id, posted_date, is_hot, article_type, page_counter, enabled, archived, rating_marks, rating_count) VALUES (44, 4, '', '', 0, '', '', '', 'iPhone Native Apps vs. iPhone Web Apps', 'John Allsop wrote a long piece over at Web Directions South with some thoughts on writing native iPhone apps versus web-based iPhone apps.\nThe obvious flaw in his piece is that he only looked at free iPhone applications and from that subset concluded that almost everything the native apps do could be done with web applications [...]', 'http://feeds.feedburner.com/~r/ajaxian/~3/341549979/iphone-native-apps-vs-iphone-web-apps', 1, 0, 1216647628, 0, 0, 1, 1, 0, NULL, NULL);
INSERT INTO {PREFIX}_article (article_id, cat_id, meta_keywords, meta_desc, topic_id, thumb_large, thumb_small, thumb_icon, title, content_desc, content_url, poster_id, checker_id, posted_date, is_hot, article_type, page_counter, enabled, archived, rating_marks, rating_count) VALUES (45, 4, '', '', 0, '', '', '', 'jQuery: Sparklines Plug-in', 'Edward Tufte has long had a following of fans in the field of information visualizations. Among his interesting taxonomy of visualization types is the "Sparkline", which he describes as "data-intense, design-simple, word-sized graphics".\nWhile Tufte originally suggested that computer displays are too low-resolution to effectively make use of Sparklines (vs. printed page), James Dempster pointed us [...]', 'http://feeds.feedburner.com/~r/ajaxian/~3/341534390/jquery-sparklines-plug-in', 1, 0, 1216646517, 0, 0, 1, 1, 0, NULL, NULL);
INSERT INTO {PREFIX}_article (article_id, cat_id, meta_keywords, meta_desc, topic_id, thumb_large, thumb_small, thumb_icon, title, content_desc, content_url, poster_id, checker_id, posted_date, is_hot, article_type, page_counter, enabled, archived, rating_marks, rating_count) VALUES (46, 4, '', '', 0, '', '', '', 'Firebug to get a boost', 'Great news for all Web developers out there (that be you!). Firebug is going to get a shot in the arm. Joe Hewitt has had to slow down his work on the tool, and thus the Firebug Working Group was created, to try to make the tool continue to thrive.\nThe work has been mainly done [...]', 'http://feeds.feedburner.com/~r/ajaxian/~3/339010547/firebug-to-get-a-boost', 1, 0, 1216388812, 0, 0, 1, 1, 0, NULL, NULL);
INSERT INTO {PREFIX}_article (article_id, cat_id, meta_keywords, meta_desc, topic_id, thumb_large, thumb_small, thumb_icon, title, content_desc, content_url, poster_id, checker_id, posted_date, is_hot, article_type, page_counter, enabled, archived, rating_marks, rating_count) VALUES (47, 4, '', '', 0, '', '', '', 'Lightweight Grid Control for jQuery', 'Developers are always looking for a great grid control that is easy to use, customizable and, of course, feature-rich. Paulo MariÃ±as has created just that for jQuery developers. Flexigrid is an extremely flexible grid control with provides many of the features highly-desired by developers. These include:\n\nResizable columns\nResizable height and width\nSortable column headers\nCool theme\nCan convert an [...]', 'http://feeds.feedburner.com/~r/ajaxian/~3/338966847/lightweight-grid-control-for-jquery', 1, 0, 1216384842, 0, 0, 1, 1, 0, NULL, NULL);
INSERT INTO {PREFIX}_article (article_id, cat_id, meta_keywords, meta_desc, topic_id, thumb_large, thumb_small, thumb_icon, title, content_desc, content_url, poster_id, checker_id, posted_date, is_hot, article_type, page_counter, enabled, archived, rating_marks, rating_count) VALUES (48, 4, '', '', 0, '', '', '', 'Reduce, Reuse, Recycle…. your code', 'With a young son, I often listen to the "Reduce, Reuse, Recycle" song by Jack Johnson for the Curious George movie. Edgar Hassler has taken that axiom and applied it to code.\nEdgar goes into a lot of detail, including the following issue that he ran into:\n\nThe problem I kept having was that I needed to [...]', 'http://feeds.feedburner.com/~r/ajaxian/~3/338945389/reduce-reuse-recycle-your-code', 1, 0, 1216382927, 0, 0, 1, 1, 0, NULL, NULL);
INSERT INTO {PREFIX}_article (article_id, cat_id, meta_keywords, meta_desc, topic_id, thumb_large, thumb_small, thumb_icon, title, content_desc, content_url, poster_id, checker_id, posted_date, is_hot, article_type, page_counter, enabled, archived, rating_marks, rating_count) VALUES (49, 4, '', '', 0, '', '', '', 'Semantic Constructors', 'PLAIN TEXT\nJAVASCRIPT:\n\n\n\n\n&#160;\n\n\nClass.create = &#40;function&#40;original&#41; &#123;\n\n\n&#160; var fn = function&#40;&#41; &#123;\n\n\n&#160; &#160; var result = original.apply&#40;null, arguments&#41;;\n\n\n&#160; &#160; result.toString = function&#40;&#41; &#123; return result.prototype.initialize.toString&#40;&#41; &#125;;\n\n\n&#160; &#160; return result;\n\n\n&#160; &#125;;\n\n\n&#160; fn.toString = function&#40;&#41;&#123; return original.toString&#40;&#41; &#125;;\n\n\n&#160; return fn;\n\n\n&#125;&#41;&#40;Class.create&#41;;\n\n\n&#160;\n\n\n\n\n\nThis monkey patch by kangax allows you to get sense from inspecting a constructor setup via Prototype.\nHis code changes a [...]', 'http://feeds.feedburner.com/~r/ajaxian/~3/338889366/semantic-constructors', 1, 0, 1216377425, 0, 0, 1, 1, 0, NULL, NULL);
INSERT INTO {PREFIX}_article (article_id, cat_id, meta_keywords, meta_desc, topic_id, thumb_large, thumb_small, thumb_icon, title, content_desc, content_url, poster_id, checker_id, posted_date, is_hot, article_type, page_counter, enabled, archived, rating_marks, rating_count) VALUES (50, 4, '', '', 0, '', '', '', 'Radiohead + Open Data = JavaScript + Canvas Visualizations of their work', 'I work on Google Code. Hearing that Radiohead was going to release data with progressive licensing and wanted to do so on Google Code was awesome.\nNow we see how cool it is that the data is open. People like Jacob Seidelin are doing interesting things with it.\nIn this case, Jacob has created amazing visualizations of [...]', 'http://feeds.feedburner.com/~r/ajaxian/~3/338056445/radiohead-open-data-javascript-canvas-visualizations-of-their-work', 1, 0, 1216301709, 0, 0, 1, 1, 0, NULL, NULL);
INSERT INTO {PREFIX}_article (article_id, cat_id, meta_keywords, meta_desc, topic_id, thumb_large, thumb_small, thumb_icon, title, content_desc, content_url, poster_id, checker_id, posted_date, is_hot, article_type, page_counter, enabled, archived, rating_marks, rating_count) VALUES (51, 4, '', '', 0, '', '', '', 'Defender of the Favicon', 'Mathieu Henri saw Scott Schiller''s generated favicons VU meter and wanted to "push the concept of generated favicons further and pack a thrilling retro shooter in 16Ã—16 pixels using JavaScript, canvas and data: URIs."\nWow. He went and did it. The entire game runs in the favicon!\n\nDEFENDER of the favicon was done in 3 nights, from [...]', 'http://feeds.feedburner.com/~r/ajaxian/~3/338037753/defender-of-the-favicon', 1, 0, 1216299996, 0, 0, 1, 1, 0, NULL, NULL);
INSERT INTO {PREFIX}_article (article_id, cat_id, meta_keywords, meta_desc, topic_id, thumb_large, thumb_small, thumb_icon, title, content_desc, content_url, poster_id, checker_id, posted_date, is_hot, article_type, page_counter, enabled, archived, rating_marks, rating_count) VALUES (52, 4, '', '', 0, '', '', '', 'A tutorial on Prototype, Google Maps API and the HeatMapAPI', 'Jeffrey Barke has written up a tutorial detailing how to create a density map with Prototype, the Google Maps API and the HeatMapAPI.\nThe heat map API looks cool indeed, and that piece of code looks simple:\nPLAIN TEXT\nJAVASCRIPT:\n\n\n\n\n&#160;\n\n\naddHeatMap: function&#40;&#41; &#123;\n\n\nvar heatMap = new GEOHeatmap&#40;&#41;;\n\n\nheatMap.Init&#40;this.width, this.height&#41;;\n\n\nheatMap.SetData&#40;this.data&#41;;\n\n\nvar preUrl = heatMap.GetURL&#40;&#41;;\n\n\nvar heatmapOverlay = new HMGoogleOverlay&#40;preUrl&#41;;\n\n\nthis.map.addOverlay&#40;heatmapOverlay&#41;;\n\n\n&#125;\n\n\n&#160;', 'http://feeds.feedburner.com/~r/ajaxian/~3/337975278/a-tutorial-on-prototype-google-maps-api-and-the-heatmapapi', 1, 0, 1216294364, 0, 0, 1, 1, 0, NULL, NULL);
INSERT INTO {PREFIX}_article (article_id, cat_id, meta_keywords, meta_desc, topic_id, thumb_large, thumb_small, thumb_icon, title, content_desc, content_url, poster_id, checker_id, posted_date, is_hot, article_type, page_counter, enabled, archived, rating_marks, rating_count) VALUES (53, 4, '', '', 0, '', '', '', 'IEPNGFix 2: Now supports CSS background position and repeat', 'Ah the age old IEPNGFix solution to the problem that we had with IE 5.5 / 6.0 not supporting alpha transparency. The first IEPNGFix solved the problem:\n\nThis script adds near-native PNG support with alpha opacity to IE 5.5 and 6. Now you can have full translucency and no more ugly grey borders! It requires only [...]', 'http://feeds.feedburner.com/~r/ajaxian/~3/337893891/iepngfix-2-now-supports-css-background-position-and-repeat', 1, 0, 1216286422, 0, 0, 1, 1, 0, NULL, NULL);
INSERT INTO {PREFIX}_article (article_id, cat_id, meta_keywords, meta_desc, topic_id, thumb_large, thumb_small, thumb_icon, title, content_desc, content_url, poster_id, checker_id, posted_date, is_hot, article_type, page_counter, enabled, archived, rating_marks, rating_count) VALUES (54, 4, '', '', 0, '', '', '', 'Building a better ActionScript', 'Colin Moock has been creating some buzz in the Flash community with his article on the charges against ActionScript 3.0:\n\nThe removal of on()/onClipEvent() from Flash CS3 makes creating simple interactivity hard.\nGetting rid of loaded .swf files is hard.\nCasting DisplayObject.parent makes controlling parent movie clips hard.\nThe removal of getURL() makes linking hard.\nThe removal of loadMovie() makes [...]', 'http://feeds.feedburner.com/~r/ajaxian/~3/337787107/building-a-better-actionscript', 1, 0, 1216275499, 0, 0, 1, 1, 0, NULL, NULL);
INSERT INTO {PREFIX}_article (article_id, cat_id, meta_keywords, meta_desc, topic_id, thumb_large, thumb_small, thumb_icon, title, content_desc, content_url, poster_id, checker_id, posted_date, is_hot, article_type, page_counter, enabled, archived, rating_marks, rating_count) VALUES (55, 4, '', '', 0, '', '', '', 'Dojo Grid Widget Updated. Data Integration and Editing Improvements.', 'Dojo developers will be pleased to read about the recent update to the Dojo grid control. Version 1.2 of the grid control focuses primarily on improving integration with Dojo data stores, improved grid layout handling and providing advanced in-place editing capabilities. The update was fairly extensive forcing the team to rethink the design of the [...]', 'http://feeds.feedburner.com/~r/ajaxian/~3/337055310/dojo-grid-widget-updated-data-integration-and-editing-improvements', 1, 0, 1216213215, 0, 0, 1, 1, 0, NULL, NULL);
INSERT INTO {PREFIX}_article (article_id, cat_id, meta_keywords, meta_desc, topic_id, thumb_large, thumb_small, thumb_icon, title, content_desc, content_url, poster_id, checker_id, posted_date, is_hot, article_type, page_counter, enabled, archived, rating_marks, rating_count) VALUES (56, 4, '', '', 0, '', '', '', 'Mozilla Labs is Ubiquitous', 'The Humanized folk who now work in Mozilla Labs have taken their Enso work and created Ubiquity, a Firefox plugin that implements the Graphical Keyboard User Interface:\n\nWeb applications, much the same as desktop applications, are a bit like isolated cities: itâ€™s difficult for an end-user to arbitrarily share data and functionality between them. This is [...]', 'http://feeds.feedburner.com/~r/ajaxian/~3/337041476/mozilla-labs-is-ubiquitous', 1, 0, 1216212568, 0, 0, 1, 1, 0, NULL, NULL);
INSERT INTO {PREFIX}_article (article_id, cat_id, meta_keywords, meta_desc, topic_id, thumb_large, thumb_small, thumb_icon, title, content_desc, content_url, poster_id, checker_id, posted_date, is_hot, article_type, page_counter, enabled, archived, rating_marks, rating_count) VALUES (57, 4, '', '', 0, '', '', '', 'IE8 HTML 5 Ajax Page Navigations', 'Sharath Udupa, an IE developer at Microsoft has posted on the IE 8 page navigations feature:\n\nIn IE8 mode, we provide support for script to update the travel log components (for e.g. back/forward buttons, address bar) to reflect client-side updates to documents. This allows a better user experience where users can navigate back and forth without [...]', 'http://feeds.feedburner.com/~r/ajaxian/~3/337014601/ie8-html-5-ajax-page-navigations', 1, 0, 1216209986, 0, 0, 1, 1, 0, NULL, NULL);
INSERT INTO {PREFIX}_article (article_id, cat_id, meta_keywords, meta_desc, topic_id, thumb_large, thumb_small, thumb_icon, title, content_desc, content_url, poster_id, checker_id, posted_date, is_hot, article_type, page_counter, enabled, archived, rating_marks, rating_count) VALUES (58, 4, '', '', 0, '', '', '', 'Live Scrolling via Ext\'s LiveDataPanel Widget', 'Many developers really like the live scrolling functionality popularized by DZone. As you scroll down the page, a XHR call is made which pulls back data and instantly refreshes and allows you to continue to scroll down almost endlessly. Aaron Conran has built a widget for the Ext JS library which provides this functionality in [...]', 'http://feeds.feedburner.com/~r/ajaxian/~3/337010996/live-scrolling-via-exts-livedatapanel-widget', 1, 0, 1216209609, 0, 0, 1, 1, 0, NULL, NULL);
INSERT INTO {PREFIX}_article (article_id, cat_id, meta_keywords, meta_desc, topic_id, thumb_large, thumb_small, thumb_icon, title, content_desc, content_url, poster_id, checker_id, posted_date, is_hot, article_type, page_counter, enabled, archived, rating_marks, rating_count) VALUES (59, 4, '', '', 0, '', '', '', 'PubTools Search: Fast client-side searching with Gears', 'Brad Neuberg has built a very easy to use client side search tool called PubTools Search using Gears. The project is open source and provides a great avenue to share knowledge on Gears itself.\nTo accompany the code, Brad wrote a detailed article:\n\nDid you know that you can use Gearsto do fast, client-side searching of data, [...]', 'http://feeds.feedburner.com/~r/ajaxian/~3/336144509/pubtools-search-fast-client-side-searching-with-gears', 1, 0, 1216132666, 0, 0, 1, 1, 0, NULL, NULL);
INSERT INTO {PREFIX}_article (article_id, cat_id, meta_keywords, meta_desc, topic_id, thumb_large, thumb_small, thumb_icon, title, content_desc, content_url, poster_id, checker_id, posted_date, is_hot, article_type, page_counter, enabled, archived, rating_marks, rating_count) VALUES (60, 4, '', '', 0, '', '', '', 'Paint Servers: SVG and Canvas', 'Robert O''Callahan and Dave Hyatt have been chatting about paint servers as Robert creates SVG ones and then arbitary elements.\nThis continues the meme of taking common use cases and making them easy via CSS (e.g. reflections).\nHere is the SVG version:\nPLAIN TEXT\nHTML:\n\n\n\n\n&#160;\n\n\n&#60;html xmlns="http://www.w3.org/1999/xhtml"\n\n\n&#160; &#160; &#160;xmlns:svg="http://www.w3.org/2000/svg"&#62;\n\n\n&#60;head&#62;\n\n\n&#60;style&#62;\n\n\nh1 { background:url(#h); }\n\n\np { background:url(#p); }\n\n\nspan { background:url(#h); }\n\n\n&#60;/style&#62;\n\n\n&#60;/head&#62;\n\n\n&#60;body&#62;\n\n\n&#160; &#60;h1 style="width:95%;"&#62;Heading&#60;/h1&#62;\n\n\n&#160; [...]', 'http://feeds.feedburner.com/~r/ajaxian/~3/336049168/paint-servers-svg-and-canvas', 1, 0, 1216125610, 0, 0, 1, 1, 0, NULL, NULL);
INSERT INTO {PREFIX}_article (article_id, cat_id, meta_keywords, meta_desc, topic_id, thumb_large, thumb_small, thumb_icon, title, content_desc, content_url, poster_id, checker_id, posted_date, is_hot, article_type, page_counter, enabled, archived, rating_marks, rating_count) VALUES (61, 4, '', '', 0, '', '', '', 'XBL 2: The component model is coming to WebKit and Gecko', 'Wouldn''t it be nice if we actually had a decent component model? Instead of making JavaScript frameworks have to mess around and try to create one on top of the crud they have to deal with?\nThis is what XBL 2.0 is all about. I talked about XBL in one of my Web Archeology posts, and [...]', 'http://feeds.feedburner.com/~r/ajaxian/~3/336038696/xbl-2-the-component-model-is-coming-to-webkit-and-gecko', 1, 0, 1216124629, 0, 0, 1, 1, 0, NULL, NULL);

DROP TABLE IF EXISTS {PREFIX}_article_page;
CREATE TABLE {PREFIX}_article_page (
  page_id int(11) unsigned NOT NULL auto_increment,
  article_id int(11) unsigned NOT NULL,
  used_files varchar(255) default NULL,
  page_title varchar(255) NOT NULL,
  page_order int(11) unsigned NOT NULL default '1',
  page_enabled tinyint(1) unsigned NOT NULL default '0',
  PRIMARY KEY  (page_id),
  FULLTEXT KEY page_title (page_title)
);

ALTER TABLE {PREFIX}_article_page TYPE = MYISAM;
ALTER TABLE {PREFIX}_article_page ADD FULLTEXT (page_title);

INSERT INTO {PREFIX}_article_page (page_id, article_id, used_files, page_title, page_order, page_enabled) VALUES (16, 16, '', 'Will the iPhone Kill Radio? Will Qik Kill the Competition? (video)', 1, 1);
INSERT INTO {PREFIX}_article_page (page_id, article_id, used_files, page_title, page_order, page_enabled) VALUES (15, 15, '', 'Facebook Updates Platform Policies and Issues Ultimatum to Developers', 1, 1);
INSERT INTO {PREFIX}_article_page (page_id, article_id, used_files, page_title, page_order, page_enabled) VALUES (14, 14, '', 'Will FriendFeed Forever Be a Niche Service?', 1, 1);
INSERT INTO {PREFIX}_article_page (page_id, article_id, used_files, page_title, page_order, page_enabled) VALUES (13, 13, '', 'Favtape Creates Mixtapes from Your Pandora and Last.fm Accounts', 1, 1);
INSERT INTO {PREFIX}_article_page (page_id, article_id, used_files, page_title, page_order, page_enabled) VALUES (12, 12, '', 'e-Gold Founders Face Prison for Money Laundering', 1, 1);
INSERT INTO {PREFIX}_article_page (page_id, article_id, used_files, page_title, page_order, page_enabled) VALUES (17, 17, '', 'Ori Brafman, Co-Author of \'Sway\' Live Q&A Tuesday at 2pm PDT', 1, 1);
INSERT INTO {PREFIX}_article_page (page_id, article_id, used_files, page_title, page_order, page_enabled) VALUES (18, 18, '', 'Docoloco Simplifies Location-Based Recommendations (The Startup Review)', 1, 1);
INSERT INTO {PREFIX}_article_page (page_id, article_id, used_files, page_title, page_order, page_enabled) VALUES (19, 19, '', 'Web Directions Hits Sydney in September', 1, 1);
INSERT INTO {PREFIX}_article_page (page_id, article_id, used_files, page_title, page_order, page_enabled) VALUES (20, 20, '', 'Is Internet Radio on its Last Legs?', 1, 1);
INSERT INTO {PREFIX}_article_page (page_id, article_id, used_files, page_title, page_order, page_enabled) VALUES (21, 21, '', 'GoDaddy on .ME: \'The Most Successful New Domain Launch in History\'', 1, 1);
INSERT INTO {PREFIX}_article_page (page_id, article_id, used_files, page_title, page_order, page_enabled) VALUES (22, 22, '', 'The Dark Knight: 25 Sites to Expand Your Batman Knowledge', 1, 1);
INSERT INTO {PREFIX}_article_page (page_id, article_id, used_files, page_title, page_order, page_enabled) VALUES (23, 23, '', 'A Conversation with Widget Provider Outbrain (Israel Media Tour)', 1, 1);
INSERT INTO {PREFIX}_article_page (page_id, article_id, used_files, page_title, page_order, page_enabled) VALUES (24, 24, '', 'Mashable\'s Guide to Conferences and Events', 1, 1);
INSERT INTO {PREFIX}_article_page (page_id, article_id, used_files, page_title, page_order, page_enabled) VALUES (25, 25, '', 'AdBrite Launches Behavioral Targetting Network', 1, 1);
INSERT INTO {PREFIX}_article_page (page_id, article_id, used_files, page_title, page_order, page_enabled) VALUES (26, 26, '', 'Icahn Settles For Three Seats on Yahoo\'s Board', 1, 1);
INSERT INTO {PREFIX}_article_page (page_id, article_id, used_files, page_title, page_order, page_enabled) VALUES (27, 27, '', 'Jajah Now Comes with a Personal Assistant', 1, 1);
INSERT INTO {PREFIX}_article_page (page_id, article_id, used_files, page_title, page_order, page_enabled) VALUES (28, 28, '', 'How To Make Your Users Hate You', 1, 1);
INSERT INTO {PREFIX}_article_page (page_id, article_id, used_files, page_title, page_order, page_enabled) VALUES (29, 29, '', 'iLike Offers Free Full Track Streaming and Announces New Ad Platform', 1, 1);
INSERT INTO {PREFIX}_article_page (page_id, article_id, used_files, page_title, page_order, page_enabled) VALUES (30, 30, '', 'Minted Launches with Threadless-like Approach to Stationary Design', 1, 1);
INSERT INTO {PREFIX}_article_page (page_id, article_id, used_files, page_title, page_order, page_enabled) VALUES (31, 31, '', 'San Francisco: Tune Your TVs to SummerMash SF', 1, 1);
INSERT INTO {PREFIX}_article_page (page_id, article_id, used_files, page_title, page_order, page_enabled) VALUES (32, 32, '', 'Facebook\'s Beta Re-Design Officially Launches at new.facebook.com', 1, 1);
INSERT INTO {PREFIX}_article_page (page_id, article_id, used_files, page_title, page_order, page_enabled) VALUES (33, 33, '', 'Adobe Target FreshAIRapps Officially Moves to a New Home', 1, 1);
INSERT INTO {PREFIX}_article_page (page_id, article_id, used_files, page_title, page_order, page_enabled) VALUES (34, 34, '', 'NYT Pushing Back at WSJ With Boost to Business Coverage', 1, 1);
INSERT INTO {PREFIX}_article_page (page_id, article_id, used_files, page_title, page_order, page_enabled) VALUES (35, 35, '', 'studiVZ Claims Facebook Suit is Meritless', 1, 1);
INSERT INTO {PREFIX}_article_page (page_id, article_id, used_files, page_title, page_order, page_enabled) VALUES (36, 36, '', 'MixTurtle Music Search Is Fast. Real Fast.', 1, 1);
INSERT INTO {PREFIX}_article_page (page_id, article_id, used_files, page_title, page_order, page_enabled) VALUES (37, 37, '', 'Some Startups Just Don\'t Need Starting', 1, 1);
INSERT INTO {PREFIX}_article_page (page_id, article_id, used_files, page_title, page_order, page_enabled) VALUES (38, 38, '', 'Facebook Sets Second Redesign Launch Attempt for Tonight', 1, 1);
INSERT INTO {PREFIX}_article_page (page_id, article_id, used_files, page_title, page_order, page_enabled) VALUES (39, 39, '', 'Why Does The Industry Standard Think Podcasting is Failing?', 1, 1);
INSERT INTO {PREFIX}_article_page (page_id, article_id, used_files, page_title, page_order, page_enabled) VALUES (40, 40, '', 'Lesson Writer Helps Teachers Quickly Conquer an Often Menial Task', 1, 1);
INSERT INTO {PREFIX}_article_page (page_id, article_id, used_files, page_title, page_order, page_enabled) VALUES (41, 41, '', 'Rediff Follows Facebook\'s Lead With Its Own Platform Launch', 1, 1);
INSERT INTO {PREFIX}_article_page (page_id, article_id, used_files, page_title, page_order, page_enabled) VALUES (42, 42, '', 'WebMonkey\'s Five Best Firebug Extensions', 1, 1);
INSERT INTO {PREFIX}_article_page (page_id, article_id, used_files, page_title, page_order, page_enabled) VALUES (43, 43, '', 'Increase DOM Node Insertion Performance', 1, 1);
INSERT INTO {PREFIX}_article_page (page_id, article_id, used_files, page_title, page_order, page_enabled) VALUES (44, 44, '', 'iPhone Native Apps vs. iPhone Web Apps', 1, 1);
INSERT INTO {PREFIX}_article_page (page_id, article_id, used_files, page_title, page_order, page_enabled) VALUES (45, 45, '', 'jQuery: Sparklines Plug-in', 1, 1);
INSERT INTO {PREFIX}_article_page (page_id, article_id, used_files, page_title, page_order, page_enabled) VALUES (46, 46, '', 'Firebug to get a boost', 1, 1);
INSERT INTO {PREFIX}_article_page (page_id, article_id, used_files, page_title, page_order, page_enabled) VALUES (47, 47, '', 'Lightweight Grid Control for jQuery', 1, 1);
INSERT INTO {PREFIX}_article_page (page_id, article_id, used_files, page_title, page_order, page_enabled) VALUES (48, 48, '', 'Reduce, Reuse, Recycle your code', 1, 1);
INSERT INTO {PREFIX}_article_page (page_id, article_id, used_files, page_title, page_order, page_enabled) VALUES (49, 49, '', 'Semantic Constructors', 1, 1);
INSERT INTO {PREFIX}_article_page (page_id, article_id, used_files, page_title, page_order, page_enabled) VALUES (50, 50, '', 'Radiohead + Open Data = JavaScript + Canvas Visualizations of their work', 1, 1);
INSERT INTO {PREFIX}_article_page (page_id, article_id, used_files, page_title, page_order, page_enabled) VALUES (51, 51, '', 'Defender of the Favicon', 1, 1);
INSERT INTO {PREFIX}_article_page (page_id, article_id, used_files, page_title, page_order, page_enabled) VALUES (52, 52, '', 'A tutorial on Prototype, Google Maps API and the HeatMapAPI', 1, 1);
INSERT INTO {PREFIX}_article_page (page_id, article_id, used_files, page_title, page_order, page_enabled) VALUES (53, 53, '', 'IEPNGFix 2: Now supports CSS background position and repeat', 1, 1);
INSERT INTO {PREFIX}_article_page (page_id, article_id, used_files, page_title, page_order, page_enabled) VALUES (54, 54, '', 'Building a better ActionScript', 1, 1);
INSERT INTO {PREFIX}_article_page (page_id, article_id, used_files, page_title, page_order, page_enabled) VALUES (55, 55, '', 'Dojo Grid Widget Updated. Data Integration and Editing Improvements.', 1, 1);
INSERT INTO {PREFIX}_article_page (page_id, article_id, used_files, page_title, page_order, page_enabled) VALUES (56, 56, '', 'Mozilla Labs is Ubiquitous', 1, 1);
INSERT INTO {PREFIX}_article_page (page_id, article_id, used_files, page_title, page_order, page_enabled) VALUES (57, 57, '', 'IE8 HTML 5 Ajax Page Navigations', 1, 1);
INSERT INTO {PREFIX}_article_page (page_id, article_id, used_files, page_title, page_order, page_enabled) VALUES (58, 58, '', 'Live Scrolling via Ext\'s LiveDataPanel Widget', 1, 1);
INSERT INTO {PREFIX}_article_page (page_id, article_id, used_files, page_title, page_order, page_enabled) VALUES (59, 59, '', 'PubTools Search: Fast client-side searching with Gears', 1, 1);
INSERT INTO {PREFIX}_article_page (page_id, article_id, used_files, page_title, page_order, page_enabled) VALUES (60, 60, '', 'Paint Servers: SVG and Canvas', 1, 1);
INSERT INTO {PREFIX}_article_page (page_id, article_id, used_files, page_title, page_order, page_enabled) VALUES (61, 61, '', 'XBL 2: The component model is coming to WebKit and Gecko', 1, 1);

DROP TABLE IF EXISTS {PREFIX}_article_page_content;
CREATE TABLE {PREFIX}_article_page_content (
  page_id int(11) unsigned NOT NULL,
  article_id int(11) unsigned NOT NULL,
  content_detail mediumtext,
  author varchar(128) default NULL,
  PRIMARY KEY  (page_id),
  FULLTEXT KEY content_detail (content_detail,author)
);

ALTER TABLE {PREFIX}_article_page_content TYPE = MYISAM;
ALTER TABLE {PREFIX}_article_page_content ADD FULLTEXT (content_detail, author);

INSERT INTO {PREFIX}_article_page_content (page_id, article_id, content_detail, author) VALUES (14, 14, '&lt;P&gt;Just to get this out of the way right from the start– I am a big fan of&lt;A title=FriendFeed href=&quot;http://friendfeed.com/&quot; target=_blank&gt;FriendFeed&lt;/A&gt;. It is one of the primary tools I use every day as a blogger. It is a tool that I would sorely miss if it ever went away for whatever reason. That said I don\'t think that FriendFeed as it is now will ever make it past being an excellent niche service and into the eyes of the mainstream Web user.&lt;/P&gt;\r\n&lt;P&gt;There are several reasons I suggest this. The primary reason being the overall user interface experience for anyone coming to FriendFeed for the first time. When you look at the FriendFeed page for the first time it looks extremely bland and to a certain point it is confusing to figure out what is actually being displayed there for you. With the first cursory glance it is very hard to tell what are actually separate items as there are no distinct or even subtle dividing lines between the individual posted items.&lt;/P&gt;\r\n&lt;P&gt;The main posted items are indicated by their associated service icons and then any comments made by FriendFeed readers appear below the main item but slightly indented which does help show that they are a part of the posted item as opposed to new items of their own. The one problem though with the comments themselves is that there is no way to tell if they are an actual comment on the posted item or a reply to a comments which can be rather confusing and make following a conversation rather difficult.&lt;/P&gt;\r\n&lt;P&gt;While it is easy to see that the UI design has been influenced by the FriendFeed team members\' previous lives at Google the fact is that after a while the content all seems to blend together. For new users this could be rather disconcerting and discourage them from taking part in posting to and commenting on items in FriendFeed.&lt;/P&gt;\r\n&lt;P&gt;One other area that could really discourage new users is that FriendFeed is the current hot playground for the tech early adopters and as such much of the conversation is about FriendFeed itself and some of the other early adopter favorites like&lt;A title=Twitter href=&quot;http://twitter.com/&quot; target=_blank&gt;Twitter&lt;/A&gt;. This has to a point created an atmosphere that average users coming to the service may find rather irritating and as a result might not want to stick around because.&lt;/P&gt;\r\n&lt;P&gt;The one other thing that might discourage new users is the fact that FriendFeed is by its very nature an aggregator of a person\'s online activity across multiple services. Right now FriendFeed supports the importing of some 35 different online services which for those of us who live and breath technology is a real boon. How does this translate though to the average person who might have only one or two online services that they use on a regular basis. As handy as a service like FriendFeed might be for tech bloggers one has to wonder even going forward just how helpful this aggregation is going to be for average Web users.&amp;nbsp;&lt;/P&gt;\r\n&lt;P&gt;Now mind you, they say that imitation is the best form of flattery and as Mashable\'s Adam Ostrow pointed out to me in a conversation this morning, the new Facebook is basically a copy of FriendFeed. You can read&lt;A title=&quot;Facebook\'s Beta Re-Design Officially Launches at new.facebook.com&quot; href=&quot;http://mashable.com/2008/07/20/new-facebook-launches/&quot;&gt;his review of the Facebook revamp here&lt;/A&gt;. If this is the case then maybe the ideas of FriendFeed are translatable to more mainstream social networks, but given the way that FriendFeed is currently designed and used I don\'t see it catching on with mainstream users in the same way.&lt;/P&gt;\r\n&lt;P&gt;---Related Articles at Mashable! - The Social Networking Blog:&lt;A href=&quot;http://mashable.com/2008/05/22/friendfeed-room/&quot;&gt;FriendFeed Launches Rooms. Moving Towards Semantic Web?&lt;/A&gt;&lt;A href=&quot;http://mashable.com/2008/03/17/friendfeed-search/&quot;&gt;FriendFeed Launches Search&lt;/A&gt;&lt;A href=&quot;http://mashable.com/2007/10/01/friendfeed/&quot;&gt;Former Googlers Team Up to Launch FriendFeed&lt;/A&gt;&lt;A href=&quot;http://mashable.com/2008/02/25/friendfeed-funded/&quot;&gt;FriendFeed Gets $5M, Launches to the Public&lt;/A&gt;&lt;A href=&quot;http://mashable.com/2008/02/14/friendfeed-recommendations/&quot;&gt;FriendFeed Recommendations? Who Are You Likely to Like?&lt;/A&gt;&lt;A href=&quot;http://mashable.com/2008/06/06/friendfeed-adds-summaries/&quot;&gt;FriendFeed Adds Summaries&lt;/A&gt;&lt;A href=&quot;http://mashable.com/2008/05/16/friendfeed-does-it-enrich-the-conversation-or-add-to-the-noise/&quot;&gt;FriendFeed - Does It Enrich The Conversation Or Add To The Noise?&lt;/A&gt;&lt;/P&gt;&lt;IMG alt=&quot;&quot; src=&quot;http://mashable.com/wp-content/uploads/2007/10/friendfeed-logo.gif&quot;&gt;', 'Mashable!');
INSERT INTO {PREFIX}_article_page_content (page_id, article_id, content_detail, author) VALUES (15, 15, '&lt;P&gt;Fresh on the heels of rolling out the public beta for its&lt;A href=&quot;http://mashable.com/2008/07/20/new-facebook-launches/&quot;&gt;newly designed homepage and user profiles&lt;/A&gt;, Facebook has issued a new set of policies for application developers, many of which are related specifically to the site changes.&lt;/P&gt;\r\n&lt;P&gt;The changes are clearly aimed at further reducing spam and unwanted application invites and notifications, Facebook is also making clear that the new profile features are not fresh real estate for developers to place ads. According to the&lt;A href=&quot;http://developers.facebook.com/news.php?blog=1&amp;amp;story=137&quot; target=_blank&gt;Facebook Developer Blog&lt;/A&gt;,“advertising cannot appear on the newly launched features that deeply integrate into profiles (tabs, Publisher, and application info sections). Developers can continue to run advertising on canvas pages and monetize their applications in other ways.”&lt;/P&gt;\r\n&lt;P&gt;Facebook sounds like it isn\'t messing around with enforcing the new rules either. They are giving developers until August 11th to comply with the guidelines, at which point enforcement will begin, which we assume means the suspension of applications that don\'t meet Facebook\'s standards at that point.&lt;/P&gt;\r\n&lt;P&gt;The updated guidelines are available on the&lt;A href=&quot;http://wiki.developers.facebook.com/index.php/Platform_Policy#5._Feed&quot; target=_blank&gt;Platform Policy wiki&lt;/A&gt;.&lt;/P&gt;\r\n&lt;P&gt;&lt;A class=tradevibes_show_widget href=&quot;http://www.tradevibes.com/company/profile/facebook&quot;&gt;Facebook&lt;/A&gt;company profile provided by&lt;A class=tradevibes_home href=&quot;http://www.tradevibes.com/&quot;&gt;TradeVibes&lt;/A&gt;&lt;/P&gt;\r\n&lt;P&gt;---Related Articles at Mashable! - The Social Networking Blog:&lt;A href=&quot;http://mashable.com/2008/01/15/facebook-feed-rank/&quot;&gt;Facebook Adds More Feed Ranking&lt;/A&gt;&lt;A href=&quot;http://mashable.com/2007/10/12/linkedin-platform/&quot;&gt;LinkedIn Outlines Strategy for Upcoming Platform&lt;/A&gt;&lt;A href=&quot;http://mashable.com/2007/10/09/facebook-apps-growth/&quot;&gt;Facebook Apps Contribute 37% of Recent Growth&lt;/A&gt;&lt;A href=&quot;http://mashable.com/2007/09/10/facebook-platform-down/&quot;&gt;Facebook Platform Down&lt;/A&gt;&lt;A href=&quot;http://mashable.com/2007/06/17/facebook-attracts-developers/&quot;&gt;Facebook Platform Lures In 1,000 Developers a Day&lt;/A&gt;&lt;A href=&quot;http://mashable.com/2008/06/02/facebook-platform-open-source/&quot;&gt;Facebook Platform Goes Open Source&lt;/A&gt;&lt;A href=&quot;http://mashable.com/2007/07/19/facebook-parakey/&quot;&gt;Breaking: Facebook Acquires Firefox Founders\' Startup Parakey&lt;/A&gt;&lt;/P&gt;&lt;IMG alt=&quot;&quot; src=&quot;http://www.mashable.com/images/facebooklogofresh.PNG&quot;&gt;', 'Mashable!');
INSERT INTO {PREFIX}_article_page_content (page_id, article_id, content_detail, author) VALUES (13, 13, '&lt;P&gt;&lt;A href=&quot;http://favtape.com/&quot; target=_blank&gt;Favtape&lt;/A&gt;is another new mixtape creation site, but its standout feature is its automation process, which creates a mixtape based off songs you\'ve listened to on&lt;A href=&quot;http://www.pandora.com/&quot; target=_blank&gt;Pandora&lt;/A&gt;, or those you\'ve favorited on&lt;A href=&quot;http://www.last.fm/&quot; target=_blank&gt;Last.fm&lt;/A&gt;. Provide Favtape with your Pandora URL or your Last.fm username, and a mixtape will automatically be created for you with a unique URL that can be accessed anytime.&lt;/P&gt;\r\n&lt;P&gt;The mixtape itself consists of 10 songs, which appear to be the most recent from your Pandora or Last.fm activity. For each song on your mixtape, you\'ll have several options– play the song, purchase it on iTunes or Amazon, see the lyrics, nab a ringtone (provided by Flycell), share the song, or receive more songs based on the artist or on similar tracks. There\'s also the ability to see others\' mixtapes on the site, with voting options intact so you can see the most popular mixtapes created by other users.&lt;/P&gt;\r\n&lt;P&gt;Perhaps the best feature of Favtape is that it takes your&lt;A href=&quot;http://mashable.com/2008/07/09/streaming-music-sites/&quot;&gt;streaming music&lt;/A&gt;from two popular music recommendation engines and offers a place where you can hear the songs on demand, which is something you can\'t readily do on Pandora or Last.fm. The downfall to Favtape\'s particular approach, however, is that its limitation of ten songs acts as a mere snapshot of your account activity on Pandora and Last.fm, and despite the additional options on Favtape, there\'s not much you can do to turn actions on Favtape directly back into actions within a community network like Last.fm.&lt;/P&gt;\r\n&lt;P&gt;The recommendations on Favtape are also a bit erratic–when clicking on Similar Artists for some musicians, I received only 3 song titles from the same artist, and when I clicked“play” to actually hear some of the songs, they turned out to be songs from entirely unrelated artists. Yet clicking on Similar Artists for other musicians, I received 100 recommendations from a variety of singers.&lt;/P&gt;\r\n&lt;P&gt;Even with these particular quirks, I think it would be quite useful to have a way for your actions on Favtape be turned directly into further recommendations on other sites where you already have an established profile, so the results of using Favtape can become more long-lasting.&lt;/P&gt;&lt;IMG alt=&quot;&quot; src=&quot;http://mashable.com/wp-content/uploads/2008/07/favtape-logo.png&quot;&gt;', 'Mashable!');
INSERT INTO {PREFIX}_article_page_content (page_id, article_id, content_detail, author) VALUES (12, 12, '&lt;P&gt;&lt;A href=&quot;http://e-gold.com/&quot;&gt;&lt;/A&gt;&lt;/P&gt;\r\n&lt;P&gt;Everyone knows who PayPal is.&amp;nbsp; Do you know who competes against PayPal (and I use this term very loosely, since they dominate the market)? I did a search just a few minutes to see who\'s in business still, and which ones have gone by the wayside. It\'s a volatile market - very few companies that start up in that space are reputable, or if they are they aren\'t well funded enough to stay in business until they gain traction.&lt;/P&gt;\r\n&lt;P&gt;&lt;A href=&quot;http://mashable.com/wp-content/uploads/2008/07/e-gold-blah.jpg&quot;&gt;&lt;/A&gt;In fact, most of them are so obscure or little known that the closes thing to a list post of PayPal alternatives here at Mashable is a post&lt;A href=&quot;http://mashable.com/2006/07/06/ebay-bans-google-checkout-why&quot;&gt;Pete put out back in 2006&lt;/A&gt;, where he re-published a list of banned eBay alternative payment methods (imagine that - a list we haven\'t done yet!).&lt;/P&gt;\r\n&lt;P&gt;One company that has stood the test of time in this space is E-Gold - at least up until now.&lt;/P&gt;\r\n&lt;P&gt;&lt;A href=&quot;http://www.pcworld.com/businesscenter/article/148720/internet_currency_firm_pleads_guilty_to_money_laundering.html&quot;&gt;PC World is reporting&lt;/A&gt;that the founders of the company are facing serious jail time due to“design flaws” in the e-Gold system.&amp;nbsp; E-Gold was an odd system, even by the measure of Internet pay systems.&amp;nbsp; It required you to purchase actual gold and have it stored in an e-Gold certified vault.&amp;nbsp; From there, you could spend and accept e-Gold currency as you wished with other participating vendors.&lt;/P&gt;\r\n&lt;P&gt;Unfortunately for e-Gold, due to the PayPal/eBay stranglehold on the Internet marketplace, it was next to impossible to propogate usage through legitimate business development means. When multi-level marketeers and their cousins the ponzis schemers started using e-Gold for their business ventures, e-Gold apparently turned a blind eye for as long as they could.&lt;/P&gt;\r\n&lt;P&gt;The problem with letting too much of your business rely on folks who prey on others to make their money is that it\'ll eventually snowball into a mountain of complaints, and as they say:“when you lay down with dogs, you wake up with fleas.”&amp;nbsp; E-Gold may not have been complicit in the quasi-legal schemes of the MLMers and Ponzi schemers, and they may not have wanted to outrightly endorse the schemes, either.&amp;nbsp; Unfortunately, their very prolific usage of their systems turned US federal scrutiny towards the company when e-Gold tried&lt;A href=&quot;http://mashable.com/wp-content/uploads/2008/07/e-gold-aff.jpg&quot;&gt;&lt;/A&gt;to deal with the common problem of refunds, seizures for abuse and account suspensions that accompanies that crowd.&lt;/P&gt;\r\n&lt;P&gt;For allowing them to ply their trade using the e-Gold system, e-Gold founder Douglas Jackson and two senior directors, Barry Downey and Reid Jackson all plead guilty today to the charges related to money laundering (one part of a Ponzi scheme that makes it illegal). The senior directors could face prison sentences of up to 5 years, and Douglas Jackson is looking at 20 years.&lt;/P&gt;\r\n&lt;P&gt;Of course, shady MLMs and illegal Ponzi schemes aren\'t the only things that got them in trouble - they were the gateway drug, so to speak.&amp;nbsp; In order to cater to the userbase, which was primarily this crowd, they had to have loose identity verification standards to open an account with the system.&amp;nbsp; This ended up meaning the system was rife with other illegal activities related to, according to the Department of Justice, child exploitation, investment scams, credit card fraud and identity theft.&lt;/P&gt;\r\n&lt;P&gt;What was the situation that made this possible?&amp;nbsp; We\'re back to eBay\'s stranglehold on the market.&amp;nbsp; When PayPal and eBay ruled online commerce, which was when e-Gold made their stand against them, it was a bleak picture for anyone who tried to compete with them.&amp;nbsp; Now, with all the other commerce going on with alternatives to the largest garage sale on the Internet, a strong business development team could very easily mount an offense without catering to the lowest common denominator.&lt;/P&gt;\r\n&lt;P&gt;There are a number of interesting aspects to the story, and a lot of other systemic flaws that e-Gold even admits to as a company. To start getting into those various problems would require several more blog posts, and would involve a lot of very theoretical talk about virtual economic systems and how they interact with one another on a macro scale (for more on that from the horse\'s mouth, go to&lt;A href=&quot;http://blog.e-gold.com/2008/07/a-new-beginning.html&quot;&gt;e-Gold\'s latest blog post&lt;/A&gt;).&lt;/P&gt;\r\n&lt;P&gt;For those in that business, though, let this be a cautionary tale.&amp;nbsp; I\'ve been around a number of companies who work in this space, and it looks lucrative to cater to the MLMers and look away when you think those programs start to verge on Ponzi schemes. What happened to e-Gold, though, is what success looks like when you go down that path too far.&lt;/P&gt;\r\n&lt;P&gt;---Related Articles at Mashable! - The Social Networking Blog:&lt;A href=&quot;http://mashable.com/2008/07/06/msn-israel/&quot;&gt;Microsoft To Do MSN Israel Solo, Parting Ways With Internet Gold&lt;/A&gt;&lt;A href=&quot;http://mashable.com/2008/04/17/theblackapp/&quot;&gt;TheBlackApp: Because iPhone Users Are Too Good to Shop Like You Do&lt;/A&gt;&lt;A href=&quot;http://mashable.com/2008/01/01/mashable-elitechoice/&quot;&gt;Mashable: a Top Elite Blog for 2007&lt;/A&gt;&lt;A href=&quot;http://mashable.com/2006/06/19/gaia-online-gets-893m-for-anime-community/&quot;&gt;Gaia Online Gets $8.93M for Anime Community&lt;/A&gt;&lt;A href=&quot;http://mashable.com/2008/07/19/scriblink-small-business/&quot;&gt;Scriblink Whiteboard Adds Small Business Dimension&lt;/A&gt;&lt;A href=&quot;http://mashable.com/2007/07/09/simply-hired-rockyou-shelfari-stylefeeder-facebook-apps/&quot;&gt;Simply Hired, RockYou, Shelfari and StyleFeeder Facebook Apps&lt;/A&gt;&lt;A href=&quot;http://mashable.com/2007/10/10/tax-ban-extended/&quot;&gt;Will an Internet Tax Ban Ever Be Permanent?&lt;/A&gt;&lt;/P&gt;&lt;IMG alt=&quot;&quot; src=&quot;http://mashable.com/wp-content/uploads/2008/07/e-gold-logo.gif&quot;&gt;', 'Mashable!');
INSERT INTO {PREFIX}_article_page_content (page_id, article_id, content_detail, author) VALUES (16, 16, '&lt;P&gt;Can a phone kill an industry? What\'s Qik offering, now that they\'re in public beta? These are the questions we tackle on today\'s Mashable Conversations.&amp;nbsp; Sean and I were both intrigued by the fervor and discussion generated around my recent editorial on whether I thought the&lt;A href=&quot;http://mashable.com/2008/07/14/iphone-radio/&quot; target=_self&gt;iPhone would kill terrestrial radio&lt;/A&gt;. The response to the article was thunderous and inconclusive.&amp;nbsp; Just as many folks thought that I was right as thought that terrestrial radio has done a decent enough job of killing itself.&lt;/P&gt;\r\n&lt;P&gt;It\'s a popular topic, too.&amp;nbsp; This weekend\'s Elite Tech News show focused on this topic as well for a good portion of the program, and most of the panel disagreed with me on my hypothesis, though for a number of reasons ranging from&lt;A href=&quot;http://louisgray.com/&quot; target=_blank&gt;Louis Gray&lt;/A&gt;\'s opinion that no technology ever truly kills another to&lt;A href=&quot;http://winextra.com/&quot; target=_blank&gt;Steven Hodson&lt;/A&gt;\'s proposition that mobile smartphone technology will never be truly ubiquitous.&lt;/P&gt;\r\n&lt;P&gt;Sean and I spend a good deal of time hashing out the various thesii put forth here and there before taking some time out to speak with Qik co-founder Bhaskar Roy about today\'s launch of Qik into open beta status.&lt;/P&gt;\r\n&lt;P&gt;He told us about a number of new upgrades that come out with this version of the service, including what was most exciting to us, a number of new distribution partners.&amp;nbsp; As we\'ve talked about before, CoverItLive now supports Qik (amongst a number of other live streaming services), but Qik is now partnered also with Facebook, MySpace and Orkut.&lt;/P&gt;\r\n&lt;P&gt;For the full scoop on all this, watch the podcast below, download the&lt;A href=&quot;http://ads.episodic.com/download/e28/f20/a-conversation-with-bhaskar-roy.mp4&quot; target=_blank&gt;MP4&lt;/A&gt;to your device, or&lt;A href=&quot;http://feeds.feedburner.com/mashableconversations-video&quot;&gt;subscribe to the feed.&lt;/A&gt;&lt;/P&gt;\r\n&lt;P&gt;Never Miss an Episode!&lt;/P&gt;\r\n&lt;P&gt;&lt;A href=&quot;http://feeds.feedburner.com/MashableConversations-Video&quot;&gt;Get the Mashable Conversations podcast here&lt;/A&gt;(video feed).&lt;/P&gt;\r\n&lt;P&gt;&lt;A href=&quot;http://feeds.feedburner.com/MashableConversations&quot;&gt;Get the Mashable Conversations podcast here&lt;/A&gt;(audio feed).&lt;/P&gt;\r\n&lt;P&gt;---Related Articles at Mashable! - The Social Networking Blog:&lt;A href=&quot;http://mashable.com/2007/07/16/iphone-nametag/&quot;&gt;World\'s Simplest iPhone App&lt;/A&gt;&lt;A href=&quot;http://mashable.com/2007/09/19/iphone-germany/&quot;&gt;iPhone to Launch in Germany on T-Mobile&lt;/A&gt;&lt;A href=&quot;http://mashable.com/2007/09/18/iphone-3g/&quot;&gt;3G iPhone Confirmed for 2008&lt;/A&gt;&lt;A href=&quot;http://mashable.com/2007/08/06/mundu-iphone/&quot;&gt;Mundu Optimizes Multi-Client Chat Tool for the iPhone&lt;/A&gt;&lt;A href=&quot;http://mashable.com/2007/10/10/apple-iphone-directory/&quot;&gt;Apple Making a Directory for iPhone Apps?&lt;/A&gt;&lt;A href=&quot;http://mashable.com/2007/06/29/european-iphone-to-be-offered-on-multiple-carriers/&quot;&gt;European iPhone to be Offered on Multiple Carriers&lt;/A&gt;&lt;A href=&quot;http://mashable.com/2007/07/26/iphone-europe-september/&quot;&gt;iPhone. Europe. September.&lt;/A&gt;&lt;/P&gt;&lt;IMG alt=&quot;&quot; src=&quot;http://mashable.com/wp-content/uploads/2008/04/qiklogo.png&quot;&gt;', 'Mashable!');
INSERT INTO {PREFIX}_article_page_content (page_id, article_id, content_detail, author) VALUES (17, 17, '<p>Tomorrow, Tuesday, July 22 at 2:00PM PDT (5:00PM EDT),<a href="http://mashable.com/authors-at-mashable/ori-rom-brafman-sway">Ori Brafman</a>, co-author of Sway, will be chatting live with Authors@Mashable on<a href="http://live.yahoo.com/mashable" target="_blank">Mashable&#8217;s Y! Live channel</a>.</p><p>This is the third installment of our Sway three part series. If you missed the first two be sure to check out Brafman&#8217;s<a href="http://mashable.com/2008/07/15/ori-brafman-introduction-sway/">personal introduction</a>and post on<a href="http://mashable.com/2008/07/18/exploring-vc-irrationality/">VC Irrationality</a>.</p><p>Anyone who has not yet read Sway, can check out the<a href="http://www.docstoc.com/docs/916375/Sway-extract">first chapter for free</a>or purchase it online<a href="http://www.amazon.com/Sway-Irresistible-Pull-Irrational-Behavior/dp/0385524382/">here</a>.</p><p>*The video will be broadcast live on Mashable, but you must log into<a href="http://live.yahoo.com/mashable" target="_blank">Mashable&#8217;s Y! Live Channel</a>to chat with Ori and Rom Brafman.</p><p>---Related Articles at Mashable! - The Social Networking Blog:<a href="http://mashable.com/2008/07/09/authors-at-mashable-series/">New Series: Authors @ Mashable [50 Book Giveaway]</a><a href="http://mashable.com/2007/06/21/cyworld-live-chat/">Cyworld Launches Live Chat</a><a href="http://mashable.com/authors-at-mashable/">Authors at Mashable</a><a href="http://mashable.com/2007/12/31/mozilla-live-chat-support/">Mozilla Adds Live Chat Support: Eroding Microsoft&#8217;s Stronghold?</a><a href="http://mashable.com/2008/07/18/exploring-vc-irrationality/">Exploring VC Irrationality [Authors @ Mashable]</a><a href="http://mashable.com/2007/03/26/ivillage-chat/">iVillage Does More Social Stuff - Adds Live Chat</a><a href="http://mashable.com/2007/04/09/xbox-messenger/">Windows Live Messenger Arrives on XBox</a></p><img src="http://mashable.com/wp-content/uploads/2008/07/ylive-sway-brafman.jpg" alt="" />', 'Mashable!');
INSERT INTO {PREFIX}_article_page_content (page_id, article_id, content_detail, author) VALUES (18, 18, '<p>Editor&#8217;s Note: This post is part of an ongoing series at Mashable - The Startup Review, Sponsored by Sun Microsystems Startup Essentials. If you would like to have your startup considered for inclusion, please see the details<a href="http://mashable.com/startup-review-sponsored-sun-startup-essentials/">here</a>.</p><p>STARTUP DETAILS:</p><p>Company Name:<a href="http://www.docoloco.com/" target="_blank">Docoloco</a></p><p>20 word description:   Recommendation lists written by friends and locals. A completely flexible way of sharing local recommendations in a conversational way.</p><p>CEO&#8217;s 100 word description: Docoloco uses very simple interactivity and social network capabilities to make sense of our neighbourhoods and the places in them: the places we love and the places we love to hate.</p><p>People complete short simple sentences to describe a place. The Docoloco system extracts data from those simple sentences and sorts recommendations into rated lists and conversation streams around places, topics and people. You follow topics, people, neighborhoods, or a particular place and Docoloco will keep you posted on new recommendations.</p><p>Docoloco is focused on the Australian Market in the short term but the system is enabled for global use.</p><p>Mashable&#8217;s Take:  Docoloco is a new location-based recommendation system that seeks to simplify the information extraction process.  It does this by offering up a form that&#8217;s really easy to fill out, and your recommendations then act as microblog updates, in a sense.  For example, when making a recommendation on Docoloco you&#8217;ll see that you can fill out a business name, select what type of comment you&#8217;re making about it, and then give your two cents.</p><p>The result is a one sentence blurb on a given business, service or location that would look something like this:&#8220;Tribeca is&#8216;good for&#8217; shopping.&#8221;  The&#8220;good for&#8221; portion of the sentence is what&#8217;s interchangeable from Docoloco&#8217;s standpoint, and you can pick what phrase you&#8217;d like to insert there from a drop down box.  You could instead say that&#8220;Tribeca is&#8216;bad for&#8217; saving money,&#8221; or that&#8220;Tribeca&#8217;sells cheap&#8217; handbags.&#8221;  If you&#8217;d like to add more descriptive content in addition to this one sentence blurb you can write more text or add images as well.</p><p>Similar to<a href="http://mashable.com/2007/03/11/twitter/">Twitter</a>, all of these microblogging recommendations show up in a global feed and a personal feed.  You can follow individual users, areas, businesses or topics.  This allows  you to customize things more so you&#8217;re better able to seek out contextual information instead of merely following other users that may be your friends but have terrible taste in West Loop boutiques.</p><p>Following a topic is easy enough, and it actually operates as an ongoing Q&#038;A that involves the Docoloco community.  If you&#8217;re seeking information and/or recommendations on a particular topic (perhaps you&#8217;d like to find a good cafe for doing work or the best pace on the North side for sushi), then you put in your request and it&#8217;s immediately broadcast throughout Docoloco and automatically added to your Follow list. Any recommendations with relevant content will show up in your subscription feed.</p><p>I do appreciate the simplified manner in which content can be created on Docoloco, and there are even a couple of external publishing features, such as social bookmarking and integration with your own existing blog, that allows your content to be shared beyond the Docoloco site.  But its simple format that somewhat mimics microblogging also makes it a fine candidate for deep mobile integration, which is always a plus when it comes to location-based recommendations.</p><p>Sponsored by<a href="http://www.sun.com/emrkt/startupessentials/join.jsp">Sun Startup Essentials</a><a href="http://www.sun.com/emrkt/startupessentials/join.jsp"></a></p><p><a class="tradevibes_show_widget" href="http://www.tradevibes.com/company/profile/docoloco">Docoloco</a>company profile provided by<a class="tradevibes_home" href="http://www.tradevibes.com/">TradeVibes</a></p><img src="http://mashable.com/wp-content/uploads/2008/07/docoloco-logo.png" alt="" />', 'Mashable!');
INSERT INTO {PREFIX}_article_page_content (page_id, article_id, content_detail, author) VALUES (19, 19, '<p>Returning to Sydney Australia in September for the 5th year,<a href="http://south08.webdirections.org/" rel="nofollow">Web Directions South&#8216;08</a>once again features a two day conference of leading international and local experts in web design and development, two days of in depth workshops, parties, receptions and other networking events. Featured speakers this year include</p><p>Speakers include Jeffrey Veen, Derek Featherstone, Daniel Burka, Douglas Crockford,  Jeff Croft, and Lynne D Johnson, who will cover front and back end web development, web app security, web design, interaction design, and much more.</p><p>Come and join fellow web professionals from all over Australia and all over the world in Sydney.  The conference and expo will be held on September 25th and 26th at the Sydney Convention Centre, Darling Harbour Parkside.  There will be relevant workshops on September 23rd and 24th at the PowerHouse Museum.</p><p>Mashable readers will receive a further $50 off the already great value price, making it just $795 before July 23rd. Just use the code WDS08-Mash when registering.</p><p>---Related Articles at Mashable! - The Social Networking Blog:<a href="http://mashable.com/2008/03/24/south-park-free-episodes/">Watch All South Park Episodes Online for Free</a><a href="http://mashable.com/2008/01/03/askcom-voice-directions/">Ask.com&#8217;s Answer to GOO411? Voice-Activated Directions.</a><a href="http://mashable.com/2007/10/04/live-search-maps/">Live Search Maps to Introduce New Features</a><a href="http://mashable.com/2007/06/03/google-directions-api/">Google Launches Directions API</a><a href="http://mashable.com/2008/04/09/south-park-viral-videos/">Viral Videos Go Berserk, South Park Style!</a><a href="http://mashable.com/2008/02/20/free411-driving-directions/">FREE411 Now Has Voice-Activated Driving Directions</a><a href="http://mashable.com/2007/11/29/mtv-to-give-south-park-episodes-for-free/">MTV To Give South Park Episodes For Free</a></p><img src="http://mashable.com/wp-content/uploads/2008/07/webdirections.jpg" alt="" />', 'Mashable!');
INSERT INTO {PREFIX}_article_page_content (page_id, article_id, content_detail, author) VALUES (20, 20, '<p>Choosing a radio station was once a right of passage for the American adolescence.  It was what bound you to your friends, disassociated you from your parents and attracted to you whatever partner had the misfortune to have you. Regional in range, determined by frequency, traditional radio was completely national in scope, cities to suburbs, Natick to Nashville.  And then, like with the overnight successes the medium helped popularize, everything seemed to decline.</p><p>Traditional radio has been in a steady fall for nearly a decade. While it still remains a 21 billion dollar industry, the time spent listening to radio has fallen somewhere to the tune of 8 percent since 2000, according to<a href="http://www.arbitron.com/home/content.stm" target="_blank">Arbitron</a>, a firm that measure radio audiences. This steady drop in listenership has forced terrestrial radio stations to program music that can appeal to the broadest of audiences, disenfranchising both music fans and emerging artists, and helping to foster the growth of satellite and Internet radio.</p><p>&#8220;Internet radio has redrawn the whole radio landscape,&#8221; said Tim Westergren, a founder of<a href="http://pandora.com/" target="_blank">Pandora</a>, a leading Internet radio company.&#8220;It provides a more fulfilling radio experience and a mass promotion for artists being shut out of terrestrial radio.&#8221;</p><p>The metrics are in agreement with Westergren, Internet radio captures 33 million listeners per week, according to Arbitron, and nearly 15 % of 18 to 49 year olds tune in to Internet radio on a weekly basis. Internet radio companies, such as Pandora,<a href="http://mashable.com/2008/07/13/lastfm-iphone/">Last.fm</a>and<a href="http://www.slacker.com/" target="_blank">Slacker</a>offer a personalized radio experience which gives its listeners access to a greater variety of music and enhanced control over the music being delivered to them. The listening experience is now being offered portably, with Slacker&#8217;s offering a for-sale portable player and Pandora delivering an<a href="http://mashable.com/2008/07/14/iphone-radio/">iPhone application</a>.</p><p>Internet radio might be an even greater bonanza for the working artist.&#8220;For bands that have no shot at traditional radio&#8221;, says radio expert Kurt Hanson,&#8220;it is one way they can expose their music to fans.&#8221; Pandora is home to 60,000 artists, 70% of which aren&#8217;t affiliated with a major label.&#8220;While some bands are still holding out for that elusive deal,&#8221; says Joanna Ifrah, a former artist and repertoire  scout for Columbia and Sony records,&#8220;Many more emerging bands are working their audience, working their Myspace pages, betting on themselves and getting paid.&#8221;</p><p>Artists are working comfortably and profitably outside of major labels, getting airtime through Internet and satellite radio, building audiences through social networks, and further being able to monetize themselves through sites such as Los Angeles based startup<a href="http://www.trueanthem.com/home/" target="_blank">True Anthem</a>. However, major labels are pushing back by influencing<a href="http://www.soundexchange.com/" target="_blank">Soundexchange</a>to refuse to renegotiate royalty rates agreed upon last year that could potentially bankrupt the Internet radio industry.</p><p>While the numbers can be complicated, it comes down to simple metrics; a now profitable Internet radio site will pay royalty rates that exceed total revenue if the current rates negotiated by Soundexchange are upheld. A company like Pandora, which is paying $750,000 per month to Soundexchange under the current rates, would go out of business under the new rates which increase per year retroactively going back to 2006. (Satellites and cable radio settled for 7.5 percent of revenue with Soundexchange). The idea that Internet radio has to pay any royalty rates, while fair to the artists, legally speaking, is laughable.</p><p>Traditional radio doesn&#8217;t pay a dime in royalty rates because it is considered promotional. Has there been a greater promotional tool for an artist since the invention of the barker than the Internet?  Even with the 50% cut that the artist receive from Soundexchange, for the working musician,  according to Hanson, Internet radio is for more valuable developing a fan base than the&#8220;single digit cut they get from royalties.&#8221;  If these rates are enforced and companies like Pandora go out of business, bands that don&#8217;t fit in the broad world of terrestrial radio will have a far more difficult time building a fan base and will lose the revenue stream that is Internet radio.</p><p>While the negotiations between Internet radio and Soundexchange look grim, companies like Pandora aren&#8217;t ready to lower the antennae on Internet radio just yet.</p><p>&#8220;We are going to plow ahead until we reach a reasonable settlement,&#8221; said Westergren.</p><p>---Related Articles at Mashable! - The Social Networking Blog:<a href="http://mashable.com/2007/06/27/emusic-mashups/">eMusic Launches 10 Internet Radio Mashups</a><a href="http://mashable.com/2007/07/12/savenetradio-loses-court-battle/">Another Court Loss for Internet Radio Broadcasters</a><a href="http://mashable.com/2007/04/27/internet-radio-equality-act/">SaveNetRadio Applauds New Bill</a><a href="http://mashable.com/2007/06/21/internet-radio-day-of-silence/">Internet Radio Broadcasters Call for Day of Silence on June 26</a><a href="http://mashable.com/2007/12/14/cbs-radio-online/">CBS Radio Rolling Out More Internet Initiatives</a><a href="http://mashable.com/2007/08/22/soundexchange-2/">Latest Offer from SoundExchange Turned Down by Webcasters</a><a href="http://mashable.com/2007/04/16/radio-webcasts/">Radio Webcasters Lose Court Battle - What Now for Last.fm and Pandora?</a></p><img src="http://mashable.com/wp-content/uploads/2008/07/radio.bmp" alt="" />', 'Mashable!');
INSERT INTO {PREFIX}_article_page_content (page_id, article_id, content_detail, author) VALUES (21, 21, '<p>Talk about bravado.  Four days after launching the .me domain extension and inciting a virtual riot among customers,<a href="http://www.godaddy.com" target="_blank">GoDaddy</a>is toting the success of what it calls“the most successful new domain launch in GoDaddy\'s history.”  The basis for that claim?  More than 20,000 .Me domain names were registered in the first 24 hours of availability, according to the company.</p><p>As we reported last week, the<a href="http://mashable.com/2008/07/17/godaddy-offers-me-domain-names-it%e2%80%99s-a-big-fail-so-far/comment-page-4/#comments">.Me launch was riddled with technical problems</a>, including as many of 8 or 9 people claiming to hold receipts for the domain name Aweso.me.   To its credit, GoDaddy responded quickly to the problems, issuing refunds to effected customers and making personal phone calls to many of them (a voicemail from a GoDaddy rep left with<a href="http://www.marketingpilgrim.com" target="_blank">Andy Beal</a>can be heard<a href="http://www.grandcentral.com/forwarded_messages/?unique_key=3b2355db0750099a22cdb972f0a702b3&#038;mhash=a071ad3dfe894ba8dc1cb9847cd3b053" target="_blank">here</a>).  But that has done little to qualm the anger of many of those that thought they were the new owner of potentially lucrative .Me names.</p><p>In a press release this morning, the company acknowledges the technical issues they encountered upon launch, but actually uses the“it\'s a nice problem to have” cliché, with CEO Bob Parsons stating “In spite of a few early difficulties - GoDaddy.com successfully processed a huge, record-setting level of registrations.  To the best of our knowledge, there have never been more registrations handled in one day during theordinary course of businesses by any registrar in history.&#8221;</p><p>Realistically, I don\'t think there is that much GoDaddy could have done to prevent the issues it encountered as domain speculators raced to buy up premium .Me domains upon launch.  However, given the frustration and confusion caused on launch day, I think the celebration dance would\'ve best been kept internal.</p><p><a class="tradevibes_show_widget" href="http://www.tradevibes.com/company/profile/go-daddy">Go Daddy</a>company profile provided by<a class="tradevibes_home" href="http://www.tradevibes.com/">TradeVibes</a></p><p>---Related Articles at Mashable! - The Social Networking Blog:<a href="http://mashable.com/2007/11/13/godaddy-google/">GoDaddy Integrating Google Webmaster Tools</a><a href="http://mashable.com/2008/03/12/godaddy-poll/">The Daily Poll: What Do You Think of GoDaddy?</a><a href="http://mashable.com/2008/07/17/godaddy-offers-me-domain-names-it%e2%80%99s-a-big-fail-so-far/">GoDaddy Offers .Me Domain Names.  It\'s a Big .Fail So Far.</a><a href="http://mashable.com/2008/03/11/ratemycop-shutdown/">GoDaddy Pulls the Plug on RateMyCop</a><a href="http://mashable.com/2007/01/25/myspace-godaddy/">Who Sucks More - GoDaddy or MySpace?</a><a href="http://mashable.com/2008/03/14/ratemycop-rackspace-censorship/">RackSpace Censorship: The RateMyCop Saga Continues</a><a href="http://mashable.com/2008/03/12/godaddy-revolt/">GoDaddy: You Don&#8217;t Like Them. Can They Redeem Themselves?</a></p><img src="http://mashable.com/wp-content/uploads/2008/03/godaddy.gif" alt="" />', 'Mashable!');
INSERT INTO {PREFIX}_article_page_content (page_id, article_id, content_detail, author) VALUES (22, 22, '<p>In 1939, Bob Kane created&#8220;The Bat-Man&#8221; for issue #27 of Detective Comics, and as they say, the rest is history. This past weekend the highly anticipated film The Dark Knight was released in theaters, setting a record for biggest three-day take with $155.3M in tickets sold. To celebrate we&#8217;ve rounded up 25 sites where you can learn more about the Batman series and its characters.</p><p>Below you can find showtimes and buy tickets to the film, read about how the movie was made, explore close to 70 years of Batman&#8217;s history, and more.</p><p>Fan Sites</p><p><a href="http://batman-dark-knight.moviechronicles.com/" target="_blank">Batman-Dark-Knight.MovieChronicles.com</a>- An unofficial site following all the news related to the hot film&#8217;s release.</p><p><a href="http://www.batman-on-film.com/" target="_blank">Batman-on-Film.com</a>- For ten years, Batman-on-Film has covered all Batman film related projects as well as reviews of the comics.</p><p><a href="http://www.batmanfanfilms.com/" target="_blank">BatmanFanFilms.com</a>- A large collection of fan films based on the Caped Crusader with some being of amazingly high quality.</p><p><a href="http://www.batmanytb.com" target="_blank">BatmanYTB.com</a>- Batman Yesterday, Today&amp; Beyond gives you a history of Batman as well as information on collectibles, television shows, films and more.</p><p><a href="http://www.comicvine.com/batman/29-1699/" target="_blank">ComicVine.com</a>- ComicVine has a very detailed history of Batman comics, movies, television appearances and even touches on the 1950&#8217;s book, Seduction of the Innocent, which caused many to question Batman&#8217;s sexuality.</p><p><a href="http://en.dcdatabaseproject.com/Batman_(Bruce_Wayne)" target="_blank">DCDatabaseProject.com</a>- Part of the Wikia network, this wiki aims to index all of the DC Universe, but has lots of information on Batman.</p><p><a href="http://www.goldenagebatman.com/" target="_blank">GoldenAgeBatman.com</a>- A site dedicated to the Batman comics of the 1940&#8217;s, 50&#8217;s and 60&#8217;s.</p><p><a href="http://legionsofgotham.proboards70.com/index.cgi?board=bringonthebatman" target="_blank">Legions Of Gotham</a>- A large message forum dedicated to discussing every aspect of the Batman universe.</p><p>News</p><p><a href="http://www.aintitcool.com/" target="_blank">AintItCool.com</a>- Well known site for film gossip of all kinds.</p><p><a href="http://chud.com/articles/" target="_blank">Chud.com</a>- Short for&#8220;Cinematic Happenings Under Development&#8221;, CHUD is also the name of a 1980&#8217;s horror film, but this site is all about movie rumors and news.</p><p><a href="http://www.darkhorizons.com/" target="_blank">DarkHorizons.com</a>- Though based out of Australia, Dark Horizons is well known for being right on top of all the major film gossip.</p><p><a href="http://www.latinoreview.com">LatinoReview.com</a>- Well known for their early script reviews, has lots of news that led up to the new film.</p><p><a href="http://www.superherohype.com/batman/" target="_blank">SuperHeroHype.com</a>- A site dedicated to news of the ever increasing number of super hero films being produced, and they have a good recap of everything that led up to The Dark Knight.</p><p>Official Sites</p><p><a href="http://www.adamwest.com/" target="_blank">AdamWest.com</a>- Love or hate the 1960&#8217;s television series, it is still a part of Bat-history, and Adam West certainly figures into that.</p><p><a href="http://www.dccomics.com/sites/batman/" target="_blank">DC Comics</a>- The publishing company behind Batman since he first appeared in Detective Comics in 1939.</p><p><a href="http://ibelieveinharveydent.com/" target="_blank">IBelieveInHarveyDent.com</a>- Started off as a campaign website for the character of Harvey Dent running for district attorney, was later&#8220;hacked&#8221; by the Joker.</p><p><a href="http://rorysdeathkiss.com" target="_blank">RorysDeathKiss.com</a>- Part of the viral campaign that led up to the film, this site had the Joker asking people to dress up as him and submit pictures of themselves in interesting locations.</p><p><a href="http://thedarkknight.com/" target="_blank">TheDarkKnight.com</a>- Official site promoting the second film in the new series.</p><p><a href="http://www.wearetheanswer.org/" target="_blank">WeAreTheAnswer.org</a>- A site launched by the character of Harvey Dent to help get rid of police corruption in Gotham City, later hacked by the Joker.</p><p><a href="http://whysoserious.com/" target="_blank">WhySoSerious.com</a>- The Joker&#8217;s main site in the viral campaign where he made most of his communications with the citizens of Gotham City.</p><p>Tickets</p><p><a href="http://www.fandango.com" target="_blank">Fandango.com</a>- Besides buying tickets for both normal showings and IMAX screenings, also have a<a href="http://www.fandango.com/moviephotos/thegreatestandworstcomicbookmovies_5" target="_blank">list of the 10 best&amp; worst comic book films of all time</a>.</p><p><a href="http://www.moviefone.com">Moviefone.com</a>- Get movie news and trailers as well as buy your tickets for the film.</p><p><a href="http://movies.yahoo.com/" target="_blank">Movies.Yahoo.com</a>- Yahoo&#8217;s movie site has ticket sales as well as numerous exclusive trailer premieres.</p><p><a href="http://www.movietickets.com/" target="_blank">MovieTickets.com</a>- Read or listen to a synopsis of the film before you make that final decision to go see it.</p><p><a href="http://www.nyc.com/movies/" target="_blank">NYC.com movies</a>- A portion of the NYC site that helps you navigate the theaters in all the various neighborhoods of New York City.</p><p>---Related Articles at Mashable! - The Social Networking Blog:<a href="http://mashable.com/2008/07/11/dark-knight-screening/">Free Passes to Early Screening of&#8220;The Dark Knight&#8221;</a><a href="http://mashable.com/2008/05/22/wesabe-executive-shuffl/">Knight Resigns as Wesabe CEO to be with Family; Hedlund takes the Reins</a><a href="http://mashable.com/2007/09/15/star-wars-clip-restored/">Fallen Star Wars Clip on YouTube Has Been Restored</a><a href="http://mashable.com/2007/08/30/viacom-infringement/">Viacom: It&#8217;s Not Copyright Infringement When We Do it to You</a><a href="http://mashable.com/2008/04/08/web-20-marketplace-listings-for-april-8th-2008/">Web 2.0 Marketplace Listings for April 8th, 2008</a><a href="http://mashable.com/2008/04/14/web-20-marketplace-listings-for-april-14th-2008/">Web 2.0 Marketplace Listings for April 14th, 2008</a><a href="http://mashable.com/2008/02/12/massify-after-dark-films/">Massify Teams with After Dark Films for Crowdsourcing Horror Flick</a></p><img src="http://mashable.com/wp-content/uploads/2008/07/batman-logo.gif" alt="" />', 'Mashable!');
INSERT INTO {PREFIX}_article_page_content (page_id, article_id, content_detail, author) VALUES (23, 23, '<p>Company:<a href="http://www.outbrain.com/" target="_blank">Outbrain</a></p><p>Founded: 2006</p><p>Located: Netanya</p><p>I had the opportunity to meet with John LoGioco, VP of Business Development at Outbrain, the free service that offers bloggers and publishers a ratings widget that can be used by visitors of their sites to rate their content. The service, which serves as a recommendation engine for readers allowing them to discover new content they might like based on the ratings they give, recently announced an<a href="http://mashable.com/2008/07/10/outbrain-reports/">analytics dashboard</a>for bloggers and site publishers.  Outbrain is signaling a trend towards offering higher quality, more personalized Web content based on reader response and giving readers more power over the content they are viewing.</p><p>In our interview below, I speak with John about Outbrain&#8217;s philosophy and goals.</p><p><a rel="nofollow" href="http://www.blonde2dot0.com/" target="_blank"></a>Ayelet Noff, also known as blogger<a rel="nofollow" href="http://www.blonde2dot0.com/" target="_blank">Blonde 2.0</a>,  is a social marketing strategist and consultant who has been an influential force in the Israeli tech scene for many years. Noff specializes in helping companies strategically market their brands online.</p><p>[Disclosure: Outbrain is a past sponsor of Mashable events]</p><p>---Related Articles at Mashable! - The Social Networking Blog:<a href="http://mashable.com/2007/05/07/outbrain/">Outbrain Raises Funding for Blog Ratings System</a><a href="http://mashable.com/2008/04/28/announcing-mashbash-tel-aviv-and-israel-media-tour/">Announcing MashBash Tel Aviv and Israel Media Tour</a><a href="http://mashable.com/2008/07/10/outbrain-reports/">Outbrain Offers Bloggers More Data with Reports Dashboard</a><a href="http://mashable.com/2008/06/16/mashable-israel-media-tour/">Shalom and Welcome to the Israel Media Tour</a><a href="http://mashable.com/2008/02/01/israel-web-tour-discount/">Discount Code for IsraelWebTour, Hosted by Microsoft</a><a href="http://mashable.com/2008/05/29/now-available-final-tickets-for-mashbash-tel-aviv/">Now Available: Final Tickets for MashBash Tel Aviv</a><a href="http://mashable.com/2008/05/14/mashbash-tel-aviv-israel-tickets/">MashBash Tel Aviv and Israel Media Tour Updates - Last Set of Tickets</a></p><img src="http://mashable.com/wp-content/uploads/2007/05/outbrain.png" alt="" />', 'Mashable!');
INSERT INTO {PREFIX}_article_page_content (page_id, article_id, content_detail, author) VALUES (24, 24, '<p>Here&#8217;s Mashable&#8217;s latest round-up of upcoming Web 2.0 events, parties, and conferences.  Not on this list?  Contact us and let&#8217;s establish a media sponsorship.</p><p>July 22-24, 2008: The AlwaysOn&#038; STVP Summit at Stanford is a two-and-a-half-day executive gathering that highlights the significant economic, political and commercial trends affecting the global technology industries. The AlwaysOn&#038; STVP Summit at Stanford features the most innovative companies, eminent technologists, influential investors and journalists in keynote presentations, panel debates and private company CEO showcases. The AlwaysOn&#038; STVP Summit at Stanford\'s goal is to identify the most promising entrepreneurial opportunities and investments in the global tech industry.  More information and a 50% discount link can be found<a href="http://mashable.com/2008/07/07/stanford-summit/">here</a>.</p><p>MobileBeat 2008 is the premier mobile conference seeking to answer the larger questions that confront developers, entrepreneurs, and investors within the mobile industry.  Want more information and a discount code?  Hop on over to our<a href="http://mashable.com/2008/07/08/mobilebeat-2008/">MobileBeat conference post</a>.</p><p>July 30, 2008: Mashable is ready to rock out at our fourth stop on the U.S. Summer Tour, as well as our first time in<a href="http://mashable.com/us-summer-tour-2008/summermash-austin/">Austin, TX</a>. With finger-lickin\' food, cold drinks and Mashable\'s Pete Cashmore, Mark  \'Rizzn\' Hopkins and Karen Hartline, it\'s the event you won\'t want to miss. We promise not to mess with Texas while we\'re in town and guarantee to accept any challenge to Billiards, Rock Band, Wii, or Shuffleboard. Yee haw!</p><p>July 31-August 4, 2008:<a href="http://icamp.ru/" rel="nofollow">iCAMP</a>is an international informal conference of Internet activists, held at Moscow.  iCamp 2008 will bring together internet project managers, startup managers, web developers, designers, media managers, bloggers, and journalists and connect them with angel investors, government IT representatives, internet researchers, and more.  All in all, among 500 participants from Russia, CIS, Europe and USA will spend 4 days exchanging ideas, projects, experience, as well as playing games, doing sports, dancing to live music, and just mingling.</p><p>August 2, 2008: Mashable makes<a href="http://mashable.com/us-summer-tour-2008/summermash-miami/">our first trip to Miami</a>for the forth stop on the U.S. Summer Tour.  Party the night away at The Opium Garden, where we may forget we\'re in Miami with the amazing Asian outdoor architecture. Everyone is a VIP as we have a private room just for the Summer MashBash.  The temperature will rise when Mashable\'s Pete Cashmore and Karen Hartline arrive, but we need you there to keep the roof blazing.  We\'ll provide drink tickets,appetizers and music if you bring the moves.  Miami is extra special as we\'re partying with DailyMe and celebrating their launch!</p><p>August 5, 2008: Mashable makes it\'s first trip to Boston, MA for the sixth stop on the U.S. Summer Tour.  You won\'t see Paul Revere, but you will have the chance to hang out with Mashable\'s Pete Cashmore, Brett Petersel and Karen Hartline. Join us for food (no Boston baked beans, sorry), drinks and a DJ. We want to see the “Mashable Nation” in full force! We\'re partying at The Roxy Nightclub, which has many areas for you to see and be seen.  Get more information and<a href="http://mashable.com/us-summer-tour-2008/summermash-boston/">RSVP here</a>.</p><p>August 7, 2008: Mashable finish\'s the U.S. Summer Tour in the only city big enough to handle it,<a href="http://mashable.com/us-summer-tour-2008/summermash-new-york-city/">New York City</a>! Mashable\'s back for our second time in NYC and will have a repeat performance at Touch with the Mashable All-Stars, including Pete Cashmore, Adam Hirsch, Adam Ostrow, Brett Petersel, Tamar Weinberg, and Karen Hartline. Frank Sinatra did it his way, but we\'re ready to rock out our final stop with the city that never sleeps. We\'re going out with a bang and have a big surprise in store for the big finale.  You won\'t want to miss out on this!</p><p>August 10-12, 2008: Mashable is pleased to announce that we are a sponsor of Affiliate Summit 2008 East, which is taking place August 10-12 in Boston and expects about 2,500 attendees.  The keynote speaker will be Cory Booker, Mayor of Newark, NJ.<a href="http://www.affiliatesummit.com/" rel="nofollow">Affiliate Summit Inc.</a>is the premier affiliate marketing conference and was founded in 2003 by affiliate marketing industry veterans, Shawn Collins and Missy Ward to serves the affiliate marketing professional community.  Affiliate marketers know not to miss this event.<a href="http://mashable.com/2008/05/23/affiliate-summit-discount/">Find out how</a>to save 15% off.</p><p>August 14-16, 2008:<a href="http://www.newmediaexpo.com/incoming.php?linkid=1936" rel="nofollow">The New Media Expo</a>is the world&#8217;s most popular convention for online audio and video creators and will be held at the Las Vegas Convention Center. The Expo is a hands-on, exciting,&#8220;how-to&#8221; event with practical conference sessions about how to produce high-quality online audio and video content, grow a loyal audience, and market or monetize that content in creative ways.  Congratulations to Ben Parr for winning a ticket from Mashable!</p><p>August 21, 2008:<a href="http://communitynext.com/" rel="nofollow">Community Next::Monetize</a>is an exclusive expo bringing together top advertisers and publishers/bloggers/app developers. The goal is to connect these influential groups and help publishers find new and better ways to monetize and of course have fun in the process. There will be a free delicious lunch and an open bar all afternoon.  Want more information?  Visit our<a href="http://mashable.com/2008/07/15/communitynext-monetize/">CommunityNext::Monetize announcement</a>for the skinny.</p><p>September 7-9, 2008 Be the first to see the most innovative, marketing defining new technologies unveiled for the very first time.  Attend DEMOfall 08 on September 7-9, 2008 in San Diego.  Mashable readers are invited to attend for a special rate of only $2,395– a $600 savings off our regular rate.  Click here to learn more and register:<a href="http://www.demo.com/F8mashable">http://www.demo.com/F8mashable</a></p><p>InterAct 2008, to be held on September 29-30 at the Ronald Reagan Building in Washington DC, hopes to have 1,000 attendees each day, 65 exhibitors, and 35+ of the industries hottest talents speaking about proven methods to increase market share on the web, turnkey web solutions, user experience, search engine optimization, user interface design, branding, rich media, video, mobile media, social media, new business development, and networking, networking, networking.  Want more information and a discount code?<a href="http://mashable.com/2008/07/07/interact-2008/">Hop on over to our conference post</a>with all the deets!</p><p>October 6-8, 2008: Back for the second year,<a href="http://virtualworldsforum.com/" rel="nofollow">Virtual Worlds Forum Europe 2008</a>(VWF) isproduced by the Virtual Economic Forum, Europe&#8217;s leading virtual worlds media company. Three days of congress, expo and workshops covering entertainment, enterprise, community, education, marketing, regulation, and finance&#8230; plus lots more. VWF is the place to make connections, be inspired and have fun.</p><p>November 11-14, 2008: For anyone involved in the production, marketing, or management of an Internet web site - this is a must attend event to be held in Las Vegas, NV.<a href="http://www.pubcon.com" rel="nofollow">PubCon</a>covers search engine optimization (SEO), search engine marketing (SEM), web hosting issues, domains&#038; the domaining business, Internet video, podcasting, multimedia, and special sessions of interactive attendee site reviews. In addition, there are tracks on new marketing techniques, linking strategies, social media, and online advertising.  Save 15% by using the code<a href="http://mashable.com/2008/07/15/pubcon-2008-discount/">on our discount announcement</a>.</p><p>On a related note, the<a href="http://www.proto.in/" rel="nofollow">Proto.in</a>startup event was held over the weekend in India.  Over 500 attendees, including Venture Capitalists, startup companies, investors, and aspiring entrepreneurs learned about some incredibly promising startups.  Great times were had by all.  The<a href="http://blog.proto.in/" rel="nofollow">blog</a>covers more of what you missed!</p><p>---Related Articles at Mashable! - The Social Networking Blog:<a href="http://mashable.com/2008/04/25/shwaggin-wagon/">I Took a Ride in the Schwaggin&#8217; Wagon, at Web 2.0 Expo</a><a href="http://mashable.com/2007/07/05/apple-iphone-developers-guide/">Apple Releases iPhone Developer&#8217;s Guide</a><a href="http://mashable.com/2008/04/20/more-web-20-expo-fun-ie-parties/">More Web 2.0 Expo Fun (i.e. Parties)</a><a href="http://mashable.com/2007/10/31/aol-local-india/">AOL Goes Local In India</a><a href="http://mashable.com/2007/07/13/smugglersmusic/">SmugglersMusic Launches Band Sales&amp; Promotion Site</a><a href="http://mashable.com/2007/10/25/do-me-london-city-tours/">Do Me London Offers Mobile City Tours</a><a href="http://mashable.com/2008/05/21/gsp-east-contest/">Ticket Giveaway for O&#8217;Reilly&#8217;s Graphing Social Patterns East</a></p><img src="http://mashable.com/wp-includes/images/smilies/icon_smile.gif" alt="" />', 'Mashable!');
INSERT INTO {PREFIX}_article_page_content (page_id, article_id, content_detail, author) VALUES (25, 25, '<p><a href="http://www.adbrite.com/" target="_blank">AdBrite</a>announced it will use its large online advertising marketplace (70,000 active websites) to unveil a new behavioral targeting product, currently available as invite-only to a select group of advertisers.</p><p>The new service allows advertisers to display ads to users based on their interests and habits, and however freakish this may seem to some users, we all know that it works well in practice. There are 14 major interest categories which are subdivided to over 3000 subcategories; these include Automotive, Business&#038; Finance, Careers, Consumer Electronics, Dating&#038; Singles, Health, Music, and Travel.</p><p>Prices for the behaviorally targeted ad inventory are determined through a real-time auction, and advertisers are able to view detailed reports on the performance of each subcategory, thus enabling them to precisely adjust bids and placements of their ads.</p><p>There is some serious competition in this field; one company that comes to mind is<a href="http://mashable.com/2007/11/01/exelate-the-behavioral-data-marketplace-raises-4-million/">eXelate</a>, which was funded with $4 million in 2007; also, pretty much every big player has its own behavioral ad network in stock already. AdBrite hopes to leverage its large inventory to draw advertisers; as Ignacio Fanlo, AdBrite CEO puts it,“AdBrite\'s mix of high-reach publisher brands and engaging specialty content sites is an unbeatable combination for advertisers and publishers alike.”</p><p><a class="tradevibes_show_widget" href="http://www.tradevibes.com/company/profile/adbrite">AdBrite</a>company profile provided by<a class="tradevibes_home" href="http://www.tradevibes.com/">TradeVibes</a></p><p>---Related Articles at Mashable! - The Social Networking Blog:<a href="http://mashable.com/2008/04/10/adbrite-otx/">AdBrite Opens Platform, So You Can Play with Targeting Ads</a><a href="http://mashable.com/2007/11/29/adbrite-funding/">Big Money for AdBrite: $23 Million from Sequoia and Others</a><a href="http://mashable.com/2007/10/14/adbrite-full-page-ads/">AdBrite Now Offers Full Page Ads</a><a href="http://mashable.com/2008/04/13/widgetbucks-2/">Widgetbuck&#8217;s Makes comScore&#8217;s List, Launches Hybrid Widget</a><a href="http://mashable.com/2007/10/30/adbrite-serves-ads-for-facebook-apps/">AdBrite Serves Ads For Facebook Apps</a><a href="http://mashable.com/2008/05/08/adbrite-seeks-more-clients-with-tailored-music-ads/">AdBrite Seeks More Clients, with Tailored Music Ads</a><a href="http://mashable.com/2008/02/18/uk-isps-behavioral-ad-networks-phorm/">British ISPs to Delve into Behavioral Ads, Too</a></p><img src="http://mashable.com/wp-content/uploads/2007/10/brite.png" alt="" />', 'Mashable!');
INSERT INTO {PREFIX}_article_page_content (page_id, article_id, content_detail, author) VALUES (26, 26, '<p>Yahoo! reached an agreement with Carl Icahn: eight members of Yahoo&#8217;s current board of directors will stand for re-election; the board will be expanded to 11 members, Icahn will take one, and the other two will be chosen based on his recommendation.</p><p>Yahoo! co-founder and CEO Jerry Yang said this of the agreement:</p><p>“This agreement will not only allow Yahoo! to put the distraction of the proxy contest behind us, it will allow the Company to continue pursuing its strategy of being the starting point for Internet users and a must buy for advertiser.”</p><p>Icahn&#8217;s statement is more revealing:“I am very pleased that this settlement will allow me to work in partnership with Yahoo!\'s Board and management team to help the Company achieve its full potential. While I continue to believe that the sale of the whole Company or the sale of its Search business in the right transaction must begiven full consideration, I share the view that Yahoo!\'s valuable collection of assets positions it well to continue expanding its online leadership and enhancing returns to stockholders.”</p><p>Bascially, Icahn backed down in exchange for three seats on the board; and will not be pushing for the sale of Yahoo or its search business&#8230;for a while. Does it mean that the Microhoo soap opera is finally at an end? Far from it: this is just one little (costly) victory for Yahoo. If there is a clear&#8220;winner&#8221; in this story when the dust settles in the end, I bet it will be a Pyrrhic victory.</p><p>Read the official statement by Yahoo<a href="http://finance.paidcontent.org/paidcontent?GUID=6060882&#038;Page=MediaViewer&#038;Ticker=YHOO">here</a>.</p><p>---Related Articles at Mashable! - The Social Networking Blog:<a href="http://mashable.com/2008/05/14/yahoo-carl-icahn/">The Microsoft-Yahoo Dream/Nightmare Lives On: Billionaire Icahn Makes a Move</a><a href="http://mashable.com/2008/05/16/pushed-by-icahn-yahoo-jumps-back-into-ad-deal-with-google/">Pushed By Icahn, Yahoo Jumps Back Into Ad Deal With Google?</a><a href="http://mashable.com/2008/05/23/yahoo-board-member-leaves-first-signs-of-disintegration/">Yahoo Board Member Leaves; First Sign Of Disintegration?</a><a href="http://mashable.com/2008/05/15/yahoo-responds-to-icahn/">More Love Notes: Yahoo Responds to Icahn&#8217;s Master Plan</a><a href="http://mashable.com/2008/05/18/yahoo-responds-to-microsoft-alternative/">@Yahoo is Twittering: @Microsoft: Sure, We\'ll Consider an Alternative</a><a href="http://mashable.com/2008/06/04/icahn-yang-yahoo/">Icahn Wants Yang Fired, Microsoft Chuckles Evilly</a><a href="http://mashable.com/2008/05/17/yahoo-shareholder-suit/">Yahoo Shareholders Claim Company Is Concealing Critical Documents</a></p><img src="http://mashable.com/wp-content/uploads/2008/05/icahn.gif" alt="" />', 'Mashable!');
INSERT INTO {PREFIX}_article_page_content (page_id, article_id, content_detail, author) VALUES (27, 27, '<p><a href="http://www.jajah.com/" target="_blank">Jajah</a>, which has been on the fast track to expansion by way of several partnerships, has just teamed up with<a href="http://www.pageonce.com/" target="_blank">Pageonce</a>&#8217;s Personal Internet Assistant service so users can keep track of their Jajah activity at any time.  This comes with additional alerts from Pageonce for account updates like a low balance or other changes that have occurred to their account.  As with all other service partnerships included in Pageonce, the Jajah account access and alerts are free.</p><p>This is different than most Jajah partnerships you hear about, as most announcements regarding Jajah integration involve the ability to make VoIP calls within a particular social network.  But the remote access to your Jajah account activity through Pageonce is an important  partnership as well.   As I<a href="http://mashable.com/2008/06/02/pageonc/">mentioned</a>in previous coverage of Pageonce, through its virtual service you can access your various accounts securely, without having to log in, once your account has been confirmed.</p><p>We&#8217;ve seen several developments moving towards just this type of a partnership, with advances from Pageonce, LiquidTalk, SkyDeck, Chase and also Jajah, to name a few.  So I&#8217;m not surprised to see Jajah make your account activity available through the Pageonce Personal Internet Assistant program, and extend it to all their users.  Not only are more companies making their content accessible remotely through plug-ins and third-party services, but others like Pageonce are turning this into a highly personalized service that aggregates nearly everything in your life, from your cable service account information to your checking account balance, your Netflix queue to your airline mileage points.</p><p>Pageonce is one of the most comprehensive tool of its kind that I&#8217;ve used so far, and the company has worked hard to make as many services as possible available directly through its service.  I think the next major step for this particular space is continued growth through user and B2B adoption, and we&#8217;ll likely see some indirect recommendations as a result, on a very personalized level.</p><p>As services like Pageonce become a platform for centralized custom content, we&#8217;ll also likely see some indirect marketing from third party services come about, as services find that Pageonce has the potential to become yet another way in which they can reach out to consumers, as well as an integrated service that can be offered as a perk for their existing customers.  The beauty of it is that it works across a myriad of services and industries, even those outside of the Web-based service realm.</p><p>---Related Articles at Mashable! - The Social Networking Blog:<a href="http://mashable.com/2008/06/02/pageonc/">Pageonce Launches Virtual Personal Assistant&#8211;And it Works</a><a href="http://mashable.com/2008/01/08/pageonce-funded/">Can the Web Be Your Personal Assistant? PageOnce + $1.5M Says Yes.</a><a href="http://mashable.com/2006/06/27/jajah-launches-today-free-phone-calls/">Jajah Launches Free Phone Calls Globally</a><a href="http://mashable.com/2007/12/06/jajah-iphone/">Jajah Enables VoIP Calls on iPhone</a><a href="http://mashable.com/2007/09/27/jajah-buttons/">Jajah Introduces Buttons: Widgets for Toll-Free Calling</a><a href="http://mashable.com/2006/12/17/jajah-going-ad-supported/">Jajah Going Ad-Supported</a><a href="http://mashable.com/2007/10/04/ebay-jajah/">eBay Deletes Listings with Jajah VoIP Buttons</a></p><img src="http://mashable.com/wp-content/uploads/2007/09/jajah-logo.gif" alt="" />', 'Mashable!');
INSERT INTO {PREFIX}_article_page_content (page_id, article_id, content_detail, author) VALUES (28, 28, '<p>I loathe<a href="http://www.mtv.com/">MTV</a>. It&#8217;s not because they&#8217;ve gone from music television to let&#8217;s-hypnotize-teens-and-turn-them-into-some-sort-of-zombie-army television (they have), and it&#8217;s not because the music there sucks most of the time (it does); it&#8217;s because every time I find a link to some video that resides on their site I get the following message:</p><p>COPYRIGHT RESTRICTS US FROM PLAYING THIS VIDEO OUTSIDE OF THE US.</p><p>Now, I know all you US folks aren&#8217;t familiar with these sorts of messages, but can you please take a second and imagine how it is for the rest of us? You feel stupid: you&#8217;re willing to spend some of your precious time and see some content, and then you&#8217;re told that you can&#8217;t, because you&#8217;re located on the wrong spot of the globe.</p><p>If MTV was completely unavailable in my country (Croatia) and I were unfamiliar with the brand, it wouldn&#8217;t be a big deal. Don&#8217;t know them, don&#8217;t care. But I am a user; they&#8217;re very much available here (and pretty much everywhere else) on satellite TV, and I&#8217;m seeing those same videos I&#8217;m unable to see online on my telly every day (actually, I don&#8217;t, cause I rarely watch television; but you get the idea).</p><p>I know why this is: copyright problems. As I stated<a href="http://mashable.com/2008/03/11/hulu-europe/">many times before</a>: I don&#8217;t care. Solve it. Do something. I&#8217;m obviously able to see the content elsewhere (be it on YouTube or TV), so it&#8217;s not impossible.</p><p>Don&#8217;t do it because I tell you so, MTV. Do it because you&#8217;ve got millions of visitors hating you more and more each day; they&#8217;re your users because they&#8217;re familiar with your brand, and you&#8217;re telling them to buzz off? Gee, let me guess how that one is going to end up.</p><p>It&#8217;s one thing when you don&#8217;t let users see the video. It&#8217;s bad, but it can be worse. By chance, I&#8217;ve stumbled into some niche social network called<a href="http://www.virtualrush.com/">Virtual Rush</a>. I can&#8217;t even open the site, as I&#8217;m greeted with the message:&#8220;Sorry! Virtual Rush is only available within the United States.&#8221; They didn&#8217;t even create a nice&#8220;sorry&#8221; page, it&#8217;s just ugly, .85em sized, black Arial letters on white background. I can&#8217;t imagine why can it be necessary to keep users from even seeing the front page of a social network, regardless of how country-specific it may be.</p><p>Let&#8217;s do this once again for those companies who haven&#8217;t been paying attention: the internet is global. Anyone can be your user, regardless of where they physically are. Hiding stuff from users based on their location is stupid, and it&#8217;ll make your users hate you. Get it?</p><p>---Related Articles at Mashable! - The Social Networking Blog:<a href="http://mashable.com/2007/09/10/islam-facebook/">Anti-Islam Facebook Group Removed After User Complaints</a><a href="http://mashable.com/2007/03/15/why-we-hate-viacom-youtubers-sue-back-edition/">Why We Hate Viacom, YouTubers Sue Back Edition</a><a href="http://mashable.com/2007/11/29/facebook-beacon/">Report: Facebook Might Make Beacon Less Creepy</a><a href="http://mashable.com/2007/08/16/friend2friend-facebook-app/">Friend2Friend Facebook Application</a><a href="http://mashable.com/2007/02/16/dell-rips-off-digg-another-diggstorm-in-the-making/">Dell Rips Off Digg - Another Diggstorm in the Making</a><a href="http://mashable.com/2007/10/10/cbs-dotspotter/">CBS Acquires Gossip Digg Clone for $10M</a><a href="http://mashable.com/2007/06/30/rise-of-the-rose-bashers/">Rise of the Rose Bashers?</a></p><img src="http://mashable.com/wp-content/uploads/2008/07/hate.png" alt="" />', 'Mashable!');
INSERT INTO {PREFIX}_article_page_content (page_id, article_id, content_detail, author) VALUES (29, 29, '<p><a href="http://www.ilike.com" target="_blank">iLike</a>, the music discovery service with a number of popular applications across social networks, has announced that it will now offer full track streaming through a partnership with Rhapsody.  That means that users of iLike\'s applications on Facebook, MySpace, Bebo, and hi5 will now be able to listen to complete tracks, as opposed to the 30 second samples offered previously.  Users can listen to up to 25 free tracks per month, at which point they can either subscribe to Rhapsody or will be reverted back to the samples.</p><p>The deal also has an interesting business model for artists– they earn revenue each time their music is played.  Hadi Partovi, President of iLike, told me in a conversation last week that “in the past, music social networks have been a promotional vehicle [for artists], but now it\'s also a way to help fund the music industry through our deal with Rhapsody.”  Competitor Last.fm rolled out a similar program earlier this month, dubbed the<a href="http://mashable.com/2008/07/09/lastfm-artist-royalty-program/">Artist Royalty Program</a>.</p><p>In addition to free streaming, iLike, which now claims 30 million users, has announced a new<a href="http://www.ilike.com/advertise" target="_blank">advertising platform</a>for concert promoters.  The self-service platform allows advertisers to target music fans based on their tastes, what events their friends are attending, and location.  Promoters can include multimedia in their ads, such as tracks and videos.</p><p>Finally, iLike has also announced that they plan to launch a developer platform later this year.  The platform will enable developers to access iLike\'s music catalog and stream songs in their own applications, and also allow them to integrate other features of the service.  Similarly, Imeem opened up its<a href="http://mashable.com/2008/03/24/imeem-open-platform/">music catalog</a>to developers back in March.</p><p>Overall, iLike, imeem, and Last.fm seem to be moving in very similar directions of offering free streaming music across social networks and relying on alternative business models– for iLike, concert promotion and now upselling users to Rhapsody.  Which one will win out?  The latest stats from Google Trends show Imeem in the lead, but the comparison isn\'t exactly apples-to-apples since much of iLike\'s userbase never visits the actual website and use the company&#8217;s applications within the social networks that it supports.</p><p>---Related Articles at Mashable! - The Social Networking Blog:<a href="http://mashable.com/2007/12/13/thumbplay-ilike/">Ringtones on iLike, Powered by Thumbplay</a><a href="http://mashable.com/2008/03/10/rem-new-album/">Hear The New R.E.M. Album on iLike Before it Hits the Stores</a><a href="http://mashable.com/2007/10/22/ilike-billboard-facebook-app/">iLike, Billboard Team Up for New Music Charts</a><a href="http://mashable.com/2007/11/12/rhapsody-wendys/">Free Music at Rhapsody.  Just Buy a Hot, Juicy Burger.</a><a href="http://mashable.com/2008/06/30/rhapsody-music-without-limit/">Rhapsody Does DRM-Free Music, Teams With Yahoo and Verizon</a><a href="http://mashable.com/2007/10/09/tivo-rhapsody/">Rhapsody Music Now Available Through TiVo</a><a href="http://mashable.com/2007/10/04/ilike-artist-services/">iLike Launches New Tools for Artists</a></p><img src="http://mashable.com/wp-content/uploads/2008/07/ilike-logo.gif" alt="" />', 'Mashable!');
INSERT INTO {PREFIX}_article_page_content (page_id, article_id, content_detail, author) VALUES (30, 30, '<p>After working as an executive at The Body Shop and becoming an Internet entrepreneur in her own right as the co-founder of Eve.com, Mariam Naficy is a Web veteran known for her experience in the retail market.  Her latest project,<a href="http://www.minted.com" target="_blank">Minted.com</a>, launches today as both an online retail site and a community, targeting nearly every aspect of the stationary market.</p><p>Minted is angel-funded with more than a dozen private investors, most of which are other tech veterans including Ben Elowitz, Founder and CEO of WetPaint, as well as Toby Lenk, Founder of eToys and President of of Gap, Inc. Direct.  Minted has also managed to steal one of Facebook&#8217;s former employees, Biren Gandhi, as its new Vice-President, Engineering.</p><p>As a retailer and a community, Minted acts somewhat as an outsourcing tool for independent designers of paper products.  It&#8217;s the exclusive online retailer for about 17 top independent stationary brands in the US, and looking through Minted&#8217;s site, it&#8217;s clear that it would like to build on this foundation and connect designers and consumers through an olnine community.  Similar to<a href="http://www.threadless.com" target="_blank">Threadless</a>, designers can submit designs to the site, where they are voted on.  Top designs get to become part of the inventory available on Minted, and the community voting process acts as a filter for incoming content.</p><p>Such filtering is good for the consumers, as Nacify noted that they&#8217;re a busy group and would rather not have to sift through hoards of content in order to find the best designs.  But Nacify feels that the designers not only gain exposure through Minted&#8217;s online market, but that the contest approach as well.&#8220;The competitive format also creates an aspirational element that I think the designers appreciate– they like that the site is selective, and they enjoy the fun and challenge of the competition,&#8221; says Nacify.&#8220;I think there is a lot of respect among our designers for each other, so winning means a great deal to them.&#8221;</p><p>We&#8217;re seeing a number of retailers take the community approach to filtering content before it even reaches the marketplace, and others like<a href="http://mashable.com/2008/07/09/cameesa/">Cameesa</a>combining this with a micro-investment aspect for community members to become financially involved in the success of independent designers and freelancers as well.  The Web has certainly made such business models more viable, and with the experience behind Minted&#8217;s team, and its chosen $10 billion market in stationary products, it looks like the site will do quite well.</p><p>---Related Articles at Mashable! - The Social Networking Blog:<a href="http://mashable.com/2008/07/11/24-hours-iphone/">Leo Laporte Does 24 Hours of iPhone to Over a Quarter Million Viewers</a><a href="http://mashable.com/2008/01/14/myspace-and-ag-announce-internet-safety-principles/">MySpace and AG Announce Internet Safety Principles</a><a href="http://mashable.com/2008/06/03/microsoft-web-page-error-toolkit/">Microsoft Dusts Off Its 404 Page With Web Page Error Toolkit</a><a href="http://mashable.com/2007/12/17/twitter-vulnerable-to-spammer-invasion/">Twitter: Vulnerable to Spammer Invasion?</a><a href="http://mashable.com/2008/01/31/readburner-api/">Readburner&#8217;s Unofficial API</a><a href="http://mashable.com/2007/11/23/is-the-microsoft-zune-still-failing/">Is The Microsoft Zune Still Failing?</a><a href="http://mashable.com/2008/05/15/17-online-tools-for-your-graduation/">17 Online Tools For Your Graduation</a></p><img src="http://mashable.com/wp-content/uploads/2008/07/minted-logo.png" alt="" />', 'Mashable!');
INSERT INTO {PREFIX}_article_page_content (page_id, article_id, content_detail, author) VALUES (31, 31, '<p>If you&#8217;re in SF, look out for coverage of this week&#8217;s massively successful SummerMash SF on<a href="http://www.kron4.com/global/Category.asp?c=142817">Kron4</a>, tonight at 9pm PT. Alternatively, check out the embedded clips below.</p><p>The latest photos from the SummerMash series of events are available on our<a href="http://flickr.com/photos/mashable">Flickr feed</a>or through Facebook (feel free to<a href="http://www.facebook.com/profile.php?id=500283591">add me</a>as a friend).</p><p>---Related Articles at Mashable! - The Social Networking Blog:<a href="http://mashable.com/2008/06/13/summermash-startups/">Get Your Startup on Mashable (If You\'re in a SummerMash City)</a><a href="http://mashable.com/2008/07/09/qik-mobile-live-streaming-straight-to-mashable-events-pages/">Qik Mobile Live Streaming Straight to Mashable Events Pages</a><a href="http://mashable.com/2008/07/15/summermash-san-francisco-streaming-live-summermash-tour-2008/">SummerMash San Francisco Streaming Live [SummerMash Tour 2008]</a><a href="http://mashable.com/2008/07/12/summermash-seattle-3/">U.S SummerMash Tour Opens In Seattle - Live Video Feed</a><a href="http://mashable.com/2008/07/15/personality-not-included-book-signing/">&#8220;Personality Not Included&#8221; Book Signing This Week at SummerMash SF and Los Angeles</a><a href="http://mashable.com/2008/07/14/seattle-summermash-wrapup/">Thank You Seattle!  SummerMash Rocked</a><a href="http://mashable.com/2008/07/11/yoono-social-media-camp-seattle/">Get Warmed Up for SummerMash Seattle with Yoono&#8217;s Social Media Camps</a></p><img src="http://mashable.com/wp-content/uploads/2008/07/pete-kron.gif" alt="" />', 'Mashable!');
INSERT INTO {PREFIX}_article_page_content (page_id, article_id, content_detail, author) VALUES (32, 32, '<p>Update (9:55PM PT): Facebook has issued a<a href="http://www.new.facebook.com/press/releases.php?p=47448">press release</a>announcing the new design, indicating that&#8220;access to the new design will be limited at first and gradually become available to all.&#8221;</p><p>As<a href="http://mashable.com/2008/07/20/facebook-redesign/">expected</a>, Facebook has officially rolled out the beta for its new design this evening.  To get it, you can now go to<a href="http://www.new.facebook.com" target="_blank">www.new.facebook.com</a>, which will convert the site to the new look.  You can still roll back to the previous version by clicking a“Back to Old Facebook” link at the top of the site.</p><p>From top to bottom, the design is a lot cleaner than the current Facebook, and certainly is a big attempt to make the site less cluttered while placing an emphasis on a number of features– most notably the mini-feed and status updates.  This is immediately noticeable in the homepage, where the new Facebook features just two columns versus the three in the old version, with requests, links, and other current homepage features consolidates on the right, with your News Feed on the left occupying the majority of the real estate.</p><p>Moving to the user profiles, as expected, user profiles are now tabbed, with the defaults being Wall (your feed and wall posts), Info (your profile info), Photos, and Boxes (applications).  On your own profile, Facebook is clearly trying to push status updates, asking a variation of the very same question posed by Twitter“What are you doing right now?”   Profiles are also now two columns, making more space for the mini-feed and the other new tabs.</p><p>So far, it\'s unclear how Facebook plans to promote the new site to users and get them involved in the beta.  While those of us in the tech blogosphere have been expecting the changes since early this year and been following each new twist and turn closely, it\'s a major change in look and feel that will likely be dramatic for mainstream users.</p><p>Presumably Facebook has learned its lesson from previously poorly communicated roll outs like<a href="http://mashable.com/?p=958">News Feed</a>and<a href="http://mashable.com/2007/12/05/facebook-5/">Beacon</a>, and so far has been doing an excellent job of keeping the developer community informed of the design changes. Meanwhile, keeping the option to revert to the old Facebook for a while should help Facebook weather what will surely be some confusion and anger from ever-fickle social networking users.  There&#8217;s also a prominent link for users to submit their feedback on the new look.</p><p>Last week, when a<a href="http://mashable.com/2008/07/14/future-facebook-profiles/">preview of the new site</a>was briefly available, our audience was decidedly split with their reviews, so it will be interesting to see your opinions now that the beta has officially arrived and working as expected.  Let us know what you think in the comments.</p><p>---Related Articles at Mashable! - The Social Networking Blog:<a href="http://mashable.com/2007/03/15/facebook-exporter-iphoto/">Facebook Exporter for iPhoto Launches</a><a href="http://mashable.com/2007/08/16/facebook-diaries-3/">Facebook Diaries Officially Launched in Conjunction With Ziddio</a><a href="http://mashable.com/2006/09/21/unilife-launches-italian-facebook/">Unilife Launches Italian Facebook</a><a href="http://mashable.com/2006/10/12/aussie-facebook-opens-to-everyone/">Aussie Facebook Opens to Everyone</a><a href="http://mashable.com/2007/04/02/facebook-thrift/">Thrift: Facebook Gets Thrifty</a><a href="http://mashable.com/2007/09/20/mashable-fbfactory-facebook/">Our Second Facebook App is Here!</a><a href="http://mashable.com/2007/09/25/facebook-im-2/">Unofficial Facebook IM Application in the Works</a></p><img src="http://www.mashable.com/images/facebooklogofresh.PNG" alt="" />', 'Mashable!');
INSERT INTO {PREFIX}_article_page_content (page_id, article_id, content_detail, author) VALUES (33, 33, '<p>Only two weeks have passed since we first reported on Adobe Inc\'s undertaking<a href="http://mashable.com/2008/07/06/adobe-air-tm/">to remove the FreshAIRapps</a>domain and nameplate from the Web. In short,<a href="http://freshairapps.com/" target="_blank">FreshAIRapps</a>was a compendium or directory of applications built upon the Adobe AIR platform. Users could rate codeworks and read relevant news and so forth in one central location. It would be accurate to have called it a fairly popular upstart.</p><p>Yes, called is the key word to keep in mind now. According to the founder of FreshAIRapps, James Whittaker, who alerted Mashable to the fact earlier today, the website is no more. An attempt to visit the URL shows a mostly bare white page, stating that the site has moved to a new location. Seconds later, the visitor is automatically transferred there.&#8220;There&#8221; being<a href="http://refreshingapps.com/" target="_blank">RefreshingApps.com</a>.</p><p>It sports a slightly different design, but its basic makeup is all very much intact. The one overt exception is a now-absent section originally seen at FreshAIRapps, labeled \'Tutorials.\'</p><p>There was a notable level of resentment and fury levied at Adobe for pushing forcefully for the removal of FreshAIRapps in name only. Some<a href="http://mashable.com/2008/07/06/adobe-air-tm/#comments">commenters</a>found it peculiar that the company would enforce a trademark of“AIR.” I myself seconded such objections. Still, the site\'s creator continued to converse with Adobe over the planned transfer to the RefreshingApps domain and has now officially announced the completion of the move.</p><p>Whittaker does note he and the RefreshingApps project“will be working closely with Adobe and their evangelists to further promote the Adobe AIR offering” as well as RefreshingApps.com. He also mentioned that word concerning “AIR stuff and RefreshingApps” will likely be delivered by Adobe sometime this week.</p><p>---Related Articles at Mashable! - The Social Networking Blog:<a href="http://mashable.com/2008/07/06/adobe-air-tm/">Adobe Lays Claim To AIR (In The Web Domain Space)</a><a href="http://mashable.com/2007/10/10/adobe-security-flaw/">Adobe Can&#8217;t Fix Security Flaw Until End of October</a><a href="http://mashable.com/2007/08/14/adobe-office-applications/">Adobe Building Office Apps to Go After Microsoft?</a><a href="http://mashable.com/2007/08/20/adobe-flash-player-9/">Adobe Launches Updated Flash Player 9:  Moviestar</a><a href="http://mashable.com/2007/10/01/adobe-buzzword/">Adobe to Acquire Makers of Web-Based Word Processor Buzzword</a><a href="http://mashable.com/2007/09/21/adobe-vulnerability/">Beware of PDF Files! Adobe Security Vulnerability Found.</a><a href="http://mashable.com/2007/05/30/adobe-delicious/">Adobe Illustrator Integrated with Del.icio.us</a></p><img src="http://mashable.com/wp-content/uploads/2008/07/refreshingapps.png" alt="" />', 'Mashable!');
INSERT INTO {PREFIX}_article_page_content (page_id, article_id, content_detail, author) VALUES (34, 34, '<p>This week\'s edition of<a href="http://adage.com/mediaworks/article?article_id=129774" target="_blank">Advertising Age</a>has a somewhat revealing piece concerning movements in Web media space by some old media titans. In particular,<a href="http://mashable.com/2008/04/20/wsj-vs-nyt/">The New York Times versus The Wall Street Journal</a>. We\'ve heard the WSJ talk adventurous talk in months past about conditioning itself to compete more effectively in the general news space with the NYT. Now it\'s being said that, in addition to the NYT\'s attempts to draw itself<a href="http://www.mashable.com/2008/06/18/nytimes-timespeople/">further into the social realm</a>online, the outfit is pressing to meet the WSJ in its own court: business.</p><p>Indeed, according to Vivian Schiller, senior vice president and general manager of the NYT\'s website, coverage will grow in the areas of “the economy, energy, small business, personal finance and enterprise technology,” all of it constructed into verticals in vein of the popular<a href="http://dealbook.blogs.nytimes.com/" target="_blank">DealBook</a>blog. This move was recently hinted at by John Markoff, a writer and reporter for the paper, while sitting as a guest on a recent episode of&#8220;<a href="http://www.crankygeeks.com/2008/07/episode_124_the_future_of_tech.php" target="_blank">Cranky Geeks</a>,&#8221; a weekly video podcast hosted by John C. Dvorak.</p><p>I must say, this is fairly interesting information to consider. The Wall Street Journal has made known its intention to increase the value of its website\'s components in the area of business, along with a<a href="http://mashable.com/2008/04/20/wsj-vs-nyt/">general site-wide refresh</a>scheduled for the fall season, which might help to spur its paid subscription platform further. (This despite a move by The New York Times to<a href="http://www.mashable.com/2007/09/17/timesselect-officially-free-and-other-nyt-stuff-too/">eliminate virtually all reader fees</a>on the Web.)</p><p>And now that The New York Times is said to be working on delivering expanded business coverage, which one would presume will be entirely ad-supported, The New York Times is evidently leaving little to chance. Staff layoffs aside, it\'s evidently working to challenge The Wall Street Journal in its primary domain. The logic seems to be, when all is said and done, to fight fire with fire.</p><p>The questions to ask now seems to be: Could this mean that WSJ.com will have to play defense against NYTimes.com? Will favored business coverage continue to fall to WSJ.com? And, reversely, will the traditional strength of varietal reporting by NYTimes.com become stretched and diminish in stature with the WSJ.com coming up closely behind?</p><p>It seems to me that both news organizations will retain some allegiance among readers. But while the generations that have lived largely with paper are replaced with the generations that rely mostly on computer-enabled information consumption, crossover will occur at an increasing rate. It\'s already done so to large degree, in fact. And at this point in time, my impression is that, for WSJ.com to achieve the ends it seeks, it will have to submit to the call for free-access to its content.</p><p>That simple. On the Web it&#8217;s a numbers game. It\'s a matter of who has more readers and how much they read. In that respect, NYTimes.com is the better bet right now. (Eventually, reader wealth demographics will become more and more important as well.)</p><p>---Related Articles at Mashable! - The Social Networking Blog:<a href="http://mashable.com/2007/07/16/business-20-getting-the-axe/">Business 2.0 May Be Getting the Axe from Time Inc.</a><a href="http://mashable.com/2007/09/04/business-20-closing/">Business 2.0 Says Goodbye</a><a href="http://mashable.com/2007/10/26/business-30-facebook-app/">Business 3.0 Facebook App Doesn&#8217;t Live Up to its Name</a><a href="http://mashable.com/2007/08/06/google-business-referral/">Google Will Pay You to Add Business Info to Maps</a><a href="http://mashable.com/2008/01/21/iphone-now-wears-a-suit-att-unveils-business-plan/">iPhone Now Wears a Suit: AT&#038;T Unveils Business Plan</a><a href="http://mashable.com/2007/09/06/zoho-business/">Zoho Business Launching At Office 2.0 Conference</a><a href="http://mashable.com/2005/09/19/business-week-online-covers-web-20/">Business Week Online Covers Web 2.0</a></p><img src="http://mashable.com/wp-content/uploads/2008/04/nytwsj.jpg" alt="" />', 'Mashable!');
INSERT INTO {PREFIX}_article_page_content (page_id, article_id, content_detail, author) VALUES (35, 35, '<p>As has been widely reported by tech media outlets for a few days now, Facebook filed a<a href="http://mashable.com/2008/07/19/fed-up-with-german-copycat-facebook-unleashes-the-lawyers/">lawsuit against studiVZ</a>Ltd. in California federal court on Friday claiming the German network had copied its“look, feel, features and services.” Today the recipient of the suit issued a public response on the matter. StudiVZ said that prior to Facebook\'s own filing in the U.S., lawyers representing Palo Alto-based network had communicated messages that “prompted studiVZ to file for a declaratory judgment at the District Court in Stuttgart, Germany” the same day.<a href="http://www.studivz.net/" target="_blank">StudiVZ</a>would not elaborate as of yet, however, saying that it had not been formally served with Facebook\'s complaint, and therefore “cannot comment in detail about the content of the claims.”</p><p><a href="http://mashable.com/wp-content/uploads/2008/07/marcus.png"></a>StudiVZ CEO Marcus Riecke delivered a statement along with the company\'s brief summary of Friday\'s events:</p><p>“Now that Facebook, despite trying hard, has not been successful in the German market, the company seeks to obstruct studiVZ through court action. Their strategy appears to be: If you can&#8217;t beat them, sue them.</p><p>“There are numerous social networks. Facebook was not the first and certainly isn&#8217;t the only one. By attempting to harm studiVZ through a meritless California lawsuit, Facebook is arrogantly laying claim to an international monopoly over social networking sites that the facts show it does not deserve.&#8221;</p><p>---Related Articles at Mashable! - The Social Networking Blog:<a href="http://mashable.com/2007/01/03/studivz/">StudiVZ Acquired For $112M</a><a href="http://mashable.com/2008/07/19/fed-up-with-german-copycat-facebook-unleashes-the-lawyers/">Fed Up With German Copycat, Facebook Unleashes the Lawyers</a><a href="http://mashable.com/2007/08/19/doktus/">Doktus, German Scribd Clone: Samwer Brothers At It Again?</a><a href="http://mashable.com/2006/11/15/studivz-controversy-surrounds-facebook-rip-off/">StudiVZ - Massive Controversy Surrounds Facebook Rip-Off</a><a href="http://mashable.com/2007/09/03/myvideode-acquired/">German YouTube Clone Acquired by TV Station</a><a href="http://mashable.com/2008/01/15/facebook-samwer-brothers/">Facebook Gets New Investors: Samwer Brothers for European Expansion</a><a href="http://mashable.com/2007/07/11/10-facebook-clones/">Copycats: Top 10 International Facebook Clones</a></p><img src="http://mashable.com/wp-content/uploads/2008/07/studivz.png" alt="" />', 'Mashable!');
INSERT INTO {PREFIX}_article_page_content (page_id, article_id, content_detail, author) VALUES (36, 36, '<p>Combine the element of Web search with music playback and a mohawk-sporting, ciggie-smoking dinosaur, and you get<a href="http://mixturtle.com/" target="_blank">MixTurtle</a>, a new service that works as you might expect it to. Just click and play.</p><p>Ajax is responsible making it behave as it does. Some might consider it bit too heavy on the large print. Everything but the topmost menu is sized big. But this is fairly easy to get accustomed to. And there\'s an upside to the design choice. The results are easy to make sense of. If your music search produces an especially large volume of material, this can really prove helpful in finding what you\'re looking for.</p><p>Most impressive with MixTurtle, whose content sources are absent the picture, is the sheer speed with which information is displayed. Begin to type a keyword, and you\'re immediately shown a selection of choices in a drop-down overlay. You can select one listed or continue with your query by manually inputting any desired text. Once you\'ve entered your search, the rate of return is all but instant. I don\'t recall testing any other engine with such alacrity.Not<a href="http://mashable.com/2008/02/04/songerize/">Seeqpod</a>, not<a href="http://www.mashable.com/2008/03/04/songza-profiles/">Songza</a>, not any other. This little reptile has one heck of a rocket affixed to its rear, for sure.</p><p>The rest of the engine is fairly self-explanatory. As noted directly above the results box, you can add songs to a playlist, which you can call on any subsequently visit once you sign up for a free account.</p><p>To play back music, you click the artist/track label. Click again to pause. A slim submenu emerges directly below the chosen song, which displays the buffer bar, the number of sources discovered to hold said track, and an option to browse other sources. That last item may not prove too useful, however, since MixTurtle automatically begins to plays a song. (Note: sometimes a request or a user name and password will surface for a particular track.)</p><img src="http://mashable.com/wp-content/uploads/2008/07/mixturtle.png" alt="" />', 'Mashable!');
INSERT INTO {PREFIX}_article_page_content (page_id, article_id, content_detail, author) VALUES (37, 37, '<p>I\'ve been scrolling slowly down the list of items mentioned by Paul Graham, a partner at the startup micro-financier outfit<a href="http://ycombinator.com/" target="_blank">Y Combinator</a>, in a piece titled“<a href="http://ycombinator.com/ideas.html" target="_blank">Startup Ideas We\'d Like to Fund</a>.” It\'s an interesting write-up, and I think a whole lot of people should give it a look. Not necessarily because genius resides within. In fact, a lot of what Graham says will strike most any reader as fairly obviously wanting for the wand of progress.</p><p>There are some points raised, however, that either seem too vague or uninformative, or just plain unnecessary, to be worth a“new” attempt. Of course, I do recognize that Graham\'s post is only a soft invitation for startups to submit ideas to Y Combinator. And, well, it would be pretty senseless to object to the inclinations of the firm. That\'s not what I intend for here. Rather, I simply wish to parse some itemsthat I consider superfluous and unnecessary. The kind of stuff that invokes the “been there, done that” adage, in other words. Ideas that already have solid representation on the Web, and don&#8217;t require major fixes or alterations.</p><p>First, there is the idea posited by YC (I\'ll abbreviate it investor\'s name from here on out) for a fresh startup to compete with Microsoft. Now, a plan to take on Redmond is all good and well. An admirable goal for sure. But others are already working toward that objective.<a href="http://www.mashable.com/2008/04/13/salesforce-for-google-apps/">Google</a>is one.<a href="http://www.mashable.com/2008/05/14/zoho-openid/">Zoho</a>is another.<a href="http://www.mashable.com/2008/06/01/adobe-acrobat/">Adobe</a>recently introduced its own suite as well. And while they may ideally prefer to engineer a collective effort to bring down the software market\'s reigning cash cow, they will no doubt look after their own health above all other concerns. Save for an acquisition, new rising stars aren\'t likely to grow so tall, in other words. But with the tech sector feeling a few pangs of financial caution, the idea of buying only what you need would logically come to the fore. So at this point, I\'ll short any newbies to this particular segment of the Web application market.</p><p>Photo/video sharing services are another group on YC\'s agenda. Why that is is somewhat of a mystery to me.<a href="http://www.mashable.com/2007/08/04/flickr-toolbox/">Flickr</a>,<a href="http://www.mashable.com/2008/07/10/photobucket-iphone/">Photobucket</a>,<a href="http://mashable.com/2008/07/20/facebook-redesign/">Facebook</a>are all solid examples. YC explains that“there may ultimately be 30 different subtypes of image/video sharing services, have of which remain to be discovered.” I\'m not so sure about that. People like having reams of data at their fingertips. That\'s part of the reason why industry\'s giant have succeeded. Everyone likes a winner,right? As for serving the long tail of the Web, where photo and video users may prefer to take their media host service\'s platform and adapt it to fit conditions on personal websites, that can already be accomplished.<a href="http://www.smugmug.com/" target="_blank">SmugMug</a>is a nice example of this, actually.</p><p>On entirely separate note, while Y Combinator imagines there are“better” dating sites to come, I would say the life of those networks is finite. I sure hope so, anyway. To approach the concept in a different way, dating sites will simply be replaced by your run-of-the-mill<a href="http://mashable.com/category/social-networking">social networking services</a>. Mobile ones, especially. To keep perpetuating this idea of specialized matchmaking through ample profile metadata and the like is simply absurd. It may work some of the time, but it doesn\'t work enough of the time.</p><p>I really wish<a href="http://www.wikipedia.org" target="_blank">Wikipedia</a>alternatives much luck, because they\'ll need it.<a href="http://www.mashable.com/2008/07/18/wikipedia-with-approvals-boring-wikipedia/">Wikipedia</a>may evolve, it may invoke new layers of security, it may open itself up to cool new (or old) sources of information. But the chance of Wikipedia actually being irretrievably challenged or supplanted in the foreseeable future is [insert dirty word(s) here]. Wikipedia is going to be the new encyclopedia. It may not be something taken seriously by [insert name of educational or professional institution here] now, but it shall. The fact of the matter is that Wikipedia has been built on a collective brain power similar in structure to that which built the Oxford English Dictionary. And how is the OED considered by academics, might I ask?</p><p>Lastly, I\'d like to highlight an idea put forth by YC placed somewhere near the  middle of its list of 30. This one is 16. It reads as such:</p><p>&#8220;A form of search that depends on design. Google doesn&#8217;t have a lot of weaknesses. One of the biggest is that they have no sense of design. They do the next best thing, which is to keep things sparse. But if there were a kind of search that depended a lot on design, a startup might actually be able to beat Google at search&#8230;.”</p><p>There are a number of things wrong with that statement. For one, Google may not seem to have any sense of design for some, but it does. It\'s actually described in Paul Graham\'s subsequent line. Indeed, sparseness is Google\'s schtick.</p><p>That, and a super-simple color palette. Those appear to be the fundamentals for the company\'s overarching design. And years and years of experience and trend setting and all other things that go into making an Internet company into a Internet giant and an Internet leader have shown that Google has largely been walking the right path. No, its engine doesn\'t connote iPod-like elegance.Goodness sake, though, its primary businesses are search and advertising. How in the world do you make that visually delightful and retain a modicum of user friendliness?</p><p>An even more pressing question to ask: What makes one think that fantastic design alone is a prescription for beating Google? There\'s already quite a visually attractive alternative to Google. It\'s called<a href="http://www.ask.com">Ask.com</a>. Take a look. You\'ll see. And it\'s nowhere near #1.</p><p>To end, I would say that, taken as a largely suggestive request for fresh ideas, Graham\'s solicitation definitely has its strong points. If some number of startups manage to develop something that addresses many of the weak spots in the Internet market currently afflicting users - particularly the non-tech-savvy - and those startups happen to take the route of YC, the firm\'s partners could be riding some serious gravy trains. New ideas are what will let milk and honey flow. Companies which try to address the topics parsed above, however, aren\'t likely to reach such grand heights.</p><p>---Related Articles at Mashable! - The Social Networking Blog:<a href="http://mashable.com/2007/10/30/soupio-microblogging/">Soup.io Offers Simplest Microblogging Yet</a><a href="http://mashable.com/2007/03/28/myspace-slideshows-heysan/">MySpace Slideshows from Your Phone - HeySan</a><a href="http://mashable.com/2007/08/08/disqus/">Disqus Challenges CoComment</a><a href="http://mashable.com/2008/06/30/tws2008-tel-aviv/">Tomorrow in Tel Aviv: TWS2008</a><a href="http://mashable.com/2008/07/16/free-advertising/">Free Advertising on Mashable for Three Lucky Startups</a><a href="http://mashable.com/2006/02/11/new-mashable-blog-weblist/">New Mashable Blog - Weblist!</a><a href="http://mashable.com/2007/08/30/seedcamps-20-startups-revealed/">Seedcamp&#8217;s 20 Startups Revealed</a></p><img src="http://mashable.com/wp-content/uploads/2008/07/ycombinator.png" alt="" />', 'Mashable!');
INSERT INTO {PREFIX}_article_page_content (page_id, article_id, content_detail, author) VALUES (38, 38, '<p>Alright, so<a href="http://www.facebook.com" target="_blank">Facebook</a>kind of failed to accurately estimate when it would be taking long-talked-about profile redesign. The number last tossed around was<a href="http://mashable.com/2008/07/07/facebook-profiles-beta/">July 16</a>. The day came, the day went, and nothing. No changes made. That may have made for an anticlimactic Wednesday for some. So will the second try, scheduled for this evening, according to Justin Smith of<a href="http://www.insidefacebook.com/2008/07/19/facebook-redesign-beta-now-going-live-on-sunday-night/" target="_blank">Inside Facebook</a>, turn out to be the true charmer?</p><p>As you may be aware, Facebook has been<a href="http://mashable.com/2008/07/14/future-facebook-profiles/">teasing users</a>as of late with a<a href="http://www.new.facebook.com/" target="_blank">test page</a>to give a glimpse of what\'s to come. And the network began in Spring to<a href="http://mashable.com/2008/05/23/facebook-profile-redesign-sandbo/">allow developers</a>to familiarize themselves with the new layout. When doors officially open, all of Facebook\'s members will be access, albeit through a transitional, opt-in model.</p><p>The upgrade to the profile page isn\'t a whirlwind transformation. Most users will likely intuit for themselves how to manage their information in no time. But it\'s a welcome move all the same. The current design has been in place for quite a while. Lots of things in the social networking space have evolved with the seasons. Facebook would do well to alter itself a bit, too.</p><p>Of course, it\'s largest task has been bringing application developers into alignment. If you\'re counting on an entirely glitch-less upgrade, you may be in luck. Or you may not. Much may depend on your chosen third-party installs. In that respect, there\'s still some chance for a bit of disappointment. And as far as potential hiccups on Facebook\'s end, well, suffice it to say that the company acknowledged a problem with API performance days after days after the profile update was originally intended for public launch.</p><p>---Related Articles at Mashable! - The Social Networking Blog:<a href="http://mashable.com/2008/05/23/facebook-profile-redesign-sandbo/">Facebook Profile Redesign: Sandbox Now Open to Developers</a><a href="http://mashable.com/2008/04/13/facebook-delays-redesign/">Facebook Puts Off Early April Redesign</a><a href="http://mashable.com/2008/05/07/facebook-redesign-are-developers-ready/">Facebook Redesign: Are Developers Ready?</a><a href="http://mashable.com/2007/04/11/facebook-design/">Facebook Guy Dead at 3: Poke in Peace</a><a href="http://mashable.com/2008/07/07/facebook-profiles-beta/">Facebook Profile Redesign Beta Launches July 16th. Are Users Ready?</a><a href="http://mashable.com/2007/07/16/yellowpages-redesign/">YellowPages Redesigned to Better Accommodate Local Search</a><a href="http://mashable.com/2008/06/19/facebook-matt-cohler/">Facebook Loses Another Early Executive</a></p><img src="http://mashable.com/wp-content/uploads/2008/07/facebook-redesign.png" alt="" />', 'Mashable!');
INSERT INTO {PREFIX}_article_page_content (page_id, article_id, content_detail, author) VALUES (39, 39, '<p>The short answer is that they want it to fail. There seems to be an underpinning of glee to get to deadpool it, and no one has told them it&#8217;s no longer trendy to call podcasting a failure anymore.</p><p>The long answer has to do with a lot of factors.  The subject is brought to my attention by Ian Lamont, who&#8217;s<a href="http://www.thestandard.com/news/2008/07/18/why-podcasting-failing-part-ii-lessons-podtech" target="_blank">written another weekend article that takes a hit out on podcasting</a>as an industry due to the failings of a few. In an editorial published today, Ian talks about the black eye podcasting as a whole has recieved as a result of the<a href="http://mashable.com/2008/07/17/podtech-sold/">failure of PodTech</a>to sell for more than half a million.</p><p>Just as I predicted at the end of that article, the myopic analysis on the&#8220;death of podcasting&#8221; is beginning anew. Ian pontificates:</p><p>&#8220;&#8230;[M]y original thesis: Podcasting is failing as a business platform, and has failed to make a mainstream impact [...] But even if the stars had stuck around to the end, and the management and board problems were addressed earlier, I have to wonder how well this venture would have done. This was a hyped business built on one of the most hyped technologies of 2005. Once the that faded, reality set in. As I pointed out in my original post, there are a lot of factors that are working against podcasting. Making programs is a labor-intensive process requiring special skills. In addition, there is no AdSense or AdWords equivalents for podcasts&#8212; advertising has to be sold, produced, and placed by humans.&#8221;</p><p>When it comes down to it, though, Ian only has a few points to prop up his diagnosis of podcasting: PodTech more or less failed in the end, podcasting was overhyped and his analysis of a podcasting survey<a href="http://www.pewinternet.org/PPF/r/193/report_display.asp" target="_blank">from two years ago</a>shows that there&#8217;s no growth in podcasting.</p><p>The problem is that his analysis has little basis in reality. Podcasting has evolved a bit since PodTech was founded, and those getting into it now have a much clearer vision of what it means to go about podcasting in a profitable manner. For those with established brands, it isn&#8217;t particularly difficult to make a profitable go of it (there are a number folks out there doing that, including us here at Mashable).</p><p>Even for those wanting to start from nothing in the business, there are a number of established podcast companies that are out there.  Some of them have some very impressive revenues, and some are squarely profitable. There are even a number of folks outthere doing a full-time living just with indie podcasting alone, many of which we&#8217;ve covered here at Mashable.</p><p>In case you need to review proof podcasting isn&#8217;t dead:</p><p><a href="http://mashable.com/2008/03/18/wizzard-record-profit/">Wizzard has a great 2007</a>, and a<a href="http://mashable.com/2008/05/10/wizzard-sees-first-quarter-revenue-grow-130/">superb Q1 2008</a>. In 2007, they grossed over $5 million, and in the first quarter of 2008, they increased revenues by 130%.</p><p><a href="http://mashable.com/2008/06/04/leo-laporte-stickam/">Leo Laporte hauls down a chunk of change</a>.  In June, we reported that Leo Laporte landed a $100,000 contract with video streamer Stickam. Leo left us a comment to correct us - it wasn&#8217;t a $100k check, as we made it sound, but a revenue sharing agreement that he had hopes would bring down much more than that (this, of course, in addition to all the other money he brings in with his podcasting mini-empire).</p><p><a href="http://mashable.com/2007/11/10/blinkx-offers-big-bucks-for-video/">BlinkX Hits $60 CPM on Video</a>. Granted it&#8217;s a select segment of the market, but showing hard proof that podcasting can be big business is harder to better exemplify elsewhere.</p><p><a href="http://mashable.com/2007/12/03/internet-video-producers-have-a-plan/" target="_blank">Smartassed Ninja Makes $50,000 in Eight Months</a>. Everyone&#8217;s favorite wise-cracking ninja made a nice chunk of change before going on to make the millions with official sponsorship and millions of video views per episode.</p><p>Podcasting isn&#8217;t dead, it isn&#8217;t a failure, and it isn&#8217;t impossible to build a business around.  It isn&#8217;t necessarily what we thought it was when we first started up with it.  A lot of us early adopters got stars and money signs in our eyes when we first started playing with podcasting.  PodTech did a lot of adapting to the realities of the business, and the VCs ultimately didn&#8217;t care to make those adaptations with them, which is a big reason why it failed.</p><p>Again, though, to say that PodTech&#8217;s ultimate failure is somehow an inherent failure to the concept of podcasting is about like blaming the hammer for fall of London Bridge and the Leaning Tower of Pisa.</p><p>---Related Articles at Mashable! - The Social Networking Blog:<a href="http://mashable.com/2008/01/20/2007-twas-a-great-year-for-podcasting/">2007:&#8216;Twas A Great Year For Podcasting</a><a href="http://mashable.com/2008/01/09/video-podcasting-coming-to-tivo-and-thus-mainstream-audiences/">Video Podcasting Coming to TiVo and Thus Mainstream Audiences</a><a href="http://mashable.com/2007/11/18/wizzard-media-joins-the-navy/">Wizzard Media Joins the Navy</a><a href="http://mashable.com/2007/09/11/shoephone/">TalkShoe Launches ShoePhone: Cross Platform VoIP for Unlimited Conference Calls</a><a href="http://mashable.com/2006/06/11/podtechnet-gets-scobleized/">PodTech.net Gets Scobleized</a><a href="http://mashable.com/2007/10/16/doppler-open-source/">Doppler Podcast Client Now Open Source</a><a href="http://mashable.com/2008/03/14/podshow-layoffs/">PodShow: There Are No Layoffs, Only Jobs You No Longer Have</a></p><img src="http://www.mashable.com/images/podtech.PNG" alt="" />', 'Mashable!');
INSERT INTO {PREFIX}_article_page_content (page_id, article_id, content_detail, author) VALUES (40, 40, '<p>If you\'re educator near the middle of the K-12 curriculum, and you\'re feeling a bit lacking in terms of online tools available to help increase your own efficiency in the case of schoolwork, this item may be worth a look. It\'s called Lesson Writer, and it\'s something that can aid you in cranking out a basic lesson (and plan) for particular course on a given day. If you\'re short for time, or consider the lesson-creation element of your workflow best left up to a series of code to piece together,<a href="http://www.lessonwriter.com/" target="_blank">Lesson Writer</a>may go far in getting you to crunch through your own set of tasks outside the classroom more quickly.</p><p>There isn\'t too much that needs explaining about Lesson Writer. If you stumble across a website whose content you\'d like to include in an agenda for a future day (or perhaps the very same school session that happens to call you to two or more places at once and leaves you with little time to manufacturepapers for class), you can select any interesting text and paste it into a draft page for a new lesson. Once you\'ve submitted said text to the Lesson Writer engine, you\'re taken through a process of choosing any that Lesson Writer deems pertinent. This goes for things like vocabulary, grammar and so forth. You can add your own custom critical thinking queries for students at the final step.</p><p>There\'s certainly a limit to what you can accomplish through Lesson Writer. Complex algebraic problems aren\'t part of the package. The extent to Lesson Writer\'s powers seems to be very plainly hinted in its title. It seems only some elementary Language Arts and perhaps some History and Civics lessons can be assembled through the service. And if you prefer to interact with lessons created by other teachers in well-engineered environment, you might do well to consult with the<a href="http://mashable.com/2007/08/23/yahoo-teachers/">Yahoo Teachers</a>beta program.</p><p>Yet, if you&#8217;re tasked with managing a variety of subjects in a given day as instructor/disciplinarian/mediator/etc., and are wanting terribly for a quick and easy backup lesson solution, and don\'t happen have your own personal living and breathing teaching assistant, Lesson Writer could very well work to complement your grind if/when the moment requires it.</p><p>---Related Articles at Mashable! - The Social Networking Blog:<a href="http://mashable.com/2007/05/30/windows-live-writer-new-release/">Windows Live Writer Launches Beta 2</a><a href="http://mashable.com/2007/08/23/yahoo-teachers/">Yahoo Teachers: Social Network for Teachers</a><a href="http://mashable.com/2007/09/18/trymango/">Learn Foreign Language for Free with Mango</a><a href="http://mashable.com/2007/10/17/kantalk/">How to Use YouTube to Learn English: FunTalk</a><a href="http://mashable.com/2008/02/27/zoho-writer-updates-2/">Zoho Writer Gets Thesaurus And File Export Upgrades</a><a href="http://mashable.com/2005/12/26/the-delicious-lesson-putting-personal-value-before-network-effect/">The Del.icio.us Lesson - Putting Personal Value Before Network Value</a><a href="http://mashable.com/2007/11/14/zoho-writer-updates/">Zoho Writer Gets More Professional</a></p><img src="http://mashable.com/wp-content/uploads/2008/07/lessonwriter.png" alt="" />', 'Mashable!');
INSERT INTO {PREFIX}_article_page_content (page_id, article_id, content_detail, author) VALUES (41, 41, '<p><a href="http://www.rediff.com/" target="_blank"></a></p><p><a href="http://www.rediff.com/" target="_blank">Rediff</a>, one of the top online portals in India and one currently listed on the<a href="http://finance.yahoo.com/q?s=redf" target="_blank">NASDAQ</a>stock market, has evidently followed the past year progress of third-party developments within Facebook closely. Now it wants to stir a similar amount of interest in its own set of properties as well. Announced at Delhi\'s<a href="http://www.proto.in/" target="_blank">Proto.in</a>startup event, Rediff officially took the covers off its own developer program, called, plainly enough,<a href="http://developer.rediff.com/" target="_blank">The Rediff Platform</a>.</p><p>The reason for the Facebook reference is simple. The company states that its properties are“being made&#8230;to support<a href="http://developers.facebook.com/" target="_blank">FBML</a>,” Facebook\'s markup language.</p><p>Indeed,<a href="http://www.mashable.com/2007/07/15/google-yahoo-want-to-acquire-rediff/">Rediff</a>is pushing an idea eminently synonymous with Facebook\'s own. The phrase “apps economy” is writ large on the Rediff Developers page. But it\'s also an effort that the company hopes will align with multiple pieces of the Rediff puzzle. To kick off the developer program, Rediff is first opening<a href="http://www.mashable.com/2007/07/12/ishare/" target="_blank">iShare</a>, its music, video, and photo sharing service.</p><p>The company is promising grants to some students and entrepreneur developers through a basic submission program it is calling“Sociali.” The sum being touted by the company to fuel ideas thought promising ideas is 250,000 rupees, or US$5,800. A relatively small figure, it seems, especially if juxtaposed against Rediff\'s expected revenue report for Q2 2008 (roughly $17 million). All may depend on the supply of developers Rediff finds enticing enough to fund in the weeks and months ahead.</p><p>The company states that developers ready to begin fabricating can now do so with data provided through<a href="http://developer.rediff.com/" target="_blank">its new website</a>.</p><p>---Related Articles at Mashable! - The Social Networking Blog:<a href="http://mashable.com/2007/07/15/google-yahoo-want-to-acquire-rediff/">Google and Yahoo Looking to Acquire India-Based Rediff</a><a href="http://mashable.com/2007/07/12/ishare/">iShare, The Indian YouTube</a><a href="http://mashable.com/2007/07/18/yahoo-acquires-stake-in-tyroo/">Yahoo Takes Large Stake in India&#8217;s Tyroo Media</a><a href="http://mashable.com/2008/02/06/myspace-developer-platform-poll/">The Daily Poll: Would You Build Apps for the MySpace Developer Platform?</a><a href="http://mashable.com/2007/10/12/linkedin-platform/">LinkedIn Outlines Strategy for Upcoming Platform</a><a href="http://mashable.com/2007/06/13/clearspring-community-platform/">Clearspring Opens Community Platform for Developers</a><a href="http://mashable.com/2008/03/07/platform-poll/">The Daily Poll: Which Platform is the Best Opportunity for Developers?</a></p><img src="http://mashable.com/wp-content/uploads/2008/07/rediff.png" alt="" />', 'Mashable!');
INSERT INTO {PREFIX}_article_page_content (page_id, article_id, content_detail, author) VALUES (42, 42, 'Adam DuVander over at WebMonkey has compiled a list of their five favorite Firebug extensions. The ever-popular YSlow tops the list, but to that they add:\n\nFirecookie for easy access to cookie information\nFirePHP to integrating server-provided PHP debugging information with the Firebug UI\nPixel Perfect for overlaying mock-ups on top of the real thing to ensure you&#8217;ve [...]', '');
INSERT INTO {PREFIX}_article_page_content (page_id, article_id, content_detail, author) VALUES (43, 43, 'John Resig continues his streak of compelling blog entries with "DOM DocumentFragments" where he shows that:\n\nA method that is largely ignored in modern web development can provide some serious (2-3x) performance improvements to your DOM manipulation.\n\nThe technique shown is compatible across a large swath of modern browsers, including our friend IE6. Here\'s an example of [...]', '');
INSERT INTO {PREFIX}_article_page_content (page_id, article_id, content_detail, author) VALUES (44, 44, 'John Allsop wrote a long piece over at Web Directions South with some thoughts on writing native iPhone apps versus web-based iPhone apps.\nThe obvious flaw in his piece is that he only looked at free iPhone applications and from that subset concluded that almost everything the native apps do could be done with web applications [...]', '');
INSERT INTO {PREFIX}_article_page_content (page_id, article_id, content_detail, author) VALUES (45, 45, 'Edward Tufte has long had a following of fans in the field of information visualizations. Among his interesting taxonomy of visualization types is the "Sparkline", which he describes as "data-intense, design-simple, word-sized graphics".\nWhile Tufte originally suggested that computer displays are too low-resolution to effectively make use of Sparklines (vs. printed page), James Dempster pointed us [...]', '');
INSERT INTO {PREFIX}_article_page_content (page_id, article_id, content_detail, author) VALUES (46, 46, 'Great news for all Web developers out there (that be you!). Firebug is going to get a shot in the arm. Joe Hewitt has had to slow down his work on the tool, and thus the Firebug Working Group was created, to try to make the tool continue to thrive.\nThe work has been mainly done [...]', '');
INSERT INTO {PREFIX}_article_page_content (page_id, article_id, content_detail, author) VALUES (47, 47, 'Developers are always looking for a great grid control that is easy to use, customizable and, of course, feature-rich. Paulo MariÃ±as has created just that for jQuery developers. Flexigrid is an extremely flexible grid control with provides many of the features highly-desired by developers. These include:\n\nResizable columns\nResizable height and width\nSortable column headers\nCool theme\nCan convert an [...]', '');
INSERT INTO {PREFIX}_article_page_content (page_id, article_id, content_detail, author) VALUES (48, 48, 'With a young son, I often listen to the "Reduce, Reuse, Recycle" song by Jack Johnson for the Curious George movie. Edgar Hassler has taken that axiom and applied it to code.\nEdgar goes into a lot of detail, including the following issue that he ran into:\n\nThe problem I kept having was that I needed to [...]', '');
INSERT INTO {PREFIX}_article_page_content (page_id, article_id, content_detail, author) VALUES (49, 49, 'PLAIN TEXT\nJAVASCRIPT:\n\n\n\n\n&#160;\n\n\nClass.create = &#40;function&#40;original&#41; &#123;\n\n\n&#160; var fn = function&#40;&#41; &#123;\n\n\n&#160; &#160; var result = original.apply&#40;null, arguments&#41;;\n\n\n&#160; &#160; result.toString = function&#40;&#41; &#123; return result.prototype.initialize.toString&#40;&#41; &#125;;\n\n\n&#160; &#160; return result;\n\n\n&#160; &#125;;\n\n\n&#160; fn.toString = function&#40;&#41;&#123; return original.toString&#40;&#41; &#125;;\n\n\n&#160; return fn;\n\n\n&#125;&#41;&#40;Class.create&#41;;\n\n\n&#160;\n\n\n\n\n\nThis monkey patch by kangax allows you to get sense from inspecting a constructor setup via Prototype.\nHis code changes a [...]', '');
INSERT INTO {PREFIX}_article_page_content (page_id, article_id, content_detail, author) VALUES (50, 50, 'I work on Google Code. Hearing that Radiohead was going to release data with progressive licensing and wanted to do so on Google Code was awesome.\nNow we see how cool it is that the data is open. People like Jacob Seidelin are doing interesting things with it.\nIn this case, Jacob has created amazing visualizations of [...]', '');
INSERT INTO {PREFIX}_article_page_content (page_id, article_id, content_detail, author) VALUES (51, 51, 'Mathieu Henri saw Scott Schiller\'s generated favicons VU meter and wanted to "push the concept of generated favicons further and pack a thrilling retro shooter in 16Ã—16 pixels using JavaScript, canvas and data: URIs."\nWow. He went and did it. The entire game runs in the favicon!\n\nDEFENDER of the favicon was done in 3 nights, from [...]', '');
INSERT INTO {PREFIX}_article_page_content (page_id, article_id, content_detail, author) VALUES (52, 52, 'Jeffrey Barke has written up a tutorial detailing how to create a density map with Prototype, the Google Maps API and the HeatMapAPI.\nThe heat map API looks cool indeed, and that piece of code looks simple:\nPLAIN TEXT\nJAVASCRIPT:\n\n\n\n\n&#160;\n\n\naddHeatMap: function&#40;&#41; &#123;\n\n\nvar heatMap = new GEOHeatmap&#40;&#41;;\n\n\nheatMap.Init&#40;this.width, this.height&#41;;\n\n\nheatMap.SetData&#40;this.data&#41;;\n\n\nvar preUrl = heatMap.GetURL&#40;&#41;;\n\n\nvar heatmapOverlay = new HMGoogleOverlay&#40;preUrl&#41;;\n\n\nthis.map.addOverlay&#40;heatmapOverlay&#41;;\n\n\n&#125;\n\n\n&#160;', '');
INSERT INTO {PREFIX}_article_page_content (page_id, article_id, content_detail, author) VALUES (53, 53, 'Ah the age old IEPNGFix solution to the problem that we had with IE 5.5 / 6.0 not supporting alpha transparency. The first IEPNGFix solved the problem:\n\nThis script adds near-native PNG support with alpha opacity to IE 5.5 and 6. Now you can have full translucency and no more ugly grey borders! It requires only [...]', '');
INSERT INTO {PREFIX}_article_page_content (page_id, article_id, content_detail, author) VALUES (54, 54, 'Colin Moock has been creating some buzz in the Flash community with his article on the charges against ActionScript 3.0:\n\nThe removal of on()/onClipEvent() from Flash CS3 makes creating simple interactivity hard.\nGetting rid of loaded .swf files is hard.\nCasting DisplayObject.parent makes controlling parent movie clips hard.\nThe removal of getURL() makes linking hard.\nThe removal of loadMovie() makes [...]', '');
INSERT INTO {PREFIX}_article_page_content (page_id, article_id, content_detail, author) VALUES (55, 55, 'Dojo developers will be pleased to read about the recent update to the Dojo grid control. Version 1.2 of the grid control focuses primarily on improving integration with Dojo data stores, improved grid layout handling and providing advanced in-place editing capabilities. The update was fairly extensive forcing the team to rethink the design of the [...]', '');
INSERT INTO {PREFIX}_article_page_content (page_id, article_id, content_detail, author) VALUES (56, 56, 'The Humanized folk who now work in Mozilla Labs have taken their Enso work and created Ubiquity, a Firefox plugin that implements the Graphical Keyboard User Interface:\n\nWeb applications, much the same as desktop applications, are a bit like isolated cities: itâ€™s difficult for an end-user to arbitrarily share data and functionality between them. This is [...]', '');
INSERT INTO {PREFIX}_article_page_content (page_id, article_id, content_detail, author) VALUES (57, 57, 'Sharath Udupa, an IE developer at Microsoft has posted on the IE 8 page navigations feature:\n\nIn IE8 mode, we provide support for script to update the travel log components (for e.g. back/forward buttons, address bar) to reflect client-side updates to documents. This allows a better user experience where users can navigate back and forth without [...]', '');
INSERT INTO {PREFIX}_article_page_content (page_id, article_id, content_detail, author) VALUES (58, 58, 'Many developers really like the live scrolling functionality popularized by DZone. As you scroll down the page, a XHR call is made which pulls back data and instantly refreshes and allows you to continue to scroll down almost endlessly. Aaron Conran has built a widget for the Ext JS library which provides this functionality in [...]', '');
INSERT INTO {PREFIX}_article_page_content (page_id, article_id, content_detail, author) VALUES (59, 59, 'Brad Neuberg has built a very easy to use client side search tool called PubTools Search using Gears. The project is open source and provides a great avenue to share knowledge on Gears itself.\nTo accompany the code, Brad wrote a detailed article:\n\nDid you know that you can use Gearsto do fast, client-side searching of data, [...]', '');
INSERT INTO {PREFIX}_article_page_content (page_id, article_id, content_detail, author) VALUES (60, 60, 'Robert O\'Callahan and Dave Hyatt have been chatting about paint servers as Robert creates SVG ones and then arbitary elements.\nThis continues the meme of taking common use cases and making them easy via CSS (e.g. reflections).\nHere is the SVG version:\nPLAIN TEXT\nHTML:\n\n\n\n\n&#160;\n\n\n&#60;html xmlns="http://www.w3.org/1999/xhtml"\n\n\n&#160; &#160; &#160;xmlns:svg="http://www.w3.org/2000/svg"&#62;\n\n\n&#60;head&#62;\n\n\n&#60;style&#62;\n\n\nh1 { background:url(#h); }\n\n\np { background:url(#p); }\n\n\nspan { background:url(#h); }\n\n\n&#60;/style&#62;\n\n\n&#60;/head&#62;\n\n\n&#60;body&#62;\n\n\n&#160; &#60;h1 style="width:95%;"&#62;Heading&#60;/h1&#62;\n\n\n&#160; [...]', '');
INSERT INTO {PREFIX}_article_page_content (page_id, article_id, content_detail, author) VALUES (61, 61, 'Wouldn\'t it be nice if we actually had a decent component model? Instead of making JavaScript frameworks have to mess around and try to create one on top of the crud they have to deal with?\nThis is what XBL 2.0 is all about. I talked about XBL in one of my Web Archeology posts, and [...]', '');


DROP TABLE IF EXISTS {PREFIX}_article_comment;
CREATE TABLE {PREFIX}_article_comment (
  comment_id int(11) unsigned NOT NULL auto_increment,
  article_id int(11) unsigned NOT NULL,
  title varchar(255) NOT NULL,
  content mediumtext NOT NULL,
  name varchar(64) NOT NULL,
  email varchar(64) NOT NULL,
  ip varchar(16) NOT NULL,
  posted_date int(11) unsigned NOT NULL,
  enabled tinyint(1) unsigned NOT NULL default '0',
  PRIMARY KEY  (comment_id)
);
DROP TABLE IF EXISTS {PREFIX}_article_topic;
CREATE TABLE {PREFIX}_article_topic (
  topic_id int(11) unsigned NOT NULL auto_increment,
  topic_title varchar(255) NOT NULL,
  topic_desc varchar(255) NOT NULL,
  article_counter smallint(5) unsigned NOT NULL,
  posted_date int(11) unsigned NOT NULL,
  PRIMARY KEY  (topic_id),
  KEY topic_title (topic_title)
);
INSERT INTO {PREFIX}_article_topic (topic_id, topic_title, topic_desc, article_counter, posted_date) VALUES (2, 'Mashable', 'Mashable! - The #1 Social Networking and Social Media News Blog', 8, 1216695973);

DROP TABLE IF EXISTS {PREFIX}_update_schedule;
CREATE TABLE {PREFIX}_update_schedule (
  update_time int(11) unsigned NOT NULL,
  PRIMARY KEY  (update_time)
);
#=========================================

#=================== Event ==============
DROP TABLE IF EXISTS {PREFIX}_event;
CREATE TABLE {PREFIX}_event (
  event_id int(11) unsigned NOT NULL auto_increment,
  event_year smallint(4) unsigned NOT NULL,
  event_month smallint(2) unsigned NOT NULL,
  event_day smallint(2) unsigned NOT NULL,
  event_from_hour smallint(2) default NULL,
  event_from_minute smallint(3) default NULL,
  event_to_hour smallint(2) default NULL,
  event_to_minute smallint(3) default NULL,
  title varchar(255) NOT NULL,
  detail text NOT NULL,
  used_files varchar(255) default NULL,
  enabled tinyint(1) unsigned NOT NULL default '1',
  PRIMARY KEY  (event_id)
);
#=========================================

#============= Statistics =============
DROP TABLE IF EXISTS {PREFIX}_stat_day;
CREATE TABLE {PREFIX}_stat_day (
  stat_date date NOT NULL,
  day_visitors int(11) unsigned NOT NULL default '0',
  PRIMARY KEY  (stat_date)
);

DROP TABLE IF EXISTS {PREFIX}_stat_hour;
CREATE TABLE {PREFIX}_stat_hour (
  stat_date date NOT NULL,
  stat_hour smallint(2) unsigned NOT NULL,
  hour_visitors int(11) unsigned NOT NULL default '0',
  PRIMARY KEY  (stat_date,stat_hour)
);

DROP TABLE IF EXISTS {PREFIX}_stat_country;
CREATE TABLE {PREFIX}_stat_country (
  stat_date date NOT NULL,
  country_id char(2) NOT NULL,
  country_visitors int(11) unsigned NOT NULL default '0',
  PRIMARY KEY  (stat_date,country_id)
);

DROP TABLE IF EXISTS {PREFIX}_stat_browser;
CREATE TABLE {PREFIX}_stat_browser (
  stat_date date NOT NULL,
  browser_name varchar(255) NOT NULL,
  browser_visitors int(11) unsigned NOT NULL default '0',
  PRIMARY KEY  (stat_date,browser_name)
);

DROP TABLE IF EXISTS {PREFIX}_stat_referer;
CREATE TABLE {PREFIX}_stat_referer (
  stat_date date NOT NULL,
  referer_url varchar(255) NOT NULL,
  referer_visitors int(11) unsigned NOT NULL default '0',
  PRIMARY KEY  (stat_date,referer_url)
);

DROP TABLE IF EXISTS {PREFIX}_stat_session;
CREATE TABLE {PREFIX}_stat_session (
  client_ip varchar(16) NOT NULL,
  session_time int(11) unsigned NOT NULL
);
#=======================================

#=============== Web link ==============
DROP TABLE IF EXISTS {PREFIX}_weblink_category;
CREATE TABLE {PREFIX}_weblink_category (
  cat_id smallint(5) unsigned NOT NULL auto_increment,
  cat_parent_id smallint(5) unsigned NOT NULL default '0',
  cat_name varchar(128) NOT NULL,
  cat_desc varchar(255) default NULL,
  cat_order smallint(5) unsigned NOT NULL default '1',
  children_counter smallint(5) unsigned NOT NULL default '0',
  weblink_counter int(11) unsigned NOT NULL default '0',
  enabled tinyint(1) unsigned NOT NULL default '1',
  PRIMARY KEY  (cat_id),
  KEY cat_name (cat_name)
);

DROP TABLE IF EXISTS {PREFIX}_weblink;
CREATE TABLE {PREFIX}_weblink (
  weblink_id int(11) unsigned NOT NULL auto_increment,
  cat_id smallint(5) unsigned NOT NULL,
  site_url varchar(128) NOT NULL,
  site_name varchar(128) NOT NULL,
  hits int(11) unsigned NOT NULL default '0',
  start_date int(11) unsigned NOT NULL,
  end_date int(11) unsigned NOT NULL,
  weblink_order int(11) unsigned NOT NULL default '1',
  enabled tinyint(1) unsigned default NULL,
  PRIMARY KEY  (weblink_id)
);
#========================================

#============== RSS Feeds ================
DROP TABLE IF EXISTS {PREFIX}_rss_export;
CREATE TABLE {PREFIX}_rss_export (
  rss_id int(11) unsigned NOT NULL auto_increment,
  cat_id smallint(5) unsigned NOT NULL,
  rss_code varchar(16) default NULL,
  PRIMARY KEY  (rss_id)
);

DROP TABLE IF EXISTS {PREFIX}_rss_import;
CREATE TABLE {PREFIX}_rss_import (
  rss_id int(11) unsigned NOT NULL auto_increment,
  rss_title varchar(255) NOT NULL,
  rss_url varchar(255) NOT NULL,
  rss_import_pergo smallint(3) unsigned NOT NULL,
  rss_convert_charset tinyint(1) unsigned NOT NULL default '1',
  rss_auth tinyint(1) unsigned NOT NULL default '0',
  rss_auth_user varchar(128) default NULL,
  rss_auth_pass varchar(128) default NULL,
  rss_order int(11) unsigned NOT NULL default '1',
  article_cat_id smallint(5) unsigned NOT NULL,
  article_type tinyint(1) unsigned NOT NULL default '0',
  article_remove_html tinyint(1) unsigned NOT NULL default '0',
  article_show_link tinyint(1) unsigned NOT NULL default '0',
  article_username varchar(64) default NULL,
  article_userpost_increase tinyint(1) unsigned NOT NULL default '0',
  article_author varchar(128) default NULL,
  article_enabled tinyint(1) unsigned NOT NULL default '0',
  last_import_date int(11) unsigned default NULL,
  import_counter int(11) unsigned NOT NULL default '0',
  posted_date int(11) unsigned NOT NULL,
  PRIMARY KEY  (rss_id)
);
INSERT INTO {PREFIX}_rss_import (rss_id, rss_title, rss_url, rss_import_pergo, rss_convert_charset, rss_auth, rss_auth_user, rss_auth_pass, rss_order, article_cat_id, article_type, article_remove_html, article_show_link, article_username, article_userpost_increase, article_author, article_enabled, last_import_date, import_counter, posted_date) VALUES (3, 'Ajaxian', 'http://feeds.feedburner.com/ajaxian', 100, 1, 0, '', '', 2, 4, 0, 1, 0, 'admin', 0, '', 1, 1216696283, 20, 1216696276);
INSERT INTO {PREFIX}_rss_import (rss_id, rss_title, rss_url, rss_import_pergo, rss_convert_charset, rss_auth, rss_auth_user, rss_auth_pass, rss_order, article_cat_id, article_type, article_remove_html, article_show_link, article_username, article_userpost_increase, article_author, article_enabled, last_import_date, import_counter, posted_date) VALUES (2, 'Mashable!', 'http://feeds.feedburner.com/Mashable', 100, 1, 0, '', '', 1, 3, 0, 0, 0, 'admin', 1, 'Mashable!', 1, 1216696067, 30, 1216696040);

DROP TABLE IF EXISTS {PREFIX}_rss_imported;
CREATE TABLE {PREFIX}_rss_imported (
  rss_id int(11) unsigned NOT NULL,
  article_id int(11) unsigned NOT NULL,
  import_date int(11) unsigned NOT NULL,
  PRIMARY KEY  (rss_id,article_id)
);
INSERT INTO {PREFIX}_rss_imported (rss_id, article_id, import_date) VALUES (2, 21, 1216696067);
INSERT INTO {PREFIX}_rss_imported (rss_id, article_id, import_date) VALUES (2, 20, 1216696067);
INSERT INTO {PREFIX}_rss_imported (rss_id, article_id, import_date) VALUES (2, 19, 1216696067);
INSERT INTO {PREFIX}_rss_imported (rss_id, article_id, import_date) VALUES (2, 18, 1216696067);
INSERT INTO {PREFIX}_rss_imported (rss_id, article_id, import_date) VALUES (2, 17, 1216696067);
INSERT INTO {PREFIX}_rss_imported (rss_id, article_id, import_date) VALUES (2, 16, 1216696067);
INSERT INTO {PREFIX}_rss_imported (rss_id, article_id, import_date) VALUES (2, 15, 1216696067);
INSERT INTO {PREFIX}_rss_imported (rss_id, article_id, import_date) VALUES (2, 14, 1216696067);
INSERT INTO {PREFIX}_rss_imported (rss_id, article_id, import_date) VALUES (2, 13, 1216696067);
INSERT INTO {PREFIX}_rss_imported (rss_id, article_id, import_date) VALUES (2, 12, 1216696067);
INSERT INTO {PREFIX}_rss_imported (rss_id, article_id, import_date) VALUES (2, 22, 1216696067);
INSERT INTO {PREFIX}_rss_imported (rss_id, article_id, import_date) VALUES (2, 23, 1216696067);
INSERT INTO {PREFIX}_rss_imported (rss_id, article_id, import_date) VALUES (2, 24, 1216696067);
INSERT INTO {PREFIX}_rss_imported (rss_id, article_id, import_date) VALUES (2, 25, 1216696067);
INSERT INTO {PREFIX}_rss_imported (rss_id, article_id, import_date) VALUES (2, 26, 1216696067);
INSERT INTO {PREFIX}_rss_imported (rss_id, article_id, import_date) VALUES (2, 27, 1216696067);
INSERT INTO {PREFIX}_rss_imported (rss_id, article_id, import_date) VALUES (2, 28, 1216696067);
INSERT INTO {PREFIX}_rss_imported (rss_id, article_id, import_date) VALUES (2, 29, 1216696067);
INSERT INTO {PREFIX}_rss_imported (rss_id, article_id, import_date) VALUES (2, 30, 1216696067);
INSERT INTO {PREFIX}_rss_imported (rss_id, article_id, import_date) VALUES (2, 31, 1216696067);
INSERT INTO {PREFIX}_rss_imported (rss_id, article_id, import_date) VALUES (2, 32, 1216696067);
INSERT INTO {PREFIX}_rss_imported (rss_id, article_id, import_date) VALUES (2, 33, 1216696067);
INSERT INTO {PREFIX}_rss_imported (rss_id, article_id, import_date) VALUES (2, 34, 1216696067);
INSERT INTO {PREFIX}_rss_imported (rss_id, article_id, import_date) VALUES (2, 35, 1216696067);
INSERT INTO {PREFIX}_rss_imported (rss_id, article_id, import_date) VALUES (2, 36, 1216696067);
INSERT INTO {PREFIX}_rss_imported (rss_id, article_id, import_date) VALUES (2, 37, 1216696067);
INSERT INTO {PREFIX}_rss_imported (rss_id, article_id, import_date) VALUES (2, 38, 1216696067);
INSERT INTO {PREFIX}_rss_imported (rss_id, article_id, import_date) VALUES (2, 39, 1216696067);
INSERT INTO {PREFIX}_rss_imported (rss_id, article_id, import_date) VALUES (2, 40, 1216696067);
INSERT INTO {PREFIX}_rss_imported (rss_id, article_id, import_date) VALUES (2, 41, 1216696067);
INSERT INTO {PREFIX}_rss_imported (rss_id, article_id, import_date) VALUES (3, 42, 1216696283);
INSERT INTO {PREFIX}_rss_imported (rss_id, article_id, import_date) VALUES (3, 43, 1216696283);
INSERT INTO {PREFIX}_rss_imported (rss_id, article_id, import_date) VALUES (3, 44, 1216696283);
INSERT INTO {PREFIX}_rss_imported (rss_id, article_id, import_date) VALUES (3, 45, 1216696283);
INSERT INTO {PREFIX}_rss_imported (rss_id, article_id, import_date) VALUES (3, 46, 1216696283);
INSERT INTO {PREFIX}_rss_imported (rss_id, article_id, import_date) VALUES (3, 47, 1216696283);
INSERT INTO {PREFIX}_rss_imported (rss_id, article_id, import_date) VALUES (3, 48, 1216696283);
INSERT INTO {PREFIX}_rss_imported (rss_id, article_id, import_date) VALUES (3, 49, 1216696283);
INSERT INTO {PREFIX}_rss_imported (rss_id, article_id, import_date) VALUES (3, 50, 1216696283);
INSERT INTO {PREFIX}_rss_imported (rss_id, article_id, import_date) VALUES (3, 51, 1216696283);
INSERT INTO {PREFIX}_rss_imported (rss_id, article_id, import_date) VALUES (3, 52, 1216696283);
INSERT INTO {PREFIX}_rss_imported (rss_id, article_id, import_date) VALUES (3, 53, 1216696283);
INSERT INTO {PREFIX}_rss_imported (rss_id, article_id, import_date) VALUES (3, 54, 1216696283);
INSERT INTO {PREFIX}_rss_imported (rss_id, article_id, import_date) VALUES (3, 55, 1216696283);
INSERT INTO {PREFIX}_rss_imported (rss_id, article_id, import_date) VALUES (3, 56, 1216696283);
INSERT INTO {PREFIX}_rss_imported (rss_id, article_id, import_date) VALUES (3, 57, 1216696283);
INSERT INTO {PREFIX}_rss_imported (rss_id, article_id, import_date) VALUES (3, 58, 1216696283);
INSERT INTO {PREFIX}_rss_imported (rss_id, article_id, import_date) VALUES (3, 59, 1216696283);
INSERT INTO {PREFIX}_rss_imported (rss_id, article_id, import_date) VALUES (3, 60, 1216696283);
INSERT INTO {PREFIX}_rss_imported (rss_id, article_id, import_date) VALUES (3, 61, 1216696283);
#=========================================

#============== Users ====================
DROP TABLE IF EXISTS {PREFIX}_user_group;
CREATE TABLE {PREFIX}_user_group (
  group_id smallint(5) unsigned NOT NULL auto_increment,
  group_name varchar(64) NOT NULL,
  group_desc varchar(255) default NULL,
  group_level tinyint(1) unsigned NOT NULL default '0',
  user_counter int(11) unsigned NOT NULL default '0',
  PRIMARY KEY  (group_id),
  KEY group_name (group_name)
);
	
DROP TABLE IF EXISTS {PREFIX}_user;
CREATE TABLE {PREFIX}_user (
  user_id int(11) unsigned NOT NULL auto_increment,
  username varchar(32) NOT NULL,
  user_password varchar(32) NOT NULL,
  user_email varchar(64) NOT NULL,
  user_timezone float NOT NULL default '0',
  user_last_login int(11) unsigned default NULL,
  user_ip varchar(16) default NULL,
  user_template varchar(64) default NULL,
  user_language varchar(64) default NULL,
  article_counter int(11) unsigned NOT NULL default '0',
  enabled tinyint(1) unsigned NOT NULL default '0',
  PRIMARY KEY  (user_id),
  KEY username (username)
);

DROP TABLE IF EXISTS {PREFIX}_user_group_ids;
CREATE TABLE {PREFIX}_user_group_ids (
  user_id int(11) unsigned NOT NULL,
  group_id smallint(5) unsigned NOT NULL,
  PRIMARY KEY  (user_id,group_id)
);
	
DROP TABLE IF EXISTS {PREFIX}_user_field;
CREATE TABLE {PREFIX}_user_field (
  field_id smallint(5) unsigned NOT NULL auto_increment,
  field_title varchar(128) NOT NULL,
  field_desc varchar(255) default NULL,
  field_content text,
  field_type set('textinput','textarea','dropdown') NOT NULL,
  field_size smallint(3) unsigned NOT NULL,
  field_maxchars smallint(5) unsigned default NULL,
  field_order smallint(5) unsigned NOT NULL,
  field_required tinyint(1) unsigned NOT NULL default '0',
  PRIMARY KEY  (field_id),
  KEY field_title (field_title)
);
INSERT INTO {PREFIX}_user_field (field_id, field_title, field_desc, field_content, field_type, field_size, field_maxchars, field_order, field_required) VALUES(0, 'Full Name', '', '', 'textinput', '40', 64, 1, 1);
INSERT INTO {PREFIX}_user_field (field_id, field_title, field_desc, field_content, field_type, field_size, field_maxchars, field_order, field_required) VALUES(0, 'Address', '', '', 'textinput', '40', 128, 2, 0);
INSERT INTO {PREFIX}_user_field (field_id, field_title, field_desc, field_content, field_type, field_size, field_maxchars, field_order, field_required) VALUES(0, 'Phone', '', '', 'textinput', '40', 64, 3, 0);

DROP TABLE IF EXISTS {PREFIX}_user_field_value;
CREATE TABLE {PREFIX}_user_field_value (
  user_id int(11) unsigned NOT NULL,
  field_id smallint(5) unsigned NOT NULL,
  field_value text NOT NULL,
  PRIMARY KEY  (user_id,field_id)
);
#=========================================


#============= Function ==================
DROP TABLE IF EXISTS {PREFIX}_func_group;
CREATE TABLE {PREFIX}_func_group (
  fgroup_id smallint(3) unsigned NOT NULL auto_increment,
  fgroup_name varchar(64) NOT NULL,
  fgroup_order smallint(3) unsigned NOT NULL default '1',
  PRIMARY KEY  (fgroup_id),
  KEY fgroup_name (fgroup_name)
);
INSERT INTO {PREFIX}_func_group(fgroup_id, fgroup_name, fgroup_order) VALUES(1, "menu_article", 1);
INSERT INTO {PREFIX}_func_group(fgroup_id, fgroup_name, fgroup_order) VALUES(2, "menu_rss", 2);
INSERT INTO {PREFIX}_func_group(fgroup_id, fgroup_name, fgroup_order) VALUES(3, "menu_miscell", 4);
INSERT INTO {PREFIX}_func_group(fgroup_id, fgroup_name, fgroup_order) VALUES(4, "menu_newslt", 4);
INSERT INTO {PREFIX}_func_group(fgroup_id, fgroup_name, fgroup_order) VALUES(5, "menu_weblink", 5);
INSERT INTO {PREFIX}_func_group(fgroup_id, fgroup_name, fgroup_order) VALUES(6, "menu_user", 6);
INSERT INTO {PREFIX}_func_group(fgroup_id, fgroup_name, fgroup_order) VALUES(7, "menu_admin", 7);
INSERT INTO {PREFIX}_func_group(fgroup_id, fgroup_name, fgroup_order) VALUES(8, "menu_db", 8);
INSERT INTO {PREFIX}_func_group(fgroup_id, fgroup_name, fgroup_order) VALUES(9, "menu_private", 9);

DROP TABLE IF EXISTS {PREFIX}_func;
CREATE TABLE {PREFIX}_func (
  func_id smallint(3) unsigned NOT NULL auto_increment,
  fgroup_id smallint(3) unsigned NOT NULL,
  func_code varchar(32) NOT NULL,
  func_name varchar(64) NOT NULL,
  func_url varchar(64) NOT NULL,
  func_target varchar(32) default NULL,
  func_actions varchar(64) default NULL,
  func_items varchar(64) default NULL,
  func_allow_all tinyint(1) unsigned NOT NULL default '0',
  func_order smallint(5) unsigned NOT NULL default '1',
  PRIMARY KEY  (func_id),
  KEY func_name (func_name)
);
INSERT INTO {PREFIX}_func (func_id, fgroup_id, func_code, func_name, func_url, func_target, func_actions, func_items, func_allow_all, func_order) VALUES (0, 1, 'article_cat', 'menu_article_cat', 'admin.php?mod=article_cat', 'main', 'all,view,add,edit,del,move_article', '', 0, 1);
INSERT INTO {PREFIX}_func (func_id, fgroup_id, func_code, func_name, func_url, func_target, func_actions, func_items, func_allow_all, func_order) VALUES (0, 1, 'article', 'menu_article_article', 'admin.php?mod=article', 'main', 'all,view,add,edit,del,active,move_article', 'all,own,enabled,disabled', 0, 2);
INSERT INTO {PREFIX}_func (func_id, fgroup_id, func_code, func_name, func_url, func_target, func_actions, func_items, func_allow_all, func_order) VALUES (0, 1, 'article_topic', 'menu_article_topic', 'admin.php?mod=article_topic', 'main', 'all,view,add,edit,del,move_article', '', 0, 3);
INSERT INTO {PREFIX}_func (func_id, fgroup_id, func_code, func_name, func_url, func_target, func_actions, func_items, func_allow_all, func_order) VALUES (0, 1, 'article_comment', 'menu_article_comment', 'admin.php?mod=article_comment', 'main', 'all,view,edit,del', '', 0, 4);
INSERT INTO {PREFIX}_func (func_id, fgroup_id, func_code, func_name, func_url, func_target, func_actions, func_items, func_allow_all, func_order) VALUES (0, 1, 'picture', 'menu_article_picture', 'admin.php?mod=picture', 'main', 'all,view,add,edit,del,active', 'all,own,enabled,disabled', 0, 5);
INSERT INTO {PREFIX}_func (func_id, fgroup_id, func_code, func_name, func_url, func_target, func_actions, func_items, func_allow_all, func_order) VALUES (0, 2, 'rss_export', 'menu_rss_export', 'admin.php?mod=rss_export', 'main', 'edit', '', 0, 1);
INSERT INTO {PREFIX}_func (func_id, fgroup_id, func_code, func_name, func_url, func_target, func_actions, func_items, func_allow_all, func_order) VALUES (0, 2, 'rss_import', 'menu_rss_import', 'admin.php?mod=rss_import', 'main', 'all,add,edit,del,import', '', 0, 2);
INSERT INTO {PREFIX}_func (func_id, fgroup_id, func_code, func_name, func_url, func_target, func_actions, func_items, func_allow_all, func_order) VALUES (0, 3, 'event', 'menu_miscell_event', 'admin.php?mod=event', 'main', 'all,view,add,edit,del,active', 'all,enabled,disabled', 0, 1);
INSERT INTO {PREFIX}_func (func_id, fgroup_id, func_code, func_name, func_url, func_target, func_actions, func_items, func_allow_all, func_order) VALUES (0, 3, 'poll', 'menu_miscell_poll', 'admin.php?mod=poll', 'main', 'all,view,add,edit,del,active', '', 0, 2);
INSERT INTO {PREFIX}_func (func_id, fgroup_id, func_code, func_name, func_url, func_target, func_actions, func_items, func_allow_all, func_order) VALUES (0, 3, 'faq', 'menu_miscell_faq', 'admin.php?mod=faq', 'main', 'all,view,add,edit,del,active', '', 0, 3);
INSERT INTO {PREFIX}_func (func_id, fgroup_id, func_code, func_name, func_url, func_target, func_actions, func_items, func_allow_all, func_order) VALUES (0, 3, 'logo', 'menu_miscell_logo', 'admin.php?mod=logo', 'main', 'all,view,add,edit,del,active', '', 0, 4);
INSERT INTO {PREFIX}_func (func_id, fgroup_id, func_code, func_name, func_url, func_target, func_actions, func_items, func_allow_all, func_order) VALUES (0, 4, 'newslt_cat', 'menu_newslt_cat', 'admin.php?mod=newslt_cat', 'main', 'all,view,add,edit,del,move_email', '', 0, 1);
INSERT INTO {PREFIX}_func (func_id, fgroup_id, func_code, func_name, func_url, func_target, func_actions, func_items, func_allow_all, func_order) VALUES (0, 4, 'newslt_email', 'menu_newslt_email', 'admin.php?mod=newslt', 'main', 'all,view,add,edit,del,import,export', '', 0, 2);
INSERT INTO {PREFIX}_func (func_id, fgroup_id, func_code, func_name, func_url, func_target, func_actions, func_items, func_allow_all, func_order) VALUES (0, 4, 'newslt_issue', 'menu_newslt_issue', 'admin.php?mod=newslt_issue', 'main', 'all,view,add,edit,del,send_email', '', 0, 3);
INSERT INTO {PREFIX}_func (func_id, fgroup_id, func_code, func_name, func_url, func_target, func_actions, func_items, func_allow_all, func_order) VALUES (0, 5, 'weblink_cat', 'menu_weblink_cat', 'admin.php?mod=weblink_cat', 'main', 'all,view,add,edit,del,move_weblink', '', 0, 1);
INSERT INTO {PREFIX}_func (func_id, fgroup_id, func_code, func_name, func_url, func_target, func_actions, func_items, func_allow_all, func_order) VALUES (0, 5, 'weblink', 'menu_weblink_weblink', 'admin.php?mod=weblink', 'main', 'all,view,add,edit,del,active', '', 0, 2);
INSERT INTO {PREFIX}_func (func_id, fgroup_id, func_code, func_name, func_url, func_target, func_actions, func_items, func_allow_all, func_order) VALUES (0, 6, 'user_group', 'menu_user_group', 'admin.php?mod=user_group', 'main', 'all,view,add,edit,del,move_user', '', 0, 1);
INSERT INTO {PREFIX}_func (func_id, fgroup_id, func_code, func_name, func_url, func_target, func_actions, func_items, func_allow_all, func_order) VALUES (0, 6, 'user', 'menu_user_user', 'admin.php?mod=user', 'main', 'all,view,add,edit,del,active,move_user', '', 0, 2);
INSERT INTO {PREFIX}_func (func_id, fgroup_id, func_code, func_name, func_url, func_target, func_actions, func_items, func_allow_all, func_order) VALUES (0, 6, 'user_field', 'menu_user_field', 'admin.php?mod=user_field', 'main', 'all,view,add,edit,del', '', 0, 3);
INSERT INTO {PREFIX}_func (func_id, fgroup_id, func_code, func_name, func_url, func_target, func_actions, func_items, func_allow_all, func_order) VALUES (0, 7, 'setting', 'menu_admin_setting', 'admin.php?mod=setting', 'main', 'edit', '', 0, 1);
INSERT INTO {PREFIX}_func (func_id, fgroup_id, func_code, func_name, func_url, func_target, func_actions, func_items, func_allow_all, func_order) VALUES (0, 7, 'cache', 'menu_admin_cache', 'admin.php?mod=cache', 'main', 'view,del', '', 0, 2);
INSERT INTO {PREFIX}_func (func_id, fgroup_id, func_code, func_name, func_url, func_target, func_actions, func_items, func_allow_all, func_order) VALUES (0, 7, 'system', 'menu_admin_system', 'admin.php?mod=system', 'main', 'view', '', 0, 3);
INSERT INTO {PREFIX}_func (func_id, fgroup_id, func_code, func_name, func_url, func_target, func_actions, func_items, func_allow_all, func_order) VALUES (0, 7, 'log', 'menu_admin_log', 'admin.php?mod=log', 'main', 'view,export,del', '', 0, 4);
INSERT INTO {PREFIX}_func (func_id, fgroup_id, func_code, func_name, func_url, func_target, func_actions, func_items, func_allow_all, func_order) VALUES (0, 7, 'stat', 'menu_admin_stat', 'admin.php?mod=stat', 'main', 'all,view,reset', '', 0, 5);
INSERT INTO {PREFIX}_func (func_id, fgroup_id, func_code, func_name, func_url, func_target, func_actions, func_items, func_allow_all, func_order) VALUES (0, 8, 'db_info', 'menu_db_info', 'admin.php?mod=db&act=dbinfo', 'main', 'view,run_sql', '', 0, 1);
INSERT INTO {PREFIX}_func (func_id, fgroup_id, func_code, func_name, func_url, func_target, func_actions, func_items, func_allow_all, func_order) VALUES (0, 8, 'db_backup', 'menu_db_backup', 'admin.php?mod=db&act=prebk', 'main', 'backup,repair', '', 0, 2);
INSERT INTO {PREFIX}_func (func_id, fgroup_id, func_code, func_name, func_url, func_target, func_actions, func_items, func_allow_all, func_order) VALUES (0, 8, 'db_restore', 'menu_db_restore', 'admin.php?mod=db&act=prers', 'main', 'restore', '', 0, 3);
INSERT INTO {PREFIX}_func (func_id, fgroup_id, func_code, func_name, func_url, func_target, func_actions, func_items, func_allow_all, func_order) VALUES (0, 8, 'db_runtime', 'menu_db_runtime', 'admin.php?mod=db&act=runtime', 'main', 'view', '', 0, 4);
INSERT INTO {PREFIX}_func (func_id, fgroup_id, func_code, func_name, func_url, func_target, func_actions, func_items, func_allow_all, func_order) VALUES (0, 8, 'db_system', 'menu_db_system', 'admin.php?mod=db&act=system', 'main', 'view', '', 0, 5);
INSERT INTO {PREFIX}_func (func_id, fgroup_id, func_code, func_name, func_url, func_target, func_actions, func_items, func_allow_all, func_order) VALUES (0, 8, 'db_process', 'menu_db_process', 'admin.php?mod=db&act=process', 'main', 'view', '', 0, 6);
INSERT INTO {PREFIX}_func (func_id, fgroup_id, func_code, func_name, func_url, func_target, func_actions, func_items, func_allow_all, func_order) VALUES (0, 9, 'private', 'menu_private_profile', 'admin.php?mod=private', 'main', '', '', 1, 1);
INSERT INTO {PREFIX}_func (func_id, fgroup_id, func_code, func_name, func_url, func_target, func_actions, func_items, func_allow_all, func_order) VALUES (0, 9, 'changepass', 'menu_private_changepass', 'admin.php?mod=private&act=prechangepwd', 'main', '', '', 1, 2);
INSERT INTO {PREFIX}_func (func_id, fgroup_id, func_code, func_name, func_url, func_target, func_actions, func_items, func_allow_all, func_order) VALUES (0, 9, 'logout', 'menu_private_logout', 'admin.php?act=logout', '_parent', '', '', 1, 3);

DROP TABLE IF EXISTS {PREFIX}_func_auth;
CREATE TABLE {PREFIX}_func_auth (
  ugroup_id smallint(3) unsigned NOT NULL,
  func_code varchar(32) NOT NULL,
  allow_actions varchar(128) default NULL,
  allow_items varchar(128) default NULL,
  PRIMARY KEY  (ugroup_id,func_code)
);
#=========================================
	

#=============== Poll ====================
DROP TABLE IF EXISTS {PREFIX}_poll;
CREATE TABLE {PREFIX}_poll (
  poll_id int(11) unsigned NOT NULL auto_increment,
  cat_id varchar(255) default NULL,
  question varchar(255) NOT NULL,
  start_date int(11) unsigned default NULL,
  end_date int(11) unsigned default NULL,
  multiple tinyint(1) unsigned NOT NULL default '0',
  poll_order int(11) unsigned NOT NULL default '1',
  total_hits int(11) unsigned NOT NULL default '0',
  enabled tinyint(1) unsigned NOT NULL default '0',
  PRIMARY KEY  (poll_id)
);

DROP TABLE IF EXISTS {PREFIX}_poll_option;
CREATE TABLE {PREFIX}_poll_option (
  option_id int(11) unsigned NOT NULL auto_increment,
  poll_id int(11) unsigned NOT NULL,
  option_title varchar(128) NOT NULL,
  option_order int(11) unsigned NOT NULL default '1',
  option_hits int(11) unsigned NOT NULL default '0',
  PRIMARY KEY  (option_id)
);

DROP TABLE IF EXISTS {PREFIX}_poll_ip;
CREATE TABLE {PREFIX}_poll_ip (
  poll_id int(11) unsigned NOT NULL,
  client_ip varchar(16) NOT NULL,
  hit_time int(11) unsigned NOT NULL default '0'
);
#=========================================

#=========== News Picture ================
DROP TABLE IF EXISTS {PREFIX}_picture;
CREATE TABLE {PREFIX}_picture (
  picture_id int(11) unsigned NOT NULL auto_increment,
  cat_id varchar(255) default NULL,
  pic_thumb varchar(64) default NULL,
  pic_full varchar(64) default NULL,
  pic_content text NOT NULL,
  poster_id int(11) unsigned default NULL,
  checker_id int(11) unsigned default NULL,
  posted_date int(11) unsigned NOT NULL,
  enabled tinyint(1) unsigned NOT NULL default '0',
  PRIMARY KEY  (picture_id)
);
#=========================================

#=========== FAQ - Logo ==================
DROP TABLE IF EXISTS {PREFIX}_faq;
CREATE TABLE {PREFIX}_faq (
  faq_id smallint(5) unsigned NOT NULL auto_increment,
  question varchar(255) NOT NULL,
  answer text NOT NULL,
  used_files varchar(255) default NULL,
  faq_order smallint(5) unsigned NOT NULL default '1',
  enabled smallint(5) unsigned NOT NULL default '0',
  PRIMARY KEY  (faq_id)
);
	
DROP TABLE IF EXISTS {PREFIX}_logo;
CREATE TABLE {PREFIX}_logo (
  logo_id int(11) unsigned NOT NULL auto_increment,
  logo_file varchar(128) NOT NULL,
  logo_width smallint(3) default NULL,
  logo_height smallint(3) default NULL,
  site_url varchar(128) NOT NULL,
  site_name varchar(128) NOT NULL,
  hits int(11) unsigned NOT NULL default '0',
  start_date int(11) unsigned NOT NULL,
  end_date int(11) unsigned NOT NULL,
  logo_order int(11) unsigned NOT NULL default '1',
  logo_pos int(11) NOT NULL,
  logo_pages text,
  enabled tinyint(1) unsigned NOT NULL default '0',
  PRIMARY KEY  (logo_id)
);
#=========================================

#============ Newsletter =================
DROP TABLE IF EXISTS {PREFIX}_newsletter_category;
CREATE TABLE {PREFIX}_newsletter_category (
  cat_id smallint(5) unsigned NOT NULL auto_increment,
  cat_parent_id smallint(5) unsigned NOT NULL default '0',
  cat_name varchar(128) NOT NULL,
  cat_desc varchar(255) default NULL,
  cat_order smallint(5) unsigned NOT NULL default '1',
  children_counter smallint(5) unsigned NOT NULL default '0',
  email_counter int(11) unsigned NOT NULL default '0',
  enabled tinyint(1) unsigned NOT NULL default '1',
  PRIMARY KEY  (cat_id),
  KEY cat_name (cat_name)
);

DROP TABLE IF EXISTS {PREFIX}_newsletter;
CREATE TABLE {PREFIX}_newsletter (
  newslt_id int(11) unsigned NOT NULL auto_increment,
  cat_id smallint(5) unsigned NOT NULL default '0',
  name varchar(128) default NULL,
  email varchar(64) NOT NULL,
  reg_code varchar(10) NOT NULL,
  enabled tinyint(1) unsigned NOT NULL,
  PRIMARY KEY  (newslt_id),
  KEY email (email)
);

DROP TABLE IF EXISTS {PREFIX}_newsletter_issue;
CREATE TABLE {PREFIX}_newsletter_issue (
  issue_id int(11) unsigned NOT NULL auto_increment,
  cat_ids varchar(255) default NULL,
  title varchar(128) NOT NULL,
  content mediumtext NOT NULL,
  used_files varchar(255) default NULL,
  posted_date int(11) unsigned default NULL,
  sent_counter smallint(5) unsigned NOT NULL default '0',
  sent_date int(11) unsigned default NULL,
  enabled tinyint(1) unsigned default NULL,
  PRIMARY KEY  (issue_id)
);
#=========================================


#============== Site Option ==============
DROP TABLE IF EXISTS {PREFIX}_session;
CREATE TABLE {PREFIX}_session (
  session_id varchar(32) NOT NULL,
  session_time int(11) unsigned NOT NULL,
  session_hash varchar(32) NOT NULL,
  user_id int(11) unsigned NOT NULL,
  user_groups varchar(255) NOT NULL,
  auto_login tinyint(1) unsigned NOT NULL,
  kicked_by varchar(32) default NULL,
  kicked_time int(11) unsigned NOT NULL default '0',
  PRIMARY KEY  (session_id)
);

DROP TABLE IF EXISTS {PREFIX}_site_log;
CREATE TABLE {PREFIX}_site_log (
  log_time int(11) unsigned NOT NULL,
  user_id int(11) unsigned NOT NULL,
  user_ip varchar(16) NOT NULL,
  func_name varchar(32) NOT NULL,
  func_action varchar(32) NOT NULL,
  func_url_view varchar(64) default NULL,
  record_ids varchar(255) default NULL
);
	
#DROP TABLE IF EXISTS {PREFIX}_ban;
#CREATE TABLE {PREFIX}_ban(
#	ips			text,
#	email			text,
#	usernames		text
#);

DROP TABLE IF EXISTS {PREFIX}_contact_ip;
CREATE TABLE {PREFIX}_contact_ip (
  client_ip varchar(16) NOT NULL,
  contact_time int(11) unsigned NOT NULL,
  contact_note varchar(255) NOT NULL
);

DROP TABLE IF EXISTS {PREFIX}_number;
CREATE TABLE {PREFIX}_number (
  num_id varchar(32) NOT NULL,
  num_value varchar(5) NOT NULL,
  num_time int(11) unsigned NOT NULL,
  client_ip varchar(16) NOT NULL,
  PRIMARY KEY  (num_id)
);

DROP TABLE IF EXISTS {PREFIX}_send_pass;
CREATE TABLE {PREFIX}_send_pass (
  send_id varchar(32) NOT NULL,
  send_time int(11) unsigned NOT NULL,
  username varchar(32) NOT NULL
);

DROP TABLE IF EXISTS {PREFIX}_config;
CREATE TABLE {PREFIX}_config (
  config_name varchar(64) NOT NULL,
  config_value varchar(255) default NULL,
  PRIMARY KEY  (config_name)
);
INSERT INTO {PREFIX}_config (config_name, config_value) VALUES ('script_version', '2.2.0_Pro_Beta_1');
INSERT INTO {PREFIX}_config (config_name, config_value) VALUES ('site_keywords', 'Site,Keywords');
INSERT INTO {PREFIX}_config (config_name, config_value) VALUES ('site_desc', 'Site Description');
INSERT INTO {PREFIX}_config (config_name, config_value) VALUES ('log_save', '1');
INSERT INTO {PREFIX}_config (config_name, config_value) VALUES ('log_days', '30');
INSERT INTO {PREFIX}_config (config_name, config_value) VALUES ('cache_enabled', '0');
INSERT INTO {PREFIX}_config (config_name, config_value) VALUES ('cache_expire', '86400');
INSERT INTO {PREFIX}_config (config_name, config_value) VALUES ('cache_maxsize', '10485760');
INSERT INTO {PREFIX}_config (config_name, config_value) VALUES ('website_close', '0');
INSERT INTO {PREFIX}_config (config_name, config_value) VALUES ('website_close_reason', 'no reason');
INSERT INTO {PREFIX}_config (config_name, config_value) VALUES ('template', 'ProBlue');
INSERT INTO {PREFIX}_config (config_name, config_value) VALUES ('language', 'English');
INSERT INTO {PREFIX}_config (config_name, config_value) VALUES ('timezone', '0');
INSERT INTO {PREFIX}_config (config_name, config_value) VALUES ('items_per_page', '30');
INSERT INTO {PREFIX}_config (config_name, config_value) VALUES ('date_format', 'm.d.Y');
INSERT INTO {PREFIX}_config (config_name, config_value) VALUES ('time_format', 'm.d.Y, h:ia');
INSERT INTO {PREFIX}_config (config_name, config_value) VALUES ('full_date_time_format', 'l, m.d.Y, h:ia');
INSERT INTO {PREFIX}_config (config_name, config_value) VALUES ('poll_options', '7');
INSERT INTO {PREFIX}_config (config_name, config_value) VALUES ('time_revote', '3600');
INSERT INTO {PREFIX}_config (config_name, config_value) VALUES ('time_login', '5400');
INSERT INTO {PREFIX}_config (config_name, config_value) VALUES ('gzip', '0');
INSERT INTO {PREFIX}_config (config_name, config_value) VALUES ('gzip_level', '9');
INSERT INTO {PREFIX}_config (config_name, config_value) VALUES ('cookie_time', '2592000');
INSERT INTO {PREFIX}_config (config_name, config_value) VALUES ('cookie_secure', '0');
INSERT INTO {PREFIX}_config (config_name, config_value) VALUES ('kick_minutes', '10');
INSERT INTO {PREFIX}_config (config_name, config_value) VALUES ('image_type', '.gif,.jpg,.jpeg,.png');
INSERT INTO {PREFIX}_config (config_name, config_value) VALUES ('image_max_size', '512000');
INSERT INTO {PREFIX}_config (config_name, config_value) VALUES ('topic_move', '100');
INSERT INTO {PREFIX}_config (config_name, config_value) VALUES ('latest_box_items', '40');
INSERT INTO {PREFIX}_config (config_name, config_value) VALUES ('comment_enabled', '1');
INSERT INTO {PREFIX}_config (config_name, config_value) VALUES ('menucat_level', '2');
INSERT INTO {PREFIX}_config (config_name, config_value) VALUES ('home_focus_cols', '2');
INSERT INTO {PREFIX}_config (config_name, config_value) VALUES ('home_cat_article_limit', '10');
INSERT INTO {PREFIX}_config (config_name, config_value) VALUES ('home_hot_limit', '10');
INSERT INTO {PREFIX}_config (config_name, config_value) VALUES ('home_cat_cols', '2');
INSERT INTO {PREFIX}_config (config_name, config_value) VALUES ('home_latest_limit', '10');
INSERT INTO {PREFIX}_config (config_name, config_value) VALUES ('limit_home_news_next', '10');
INSERT INTO {PREFIX}_config (config_name, config_value) VALUES ('limit_home_hot', '10');
INSERT INTO {PREFIX}_config (config_name, config_value) VALUES ('home_focus_limit', '6');
INSERT INTO {PREFIX}_config (config_name, config_value) VALUES ('limit_rss_news', '10');
INSERT INTO {PREFIX}_config (config_name, config_value) VALUES ('limit_home_comment', '10');
INSERT INTO {PREFIX}_config (config_name, config_value) VALUES ('thumb_large_max_width', '220');
INSERT INTO {PREFIX}_config (config_name, config_value) VALUES ('thumb_large_max_height', '220');
INSERT INTO {PREFIX}_config (config_name, config_value) VALUES ('thumb_small_max_width', '110');
INSERT INTO {PREFIX}_config (config_name, config_value) VALUES ('thumb_small_max_height', '110');
INSERT INTO {PREFIX}_config (config_name, config_value) VALUES ('thumb_icon_max_width', '60');
INSERT INTO {PREFIX}_config (config_name, config_value) VALUES ('thumb_icon_max_height', '60');
INSERT INTO {PREFIX}_config (config_name, config_value) VALUES ('time_recontact', '30');
INSERT INTO {PREFIX}_config (config_name, config_value) VALUES ('newspic_rand_limit', '5');
INSERT INTO {PREFIX}_config (config_name, config_value) VALUES ('newspic_rand_time', '10');
INSERT INTO {PREFIX}_config (config_name, config_value) VALUES ('newspic_thumb_max_width', '135');
INSERT INTO {PREFIX}_config (config_name, config_value) VALUES ('newspic_thumb_max_height', '200');
INSERT INTO {PREFIX}_config (config_name, config_value) VALUES ('newspic_full_max_width', '500');
INSERT INTO {PREFIX}_config (config_name, config_value) VALUES ('newspic_full_max_height', '500');
INSERT INTO {PREFIX}_config (config_name, config_value) VALUES ('newspic_limit_per_page', '8');
INSERT INTO {PREFIX}_config (config_name, config_value) VALUES ('smtp_host', '');
INSERT INTO {PREFIX}_config (config_name, config_value) VALUES ('smtp_username', '');
INSERT INTO {PREFIX}_config (config_name, config_value) VALUES ('smtp_password', '');
INSERT INTO {PREFIX}_config (config_name, config_value) VALUES ('time_recomment', '30');
INSERT INTO {PREFIX}_config (config_name, config_value) VALUES ('stat_time_update', '1200');
INSERT INTO {PREFIX}_config (config_name, config_value) VALUES ('acp_note', 'acp_note');
INSERT INTO {PREFIX}_config (config_name, config_value) VALUES ('webrpt', '0');
INSERT INTO {PREFIX}_config (config_name, config_value) VALUES ('enable_article_wysiwyg_title', '1');
INSERT INTO {PREFIX}_config (config_name, config_value) VALUES ('ftp_host', '');
INSERT INTO {PREFIX}_config (config_name, config_value) VALUES ('ftp_username', '');
INSERT INTO {PREFIX}_config (config_name, config_value) VALUES ('ftp_password', '');
INSERT INTO {PREFIX}_config (config_name, config_value) VALUES ('ftp_port', '');
INSERT INTO {PREFIX}_config (config_name, config_value) VALUES ('script_name', 'SoSo News Express Pro 2.2.0 Beta 1');
INSERT INTO {PREFIX}_config (config_name, config_value) VALUES ('event_enabled', '1');
INSERT INTO {PREFIX}_config (config_name, config_value) VALUES ('poll_enabled', '1');
INSERT INTO {PREFIX}_config (config_name, config_value) VALUES ('rating_enabled', '1');
INSERT INTO {PREFIX}_config (config_name, config_value) VALUES ('newspic_enabled', '1');
INSERT INTO {PREFIX}_config (config_name, config_value) VALUES ('archived_default', '-1');
INSERT INTO {PREFIX}_config (config_name, config_value) VALUES ('newsletter_enabled', '1');
INSERT INTO {PREFIX}_config (config_name, config_value) VALUES ('limit_home_news', '10');
INSERT INTO {PREFIX}_config (config_name, config_value) VALUES ('latest_box_type', '1');
INSERT INTO {PREFIX}_config (config_name, config_value) VALUES ('website_close_message', 'website close message');
INSERT INTO {PREFIX}_config (config_name, config_value) VALUES ('limit_global_hot', '2');
INSERT INTO {PREFIX}_config (config_name, config_value) VALUES ('article_topic_limit', '50');
#=========================================

