<?php

define("IN_SITE", true);
include ("./template.php");
include ("./mysql.php");
include ("./functions.php");
@set_time_limit(100);
$Template = new Template("./skin");
$Func = new Func;
$Install = new Install;
$Template->set_files(array("header" => "header.tpl", "main" => $Install->tpl_main . ".tpl", "footer" => "footer.tpl", ));
$Template->show();
class Install
{
		var $tpl_main = "";
		var $script_name = "SoSo News Express Pro 2.2.0 Beta 1";
		var $step = 0;
		var $step_desc = "";
		var $data = array();
		var $module_upgrades = array("upgrade_1.0" => "", "upgrade_1.1" => "upgrade_1.1_to_1.2", "upgrade_1.2" => "upgrade_1.2_to_2.0", "upgrade_2.0.0" => "upgrade_2.0.0_to_2.0.1", "upgrade_2.0.1" => "upgrade_2.0.1_to_2.0.2", "upgrade_2.0.2" => "upgrade_2.0.2_to_2.0.3", "upgrade_2.0.3" => "upgrade_2.0.3_to_2.0.4", "upgrade_2.0.4" => "upgrade_2.0.4_to_2.1.0", "upgrade_2.1.0" => "upgrade_2.1.0_to_2.1.1", "upgrade_2.1.1" => "upgrade_2.1.1_to_2.2.0");
		var $desc_upgrades = array("upgrade_1.0" => "Upgrading from [1.0] to [1.1].... ", "upgrade_1.1" => "Upgrading from [1.1] to [1.2].... ", "upgrade_1.2" => "Upgrading from [1.2] to [2.0].... ", "upgrade_2.0.0" => "Upgrading from [2.0] to [2.0.1].... ", "upgrade_2.0.1" => "Upgrading from [2.0.1] to [2.0.2].... ", "upgrade_2.0.2" => "Upgrading from [2.0.2] to [2.0.3].... ", "upgrade_2.0.3" => "Upgrading from [2.0.3] to [2.0.4].... ", "upgrade_2.0.4" => "Upgrading from [2.0.4] to [2.1.0].... ", "upgrade_2.1.0" => "Upgrading from [2.1.0] to [2.1.1].... ", "upgrade_2.1.1" => "Upgrading from [2.1.1] to [2.2.0 Beta 1].... ");
		function Install()
		{
				global $Template;
				$act = isset($_GET["act"]) ? $_GET["act"] : '';
				$this->step = isset($_GET["step"]) ? intval($_GET["step"]) : 1;
				$steps = 4;
				switch ($this->step)
				{
						default:
						case "1":
								$this->check_lock();
								$this->step = 1;
								$step_desc = "Preparation";
								$this->tpl_main = "preparation";
								$Template->set_vars(array("STEPS" => $this->step . "/" . $steps . ": " . $step_desc, "SCRIPT_NAME" => $this->script_name, ));
								break;
						case "2":
								$this->check_lock();
								$step_desc = "Configuration";
								$this->tpl_main = "configuration";
								$Template->set_vars(array("STEPS" => $this->step . "/" . $steps . ": " . $step_desc, "SCRIPT_NAME" => $this->script_name, ));
								$this->show_config_form();
								break;
						case "3":
								$this->check_lock();
								$step_desc = "Confirmation";
								$this->tpl_main = "confirmation";
								$Template->set_vars(array("STEPS" => $this->step . "/" . $steps . ": " . $step_desc, "SCRIPT_NAME" => $this->script_name, ));
								$this->do_install();
								die();
								break;
						case "4":
								$step_desc = "Finish";
								$this->tpl_main = "finish";
								$Template->set_vars(array("STEPS" => $this->step . "/" . $steps . ": " . $step_desc, "SCRIPT_NAME" => $this->script_name, ));
								$this->show_finish();
				}
				$Template->set_vars(array("STEPVALUE" => $this->step . "/" . $steps . ": " . $step_desc, "SCRIPT_NAME" => $this->script_name, ));
		}
		function check_lock()
		{
				global $Template;
				if (file_exists("../install.lock"))
				{
						$file_content = trim(implode('', file("../install.lock")));
						if (!empty($file_content))
						{
								die("<font class=title2>The file install.lock is not empty! If you want to re-install SoSo News Express, please open and make the lock file blank.</font>");
						}
				}
		}
		function show_config_form()
		{
				global $Template;
				$path = str_replace("/install/install.php", "", $_SERVER["SCRIPT_NAME"]) . '/';
				$server = isset($_SERVER["SERVER_SOFTWARE"]) ? strtolower($_SERVER["SERVER_SOFTWARE"]) : '';
				if (strpos($server, 'apache') !== false)
				{
						$Template->set_block_vars("apache", array());
				}
				$Template->set_vars(array("SITE_URL" => 'http://' . $_SERVER["SERVER_NAME"] . $path, "SITE_PATH" => $path, "COOKIE_DOMAIN" => $_SERVER["SERVER_NAME"], "COOKIE_PATH" => $path, ));
		}
		function do_install()
		{
				global $Template, $DB;
				$this->data['install_type'] = isset($_POST['install_type']) ? $_POST['install_type'] : "new";
				$this->data['site_name'] = isset($_POST["site_name"]) ? htmlspecialchars($_POST["site_name"]) : '';
				$this->data['site_slogan'] = isset($_POST["site_slogan"]) ? htmlspecialchars($_POST["site_slogan"]) : '';
				$this->data['site_url'] = isset($_POST['site_url']) ? $_POST['site_url'] : "";
				$this->data['site_path'] = isset($_POST['site_path']) ? $_POST['site_path'] : "";
				$this->data['short_url_enabled'] = isset($_POST['short_url_enabled']) ? $_POST['short_url_enabled'] : 0;
				$this->data['short_url_sep'] = isset($_POST['short_url_sep']) ? $_POST['short_url_sep'] : "";
				$this->data['cookie_domain'] = isset($_POST['cookie_domain']) ? $_POST['cookie_domain'] : "";
				$this->data['cookie_path'] = isset($_POST['cookie_path']) ? $_POST['cookie_path'] : "";
				$this->data['host_name'] = isset($_POST['host_name']) ? $_POST['host_name'] : "";
				$this->data['db_name'] = isset($_POST['db_name']) ? $_POST['db_name'] : "";
				$this->data['db_username'] = isset($_POST['db_username']) ? $_POST['db_username'] : "";
				$this->data['db_password'] = isset($_POST['db_password']) ? $_POST['db_password'] : "";
				$this->data['tbl_prefix'] = isset($_POST['tbl_prefix']) ? $_POST['tbl_prefix'] : "";
				$this->data['admin_email'] = isset($_POST['admin_email']) ? $_POST['admin_email'] : "";
				$this->data['username'] = isset($_POST['username']) ? $_POST['username'] : "";
				$this->data['password'] = isset($_POST['password']) ? $_POST['password'] : "";
				$this->data['confirm_pwd'] = isset($_POST['confirm_pwd']) ? $_POST['confirm_pwd'] : "";
				if (empty($this->data['site_name']) || empty($this->data['site_url']) || empty($this->data['site_path']) || empty($this->data['cookie_domain']) || empty($this->data['cookie_path']) || empty($this->data['host_name']) || empty($this->data['db_name']) || empty($this->data['db_username']))
				{
						$Template->page_transfer("Please turn back and complete all required fields!", "install.php?step=" . ($this->step - 1));
						return;
				}
				if (($this->data['install_type'] == 'new') && (empty($this->data['admin_email']) || empty($this->data['username']) || empty($this->data['password']) || empty($this->data['confirm_pwd'])))
				{
						$Template->page_transfer("Please turn back and complete all required fields!", "install.php?step=" . ($this->step - 1));
						return;
				}
				if (($this->data['install_type'] == 'new') && ($this->data['confirm_pwd'] != $this->data['password']))
				{
						$Template->page_transfer("Your confirm password is not correct!", "install.php?step=" . ($this->step - 1));
						return;
				}
				$DB = new DBSql($this->data['host_name'], $this->data['db_name'], $this->data['db_username'], $this->data['db_password'], $this->data['tbl_prefix']);
				if ($this->data['install_type'] == 'new')
				{
						include ('modules/full_install.php');
						$New_Install = new New_Install($this->data);
				}
				else
				{
						$Template->set_files(array("header" => "header.tpl", "success" => "install_success.tpl", "refresh" => "install_refresh.tpl", "footer" => "footer.tpl", ));
						$Template->show("header");
						echo '<center><table border="0" cellpadding="0"><tr><td align="left">';
						$flag = -1;
						reset($this->module_upgrades);
						while (list($current_version, $upgrade_file) = each($this->module_upgrades))
						{
								$upgrade_file = trim($upgrade_file);
								if (empty($upgrade_file))
								{
										continue;
								}
								if ($flag == -1)
								{
										if ($current_version == $this->data['install_type'])
										{
												$flag = 0;
										}
										else
										{
												continue;
										}
								}
								if ($flag == 0)
								{
										echo "<br><font class=title2><strong>" . $this->desc_upgrades[$current_version] . "</strong></font><br><br>";
										include ('modules/' . $upgrade_file . '.php');
										$New_Upgrade = new New_Upgrade($this->data);
										$flag = 1;
										$this->data['install_type'] = $current_version;
								}
								else
								{
										$flag = 2;
										$this->data['install_type'] = $current_version;
										break;
								}
						}
						if ($flag == 2)
						{
								$this->data['site_name'] = html_entity_decode($this->data['site_name']);
								$this->data['site_slogan'] = html_entity_decode($this->data['site_slogan']);
								$hidden_fields = "";
								reset($this->data);
								while (list($field_name, $field_value) = each($this->data))
								{
										$hidden_fields .= ' <input type="hidden" name="' . $field_name . '" value="' . $field_value . '">';
								}
								$Template->set_vars(array('S_UPGRADE_ACTION' => 'install.php?step=3', 'HIDDEN_FIELDS' => $hidden_fields));
								$Template->show("refresh");
						}
						else
						{
								$Template->show("success");
						}
						echo '</td></tr></table></center>';
						$Template->show("footer");
				}
		}
		function show_finish()
		{
				global $Template;
				if (!$lock = fopen("../install.lock", "w"))
				{
						$this->halt("<font class=title2>Creating install.lock .... </font><font class=search>[ERROR]</font>");
						die();
				}
				fwrite($lock, "1");
				fclose($lock);
				$path = str_replace("install/install.php", "", $_SERVER["SCRIPT_NAME"]);
				$Template->set_vars(array("URL_INDEX" => 'http://' . $_SERVER["SERVER_NAME"] . $path, "URL_ACP" => 'http://' . $_SERVER["SERVER_NAME"] . $path . "admin/", ));
		}
		function halt($msg)
		{
				global $Template;
				echo $msg, " <font class=date> - ", @mysql_error(), "</font>";
				$Template->show("error");
				$Template->show("footer");
				die();
		}
}
?>
