<?php
/* =============================================================== *\
|		Module name:      Archive									|
|																	|
\* =============================================================== */

if (!defined('IN_SITE')){
     die('Hacking attempt!');
}
//Module language
$Func->import_module_language("home/lang_article". PHP_EX);

//Call global functions --------------
$HomeGlobal->cat_menu();
$HomeGlobal->show_poll();
$HomeGlobal->show_logos();
$HomeGlobal->show_events();
$HomeGlobal->show_news_picture();
$HomeGlobal->show_global_hotarticles();
$HomeGlobal->show_latest_box();
//------------------------------------

$Archive = new Archive;

class Archive
{
	var $filter		= array();
	var $page		= 1;

	function Archive(){
		global $Info, $Func, $Template, $Lang;

		$act	= $Func->get_vars('act', 1);
		$this->get_filter();
		if ( !empty($this->filter['url_append']) && ($this->filter['url_append'] != '?') ){
			$act	= 'list';
		}

		$Template->set_vars(array(
			'S_ARCHIVE_SEARCH'	=> $Func->compile_url(array('mod' => MOD_ARCHIVE)),
			"L_DATE_FROM"		=> $Lang->data['search_date_from'],
			"L_DATE_TO"			=> $Lang->data['search_date_to'],
			"L_BUTTON_GO"		=> $Lang->data['button_go'],
		));

		switch ($act){
			case "list":
				$Info->tpl_main		= "archive_list";
				$this->list_articles();
				break;
			case "view":
				$Info->tpl_main		= "archive_view";
				$this->view_article();
				break;
			case "print":
				$Info->tpl_header	= "";
				$Info->tpl_footer	= "";
				$Info->tpl_main		= "archive_print";
				$this->view_article();
				break;
			default:
				$Info->tpl_main		= "archive";
				$this->list_categories();
		}
	}

	function get_filter(){
		global $Template, $Info, $Func, $Info;

		$this->filter['url_append']		= $Info->option['short_url_enabled'] ? '?' : '';

		//Keyword
		$this->filter['keyword']		= htmlspecialchars($Func->get_request('s_keyword', ''));
		if ( !empty($this->filter['keyword']) ){
			$this->filter['url_append']	.= '&s_keyword='. $this->filter['keyword'];
		}

		//Category
		$this->filter['cat_id']		= intval($Func->get_request('s_cat_id', 0));
		if ( $this->filter['cat_id'] ){
			$this->filter['url_append']	.= '&s_cat_id='. $this->filter['cat_id'];
		}

		//Date from
		$this->filter['date_from']		= htmlspecialchars($Func->get_request('s_date_from', ''));
		if ( !empty($this->filter['date_from']) ){
			$this->filter['url_append']	.= '&s_date_from='. $this->filter['date_from'];
		}

		//Date to
//		$date_to	= gmdate('m/d/Y', CURRENT_TIME + $Info->option['timezone']*3600);
		$this->filter['date_to']		= htmlspecialchars($Func->get_request('s_date_to', ''));
		if ( !empty($this->filter['date_to']) ){
			$this->filter['url_append']	.= '&s_date_to='. $this->filter['date_to'];
		}

		$this->page			= isset($_GET["page"]) ? intval($_GET["page"]) : 1;

		$Template->set_vars(array(
			"SEARCH_KEYWORD"		=> $this->filter['keyword'],
			"SEARCH_CAT_ID"			=> $this->filter['cat_id'],
			"SEARCH_DATE_FROM"		=> $this->filter['date_from'],
			"SEARCH_DATE_TO"		=> $this->filter['date_to'],
		));
	}

	function list_categories(){
		global $DB, $Template, $Lang;

		$this->get_all_cats();
		$this->set_all_cats(0, 0);
	}

	function list_articles(){
		global $Lang, $Func, $Info, $DB, $Template, $HomeGlobal;

		$cat_code			= $Func->get_vars('code', 2);
		$date_format		= $Info->option['time_format'];
		$timezone			= $Info->option['timezone'] * 3600;
		$itemperpage		= 50;
		$group_by			= "";
		$cat_navigator		= "";

		if ( !empty($cat_code) || $this->filter['cat_id'] ){
			//Check if category exist
			if ( !empty($cat_code) ){
				$DB->query('SELECT cat_id, cat_name, cat_template, cat_keywords, cat_desc FROM '. $DB->prefix .'article_category WHERE enabled=1 AND cat_code="'. $cat_code .'"');
			}
			else{
				$DB->query('SELECT cat_id, cat_name, cat_template, cat_keywords, cat_desc FROM '. $DB->prefix .'article_category WHERE enabled=1 AND cat_id='. $this->filter['cat_id']);
			}
			if ( !$DB->num_rows() ){
				$Template->page_transfer($Lang->data['article_error_cat_not_exist'], $Func->compile_url(array('mod' => MOD_ARCHIVE)));
				die();
			}
			$cat_info	= $DB->fetch_array();
			$this->get_cat_navigator($cat_navigator, $cat_info['cat_id']);
			$Template->set_vars(array(
				"SEARCH_CAT_ID"			=> $cat_info['cat_id'],
			));
		}

		//Filter ----------------------------------------
		$where_sql	= ' WHERE A.enabled='. SYS_ENABLED .' AND A.archived='. SYS_ARCHIVED .' AND A.article_type!='. SYS_ARTICLE_SUMMARY .' AND A.posted_date<='. CURRENT_TIME;
		if ( !empty($this->filter['keyword']) ){
			$this->filter['keyword']	= str_replace('*', '%', $this->filter['keyword']);
			if ( SEARCH_TYPE == 1 ){
				//Fulltext search
				if ( SEARCH_IN == 1 ){
					$where_sql	.= " AND (MATCH (A.title, A.content_desc) AGAINST ('". $this->filter['keyword'] ."'))";
				}
				else{
					$where_sql	= ", ". $DB->prefix ."article_page_content AS P ". $where_sql ." AND A.article_id=P.article_id AND ((MATCH (A.title, A.content_desc) AGAINST ('". $this->filter['keyword'] ."')) OR (MATCH (P.author, P.content_detail) AGAINST ('". $this->filter['keyword'] ."')))";
					$group_by	= " GROUP BY A.article_id";
				}
			}
			else{
				//Normal search
				if ( SEARCH_IN == 1 ){
					$where_sql	.= " AND (A.title LIKE '%". $this->filter['keyword'] ."%' OR A.content_desc LIKE '%". $this->filter['keyword'] ."%')";
				}
				else{
					$where_sql	= ", ". $DB->prefix ."article_page_content AS P ". $where_sql ." AND A.article_id=P.article_id AND (A.title LIKE '%". $this->filter['keyword'] ."%' OR A.content_desc LIKE '%". $this->filter['keyword'] ."%' OR P.author LIKE '%". $this->filter['keyword'] ."%' OR P.content_detail LIKE '%". $this->filter['keyword'] ."%')";
					$group_by	= " GROUP BY A.article_id";
				}
			}
		}
		if ( isset($cat_info['cat_id']) ){
			//Get all sub cats
			$where_sql	.= " AND (A.cat_id=". $cat_info['cat_id'];
			$HomeGlobal->get_sub_cat_sql($cat_info['cat_id'], $where_sql);
			$where_sql	.= ")";
		}

		if ( !empty($this->filter['date_from']) ){
			$date_from	= $Func->string_to_date($this->filter['date_from'], 0, 0, 1);
			$where_sql	.= " AND A.posted_date>=". $date_from;
		}
		if ( !empty($this->filter['date_to']) ){
			$date_to	= $Func->string_to_date($this->filter['date_to'], 23, 59, 59);
			$where_sql	.= " AND A.posted_date<=". $date_to;
		}
		//-----------------------------------------------

		//Count total pages -----------------------------
//		$where_sql		.= sizeof($HomeGlobal->disabled_cats) ? " AND A.cat_id NOT IN (". implode(",", $HomeGlobal->disabled_cats) .")" : "";
		$DB->query('SELECT count(distinct A.article_id) AS total FROM '. $DB->prefix .'article AS A '. $where_sql);
		if ( $DB->num_rows() ){
			$result		= $DB->fetch_array();
			if ( !empty($cat_code) ){
				$u_page		= $Func->compile_url(array('mod' => MOD_ARCHIVE, 'act' => 'list', 'code' => $cat_code)) . $this->filter['url_append'];
			}
			else{
				$u_page		= $Func->compile_url(array('mod' => MOD_ARCHIVE)) . $this->filter['url_append'];
			}
			$pageshow	= $Func->pagination($result['total'], $itemperpage, $this->page, $u_page);
		}
		else{
			$pageshow['page']	= "";
			$pageshow['start']	= 0;
		}
		$DB->free_result();
		//-----------------------------------------------

		//Get articles
		$DB->query('SELECT A.article_id, A.cat_id, A.title, A.content_url, A.posted_date, A.article_type FROM '. $DB->prefix .'article AS A '. $where_sql .' '. $group_by .' ORDER BY A.posted_date DESC LIMIT '. $pageshow['start'] .','. $itemperpage);
		$article_count	= $DB->num_rows();
		$article_data	= $DB->fetch_all_array();
		$DB->free_result();

		for ($i=0; $i<$article_count; $i++){
			$code_path	= "";
			$HomeGlobal->get_code_path($code_path, $article_data[$i]['cat_id']);
			if ( $article_data[$i]['article_type'] == SYS_ARTICLE_LINK ){
				$u_view		= $article_data[$i]['content_url'];
			}
			else{
				$u_view		= $Func->compile_url(array('mod' => MOD_ARCHIVE, 'act' => 'view', 'article' => $article_data[$i]['article_id']));
			}
			$Template->set_block_vars("articlerow", array(
				'NUM'			=> ($pageshow['start'] + $i + 1),
				'DATE'			=> $Func->translate_date(gmdate($date_format, $article_data[$i]['posted_date'] + $timezone)),
				'TITLE'			=> $Func->make_article_link(html_entity_decode($article_data[$i]['title']), $article_data[$i]['article_type'], $u_view, 'otherNews'),
//				'U_VIEW'		=> $Func->compile_url(array('mod' => MOD_ARCHIVE, 'cat' => $code_path, 'article' => $article_data[$i]['article_id'])),
			));
		}

		$Template->set_vars(array(
			'CAT_NAVIGATOR'		=> !empty($cat_navigator) ? '&raquo; '. $cat_navigator : '',
			"PAGE_OUT"			=> $pageshow['page'],
			'L_SEARCH_RESULT'	=> $this->filter['keyword'] ? sprintf($Lang->data['search_result'], $this->filter['keyword']) : $Lang->data['search_result2'],
		));
	}

	function view_article(){
		global $DB, $Func, $Info, $Template, $HomeGlobal, $Lang;

		$article_id			= $Func->get_vars('article', 2);
		$page_order			= intval($Func->get_vars('page_order', 3));
		$highlight			= htmlspecialchars(urldecode($Func->get_request('highlight', '', 'GET')));
		$match				= htmlspecialchars($Func->get_request('match', '', 'GET'));

		$date_format		= $Info->option['full_date_time_format'];
		$timezone			= $Info->option['timezone'] * 3600;

		//Get article info
		$where_sql		= sizeof($HomeGlobal->disabled_cats) ? " AND A.cat_id NOT IN (". implode(",", $HomeGlobal->disabled_cats) .")" : "";
		if ( $page_order ){
			$DB->query('SELECT A.article_id, A.cat_id, A.topic_id, A.meta_keywords, A.meta_desc, A.title, A.posted_date, A.page_counter, A.rating_marks, A.rating_count, P.page_id, P.page_order, P.page_title FROM '. $DB->prefix .'article AS A, '. $DB->prefix .'article_page AS P WHERE A.enabled='. SYS_ENABLED .' AND A.archived='. SYS_ARCHIVED .' AND P.page_enabled='. SYS_ENABLED . $where_sql .' AND A.article_id='. $article_id .' AND P.article_id='. $article_id .' AND P.page_order='. $page_order);
		}
		else{
			$DB->query('SELECT A.article_id, A.cat_id, A.topic_id, A.meta_keywords, A.meta_desc, A.title, A.posted_date, A.page_counter, A.rating_marks, A.rating_count, P.page_id, P.page_order, P.page_title FROM '. $DB->prefix .'article AS A, '. $DB->prefix .'article_page AS P WHERE A.enabled='. SYS_ENABLED .' AND A.archived='. SYS_ARCHIVED .' AND P.page_enabled='. SYS_ENABLED . $where_sql .' AND A.article_id='. $article_id .' AND P.article_id='. $article_id .' ORDER BY P.page_order ASC LIMIT 0,1');
		}
		if ( !$DB->num_rows() ){
			$this->list_articles();
			return false;
		}
		$article_info	= $DB->fetch_array();

		//Get article content
		$DB->query('SELECT content_detail, author FROM '. $DB->prefix .'article_page_content WHERE page_id='. $article_info['page_id']);
		if ( $DB->num_rows() ){
			$tmp_info	= $DB->fetch_array();
			$article_info['content_detail']	= $tmp_info['content_detail'];
			$article_info['author']			= $tmp_info['author'];
		}
		else{
			$article_info['content_detail']	= "";
			$article_info['author']			= "";
		}

		//Check category
		$DB->query('SELECT cat_id, cat_name, cat_template, cat_keywords, cat_desc FROM '. $DB->prefix .'article_category WHERE cat_id='. $article_info['cat_id']);
		if ( !$DB->num_rows() ){
			$Template->page_transfer($Lang->data['article_error_cat_not_exist'], $Func->compile_url(array('mod' => MOD_ARCHIVE)));
			die();
		}
		$cat_info	= $DB->fetch_array();
		$cat_navigator	= "";
		$this->get_cat_navigator($cat_navigator, $cat_info['cat_id']);

		$code_path	= "";
		$HomeGlobal->get_code_path($code_path, $cat_info['cat_id']);
		$Template->set_vars(array(
			'U_PAGE_ORDER'			=> $Info->option['site_url'] . $Func->compile_url(array('mod' => MOD_ARCHIVE, 'act' => 'view', 'article' => $article_info['article_id'], 'page_order' => $article_info['page_order'])),
			'BROWSER_NAVIGATOR'		=> ' - '. strip_tags(html_entity_decode($article_info['title'])),
			'META_KEYWORDS'			=> !empty($article_info['meta_keywords']) ? $article_info['meta_keywords'] : (!empty($cat_info['cat_keywords']) ? $cat_info['cat_keywords'] : $Info->option['site_keywords']),
			'META_DESC'				=> !empty($article_info['meta_desc']) ? $article_info['meta_desc'] : (!empty($cat_info['cat_desc']) ? $cat_info['cat_desc'] : $Info->option['site_desc']),
			'CAT_TEMPLATE'			=> $cat_info['cat_template'],
			'CAT_NAVIGATOR'			=> !empty($cat_navigator) ? '&raquo; '. $cat_navigator : '',
			'ARTICLE_TITLE'			=> $Func->highlight_text(html_entity_decode($article_info['page_title']), $highlight, $match),
//			'PAGE_TITLE'			=> $article_info['page_title'],
			'ARTICLE_DATE'			=> $Func->translate_date(gmdate($date_format, $article_info['posted_date'] + $timezone)),
			'ARTICLE_CONTENT'		=> $Func->highlight_text(html_entity_decode($article_info['content_detail']), $highlight, $match),
			'GMT'					=> ($Info->option['timezone'] > 0) ? 'GMT+'. $Info->option['timezone'] : (($Info->option['timezone'] < 0) ? 'GMT'. $Info->option['timezone'] : 'GMT'),
			'ARTICLE_AUTHOR'		=> $article_info['author'],
			'U_PRINT'				=> $Info->option['site_url'] . $Func->compile_url(array('mod' => MOD_ARCHIVE, 'act' => 'print', 'article' => $article_info['article_id'], 'page_order' => $page_order)),
			'L_PRINT'				=> $Lang->data['general_print'],
			'L_TELLFRIEND'			=> $Lang->data['general_tellfriend'],
			'L_PAGE_PREV'			=> $Lang->data['general_page_prev'],
			'L_PAGE_NEXT'			=> $Lang->data['general_page_next'],
			'L_GO'					=> $Lang->data['general_go'],
		));

		//Get all pages ---------
		if ( $article_info['page_counter'] > 1 ){
			$DB->query('SELECT page_title, page_order FROM '. $DB->prefix .'article_page WHERE article_id='. $article_id .' AND page_enabled='. SYS_ENABLED .' ORDER BY page_order ASC');
			$page_count	= $DB->num_rows();
			$page_data	= $DB->fetch_all_array();
			$DB->free_result();

			if ( $page_count > 1 ){
				$p_order	= -1;
				for ($i=0; $i<$page_count; $i++){
					$Template->set_block_vars("pagerow", array(
						'U_VIEW'	=> $Info->option['site_url'] . $Func->compile_url(array('mod' => MOD_ARCHIVE, 'act' => 'view', 'article' => $article_info['article_id'], 'page_order' => $page_data[$i]['page_order'])),
						'TITLE'		=> strip_tags(html_entity_decode($page_data[$i]['page_title'])),
					));
					if ( $article_info['page_order'] == $page_data[$i]['page_order'] ){
						$p_order	= $i;
					}
				}

				if ( $p_order != -1 ){
					$Template->set_vars(array(
						'U_PREV_PAGE'	=> ($p_order > 0) ? $Info->option['site_url'] . $Func->compile_url(array('mod' => MOD_ARCHIVE, 'act' => 'view', 'article' => $article_info['article_id'], 'page_order' => $page_data[$p_order - 1]['page_order'])) : $Info->option['site_url'] . $Func->compile_url(array('mod' => MOD_ARCHIVE, 'act' => 'view', 'article' => $article_info['article_id'], 'page_order' => $page_data[$p_order]['page_order'])) .'#',
						'U_NEXT_PAGE'	=> ($p_order < $page_count - 1) ? $Info->option['site_url'] . $Func->compile_url(array('mod' => MOD_ARCHIVE, 'act' => 'view', 'article' => $article_info['article_id'], 'page_order' => $page_data[$p_order + 1]['page_order'])) : $Info->option['site_url'] . $Func->compile_url(array('mod' => MOD_ARCHIVE, 'act' => 'view', 'article' => $article_info['article_id'], 'page_order' => $page_data[$p_order]['page_order'])) .'#',
					));
					if ( $p_order > 0 ){
						$Template->set_block_vars("prevpage");
					}
					if ( $p_order < $page_count - 1 ){
						$Template->set_block_vars("nextpage");
					}
				}
			}
		}
		//------------------------

		//Rating
		if ( $Info->option['rating_enabled'] ){
			$Template->set_block_vars("ratingon");
			$this->show_rating_results($article_info);
		}

		if ( $Info->option['comment_enabled'] ){
			$this->show_article_comments($article_info);
		}
		return true;
	}

	function show_rating_results($article_info){
		global $DB, $Func, $Info, $Template, $HomeGlobal, $Lang;

		if ( $article_info['rating_count'] > 0 ){
			//We double rating marks in order to convert it from limitation 5 to 10
			$rating_average	= round((2*$article_info['rating_marks']) / $article_info['rating_count']);
			$rating_average	= $rating_average / 2; //Reconvert to limitation 5
		}
		else{
			$rating_average	= 0;
		}

		$rating_stars	= '';
		for ($i=1; $i<=5; $i++){
			if ( $rating_average >= $i ){
				$rating_stars	.= '<img src="'. $Info->option['template_path'] .'/images/rating_1.gif" border="0" vspace="2" hspace="0">';
			}
			else if ( $rating_average >= ($i - 0.5) ){
				$rating_stars	.= '<img src="'. $Info->option['template_path'] .'/images/rating_0.5.gif" border="0" vspace="2" hspace="0">';
			}
			else{
				$rating_stars	.= '<img src="'. $Info->option['template_path'] .'/images/rating_0.gif" border="0" vspace="2" hspace="0">';
			}
		}

		$Template->set_vars(array(
			'ARTICLE_ID'			=> $article_info['article_id'],
			'RATING_STARS'			=> $rating_stars,
			'RATING_AVERAGE'		=> ($article_info['rating_count'] > 1) ? ' . '. $Lang->data['rating_average'] .': '. $rating_average .'/5' : '',
			'RATING_VOTES'			=> $Lang->data['rating_votes'] .': '. $article_info['rating_count'],
			'L_RATING'				=> $Lang->data['rating'],
			'L_RATING_UPDATE'		=> $Lang->data['rating_update'],
		));
	}

	function show_article_comments($article_info){
		global $DB, $Lang, $Template, $Info, $Func, $HomeGlobal;

		$date_format		= $Info->option['time_format'];
		$timezone			= $Info->option['timezone'] * 3600;

		//Get comments
		$DB->query('SELECT * FROM '. $DB->prefix .'article_comment WHERE article_id='. $article_info['article_id'] .' AND enabled='. SYS_ENABLED .' ORDER BY posted_date DESC');
		$comment_count	= $DB->num_rows();
		$comment_data	= $DB->fetch_all_array();
		$DB->free_result();

		for ($i=0; $i<$comment_count; $i++){
			$Template->set_block_vars("commentrow", array(
				'DATE'		=> $Func->translate_date(gmdate($date_format, $comment_data[$i]['posted_date'] + $timezone)),
				'TITLE'		=> $comment_data[$i]['title'],
				'CONTENT'	=> nl2br($comment_data[$i]['content']),
				'NAME'		=> $comment_data[$i]['name'],
				'EMAIL'		=> $comment_data[$i]['email'],
			));
		}

		$Template->set_vars(array(
			'CM_NAME'			=> isset($this->data['name']) ? stripslashes($this->data['name']) : '',
			'CM_EMAIL'			=> isset($this->data['email']) ? stripslashes($this->data['email']) : '',
			'CM_TITLE'			=> isset($this->data['title']) ? stripslashes($this->data['title']) : '',
			'CM_CONTENT'		=> isset($this->data['content']) ? stripslashes($this->data['content']) : '',
			'L_COMMENT'			=> $Lang->data['comments'],
			'L_COMMENT_NEW'		=> $Lang->data['comment_new'],
			'L_NAME'			=> $Lang->data['comment_name'],
			'L_EMAIL'			=> $Lang->data['comment_email'],
			'L_TITLE'			=> $Lang->data['comment_title'],
			'L_CONTENT'			=> $Lang->data['comment_content'],
			'L_COMMENT_SUBMIT'	=> $Lang->data['comment_submit'],
			'L_ERROR_NOT_FULL'	=> $Lang->data['general_error_not_full'],
		));
	}

	function get_cat_navigator(&$cat_navigator, $cat_id){
		global $HomeGlobal, $Func, $Info;

		for ($i=0; $i<$HomeGlobal->cat_count; $i++){
			if ( $cat_id == $HomeGlobal->cat_data[$i]['cat_id'] ){
				$code_path	= "";
				$HomeGlobal->get_code_path($code_path, $cat_id);
				if ( !empty($cat_navigator) ){
					$cat_navigator	= " &raquo; ". $cat_navigator;
				}
				$cat_navigator	= '<a class="catnav" href="'. $Func->compile_url(array('mod' => MOD_ARCHIVE, 'act' => 'list', 'code' => $code_path)) .'">'. $HomeGlobal->cat_data[$i]['cat_name'] .'</a>' . $cat_navigator;
				
				if ( $HomeGlobal->cat_data[$i]['cat_parent_id'] ){
					$this->get_cat_navigator($cat_navigator, $HomeGlobal->cat_data[$i]['cat_parent_id']);
				}
				break;
			}
		}
	}

	function get_all_cats(){
		global $DB, $Func, $HomeGlobal;

		$where_sql		= sizeof($HomeGlobal->disabled_cats) ? " WHERE cat_id NOT IN (". implode(",", $HomeGlobal->disabled_cats) .")" : "";
		$DB->query("SELECT * FROM ". $DB->prefix ."article_category ". $where_sql ." ORDER BY cat_order ASC");
		$this->cat_count = $DB->num_rows();
		$this->cat_data  = $DB->fetch_all_array();
		$DB->free_result();
	}

	function set_all_cats($parent_id, $except_cid, $level=0, $url_append = "", $symbol="&raquo; ", $prefix="&nbsp; &nbsp; &nbsp; &nbsp; &nbsp;"){
		global $Session, $Template, $Func, $Info, $Lang;

		if ($level){
			$str_prefix	= "";
			for ($i=0; $i<$level; $i++){
				$str_prefix	.= $prefix;
			}
		}
		else{
			$str_prefix	= "";
		}

		for ($i=0; $i<$this->cat_count; $i++){
			if ( ($parent_id == $this->cat_data[$i]['cat_parent_id']) && ($except_cid != $this->cat_data[$i]['cat_id']) && empty($this->cat_data[$i]['redirect_url']) ){
				$Template->set_block_vars("catrow", array(
					'NAME'			=> $this->cat_data[$i]['cat_name'],
					'PREFIX'		=> $str_prefix .$symbol,
					'U_VIEW'		=> $Func->compile_url(array('mod' => MOD_ARCHIVE, 'act' => 'list', 'code' => $this->cat_data[$i]['cat_code'])),
				));
				$this->set_all_cats($this->cat_data[$i]['cat_id'], $except_cid, $level+1, $url_append, $symbol, $prefix);
			}
		}
	}
}

?>