<?php
/* =============================================================== *\
|		Module name:      Article									|
|																	|
\* =============================================================== */

if (!defined('IN_SITE')){
     die('Hacking attempt!');
}
define('DIR_CAT', 'category/');
//Module language
$Func->import_module_language("home/lang_article". PHP_EX);

//Call global functions --------------
$HomeGlobal->cat_menu();
$HomeGlobal->show_poll();
$HomeGlobal->show_logos();
$HomeGlobal->show_events();
$HomeGlobal->show_news_picture();
$HomeGlobal->show_global_hotarticles();
$HomeGlobal->show_latest_box();
//------------------------------------

$Article = new Article;

class Article
{
	var $page		= 1;

	function Article(){
		global $HomeGlobal, $Func;

		//Get article id and action
		$article_id	= intval($Func->get_vars('article', $HomeGlobal->cat_pos_var + 1));
		$page_order	= intval($Func->get_vars('page_order', $HomeGlobal->cat_pos_var + 2));
		$act		= htmlspecialchars($Func->get_vars('act', $HomeGlobal->cat_pos_var + 3));

		if ( $article_id ){
			switch ( $act ){
				case "print":
					$this->print_article($article_id, $page_order);
					break;
				default:
					$this->view_article($article_id, $page_order);
			}
		}
		else{
			$page		= $Func->get_vars('page', $HomeGlobal->cat_pos_var + 1);
			$page		= intval(str_replace('page_', '', $page));
			$this->page	= ($page > 0) ? $page : 1;

			$this->list_articles();
		}

		//Don't display category list and hot articles when user views all articles
		if ( isset($HomeGlobal->cat_data[0]['cat_parent_id']) && $HomeGlobal->cat_data[0]['cat_parent_id'] ){
			$this->get_top_cat_articles();
			$this->get_hot_articles();
		}
	}

	function get_top_cat_articles(){
		global $DB, $Template, $HomeGlobal, $Info, $Func;

		for ($i=0; $i<$HomeGlobal->cat_count; $i++){
			if ( $HomeGlobal->cat_data[$i]['cat_parent_id'] == $HomeGlobal->cat_id ){
				$DB->query('SELECT posted_date, article_id, thumb_small, thumb_icon, title, article_type FROM '. $DB->prefix .'article WHERE cat_id='. $HomeGlobal->cat_data[$i]['cat_id'] .' AND posted_date<='. CURRENT_TIME .' AND archived='. SYS_UNARCHIVED .' AND enabled='. SYS_ENABLED .' AND article_type!= '. SYS_ARTICLE_SUMMARY .' ORDER BY posted_date DESC LIMIT 0,1');
				if ( !$DB->num_rows() ){
					continue;
				}
				$article_info	= $DB->fetch_array();
				$DB->free_result();

				$code_path	= $HomeGlobal->cat_data[$i]['cat_code'];
				if ( $HomeGlobal->cat_data[$i]['cat_parent_id'] && $Info->option['short_url_enabled'] ){
					$HomeGlobal->get_code_path($code_path, $HomeGlobal->cat_data[$i]['cat_parent_id']);
				}

				$thumb_small		= !empty($article_info['thumb_small']) ? '<img src="'. $Func->get_article_dir($article_info['posted_date'], $article_info['article_id']) .'/'. $article_info['thumb_small'] .'" alt="" title="'. $article_info['title'] .'" border="1" vspace="5" hspace="5">' : '';
				$u_article_view		= $Func->compile_url(array('mod' => MOD_ARTICLE, 'cat' => $code_path, 'article' => $article_info['article_id']));
				$Template->set_block_vars("hotcatrow", array(
					'NAME'				=> $HomeGlobal->cat_data[$i]['cat_name'],
					'U_VIEW'			=> $Func->compile_url(array('mod' => MOD_ARTICLE, 'cat' => $code_path)),
					'ARTICLE_THUMB'		=> !empty($thumb_small) ? $Func->make_article_link($thumb_small, $article_info['article_type'], $u_article_view, "hottitle2") : '',
					'ARTICLE_TITLE'		=> $Func->make_article_link(strip_tags(html_entity_decode($article_info['title'])), $article_info['article_type'], $u_article_view, "hottitle2"),
//					'U_ARTICLE_VIEW'	=> $u_view,
				));
			}
		}
	}

	function get_hot_articles(){
		global $DB, $Template, $HomeGlobal, $Info, $Func, $Lang;

		//Get all sub cats
		$where_sql	= " WHERE (cat_id=". $HomeGlobal->cat_id;
		$HomeGlobal->get_sub_cat_sql($HomeGlobal->cat_id, $where_sql);
		$where_sql	.= ")";

		$DB->query('SELECT article_id, cat_id, thumb_icon, title, posted_date, article_type FROM '. $DB->prefix .'article '. $where_sql .' AND is_hot='. SYS_ARTICLE_HOT .' AND article_type!='. SYS_ARTICLE_SUMMARY .' AND archived='. SYS_UNARCHIVED .' AND enabled='. SYS_ENABLED .' AND posted_date<='. CURRENT_TIME .' ORDER BY posted_date DESC LIMIT 0,'. $Info->option['limit_home_hot']);
		$article_count	= $DB->num_rows();
		$article_data	= $DB->fetch_all_array();
		$DB->free_result();

		for ($i=0; $i<$article_count; $i++){
			$code_path	= "";
			$HomeGlobal->get_code_path($code_path, $article_data[$i]['cat_id']);
			$thumb_icon		= !empty($article_data[$i]['thumb_icon']) ? '<img src="'. $Func->get_article_dir($article_data[$i]['posted_date'], $article_data[$i]['article_id']) .'/'. $article_data[$i]['thumb_icon'] .'" alt="" title="'. $article_data[$i]['title'] .'" border="0" align="left" vspace="5" hspace="5">' : '';
			$u_view			= $Func->compile_url(array('mod' => MOD_ARTICLE, 'cat' => $code_path, 'article' => $article_data[$i]['article_id']));
			$Template->set_block_vars("hotarticlerow", array(
				'THUMB_ICON'	=> !empty($thumb_icon) ? $Func->make_article_link($thumb_icon, $article_data[$i]['article_type'], $u_view) : '',
				'TITLE'			=> $Func->make_article_link(strip_tags(html_entity_decode($article_data[$i]['title'])), $article_data[$i]['article_type'], $u_view, "hottitle"),
//				'U_VIEW'		=> $u_view,
			));
		}

		$Template->set_vars(array(
			'L_HOT_ARTICLES'	=> $Lang->data['article_hot']
		));
	}

	function list_articles(){
		global $DB, $Lang, $Template, $Info, $HomeGlobal, $Func;

		$Info->tpl_main		= "article_list";
		$date_format		= $Info->option['full_date_time_format'];
		$timezone			= $Info->option['timezone'] * 3600;
		$limit_news			= $Info->option['limit_home_news'];
		$limit_total		= $Info->option['limit_home_news'] + $Info->option['limit_home_news_next'];

		//Check disabled categories
		if ( in_array($HomeGlobal->cat_id, $HomeGlobal->disabled_cats) ){
			$Template->page_transfer($Lang->data['article_error_cat_not_exist'], $Info->option['site_url'] . $Func->compile_url(""));
			die();
		}

		//Check if category exist
		if ( $HomeGlobal->cat_id ){
			$DB->query('SELECT cat_id, cat_name, cat_template, cat_keywords, cat_desc FROM '. $DB->prefix .'article_category WHERE cat_id='. $HomeGlobal->cat_id);
			if ( !$DB->num_rows() ){
				$Template->page_transfer($Lang->data['article_error_cat_not_exist'], $Info->option['site_url'] . $Func->compile_url(""));
				die();
			}
			$cat_info	= $DB->fetch_array();

			$cat_navigator	= "";
			$this->get_cat_navigator($cat_navigator, $cat_info['cat_id']);

			//Get all sub cats
			$where_sql	= " WHERE (cat_id=". $cat_info['cat_id'];
			$HomeGlobal->get_sub_cat_sql($cat_info['cat_id'], $where_sql);
			$where_sql	.= ")";
		}
		else{
			$where_sql		= sizeof($HomeGlobal->disabled_cats) ? " WHERE cat_id NOT IN (". implode(",", $HomeGlobal->disabled_cats) .")" : " WHERE 1 ";
			$cat_navigator	= '<a class="catnav" href="'. $Func->compile_url(array('mod' => MOD_ARTICLE)) .'">'. $Lang->data['general_all_news'] .'</a>';
		}

		$hot_info['article_id']	= 0;

		if ( $this->page <= 1 ){
			//Get hot articles
			$DB->query('SELECT article_id, cat_id, thumb_large, thumb_small, title, content_desc, posted_date, article_type FROM '. $DB->prefix .'article '. $where_sql .' AND archived='. SYS_UNARCHIVED .' AND enabled='. SYS_ENABLED .' AND is_hot='. SYS_ARTICLE_HOT .' AND posted_date<='. CURRENT_TIME .' ORDER BY posted_date DESC LIMIT 0,1');
			if ( $DB->num_rows() ){
				$hot_info	= $DB->fetch_array();

				$code_path	= "";
				$HomeGlobal->get_code_path($code_path, $hot_info['cat_id']);
				$hot_thumb	= !empty($hot_info['thumb_large']) ? $hot_info['thumb_large'] : (!empty($hot_info['thumb_small']) ? $hot_info['thumb_small'] : '');
				$hot_thumb	= !empty($hot_thumb) ? '<img src="'. $Func->get_article_dir($hot_info['posted_date'], $hot_info['article_id']) .'/'. $hot_thumb .'" alt="" title="'. $hot_info['title'] .'" border="0" align="left" vspace="1" hspace="1" style="padding-right: 8px;">' : '';
				$u_view		= $Func->compile_url(array('mod' => MOD_ARTICLE, 'cat' => $code_path, 'article' => $hot_info['article_id']));

				$Template->set_block_vars("havehot");
				$Template->set_vars(array(
					'HOT_DATE'			=> $Func->translate_date(gmdate($date_format, $hot_info['posted_date'] + $timezone)),
					'HOT_THUMB_LARGE'	=> !empty($hot_thumb) ? $Func->make_article_link($hot_thumb, $hot_info['article_type'], $u_view) : '',
					'HOT_TITLE'			=> $Func->make_article_link(html_entity_decode($hot_info['title']), $hot_info['article_type'], $u_view, 'btitle'),
					'HOT_PREVIEW'		=> html_entity_decode($hot_info['content_desc']),
				));
			}
		}

		$code_path	= "";
		if ( $HomeGlobal->cat_id ){
			$HomeGlobal->get_code_path($code_path, $cat_info['cat_id']);
		}

		//Count total pages -----------------------------
		$DB->query('SELECT count(article_id) AS total FROM '. $DB->prefix .'article '. $where_sql .' AND archived='. SYS_UNARCHIVED .' AND enabled='. SYS_ENABLED .' AND article_id!='. $hot_info['article_id'] .' AND posted_date<='. CURRENT_TIME);
		if ( $DB->num_rows() ){
			$result		= $DB->fetch_array();
			$u_page		= $HomeGlobal->cat_id ? $Func->compile_url(array('mod' => MOD_ARTICLE, 'cat' => $code_path)) : $Func->compile_url(array('mod' => MOD_ARTICLE));
			$pageshow	= $Func->virtual_pagination($result['total'], $limit_total, $this->page, "<strong>". $Lang->data['general_page'] ."</strong>", $u_page, "page_");
		}
		else{
			$pageshow['page']	= "";
			$pageshow['start']	= 0;
		}
		$DB->free_result();
		//-----------------------------------------------

		//Get articles desc
		$DB->query('SELECT article_id, cat_id, thumb_small, title, content_desc, content_url, posted_date, article_type FROM '. $DB->prefix .'article '. $where_sql .' AND archived='. SYS_UNARCHIVED .' AND enabled='. SYS_ENABLED .' AND article_id!='. $hot_info['article_id'] .' AND posted_date<='. CURRENT_TIME .' ORDER BY posted_date DESC LIMIT '. $pageshow['start'] .','. $limit_total);
		$article_count	= $DB->num_rows();
		$article_data	= $DB->fetch_all_array();
		$DB->free_result();

		if ($article_count < $limit_news){
			$limit_news	= $article_count;
		}

		//Get news
		for ($i=0; $i<$limit_news; $i++){
			$code_path	= "";
			$HomeGlobal->get_code_path($code_path, $article_data[$i]['cat_id']);
			$thumb_small	= !empty($article_data[$i]['thumb_small']) ? '<img src="'. $Func->get_article_dir($article_data[$i]['posted_date'], $article_data[$i]['article_id']) .'/'. $article_data[$i]['thumb_small'] .'" alt="" title="'. $article_data[$i]['title'] .'" vspace="5" hspace="5" border="0" align="left">' : '';
			if ( $article_data[$i]['article_type'] == SYS_ARTICLE_LINK ){
				$u_view		= $article_data[$i]['content_url'];
			}
			else{
				$u_view		= $Func->compile_url(array('mod' => MOD_ARTICLE, 'cat' => $code_path, 'article' => $article_data[$i]['article_id']));
			}
			$Template->set_block_vars("articlerow", array(
				'DATE'			=> $Func->translate_date(gmdate($date_format, $article_data[$i]['posted_date'] + $timezone)),
				'THUMB_SMALL'	=> !empty($thumb_small) ? $Func->make_article_link($thumb_small, $article_data[$i]['article_type'], $u_view) : '',
				'TITLE'			=> $Func->make_article_link(html_entity_decode($article_data[$i]['title']), $article_data[$i]['article_type'], $u_view, 'mtitle'),
				'PREVIEW'		=> html_entity_decode($article_data[$i]['content_desc']),
			));
		}

		//get next news
		if ( $article_count > $limit_news ){
			if ($article_count < $limit_total){
				$limit_total	= $article_count;
			}

			for ($i = $limit_news; $i < $limit_total; $i++){
				$code_path	= "";
				$HomeGlobal->get_code_path($code_path, $article_data[$i]['cat_id']);
				if ( $article_data[$i]['article_type'] == SYS_ARTICLE_LINK ){
					$u_view		= $article_data[$i]['content_url'];
				}
				else{
					$u_view		= $Func->compile_url(array('mod' => MOD_ARTICLE, 'cat' => $code_path, 'article' => $article_data[$i]['article_id']));
				}
				$Template->set_block_vars("nextrow", array(
					'TITLE'			=> $Func->make_article_link(strip_tags(html_entity_decode($article_data[$i]['title'])), $article_data[$i]['article_type'], $u_view, 'ntitle')
//					'U_VIEW'		=> $u_view,
				));
			}
		}

		$Info->tpl_main	= $HomeGlobal->cat_id ? DIR_CAT . $cat_info['cat_template'] . "/". $Info->tpl_main : DIR_CAT ."default/". $Info->tpl_main;
		$Template->set_vars(array(
			'CAT_NAVIGATOR'		=> $cat_navigator,
			"PAGE_OUT"			=> $pageshow['page'],
			'BROWSER_NAVIGATOR'	=> $HomeGlobal->cat_id ? ' - '. $cat_info['cat_name'] : ' - ',
			'META_KEYWORDS'		=> !empty($cat_info['cat_keywords']) ? $cat_info['cat_keywords'] : $Info->option['site_keywords'],
			'META_DESC'			=> !empty($cat_info['cat_desc']) ? $cat_info['cat_desc'] : $Info->option['site_desc'],
		));
	}

	function get_cat_navigator(&$cat_navigator, $cat_id){
		global $HomeGlobal, $Func, $Info;

		for ($i=0; $i<$HomeGlobal->cat_count; $i++){
			if ( $cat_id == $HomeGlobal->cat_data[$i]['cat_id'] ){
				$code_path	= "";
				$HomeGlobal->get_code_path($code_path, $cat_id);
				if ( !empty($cat_navigator) ){
					$cat_navigator	= " &raquo; ". $cat_navigator;
				}
				$cat_navigator	= '<a class="catnav" href="'. $Func->compile_url(array('mod' => MOD_ARTICLE, 'cat' => $code_path)) .'">'. $HomeGlobal->cat_data[$i]['cat_name'] .'</a>' . $cat_navigator;
				
				if ( $HomeGlobal->cat_data[$i]['cat_parent_id'] ){
					$this->get_cat_navigator($cat_navigator, $HomeGlobal->cat_data[$i]['cat_parent_id']);
				}
				break;
			}
		}
	}

	function view_article($article_id, $page_order){
		global $DB, $Func, $Info, $Template, $HomeGlobal, $Lang;

		$highlight	= htmlspecialchars(urldecode($Func->get_request('highlight', '', 'GET')));
		$match		= htmlspecialchars($Func->get_request('match', '', 'GET'));

		$code	= isset($_POST['code']) ? htmlspecialchars($_POST['code']) : '';
		$Template->set_vars(array(
			'JS_RATING_MESSAGE'	=> '',
		));
		if ( $code == 'rate_article' ){
			$this->update_rating();
		}

		$date_format		= $Info->option['full_date_time_format'];
		$timezone			= $Info->option['timezone'] * 3600;
		$Info->tpl_main		= "article_view";

		//Check disabled categories
		if ( in_array($HomeGlobal->cat_id, $HomeGlobal->disabled_cats) ){
			$Template->page_transfer($Lang->data['article_error_cat_not_exist'], $Func->compile_url(""));
			die();
		}

		//Check if category exist
		$DB->query('SELECT cat_id, cat_name, cat_template, cat_keywords, cat_desc FROM '. $DB->prefix .'article_category WHERE cat_id='. $HomeGlobal->cat_id);
		if ( !$DB->num_rows() ){
			$Template->page_transfer($Lang->data['article_error_cat_not_exist'], $Func->compile_url(""));
			die();
		}
		$cat_info	= $DB->fetch_array();

		$cat_navigator	= "";
		$this->get_cat_navigator($cat_navigator, $cat_info['cat_id']);

		//Get article info
		$where_sql		= sizeof($HomeGlobal->disabled_cats) ? " AND A.cat_id NOT IN (". implode(",", $HomeGlobal->disabled_cats) .")" : "";
		if ( $page_order ){
			$DB->query('SELECT A.article_id, A.cat_id, A.topic_id, A.meta_keywords, A.meta_desc, A.title, A.posted_date, A.page_counter, A.rating_marks, A.rating_count, P.page_id, P.page_order, P.page_title FROM '. $DB->prefix .'article AS A, '. $DB->prefix .'article_page AS P WHERE A.enabled='. SYS_ENABLED .' AND archived='. SYS_UNARCHIVED .' AND P.page_enabled='. SYS_ENABLED . $where_sql .' AND A.article_id='. $article_id .' AND P.article_id='. $article_id .' AND P.page_order='. $page_order);
		}
		else{
			$DB->query('SELECT A.article_id, A.cat_id, A.topic_id, A.meta_keywords, A.meta_desc, A.title, A.posted_date, A.page_counter, A.rating_marks, A.rating_count, P.page_id, P.page_order, P.page_title FROM '. $DB->prefix .'article AS A, '. $DB->prefix .'article_page AS P WHERE A.enabled='. SYS_ENABLED .' AND archived='. SYS_UNARCHIVED .' AND P.page_enabled='. SYS_ENABLED . $where_sql .' AND A.article_id='. $article_id .' AND P.article_id='. $article_id .' ORDER BY P.page_order ASC LIMIT 0,1');
		}
		if ( !$DB->num_rows() ){
			$this->list_articles();
			return false;
		}
		$article_info	= $DB->fetch_array();

		//Get article content
		$DB->query('SELECT content_detail, author FROM '. $DB->prefix .'article_page_content WHERE page_id='. $article_info['page_id']);
		if ( $DB->num_rows() ){
			$tmp_info	= $DB->fetch_array();
			$article_info['content_detail']	= $tmp_info['content_detail'];
			$article_info['author']			= $tmp_info['author'];
		}
		else{
			$article_info['content_detail']	= "";
			$article_info['author']			= "";
		}

		//Count comments --------------
		$DB->query('SELECT count(comment_id) AS total FROM '. $DB->prefix .'article_comment WHERE enabled='. SYS_ENABLED .' AND article_id='. $article_id);
		if ( $DB->num_rows() ){
			$tmp_info	= $DB->fetch_array();
			$comment_counter	= $tmp_info['total'];
		}
		else{
			$comment_counter	= 0;
		}
		//-----------------------------

		$Info->tpl_main	= DIR_CAT . $cat_info['cat_template'] . "/". $Info->tpl_main;
		$code_path	= "";
		$HomeGlobal->get_code_path($code_path, $cat_info['cat_id']);
		$u_tellfriend_referer	= $Info->option['site_url'] . $Func->compile_url(array('mod' => MOD_ARTICLE, 'cat' => $code_path, 'article' => $article_info['article_id']));
		$u_tellfriend_referer	= str_replace('/', '@@', $u_tellfriend_referer); //Replace special letter
		$Template->set_vars(array(
			'U_PAGE_ORDER'			=> $Info->option['site_url'] . $Func->compile_url(array('mod' => MOD_ARTICLE, 'cat' => $code_path, 'article' => $article_info['article_id'], 'page_order' => $article_info['page_order'])),
			'BROWSER_NAVIGATOR'		=> ' - '. strip_tags(html_entity_decode($article_info['title'])),
			'META_KEYWORDS'			=> !empty($article_info['meta_keywords']) ? $article_info['meta_keywords'] : (!empty($cat_info['cat_keywords']) ? $cat_info['cat_keywords'] : $Info->option['site_keywords']),
			'META_DESC'				=> !empty($article_info['meta_desc']) ? $article_info['meta_desc'] : (!empty($cat_info['cat_desc']) ? $cat_info['cat_desc'] : $Info->option['site_desc']),
			'COMMENT_COUNTER'		=> $comment_counter,
			'CAT_TEMPLATE'			=> $cat_info['cat_template'],
			'CAT_NAVIGATOR'			=> $cat_navigator,
			'ARTICLE_TITLE'			=> $Func->highlight_text(html_entity_decode($article_info['page_title']), $highlight, $match),
//			'PAGE_TITLE'			=> $article_info['page_title'],
			'ARTICLE_DATE'			=> $Func->translate_date(gmdate($date_format, $article_info['posted_date'] + $timezone)),
			'ARTICLE_CONTENT'		=> $Func->highlight_text(html_entity_decode($article_info['content_detail']), $highlight, $match),
			'GMT'					=> ($Info->option['timezone'] > 0) ? 'GMT+'. $Info->option['timezone'] : (($Info->option['timezone'] < 0) ? 'GMT'. $Info->option['timezone'] : 'GMT'),
			'ARTICLE_AUTHOR'		=> $article_info['author'],
			'U_COMMENT'				=> $Func->compile_url(array('mod' => 'comment', 'article' => $article_info['article_id'])),
			'U_PRINT'				=> $Func->compile_url(array('mod' => MOD_ARTICLE, 'cat' => $code_path, 'article' => $article_info['article_id'], 'page_order' => $article_info['page_order'], 'act' => 'print')),
			'U_TELLFRIEND'			=> $Info->option['site_url'] . $Func->compile_url(array('mod' => MOD_TELLFRIEND, 'u_referer' => urlencode($u_tellfriend_referer))),
			'L_RELATED_ARTICLES'	=> $Lang->data['article_related'],
			'L_NEXT_ARTICLES'		=> $Lang->data['article_next'],
			'L_COMMENTS'			=> $Lang->data['comments'],
			'L_PRINT'				=> $Lang->data['general_print'],
			'L_TELLFRIEND'			=> $Lang->data['general_tellfriend'],
			'L_PAGE_PREV'			=> $Lang->data['general_page_prev'],
			'L_PAGE_NEXT'			=> $Lang->data['general_page_next'],
			'L_GO'					=> $Lang->data['general_go'],
		));

		//Get all pages ---------
		if ( $article_info['page_counter'] > 1 ){
			$DB->query('SELECT page_title, page_order FROM '. $DB->prefix .'article_page WHERE article_id='. $article_id .' AND page_enabled='. SYS_ENABLED .' ORDER BY page_order ASC');
			$page_count	= $DB->num_rows();
			$page_data	= $DB->fetch_all_array();
			$DB->free_result();

			if ( $page_count > 1 ){
				$p_order	= -1;
				for ($i=0; $i<$page_count; $i++){
					$Template->set_block_vars("pagerow", array(
						'U_VIEW'	=> $Info->option['site_url'] . $Func->compile_url(array('mod' => MOD_ARTICLE, 'cat' => $code_path, 'article' => $article_info['article_id'], 'page_order' => $page_data[$i]['page_order'])),
						'TITLE'		=> strip_tags(html_entity_decode($page_data[$i]['page_title'])),
					));
					if ( $article_info['page_order'] == $page_data[$i]['page_order'] ){
						$p_order	= $i;
					}
				}

				if ( $p_order != -1 ){
					$Template->set_vars(array(
						'U_PREV_PAGE'	=> ($p_order > 0) ? $Info->option['site_url'] . $Func->compile_url(array('mod' => MOD_ARTICLE, 'cat' => $code_path, 'article' => $article_info['article_id'], 'page_order' => $page_data[$p_order - 1]['page_order'])) : $Info->option['site_url'] . $Func->compile_url(array('mod' => MOD_ARTICLE, 'cat' => $code_path, 'article' => $article_info['article_id'], 'page_order' => $page_data[$p_order]['page_order'])) .'#',
						'U_NEXT_PAGE'	=> ($p_order < $page_count - 1) ? $Info->option['site_url'] . $Func->compile_url(array('mod' => MOD_ARTICLE, 'cat' => $code_path, 'article' => $article_info['article_id'], 'page_order' => $page_data[$p_order + 1]['page_order'])) : $Info->option['site_url'] . $Func->compile_url(array('mod' => MOD_ARTICLE, 'cat' => $code_path, 'article' => $article_info['article_id'], 'page_order' => $page_data[$p_order]['page_order'])) .'#',
					));
					if ( $p_order > 0 ){
						$Template->set_block_vars("prevpage");
					}
					if ( $p_order < $page_count - 1 ){
						$Template->set_block_vars("nextpage");
					}
				}
			}
		}
		//------------------------

		//Get related articles ---
		$where_sql		= sizeof($HomeGlobal->disabled_cats) ? " AND cat_id NOT IN (". implode(",", $HomeGlobal->disabled_cats) .")" : "";
		if ( $article_info['topic_id'] ){
			$DB->query('SELECT article_id, cat_id, title, article_type FROM '. $DB->prefix .'article WHERE enabled='. SYS_ENABLED . $where_sql .' AND topic_id='. $article_info['topic_id'] .' AND posted_date<'. CURRENT_TIME .' AND article_type!='. SYS_ARTICLE_SUMMARY .' AND article_id!='. $article_info['article_id'] .' ORDER BY posted_date DESC');
			$article_count	= $DB->num_rows();
			$article_data	= $DB->fetch_all_array();
			$DB->free_result();

			for ($i=0; $i<$article_count; $i++){
				$code_path	= "";
				$HomeGlobal->get_code_path($code_path, $article_data[$i]['cat_id']);
				$u_view		= $Func->compile_url(array('mod' => MOD_ARTICLE, 'cat' => $code_path, 'article' => $article_data[$i]['article_id']));
				$Template->set_block_vars("relatedrow", array(
					'TITLE'			=> $Func->make_article_link(strip_tags(html_entity_decode($article_data[$i]['title'])), $article_data[$i]['article_type'], $u_view, 'hottitle'),
//					'U_VIEW'		=> $u_view,
				));
			}
		}
		//---------------------------

		//Get next articles ---------
		$DB->query('SELECT article_id, cat_id, title, posted_date, article_type FROM '. $DB->prefix .'article WHERE enabled='. SYS_ENABLED . $where_sql .' AND cat_id='. $article_info['cat_id'] .' AND posted_date<'. $article_info['posted_date'] .' AND article_type!='. SYS_ARTICLE_SUMMARY .' ORDER BY posted_date DESC LIMIT 0,'. $Info->option['limit_home_news_next']);
		$article_count	= $DB->num_rows();
		$article_data	= $DB->fetch_all_array();

		for ($i=0; $i<$article_count; $i++){
			$code_path	= "";
			$HomeGlobal->get_code_path($code_path, $article_data[$i]['cat_id']);
			$u_view		= $Func->compile_url(array('mod' => MOD_ARTICLE, 'cat' => $code_path, 'article' => $article_data[$i]['article_id']));
			$Template->set_block_vars("nextrow", array(
				'DATE'			=> $Func->translate_date(gmdate($Info->option['date_format'], $article_data[$i]['posted_date'] + $timezone)),
				'TITLE'			=> $Func->make_article_link(strip_tags(html_entity_decode($article_data[$i]['title'])), $article_data[$i]['article_type'], $u_view, 'ntitle'),
//				'U_VIEW'		=> $u_view,
			));
		}
		//---------------------------

		//Rating
		if ( $Info->option['rating_enabled'] ){
			$Template->set_block_vars("ratingon");
			$this->show_rating_results($article_info);
		}

		if ( $Info->option['comment_enabled'] ){
			$Template->set_block_vars("commenton");
		}
		return true;
	}

	function update_rating(){
		global $DB, $Info, $Cache, $Template, $Lang;

		$article_id	= isset($_POST['article_id']) ? intval($_POST['article_id']) : 0;
		$number		= isset($_POST['number']) ? intval($_POST['number']) : 0;
		if ( !$article_id || ($number < 1) || ($number > 5) ){
			return false;
		}

		//Get article info
		$DB->query('SELECT rating_marks, rating_count FROM '. $DB->prefix .'article WHERE enabled='. SYS_ENABLED .' AND article_id='. $article_id);
		if ( !$DB->num_rows() ){
			return false;
		}
		$article_info	= $DB->fetch_array();

		//Don't allow one client votes two times
		if ( !$this->check_ip($article_id) ){
			$Template->set_vars(array(
				'JS_RATING_MESSAGE'		=> 'alert("'. $Lang->data['rating_error'] .'");',
			));
			return false;
		}

		//Clear all cached files
		$Cache->clear_cache('all', 'html');

		//Update rating
		$DB->query('UPDATE '. $DB->prefix .'article SET rating_marks=rating_marks+'. $number .', rating_count=rating_count+1 WHERE article_id='. $article_id);

		$Template->set_vars(array(
			'JS_RATING_MESSAGE'		=> 'alert("'. $Lang->data['rating_success'] .'");',
		));
		return true;
	}

	function check_ip($article_id){
		global $Info, $DB, $Func;

		$rerating_time	= CURRENT_TIME - 3600; //3600s == 1 hour
		$DB->query("SELECT client_ip FROM ". $DB->prefix ."contact_ip WHERE contact_note LIKE 'article_rating:". $article_id ."' AND client_ip='". $Info->client_ip ."' AND contact_time>=". $rerating_time);
		if ( $DB->num_rows() ){
			return false;
		}

		//Delete expired records
		$DB->query("DELETE FROM ". $DB->prefix ."contact_ip WHERE contact_time<". (CURRENT_TIME - 86400));
		//Insert new record
		$DB->query("INSERT INTO ". $DB->prefix ."contact_ip(client_ip, contact_time, contact_note) VALUES('". $Info->client_ip ."', ". CURRENT_TIME .", 'article_rating:". $article_id ."')");
		return true;
	}

	function show_rating_results($article_info){
		global $DB, $Func, $Info, $Template, $HomeGlobal, $Lang;

		if ( $article_info['rating_count'] > 0 ){
			//We double rating marks in order to convert it from limitation 5 to 10
			$rating_average	= round((2*$article_info['rating_marks']) / $article_info['rating_count']);
			$rating_average	= $rating_average / 2; //Reconvert to limitation 5
		}
		else{
			$rating_average	= 0;
		}

		$rating_stars	= '';
		for ($i=1; $i<=5; $i++){
			$imgstyle	= ' style="cursor: pointer;" onClick="javascript: rating_update('. $i .');" onMouseOver="javascript: rating_on('. $i .');" onMouseOut="javascript: rating_off('. $i .');"';
			if ( $rating_average >= $i ){
				$rating_stars	.= '<img id="ImgRating_'. $i .'" src="'. $Info->option['template_path'] .'/images/rating_1.gif" border="0" vspace="2" hspace="0" title="'. $Lang->data['rating_'. $i .'_desc'] .'" '. $imgstyle .'>';
			}
			else if ( $rating_average >= ($i - 0.5) ){
				$rating_stars	.= '<img id="ImgRating_'. $i .'" src="'. $Info->option['template_path'] .'/images/rating_0.5.gif" border="0" vspace="2" hspace="0" title="'. $Lang->data['rating_'. $i .'_desc'] .'" '. $imgstyle .'>';
			}
			else{
				$rating_stars	.= '<img id="ImgRating_'. $i .'" src="'. $Info->option['template_path'] .'/images/rating_0.gif" border="0" vspace="2" hspace="0" title="'. $Lang->data['rating_'. $i .'_desc'] .'" '. $imgstyle .'>';
			}
		}

		$Template->set_vars(array(
			'ARTICLE_ID'			=> $article_info['article_id'],
			'RATING_STARS'			=> $rating_stars,
			'RATING_AVERAGE'		=> ($article_info['rating_count'] > 1) ? ' . '. $Lang->data['rating_average'] .': '. $rating_average .'/5' : '',
			'RATING_VOTES'			=> $Lang->data['rating_votes'] .': '. $article_info['rating_count'],
			'L_RATING'				=> $Lang->data['rating'],
			'L_RATING_UPDATE'		=> $Lang->data['rating_update'],
		));
	}

	function print_article($article_id, $page_order){
		global $DB, $Func, $Info, $Template, $HomeGlobal, $Lang;

		$Info->tpl_main		= "article_print";
		$date_format		= $Info->option['full_date_time_format'];
		$timezone			= $Info->option['timezone'] * 3600;

		//Check disabled categories
		if ( in_array($HomeGlobal->cat_id, $HomeGlobal->disabled_cats) ){
			$Template->page_transfer($Lang->data['article_error_cat_not_exist'], $Func->compile_url(""));
			die();
		}

		//Check if category exist
		$DB->query('SELECT cat_id, cat_name, cat_template, cat_keywords, cat_desc FROM '. $DB->prefix .'article_category WHERE cat_id='. $HomeGlobal->cat_id);
		if ( !$DB->num_rows() ){
			$Template->page_transfer($Lang->data['article_error_cat_not_exist'], $Func->compile_url(""));
			die();
		}
		$cat_info	= $DB->fetch_array();

		$cat_navigator	= "";
		$this->get_cat_navigator($cat_navigator, $cat_info['cat_id']);

		//Get article info
		$where_sql		= sizeof($HomeGlobal->disabled_cats) ? " AND A.cat_id NOT IN (". implode(",", $HomeGlobal->disabled_cats) .")" : "";
		if ( $page_order ){
			$DB->query('SELECT A.article_id, A.cat_id, A.topic_id, A.title, A.posted_date, P.page_id, P.page_order, P.page_title FROM '. $DB->prefix .'article AS A, '. $DB->prefix .'article_page AS P WHERE A.enabled='. SYS_ENABLED .' AND P.page_enabled='. SYS_ENABLED . $where_sql .' AND A.article_id='. $article_id .' AND P.article_id='. $article_id .' AND P.page_order='. $page_order);
		}
		else{
			$DB->query('SELECT A.article_id, A.cat_id, A.topic_id, A.title, A.posted_date, P.page_id, P.page_order, P.page_title FROM '. $DB->prefix .'article AS A, '. $DB->prefix .'article_page AS P WHERE A.enabled='. SYS_ENABLED .' AND P.page_enabled='. SYS_ENABLED . $where_sql .' AND A.article_id='. $article_id .' AND P.article_id='. $article_id .' ORDER BY P.page_order ASC LIMIT 0,1');
		}
		if ( !$DB->num_rows() ){
			$this->list_articles();
			return false;
		}
		$article_info	= $DB->fetch_array();

		//Get article content
		$DB->query('SELECT content_detail, author FROM '. $DB->prefix .'article_page_content WHERE page_id='. $article_info['page_id']);
		if ( $DB->num_rows() ){
			$tmp_info	= $DB->fetch_array();
			$article_info['content_detail']	= $tmp_info['content_detail'];
			$article_info['author']			= $tmp_info['author'];
		}
		else{
			$article_info['content_detail']	= "";
			$article_info['author']			= "";
		}

		$Info->tpl_header	= "";
		$Info->tpl_footer	= "";
		$Info->tpl_main		= DIR_CAT . $cat_info['cat_template'] . "/". $Info->tpl_main;

		$code_path	= "";
		$HomeGlobal->get_code_path($code_path, $cat_info['cat_id']);
		$Template->set_vars(array(
			'CAT_TEMPLATE'			=> $cat_info['cat_template'],
			'CAT_NAVIGATOR'			=> $cat_navigator,
			'ARTICLE_TITLE'			=> html_entity_decode($article_info['page_title']),
//			'PAGE_TITLE'			=> $article_info['page_title'],
			'ARTICLE_DATE'			=> $Func->translate_date(gmdate($date_format, $article_info['posted_date'] + $timezone)),
			'ARTICLE_CONTENT'		=> html_entity_decode($article_info['content_detail']),
			'GMT'					=> ($Info->option['timezone'] != 0) ? 'GMT'. $Info->option['timezone'] : 'GMT',
			'ARTICLE_AUTHOR'		=> $article_info['author'],
		));

		//Get all pages ---------
		$DB->query('SELECT page_title, page_order FROM '. $DB->prefix .'article_page WHERE article_id='. $article_id .' AND page_enabled='. SYS_ENABLED .' ORDER BY page_order ASC');
		$page_count	= $DB->num_rows();
		$page_data	= $DB->fetch_all_array();
		$DB->free_result();

		if ( $page_count > 1 ){
			for ($i=0; $i<$page_count; $i++){
				$Template->set_block_vars("pagerow", array(
					'TITLE'		=> strip_tags(html_entity_decode($page_data[$i]['page_title'])),
				));
			}
		}
		//------------------------
		return true;
	}
}
?>