<?php
/* =============================================================== *\
|		Module name:      Comment									|
|																	|
\* =============================================================== */

if (!defined('IN_SITE')){
     die('Hacking attempt!');
}
define('DIR_CAT', 'category/');
//Module language
$Func->import_module_language("home/lang_article". PHP_EX);

//Call global functions --------------
$HomeGlobal->cat_menu();
$HomeGlobal->show_poll();
$HomeGlobal->show_logos();
$HomeGlobal->show_events();
$HomeGlobal->show_news_picture();
$HomeGlobal->show_global_hotarticles();
$HomeGlobal->show_latest_box();
//------------------------------------

if ( !$Info->option['comment_enabled'] ){
	$Template->fast_transfer($Info->option['site_url']);
	die();
}

$Comment = new Comment;

class Comment
{
	var $article_id		= 0;
	var $page			= 1;
	var $data			= array();

	function Comment(){
		global $HomeGlobal, $Func, $Template, $Lang;

		//Get article id
		$this->article_id	= intval($Func->get_vars('article', 1));
		$this->page			= intval($Func->get_vars('page', 2));

		$Template->set_vars(array(
			'BROWSER_NAVIGATOR'	=> ' - '. $Lang->data['comments'],
		));

		$flag	= isset($_POST['flag']) ? htmlspecialchars($_POST['flag']) : '';
		if ( $flag == 'post' ){
			$this->post_comment();
		}
		else{
			$this->list_comments();
		}
	}

	function list_comments($msg = ""){
		global $DB, $Lang, $Template, $Info, $Func, $HomeGlobal;

		$Info->tpl_main		= "comment_list";
		$date_format		= $Info->option['time_format'];
		$timezone			= $Info->option['timezone'] * 3600;
		$itemperpage		= $Info->option['limit_home_comment'];
		$Func->make_image_number();

		//Get article info
		$where_sql		= sizeof($HomeGlobal->disabled_cats) ? " AND cat_id NOT IN (". implode(",", $HomeGlobal->disabled_cats) .")" : "";
		$DB->query('SELECT * FROM '. $DB->prefix .'article WHERE article_id='. $this->article_id .' AND enabled='. SYS_ENABLED. $where_sql);
		if ( !$DB->num_rows() ){
			$Template->page_transfer($Lang->data['article_error_not_exist'], $Func->compile_url(""));
			die();
		}
		$article_info	= $DB->fetch_array();

		//Get cat info
		$DB->query('SELECT * FROM '. $DB->prefix .'article_category WHERE cat_id='. $article_info['cat_id']);
		if ( !$DB->num_rows() ){
			$Template->page_transfer($Lang->data['article_error_cat_not_exist'], $Func->compile_url(""));
			die();
		}
		$cat_info	= $DB->fetch_array();

		$code_path	= $cat_info['cat_code'];
		if ( $cat_info['cat_parent_id'] && $Info->option['short_url_enabled'] ){
			$HomeGlobal->get_code_path($code_path, $cat_info['cat_parent_id']);
		}

		//Generate pages
		$DB->query("SELECT count(comment_id) AS total FROM ". $DB->prefix ."article_comment WHERE article_id=". $this->article_id ." AND enabled=". SYS_ENABLED);
		if ( $DB->num_rows() ){
			$result		= $DB->fetch_array();
			$pageshow	= $Func->virtual_pagination($result['total'], $itemperpage, $this->page, '<strong>'. $Lang->data['general_page'] .'</strong>', $Func->compile_url(array("mod" => "comment", 'article' => $this->article_id)));
		}
		else{
			$pageshow['page']	= "";
			$pageshow['start']	= 0;
		}
		$DB->free_result();

		//Get comments
		$DB->query('SELECT * FROM '. $DB->prefix .'article_comment WHERE article_id='. $this->article_id .' AND enabled='. SYS_ENABLED .' ORDER BY posted_date DESC LIMIT '. $pageshow['start'] .','. $itemperpage);
		$comment_count	= $DB->num_rows();
		$comment_data	= $DB->fetch_all_array();
		$DB->free_result();

		for ($i=0; $i<$comment_count; $i++){
			$Template->set_block_vars("commentrow", array(
				'DATE'		=> $Func->translate_date(gmdate($date_format, $comment_data[$i]['posted_date'] + $timezone)),
				'TITLE'		=> $comment_data[$i]['title'],
				'CONTENT'	=> nl2br($comment_data[$i]['content']),
				'NAME'		=> $comment_data[$i]['name'],
				'EMAIL'		=> $comment_data[$i]['email'],
			));
		}

		$Info->tpl_main	= DIR_CAT . $cat_info['cat_template'] . "/". $Info->tpl_main;
		$Template->set_vars(array(
			"ERROR_MSG"			=> $msg,
			'PAGE_OUT'			=> $pageshow['page'],
			'ARTICLE_TITLE'		=> strip_tags(html_entity_decode($article_info['title'])),
			'U_VIEW_ARTICLE'	=> $Func->compile_url(array('mod' => MOD_ARTICLE, 'cat' => $code_path, 'article' => $this->article_id)),
			'CM_NAME'			=> isset($this->data['name']) ? stripslashes($this->data['name']) : '',
			'CM_EMAIL'			=> isset($this->data['email']) ? stripslashes($this->data['email']) : '',
			'CM_TITLE'			=> isset($this->data['title']) ? stripslashes($this->data['title']) : '',
			'CM_CONTENT'		=> isset($this->data['content']) ? stripslashes($this->data['content']) : '',
			'S_COMMENT_ACTION'	=> $Func->compile_url(array('mod' => 'comment', 'article' => $this->article_id)) .'#comment',
			'L_COMMENT'			=> $Lang->data['comments'],
			'L_COMMENT_NEW'		=> $Lang->data['comment_new'],
			'L_NAME'			=> $Lang->data['comment_name'],
			'L_EMAIL'			=> $Lang->data['comment_email'],
			'L_TITLE'			=> $Lang->data['comment_title'],
			'L_CONTENT'			=> $Lang->data['comment_content'],
			'L_COMMENT_SUBMIT'	=> $Lang->data['comment_submit'],
			'L_ERROR_NOT_FULL'	=> $Lang->data['general_error_not_full'],
		));
	}

	function post_comment(){
		global $Lang, $DB, $Template, $Info, $Func, $REMOTE_ADDR, $Cache;

		$this->data['name']		= isset($_POST['name']) ? htmlspecialchars($_POST['name']) : '';
		$this->data['email']	= isset($_POST['email']) ? htmlspecialchars($_POST['email']) : '';
		$this->data['ip']		= !empty($_SERVER['HTTP_X_FORWARDED_FOR']) ? $_SERVER['HTTP_X_FORWARDED_FOR'] : ( !empty($_SERVER['REMOTE_ADDR']) ? $_SERVER['REMOTE_ADDR'] : (!empty($REMOTE_ADDR) ? $REMOTE_ADDR : '' ));
		$this->data['title']	= isset($_POST['title']) ? htmlspecialchars($_POST['title']) : '';
		$this->data['content']	= isset($_POST['content']) ? htmlspecialchars($_POST['content']) : '';
		$number_id			= isset($_POST["number_id"]) ? htmlspecialchars($_POST["number_id"]) : '';
		$number_value		= isset($_POST["number_value"]) ? intval($_POST["number_value"]) : 0;

		if ( empty($this->data['name']) || empty($this->data['email']) || empty($this->data['title']) || empty($this->data['content']) ){
			$this->list_comments($Lang->data['general_error_not_full']);
			return false;
		}

		if ( !$Func->check_email($this->data['email']) ){
			$this->list_comments($Lang->data['general_error_email']);
			return false;
		}

		//Check number ---------------
		if ( empty($number_id) || !$number_value ){
			$this->list_comments($Lang->data['general_error_login_number']);
			return false;
		}

		$DB->query("SELECT * FROM ". $DB->prefix ."number WHERE num_id='". $number_id ."'");
		if ( !$DB->num_rows() ){
			$this->list_comments($Lang->data["general_error_login_number"]);
			return false;
		}
		$number_info	= $DB->fetch_array();
		if ( $number_value != $number_info['num_value'] ){
			$this->list_comments($Lang->data["general_error_login_number"]);
			return false;
		}
		//Delete login number
		$DB->query("DELETE FROM ". $DB->prefix ."number WHERE num_id='". $number_id ."'");
		//----------------------------

		//Prevent flood -----------------
		$DB->query('SELECT comment_id FROM '. $DB->prefix .'article_comment WHERE article_id='. $this->article_id .' AND ip="'. $this->data['ip'] .'" AND posted_date>='. (CURRENT_TIME - $Info->option['time_recomment']));
		if ( $DB->num_rows() ){
			$this->list_comments($Lang->data['comment_error_flood']);
			return false;
		}
		//-------------------------------

		//Insert new comment
		$sql	= "INSERT INTO ". $DB->prefix ."article_comment(article_id, title, content, name, email, ip, posted_date, enabled)
					VALUES(". $this->article_id .", '". $this->data['title'] ."', '". $this->data['content'] ."', '". $this->data['name'] ."', '". $this->data['email'] ."', '". $this->data['ip'] ."', ". CURRENT_TIME .", 0)";
		$DB->query($sql);

		//Clear all cached files
		$Cache->clear_cache('all', 'html');

		$Template->page_transfer($Lang->data['comment_success_add'], $Func->compile_url(array('mod' => 'comment', 'article' => $this->article_id)), 10);
		return true;
	}
}
?>