<?php
/* =============================================================== *\
|		Module name:      Event										|
|																	|
\* =============================================================== */

if (!defined('IN_SITE')){
     die('Hacking attempt!');
}
//Module language
//$Func->import_module_language("home/lang_event". PHP_EX);

$Event = new Event;

class Event
{
	function Event(){
		global $Func, $Template, $Lang;

		$year	= intval($Func->get_vars('year', 1));
		$month	= intval($Func->get_vars('month', 2));
		$day	= intval($Func->get_vars('day', 3));

		$Template->set_vars(array(
			'BROWSER_NAVIGATOR'	=> ' - '. $Lang->data['general_event'],
		));

		if ( $year && $month && $day ){
			$this->view_event($year, $month, $day);
		}
		else{
			$this->list_events($year, $month);
		}
	}

	function list_events($year, $month){
		global $Lang, $Info, $Template, $DB, $Func, $HomeGlobal;

		//Call global functions --------------
		$HomeGlobal->cat_menu();
		$HomeGlobal->show_poll();
		$HomeGlobal->show_logos();
		$HomeGlobal->show_news_picture();
		$HomeGlobal->show_global_hotarticles();
		$HomeGlobal->show_latest_box();
		//------------------------------------

		$Info->tpl_main		= "event_list";
		$timezone			= $Info->option['timezone']*3600;

		//Monthrow - Display month name with user's language
		$month_info		= explode(',', $Lang->data['general_date_month']);
		for ($i=0; $i<12; $i++){
			$Template->set_block_vars("monthrow", array(
				'NUM'	=> ($i + 1),
				'NAME'	=> trim($month_info[$i])
			));
		}
		//--------------------------------------------------

		if ( ($year < 1) || ($year > 9999) || ($month < 1) || ($month > 12) ){
			//Get current date
			$time		= CURRENT_TIME + $timezone;
			$today		= getdate($time);
			$year		= $today['year'];
			$month		= $today['mon'];
		}
		//Number days in month
		$day_count	= $Func->count_month_days($month, $year);

		//Get event from database -------------------
		$DB->query('SELECT event_day FROM '. $DB->prefix .'event WHERE event_year='. $year .' AND event_month='. $month .' AND enabled='. SYS_ENABLED);
		$event_info	= array();
		if ( $DB->num_rows() ){
			while ($tmp_info = $DB->fetch_array()){
				$event_info[]	= $tmp_info['event_day'];
			}
		}
		$DB->free_result();
		//-------------------------------------------

		//Display all days in month -----------------
		$day_info	= array();
		$first_day	= $Func->get_days_of_week($year, $month);
		for ($i=0; $i<$first_day; $i++){
			$day_info[]	= '&nbsp;';
		}
		for ($i=1; $i<=$day_count; $i++){
			$day_info[]	= $i;
		}

		$i = 0;
		$count	= sizeof($day_info);
		while ($i < $count){
			$Template->set_block_vars("maineventrow");
			for ($j=0; $j<7; $j++){
				if ( $i < $count ){
					$Template->set_block_vars("maineventrow:eventcol", array(
						'DAY'		=> in_array($day_info[$i], $event_info) ? '<a class="haveEvent2" href="#" onclick="javascript: open_window(\''. $Info->option['site_url'] . $Func->compile_url(array('mod' => 'event', 'year' => $year, 'month' => $month, 'day' => $day_info[$i])) .'\', 450, 400); return false;">'. $day_info[$i] .'</a>' : $day_info[$i],
					));
					if ( $day_info[$i] != '&nbsp;'){
						$Template->set_block_vars("maineventrow:eventcol:havecol");
					}
				}
				else{
					$Template->set_block_vars("maineventrow:eventcol", array(
						'DAY'		=> '&nbsp;',
					));
				}
				$i++;
			}
		}
		//-------------------------------------------

		//Get previous and next month, year ---------
		if ( $month == 1 ){
			$prev_month		= 12;
			$prev_year		= $year - 1;
		}
		else{
			$prev_month		= $month - 1;
			$prev_year		= $year;
		}

		if ( $month == 12 ){
			$next_month		= 1;
			$next_year		= $year + 1;
		}
		else{
			$next_month		= $month + 1;
			$next_year		= $year;
		}
		//-------------------------------------------

		$Template->set_vars(array(
//			'CURRENT_MONTH_YEAR'		=> $today['month'] .' '. $today['year'],
			'U_EVENT'					=> $Func->compile_url(array('mod' => 'event')),
			'U_PREV_MONTH'				=> $Func->compile_url(array('mod' => 'event', 'year' => $prev_year, 'month' => $prev_month)),
			'U_NEXT_MONTH'				=> $Func->compile_url(array('mod' => 'event', 'year' => $next_year, 'month' => $next_month)),
			'EVENT_MONTH'				=> $month,
			'EVENT_YEAR'				=> $year,
			"L_PREV_MONTH"				=> $Lang->data["event_prev_month"],
			"L_NEXT_MONTH"				=> $Lang->data["event_next_month"],
			"L_EVENT"					=> $Lang->data["event"],
			"L_MONDAY"					=> $Lang->data["event_monday_full"],
			"L_TUESDAY"					=> $Lang->data["event_tuesday_full"],
			"L_WEDNESDAY"				=> $Lang->data["event_wednesday_full"],
			"L_THURDAY"					=> $Lang->data["event_thurday_full"],
			"L_FRIDAY"					=> $Lang->data["event_friday_full"],
			"L_SATURDAY"				=> $Lang->data["event_saturday_full"],
			"L_SUNDAY"					=> $Lang->data["event_sunday_full"],
		));
	}

	function view_event($year, $month, $day){
		global $DB, $Info, $Lang, $Template, $Func;

		if ( !$Func->check_anydate($month, $day, $year) ){
			$this->list_events();
			return false;
		}
//		$today		= getdate(mktime(12, 0, 0, $month, $day, $year));

		$Info->tpl_main		= "event_view";
		$Info->tpl_header	= "";
		$Info->tpl_footer	= "";

		$DB->query('SELECT * FROM '. $DB->prefix .'event WHERE event_year='. $year .' AND event_month='. $month .' AND event_day='. $day .' AND enabled='. SYS_ENABLED .' ORDER BY event_from_hour, event_from_minute ASC');
		$event_count	= $DB->num_rows();
		$event_data		= $DB->fetch_all_array();
		$DB->free_result();

		for ($i=0; $i<$event_count; $i++){
			$hour		= "";
			if ( $event_data[$i]['event_from_hour'] >= 0 ){
				$from_hour		= "";
				$to_hour		= "";
				//From hour
				$from_hour		= $event_data[$i]['event_from_hour'] .'h';
				if ( $event_data[$i]['event_from_minute'] > 0 ){
					$from_hour	.= $event_data[$i]['event_from_minute'];
				}
				else if ( $event_data[$i]['event_from_minute'] == 0 ){
					$from_hour	.= '00';
				}

				//To hour
				if ( $event_data[$i]['event_to_hour'] >= 0 ){
					$to_hour	= ' - '. $event_data[$i]['event_to_hour'] .'h';
					if ( $event_data[$i]['event_to_minute'] > 0 ){
						$to_hour	.= $event_data[$i]['event_to_minute'];
					}
					else if ( $event_data[$i]['event_to_minute'] > 0 ){
						$to_hour	.= '00';
					}
				}
				$hour	= $from_hour . $to_hour .':';
			}
			$Template->set_block_vars("eventrow", array(
				'HOUR'				=> $hour,
				'TITLE'				=> $event_data[$i]['title'],
				'DETAIL'			=> html_entity_decode($event_data[$i]['detail']),
				'HR'				=> ($i < $event_count - 1) ? '<hr class="myhr" size="1">' : '&nbsp;',
			));
		}

		if ( $day < 10 ){
			$day	= '0'. $day;
		}
		$Template->set_vars(array(
			'L_EVENT'		=> $Lang->data['event'],
			'L_CLOSE'		=> $Lang->data['general_close'],
			'EVENT_DATE'	=> $day .' '. $Func->convert_month($month) .' '. $year,
		));
		return true;
	}
}

?>