<?php
/* =============================================================== *\
|		Module name:      Global									|
|																	|
\* =============================================================== */

if (!defined('IN_SITE')){
     die('Hacking attempt!');
}
//Module languages
$Func->import_module_language("home/lang_poll". PHP_EX);
$Func->import_module_language("home/lang_newsletter". PHP_EX);
$Func->import_module_language("home/lang_event". PHP_EX);

include("modules/newsletter_global". PHP_EX);

$HomeGlobal	= new Home_Global;

class Home_Global
{
	var	$cat_id					= 0;
	var	$cat_pos_var			= 0;
	var $cat_count				= 0;
	var $cat_data				= array();
	var $cat_flag				= array();
	var $disabled_cats			= array();

	function Home_Global(){
		global $Func;

		$this->set_global();
		$this->update_statistic();
		$Func->show_template_dirs();
	}

	function set_global(){
		global $Info, $Template, $Lang, $Func;

		if ($Info->option['timezone'] > 0){
			$gmt	= ' (GMT+'. $Info->option['timezone'] .')';
		}
		else if ($Info->option['timezone'] < 0){
			$gmt	= ' (GMT'. $Info->option['timezone'] .')';
		}
		else{
			$gmt	= ' (GMT)';
		}

		$Template->set_vars(array(
			'U_HOME'					=> $Func->compile_url(""),
			'S_NEWSLETTER'				=> $Func->compile_url(array('mod' => MOD_NEWSLETTER, 'act' => 'subscribe')),
			'S_TEMPLATE_UPDATE'			=> $Func->compile_url(array('mod' => MOD_UPDATE, 'act' => 'template')),
			'S_ARTICLE_SEARCH'			=> $Func->compile_url(array('mod' => MOD_SEARCH)),
			'U_ADVANCE_SEARCH'			=> $Func->compile_url(array('mod' => MOD_SEARCH, 'act' => 'advance')),
			'U_FAQ'						=> $Func->compile_url(array('mod' => MOD_FAQ)),
			'U_WEBLINK'					=> $Func->compile_url(array('mod' => MOD_WEBLINK)),
			'U_RSS'						=> $Func->compile_url(array('mod' => MOD_RSS)),
			'U_SITEMAP'					=> $Func->compile_url(array('mod' => MOD_SITEMAP)),
			'U_CONTACT'					=> $Func->compile_url(array('mod' => MOD_CONTACT)),
//			'U_ABOUT'					=> $Func->compile_url(array('mod' => MOD_ABOUT)),
			'U_NEWS_PICTURE'			=> $Func->compile_url(array('mod' => MOD_PICTURE)),
			'U_ALL_NEWS'				=> $Func->compile_url(array('mod' => MOD_ARTICLE)),
			'U_ARCHIVE'					=> $Func->compile_url(array('mod' => MOD_ARCHIVE)),
			'GLOBAL_TEMPLATE_ID'		=> $Info->option['template'],
			'ARTICLE_HOT'				=> SYS_ARTICLE_HOT,
			"SCRIPT_NAME"				=> $Info->option['script_name'],
			"SITE_NAME"					=> $Info->option['site_name'],
			"SITE_SLOGAN"				=> $Info->option['site_slogan'],
			"SITE_URL"					=> $Info->option['site_url'],
			"META_KEYWORDS"				=> $Info->option['site_keywords'],
			"META_DESC"					=> $Info->option['site_desc'],
			"BROWSER_NAVIGATOR"			=> '',
			"SEARCH_KEYWORD"			=> '',
			'TODAY_DATE_TIME'			=> $Func->translate_date(gmdate($Info->option['full_date_time_format'], CURRENT_TIME + $Info->option['timezone']*3600)) . $gmt,
			'L_CHARSET'					=> $Lang->charset,
			"L_FAVORITE_ADD"			=> $Lang->data["general_favorite_add"],
			"L_BUTTON_GO"				=> $Lang->data["button_go"],
			"L_ERROR_EMAIL"				=> $Lang->data["newslt_error_email"],
			"L_NEWS_PICTURE"			=> $Lang->data["newspic"],
			"L_POLL"					=> $Lang->data["poll"],
			"L_POLL"					=> $Lang->data["poll"],
			"L_POLL_HIT"				=> $Lang->data["poll_hit"],
			"L_POLL_RESULT"				=> $Lang->data["poll_result"],
			"L_LOGO"					=> $Lang->data["logo"],
			"L_HOME"					=> $Lang->data["general_home"],
			"L_ALL_NEWS"				=> $Lang->data["general_all_news"],
			"L_ARCHIVE"					=> $Lang->data["general_archive"],
			"L_SEARCH"					=> $Lang->data["search"],
			"L_ADVANCE_SEARCH"			=> $Lang->data["search_advance"],
			"L_SEARCH_KEYWORD"			=> $Lang->data["search_keyword"],
			"L_SEARCH_DAY"				=> $Lang->data["search_day"],
			"L_SEARCH_MONTH"			=> $Lang->data["search_month"],
			"L_SEARCH_YEAR"				=> $Lang->data["search_year"],
			"L_FAQ"						=> $Lang->data["general_faq"],
			"L_WEBLINK"					=> $Lang->data["general_weblink"],
			"L_RSS"						=> $Lang->data["general_rss"],
			"L_SITEMAP"					=> $Lang->data["general_sitemap"],
			"L_ABOUT"					=> $Lang->data["general_about"],
			"L_CONTACT"					=> $Lang->data["general_contact"],
			"L_NEWSLETTER"				=> $Lang->data["newslt"],
			"L_YOUR_NAME"				=> $Lang->data["newslt_name"],
			"L_YOUR_EMAIL"				=> $Lang->data["newslt_email"],
			"L_SUBSCRIBE"				=> $Lang->data["newslt_subscribe"],
			"L_UNSUBSCRIBE"				=> $Lang->data["newslt_unsubscribe"],
			"L_SUBMIT"					=> $Lang->data["button_submit"],
			"L_EMAIL"					=> $Lang->data["newslt_email"],
			"L_ERROR_EMAIL"				=> $Lang->data["newslt_error_email"],
			"L_ERROR_KEYWORD"			=> $Lang->data["search_error_keyword"],
			'L_ERROR_NOT_FULL'			=> $Lang->data["general_error_not_full"],
			"L_GO"						=> $Lang->data["button_go"],
			"L_CAT"						=> $Lang->data["general_cat"],
			"L_TOP_PAGE"				=> $Lang->data["general_top_page"],
			"L_VIEW_MORE"				=> $Lang->data["general_view_more"],
			"L_TEMPLATE"				=> $Lang->data["general_template"],
		));
	}

	function update_statistic(){
		global $Info, $Template;

		$update_time	= CURRENT_TIME - $Info->option['stat_time_update'];

		//Check stat session from cookie
		if ( isset($_COOKIE['stat_time_update']) && ($_COOKIE['stat_time_update'] >= $update_time) ){
			return false;
		}

		$Template->set_block_vars("ajax_update_statistic", array(
			'U_STATISTIC'	=> $Info->option['site_url'] . AJAX_INDEX .'?mod='. MOD_AJAX_STATISTIC
		));
	}

	function cat_menu(){
		global $Func, $Info, $DB, $Template;

		//Get disabled categories
		$this->disabled_cats	= $Func->get_disabled_cats("article_category");

		//Get all cats
		$where_sql		= sizeof($this->disabled_cats) ? " WHERE cat_id NOT IN (". implode(",", $this->disabled_cats) .")" : "";
		$DB->query("SELECT * FROM ". $DB->prefix ."article_category ". $where_sql ." ORDER BY cat_order ASC");
		$this->cat_count	= $DB->num_rows();
		$this->cat_data		= $DB->fetch_all_array();
		$DB->free_result();

		//Get cat id from code -----------------
		if ( $Info->mod	== MOD_ARTICLE ){
			if ( $Info->option['short_url_enabled'] && ($Func->var_count > 1) ){
				for ($i=1; $i < $Func->var_count; $i++){
					$cid	= $this->get_cat_id($Func->var_info[$i]);
					if ( $cid ){
						$this->cat_id		= $cid;
						$this->cat_pos_var	= $i;
					}
					else{
						break;
					}
				}
			}
			else{
				$cat_code		= isset($_GET["cat"]) ? htmlspecialchars($_GET["cat"]) : '';
				$cid			= $this->get_cat_id($cat_code);
				$this->cat_id	= $cid ? $cid : 0;
			}
		}
		//--------------------------------------

		//Compile cats for showing
		$this->get_parent_cat($this->cat_id);
		$this->show_cats($this->cat_id, 0, 1, $Info->option['menucat_level']);
	}

	function get_cat_id($cat_code){
		if ( empty($cat_code) ) return 0;

		for ($i=0; $i<$this->cat_count; $i++){
			if ($cat_code == $this->cat_data[$i]['cat_code']){
				return $this->cat_data[$i]['cat_id'];
			}
		}

		return 0;
	}

	function get_parent_cat($cid){
		for ($i=0; $i<$this->cat_count; $i++){
			if ($cid == $this->cat_data[$i]['cat_id']){
				$this->cat_flag[$this->cat_data[$i]['cat_parent_id']] = 1;
				$this->get_parent_cat($this->cat_data[$i]['cat_parent_id']);
				break;
			}
		}
	}

	function show_cats($cid, $parent_id, $current_level, $display_level=1, $prefix=""){
		global $Template, $Func, $Info;

		for ($i=0; $i<$this->cat_count; $i++){
			if ($parent_id == $this->cat_data[$i]['cat_parent_id']){
				$code_path	= $this->cat_data[$i]['cat_code'];
				if ( $this->cat_data[$i]['cat_parent_id'] && $Info->option['short_url_enabled'] ){
					$this->get_code_path($code_path, $this->cat_data[$i]['cat_parent_id']);
				}

				if ( !empty($this->cat_data[$i]['redirect_url']) ){
					$u_view	= (@substr($this->cat_data[$i]['redirect_url'], 0, 7) != 'http://') ? 'http://'. $this->cat_data[$i]['redirect_url'] : $this->cat_data[$i]['redirect_url'];
				}
				else{
					$u_view	= $Func->compile_url(array('mod' => MOD_ARTICLE, 'cat' => $code_path));
				}

				$blockname	= ($current_level <= 1) ? "menucatrow" : "menucatrow:subcatrow";
				$Template->set_block_vars($blockname, array(
					'U_VIEW'		=> $u_view,
					'NAME'			=> $this->cat_data[$i]['cat_name'],
					'DESC'			=> $this->cat_data[$i]['cat_desc'],
					'PREFIX'		=> $prefix,
				));

				if ( ($cid == $this->cat_data[$i]['cat_id']) || isset($this->cat_flag[$this->cat_data[$i]['cat_id']]) || ($current_level < $display_level) ){
					$this->show_cats($cid, $this->cat_data[$i]['cat_id'], $current_level+1, $display_level, $prefix . "&nbsp;&nbsp;&nbsp;");
				}
			}
		}
	}

	function get_code_path(&$code_path, $cat_id){
		global $Info;

		for ($i=0; $i<$this->cat_count; $i++){
			if ($cat_id == $this->cat_data[$i]['cat_id']){
				$code_path	= !empty($code_path) ? $this->cat_data[$i]['cat_code'] . $Info->option['short_url_sep'] . $code_path : $this->cat_data[$i]['cat_code'];
				if ( !$Info->option['short_url_enabled'] ) return false;
				if ( $this->cat_data[$i]['cat_parent_id'] ){
					$this->get_code_path($code_path, $this->cat_data[$i]['cat_parent_id']);
				}
			}
		}

		return true;
	}

	function show_poll(){
		global $Func, $DB, $Template, $Lang, $Info;

		if ( !$Info->option['poll_enabled'] ){
			//Hide Poll box
			return false;
		}

		$cat_id		= $this->cat_id ? $this->cat_id : -1;

		$DB->query("SELECT poll_id, question, multiple FROM ". $DB->prefix ."poll WHERE cat_id LIKE '%,$cat_id,%' AND enabled=". SYS_ENABLED ." AND start_date<=". CURRENT_TIME ." AND (end_date=0 OR end_date>". CURRENT_TIME .") ORDER BY poll_order DESC LIMIT 0,1");
		$poll_count = $DB->num_rows();
		$poll_data  = $DB->fetch_all_array();
		$DB->free_result();

		for ($i=0; $i<$poll_count; $i++){
			$Template->set_block_vars("pollrow", array(
				"S_ACTION"			=> $Func->compile_url(array('mod' => 'poll', 'act' => 'vote', 'id' => $poll_data[$i]["poll_id"])),
				"U_VIEW_RESULT"		=> $Info->option['site_url'] . $Func->compile_url(array('mod' => 'poll', 'act' => 'view', 'id' => $poll_data[$i]["poll_id"])),
				"ID"				=> $poll_data[$i]["poll_id"],
				"QUESTION"			=> $poll_data[$i]["question"],
				"MULTIPLE"			=> ($poll_data[$i]["multiple"]) ? 'checkbox' : 'radio',
			));

			//Get option
			$DB->query('SELECT option_id, option_title FROM '. $DB->prefix .'poll_option WHERE poll_id='. $poll_data[$i]['poll_id']);
			$option_count	= $DB->num_rows();
			$option_data	= $DB->fetch_all_array();
			$DB->free_result();

			//Options
			for ($j=0; $j<$option_count; $j++){
				$Template->set_block_vars("pollrow:optionrow", array(
					"ID"			=> $option_data[$j]['option_id'],
					"CONTENT"       => $option_data[$j]['option_title'],
					"INPUTNAME"     => ($poll_data[$i]["multiple"]) ? 'optionid['. $option_data[$j]['option_id'] .']' : 'optionid',
				));
			}
		}
		return true;
	}

	function show_logos(){
		global $Func, $DB, $Info, $Template, $Lang, $cfg_webpage_list, $cfg_media_objects;

		$date_format	= $Info->option['date_format'];
		$timezone		= $Info->option['timezone'] * 3600;

		//Get page code
		$page_code	= $Info->get_mod();
		if ( in_array($page_code, array(MOD_PICTURE, MOD_SEARCH, MOD_ARCHIVE)) ){
			$page_code	= MOD_HOME; //Home page
		}

		if ( isset($cfg_webpage_list[$page_code]) ){
			$sql	= "SELECT * FROM ". $DB->prefix ."logo WHERE enabled=1 AND start_date<=". CURRENT_TIME ." AND (end_date=0 OR end_date>". CURRENT_TIME .") AND (logo_pages LIKE '%,". $page_code .",%' OR logo_pages LIKE '%,-1,%') ORDER BY logo_order ". LOGO_SORT_ORDER;
		}
		else if ( $page_code == MOD_ARTICLE ){
			$sql	= "SELECT * FROM ". $DB->prefix ."logo WHERE enabled=1 AND start_date<=". CURRENT_TIME ." AND (end_date=0 OR end_date>". CURRENT_TIME .") AND (logo_pages LIKE '%,C_". $this->cat_id .",%' OR logo_pages LIKE '%,-1,%') ORDER BY logo_order ". LOGO_SORT_ORDER;
		}
		else{
			return false;
		}

		$DB->query($sql);
		$logo_count		= $DB->num_rows();
		$logo_data		= $DB->fetch_all_array();
		$DB->free_result();

		for ($i=0; $i<$logo_count; $i++){
			//Title
			$logo_title	= sprintf($Lang->data["logo_title"], $logo_data[$i]["site_name"], $Func->translate_date(gmdate($date_format, $logo_data[$i]["start_date"] + $timezone)));
			//File path
			if ( substr($logo_data[$i]["logo_file"], 0, 7) != 'http://' ){
				$logo_data[$i]["logo_file"]	= './images/logos/'. $logo_data[$i]["logo_file"];
			}
			//Logo
			if ( @substr($logo_data[$i]["logo_file"], -4) == '.swf' ){
				$swf_width	= $logo_data[$i]["logo_width"] ? $logo_data[$i]["logo_width"] : LOGO_SWF_WIDTH;
				$swf_height	= $logo_data[$i]["logo_height"] ? $logo_data[$i]["logo_height"] : LOGO_SWF_HEIGHT;
				$logo		= str_replace("[_FILENAME_]", $logo_data[$i]["logo_file"], $cfg_media_objects['swf']);
				$logo		= str_replace("[_WIDTH_]", $swf_width, $logo);
				$logo		= str_replace("[_HEIGHT_]", $swf_height, $logo);
			}
			else{
				$logo  = '<img src="'. $logo_data[$i]["logo_file"] .'" border="0"';
				$logo .= $logo_data[$i]["logo_width"] ? ' width="'. $logo_data[$i]["logo_width"] .'"' : '';
				$logo .= $logo_data[$i]["logo_height"] ? ' height="'. $logo_data[$i]["logo_height"] .'"' : '';
				$logo .= ' alt="" title="'. $logo_title .'">';
			}

			if ( !empty($logo_data[$i]['site_url']) ){
				$u_view	= $Func->compile_url(array('mod' => 'logo', 'id' => $logo_data[$i]['logo_id']));
				$logo	= '<a href="'. $u_view .'" target="_blank" title="'. $logo_title .'">'. $logo .'</a>';
			}

			$blockname	= ($logo_data[$i]["logo_pos"] == LOGO_POS_LEFT) ? "left_logorow" : "right_logorow";
			$Template->set_block_vars($blockname, array(
				"LOGO"		=> $logo,
			));
		}
	}

	function get_sub_cat_sql($cat_parent_id, &$where_sql, $check_index_display = 0){
		for ($i=0; $i<$this->cat_count; $i++){
			if ($this->cat_data[$i]['cat_parent_id'] == $cat_parent_id){
				if ( !$check_index_display || ($this->cat_data[$i]['index_display'] == 1) ){
					$where_sql	.= " OR cat_id=". $this->cat_data[$i]['cat_id'];
					$this->get_sub_cat_sql($this->cat_data[$i]['cat_id'], $where_sql);
				}
			}
		}
	}

	function show_news_picture(){
		global $DB, $Template, $Info, $Func;

		if ( !$Info->option['newspic_enabled'] ){
			//Hide NewsPicture box
			return false;
		}

		$cat_id		= $this->cat_id;
		if ( !$cat_id ){
			$cat_id	= -1;
		}

		$limit	= intval($Info->option['newspic_rand_limit']);
		$DB->query("SELECT picture_id, pic_thumb, pic_full, pic_content, posted_date FROM ". $DB->prefix ."picture WHERE cat_id LIKE '%,". $cat_id .",%' AND enabled=". SYS_ENABLED ." AND posted_date<=". CURRENT_TIME ." AND pic_thumb!='' ORDER BY posted_date DESC LIMIT 0,". $limit);
		$newspic_count	= $DB->num_rows();
		$newspic_data	= $DB->fetch_all_array();
		$DB->free_result();

		if ( $newspic_count ){
			$image_path		= $Func->get_newspic_dir($newspic_data[0]['posted_date'], $newspic_data[0]['picture_id']);
			if ( !empty($newspic_data[0]['pic_full']) && file_exists($image_path .'/'. $newspic_data[0]['pic_full']) ){
				$imgsize	= getimagesize($image_path .'/'. $newspic_data[0]['pic_full']);
			}
			$Template->set_block_vars("newspicture", array(
				'PIC_THUMB'		=> !empty($newspic_data[0]['pic_thumb']) ? '<img src="'. $image_path .'/'. $newspic_data[0]['pic_thumb'] .'" border="0" alt="">' : '',
				'PIC_FULL'		=> !empty($newspic_data[0]['pic_full']) ? $Info->option['site_url'] . $image_path .'/'. $newspic_data[0]['pic_full'] : '',
				'CONTENT'		=> nl2br($newspic_data[0]['pic_content']),
				'WIDTH'			=> isset($imgsize[0]) ? $imgsize[0] : 200,
				'HEIGHT'		=> isset($imgsize[1]) ? $imgsize[1] : 200,
				'RAND_TIME'		=> $Info->option['newspic_rand_time'],
				'TOTAL_PICS'	=> $newspic_count,
			));

			if ( $newspic_count >= 2 ){
				for ($i=0; $i<$newspic_count; $i++){
					$image_path		= $Func->get_newspic_dir($newspic_data[$i]['posted_date'], $newspic_data[$i]['picture_id']);
					if ( !empty($newspic_data[$i]['pic_full']) && file_exists($image_path .'/'. $newspic_data[$i]['pic_full']) ){
						$imgsize	= getimagesize($image_path .'/'. $newspic_data[$i]['pic_full']);
					}
					$picthumb	= !empty($newspic_data[$i]['pic_thumb']) ? '<img src="'. $image_path .'/'. $newspic_data[$i]['pic_thumb'] .'" border="0" alt="">' : '';
					$picfull	= !empty($newspic_data[$i]['pic_full']) ? $Info->option['site_url'] . $image_path .'/'. $newspic_data[$i]['pic_full'] : '';
					$content	= nl2br($newspic_data[$i]['pic_content']);
					$content	= str_replace("\r\n", "", $content);
					$content	= str_replace("\n", "", $content);
					$Template->set_block_vars("global_newspicrow", array(
						'NUM'			=> $i,
						'PIC_THUMB'		=> addslashes($picthumb),
						'PIC_FULL'		=> addslashes($picfull),
						'CONTENT'		=> addslashes(addslashes($content)),
						'WIDTH'			=> isset($imgsize[0]) ? $imgsize[0] : 200,
						'HEIGHT'		=> isset($imgsize[1]) ? $imgsize[1] : 200,
					));
				}
			}
		}
		return true;
	}

	function show_events(){
		global $Lang, $Info, $Template, $DB, $Func;

		if ( !$Info->option['event_enabled'] ){
			//Hide Event box
			return false;
		}
		//Display Event box
		$Template->set_block_vars("event_enabled");

		$time		= CURRENT_TIME + $Info->option['timezone']*3600;
		$today		= getdate($time);
		$day_count	= date('t', $time);

		//Get event from database -------------------
		$DB->query('SELECT event_day FROM '. $DB->prefix .'event WHERE event_year='. $today['year'] .' AND event_month='. $today['mon'] .' AND enabled='. SYS_ENABLED);
		$event_info	= array();
		if ( $DB->num_rows() ){
			while ($tmp_info = $DB->fetch_array()){
				$event_info[]	= $tmp_info['event_day'];
			}
		}
		$DB->free_result();
		//-------------------------------------------

		$day_info	= array();
		$first_day	= ($today['wday'] + 1) - $today['mday']%7;
		if ( $first_day == 7 ){
			$first_day	= 0;
		}
		if ( $first_day < 0 ){
			$first_day		= 7 + $first_day; //Ex: 7 + (-2)
		}
		if ( $first_day ){
			for ($i=0; $i<$first_day; $i++){
				$day_info[]	= '&nbsp;';
			}
		}
		for ($i=1; $i<=$day_count; $i++){
			$day_info[]	= $i;
		}

		$i = 0;
		$count	= sizeof($day_info);
		while ($i < $count){
			$Template->set_block_vars("eventrow");
			for ($j=0; $j<7; $j++){
				if ( $i < $count ){
					$Template->set_block_vars("eventrow:eventcol", array(
						'DAY'	=> in_array($day_info[$i], $event_info) ? '<a class="haveEvent" href="javascript: open_window(\''. $Info->option['site_url'] . $Func->compile_url(array('mod' => 'event', 'year' => $today['year'], 'month' => $today['mon'], 'day' => $day_info[$i])) .'\', 450, 400);">'. $day_info[$i] .'</a>' : $day_info[$i],
					));
					if ( $day_info[$i] != '&nbsp;'){
						$Template->set_block_vars("eventrow:eventcol:havecol");
					}
				}
				else{
					$Template->set_block_vars("eventrow:eventcol", array(
						'DAY'	=> '&nbsp;',
					));
				}
				$i++;
			}
		}

		$Template->set_vars(array(
			'CURRENT_MONTH_YEAR'	=> $Func->convert_month($today['mon']) .' '. $today['year'],
			'U_EVENT'				=> $Func->compile_url(array('mod' => 'event')),
			"L_EVENT"				=> $Lang->data["event"],
			"L_MONDAY"				=> $Lang->data["event_monday"],
			"L_TUESDAY"				=> $Lang->data["event_tuesday"],
			"L_WEDNESDAY"			=> $Lang->data["event_wednesday"],
			"L_THURDAY"				=> $Lang->data["event_thurday"],
			"L_FRIDAY"				=> $Lang->data["event_friday"],
			"L_SATURDAY"			=> $Lang->data["event_saturday"],
			"L_SUNDAY"				=> $Lang->data["event_sunday"],
		));
		return true;
	}

	function show_global_hotarticles(){
		global $DB, $Template, $HomeGlobal, $Info, $Func, $Lang;

		//Get hotest articles
		$where_sql		= sizeof($this->disabled_cats) ? " AND cat_id NOT IN (". implode(",", $this->disabled_cats) .")" : "";
		$DB->query('SELECT article_id, cat_id, title FROM '. $DB->prefix .'article WHERE is_hot='. SYS_ARTICLE_HOT . $where_sql .' AND article_type='. SYS_ARTICLE_FULL .' AND archived='. SYS_UNARCHIVED .' AND enabled='. SYS_ENABLED .' AND posted_date<='. CURRENT_TIME .' ORDER BY posted_date DESC LIMIT 0,'. $Info->option['limit_global_hot']);
		$article_count	= $DB->num_rows();
		$article_data	= $DB->fetch_all_array();
		$DB->free_result();

		$title_string	= "";
		$url_string		= "";
		if ( $article_count ){
			for ($i=0; $i<$article_count; $i++){
				$code_path	= "";
				$HomeGlobal->get_code_path($code_path, $article_data[$i]['cat_id']);
/*
				//Use marquee to display hot articles
				$Template->set_block_vars("globalHotArticlerow", array(
					'TITLE'		=> strip_tags(html_entity_decode($article_data[$i]['title'])),
					'U_VIEW'	=> $Func->compile_url(array('mod' => MOD_ARTICLE, 'cat' => $code_path, 'article' => $article_data[$i]['article_id'])),
					'SEP'		=> ($i < $article_count - 1) ? ';' : '',
				));
*/
				//Use ticker engine to display
				//Titles
				$title_string	.= '"'. addslashes(strip_tags(html_entity_decode($article_data[$i]['title']))) .'"';
				if ( $i < $article_count - 1 ){
					$title_string	.= ', ';
				}

				//URLs
				$url		= $Func->compile_url(array('mod' => MOD_ARTICLE, 'cat' => $code_path, 'article' => $article_data[$i]['article_id']));
				$url_string	.= '"'. addslashes($url) .'"';
				if ( $i < $article_count - 1 ){
					$url_string	.= ', ';
				}
			}
			$Template->set_block_vars("globalHotArticle", array(
				'TITLE_STRINGS'		=> $title_string,
				'URL_STRINGS'		=> $url_string,
			));
		}

		$Template->set_vars(array(
			'L_FOCUS'			=> $Lang->data['article_focus'],
			'L_HOT_NEWS'		=> $Lang->data['article_hot'],
		));
	}

	//Latest articles | Today articles
	function show_latest_box(){
		global $DB, $Template, $HomeGlobal, $Info, $Func, $Lang;

		$limit_news		= intval($Info->option['latest_box_items']);
		$where_sql		= sizeof($this->disabled_cats) ? " AND cat_id NOT IN (". implode(",", $this->disabled_cats) .")" : "";

		if ( $Info->option['latest_box_type'] == 1 ){ //Latest articles
//			$sql	= 'SELECT article_id, cat_id, thumb_small, thumb_icon, title, content_url, posted_date, article_type FROM '. $DB->prefix .'article WHERE article_type!='. SYS_ARTICLE_SUMMARY . $where_sql .' AND enabled='. SYS_ENABLED .' AND posted_date<='. CURRENT_TIME .' ORDER BY posted_date DESC LIMIT 0,'. $limit_news;
			$sql	= 'SELECT article_id, cat_id, thumb_small, thumb_icon, title, content_url, posted_date, article_type FROM '. $DB->prefix .'article WHERE article_type!='. SYS_ARTICLE_SUMMARY . $where_sql .' AND archived='. SYS_UNARCHIVED .' AND enabled='. SYS_ENABLED .' AND posted_date<='. CURRENT_TIME .' ORDER BY posted_date DESC LIMIT 3,'. $limit_news; //Remove first three articles since they are displayed on the main box
		}
		else if ( $Info->option['latest_box_type'] == 2 ){ //Today articles
			//Get start time
			$tmp_time	= gmdate("H:i:s", CURRENT_TIME + $Info->option['timezone']*3600);
			$time_info	= explode(":", $tmp_time);
			$start_time	= CURRENT_TIME - ($time_info[0]*3600) + ($time_info[1]*60) + $time_info[2];//Get total seconds

			$sql	= 'SELECT article_id, cat_id, thumb_small, thumb_icon, title, content_url, posted_date, article_type FROM '. $DB->prefix .'article WHERE article_type!='. SYS_ARTICLE_SUMMARY . $where_sql .' AND archived='. SYS_UNARCHIVED .' AND enabled='. SYS_ENABLED .' AND posted_date>'. $start_time .' AND posted_date<='. CURRENT_TIME .' ORDER BY posted_date DESC LIMIT 0,'. $limit_news;
		}
		else{ //Not display latest box
			return false;
		}

		//Get totay articles
		$DB->query($sql);
		$article_count	= $DB->num_rows();
		$article_data	= $DB->fetch_all_array();
		$DB->free_result();

		$Template->set_block_vars("globalLatestBox", array(
			'MESSAGE'	=> $article_count ? "" : $Lang->data['general_no_article']
		));
		for ($i=0; $i<$article_count; $i++){
			$code_path	= "";
			$HomeGlobal->get_code_path($code_path, $article_data[$i]['cat_id']);
			if ( $article_data[$i]['article_type'] == SYS_ARTICLE_LINK ){
				$u_view		= $article_data[$i]['content_url'];
			}
			else{
				$u_view		= $Func->compile_url(array('mod' => MOD_ARTICLE, 'cat' => $code_path, 'article' => $article_data[$i]['article_id']));
			}
			$Template->set_block_vars("globalLatestBox:Articlerow", array(
				'THUMB_SMALL'	=> !empty($article_data[$i]['thumb_small']) ? '<img src="'. $Func->get_article_dir($article_data[$i]['posted_date'], $article_data[$i]['article_id']) .'/'. $article_data[$i]['thumb_small'] .'" alt="" title="'. $article_data[$i]['title'] .'" border="0" vspace="3" hspace="0"><br>' : '',
				'TITLE'			=> strip_tags(html_entity_decode($article_data[$i]['title'])),
				'U_VIEW'		=> $u_view,
			));
		}

		$Template->set_vars(array(
			'L_LATEST_BOX'		=> ($Info->option['latest_box_type'] == 1) ? $Lang->data['latest_articles'] : $Lang->data['today_articles'],
		));
	}
}

?>