<?php
/* =============================================================== *\
|		Module name:      Home										|
|																	|
\* =============================================================== */

if (!defined('IN_SITE')){
     die('Hacking attempt!');
}

//Call global functions --------------
$HomeGlobal->cat_menu();
$HomeGlobal->show_poll();
$HomeGlobal->show_logos();
$HomeGlobal->show_events();
$HomeGlobal->show_news_picture();
$HomeGlobal->show_global_hotarticles();
//------------------------------------

$Home = new Home;

class Home
{
	var $gmt				= array();
	var $hot_articles		= array();

	function Home(){
		global $Info;

		if ( $Info->option['timezone'] > 0 ){
			$this->gmt	= ' (GMT+'. $Info->option['timezone'] .')';
		}
		else if ( $Info->option['timezone'] < 0 ){
			$this->gmt	= ' (GMT'. $Info->option['timezone'] .')';
		}
		else{
			$this->gmt	= ' (GMT)';
		}

		$this->get_focus_articles();
		$this->get_hot_articles();
		$this->get_latest_articles();
		$this->list_categories();
	}

	function get_focus_articles(){
		global $DB, $Template, $Lang, $Info, $Func, $HomeGlobal;

		$date_format	= $Info->option['full_date_time_format'];
		$timezone		= $Info->option['timezone'] * 3600;

		$where_sql		= sizeof($HomeGlobal->disabled_cats) ? " AND cat_id NOT IN (". implode(",", $HomeGlobal->disabled_cats) .")" : "";
		$DB->query('SELECT article_id, cat_id, thumb_large, thumb_small, thumb_icon, title, content_desc, content_url, posted_date, article_type FROM '. $DB->prefix .'article WHERE article_type!='. SYS_ARTICLE_SUMMARY .' AND archived='. SYS_UNARCHIVED .' AND enabled='. SYS_ENABLED . $where_sql .' AND is_hot='. SYS_ARTICLE_HOT .' AND posted_date<='. CURRENT_TIME .' ORDER BY posted_date DESC LIMIT 0,'. $Info->option['home_focus_limit']);
		$article_count	= $DB->num_rows();
		$article_data	= $DB->fetch_all_array();
		$DB->free_result();

		if ( $article_count ){
			$i			= 0;
			$code_path	= "";
			$HomeGlobal->get_code_path($code_path, $article_data[$i]['cat_id']);
			$thumb_pic	= !empty($article_data[$i]['thumb_large']) ? $article_data[$i]['thumb_large'] : (!empty($article_data[$i]['thumb_small']) ? $article_data[$i]['thumb_small'] : '');
			$thumb_pic	= !empty($thumb_pic) ? '<img src="'. $Func->get_article_dir($article_data[$i]['posted_date'], $article_data[$i]['article_id']) .'/'. $thumb_pic .'" alt="" title="'. $article_data[$i]['title'] .'" border="0" align="left" vspace="0" hspace="0" style="padding-right: 8px;">' : '';
			if ( $article_data[$i]['article_type'] == SYS_ARTICLE_LINK ){
				$u_view		= $article_data[$i]['content_url'];
			}
			else{
				$u_view		= $Func->compile_url(array('mod' => MOD_ARTICLE, 'cat' => $code_path, 'article' => $article_data[$i]['article_id']));
			}
			$Template->set_block_vars("focusArticle", array(
				'DATE'			=> $Func->translate_date(gmdate($date_format, $article_data[$i]['posted_date'] + $timezone)),
				'PIC_THUMB'		=> !empty($thumb_pic) ? $Func->make_article_link($thumb_pic, $article_data[$i]['article_type'], $u_view) : '',
				'TITLE'			=> $Func->make_article_link(html_entity_decode($article_data[$i]['title']), $article_data[$i]['article_type'], $u_view, "btitle"),
				'PREVIEW'		=> html_entity_decode($article_data[$i]['content_desc']),
			));

			$i++;
			while ($i < $article_count){
				$Template->set_block_vars("focusArticle:articlerow");
				for ($j=0; $j<$Info->option['home_focus_cols']; $j++){
					if ($i < $article_count){
						$code_path	= "";
						$HomeGlobal->get_code_path($code_path, $article_data[$i]['cat_id']);
						$thumb_icon	= !empty($article_data[$i]['thumb_icon']) ? '<img src="'. $Func->get_article_dir($article_data[$i]['posted_date'], $article_data[$i]['article_id']) .'/'. $article_data[$i]['thumb_icon'] .'" alt="" title="'. $article_data[$i]['title'] .'" border="0" align="left" vspace="5" hspace="5">' : '';
						$u_view		= $Func->compile_url(array('mod' => MOD_ARTICLE, 'cat' => $code_path, 'article' => $article_data[$i]['article_id']));
						if ( $article_data[$i]['article_type'] == SYS_ARTICLE_LINK ){
							$u_view		= $article_data[$i]['content_url'];
						}
						else{
							$u_view		= $Func->compile_url(array('mod' => MOD_ARTICLE, 'cat' => $code_path, 'article' => $article_data[$i]['article_id']));
						}
						$Template->set_block_vars("focusArticle:articlerow:articlecol", array(
							'DATE'			=> $Func->translate_date(gmdate($date_format, $article_data[$i]['posted_date'] + $timezone)),
							'PIC_ICON'		=> !empty($thumb_icon) ? $Func->make_article_link($thumb_icon, $article_data[$i]['article_type'], $u_view) : '',
							'TITLE'			=> $Func->make_article_link(html_entity_decode($article_data[$i]['title']), $article_data[$i]['article_type'], $u_view, "ntitle"),
						));
						if ( $j < $Info->option['home_focus_cols'] - 1){
							$Template->set_block_vars("focusArticle:articlerow:articlecol:middle");
						}
					}
					else{
						$Template->set_block_vars("focusArticle:articlerow:articlecol", array(
							'DATE'			=> '',
							'PIC_ICON'	=> '',
							'TITLE'			=> '',
						));
					}
					$i++;
				}
			}

			//Remember hot articles ------------
			for ($i=0; $i<$article_count; $i++){
				$this->hot_articles[]	= $article_data[$i]['article_id'];
			}
			//----------------------------------
		}

		$Template->set_vars(array(
			'FOCUS_TDWIDTH'		=> (round(100 / $Info->option['home_focus_cols']) - $Info->option['home_focus_cols'] + 1) .'%',
			'L_FOCUS_NEWS'		=> $Lang->data['article_focus']
		));
	}

	function get_hot_articles(){
		global $DB, $Template, $HomeGlobal, $Info, $Func, $Lang;

		$where_sql		= sizeof($HomeGlobal->disabled_cats) ? " AND cat_id NOT IN (". implode(",", $HomeGlobal->disabled_cats) .")" : "";
		$DB->query('SELECT article_id, cat_id, title, content_url, posted_date, article_type FROM '. $DB->prefix .'article WHERE is_hot='. SYS_ARTICLE_HOT . $where_sql .' AND article_type='. SYS_ARTICLE_FULL .' AND archived='. SYS_UNARCHIVED .' AND enabled='. SYS_ENABLED .' AND posted_date<='. CURRENT_TIME .' ORDER BY posted_date DESC LIMIT 0,'. $Info->option['home_hot_limit']);
		$article_count	= $DB->num_rows();
		$article_data	= $DB->fetch_all_array();
		$DB->free_result();

		for ($i=0; $i<$article_count; $i++){
			$code_path	= "";
			$HomeGlobal->get_code_path($code_path, $article_data[$i]['cat_id']);
			$thumb_icon	= !empty($article_data[$i]['thumb_icon']) ? '<img src="'. $Func->get_article_dir($article_data[$i]['posted_date'], $article_data[$i]['article_id']) .'/'. $article_data[$i]['thumb_icon'] .'" alt="" title="'. $article_data[$i]['title'] .'" border="0" align="left" vspace="3" hspace="3">' : '';
			$Template->set_block_vars("hotarticlerow", array(
				'TITLE'			=> strip_tags(html_entity_decode($article_data[$i]['title'])),
				'U_VIEW'		=> $Func->compile_url(array('mod' => MOD_ARTICLE, 'cat' => $code_path, 'article' => $article_data[$i]['article_id'])),
			));
		}
	}

	function get_latest_articles(){
		global $DB, $Template, $HomeGlobal, $Info, $Func, $Lang;

		$where_sql		= sizeof($HomeGlobal->disabled_cats) ? " AND cat_id NOT IN (". implode(",", $HomeGlobal->disabled_cats) .")" : "";
		$DB->query('SELECT article_id, cat_id, title, content_url, posted_date, article_type FROM '. $DB->prefix .'article WHERE is_hot='. SYS_ARTICLE_NORMAL . $where_sql .' AND article_type='. SYS_ARTICLE_FULL .' AND archived='. SYS_UNARCHIVED .' AND enabled='. SYS_ENABLED .' AND posted_date<='. CURRENT_TIME .' ORDER BY posted_date DESC LIMIT 0,'. $Info->option['home_latest_limit']);
		$article_count	= $DB->num_rows();
		$article_data	= $DB->fetch_all_array();
		$DB->free_result();

		for ($i=0; $i<$article_count; $i++){
			$code_path	= "";
			$HomeGlobal->get_code_path($code_path, $article_data[$i]['cat_id']);
			$thumb_icon	= !empty($article_data[$i]['thumb_icon']) ? '<img src="'. $Func->get_article_dir($article_data[$i]['posted_date'], $article_data[$i]['article_id']) .'/'. $article_data[$i]['thumb_icon'] .'" alt="" title="'. $article_data[$i]['title'] .'" border="0" align="left" vspace="3" hspace="3">' : '';
			$Template->set_block_vars("latestarticlerow", array(
				'TITLE'			=> strip_tags(html_entity_decode($article_data[$i]['title'])),
				'U_VIEW'		=> $Func->compile_url(array('mod' => MOD_ARTICLE, 'cat' => $code_path, 'article' => $article_data[$i]['article_id'])),
			));
		}

		$Template->set_vars(array(
			'L_LATEST_NEWS'	=> $Lang->data['latest_articles']
		));
	}

	function list_categories(){
		global $DB, $Template, $Lang, $Info, $HomeGlobal, $Func;

		$Info->tpl_main	= "home";
		$date_format	= $Info->option['full_date_time_format'];
		$timezone		= $Info->option['timezone'] * 3600;

		//Get top cats
		$cat_count		= 0;
		$cat_data		= array();
		for ($i=0; $i<$HomeGlobal->cat_count; $i++){
			if ( !$HomeGlobal->cat_data[$i]['cat_parent_id'] && $HomeGlobal->cat_data[$i]['index_display'] && empty($HomeGlobal->cat_data[$i]['redirect_url']) ){
				$cat_data[]	= $HomeGlobal->cat_data[$i];
				$cat_count++;
			}
		}

		//Get top articles
		$i	= 0;
		while ($i < $cat_count){
			$Template->set_block_vars("catrow");
			for ($j=0; $j<$Info->option['home_cat_cols']; $j++){
				if ($i < $cat_count){
					$Template->set_block_vars("catrow:catcol", array(
						'CAT_NAME'		=> $cat_data[$i]['cat_name'],
						'U_VIEW'		=> $Func->compile_url(array('mod' => MOD_ARTICLE, 'cat' => $cat_data[$i]['cat_code'])),
					));
					if ( $j == 0 ){
						$Template->set_block_vars("catrow:catcol:leftcol");
					}
					else{
						$Template->set_block_vars("catrow:catcol:rightcol");
					}
					if ( $j < $Info->option['home_cat_cols'] - 1){
						$Template->set_block_vars("catrow:catcol:middle");
					}

					//Make where sql for subcats
					$where_sql	= " WHERE (cat_id=". $cat_data[$i]['cat_id'];
					$HomeGlobal->get_sub_cat_sql($cat_data[$i]['cat_id'], $where_sql, 1);
					$where_sql	.= ") AND archived='. SYS_UNARCHIVED .' AND enabled=". SYS_ENABLED ." AND posted_date<=". CURRENT_TIME ." AND article_type=". SYS_ARTICLE_FULL;
					if ( sizeof($this->hot_articles) ){//Not diplay top hot articles
						$where_sql	.= " AND article_id NOT IN (". implode(",", $this->hot_articles) .")";
					}

					//Get articles of these cats
					$DB->query('SELECT article_id, cat_id, thumb_small, title, content_desc, content_url, posted_date, article_type FROM '. $DB->prefix .'article '. $where_sql .' ORDER BY posted_date DESC LIMIT 0,'. $Info->option['home_cat_article_limit']);
					$article_count	= $DB->num_rows();
					$article_data	= $DB->fetch_all_array();
					$DB->free_result();

					$desc_flag	= 0;
					for ($k=0; $k<$article_count; $k++){
						$code_path	= "";
						$HomeGlobal->get_code_path($code_path, $article_data[$k]['cat_id']);
						$thumb_small	= !empty($article_data[$k]['thumb_small']) ? '<img src="'. $Func->get_article_dir($article_data[$k]['posted_date'], $article_data[$k]['article_id']) .'/'. $article_data[$k]['thumb_small'] .'" alt="" title="'. $article_data[$k]['title'] .'" border="0" align="left" vspace="5" hspace="5">' : '';
						if ( $article_data[$k]['article_type'] == SYS_ARTICLE_LINK ){
							$u_view		= $article_data[$k]['content_url'];
						}
						else{
							$u_view		= $Func->compile_url(array('mod' => MOD_ARTICLE, 'cat' => $code_path, 'article' => $article_data[$k]['article_id']));
						}
						if ( !$desc_flag ){
							$Template->set_block_vars("catrow:catcol:hotrow", array(
								'DATE'			=> $Func->translate_date(gmdate($date_format, $article_data[$k]['posted_date'] + $timezone)),
								'THUMB_SMALL'	=> !empty($thumb_small) ? $Func->make_article_link($thumb_small, $article_data[$k]['article_type'], $u_view) : '',
								'TITLE'			=> $Func->make_article_link(html_entity_decode($article_data[$k]['title']), $article_data[$k]['article_type'], $u_view, 'mtitle'),
								'PREVIEW'		=> html_entity_decode($article_data[$k]['content_desc']),
							));
							$desc_flag	= 1;
						}
						else{
							$Template->set_block_vars("catrow:catcol:articlerow", array(
								'DATE'			=> $Func->translate_date(gmdate($date_format, $article_data[$k]['posted_date'] + $timezone)),
								'TITLE'			=> $Func->make_article_link(html_entity_decode($article_data[$k]['title']), $article_data[$k]['article_type'], $u_view, 'otherNews'),
							));
						}
					}
				}
				else{
					$Template->set_block_vars("catrow:catcol", array(
						'CAT_NAME'			=> '',
						'U_VIEW'			=> '',
					));
				}
				$i++;
			}
		}

		$Template->set_vars(array(
			'CAT_TDWIDTH'	=> (round(100 / $Info->option['home_cat_cols']) - $Info->option['home_cat_cols'] + 1) .'%',
			'L_VIEW_MORE'	=> $Lang->data['general_view_more']
		));
	}
}
?>