<?php
/* =============================================================== *\
|		Module name: Newsletter Global								|
|																	|
\* =============================================================== */

if (!defined('IN_SITE')){
     die('Hacking attempt!');
}

$NewsltGlobal	= new Newsletter_Global;

class Newsletter_Global
{
	var $cat_count		= 0;
	var $cat_data		= array();

	function Newsletter_Global(){
		global $Template, $Info;

		if ( !$Info->option['newsletter_enabled'] ){
			//Hide Newsletter box
			return false;
		}
		//Display Newsletter box
		$Template->set_block_vars("newsletter_enabled");

		$this->get_all_cats();
		$this->set_all_cats(0, 0);
		return true;
	}

	function get_all_cats(){
		global $DB, $Func;

		//Get disabled categories
		$disabled_cats	= $Func->get_disabled_cats("newsletter_category");

		//Get all cats
		$where_sql		= sizeof($disabled_cats) ? " WHERE cat_id NOT IN (". implode(",", $disabled_cats) .")" : "";
		$DB->query("SELECT * FROM ". $DB->prefix ."newsletter_category ". $where_sql ." ORDER BY cat_order ASC");
		$this->cat_count = $DB->num_rows();
		$this->cat_data  = $DB->fetch_all_array();
		$DB->free_result();
	}

	function set_all_cats($parent_id, $except_cid, $level=0, $symbol="&raquo;", $prefix="&nbsp; &nbsp;"){
		global $Session, $Template;

		if ($level){
			$str_prefix	= "";
			for ($i=0; $i<$level; $i++){
				$str_prefix	.= $prefix;
			}
		}
		else{
			$str_prefix	= "";
		}

		for ($i=0; $i<$this->cat_count; $i++){
			if ( ($parent_id == $this->cat_data[$i]['cat_parent_id']) && ($except_cid != $this->cat_data[$i]['cat_id']) ){
				$Template->set_block_vars("newsltcatrow",array(
					'ID'				=> $this->cat_data[$i]['cat_id'],
					'NAME'				=> $this->cat_data[$i]['cat_name'],
					'EMAIL_COUNTER'		=> $this->cat_data[$i]['email_counter'],
					'SUBCAT_COUNTER'	=> $this->cat_data[$i]['children_counter'],
					'PREFIX'			=> $str_prefix . $symbol,
				));
				$this->set_all_cats($this->cat_data[$i]['cat_id'], $except_cid, $level+1, $symbol, $prefix);
			}
		}
	}
}

?>