<?php
/* =============================================================== *\
|		Module name: News Picture									|
|																	|
\* =============================================================== */

if (!defined('IN_SITE')){
     die('Hacking attempt!');
}
//Call global functions --------------
$HomeGlobal->cat_menu();
$HomeGlobal->show_poll();
$HomeGlobal->show_logos();
$HomeGlobal->show_events();
$HomeGlobal->show_global_hotarticles();
$HomeGlobal->show_latest_box();
//------------------------------------

$NewsPic	= new News_Picture;

class News_Picture
{
	var $page		= 1;

	function News_Picture(){
		global $Func;

			$page		= $Func->get_vars('page', 1);
			$page		= intval(str_replace('page_', '', $page));
			$this->page	= ($page > 0) ? $page : 1;

			$this->list_pictures();
	}

	function list_pictures(){
		global $DB, $Lang, $Template, $Info, $HomeGlobal, $Func;

		$Info->tpl_main		= "picture_list";
		$limit_items		= intval($Info->option['newspic_limit_per_page']);

		//Count total pages -----------------------------
		$DB->query('SELECT count(picture_id) AS total FROM '. $DB->prefix .'picture WHERE enabled='. SYS_ENABLED .' AND posted_date<='. CURRENT_TIME);
		if ( $DB->num_rows() ){
			$result		= $DB->fetch_array();
			$pageshow	= $Func->virtual_pagination($result['total'], $limit_items, $this->page, "<strong>". $Lang->data['general_page'] ."</strong>", $Func->compile_url(array('mod' => MOD_PICTURE)), "page_");
		}
		else{
			$pageshow['page']	= "";
			$pageshow['start']	= 0;
		}
		$DB->free_result();
		//-----------------------------------------------

		//Get pictures
		$DB->query('SELECT picture_id, pic_thumb, pic_full, pic_content, posted_date FROM '. $DB->prefix .'picture WHERE enabled='. SYS_ENABLED .' AND posted_date<='. CURRENT_TIME .' ORDER BY posted_date DESC LIMIT '. $pageshow['start'] .','. $limit_items);
		$picture_count	= $DB->num_rows();
		$picture_data	= $DB->fetch_all_array();
		$DB->free_result();

		$i		= 0;
		$cols	= 2;
		while ($i < $picture_count){
			$Template->set_block_vars("picturerow");
			for ($j=0; $j<$cols; $j++){
				if ( $i < $picture_count ){
					$image_path		= $Func->get_newspic_dir($picture_data[$i]['posted_date'], $picture_data[$i]['picture_id']);
					if ( !empty($picture_data[$i]['pic_full']) && file_exists($image_path .'/'. $picture_data[$i]['pic_full']) ){
						$imgsize	= getimagesize($image_path .'/'. $picture_data[$i]['pic_full']);
					}
					$Template->set_block_vars("picturerow:picturecol", array(
						'PIC_THUMB'		=> !empty($picture_data[$i]['pic_thumb']) ? '<img src="'. $image_path .'/'. $picture_data[$i]['pic_thumb'] .'" border="0" alt="">' : '',
						'PIC_FULL'		=> !empty($picture_data[$i]['pic_full']) ? $Info->option['site_url'] . $image_path .'/'. $picture_data[$i]['pic_full'] : '',
						'CONTENT'		=> nl2br($picture_data[$i]['pic_content']),
						'WIDTH'			=> isset($imgsize[0]) ? $imgsize[0] : 200,
						'HEIGHT'		=> isset($imgsize[1]) ? $imgsize[1] : 200,
					));
					$Template->set_block_vars("picturerow:picturecol:havepic");
				}
				else{
					$Template->set_block_vars("picturerow:picturecol");
					$Template->set_block_vars("picturerow:picturecol:nohavepic");
				}
				$i++;
			}
		}

		$Template->set_vars(array(
			"PAGE_OUT"				=> $pageshow['page'],
			'BROWSER_NAVIGATOR'		=> ' - '. $Lang->data['newspic'],
			'NEWSPIC_TDWIDTH'		=> round(100/$cols) .'%',
			'NEWSPIC_COLS'			=> $cols,
		));
	}
}

?>