<?php
/* =============================================================== *\
|		Module name:      RSS										|
|																	|
\* =============================================================== */

if (!defined('IN_SITE')){
     die('Hacking attempt!');
}
define('RSS_CODE_LATEST', 'latest');

//Call global functions --------------
$HomeGlobal->cat_menu();
$HomeGlobal->show_poll();
$HomeGlobal->show_logos();
$HomeGlobal->show_events();
$HomeGlobal->show_news_picture();
$HomeGlobal->show_global_hotarticles();
$HomeGlobal->show_latest_box();
//------------------------------------

$Rss = new RSS;

class RSS
{
	var $cat_count		= 0;
	var $cat_data		= array();
	var $rss_info		= array();

	function RSS(){
		global $DB, $HomeGlobal, $Info, $Func;

		//Get cat id from code -----------------
		if ( $Info->option['short_url_enabled'] && ($Func->var_count > 1) ){
			$cid		= $HomeGlobal->get_cat_id($Func->var_info[1]);
			$rss_code	= isset($Func->var_info[2]) ? $HomeGlobal->get_cat_id($Func->var_info[2]) : '';
		}
		else{
			$cat_code	= isset($_GET["cat"]) ? htmlspecialchars($_GET["cat"]) : '';
			$rss_code	= isset($_GET["rss_code"]) ? htmlspecialchars($_GET["rss_code"]) : '';
			$cid		= $HomeGlobal->get_cat_id($cat_code);
		}
		//--------------------------------------

		if ( $cid || ($rss_code == RSS_CODE_LATEST) ){
			$this->view_rss($cid, $rss_code);
		}
		else{
			$this->list_rss();
		}
	}

	function list_rss(){
		global $DB, $Info, $Template, $Lang, $Func, $HomeGlobal;

		$Info->tpl_main		= "rss_list";

		//Get all published streams
		$DB->query("SELECT cat_id, rss_code FROM ". $DB->prefix ."rss_export");
		$rss_count = $DB->num_rows();
		$rss_data  = $DB->fetch_all_array();
		$DB->free_result();

		for ($i=0; $i<$rss_count; $i++){
			if ( $rss_data[$i]['cat_id'] ){
				$this->rss_info['cat_ids'][]	= $rss_data[$i]['cat_id'];
			}
			else{
				$this->rss_info['rss_codes'][]	= $rss_data[$i]['rss_code'];
			}
		}
		//--------------------------

		//Display top articles
		if ( isset($this->rss_info['rss_codes']) && in_array(RSS_CODE_LATEST, $this->rss_info['rss_codes']) ){
			//Get max cat id
			$DB->query("SELECT max(cat_id) AS max_id FROM ". $DB->prefix ."article_category");
			if ( $DB->num_rows() ){
				$tmp_info	= $DB->fetch_array();
				$max_id		= $tmp_info['max_id'] + 1;
			}
			else{
				$max_id		= 1;
			}

			$Template->set_block_vars("rsscoderow", array(
				'ID'		=> $max_id,
				'NAME'		=> $Lang->data['rss_export_latest_articles'],
				'U_VIEW'	=> $Func->compile_url(array('mod' => 'rss', 'cat' => 'allcat', 'rss_code' => RSS_CODE_LATEST)),
			));
		}

		//Display categories
		$this->cat_count	= $HomeGlobal->cat_count;
		$this->cat_data		= $HomeGlobal->cat_data;
		$this->show_cat(0);

		$Template->set_vars(array(
			'L_EXPAND_ALL'		=> $Lang->data['general_expand_all'],
			'L_COLLAPSE_ALL'	=> $Lang->data['general_collapse_all'],
			'BROWSER_NAVIGATOR'	=> ' - '. $Lang->data['general_rss'],
		));
	}

	function show_cat($parent_id){
		global $Template, $Func, $HomeGlobal, $Info;

		for ($i=0; $i<$this->cat_count; $i++){
			if ( $this->cat_data[$i]['cat_parent_id'] == $parent_id ){
				if (isset($this->rss_info['cat_ids']) && in_array($this->cat_data[$i]['cat_id'], $this->rss_info['cat_ids'])){
					$publish_rss	= 1;
				}
				else{
					$publish_rss	= 0;
					$this->check_publish_rss($publish_rss, $this->cat_data[$i]['cat_id']);
				}

				if ( $publish_rss ){
					$Template->set_block_vars("rsscatrow", array(
						'ID'			=> $this->cat_data[$i]['cat_id'],
						'PARENT_ID'		=> $this->cat_data[$i]['cat_parent_id'],
						'CAT_NAME'		=> (isset($this->rss_info['cat_ids']) && in_array($this->cat_data[$i]['cat_id'], $this->rss_info['cat_ids'])) ? addslashes($this->cat_data[$i]['cat_name']) .' <img src="templates/'. $Info->option['template'] .'/images/rss.gif" border="0" align="absbottom" alt="">' : addslashes($this->cat_data[$i]['cat_name']),
						'U_VIEW'		=> (isset($this->rss_info['cat_ids']) && in_array($this->cat_data[$i]['cat_id'], $this->rss_info['cat_ids'])) ? $Func->compile_url(array('mod' => 'rss', 'cat' => $this->cat_data[$i]['cat_code'])) : '',
					));
					$this->show_cat($this->cat_data[$i]['cat_id']);
				}
			}
		}
	}

	function check_publish_rss(&$publish_rss, $parent_id){
		for ($i=0; $i<$this->cat_count; $i++){
			if ( $this->cat_data[$i]['cat_parent_id'] == $parent_id ){
				if (isset($this->rss_info['cat_ids']) && in_array($this->cat_data[$i]['cat_id'], $this->rss_info['cat_ids'])){
					$publish_rss	= 1;
					return true;
				}
				$this->check_publish_rss($publish_rss, $this->cat_data[$i]['cat_id']);
				if ( $publish_rss ){
					return true;
				}
			}
		}
		return false;
	}

	function view_rss($cat_id, $rss_code){
		global $DB, $Info, $Template, $Lang, $Func, $HomeGlobal;

		$Info->tpl_main		= "rss_view";
		$Info->tpl_header	= "";
		$Info->tpl_footer	= "";

		$date_format	= 'D, d M Y h:i:s';
		$limit_news		= $Info->option['limit_rss_news'];

		//Display articles with cat id
		if ( $cat_id ){
			//Check disabled categories
			if ( in_array($HomeGlobal->cat_id, $HomeGlobal->disabled_cats) ){
				$Template->page_transfer($Lang->data['article_error_cat_not_exist'], $Info->option['site_url'] . $Func->compile_url(""));
				die();
			}

			//Check if category exist
			$DB->query('SELECT * FROM '. $DB->prefix .'article_category WHERE cat_id='. $cat_id);
			if ( !$DB->num_rows() ){
				$Template->page_transfer($Lang->data['article_error_cat_not_exist'], $Info->option['site_url'] . $Func->compile_url(""));
				die();
			}
			$cat_info	= $DB->fetch_array();

			//Get all sub cats
			$where_sql	= " WHERE (cat_id=". $cat_id;
			$HomeGlobal->get_sub_cat_sql($cat_id, $where_sql);
			$where_sql	.= ")";

			$code_path	= "";
			$HomeGlobal->get_code_path($code_path, $cat_id);
			$Template->set_vars(array(
				'CAT_TITLE'			=> $cat_info['cat_name'],
				'CAT_DESC'			=> $cat_info['cat_desc'],
				'U_CAT_VIEW'		=> htmlspecialchars($Info->option['site_url'] . $Func->compile_url(array('mod' => MOD_ARTICLE, 'cat' => $code_path))),
			));

			//Get Top articles in this cat
			$DB->query('SELECT article_id, cat_id, thumb_small, title, content_desc, posted_date FROM '. $DB->prefix .'article '. $where_sql .' AND archived='. SYS_UNARCHIVED .' AND enabled='. SYS_ENABLED .' AND posted_date<='. CURRENT_TIME .' ORDER BY posted_date DESC LIMIT 0,'. $limit_news);
			$article_count	= $DB->num_rows();
			$article_data	= $DB->fetch_all_array();
			$DB->free_result();
		}
		//Display articles with rss code
		else if ($rss_code == RSS_CODE_LATEST){
			$Template->set_vars(array(
				'CAT_TITLE'			=> $Lang->data['rss_export_latest_articles'],
				'CAT_DESC'			=> "",
				'U_CAT_VIEW'		=> "",
			));

			//Get Top articles
			$where_sql		= sizeof($HomeGlobal->disabled_cats) ? " AND cat_id NOT IN (". implode(",", $HomeGlobal->disabled_cats) .")" : "";
			$DB->query('SELECT article_id, cat_id, thumb_small, title, content_desc, posted_date FROM '. $DB->prefix .'article WHERE enabled='. SYS_ENABLED . $where_sql .' AND archived='. SYS_UNARCHIVED .' AND posted_date<='. CURRENT_TIME .' ORDER BY posted_date DESC LIMIT 0,'. $limit_news);
			$article_count	= $DB->num_rows();
			$article_data	= $DB->fetch_all_array();
			$DB->free_result();
		}
		else{
			$Template->page_transfer($Lang->data['article_error_cat_not_exist'], $Info->option['site_url'] . $Func->compile_url(""));
			die();
		}

		//Show articles
		for ($i=0; $i<$article_count; $i++){
			$code_path	= "";
			$HomeGlobal->get_code_path($code_path, $article_data[$i]['cat_id']);
			$Template->set_block_vars("articlerow", array(
				'DATE'			=> $Func->translate_date(gmdate($date_format, $article_data[$i]['posted_date'])) .' GMT',
				'TITLE'			=> htmlspecialchars(strip_tags(html_entity_decode($article_data[$i]['title']))),
				'PREVIEW'		=> htmlspecialchars(strip_tags(html_entity_decode($article_data[$i]['content_desc']))),
				'U_VIEW'		=> htmlspecialchars($Info->option['site_url'] . $Func->compile_url(array('mod' => MOD_ARTICLE, 'cat' => $code_path, 'article' => $article_data[$i]['article_id']))),
			));
			if ( !empty($article_data[$i]['thumb_small']) ){
				$imgsize	= @getimagesize($this->get_article_dir($article_data[$i]['posted_date'], $article_data[$i]['article_id']) .'/'. $article_data[$i]['thumb_small']);
				$Template->set_block_vars("articlerow:enclosure", array(
					'IMAGE_URL'		=> $Info->option['site_url'] . $this->get_article_dir($article_data[$i]['posted_date'], $article_data[$i]['article_id']) .'/'. $article_data[$i]['thumb_small'],
					'IMAGE_TYPE'	=> @$imgsize['mime'],
				));
			}
		}

		@header("Content-Type: text/xml");
	}

	function get_article_dir($time, $id){
		global $Info;

		//Get month and year
		$date	= getdate($time);
		if ($date['mon'] < 10){
			$date['mon']	= '0'. $date['mon'];
		}
		return $Info->imgpath_article . $date['year'] ."_". $date['mon'] .'/'. $id;
	}
}

?>