<?php
/* =============================================================== *\
|		Module name:      Sitemap									|
|																	|
\* =============================================================== */

if (!defined('IN_SITE')){
     die('Hacking attempt!');
}

//Call global functions --------------
$HomeGlobal->cat_menu();
$HomeGlobal->show_poll();
$HomeGlobal->show_logos();
$HomeGlobal->show_events();
$HomeGlobal->show_news_picture();
$HomeGlobal->show_global_hotarticles();
$HomeGlobal->show_latest_box();
//------------------------------------

$SiteMap = new SiteMap;

class SiteMap
{
	var $number		= 1;
	var $cat_count	= 0;
	var $cat_data	= array();

	function SiteMap(){
		global $Info;

		$Info->tpl_main	= "sitemap";
		$this->view_sitemap();
	}

	function view_sitemap(){
		global $Func, $DB, $Template, $Lang, $Info, $HomeGlobal;

		//Get all categories
		$this->cat_count	= $HomeGlobal->cat_count;
		$this->cat_data		= $HomeGlobal->cat_data;
		$this->show_cat(0);

		$Template->set_vars(array(
			'L_EXPAND_ALL'		=> $Lang->data['general_expand_all'],
			'L_COLLAPSE_ALL'	=> $Lang->data['general_collapse_all'],
			'BROWSER_NAVIGATOR'	=> ' - '. $Lang->data['general_sitemap'],
		));
	}

	function show_cat($parent_id){
		global $Template, $Func, $HomeGlobal, $Info;

		for ($i=0; $i<$this->cat_count; $i++){
			if ( $this->cat_data[$i]['cat_parent_id'] == $parent_id ){
				$code_path	= $this->cat_data[$i]['cat_code'];
				if ( $this->cat_data[$i]['cat_parent_id'] && $Info->option['short_url_enabled'] ){
					$HomeGlobal->get_code_path($code_path, $this->cat_data[$i]['cat_parent_id']);
				}

				if ( !empty($this->cat_data[$i]['redirect_url']) ){
					$u_view	= (@substr($this->cat_data[$i]['redirect_url'], 0, 7) != 'http://') ? 'http://'. $this->cat_data[$i]['redirect_url'] : $this->cat_data[$i]['redirect_url'];
				}
				else{
					$u_view	= $Func->compile_url(array('mod' => MOD_ARTICLE, 'cat' => $code_path));
				}

				$Template->set_block_vars("maprow", array(
					'ID'			=> $this->cat_data[$i]['cat_id'],
					'PARENT_ID'		=> $this->cat_data[$i]['cat_parent_id'],
					'CAT_NAME'		=> addslashes($this->cat_data[$i]['cat_name']),
//					'U_VIEW'		=> !empty($this->cat_data[$i]['redirect_url']) ? $this->cat_data[$i]['redirect_url'] : $Func->compile_url(array('mod' => MOD_ARTICLE, 'cat' => $code_path)),
					'U_VIEW'		=> $u_view,
				));
				$this->show_cat($this->cat_data[$i]['cat_id']);
			}
		}
	}
}

?>