<?php
/* =============================================================== *\
|		Module name:      WEBLINK										|
|																	|
\* =============================================================== */

if (!defined('IN_SITE')){
     die('Hacking attempt!');
}

//Call global functions --------------
$HomeGlobal->cat_menu();
$HomeGlobal->show_poll();
$HomeGlobal->show_logos();
$HomeGlobal->show_events();
$HomeGlobal->show_news_picture();
$HomeGlobal->show_global_hotarticles();
$HomeGlobal->show_latest_box();
//------------------------------------

$WebLink = new WebLink;

class WebLink
{
	function WebLink(){
		global $Func;

		$id		= intval($Func->get_vars('id', 1));
		if ( $id ){
			$this->view_weblink($id);
		}
		else{
			$this->list_weblinks();
		}
	}

	function list_weblinks(){
		global $DB, $Info, $Template, $Lang, $Func;

		$Info->tpl_main		= "weblink_list";

		//Get disabled categories
		$disabled_cats	= $Func->get_disabled_cats("weblink_category");

		//Get all cats
		$where_sql		= sizeof($disabled_cats) ? " WHERE cat_id NOT IN (". implode(",", $disabled_cats) .")" : "";

		//Get cats
		$DB->query('SELECT * FROM '. $DB->prefix .'weblink_category '. $where_sql .' ORDER BY cat_order ASC');
		$cat_count 	= $DB->num_rows();
		$cat_data 	= $DB->fetch_all_array();
		$DB->free_result();

		for ($i=0; $i<$cat_count; $i++){
			if ( $cat_data[$i]['cat_parent_id'] == 0 ){
				$Template->set_block_vars("weblinkcatrow", array(
					'CAT_NAME'	=> $cat_data[$i]['cat_name'],
				));

				//Get links
				$DB->query('SELECT * FROM '. $DB->prefix .'weblink WHERE enabled=1 AND cat_id='. $cat_data[$i]['cat_id'] .' ORDER BY weblink_order ASC');
				$weblink_count	= $DB->num_rows();
				$weblink_data	= $DB->fetch_all_array();
				$DB->free_result();

				for ($j=0; $j<$weblink_count; $j++){
					$Template->set_block_vars('weblinkcatrow:weblinkrow', array(
						'SITE_NAME'		=> $weblink_data[$j]['site_name'],
						'SITE_URL'		=> $weblink_data[$j]['site_url'],
						'SITE_URL2'		=> str_replace('http://', '', $weblink_data[$j]['site_url']),
						'U_VIEW'		=> $Func->compile_url(array('mod' => MOD_WEBLINK, 'id' => $weblink_data[$j]['weblink_id'])),
						'CSS'			=> ($j % 2) ? 'tdtext1' : 'tdtext2',
					));
				}
			}
		}

		$Template->set_vars(array(
			'BROWSER_NAVIGATOR'		=> ' - '. $Lang->data['general_weblink'],
		));
	}

	function view_weblink($id){
		global $DB, $Info, $Template, $Lang, $Func;

		//Get url
		$DB->query('SELECT site_url FROM '. $DB->prefix .'weblink WHERE enabled=1 AND weblink_id='. $id);
		if ( !$DB->num_rows() ){
			die("Not found!!");
		}
		$weblink_info	= $DB->fetch_array();

		//Update hits
		$DB->query('UPDATE '. $DB->prefix .'weblink SET hits=hits+1 WHERE weblink_id='. $id);

		header("location: ". $weblink_info['site_url']);
	}
}

?>