<?php
/*========================================================================*\
|| ###################################################################### ||
|| # vBCMS Version 1.3.0
|| # ------------------------------------------------------------------ # ||
|| # Copyright  2002 - 2008 Reuter & Bloe GbR.                          ||
|| # ------------------- VBCMS IS NOT FREE SOFTWARE ------------------- # ||
|| # http://www.vbdesigns.de | http://www.vbdesigns.de/license.html     # ||
|| ###################################################################### ||
\*========================================================================*/

if(!class_exists('vB_DataManager'))
{
        exit;
}

require_once(DIR . '/includes/adminfunctions.php');

/**
* Class to do data save/delete operations for vBCMS Linkscategories
*
* @package	vBCMS 1.3.0
* @version	$Revision: 1194 $
* @date		$Date: 2008-09-16 12:54:59 +0200 (Di, 16. Sep 2008) $
*/
class vB_DataManager_vbcmslinks extends vB_DataManager
{
        /**
        * Array of recognised and required fields for vbcmslinkscats, and their types
        *
        * @var	array
        */
        var $validfields = array(
                'catid'            => array(TYPE_UINT,       REQ_INCR,  VF_METHOD, 'verify_nonzero'),
                'styleid'          => array(TYPE_INT,        REQ_NO,    'if ($data == 0) { $data = 0; } return true;'),
                'options'          => array(TYPE_ARRAY_BOOL, REQ_AUTO),
                'position'         => array(TYPE_INT,        REQ_NO),
                'commentcount'     => array(TYPE_INT,        REQ_NO),
                'lastlinkid'       => array(TYPE_INT,        REQ_NO),
                'lastlinkuserid'   => array(TYPE_INT,        REQ_NO),
                'lastlinkusername' => array(TYPE_STR,        REQ_NO),
                'lastlinktitle'    => array(TYPE_STR,        REQ_NO),
                'lastlinkdate'     => array(TYPE_INT,        REQ_NO),
                'linkscount'       => array(TYPE_INT,        REQ_NO),
                'lastcomid'        => array(TYPE_INT,        REQ_NO),
                'lastcomlinkid'    => array(TYPE_INT,        REQ_NO),
                'lastcomtitle'     => array(TYPE_STR,        REQ_NO),
                'lastcomuserid'    => array(TYPE_INT,        REQ_NO),
                'lastcomusername'  => array(TYPE_STR,        REQ_NO),
                'lastcomdate'      => array(TYPE_INT,        REQ_NO),
                'newpostemail'     => array(TYPE_STR,        REQ_NO,    VF_METHOD, 'verify_emaillist'),
                'newlinkemail'     => array(TYPE_STR,        REQ_NO,    VF_METHOD, 'verify_emaillist'),
                'sub'              => array(TYPE_INT,        REQ_NO,    VF_METHOD),
                'parent'           => array(TYPE_STR,        REQ_NO),
                'breads'           => array(TYPE_STR,        REQ_NO),
                'catpic'           => array(TYPE_STR,        REQ_NO)
        );

        /**
        * Array of field names that are bitfields, together with the name of the variable in the registry with the definitions.
        * For example: var $bitfields = array('options' => 'bf_misc_useroptions', 'permissions' => 'bf_misc_moderatorpermissions')
        *
        * @var	array
        */
        var $bitfields = array('options' => 'bf_misc_VBCMSLINKOPTIONS');

        /**
        * The main table this class deals with
        *
        * @var	string
        */
        var $table = 'vbcmslinkscats';

        /**
        * Array to store stuff to save to vbcmslinkscats table
        *
        * @var	array
        */
        var $vbcmslinkscats = array();

        /**
        * Condition template for update query
        *
        * @var	array
        */
        var $condition_construct = array('catid = %1$d', 'catid');

        /**
        * Constructor - checks that the registry object has been passed correctly.
        *
        * @param	vB_Registry	Instance of the vBulletin data registry object - expected to have the database object as one of its $this->db member.
        * @param	integer		One of the ERRTYPE_x constants
        */
        function vB_DataManager_vbcmslinks(&$registry, $errtype = ERRTYPE_STANDARD)
        {
                parent::vB_DataManager($registry, $errtype);

                ($hook = vBulletinHook::fetch_hook('vbcms_linkdata_start')) ? eval($hook) : false;
        }

        /**
        * Validates multiple titles an descriptions for the languages
        *
        * @param     array     with titleinfos
        * @param     array     with descriptioninfos
        *
        * @return	 boolean   Returns
        */
        function verify_inputlang_arrays(&$title)
        {
                global $vbcms_global;

                if(empty($title[$vbcms_global['langid']]))
                {
                        $this->error('l_add_error_title');
                        return false;
                }
                return true;
        }

        /**
        * Validates a space-separated list of email addresses, prevents duplicates etc.
        *
        * @param	string	Whitespace-separated list of email addresses
        *
        * @return	boolean
        */
        function verify_emaillist(&$emails)
        {
                $emaillist = array();

                foreach(preg_split('#\s+#s', $emails, -1, PREG_SPLIT_NO_EMPTY) AS $email)
                {
                        if ($this->verify_email($email))
                        {
                                $emaillist["$email"] = $email;
                        }
                }

                $emails = implode(' ', $emaillist);

                return true;
        }

        /**
        * Verifies that the parent category specified exists and is a valid parent for this category
        *
        * @param	integer	Parent category ID
        *
        * @return	boolean	Returns true if the parent id is valid, and the parent forum specified exists
        */
        function verify_sub(&$parentid)
        {
                if($parentid === $this->fetch_field('catid'))
                {
                        $this->error('cant_parent_forum_to_self');
                        return false;

                }else if($parentid == 0){

                        $parentid = 0;
                        return true;

                }else if($this->condition !== null){

                        return $this->is_subcat_of($this->fetch_field('catid'), $parentid);
                }else{

                        return true;
                }
        }

        /**
        * Verifies that a given category parent id is not one of its own children
        *
        * @param	integer	The ID of the current category
        * @param	integer	The ID of the category's proposed parentid
        *
        * @return	boolean	Returns true if the children of the given parent category does not include the specified forum... or something
        */
        function is_subcat_of($catid, $parentid)
        {
                $cache = $this->dbobject->query_first_slave("
                        SELECT
                        parent
                        FROM " . TABLE_PREFIX . "vbcmslinkscats
                             WHERE catid = " . $catid . "
                ");

                if(in_array($parentid, explode(',' , $cache['parent'])))
                {
                        $this->error('vbcms_cant_cat_to_child');
                        return false;
                }
                return true;
        }

        /**
        * Any checks to run immediately before saving. If returning false, the save will not take place.
        *
        * @param	boolean	Do the query?
        *
        * @return	boolean	True on success; false if an error occurred
        */
        function pre_save($doquery = true)
        {
                if($this->presave_called !== null)
                {
                        return $this->presave_called;
                }

                $return_value = true;
                ($hook = vBulletinHook::fetch_hook('vbcms_linkdata_presave')) ? eval($hook) : false;

                $this->presave_called = $return_value;
                return $return_value;
        }

        /**
        * Additional data to update after a save call (such as denormalized values in other tables).
        * In batch updates, is executed for each record updated.
        *
        * @param	boolean	Do the query?
        */
        function post_save_each($doquery = true)
        {
                // Nothing at the moment
                ($hook = vBulletinHook::fetch_hook('vbcms_linkdata_postsave')) ? eval($hook) : false;
        }

        /**
        * Additional data to update after a save call (such as denormalized values in other tables).
        * In batch updates, is executed once after all records are updated.
        *
        * @param	boolean	Do the query?
        */
        function post_save_once($doquery = true)
        {
                if(empty($this->info['update_parents']))
                {
                        $this->update_parents();
                }
        }

        /**
        * Save multiple titles an descriptions for the languages
        *
        * @param     array with titleinfos
        * @param     array with descriptioninfos
        * @param     int the insertid for insertquery
        */
        function save_language_arrays($title, $description, $insertid = 0)
        {
                $queryset = $querywhere = $queryinto = $queryvalues = '';
                ($hook = vBulletinHook::fetch_hook('vbcms_linkdata_language_start')) ? eval($hook) : false;

                if($this->condition)
                {
                        foreach($this->registry->languagecache AS $language)
                        {
                                if($havelang = $this->dbobject->query_first("SELECT * FROM " . TABLE_PREFIX . "vbcmslinkscatslang WHERE linkcatid = " . $this->fetch_field('catid') . " AND langid = " . intval($language['languageid']) . ""))
                                {
                                        $this->dbobject->query_write("
                                                UPDATE " . TABLE_PREFIX . "vbcmslinkscatslang
                                                SET
                                                   langtitle = '" . $this->dbobject->escape_string(convert_to_valid_html($title["$language[languageid]"])) . "',
                                                   langdesc = '" . $this->dbobject->escape_string(convert_to_valid_html($description["$language[languageid]"])) . "'
                                                $queryset
                                                WHERE linkcatid = " . $this->fetch_field('catid') . " AND langid = " . intval($language['languageid']) . " $querywhere
                                        ");
                                }else{
                                        $this->dbobject->query_write("
                                                INSERT
                                                INTO " . TABLE_PREFIX . "vbcmslinkscatslang
                                                        (id, langtitle, langdesc, langid, linkcatid $queryinto)
                                                VALUES
                                                        ('', '" . $this->dbobject->escape_string(convert_to_valid_html($title["$language[languageid]"])) . "', '" . $this->dbobject->escape_string(convert_to_valid_html($description["$language[languageid]"])) . "', " . intval($language['languageid']) . ", " . intval($insertid) . ")
                                        ");
                                }
                        }
                }else{
                        foreach($this->registry->languagecache AS $language)
                        {
                                $lang_query[] = "('', '" . $this->dbobject->escape_string(convert_to_valid_html($title["$language[languageid]"])) . "', '" . $this->dbobject->escape_string(convert_to_valid_html($description["$language[languageid]"])) . "', " . intval($language['languageid']) . ", " . intval($insertid) . " $queryvalues)";
                        }
                        // Build Language entrys
                        $this->dbobject->query_write("
                                INSERT
                                INTO " . TABLE_PREFIX . "vbcmslinkscatslang
                                      (id, langtitle, langdesc, langid, linkcatid $queryinto)
                                VALUES
                                      " . implode(',', $lang_query) . "
                        ");
                }

                ($hook = vBulletinHook::fetch_hook('vbcms_linkdata_language_end')) ? eval($hook) : false;

                if(empty($this->info['make_no_cache']))
                {
                        if(!function_exists('cache_linkcategorys'))
                        {
                                require_once(DIR . '/includes/vbcms_link_functions.php');
                        }
                        cache_linkcategorys();
                }

                return true;
        }

        /**
        * Updtate the parentfield
        *
        */
        function update_parents()
        {
                global $parent, $breads;

                $subs = array();
                $subs_quer = $this->dbobject->query_read_slave("
                        SELECT
                        *
                        FROM " . TABLE_PREFIX . "vbcmslinkscats
                ");

                while($subs_row = $this->dbobject->fetch_array($subs_quer))
                {
                        $subs[] = $subs_row;
                }
                $this->dbobject->free_result($subs_quer);

                if($subs[0])
                {
                        foreach($subs AS $key)
                        {
                                $parent = $breads = array();
                                $parent[] = $breads[] = $key['catid'];
                                $this->make_rekursive($subs, $key['catid']);
                                $this->make_breads($subs, $key['sub']);
                                $parent = array_unique($parent);
                                $setparent = implode(',', $parent);
                                $setbreads = implode(',', $breads);
                                $parentsql .= "WHEN $key[catid] THEN '$setparent'\n";
                                $breadssql .= "WHEN $key[catid] THEN '$setbreads'\n";
                        }

                        $this->dbobject->query_write("
                                UPDATE " . TABLE_PREFIX . "vbcmslinkscats SET
                                parent = CASE catid
                                     $parentsql
		        	        	ELSE parent
                                END
                        ");

                        $this->dbobject->query_write("
                                UPDATE " . TABLE_PREFIX . "vbcmslinkscats SET
                                breads = CASE catid
                                     $breadssql
		        	        	ELSE breads
                                END
                        ");
                }
        }

        /**
        * Recursive function to sort the parents
        *
        * @param	int     for the key
        * @param    int     for linkid
        *
        * @return   array   with options
        */
        function make_rekursive($each, $linkid)
        {
                global $parent;
                foreach($each AS $sub)
                {
                        if($sub['sub'] == $linkid)
                        {
                                $parent[] = $sub['catid'];
                                $parent = array_merge($parent, explode(',',$sub['parent']));
                                $this->make_rekursive($each, $sub['parent']);
                        }
                }
                return $parent;
        }
        /**
        * Recursive function to sort the breads
        *
        * @param	int     for the key
        * @param    int     for linkid
        *
        * @return   array   with options
        */
        function make_breads($each, $linkid)
        {
                global $breads;
                foreach($each AS $sub)
                {
                        if($sub['catid'] == $linkid)
                        {
                                $breads[] = $sub['catid'];
                                $this->make_breads($each, $sub['sub']);
                        }
                }
                return $breads;
        }
        /**
        * Deletes a category and its associated data from the database
        */
        function delete()
        {
                $categorys = array();
                $categorys = $this->dbobject->query_first("
                        SELECT
                        parent FROM " . TABLE_PREFIX . "vbcmslinkscats
                            WHERE " . $this->condition
                );

                $categorys = $categorys['parent'];

                if(empty($categorys))
                {
                         $this->error('vbcms_invalid_catid_specifed');
                }else{

                         $condition = "catid IN ($categorys)";
                         $condition_language = "linkcatid IN ($categorys)";

                         $linkdata =& datamanager_init('linkentry', $this->registry, ERRTYPE_ARRAY, 'vbcmslinks_entrys');
                         $linkdata->set_info('cat', $this->registry->vbcmslinkscat[$this->registry->GPC['catid']]);
						 $linkdata->delete($condition);

                         $this->db_delete(TABLE_PREFIX, 'vbcmslinkscatslang', $condition_language);
                         $this->db_delete(TABLE_PREFIX, 'vbcmslinkscats', $condition);
                         if(!function_exists('cache_linkcategorys'))
                         {
                                require_once(DIR . '/includes/vbcms_link_functions.php');
                         }
                         cache_linkcategorys();
                         ($hook = vBulletinHook::fetch_hook('vbcms_linkdata_delete')) ? eval($hook) : false;
                }
        }
}

/*======================================================================*\
|| ####################################################################
|| #
|| # SVN: $RCSfile$ - $Revision: 1194 $
|| ####################################################################
\*======================================================================*/
?>