<?php
/*========================================================================*\
|| ###################################################################### ||
|| # vBCMS Version 1.3.0
|| # ------------------------------------------------------------------ # ||
|| # Copyright  2002 - 2008 Reuter & Bloe GbR.                          ||
|| # ------------------- VBCMS IS NOT FREE SOFTWARE ------------------- # ||
|| # http://www.vbdesigns.de | http://www.vbdesigns.de/license.html     # ||
|| # ------------------------------------------------------------------ # ||
|| # Warning: Change the file only if you know what you do!             # ||
|| # Warnung: ndern Sie die Datei nur, wenn Sie wissen was Sie tun!    # ||
|| ###################################################################### ||
\*========================================================================*/
/**
* Fetch the options infos from a catgory return array with infos or false
*
* @param	int     for the catid
* @param    bool    for usecache
*
* @return   mixed
*/
function vbcms_fetch_link_catinfo(&$catid, $chache = true)
{
        global $vbulletin;

        $catid = intval($catid);
        if (!$chache OR !isset($vbulletin->vbcmslinkscat["$catid"]))
        {
                $vbulletin->vbcmslinkscat["$catid"] = $vbulletin->db->query_first_slave("
                        SELECT
                        *
                        FROM " . TABLE_PREFIX . "vbcmslinkscats
                        WHERE catid = $catid
                ");
        }

        if(!$vbulletin->vbcmslinkscat["$catid"])
        {
                return false;
        }

        $vbulletin->vbcmslinkscat["$catid"]['options'] = intval($vbulletin->vbcmslinkscat["$catid"]['options']);

        foreach($vbulletin->bf_misc_VBCMSLINKOPTIONS AS $optionname => $optionval)
        {
                $vbulletin->vbcmslinkscat["$catid"]["$optionname"] = (($vbulletin->vbcmslinkscat["$catid"]['options'] & $optionval) ? 1 : 0);
        }

        return $vbulletin->vbcmslinkscat["$catid"];
}

/**
* Fetch moderator permissions
*
* @param	int      catid
* @param	sring    what for a action we want
*
* @return   mixed
*/
function vbcms_can_moderate_links($catid = false, $action = '')
{
        global $vbulletin, $ismodin;

        if($catid)
        {
                $permcache = $vbulletin->userinfo['vbcmslinkscatspermissions']["$catid"];

                // if user is a administrator
                if(($permcache & $vbulletin->bf_ugp_vbcmslinkscatspermissions['can_admin_links']) OR ($vbulletin->usergroupcache[$vbulletin->userinfo['usergroupid']]['adminpermissions'] & $vbulletin->bf_ugp_adminpermissions['cancontrolpanel']))
                {
                        DEVDEBUG('CatID: User is a Administrator');
                        return true;
                }
                // if user is a supermod
                if(($permcache & $vbulletin->bf_ugp_vbcmslinkscatspermissions['is_super_mod']))
                {
                        DEVDEBUG('CatID: User is a Supermod');
                        return true;

                }
                $parents = explode(',', $vbulletin->vbcmslinkscat[$catid]['breads']);
                if(is_array($parents))
                {
                        foreach($parents AS $ids)
                        {
                                if(empty($modperms))
                                {
                                        $modperms = $vbulletin->vbcmslinksmods[$ids][$vbulletin->userinfo['userid']]['perms'];
                                }
                        }
                }

                if($modperms & $vbulletin->bf_misc_vbcmslinksmoderatorpermissions[$action])
                {
                        DEVDEBUG('CatID: User is a Mod');
                        return true;

                }else{
                        DEVDEBUG('No CatID: User is no Mod');
                        return false;
                }
        }else{
                // if user is a administrator
                if(($vbulletin->usergroupcache[$vbulletin->userinfo['usergroupid']]['adminpermissions'] & $vbulletin->bf_ugp_adminpermissions['cancontrolpanel']))
                {
                        DEVDEBUG('No CatID: User is a Administrator');
                        return true;

                }
                foreach($vbulletin->vbcmslinkscat AS $cat)
                {
                        $permcache = $vbulletin->userinfo['vbcmslinkscatspermissions'][$cat['catid']];

                        if(($permcache & $vbulletin->bf_ugp_vbcmslinkscatspermissions['is_super_mod']))
                        {
                                DEVDEBUG('No CatID: User is a Supermod');
                                return true;
                        }

                        $modperms = $vbulletin->vbcmslinksmods[$cat['catid']][$vbulletin->userinfo['userid']]['perms'];

                        if($modperms & $vbulletin->bf_misc_vbcmslinksmoderatorpermissions[$action])
                        {
                                DEVDEBUG('No CatID: User is a Mod in CatID: ' . $cat['catid']);
                                $return = true;
                        }
                }
                if($return)
                {
                        return $return;

                }else{
				        DEVDEBUG('No CatID: User is no Mod in CatID: ' . $cat['catid']);
                        return false;
                }
        }
}

/**
* Fetch the status image
*
* @param	int   (ref)  catid
* @param    array (ref)  lastentryarray
* @param    array (ref)  catarray
*
* @return   mixed (new|old)
*/
function vbcms_fetch_catimage(&$catid, &$lastentryinfo, &$lastentryinfo_comments, &$catarray)
{
        global $vbulletin;
        if(
           ($lastentryinfo['lastlinkdate'] > $vbulletin->userinfo['lastvisit'] AND $lastentryinfo['lastlinkuserid'] != $vbulletin->userinfo['userid'])
                OR
           ($lastentryinfo_comments['lastcomdate'] > $vbulletin->userinfo['lastvisit'] AND $lastentryinfo_comments['lastcomuserid'] != $vbulletin->userinfo['userid'])
        )
        {
                return 'new';
        }else{
                return 'old';
        }
}

/**
* Recursive function to make output the comma seperated subcats
*
* @param	int     for the parentid
* @param    int     for the depthmark
*
* @return   string  comma seperated subcatlinks
*/
function vbcms_construct_subcat_links($parentid = 0, $depth = 0)
{
        global $vbulletin, $vbphrase, $vbcms_global, $lastentryinfo, $vbcmsoptions, $lastentrysarray, $lastentrysarray_comments, $stylevar;

        if (!$vbulletin->ivbcmslinkscat["$parentid"])
        {
                return false;
        }

        foreach($vbulletin->ivbcmslinkscat["$parentid"] AS $subcatid)
        {
                $subcat = $vbulletin->vbcmslinkscat["$subcatid"];
                $subcatperms = $vbulletin->userinfo['vbcmslinkscatspermissions']["$subcatid"];

                if(!($subcatperms & $vbulletin->bf_ugp_vbcmslinkscatspermissions['can_see_linkscats']) OR !($subcat['options'] & $vbulletin->bf_misc_VBCMSLINKOPTIONS['active']))
		        {
			            continue;
		        }

                $lastentryinfo = $vbulletin->vbcmslinkscat[$lastentrysarray["$subcatid"]];
                $lastentryinfo_comments = $vbulletin->vbcmslinkscat[$lastentrysarray_comments["$subcatid"]];

				$cat['statusicon'] = vbcms_fetch_catimage($subcatid, $lastentryinfo, $lastentryinfo_comments, $subcat);

                $subcatlinks .= '<img class="inlineimg" src="' . $stylevar['imgdir_statusicon'] . '/subforum_' . $cat['statusicon'] . '.gif" alt="" border="0" /> <a href="' . $vbcmsoptions['vbcms_url'] . $vbcmsoptions['vbcms_filename'] . '.php?' . $session['sessionurl'] . 'area=' . $vbcms_global['area'] . '&amp;do=showcat&amp;catid=' . $subcat['catid']. '">' . $vbulletin->vbcmslinkscat["$subcatid"]['langtitle'][$vbcms_global['langid']] . '</a>, ';

				if($depth < $vbulletin->vbcmsoptions['linksarea_subcatdepth'])
				{
                        $subcatlinks .= vbcms_construct_subcat_links($subcatid, $depth + 1);
                }

        }
        return $subcatlinks;
}

/**
* Recursive function to make output the categorys
*
* @param	int     for the parentid
* @param    int     for the depthmark
*
* @return   string  with catbits and subcats
*/
function vbcms_construct_linkcategorys($parentid = 0, $depth = 0, $sub = '')
{
        global $vbulletin, $vbphrase, $catcache, $vbcms_global, $vbcmsoptions, $lastentrysarray, $lastentrysarray_comments, $vbcollapse, $stylevar, $counter;

        if (!$vbulletin->ivbcmslinkscat["$parentid"])
        {
                return false;
        }

        if(!is_array($lastentrysarray))
        {
                vbcms_build_lastcatentrys();
        }
        $catbits = '';
        $depth++;

        foreach($vbulletin->ivbcmslinkscat["$parentid"] AS $catid)
        {
                $cat = $vbulletin->vbcmslinkscat["$catid"];
                $catperms = $vbulletin->userinfo['vbcmslinkscatspermissions']["$catid"];

                if(!($catperms & $vbulletin->bf_ugp_vbcmslinkscatspermissions['can_see_linkscats']) OR !($cat['options'] & $vbulletin->bf_misc_VBCMSLINKOPTIONS['active']))
		        {
			            continue;
		        }
				$vbcms_global['show_subcats'] = true;

				if($depth < $vbulletin->vbcmsoptions['linksarea_catdepth'])
				{
                        $subcatbits = vbcms_construct_linkcategorys($catid, $depth);
				}else{
				        $subcatbits = '';
				}

                if(($cat['options'] & $vbulletin->bf_misc_VBCMSLINKOPTIONS['iscat']))
                {
                        $bitend = '_nolinks';
                }else{
                        $bitend = '_links';
                }

                if($depth == 1 AND  $bitend == '_nolinks')
                {
				        $collapseobj_catid =& $vbcollapse["collapseobj_catbit_$cat[catid]"];
				        $collapseimg_catid =& $vbcollapse["collapseimg_catbit_$cat[catid]"];

				        $show['collapsebutton'] = true;
                }else{
				        $show['collapsebutton'] = false;
				}

			    $lastentryinfo          = (empty($lastentrysarray[$catid]) ? array() : $vbulletin->vbcmslinkscat[$lastentrysarray["$catid"]]);
			    $lastentryinfo_comments = (empty($lastentrysarray_comments[$catid]) ? array() : $vbulletin->vbcmslinkscat[$lastentrysarray_comments["$catid"]]);

                if($depth == $vbulletin->vbcmsoptions['linksarea_catdepth'] AND $vbulletin->vbcmsoptions['linksarea_subcatdepth'] > 0)
                {
                        $cat['subcategories'] = substr(vbcms_construct_subcat_links($catid), 0 , -2);
                }else{
                        $cat['subcategories'] = '';
                }

                $vbcms_global['show_subcategories'] = ($cat['subcategories'] != '' ? true : false);
				$cat['statusicon'] = vbcms_fetch_catimage($catid, $lastentryinfo, $lastentryinfo_comments, $cat);

                if(!($catperms & $vbulletin->bf_ugp_vbcmslinkscatspermissions['can_add_links']) OR !($cat['options'] & $vbulletin->bf_misc_VBCMSLINKOPTIONS['open']))
		        {
			           $cat['statusicon'] .= '_lock';
		        }

                // Build the last link infos
                if(!empty($lastentryinfo['lastlinkid']) AND $vbulletin->vbcmsoptions['linksarea_showlastlink'])
                {
                          if(!($catperms & $vbulletin->bf_ugp_vbcmslinkscatspermissions['can_see_links']) OR ($vbulletin->userinfo['userid'] != $lastentryinfo['lastlinkuserid'] AND !($catperms & $vbulletin->bf_ugp_vbcmslinkscatspermissions['can_see_links_from_other'])))
                          {
                                  $vbcms_global['can_see_lastlinks'] = false;
                                  $lastentryinfo['lastlinktitle'] =& $vbphrase['private'];
                          }else{
                                  $vbcms_global['can_see_lastlinks'] = true;
                                  if($vbulletin->vbcmsoptions['linksarea_lastlinklen'])
                                  {
                                          $lastentryinfo['lastlinktitle'] = fetch_trimmed_title($lastentryinfo['lastlinktitle'], $vbulletin->vbcmsoptions['linksarea_lastlinklen']);
                                  }

                                  $lastentryinfo['lastlinktime'] = vbdate($vbulletin->options['timeformat'], $lastentryinfo['lastlinkdate']);
                                  $lastentryinfo['lastlinkdate'] = vbdate($vbulletin->options['dateformat'], $lastentryinfo['lastlinkdate'], true);
                          }
                }else{
                          $vbcms_global['can_see_lastlinks'] = false;
                          $lastentryinfo['lastlinktitle'] =& $vbphrase['never'];
                }

                // Build the last comments infos
                if(!empty($lastentryinfo_comments['lastcomid']) AND $vbulletin->vbcmsoptions['linksarea_showlastpost'])
                {
                          if(($vbulletin->userinfo['userid'] != $lastentryinfo_comments['lastcomuserid'] AND !($catperms & $vbulletin->bf_ugp_vbcmslinkscatspermissions['can_see_links_from_other'])))
                          {
                                  $vbcms_global['can_see_lastcomments'] = false;
                                  $lastentryinfo_comments['lastcomtitle'] =& $vbphrase['private'];
                          }else{
                                  $vbcms_global['can_see_lastcomments'] = true;
                                  if($vbulletin->vbcmsoptions['linksarea_linksarea_lastpostlen'])
                                  {
                                          $lastentryinfo_comments['lastcomtitle'] = fetch_trimmed_title($lastentryinfo_comments['lastcomtitle'], $vbulletin->vbcmsoptions['linksarea_lastpostlen']);
                                  }

                                  $lastentryinfo_comments['lastcomtime'] = vbdate($vbulletin->options['timeformat'], $lastentryinfo_comments['lastcomdate']);
                                  $lastentryinfo_comments['lastcomdate'] = vbdate($vbulletin->options['dateformat'], $lastentryinfo_comments['lastcomdate'], true);
                          }
                }else{
                          $vbcms_global['can_see_lastcomments'] = false;
                          $lastentryinfo_comments['lastcomtitle'] =& $vbphrase['never'];
                }

                if($vbulletin->vbcmsoptions['linksarea_showcatmoderators'])
                {
                        foreach(explode(',', $cat['breads']) AS $realid)
                        {
                                if(!isset($vbulletin->vbcmslinksmods["$realid"]))
                                {
                                        continue;
                                }
                                foreach($vbulletin->vbcmslinksmods["$realid"] AS $moderator)
                                {
                                        fetch_musername($moderator);
                                        if(!isset($cat['moderators']))
                                        {
                                                eval('$cat[\'moderators\'] = "' . fetch_template('Portal_links_moderator') . '";');
                                        }else{
                                                eval('$cat[\'moderators\'] .= ", ' . fetch_template('Portal_links_moderator') . '";');
                                        }
                                }
                        }
                        if(!isset($cat['moderators']))
                        {
                                $cat['moderators'] = '';
                        }
                }

                $cat['linkscount']   = vb_number_format($counter["$cat[catid]"]['linkscount']);
                $cat['commentcount'] = vb_number_format($counter["$cat[catid]"]['commentcount']);

                eval('$catbits .= "' . fetch_template("Portal_links_catbits_level$depth$bitend") . '";');

        }
        return $catbits;
}

/**
* Build the lastentry array an the counters
*
*
*/
function vbcms_build_lastcatentrys()
{
        global $vbulletin, $lastentrysarray, $lastentrysarray_comments, $counter;

        $counter = $lastentrysarray = $lastentrysarray_comments = array();

        foreach($vbulletin->vbcmslinkscat AS $temp)
        {
                if(!isset($lastentrysarray["$temp[catid]"]))
                {
                        $lastentrysarray["$temp[catid]"] = $temp['catid'];
                }

                foreach(explode(',', $temp['parent']) AS $count)
                {
                        $counter["$temp[catid]"]['linkscount']   += $vbulletin->vbcmslinkscat["$count"]['linkscount'];
                        $counter["$temp[catid]"]['commentcount'] += $vbulletin->vbcmslinkscat["$count"]['commentcount'];
                }
                foreach(explode(',', $temp['breads']) AS $realid)
                {
                        if($temp['lastlinkdate'] > $vbulletin->vbcmslinkscat[$realid]['lastlinkdate'])
				        {
				                $lastentrysarray[$realid] = $temp['catid'];
				                $vbulletin->vbcmslinkscat[$realid]['lastlinkdate'] = $temp['lastlinkdate'];
                        }
                }
        }
        unset($temp);
        foreach($vbulletin->vbcmslinkscat AS $temp)
        {
                if(!isset($lastentrysarray_comments["$temp[catid]"]))
                {
                        $lastentrysarray_comments["$temp[catid]"] = $temp['catid'];
                }
                foreach(explode(',', $temp['breads']) AS $realid)
                {
                        if($temp['lastcomdate'] > $vbulletin->vbcmslinkscat[$realid]['lastcomdate'])
				        {
				                $lastentrysarray_comments[$realid] = $temp['catid'];
                                $vbulletin->vbcmslinkscat[$realid]['lastcomdate'] = $temp['lastcomdate'];
                        }
                }
        }
}

/**
* Recursive function to make output the categorys fo administration
*
* @param	int     for the parentid
* @param    string  for the depthmark
*
* @return   string  with contenttables
*/
function construct_adminlinkcategorys($parentid = 0, $depth = false)
{
        global $vbulletin, $vbphrase, $catcache, $vbcms_global;

        if (!$vbulletin->ivbcmslinkscat["$parentid"])
        {
                return false;
        }

        foreach($vbulletin->ivbcmslinkscat["$parentid"] as $catid)
        {
                $d = $vbulletin->vbcmslinkscat["$catid"];

                if($depth)
                {


                }else{
                        $bo = array(0 => '<b>', 1 => '</b>');
                        $output .= '
                                <tr>
                                      <td class="thead" width="100%">
                                            ' . $vbphrase['vbcms_linksadmin_cat'] . '
                                      </td>
                                      <td class="thead" align="center">
                                            ' . $vbphrase['controls'] . '
                                      </td>
                                      <td class="thead" align="center">
                                            ' . $vbphrase['vbcms_linksadmin_display_order'] . '
                                      </td>
                                      <td class="thead" align="center">
                                            ' . $vbphrase['moderator'] . '
                                      </td>
                                </tr>
                        ';
                }
                $i = 0;
                if(!empty($vbulletin->vbcmslinksmods[$d['catid']]))
                {
                        foreach($vbulletin->vbcmslinksmods[$d['catid']] AS $moderator)
                        {
                                $i++;
                                $d['modselect'] .= '<option value="' . $moderator['modid'] . '">' . $moderator['username'] . '</option>' . "\n";
                        }

                }
                $modselect_first = '<option value="">' . $vbphrase['moderators'] . ' (' . $i . ')</option>' . "\n";
                $output .= '
                        <tr>
                              <td class="alt1">
                                    <a name="cat' . $d['catid'] . '"></a>' . $depth . $bo[0] . '<a href="' . $vbulletin->vbcmsoptions['vbcms_url'] . $vbulletin->vbcmsoptions['vbcms_filename'] . '.php?' . $vbulletin->session->vars['sessionurl'] . 'area=' . $vbcms_global['area'] . '&amp;do=managecats&amp;show=editcat&amp;catid=' . $d['catid'] . '">' . $d['langtitle']["$vbcms_global[langid]"] . '</a>' . $bo[1] . '
                              </td>
                              <td class="alt2" align="center">
                                    <select name="catselect' . $d['catid'] . '" onchange="cat_jump(' . $d['catid'] . ');" >
                                            <option value="catedit">' . $vbphrase['vbcms_linksadmin_catedit'] . '</option>
                                            <option value="catview">' . $vbphrase['vbcms_linksadmin_catview'] . '</option>
                                            <option value="catdelete">' . $vbphrase['vbcms_linksadmin_catdelete'] . '</option>
                                            <option value="cataddsub">' . $vbphrase['vbcms_linksadmin_cataddsub'] . '</option>
                                            <option value="catperms">' . $vbphrase['view_permissions'] . '</option>
                                            <option value="addmoderator">' . $vbphrase['add_moderator'] . '</option>
                                    </select><input type="button" class="button" value="' . $vbphrase['go'] . '" onclick="cat_jump(' . $d['catid'] . ');" />
                              </td>
                              <td class="alt1" align="center">
                                    <input type="text" size="1" name="position_def[' . $d['catid'] . ']" value="' . $d['position'] . '" />
                              </td>
                              <td class="alt2" align="center">
                                    <select name="modselect' . $d['catid'] . '" onchange="mod_jump(' . $d['catid'] . ');" >
                                            ' . $modselect_first . $d['modselect'] . '
                                            <option value="add">' . $vbphrase['add_moderator'] . '</option>
                                    </select><input type="button" class="button" value="' . $vbphrase['go'] . '" onclick="mod_jump(' . $d['catid'] . ');" />
                              </td>

                        </tr>';
                $output .= construct_adminlinkcategorys($catid, $depth . '- - ');
        }

        return $output;
}

/**
* Recursive function to make output the permissions
*
* @param	int     for the parentid
* @param    string  for the depthmark
*
* @return   string  with HTML formatted <ul> list
*/
function vbcms_list_linkscatpermissions($parentid = 0, $depth = '    ')
{
        global $vbulletin, $vbphrase, $vbcms_global, $catinfo;
        static $catcache;

        if($parentid == 0)
        {
                $catcache = array();
                foreach($vbulletin->vbcmslinkscat AS $catid => $cat)
                {
                        $catcache["$cat[sub]"]["$catid"] =& $vbulletin->vbcmslinkscat["$catid"];
                }
        }

        if(is_array($catcache["$parentid"]))
        {
                foreach($catcache["$parentid"] AS $key => $d)
                {
                        $output .= "\r" . $depth . '<ul>'. "\r";

                        $output .= $depth . '<li><a name="cat' . $d['catid'] . '"></a> <a href="' . $vbulletin->vbcmsoptions['vbcms_url'] . $vbulletin->vbcmsoptions['vbcms_filename'] . '.php?' . $vbulletin->session->vars['sessionurl'] . 'area=' . $vbcms_global['area'] . '&amp;do=managecats&amp;show=editcat&amp;catid=' . $d['catid'] . '" ><b>' . $d['langtitle']["$vbcms_global[langid]"] . '</b></a> <span class="smallfont">( [<a href="' . $vbulletin->vbcmsoptions['vbcms_url'] . $vbulletin->vbcmsoptions['vbcms_filename'] . '.php?' . $vbulletin->session->vars['sessionurl'] . 'area=' . $vbcms_global['area'] . '&amp;do=managecats&amp;show=permission_reset&amp;catid=' . $d['catid'] . '" >' . $vbphrase['reset'] . '</a>] )</span>'. "\r" . $depth . '<ul>';

                        foreach($vbulletin->usergroupcache AS $usergroupid => $usergroup)
                        {
                                if($vbulletin->vbcmslinksperms[$d['catid']][$usergroupid])
                                {
                                        $mark = array(0 => 'style="color:#FF0000;"');

                                        if($vbulletin->vbcmslinksperms[$d['catid']]['sub'])
                                        {
                                                $mark = array(0 => 'style="color:#E59700;"');
                                        }
                                }else{
                                        $mark = array();
                                }

                                $output .= "\r" . '<li ' . $mark[0] . '><span class="smallfont">[<a ' . $mark[0] . ' href="' . $vbulletin->vbcmsoptions['vbcms_url'] . $vbulletin->vbcmsoptions['vbcms_filename'] . '.php?' . $vbulletin->session->vars['sessionurl'] . 'area=' . $vbcms_global['area'] . '&amp;do=managecats&amp;show=permissions_edit&amp;catid=' . $d['catid'] . '&amp;usergroupid=' . $usergroupid . '">' . $vbphrase['edit'] . '</a>] ' . $usergroup['title'] . '</span></li>';
                        }

                        $output .= "\r" . $depth . '</ul><br />';

                        $output .= vbcms_list_linkscatpermissions($key, "$depth    ");

                        $output .= "\r" . $depth . '</li>';
                        $output .= "\r" . $depth . '</ul>'. "\r";

                        if(!$d['sub'])
                        {
                                $output .= "\r" . $depth . '<hr size="1" />';
                        }
                }
        }
        return $output;
}

/**
* Recursive function to make output the selectfield
*
* @param	int     for the parentid
* @param    string  for the depthmark
*
* @return   mixed
*/
function vbcms_fetch_linkscatselect($parentid = 0, $depth = false)
{
        global $vbulletin, $vbphrase, $vbcms_global, $catinfo;
        static $catcache;

        if($parentid == 0)
        {
                $catcache = array();
                foreach($vbulletin->vbcmslinkscat AS $catid => $cat)
                {
                        $catcache["$cat[sub]"]["$catid"] =& $vbulletin->vbcmslinkscat["$catid"];
                }
        }

        if(is_array($catcache["$parentid"]))
        {
                foreach($catcache["$parentid"] AS $key => $d)
                {
                        $catperms = $vbulletin->userinfo['vbcmslinkscatspermissions'][$d['catid']];

                        if(!($catperms & $vbulletin->bf_ugp_vbcmslinkscatspermissions['can_see_linkscats']) OR !($d['options'] & $vbulletin->bf_misc_VBCMSLINKOPTIONS['active']))
		                {
			                    continue;
		                }

                        $output .= '<option value="' . $d['catid'] . '" ' . (($d['sub'] == 0) ? 'class="fjdpth0"' : '') . ' ' . (($catinfo['sub'] == $d['catid']) ? 'selected="selected"' : '') .'>' . $depth . $d['langtitle']["$vbcms_global[langid]"] . '</option>';
                        $output .= vbcms_fetch_linkscatselect($key, $depth . '&nbsp;&nbsp;&nbsp;');
                }
        }
        return $output;
}


/**
* Make the ivbcmslinkscat and put the counters in the vbcmslinkscat array
*
* @param   boolean   put counters in the catcache or not
* @param   boolean   at moment nothing
*
*
*/
function vbcms_cache_cats($counters = 0, $userid = 0)
{
        global $vbulletin;

        if($counters)
        {
                if($userid)
                {
                        $query = "";
                }else{
                        $query = "
                                SELECT
                                catid, lastlinkid, catpic, linkscount, commentcount,
                                lastlinktitle, lastlinkuserid, lastlinkusername,
                                lastlinkdate, lastcomid, lastcomlinkid, lastcomtitle, lastcomuserid,
                                lastcomusername, lastcomdate
                                FROM " . TABLE_PREFIX . "vbcmslinkscats
                        ";
                }
        }
        if($query !== null)
        {
                $catquer = $vbulletin->db->query_read_slave($query);
                if($vbulletin->db->num_rows($catquer))
                {
                        while($catrow = $vbulletin->db->fetch_array($catquer))
                        {
                                if(empty($vbulletin->vbcmslinkscat["$catrow[catid]"]))
                                {
									$vbulletin->vbcmslinkscat["$catrow[catid]"] = $catrow;
                                }else{
									$vbulletin->vbcmslinkscat["$catrow[catid]"] = $catrow + $vbulletin->vbcmslinkscat["$catrow[catid]"];
								}
                        }
                }
        }

        $vbulletin->ivbcmslinkscat = array();

        foreach ($vbulletin->vbcmslinkscat AS $catid => $cat)
        {
                $cat['sub'] = intval($cat['sub']);
                $vbulletin->ivbcmslinkscat["$cat[sub]"]["$catid"] = $catid;
        }
}

/**
* Function to put the linkscatpermissions in the $vbulletin->userinfo array
*
* @param	ref     userinfo
*
* @return   array   userinfo + permissions
*/
function vbcms_fetch_linkscatpermissions(&$user)
{
        global $vbulletin;
        foreach($vbulletin->vbcmslinkscat AS $catid => $cat)
        {
                foreach($vbulletin->usergroupcache AS $key => $value)
                {
                        // Default Catpermissions from the usergroupcache
                        $vbulletin->vbcmslinkscat["$catid"]['permissions']["$key"] = $value['vbcmslinkscatspermissions'];

                        // Specified Catpermissions
                        if(isset($vbulletin->vbcmslinksperms["$catid"]["$key"]))
                        {
                                foreach(explode(',', $cat['parent']) AS $realid)
                                {
                                        if(!$vbulletin->vbcmslinksperms["$realid"]["$key"])
                                        {
                                                $vbulletin->vbcmslinkscat["$realid"]['permissions']["$key"] = $vbulletin->vbcmslinksperms["$catid"]["$key"];
                                                $vbulletin->vbcmslinksperms["$realid"]["$key"] = $vbulletin->vbcmslinksperms["$catid"]["$key"];
                                                $vbulletin->vbcmslinksperms["$realid"]['sub'] = 1;
                                        }
                                }
                                $vbulletin->vbcmslinkscat["$catid"]['permissions']["$key"] = $vbulletin->vbcmslinksperms["$catid"]["$key"];
                        }
                }
        }

	    $groupids = fetch_membergroupids_array($user);

        foreach($vbulletin->vbcmslinkscat AS $catid => $cat)
        {
                if(!isset($user['vbcmslinkscatspermissions']["$catid"]))
                {
					$user['vbcmslinkscatspermissions']["$catid"] = 0;
                }
                foreach($groupids AS $usergroupid)
		        {
                        $user['vbcmslinkscatspermissions']["$catid"] |= $vbulletin->vbcmslinkscat["$catid"]['permissions']["$usergroupid"];
                }
        }
        return $user['permissions'];
}

/**
* make the categorycache $vbulletin->vbcmslinkscat
*/
function cache_linkcategorys()
{
        global $vbulletin;

        $cache         = array();
        $lang_row      = array();
        $lang_row_desc = array();

        $l_query = $vbulletin->db->query_read_slave("
                SELECT
                langid, linkcatid, langtitle, langdesc
                FROM " . TABLE_PREFIX . "vbcmslinkscatslang
        ");

        while($l_row = $vbulletin->db->fetch_array($l_query))
        {
                $lang_row["$l_row[linkcatid]"]["$l_row[langid]"] = $l_row['langtitle'];
                $lang_row_desc["$l_row[linkcatid]"]["$l_row[langid]"] = $l_row['langdesc'];
        }
        $vbulletin->db->free_result($l_query);

        $link_quer = $vbulletin->db->query_read("
                SELECT
                catid, sub, parent, breads, styleid, position, options, newpostemail, newlinkemail
                FROM " . TABLE_PREFIX . "vbcmslinkscats
                ORDER BY position ASC
        ");

        while($link_row = $vbulletin->db->fetch_array($link_quer))
        {
                if($lang_row["$link_row[catid]"])
                {
                        $link_row['langtitle'] = $lang_row["$link_row[catid]"];
                        $link_row['langdesc']  = $lang_row_desc["$link_row[catid]"];
                }

                $cache["$link_row[catid]"] = $link_row;
        }
        $vbulletin->db->free_result($link_quer);
        build_datastore('vbcmslinkscat', serialize($cache), 1);
}
/*======================================================================*\
|| ####################################################################
|| #
|| # SVN: $RCSfile$ - $Revision: 1194 $
|| ####################################################################
\*======================================================================*/
?>