<?php
/*======================================================================*\
|| #################################################################### ||
|| #                  pages v 1.0               # ||
|| #              for vBulletin Version 3.6.8                         # ||
|| #              http://www.alghat.com            # ||
|| #               /                                      # ||
|| #################################################################### ||
\*======================================================================*/
// ######################## SET PHP ENVIRONMENT ###########################
error_reporting(E_ALL & ~E_NOTICE);

// ##################### DEFINE IMPORTANT CONSTANTS #######################
define('CVS_REVISION', '$RCSfile: pagecp.php,v $ - $Revision: 3.8 $');
define('NO_REGISTER_GLOBALS', 1);
define('THIS_SCRIPT', 'pagecp');

// ################### PRE-CACHE TEMPLATES AND DATA ######################
$phrasegroups = array();
$specialtemplates = array();
$globaltemplates = array();
$actiontemplates = array();

// ########################## REQUIRE BACK-END ############################
require_once('./global.php');

// ######################## CHECK ADMIN PERMISSIONS #######################
if (!in_array($vbulletin->userinfo['userid'], preg_split('#\s*,\s*#s', $vbulletin->config['SpecialUsers']['superadministrators'], -1, PREG_SPLIT_NO_EMPTY)))
{
	print_cp_no_permission();
}

// ############################# LOG ACTION ###############################
log_admin_action($_REQUEST['do'] . iif(intval($_REQUEST['pageid']) != 0, " pageid = $_REQUEST[pageid]"));

// ########################################################################
// ######################### START MAIN SCRIPT ############################
// ########################################################################

print_cp_header($vbphrase['pages_manager']);

if (empty($_REQUEST['do']))
{
	$_REQUEST['do'] = 'manage';
}

// ###################### Start manage #######################
if ($_REQUEST['do'] == "manage")
{
	$pages = $db->query_read("
		SELECT * FROM " . TABLE_PREFIX . "pages_default
		ORDER BY pageid
	");

	print_form_header(THIS_SCRIPT, 'add');
	print_table_header($vbphrase['pages_manager'], 6);
	$headings = array();
	$headings[] = "id";
	$headings[] = $vbphrase['page_url'];
	$headings[] = $vbphrase['page_title'];
	$headings[] = $vbphrase['page_dateline'];
	$headings[] = $vbphrase['count_visit'];
	$headings[] = $vbphrase['options'];
	print_cells_row($headings, 1, 0, 1);
	$cell = array();
	while ($page = $db->fetch_array($pages))
	{
		$cell[] = $page['pageid'];
		$cell[] = "<a target=\"_blank\" href=\"" . $vbulletin->options['bburl'] . "/page.php?do=" . $page['varname'] . "\">" . $page['varname'] . "</a>";
		$cell[] = $page['title'];
		$cell[] = vbdate($vbulletin->options['dateformat'], $page['dateline'], 1).'&nbsp;'.vbdate($vbulletin->options['timeformat'], $page['dateline']);;
		$cell[] = $page['countvisit'];
		$cell[] = "
		<a href=\"" . THIS_SCRIPT . ".php?do=edit&pageid=" . $page['pageid'] . "\"></a>
		<a href=\"" . THIS_SCRIPT . ".php?do=empty&pageid=" . $page['pageid'] . "\"></a>
		<a href=\"" . THIS_SCRIPT . ".php?do=remove&pageid=" . $page['pageid'] . "\"></a>
		<a href=\"" . THIS_SCRIPT . ".php?do=stats&pageid=" . $page['pageid'] . "\"></a>
		";
		print_cells_row($cell, 0, 0, 1);
		unset($cell);
	}
	print_submit_row('  ', 0, 6);
	print_table_footer();
}

// ###################### Start add #######################
elseif ($_REQUEST['do'] == "add" OR $_REQUEST['do'] == "edit")
{
	?>
	<script type="text/javascript">
	function check_all_usergroups(formobj, toggle_status)
	{
		for (var i = 0; i < formobj.elements.length; i++)
		{
			var elm = formobj.elements[i];
			if (elm.type == "checkbox" && elm.name == 'groupids[]')
			{
				elm.checked = toggle_status;
			}
		}
	}
	</script>
	<?

	$vbulletin->input->clean_gpc('r', 'pageid', TYPE_INT);

	if($vbulletin->GPC['pageid'])
	{
		$pages = $db->query_first("
			SELECT * FROM " . TABLE_PREFIX . "pages_default
			WHERE pageid = " . $vbulletin->GPC['pageid']
		);
	}

	print_form_header(THIS_SCRIPT, "save", $vbphrase['pages_manager']);
	construct_hidden_code("pageid", $vbulletin->GPC['pageid']);
	print_table_header($vbphrase['page_' . $_REQUEST['do']]);
	print_input_row($vbphrase['page_title'], "title", $pages['title']);
	print_input_row($vbphrase['page_varname'], "varname", $pages['varname']);
	print_textarea_row($vbphrase['page_text'], "text", $pages['text'], 20, 80, true, true, 'ltr');
	print_radio_row('    ', 'bbcode', array(0 => 'HTML', 1 => 'bbcode'), $pages['bbcode']);
	print_checkbox_row($vbphrase['all_usergroups'], 'usergroup_all', 0, -1, $vbphrase['all_usergroups'], 'check_all_usergroups(this.form, this.checked);');
	print_membergroup_row('   ', 'groupids', 2, array('membergroupids' => $pages['groupids']));
	print_submit_row($vbphrase['save'], 0);
}

// ###################### Start Save #######################
elseif ($_POST['do'] == "save")
{
	$vbulletin->input->clean_array_gpc('p', array(
		'pageid'	=> TYPE_INT,
		'bbcode'	=> TYPE_INT,
		'title'		=> TYPE_STR,
		'varname'	=> TYPE_STR,
		'text'		=> TYPE_STR,
		'groupids'	=> TYPE_ARRAY_INT
	));

	foreach($vbulletin->GPC['groupids'] AS $group)
	{
		if (empty($groupsid))
		{
			$groupsid = $group;
		}
		else
		{
			$groupsid .= ',' . $group;
		}
	}

	if (preg_match('#^[a-z0-9_]+$#s', $vbulletin->GPC['varname']))
	{
		if($vbulletin->GPC['pageid'])
		{
			$db->query_write("
				UPDATE " . TABLE_PREFIX . "pages_default
				SET title = '" . $db->escape_string($vbulletin->GPC['title']) . "',
					varname = '" . $db->escape_string($vbulletin->GPC['varname']) . "',
					text = '" . $db->escape_string($vbulletin->GPC['text']) . "',
					bbcode = " . $vbulletin->GPC['bbcode'] . ",
					groupids = '" . $groupsid . "'
				WHERE pageid = " . $vbulletin->GPC['pageid']
			);
		}
		else
		{
			$db->query_write("
				INSERT INTO " . TABLE_PREFIX . "pages_default
					(title, varname, text, bbcode, groupids, dateline)
				VALUES
				(
					'" . $db->escape_string($vbulletin->GPC['title']) . "',
					'" . $db->escape_string($vbulletin->GPC['varname']) . "',
					'" . $db->escape_string($vbulletin->GPC['text']) . "',
					" . $vbulletin->GPC['bbcode'] . ",
					'" . $groupsid . "',
					" . TIMENOW . "
				)
			");
		}
		print_cp_message($vbphrase['page_saved'], THIS_SCRIPT . ".php?do=manage");
	}
	else
	{
		print_stop_message('varname_invalid');
	}
}

// ###################### Start Remove #######################
elseif ($_REQUEST['do'] == "remove" OR $_REQUEST['do'] == "empty")
{
	$vbulletin->input->clean_gpc('r', 'pageid', TYPE_INT);

	$title = $db->query_first("
		SELECT title FROM " . TABLE_PREFIX . "pages_default
		WHERE pageid = " . $vbulletin->GPC['pageid']
	);

	print_form_header(THIS_SCRIPT, "kill", $vbphrase['pages_manager']);
	construct_hidden_code('pageid', $vbulletin->GPC['pageid']);
	construct_hidden_code('kill', iif($_REQUEST['do'] == "remove", 1, 0));
	print_table_header($title['title']);
	print_description_row("
	<blockquote><br />
	" . construct_phrase($vbphrase[iif($_REQUEST['do'] == "remove", 'del', 'emp') . '_page'], $title['title'], $vbulletin->GPC['pageid'], '') . "
	<br /></blockquote>\n\t");
	print_submit_row($vbphrase['yes'], 0, 2, $vbphrase['no']);
}

// ###################### Start Kill #######################
elseif ($_POST['do'] == "kill")
{
	$vbulletin->input->clean_array_gpc('p', array(
		'pageid'	=> TYPE_INT,
		'kill'		=> TYPE_INT
	));

	if ($vbulletin->GPC['kill'])
	{
		$db->query_write("DELETE FROM " . TABLE_PREFIX . "pages_default WHERE pageid = " . $vbulletin->GPC['pageid']);
		$db->query_write("DELETE FROM " . TABLE_PREFIX . "pages_visitor WHERE pagesid = " . $vbulletin->GPC['pageid']);
		print_cp_message($vbphrase['page_deleted'], THIS_SCRIPT . ".php?do=manage");
	}
	else
	{
		$db->query_write("UPDATE " . TABLE_PREFIX . "pages_default SET countvisit = 0 WHERE pageid = " . $vbulletin->GPC['pageid']);
		$db->query_write("DELETE FROM " . TABLE_PREFIX . "pages_visitor WHERE pagesid = " . $vbulletin->GPC['pageid']);
		print_cp_message($vbphrase['page_emptied'], THIS_SCRIPT . ".php?do=manage");
	}
}

###################### Start stats ########################
elseif ($_REQUEST['do'] == "stats")
{
	$vbulletin->input->clean_array_gpc('r', array(
		'pageid'	=> TYPE_INT,
		'orderby'	=> TYPE_STR,
		'ascdesc'	=> TYPE_STR
	));

	$pages = $db->query_read("
		SELECT *, username FROM " . TABLE_PREFIX . "pages_default
		LEFT JOIN " . TABLE_PREFIX . "pages_visitor AS pages_visitor ON(pages_default.pageid = pages_visitor.pagesid)
		LEFT JOIN " . TABLE_PREFIX . "user AS user ON(user.userid = pages_visitor.visitors)
		WHERE pages_visitor.pagesid = " . $vbulletin->GPC['pageid'] . "
		ORDER BY id
	");

	if ($db->num_rows($pages))
	{
		print_form_header('', '');
		while ($page = $db->fetch_array($pages))
		{
			if ($page['pagesid'] != $prevgroup)
			{
				if($prevgroup)
				{
					print_table_break();
				}

				$prevgroup = $page['pagesid'];

				print_table_header($page['title'], 3);
				$headings = array();
				$headings[] = $vbphrase['page_visitor'];
				$headings[] = $vbphrase['page_datevisit'];
				$headings[] = $vbphrase['ip_address'];
				print_cells_row($headings, 1, 0, 1);
			}

			$cell = array();
			$cell[] = iif(!empty($page['visitors']), "<a href=\"user.php?" . $vbulletin->session->vars['sessionurl'] . "do=edit&u=$page[visitors]\">$page[username]</a>", "");
			$cell[] = vbdate($vbulletin->options['dateformat'], $page['dateline'], 1).'&nbsp;'.vbdate($vbulletin->options['timeformat'], $page['dateline']);
			$cell[] = iif($page['ip'], "<a href=\"usertools.php?" . $vbulletin->session->vars['sessionurl'] . "do=gethost&ip=$page[ip]\">$page[ip]</a>", '&nbsp;');
			print_cells_row($cell, 0, 0, 1, 1, 0, 1);
			unset($cell);
		}
		print_table_footer();
	}
	else
	{
		print_stop_message('no_log_entries_matched_your_query');
	}
}
print_cp_footer();
?>