<?php

// Unserialize the user chatbox params and add it to the userinfo global var table 
function mgc_cb_evo_unserialize_user_params() {
    global $vbulletin;

    // If the table is empty -> set default values 
    if (!empty($vbulletin->userinfo['mgc_cb_evo_params'])) {
        $unserialized_params = unserialize($vbulletin->userinfo['mgc_cb_evo_params']);
        
        // Add the new variables to the userinfo table of the vbulletin object 
        if (!empty($unserialized_params)) {
            foreach ($unserialized_params as $key => $val) {
                $vbulletin->userinfo["$key"] = $val;
            }
        }
    } else {
        $vbulletin->userinfo['mgc_cb_evo_show'] = 1;
    }
}

// User can see chatbox even if he has not reached number of posts 
function can_see_if_not_enough_posts() {
    global $vbulletin, $permissions;

    return ($permissions['mgc_cb_evo_permissions'] & $vbulletin->bf_ugp_mgc_cb_evo_permissions['canseeifnotenoughposts']);
}

// User can view the chatbox permission check 
function can_view_mgc_cb_evo() {
    global $vbulletin, $permissions;

    // Chatbox deactivated 
    if (!$vbulletin->options['mgc_cb_evo_active']) {
        return 0;
    }

    // Chatbox shall be idle in this style ? 
    if (!empty($vbulletin->options['mgc_cb_evo_styleids_hide']))
    {
    	$styleids_array = explode(',',$vbulletin->options['mgc_cb_evo_styleids_hide']);

    	if (in_array($vbulletin->userinfo['styleid'],$styleids_array))
    	{
    		return 0;
    	}
    }

    // Check number of posts per 24H ? 
    if ($permissions['mgc_cb_evo_nbmsg_perday_show'] > 0) {
        $getnbmsg = $vbulletin->db->query_first("SELECT COUNT(postid) AS nbposts FROM " . TABLE_PREFIX . "post WHERE dateline>='" . (TIMENOW - 86400) . "' AND userid='" . $vbulletin->userinfo['userid'] . "'");

        if (($getnbmsg['nbposts'] < $permissions['mgc_cb_evo_nbmsg_perday_show']) && !can_see_if_not_enough_posts()) {
            return false;
        }
    }

    // Check number of posts ? 
    if ($permissions['mgc_cb_evo_nbmsg_show'] > 0) {
        if (($vbulletin->userinfo['posts'] <= $permissions['mgc_cb_evo_nbmsg_show']) && !can_see_if_not_enough_posts()) {
              return false;
    	}
    }

    // Check user ban status 
    if ($vbulletin->userinfo['mgc_cb_evo_banned']) {
        return;
    }

    return ($permissions['mgc_cb_evo_permissions'] & $vbulletin->bf_ugp_mgc_cb_evo_permissions['canview']);
}


// User can use the chatbox permission check 
function can_use_mgc_cb_evo() {
    global $vbulletin, $permissions;

    // Check number of posts per 24H ? 
    if ($permissions['mgc_cb_evo_nbmsg_perday_show'] > 0) {
        $getnbmsg = $vbulletin->db->query_first("SELECT COUNT(postid) AS nbposts FROM " . TABLE_PREFIX . "post WHERE dateline>='" . (TIMENOW - 86400) . "' AND userid='" . $vbulletin->userinfo['userid'] . "'");

        if ($getnbmsg['nbposts'] < $permissions['mgc_cb_evo_nbmsg_perday_show']) {
            return false;
        }
    }

    // Check number of posts ? 
    if ($permissions['mgc_cb_evo_nbmsg_show'] > 0) {
        if ($vbulletin->userinfo['posts'] <= $permissions['mgc_cb_evo_nbmsg_show']) {
            return false;
        }
    }

    return ($permissions['mgc_cb_evo_permissions'] & $vbulletin->bf_ugp_mgc_cb_evo_permissions['canuse']);
}

// User can manage the chatbox permission check 
function can_manage_mgc_cb_evo() {
    global $vbulletin, $permissions;

    return ($permissions['mgc_cb_evo_permissions'] & $vbulletin->bf_ugp_mgc_cb_evo_permissions['canmanage']);
}

// User can view the IPs in the chatbox permission check 
function can_viewips_in_chatbox() {
    global $vbulletin, $permissions;

    return ($permissions['mgc_cb_evo_permissions'] & $vbulletin->bf_ugp_mgc_cb_evo_permissions['canviewip']);
}


// User can manage own chats permission check 
function can_manage_own_chats() {
    global $vbulletin, $permissions;

    return ($permissions['mgc_cb_evo_permissions'] & $vbulletin->bf_ugp_mgc_cb_evo_permissions['canmanageownchats']);
}

// User can see the archives permission check 
function can_view_mgc_cb_evo_archives() {
    global $vbulletin, $permissions;

    return ($permissions['mgc_cb_evo_permissions'] & $vbulletin->bf_ugp_mgc_cb_evo_permissions['canviewarchives']);
}

// User can download the archives permission check 
function can_download_mgc_cb_evo_archives() {
    global $vbulletin, $permissions;

    return ($permissions['mgc_cb_evo_permissions'] & $vbulletin->bf_ugp_mgc_cb_evo_permissions['candownloadarchives']);
}

// User can see prompt message in chatbox input field 
function can_see_promptmsg() {
    global $vbulletin, $permissions;

    return ($permissions['mgc_cb_evo_permissions'] & $vbulletin->bf_ugp_mgc_cb_evo_permissions['showpromptmsg']);
}

// User can sticky a chat 
function can_sticky()
{
    global $vbulletin, $permissions;

    return ($permissions['mgc_cb_evo_permissions'] & $vbulletin->bf_ugp_mgc_cb_evo_permissions['cansticky']);
}

// User can use bbcode if they are active 
function can_use_bbcodes() {
    global $vbulletin, $permissions;

    return ($permissions['mgc_cb_evo_permissions'] & $vbulletin->bf_ugp_mgc_cb_evo_permissions['canusebbcode']);
}

// User can user smilies if they are active 
function can_use_smilies() {
    global $vbulletin, $permissions;

    return ($permissions['mgc_cb_evo_permissions'] & $vbulletin->bf_ugp_mgc_cb_evo_permissions['canusesmilies']);
}

// User can search within the chats 
function can_search() {
    global $vbulletin, $permissions;

    return ($permissions['mgc_cb_evo_permissions'] & $vbulletin->bf_ugp_mgc_cb_evo_permissions['cansearch']);
}

// User can select default channel 
function can_select_default_channel() {
    global $vbulletin, $permissions;
    
    return ($permissions['mgc_cb_evo_permissions'] & $vbulletin->bf_ugp_mgc_cb_evo_permissions['canselectdefchan']);
}

// Check if autorefresh should be activated (depends of max number of chats per day) 
function authorize_mgc_cb_evo_autorefresh($max_number_of_chats_reached)
{
    global $vbulletin, $permissions;

	// No refresh 
	if ($permissions['mgc_cb_evo_refreshrate'] == 0)
	{
		return 0;
	}
	else
	{
		// Max number of posts reached and disable refresh in that case option active 
		if (($permissions['mgc_cb_evo_permissions'] & $vbulletin->bf_ugp_mgc_cb_evo_permissions['disablerefreshuponlimit']) && $max_number_of_chats_reached)
		{
			return 0;
		}
		else
		{
			return 1;
		}
	}
}

// Construct the chatbox allowed bbcode tags list 
function construct_bbcode_tag_list($with_color) {
    global $vbulletin;

    $bbcode_list = array();

    if ($vbulletin->options['mgc_cb_evo_bbcode']) {
        $bbcode_list['no_option']['b'] = array('html' => '<b>%1$s</b>', 'strip_empty' => true);

        $bbcode_list['no_option']['i'] = array('html' => '<i>%1$s</i>', 'strip_empty' => true);

        $bbcode_list['no_option']['u'] = array('html' => '<u>%1$s</u>', 'strip_empty' => true);

        if ($with_color) {
            $bbcode_list['option']['color'] = array('html' =>
                                                    '<font color="%2$s">%1$s</font>', 'option_regex' => '#^\#?\w+$#', 'strip_empty' => true);
        }

        $bbcode_list['option']['size'] = array('html' => '<font size="%2$s">%1$s</font>',
                                               'option_regex' => '#^[0-9\+\-]+$#', 'strip_empty' => true);

        $bbcode_list['option']['font'] = array('html' => '<font face="%2$s">%1$s</font>',
                                               'option_regex' => '#^[^["`\':]+$#', 'strip_empty' => true);
    }

    if ($vbulletin->options['mgc_cb_evo_bbcode_url']) {
        $bbcode_list['no_option']['url'] = array('callback' => 'handle_bbcode_url',
                                                 'strip_empty' => true);

        $bbcode_list['option']['url'] = array('callback' => 'handle_bbcode_url',
                                              'strip_empty' => true);
    }

    if ($vbulletin->options['mgc_cb_evo_bbcode_email']) {
        $bbcode_list['no_option']['email'] = array('callback' => 'handle_bbcode_email',
                                                   'strip_empty' => true);

        $bbcode_list['option']['email'] = array('callback' => 'handle_bbcode_email',
                                                'strip_empty' => true);
    }

    if ($vbulletin->options['mgc_cb_evo_bbcode_noparse']) {

		$bbcode_list['no_option']['noparse'] = array(
			'html' => '%1$s',
			'strip_empty' => true,
			'stop_parse' => true,
			'disable_smilies' => true
		);
    }
    
    if ($vbulletin->options['mgc_cb_evo_bbcode_quote']) {
   		$bbcode_list['no_option']['quote'] = array(
			'callback' => 'handle_bbcode_quote',
			'strip_empty' => true,
			'strip_space_after' => 2
		);

		$bbcode_list['option']['quote'] = array(
			'callback' => 'handle_bbcode_quote',
			'strip_empty' => true,
			'strip_space_after' => 2,
			'parse_option' => true
		);    
	}

    return $bbcode_list;
}

// Retrieves the chatbit display
function fetch_chat_info($chat, $parsebbcode, $commands_status, $channel_id,$alt = 'alt2',$static = 0,$showchanname = 0,$keywords = '') {
    global $vbulletin, $vbphrase, $vbcollapse, $permissions, $stylevar, $mgc_cb_evo_floc;

    //* Username management *
    if ($chat['touid'] == 0) { // Normal command 
        $username_prefix = "";

        // Anonymous user 
        if (!$chat['fromuid']) {
            $anonymous 	            = 1;
            // Display entered name if option active, otherwise default anonymous name 
            if ($vbulletin->options['mgc_cb_evo_ask_anonymous_name'] && !empty($chat['name'])) {
            	$user['username']	= $user['raw_username'] = htmlspecialchars_uni($chat['name']);
            } else {
	            $user['username']   = $user['raw_username'] = $vbulletin->options['mgc_cb_evo_anonymous_uname'];
	        }
        } else {
            $anonymous		        	= 0;
            $user 						= array();
            $user['userid'] 			= $chat['fromuid'];
            $user['usergroupid']    = $chat['usergroupid'];
            $user['displaygroupid'] = $chat['displaygroupid'];
            $user['username'] 		= $user['raw_username'] = $chat['name'];
            $user['username'] 		= fetch_musername($user, 'displaygroupid');
				 // Manage avatar if option is active 
				 if ($vbulletin->options['mgc_cb_evo_avatar_on']) {
					// Show no avatar for anonymous users 
					if ($anonymous) {
						$avatarurl = $stylevar['imgdir_misc'] . '/mgc_cb_evo/noavatar.jpg';
					} else {
						$chat['userid'] = $user['userid'];
						$avatarurl 		= get_avatar_chatbox($chat,0);
					}
				 }            
        }
    } else { // Command from user to user 

        // Message sent by the user 
			$user 						= array();
        if ($chat['fromuid'] == $vbulletin->userinfo['userid']) {
            $username_prefix 		= $vbphrase['mgc_cb_evo_to'] . " ";
            $anonymous 		        = 0;         	
         	$user['userid'] 			= $chat['touid'];
         	$user['usergroupid']    = $chat['tousergroupid'];
      	   $user['displaygroupid'] = $chat['todisplaygroupid'];
   	      $user['username'] 		= $user['raw_username'] = $chat['toname'];
	         $user['username'] 		= fetch_musername($user, 'displaygroupid'); 
				 // Manage avatar if option is active 
				 if ($vbulletin->options['mgc_cb_evo_avatar_on']) {
					// Show no avatar for anonymous users 
					if ($anonymous) {
						$avatarurl = $stylevar['imgdir_misc'] . '/mgc_cb_evo/noavatar.jpg';
					} else {
						$chat['userid'] = $user['userid'];
						$avatarurl 		= get_avatar_chatbox($chat,1);
					}
				 }     
        } else {
            $username_prefix 		= $vbphrase['mgc_cb_evo_from'] . " ";
            $anonymous				= 0;
         	$user['userid'] 			= $chat['fromuid'];
         	$user['usergroupid']    = $chat['usergroupid'];
      	   $user['displaygroupid'] = $chat['displaygroupid'];
   	      $user['username'] 		= $user['raw_username'] = $chat['name'];
	         $user['username'] 		= fetch_musername($user, 'displaygroupid');         
				 // Manage avatar if option is active 
				 if ($vbulletin->options['mgc_cb_evo_avatar_on']) {
					// Show no avatar for anonymous users 
					if ($anonymous) {
						$avatarurl = $stylevar['imgdir_misc'] . '/mgc_cb_evo/noavatar.jpg';
					} else {
						$chat['userid'] = $user['userid'];
						$avatarurl 		= get_avatar_chatbox($chat,0);
					}
				 }    	
        }
    }

    // Username display applies for all chats except the one with the me or slap command and the thread/post warnings 
    if ($chat['coidentifier'] != 'me' && $chat['coidentifier'] != 'slap' && !$chat['iswarning']) {
        $user['username'] = str_replace("{1}",$user['username'],$vbulletin->options['mgc_cb_evo_username_html']);
    }

    //* Date and time *

	// Hide date/time var for specialchats 
	if ($chat['iswarning'] && $vbulletin->options['mgc_cb_evo_separate_special_chats'])
	{
		$hidedatespecial = $vbulletin->options['mgc_cb_evo_schat_hidedate'];
		$hidetimespecial = $vbulletin->options['mgc_cb_evo_schat_hidetime'];
	}
	else
	{
		$hidedatespecial = 0;
		$hidetimespecial = 0;
	}
	
    // Display date 
    if ($vbulletin->options['mgc_cb_evo_do_yestoday'] && !$static)
    {
		if ($vbulletin->options['mgc_cb_evo_show_date'] && !$hidedatespecial) {
			$date = vbdate($vbulletin->options['dateformat'], $chat['dateline'],true,false);
		} else {
			$date = "";
		}
	
		// Display time 
		if ($vbulletin->options['mgc_cb_evo_show_time'] && !$hidetimespecial) {
			$time = vbdate($vbulletin->options['timeformat'], $chat['dateline'],true,false);
		} else {
			$time = "";
		}    	
    }
    else
    {
		if ($static) {
			$date = vbdate($vbulletin->options['mgc_cb_evo_archives_format_date'], $chat['dateline'],0,false);
		} else {
			if ($vbulletin->options['mgc_cb_evo_show_date'] && !$hidedatespecial) {
				$date = vbdate($vbulletin->options['mgc_cb_evo_format_date'], $chat['dateline'],0,false);
			} else {
				$date = "";
			}
		}
	
		// Display time 
		if ($vbulletin->options['mgc_cb_evo_show_time'] && !$hidetimespecial) {
			$time = vbdate($vbulletin->options['mgc_cb_evo_format_time'], $chat['dateline'],false,false);
		} else {
			$time = "";
		}    
    }

    //* Chats management (Edit ) *

    // Chatbox not collapsed 
    if ($vbcollapse['collapseobj_mgc_chatbox'] == '') {
        $show['mgc_cb_evo_mngt'] = can_manage_mgc_cb_evo() || (($vbulletin->userinfo['userid'] == $chat['fromuid']) && can_manage_own_chats());
    } else {
        $show['mgc_cb_evo_mngt'] = 0;
    }

    if ($show['mgc_cb_evo_mngt']) {
        $chat_ondblclick = "ondblclick='mgc_cb_evo_inline_edit(this,$chat[chatid])'";
    } else {
        $chat_ondblclick = "";
    }

    //* Chats management in static (Delete) *
    if ($static && can_manage_mgc_cb_evo()) {
        $show['delete_column'] = true;
    }

    //* Chat display formatting *

    // Bbcode parsing if bbcodes are active and the command is not the me command 
    if ($parsebbcode) {
        $parser = &new vB_BbCodeParser($vbulletin, construct_bbcode_tag_list(true));
        $chat['text'] = $parser->do_parse($chat['ctext'], false, $vbulletin->options['mgc_cb_evo_smileys'], true,$vbulletin->options['mgc_cb_evo_bbcode_img'], false, false);
    } else {
        // Fetch censored text 
        $chat['text'] = fetch_censored_text($chat['ctext']);
        $chat['text'] = htmlspecialchars($chat['ctext']);
    }

    // Specific display management for the me and slap commands 
    if ($chat['coidentifier'] == 'me') {
        $show['mgc_cb_evo_username_column'] = 0;
        $chat['text'] = '<font color="#' . $vbulletin->options['mgc_cb_evo_cmd_me_color'] . '"><b>* ' . $user['username'] . ' ' . $chat['text'] . '</b></font>';
    } else if ($chat['coidentifier'] == 'slap') {
        $show['mgc_cb_evo_username_column'] = 0;
        $text = str_replace("{1}",$user['username'],$vbulletin->options['mgc_cb_evo_cmd_slap_phrase']);
        $text = str_replace("{2}",$chat['text'],$text);
        $chat['text'] = '<font color="#' . $vbulletin->options['mgc_cb_evo_cmd_slap_color'] . '"><b>* ' . $text . '</b></font>';
    } else if ($chat['warningtype'] == 'thread') {
        $show['mgc_cb_evo_username_column'] = 1;
        $pos_coma 		= strpos($chat['text'],',');
        $threadid		= substr($chat['text'],0,$pos_coma);
        $threadtitle 	= decode_htmlspecialchars(substr($chat['text'],$pos_coma + 1));
        $chat['text'] 	= construct_phrase($vbphrase['mgc_cb_evo_x_has_posted_newthread'],$vbulletin->options['bburl'],$threadid,$threadtitle);
    } else if ($chat['warningtype'] == 'post') {
        $show['mgc_cb_evo_username_column'] = 1;
        $pos_coma1 		= strpos($chat['text'],',');
        $threadid		= substr($chat['text'],0,$pos_coma1);
        $chat['text'] 	= substr($chat['text'],$pos_coma1 + 1);
        $pos_coma2		= strpos($chat['text'],',');
        $postid			= substr($chat['text'],0,$pos_coma2);
        $threadtitle 	= decode_htmlspecialchars(substr($chat['text'],$pos_coma2 + 1));
        $chat['text'] 	= construct_phrase($vbphrase['mgc_cb_evo_x_has_posted_newpost_inthread_y'],$vbulletin->options['bburl'],$postid,$threadtitle);
    } else {
        $show['mgc_cb_evo_username_column'] = 1;
    }
    
	// Add Team command prefix if needed 
	if ($chat['coidentifier'] == 'team' && !empty($vbulletin->options['mgc_cb_evo_cmd_team_prefix']))
	{
		$chat['text'] = $vbulletin->options['mgc_cb_evo_cmd_team_prefix'] . '&nbsp;' . $chat['text'];
	}

	($hook = vBulletinHook::fetch_hook('mgc_cb_evo_notifs_display_text')) ? eval($hook) : false;

    // Font class 
	if ($chat['iswarning'])
	{
		if ($vbulletin->options['mgc_cb_evo_schat_fontclass']) {
			$fontclass= "smallfont";
		} else {
			$fontclass = "normalfont";
		}
	}
	else
	{
		if ($vbulletin->options['mgc_cb_evo_chat_fontclass']) {
			$fontclass= "smallfont";
		} else {
			$fontclass = "normalfont";
		}	
	}
    // Authorization to display sticky chat in the chatbox menu 
    $show['stickychat'] = can_sticky();

    // Authorization to display the view all user shouts in the chatbox menu 
    $show['search_userchats'] = can_search();

    // Authorization to display user IP in the chatbox menu 
    $show['userip'] = can_viewips_in_chatbox();

    // Manage channel name if active 
    if ($showchanname)
    {
    		// General channel 
    		if ($chat['chanid'] == 0)
    		{
    			$channelname = $vbphrase['mgc_cb_evo_channel_gen'];
    		}
    		else
    		{
    			$channelname = htmlspecialchars_uni($chat['chantitle']);
    		}
    }

    // Let's build the commands chatbit menu bit if user is not anonymous 
    if (!$anonymous && !$chat['iswarning']) {
        eval('$chatbit_menu .= "' . fetch_template('mgc_cb_evo_chatbit_menu') . '";');
    }

    // Highlight keywords if option active and keywords provided 
    if ($vbulletin->options['mgc_cb_evo_highlight_searched_keywords'] && !empty($keywords))
    {
    		 $keywords = addslashes($keywords);
    		 $chat['text'] = preg_replace('/('.$keywords.')/i', "<span style=\"font-weight: bold;color: #FF0000; background-color: #" . $vbulletin->options['mgc_cb_evo_highlight_searched_keywords_color'] . ";\">$1</span> ", $chat['text']);
    }

    if ($static) {
        eval('$chat_txt .= "' . fetch_template('mgc_cb_evo_static_chatbit') . '";');
	    return $chat_txt;
    } else {
        eval('$chat_cols[col_avatar] .= "' . fetch_template('mgc_cb_evo_chatbit_col_avatar') . '";');
        eval('$chat_cols[col_chat]   .= "' . fetch_template('mgc_cb_evo_chatbit_col_chat') . '";');
        eval('$chat_cols[col_date]   .= "' . fetch_template('mgc_cb_evo_chatbit_col_date') . '";');
        eval('$chat_cols[col_menu]   .= "' . fetch_template('mgc_cb_evo_chatbit_col_menu') . '";');
        eval('$chat_cols[col_sticky] .= "' . fetch_template('mgc_cb_evo_chatbit_col_sticky') . '";');
        eval('$chat_cols[col_uname]  .= "' . fetch_template('mgc_cb_evo_chatbit_col_uname') . '";');

        // Remove html comments to avoid problem with vB templates name html comment in ajax 
        foreach($chat_cols AS $key => $value)
        {
				$val = preg_replace('/<!--(.|\s)*?-->/', '', $value);
				$chat_cols[$key] = $val;
        }

        return $chat_cols;
    }
}


function build_smileys_selector_display() {
    global $vbulletin, $vbphrase;

    // The number of smileys defined for the editor is equal to 0 ? 

    // Nombre de smileys dans l'éditeur différent de 0 
    if ($vbulletin->options['mgc_cb_evo_editor_nbsmileys']) {
        if ($vbulletin->options['mgc_cb_evo_editor_smileys_acporder']) { // Acp order smilies 
            $smilies = $vbulletin->db->query_read("
			  SELECT s.smilieid, s.smilietext, s.smiliepath, s.title
			  FROM " . TABLE_PREFIX . "smilie AS s
			  LEFT JOIN " . TABLE_PREFIX . "imagecategory AS cat ON (s.imagecategoryid=cat.imagecategoryid)
			  ORDER BY cat.displayorder ASC,s.displayorder ASC
			  LIMIT " . $vbulletin->options['mgc_cb_evo_editor_nbsmileys']
                                                  );
        } else if ($vbulletin->options['mgc_cb_evo_editor_smileys_random']) { // Random smilies 
            $smilies = $vbulletin->db->query_read("
			  SELECT smilieid, smilietext, smiliepath, title
			  FROM " . TABLE_PREFIX . "smilie
			  ORDER BY RAND() LIMIT " . $vbulletin->options['mgc_cb_evo_editor_nbsmileys']
                                                  );
        } else {
            $smilies = $vbulletin->db->query_read("
			  SELECT smilieid, smilietext, smiliepath, title
			  FROM " . TABLE_PREFIX . "smilie
			  LIMIT " . $vbulletin->options['mgc_cb_evo_editor_nbsmileys']
                                                  );
        }

        $cb_smilies = '';
        $cnt_smilies = 0;

        // Any smilies ? 
        if ($vbulletin->db->num_rows($smilies)) {
            while (($smiley = $vbulletin->db->fetch_array($smilies))) {
                $textsmiley = str_replace("'", "\'", $smiley['smilietext']);
                $textsmiley = str_replace("\\", "\\\\", $textsmiley);
                $cb_smilies .= '<a href="#chatbox" onclick="return add_smiley_to_input(\'' . $textsmiley . '\');"><img src="' . $smiley['smiliepath'] . '" border="0" alt="' . $smiley['title'] . '" /></a> ';
            }
            return $cb_smilies;
        } else {
            return $vbphrase['mgc_cb_no_smileys'];
        }
    } else {
        return $vbphrase['mgc_cb_no_smileys'];
    }
}

function build_fonts_selector($fonts_list, $inprofile = false) {
    global $vbulletin, $vbphrase;

    $userpref_val = $vbulletin->userinfo['mgc_cb_evo_font'];

    // Building a selector for the user cp 
    if ($inprofile) {
        $fonts_select = '<select name="mgc_cb_evo_font" id="mgc_cb_evo_font">';
        $fonts_select .= '<option value="0" ' . (($userpref_val == 0) ? "selected=\"selected\"" : "") . '" style="font-weight: bold">' . $vbphrase['use_forum_default'] . '</option>';
    } else {
        $fonts_select = '<select name="mgc_cb_evo_font" id="mgc_cb_evo_font" onchange="return configure_enhanced_format(this,\'font\');">';
        $fonts_select .= '<option value="Arial" ' . (($userpref_val == 0) ? "selected=\"selected\"" : "") . ' style="font-weight: bold">[' . $vbphrase['default'] . ']</option>';
    }

    foreach ($fonts_list as $id => $font) {
        if ($font == $userpref_val) {
            $fonts_select .= '<option style="font: 10px ' . strtolower($font) . ';" value="' . $font . '" selected="selected">' . $font . '</option>';
        } else {
            $fonts_select .= '<option style="font: 10px ' . strtolower($font) . ';" value="' . $font . '">' . $font . '</option>';
        }
    }

    $fonts_select .= '</select>';

    return $fonts_select;
}

function build_size_selector($sizes_list, $inprofile = false) {
    global $vbulletin, $vbphrase;

    $userpref_val = $vbulletin->userinfo['mgc_cb_evo_size'];

    foreach ($sizes_list as $id => $size) {
        if ($size <= $vbulletin->options['mgc_cb_evo_max_bbcode_size']) {
            if ($size == $userpref_val) {
                $sizes_selectbit .= '<option value="' . $size . '" selected="selected">' . $size . '</option>';
            } else {
                $sizes_selectbit .= '<option value="' . $size . '">' . $size . '</option>';
            }
        }
    }

    // Building a selector for the user cp 
    if ($inprofile) {
        $sizes_select  = '<select name="mgc_cb_evo_size" id="mgc_cb_evo_size">';
        $sizes_select .= '<option value="0" ' . (($userpref_val == 0) ?"selected=\"selected\"" : "") . '" style="font-weight: bold">' . $vbphrase['use_forum_default'] . '</option>';
    } else {
        $sizes_select  = '<select name="mgc_cb_evo_size" id="mgc_cb_evo_size" onchange="return configure_enhanced_format(this,\'size\');">';
        $sizes_select .= '<option value="3" ' . ( ($select_val == 0) ? "selected=\"selected\"" : "" ) . ' style="font-weight: bold">[' . $vbphrase['default'] . ']</option>';
    }

    $sizes_select .= $sizes_selectbit;
    $sizes_select .= '</select>';

    return $sizes_select;
}

function build_color_selector($inprofile = false) {
    global $vbphrase, $vbulletin;

    if (!empty($vbulletin->userinfo['mgc_cb_evo_color'])) {
        // User default 
        $select_val = $vbulletin->userinfo['mgc_cb_evo_color'];
    } else if (!$inprofile && $vbulletin->userinfo['mgc_cb_evo_default_color']) {
        // Usergroup default if different from 000000 
        $select_val = $vbulletin->userinfo['mgc_cb_evo_default_color'];
    }

    $colors_list = array('#000000', '#A0522D', '#556B2F', '#006400', '#483D8B',
                         '#000080', '#4B0082', '#2F4F4F', '#8B0000', '#FF8C00', '#808000', '#008000',
                         '#008080', '#0000FF', '#708090', '#696969', '#FF0000', '#F4A460', '#9ACD32',
                         '#2E8B57', '#48D1CC', '#4169E1', '#800080', '#808080', '#FF00FF', '#FFFF00',
                         '#00FF00', '#00FFFF', '#00BFFF', '#9932CC', '#C0C0C0', '#FFC0CB', '#F5DEB3',
                         '#FFFACD', '#98FB98', '#AFEEEE', '#ADD8E6', '#DDA0DD', '#FFFFFF');

    if ($inprofile) {
        $colors_select = '<select name="mgc_cb_evo_color" id="mgc_cb_evo_color">';
        $colors_select .= '<option value="0" ' . (empty($select_val) ?  "selected=\"selected\"" : "") . '" style="font-weight: bold">' . $vbphrase['use_forum_default'] . '</option>';
    } else {
        $colors_select = '<select name="mgc_cb_evo_color" id="mgc_cb_evo_color" onchange="return configure_enhanced_format(this,\'color\');">';
        $colors_select .= '<option value="#' . $vbulletin->userinfo['mgc_cb_evo_default_color'] . '" ' . (empty($select_val) ? "selected=\"selected\"" : "") . ' style="font-weight: bold">[' . $vbphrase['default'] . ']</option>';
    }

    foreach ($colors_list as $name => $val) {
        if ($val == '#' . $select_val) {
            $colors_select .= '<option value="' . $val . '" style="background-color: ' . $val . '; color: ' . $val . '" selected="selected">' . $val . '</option>';
        } else {
            $colors_select .= '<option value="' . $val . '" style="background-color: ' . $val . '; color: ' . $val . '">' . $val . '</option>';
        }
    }

    $colors_select .= '</select>';

    return $colors_select;
}

function build_default_channel_selector()
{
	global $vbphrase,$vbulletin;
	
    if (array_key_exists('mgc_cb_evo_uchanid',$vbulletin->userinfo)) {
        // User choice 
        $select_val = $vbulletin->userinfo['mgc_cb_evo_uchanid'];
    }
    else
    {
    	// Usergroup default 
    	$select_val = $vbulletin->userinfo['mgc_cb_evo_chanid'];
    }

	$channel_select = '<select name="mgc_cb_evo_uchanid" id="mgc_cb_evo_uchanid">';
    $channel_select .= '<option value="0" ' . (($select_val == 0) ?  "selected=\"selected\"" : "") . '>' . $vbphrase['mgc_cb_evo_channel_gen'] . '</option>';
    
    // Get channels 
    $sql_condition = "usergroupids REGEXP('^([0-9]+,)*" . $vbulletin->userinfo['usergroupid'] . "(,[0-9]+)*$')";

    if (!empty($vbulletin->userinfo['membergroupids'])) {
        $ugipds_array = explode(',', $vbulletin->userinfo['membergroupids']);

        foreach ($ugipds_array as $index => $ugpid) {
            $sql_condition .= " OR usergroupids REGEXP('^([0-9]+,)*" . $ugpid . "(,[0-9]+)*$')";
        }
    }

    $sql_condition .= " OR userids REGEXP('^([0-9]+,)*" . $vbulletin->userinfo['userid'] . "(,[0-9]+)*$')";

    $getchannels = $vbulletin->db->query_read("
      SELECT chanid,title
      FROM " . TABLE_PREFIX . "mgc_cb_evo_channel
      WHERE active='1' AND $sql_condition
      ORDER BY chanorder ASC
   	");    
    
    while ($channel = $vbulletin->db->fetch_array($getchannels)) {
        if ($channel['chanid'] == $select_val) {
            $channel_select .= '<option value="' . $channel['chanid'] . '" selected="selected">' . $channel['title'] . '</option>';
        } else {
            $channel_select .= '<option value="' . $channel['chanid'] . '" >' . $channel['title'] . '</option>';
        }
    }

    $channel_select .= '</select>';

    return $channel_select;	
}

function build_bbcode_selector_display() {
    global $vbulletin, $vbphrase, $stylevar;

    $bbcodes = '';

    // Simple bbcode active 
    if ($vbulletin->options['mgc_cb_evo_bbcode']) {
        // Get necessary templates 
        foreach (array('editor_jsoptions_font', 'editor_jsoptions_size') as $template) {
            $string = fetch_template($template, 1, 0);
            $$template = preg_split('#\r?\n#s', $string, -1, PREG_SPLIT_NO_EMPTY);
        }

        // Font list 
        $fonts  = $editor_jsoptions_font;
        $bbcodes .= build_fonts_selector($fonts);

        // Sizes list 
        $sizes = $editor_jsoptions_size;
        $bbcodes .= '&nbsp;&nbsp;' . build_size_selector($sizes);

        // Colors selector 
        $bbcodes .= '&nbsp;&nbsp;' . build_color_selector();

        // B / I / U buttons 
        	if ($vbulletin->userinfo['mgc_cb_evo_b'])
        	{
				$bbcodes .= '&nbsp;<input type="image" id="bbcode_image_b" name="bold" class="inlineimg" src="' . $stylevar['imgdir_misc'] . '/mgc_cb_evo/mgc_cb_evo_b_on.gif"  value="b" onclick="return configure_simple_format(\'b\');" />';
			}
			else
			{
				$bbcodes .= '&nbsp;<input type="image" id="bbcode_image_b" name="bold" class="inlineimg" src="' . $stylevar['imgdir_misc'] . '/mgc_cb_evo/mgc_cb_evo_b_off.gif"  value="b" onclick="return configure_simple_format(\'b\');" />';
			}
			
        	if ($vbulletin->userinfo['mgc_cb_evo_i'])
        	{
        		$bbcodes .= '&nbsp;<input type="image" id="bbcode_image_i" name="italic" class="inlineimg" src="' . $stylevar['imgdir_misc'] . '/mgc_cb_evo/mgc_cb_evo_i_on.gif" value="i" onclick="return configure_simple_format(\'i\');" />';
        	}
        	else
        	{
        		$bbcodes .= '&nbsp;<input type="image" id="bbcode_image_i" name="italic" class="inlineimg" src="' . $stylevar['imgdir_misc'] . '/mgc_cb_evo/mgc_cb_evo_i_off.gif" value="i" onclick="return configure_simple_format(\'i\');" />';
        	}
			
        	if ($vbulletin->userinfo['mgc_cb_evo_u'])
        	{
        		$bbcodes .= '&nbsp;<input type="image" id="bbcode_image_u" name="underlined" class="inlineimg" src="' . $stylevar['imgdir_misc'] . '/mgc_cb_evo/mgc_cb_evo_u_on.gif"  value="u" onclick="return configure_simple_format(\'u\');" />';
        	}
        	else
        	{
        		$bbcodes .= '&nbsp;<input type="image" id="bbcode_image_u" name="underlined" class="inlineimg" src="' . $stylevar['imgdir_misc'] . '/mgc_cb_evo/mgc_cb_evo_u_off.gif"  value="u" onclick="return configure_simple_format(\'u\');" />';
        	}
    }

    if ($vbulletin->options['mgc_cb_evo_bbcode_url']) {
        $bbcodes .= empty($bbcodes) ? '' : '&nbsp;';
        $bbcodes .= '<input type="image" name="url" class="inlineimg" src="' . $stylevar['imgdir_misc'] . '/mgc_cb_evo/mgc_cb_evo_url.gif"  value="URL" onclick="return insert_bbcode_url();" />';
    }

    if ($vbulletin->options['mgc_cb_evo_bbcode_email']) {
        $bbcodes .= empty($bbcodes) ? '' : '&nbsp;';
        $bbcodes .= '<input type="image" name="url" class="inlineimg" src="' . $stylevar['imgdir_misc'] . '/mgc_cb_evo/mgc_cb_evo_email.gif"  value="EMAIL" onclick="return insert_bbcode_email();" />';
    }

    if ($vbulletin->options['mgc_cb_evo_bbcode_img']) {
        $bbcodes .= empty($bbcodes) ? '' : '&nbsp;';
        $bbcodes .= '<input type="image" name="image" class="inlineimg" src="' . $stylevar['imgdir_misc'] . '/mgc_cb_evo/mgc_cb_evo_img.gif" value="IMG" onclick="return insert_bbcode_img();" />';
    }

    $bbcodes .= '&nbsp;<input type="image" name="clear" class="inlineimg" src="' . $stylevar['imgdir_misc'] . '/mgc_cb_evo/mgc_cb_evo_clear.gif" value="' . $vbphrase['mgc_cb_evo_clear_bbcode'] . '" onclick="return reset_bbcodes();" />';

    return $bbcodes;
}

// Returns all the chatbox for display 
function build_mgc_cb_evo_display($chatbox_height) {
    global $vbulletin, $vbphrase, $show, $stylevar, $vbcollapse, $vboptions,$permissions;
    global $mgc_cb_evo_floc;

    // First load and inactive mode not activated by default => Update session table 
    if ((!$vbulletin->options['mgc_cb_evo_inactive_mode'] || ($vbulletin->options['mgc_cb_evo_inactive_mode'] && !$vbulletin->options['mgc_cb_evo_inactive_mode_onload'])) && $vbulletin->options['mgc_cb_evo_whoisonline_active']) {
        $vbulletin->db->query_write("REPLACE INTO " . TABLE_PREFIX . "mgc_cb_evo_session SET userid='" . $vbulletin->userinfo['userid'] . "',dateline='" . TIMENOW . "'");
    }


    // Retrieving of commands permissions to activate the autocompletion 
    $autocompletion_js_array = array();

    if ($vbulletin->options['mgc_cb_evo_act_autocompletion']) {
        $commands = $vbulletin->db->query_read("SELECT * FROM " . TABLE_PREFIX . "mgc_cb_evo_command WHERE active='1'");

        while ($command = $vbulletin->db->fetch_array($commands)) {
            if (mgc_cb_evo_can_use_command($command)) {
                $show['mgc_cb_evo_command_' . $command['identifier']] = true;

                // If autocompletion is active, add commands tips to autocompletion array 
                if ($vbulletin->options['mgc_cb_evo_act_autocompletion']) {
                    $append_array = get_command_autocompletion_array($command['identifier']);
                    $autocompletion_js_array = array_merge($autocompletion_js_array,$append_array);
                }
            } else {
                $show['mgc_cb_evo_command_' . $command['identifier']] = false;
            }
        }

        if (sizeof($autocompletion_js_array)) {
            // Order table alphabetically 
            sort($autocompletion_js_array);

            // Implode array 
            $autocompletion_js = implode(',',$autocompletion_js_array);
        }
    }
    
    $show['mgc_cb_evo_promptmsg'] 	= (can_see_promptmsg() && $vbulletin->options['mgc_cb_evo_input_prompt']) ? 1 : 0;
    $show['mgc_cb_evo_smilies'] 	= 0;
    $show['mgc_cb_evo_bbcodes'] 	= 0;
    $show['mgc_cb_evo_archives']	= can_view_mgc_cb_evo_archives();

	// Check if user has limited number of posts per day limit 
	if ($permissions['mgc_cb_evo_max_chats_perday'])
	{
		$getnbchats = $vbulletin->db->query_first("SELECT COUNT(chatid) AS nbchats FROM " . TABLE_PREFIX . "mgc_cb_evo_chat WHERE dateline>='" . (TIMENOW - 86400) . "' AND fromuid='" . $vbulletin->userinfo['userid'] . "'");
				
		// Max number of chats reached => hide editor 
		if ($getnbchats['nbchats'] >= $permissions['mgc_cb_evo_max_chats_perday'])
		{
			$warn_msg 						= $vbulletin->options['mgc_cb_evo_msg_max_numberchatsperday_reached'];
			$max_number_of_chats_reached 	= 1;
			$show['mgc_cb_evo_editor'] 		= 0;
		}
		else
		{
			$max_number_of_chats_reached 	= 0;
	    	$show['mgc_cb_evo_editor'] 		= can_use_mgc_cb_evo();				
		}
	}
	else
	{
		$max_number_of_chats_reached 	= 0;	
    	$show['mgc_cb_evo_editor'] 		= can_use_mgc_cb_evo();		
	}

	// If editor line displayed 
	if ($show['mgc_cb_evo_editor'])
	{
		// Smileys display if activated 
		if (can_use_smilies() && $vbulletin->options['mgc_cb_evo_smileys']) {
			$smilies = build_smileys_selector_display();
			// Only show smilies if any 
			if (!empty($smilies)) {
				$show['mgc_cb_evo_smilies'] = 1;
			}
		}
	
		// BBCODE display if activated 
		if (can_use_bbcodes() && ($vbulletin->options['mgc_cb_evo_bbcode'] || $vbulletin->options['mgc_cb_evo_bbcode_url'] || $vbulletin->options['mgc_cb_evo_bbcode_email'] || $vbulletin->options['mgc_cb_evo_bbcode_img'])) {
			$bbcodes = build_bbcode_selector_display();
			$show['mgc_cb_evo_bbcodes'] = 1;
		}
	}

    // Retrieving of the channels 
    $sql_condition = "usergroupids REGEXP('^([0-9]+,)*" . $vbulletin->userinfo['usergroupid'] . "(,[0-9]+)*$')";

    if (!empty($vbulletin->userinfo['membergroupids'])) {
        $ugipds_array = explode(',', $vbulletin->userinfo['membergroupids']);

        foreach ($ugipds_array as $index => $ugpid) {
            $sql_condition .= " OR usergroupids REGEXP('^([0-9]+,)*" . $ugpid . "(,[0-9]+)*$')";
        }
    }

    $sql_condition .= " OR userids REGEXP('^([0-9]+,)*" . $vbulletin->userinfo['userid'] . "(,[0-9]+)*$')";

    $channels_bit = '';
    $getchannels = $vbulletin->db->query_read("
      SELECT chanid,title,img_name
      FROM " . TABLE_PREFIX . "mgc_cb_evo_channel
      WHERE active='1' AND $sql_condition
      ORDER BY chanorder ASC
   	");


    if ($vbulletin->options['mgc_cb_evo_show_channelname'])
    {
    	 $array_channelnames = array();
	    $array_channelnames['0'] = "\"" . $vbphrase['mgc_cb_evo_channel_gen'] . "\"";
    }

	$default_channel = 0;

    if ($vbulletin->db->num_rows($getchannels)) {
        $show['genchan'] = 1;
        while($channel = $vbulletin->db->fetch_array($getchannels)) {
        	// Channel display 
		    if ($vbulletin->options['mgc_cb_evo_show_channelname'])
		    {
			    $array_channelnames["$channel[chanid]"] = "\"" . htmlspecialchars_uni($channel['title']) . "\"";
		    }
            $channel_ids[] 		= $channel['chanid'];
            $channel['title'] 	= htmlspecialchars_uni($channel['title']);
            eval('$channels_bit .= "' . fetch_template('mgc_cb_evo_channel_button') . '";');
			
			// Default channel active (to check channel still active and usergroup still has access) 
			if ($channel['chanid'] == $vbulletin->userinfo['mgc_cb_evo_chanid'])
			{
				$default_channel = $channel['chanid'];
			}
        }

        $js_channels_ids_array = "var channels_ids = new Array(\"" . implode("\",\"",$channel_ids) . "\");\n";
    }

	// User default channel : $default_channel contains the default usergroup channel, let's see if there is a user default channel 
	if (can_select_default_channel())
	{
		if (array_key_exists('mgc_cb_evo_uchanid',$vbulletin->userinfo))
		{
			$default_channel = $vbulletin->userinfo['mgc_cb_evo_uchanid'];		
		}
	}

    // Chatbox announcement parsing 
    if ($vbulletin->options['mgc_cb_evo_bbcode_in_chatbox_announcement']) {
        require_once(DIR . '/includes/class_bbcode.php');
        $parser =& new vB_BbCodeParser($vbulletin, fetch_tag_list());
        $vbulletin->options['mgc_cb_evo_announcement'] = $parser->do_parse($vbulletin->options['mgc_cb_evo_announcement'], true, true, true, true, false, false);
    }

    // Who is online in the chatbox display 
    if ($vbulletin->options['mgc_cb_evo_whoisonline_active']) {
        $show['mgc_cb_evo_whoisonline'] = true;

        // Get whosonline only if not in a tab mode 
        if (!$vbulletin->options['mgc_cb_evo_whoisonline_showintab']) {
            // Inactive mode active and delay < session delay => inactive mode delay taken 
            if ($vbulletin->options['mgc_cb_evo_inactive_mode'] && $vbulletin->options['mgc_cb_evo_inactive_mode_delay'] < $vbulletin->options['mgc_cb_evo_whoisonline_delay']) {
                $dateline = TIMENOW - ($vbulletin->options['mgc_cb_evo_inactive_mode_delay'] * 60);
            } else {
                $dateline = TIMENOW - ($vbulletin->options['mgc_cb_evo_whoisonline_delay'] * 60);
            }

            $getusers = $vbulletin->db->query_read("
			  SELECT u.username,u.displaygroupid,u.userid,
				 (u.options & " . $vbulletin->bf_misc_useroptions['invisible'] . ") AS invisible
			  FROM " . TABLE_PREFIX . "mgc_cb_evo_session AS cbs
			  LEFT JOIN " . TABLE_PREFIX . "user AS u ON (cbs.userid=u.userid)
			  WHERE cbs.dateline>='$dateline' AND cbs.userid!=0
			");

            if ($vbulletin->db->num_rows($getusers)) {
                $show['mgc_cb_evo_nouser_online'] = false;
                $users_online['nb'] = 0;

                $first = 1;
                while ($user = $vbulletin->db->fetch_array($getusers)) {
                    if ($user['invisible']) {
                        if (($vbulletin->userinfo['permissions']['genericpermissions'] & $vbulletin->bf_ugp_genericpermissions['canseehidden']) OR $user['userid'] == $vbulletin->userinfo['userid']) {
                            if ($user['userid']) {
                                $users_online['nb']++;

                                if (!$first) {
                                    $users_online['list'] .= ', ';
                                } else {
                                    $first = 0;
                                }

                                $users_online['list'] .= '<a href="member.php?' . $session['sessionurl'] . 'u=' . $user['userid'] . '">' . fetch_musername($user,'displaygroupid') . '</a>*';
                            }
                        }
                    } else {
                        if ($user['userid']) {
                            $users_online['nb']++;

                            if (!$first) {
                                $users_online['list'] .= ', ';
                            } else {
                                $first = 0;
                            }

                            $users_online['list'] .= '<a href="member.php?' . $session['sessionurl'] . 'u=' . $user['userid'] . '">' . fetch_musername($user,'displaygroupid') . '</a>';
                        }
                    }
                }
            }
        } else {
            $show['mgc_cb_evo_nouser_online'] = true;
        }
    }

    //* Management of the chatbox editors state *

    // Collapse reset for buttons if not keeped 
    if (!$vbulletin->options['mgc_cb_evo_keep_editor_state']) {
    	// Do not collapse if bbcode editor shall be displayed by default 
    	if (!$vbulletin->options['mgc_cb_evo_bbcode_editor_default']) {
    	    $vbcollapse['collapseimg_mgc_cb_evo_bbcodes'] = "_collapsed";
    		$vbcollapse['collapseobj_mgc_cb_evo_bbcodes'] = "display: none";
    	}
    	// Do not collapse if smilies editor shall be displayed by default 
    	if (!$vbulletin->options['mgc_cb_evo_smilies_editor_default']) {
        	$vbcollapse['collapseimg_mgc_cb_evo_smilies'] = "_collapsed";
       		$vbcollapse['collapseobj_mgc_cb_evo_smilies'] = "display: none";
    	}
        $vbcollapse['collapseimg_mgc_cb_evo_help'] = "_collapsed";
        $vbcollapse['collapseobj_mgc_cb_evo_help'] = "display: none";
    }

    $vbcollapse['collapseimg_mgc_cb_evo_online'] = "_collapsed";
    $vbcollapse['collapseobj_mgc_cb_evo_online'] = "display: none";

	//* Management of the chatbox width if notification activated and separated *
	if ($vbulletin->options['mgc_cb_evo_separate_special_chats'])
	{
		if (!empty($vbulletin->options['mgc_cb_evo_notif_column_width']) && $vbulletin->options['mgc_cb_evo_notif_column_width'] != 0 && $vbulletin->options['mgc_cb_evo_notif_column_width'] < 100)
		{
			$chatwidth  = 100 - $vbulletin->options['mgc_cb_evo_notif_column_width'];
			$notifwidth = $vbulletin->options['mgc_cb_evo_notif_column_width'];
		}
		else
		{
			// Default 
			$chatwidth  = 75;
			$notifwidth = 25;
		}
	}

	//* Management of the chatbox state *

	// Chatbox forced as collapsed by default ? 
	if ($vbulletin->options['mgc_cb_evo_force_default_collapsed'])
	{
		$vbcollapse['collapseimg_mgc_cb_evo'] = "_collapsed";
		$vbcollapse['collapseobj_mgc_cb_evo'] = "display: none";
	}
	
    $chatbox_autorefresh_on = authorize_mgc_cb_evo_autorefresh($max_number_of_chats_reached);

	// Retrieval of js vars and file 	
	$mgc_cb_evo_js_vars		= "<script type=\"text/javascript\">\n";
	$mgc_cb_evo_js_vars		.= "<!--\n";
	$mgc_cb_evo_js_vars 		.= construct_jsvars($chatbox_autorefresh_on,$mgc_cb_evo_floc,$show['mgc_cb_evo_promptmsg'],$autocompletion_js,$array_channelnames,$vbcollapse['collapseobj_mgc_cb_evo']);
	$mgc_cb_evo_js_vars 		.= $js_channels_ids_array . "\n";
	if (!empty($default_channel))
	{
		$mgc_cb_evo_js_vars		.= "var mgc_cb_evo_default_channel = " . $default_channel . ";\n";
	}
	else
	{
		$mgc_cb_evo_js_vars		.= "var mgc_cb_evo_default_channel = 0;\n";
	}
	$mgc_cb_evo_js_vars		.= "// -->";
	$mgc_cb_evo_js_vars		.= "</script>\n";	
	$mgc_cb_evo_js_vars		.= construct_mgc_cb_evo_headinclude();
	
	// Creation editor 
    eval('$mgc_cb_evo_editor = "' . fetch_template('mgc_cb_evo_editor') . '";');

	// Creation of chatbox 
    eval('$mgc_cb_evo = "' . fetch_template('mgc_cb_evo') . '";');

    return $mgc_cb_evo;
}

function construct_mgc_cb_evo_table_col($td_content,$td_width,$td_class = 'alt1',$tr_start = false, $tr_end = false, $td_align = 'left', $td_colspan = '0') {
    global $vbulletin,$stylevar;

    eval('$table_col = "' . fetch_template('mgc_cb_evo_table_bit') . '";');
    return $table_col;
}

function construct_mgc_cb_evo_table($table_content) {
    global $vbulletin,$stylevar;

    eval('$table = "' . fetch_template('mgc_cb_evo_table') . '";');
    return $table;
}

function consruct_mgc_cb_evo_table_row_close_popup($colspan = 2) {
    global $vbphrase;
    return '<tr><td class="tfoot" align="center" ' . ($colspan ? 'colspan="' . $colspan . '"' : '') . '><input type="button" onclick=" return window.close();" class="button" tabindex="1" value="' . $vbphrase['mgc_cb_evo_close_popup'] . '" accesskey="s" /></td></tr>';
}

function mgc_cb_evo_can_use_command($command) {
    global $vbulletin;

    // Chatbox is not active or user can't access and use the chatbox => Error 
    if (! ($vbulletin->options['mgc_cb_evo_active'] &&  can_view_mgc_cb_evo() && can_use_mgc_cb_evo()) ) {
        return 0;
    }

    if (!empty($command['usergroupids'])) {
        $usergroupids = explode(',',$command['usergroupids']);

        if (in_array($vbulletin->userinfo['usergroupid'],$usergroupids)) {
            return 1;
        }

        if (!empty($vbulletin->userinfo['membergroupids'])) {
            $ugipds_array = explode(',', $vbulletin->userinfo['membergroupids']);

            foreach ($ugipds_array as $index => $ugpid) {
                if (in_array($ugpid,$usergroupids)) {
                    return 1;
                }
            }
        }
    }

    if (!empty($command['userids'])) {
        $userids = explode(',',$command['userids']);

        if (in_array($vbulletin->userinfo['userid'],$userids)) {
            return 1;
        }
    }

    return 0;
}

function get_user_number_of_chats() {
    global $vbulletin;
	
	// Based on user counters ? 
	if ($vbulletin->options['mgc_cb_evo_count_userchats'])
	{
		$getnbchats['nbchats'] = $vbulletin->userinfo['mgc_cb_evo_nbchats'];
	}
	else
	{
		$getnbchats = $vbulletin->db->query_first("
		  SELECT COUNT(chatid) AS nbchats
		  FROM " . TABLE_PREFIX . "mgc_cb_evo_chat AS c
		  WHERE (fromuid='" . $vbulletin->userinfo['userid'] . "')
	   ");
	}
	
    return $getnbchats['nbchats'];
}

function get_number_of_chats($last24h = false) {
    global $vbulletin;

    // Constructing the REGEXP for the commands and channels 
    $sql_condition_co = "co.usergroupids REGEXP('^([0-9]+,)*" . $vbulletin->userinfo['usergroupid'] . "(,[0-9]+)*$')";
    $sql_condition_ch = "ch.usergroupids REGEXP('^([0-9]+,)*" . $vbulletin->userinfo['usergroupid'] . "(,[0-9]+)*$')";

    if (!empty($vbulletin->userinfo['membergroupids'])) {
        $ugipds_array = explode(',', $vbulletin->userinfo['membergroupids']);

        foreach ($ugipds_array as $index => $ugpid) {
            $sql_condition_co .= " OR co.usergroupids REGEXP('^([0-9]+,)*" . $ugpid . "(,[0-9]+)*$')";
            $sql_condition_ch .= " OR ch.usergroupids REGEXP('^([0-9]+,)*" . $ugpid . "(,[0-9]+)*$')";
        }
    }

    $sql_condition_co .= " OR co.userids REGEXP('^([0-9]+,)*" . $vbulletin->userinfo['userid'] . "(,[0-9]+)*$')";
    $sql_condition_ch .= " OR ch.userids REGEXP('^([0-9]+,)*" . $vbulletin->userinfo['userid'] . "(,[0-9]+)*$')";

    $sql_condition_co = "(co.active='1' AND $sql_condition_co)";
    $sql_condition_ch = "((c.chanid='0') OR (ch.active='1' AND ($sql_condition_ch)))";

    $getnbchats = $vbulletin->db->query_first("
		SELECT COUNT(chatid) AS nbchats
		FROM " . TABLE_PREFIX . "mgc_cb_evo_chat AS c
                LEFT JOIN " . TABLE_PREFIX . "mgc_cb_evo_command AS co ON (c.coidentifier=co.identifier)
                LEFT JOIN " . TABLE_PREFIX . "mgc_cb_evo_channel AS ch ON (c.chanid=ch.chanid)
		WHERE
		  ((c.coidentifier='0' AND $sql_condition_ch) OR ($sql_condition_co AND $sql_condition_ch))
		  " . ($last24h ? "AND dateline>'" . (TIMENOW - (24 * 60 * 60)) . "'" : "") . "
		  AND (fromuid<>'0' AND (c.coidentifier<>'pm' OR (fromuid='" . $vbulletin->userinfo['userid'] . "' OR touid='" . $vbulletin->userinfo['userid'] . "')))
	");

    return $getnbchats['nbchats'];
}

function get_top_x($dotable = false) {
    global $vbulletin,$vbphrase,$session;

    require_once(DIR . '/includes/class_bbcode.php');

	// Based on user table counters ? 
	if ($vbulletin->options['mgc_cb_evo_count_userchats'])
	{
		$get_top_x = $vbulletin->db->query_read("
			 SELECT u.mgc_cb_evo_nbchats AS nbchats,u.userid,u.username,u.displaygroupid,u.usergroupid
			 FROM " . TABLE_PREFIX ."user AS u
			 ORDER BY nbchats DESC
			 LIMIT 0 , " . $vbulletin->options['mgc_cb_evo_archives_stats_nbtopshouters'] . "
	   ");			
	}
	else
	{
		// Constructing the REGEXP for the commands and channels 
		$sql_condition_co = "co.usergroupids REGEXP('^([0-9]+,)*" . $vbulletin->userinfo['usergroupid'] . "(,[0-9]+)*$')";
		$sql_condition_ch = "ch.usergroupids REGEXP('^([0-9]+,)*" . $vbulletin->userinfo['usergroupid'] . "(,[0-9]+)*$')";
	
		if (!empty($vbulletin->userinfo['membergroupids'])) {
			$ugipds_array = explode(',', $vbulletin->userinfo['membergroupids']);
	
			foreach ($ugipds_array as $index => $ugpid) {
				$sql_condition_co .= " OR co.usergroupids REGEXP('^([0-9]+,)*" . $ugpid . "(,[0-9]+)*$')";
				$sql_condition_ch .= " OR ch.usergroupids REGEXP('^([0-9]+,)*" . $ugpid . "(,[0-9]+)*$')";
			}
		}
	
		$sql_condition_co .= " OR co.userids REGEXP('^([0-9]+,)*" . $vbulletin->userinfo['userid'] . "(,[0-9]+)*$')";
		$sql_condition_ch .= " OR ch.userids REGEXP('^([0-9]+,)*" . $vbulletin->userinfo['userid'] . "(,[0-9]+)*$')";
	
		$sql_condition_co = "(co.active='1' AND $sql_condition_co)";
		$sql_condition_ch = "((c.chanid='0') OR (ch.active='1' AND ($sql_condition_ch)))";
	
		$get_top_x = $vbulletin->db->query_read("
			 SELECT COUNT(chatid) AS nbchats,u.userid,u.username,u.displaygroupid,u.usergroupid
			 FROM " . TABLE_PREFIX . "mgc_cb_evo_chat AS c
				 LEFT JOIN " . TABLE_PREFIX . "mgc_cb_evo_command AS co ON (c.coidentifier=co.identifier)
				 LEFT JOIN " . TABLE_PREFIX . "mgc_cb_evo_channel AS ch ON (c.chanid=ch.chanid)
			 LEFT JOIN " . TABLE_PREFIX ."user AS u ON (c.fromuid=u.userid)
			 WHERE
			   ((c.coidentifier='0' AND $sql_condition_ch) OR ($sql_condition_co AND $sql_condition_ch))
			   " . ($last24h ? "AND dateline>'" . (TIMENOW - (24 * 60 * 60)) . "'" : "") . "
			   AND (fromuid<>'0' AND (c.coidentifier<>'pm' OR (fromuid='" . $vbulletin->userinfo['userid'] . "' OR touid='" . $vbulletin->userinfo['userid'] . "')))
			 GROUP BY c.fromuid
			 ORDER BY nbchats DESC
			 LIMIT 0 , " . $vbulletin->options['mgc_cb_evo_archives_stats_nbtopshouters'] . "
	   ");	
	}

    $top_x = '';

    // Do table in archives 
    if($dotable) {
        if($vbulletin->db->num_rows($get_top_x)) {
            while($shouter = $vbulletin->db->fetch_array($get_top_x)) {
                $top_x .= '<tr><td class="alt2" width="100%" align="left">';
                $top_x .= '<a style="text-decoration: none"  href="member.php?' . $session['sessionurl'] .'u=' . $shouter['userid'] . '">' . fetch_musername($shouter, 'displaygroupid') . '</a>';
                $top_x .= '</td>';
                $top_x .= '<td class="alt1" align="center">' . $shouter['nbchats'] . '</td></tr>';
            }
        } else {
            $top_x = "<tr><td align='center' colspan='2'>" . $vbphrase['mgc_cb_evo_no_shouters'] . "</td></tr>";
        }
    } else {
        if($vbulletin->db->num_rows($get_top_x)) {
            while($shouter = $vbulletin->db->fetch_array($get_top_x)) {
                $top_x .= '<a style="text-decoration: none"  href="member.php?' . $session['sessionurl'] .'u=' . $shouter['userid'] . '">' . fetch_musername($shouter, 'displaygroupid') . '</a>';
                $top_x .= '&nbsp;(' . $shouter['nbchats'] . ')&nbsp;';
            }
        } else {
            $top_x = $vbphrase['mgc_cb_evo_no_shouters'];
        }
    }

    return $top_x;
}

function construct_mgc_cb_evo_forumhome_stats() {
    global $vbulletin,$vbphrase,$session;

    return construct_phrase($vbphrase['mgc_cb_evo_stats_forumhome'],$vbulletin->options['mgc_cb_stats_nbtopshouters'],get_top_x(), get_number_of_chats(), get_number_of_chats(true), get_user_number_of_chats());
}

function get_command_autocompletion_array($command_identifier) {
    global $vbphrase;

    $autocompletion_js_array = array();

    switch ($command_identifier) {
      case "announcement" :
        $autocompletion_js_array[] = "\"/announcement " . $vbphrase['mgc_cb_evo_your_announcement'] . "\"";
        $autocompletion_js_array[] = "\"/announcement remove\"";
        break;
      case "ban" :
        $autocompletion_js_array[] = "\"/ban on uid " . $vbphrase['mgc_cb_evo_userid_utilisateur'] . "\"";
        $autocompletion_js_array[] = "\"/ban on uname " . $vbphrase['mgc_cb_evo_username_utilisateur'] . "\"";
        $autocompletion_js_array[] = "\"/ban h " . $vbphrase['mgc_cb_evo_number_of_hours'] . " uid " . $vbphrase['mgc_cb_evo_userid_utilisateur'] . "\"";
        $autocompletion_js_array[] = "\"/ban h " . $vbphrase['mgc_cb_evo_number_of_hours'] . " uname " . $vbphrase['mgc_cb_evo_username_utilisateur'] . "\"";
        $autocompletion_js_array[] = "\"/ban d " . $vbphrase['mgc_cb_evo_number_of_days'] . " uid " . $vbphrase['mgc_cb_evo_userid_utilisateur'] . "\"";
        $autocompletion_js_array[] = "\"/ban d " . $vbphrase['mgc_cb_evo_number_of_days'] . " uname " . $vbphrase['mgc_cb_evo_username_utilisateur'] . "\"";
        $autocompletion_js_array[] = "\"/ban off uid " . $vbphrase['mgc_cb_evo_userid_utilisateur'] . "\"";
        $autocompletion_js_array[] = "\"/ban off uname " . $vbphrase['mgc_cb_evo_username_utilisateur'] . "\"";
        $autocompletion_js_array[] = "\"/ban show\"";
        break;
      case "del" :
        $autocompletion_js_array[] = "\"/del all\"";
        $autocompletion_js_array[] = "\"/del chan\"";
        $autocompletion_js_array[] = "\"/del days " . $vbphrase['mgc_cb_evo_number_of_days'] . "\"";
        $autocompletion_js_array[] = "\"/del uid " . $vbphrase['mgc_cb_evo_userid_utilisateur'] . "\"";
        $autocompletion_js_array[] = "\"/del uname " . $vbphrase['mgc_cb_evo_username_utilisateur'] . "\"";
        break;
      case "ignore" :
        $autocompletion_js_array[] = "\"/ignore on uid " . $vbphrase['mgc_cb_evo_userid_utilisateur'] . "\"";
        $autocompletion_js_array[] = "\"/ignore on uname " . $vbphrase['mgc_cb_evo_username_utilisateur'] . "\"";
        $autocompletion_js_array[] = "\"/ignore off uid " . $vbphrase['mgc_cb_evo_userid_utilisateur'] . "\"";
        $autocompletion_js_array[] = "\"/ignore off uname " . $vbphrase['mgc_cb_evo_username_utilisateur'] . "\"";
        $autocompletion_js_array[] = "\"/ignore show\"";
        break;
      case "me" :
        $autocompletion_js_array[] = "\"/me " . $vbphrase['mgc_cb_evo_your_message'] . "\"";
        break;
      case "pm" :
        $autocompletion_js_array[] = "\"/pm uid " . $vbphrase['mgc_cb_evo_userid_utilisateur'] . " " . $vbphrase['mgc_cb_evo_your_message'] . "\"";
        $autocompletion_js_array[] = "\"/pm uname " . $vbphrase['mgc_cb_evo_username_utilisateur'] . " " . $vbphrase['mgc_cb_evo_your_message'] . "\"";
        $autocompletion_js_array[] = "\"/pm " . $vbphrase['mgc_cb_evo_your_message'] . "\"";
        break;
      case "slap" :
        $autocompletion_js_array[] = "\"/slap uid " . $vbphrase['mgc_cb_evo_userid_utilisateur'] . "\"";
        $autocompletion_js_array[] = "\"/slap uname " . $vbphrase['mgc_cb_evo_username_utilisateur'] . "\"";
        break;
      case "team" :
      	$autocompletion_js_array[] = "\"/team " . $vbphrase['mgc_cb_evo_your_message'] . "\"";
      	break;
    }

    return $autocompletion_js_array;
}

function identifier_can_use_command($command_identifier) {
    global $vbulletin;

    // Get pm command permissions 
    $getpmpermissions = $vbulletin->db->query_first("
		SELECT usergroupids,userids
		FROM " . TABLE_PREFIX . "mgc_cb_evo_command
		WHERE identifier='$command_identifier'
     ");

    //* It's time to check if the user has access to the command 
    $authorized = 0;

    // Usergroupids 
    if (!empty($getpmpermissions['usergroupids'])) {
        $ugipds_array = explode(',',$getpmpermissions['usergroupids']);

        if (in_array($vbulletin->userinfo['usergroupid'],$ugipds_array)) {
            $authorized = 1;
        }

        if (!empty($vbulletin->userinfo['membergroupids'])) {
            $mgids_array = explode(',', $vbulletin->userinfo['membergroupids']);

            foreach ($mgids_array as $index => $mgpid) {
                if (in_array($mgpid,$ugipds_array)) {
                    $authorized = 1;
                }
            }
        }
    }

    // Userids if not already authorized 
    if (!$authorized && !empty($getpmpermissions['userids'])) {
        $uids_array = explode(',',$getpmpermissions['userids']);

        if (in_array($vbulletin->userinfo['userid'],$uids_array)) {
            $authorized = 1;
        }
    }

    return $authorized;
}

function get_avatar_chatbox($userinfo,$touser) {
	global $vbulletin, $stylevar;

	if ($touser)
	{
		$userinfo['avatarpath']			= $userinfo['toavatarpath'];
		$userinfo['avatarid']			= $userinfo['toavatarid'];
		$userinfo['hascustom']			= $userinfo['tohascustom'];
		$userinfo['hascustomavatar']	= $userinfo['tohascustomavatar'];
		$userinfo['userid']				= $userinfo['touid'];
		$userinfo['avatarrevision']	= $userinfo['toavatarrevision'];
		$userinfo['filedata_thumb']	= $userinfo['tofiledata_thumb'];
		$userinfo['avatardateline']	= $userinfo['toavatardateline'];
	}

	if (!empty($userinfo['avatarpath'])) {
		// Non custom avatar 
		if ($thumb) {
			if (@file_exists(DIR . '/images/avatars/thumbs/' . $userinfo['avatarid'] . '.gif')) {
				$avatarurl = 'images/avatars/thumbs/' . $userinfo['avatarid'] . '.gif';
			} else {
				$avatarurl = $userinfo['avatarpath'];
			}
		} else {
			$avatarurl = $userinfo['avatarpath'];
		}
	} else if ($userinfo['hascustom'] OR $userinfo['hascustomavatar']) {
		// User custom avatar 
		if ($vbulletin->options['usefileavatar']) {
			if ($thumb AND @file_exists($vbulletin->options['avatarpath'] . "/thumbs/avatar$userinfo[userid]_$userinfo[avatarrevision].gif")) {
				$avatarurl = $vbulletin->options['avatarurl'] . "/thumbs/avatar$userinfo[userid]_$userinfo[avatarrevision].gif";
			} else {
				$avatarurl =  $vbulletin->options['avatarurl'] . "/avatar$userinfo[userid]_$userinfo[avatarrevision].gif";
			}
		} else {
			if ($thumb AND $userinfo['filedata_thumb'])	{
				$avatarurl = 'image.php?' . $vbulletin->session->vars['sessionurl'] . 'u=' . $userinfo['userid'] . "&amp;dateline=$userinfo[avatardateline]&amp;type=thumb";
			} else {
				$avatarurl = 'image.php?' . $vbulletin->session->vars['sessionurl'] . 'u=' . $userinfo['userid'] . "&amp;dateline=$userinfo[avatardateline]";
			}
		}
	}

	// No avatar => show no avatar image 
	if (empty($avatarurl)) {
		$avatarurl = $stylevar['imgdir_misc'] . '/mgc_cb_evo/noavatar.jpg';
	}

	return $avatarurl;
}

// Construct the js variables 
function construct_jsvars($autorefreshon,$chatboxlocation,$showpromptmsg,$autocompletion_js,$channelnames,$collapsestate)
{
	global $vbulletin, $vbphrase, $permissions, $stylevar;
	
	// Phrases 
	$jsvars .= "var phrase_error_chat_in_process = \"" . $vbphrase['mgc_cb_evo_jserror_chat_in_progress'] . "\";";
	$jsvars .= "var phrase_enter_url = \"" . $vbphrase['mgc_cb_evo_js_enter_url'] . "\";\n";
	$jsvars .= "var phrase_enter_email = \"" . $vbphrase['mgc_cb_evo_js_enter_email'] . "\";\n";   
	$jsvars .= "var phrase_enter_imgurl = \"" . $vbphrase['mgc_cb_evo_js_enter_imgurl'] . "\";\n";
	$jsvars .= "var phrase_already_editing = \"" . $vbphrase['mgc_cb_evo_already_editing'] . "\";\n";
	$jsvars .= "var phrase_edit_forbidden = \"" . $vbphrase['mgc_cb_evo_edit_forbidden'] . "\";\n";
	$jsvars .= "var phrase_inactive = \"" . $vbphrase['mgc_cb_evo_inactive'] . "\";\n";
	$jsvars .= "var phrase_enter_urltext = \""  . $vbphrase['mgc_cb_evo_js_enter_urltext'] . "\";\n";
	$jsvars .= "var phrase_enter_name = \"" . $vbphrase['mgc_cb_evo_js_enter_name'] . "\";\n";
	$jsvars .= "var phrase_error_name = \"" . $vbphrase['mgc_cb_evo_js_error_name'] . "\";\n";
	$jsvars .= "var phrase_ok = \"" . $vbphrase['mgc_cb_evo_ok'] . "\";\n";
	$jsvars .= "var phrase_yes = \"" . $vbphrase['yes'] . "\";\n";
	$jsvars .= "var phrase_no = \"" . $vbphrase['no'] . "\";\n";
	$jsvars .= "var phrase_save = \"" . $vbphrase['save'] . "\";\n";
	$jsvars .= "var phrase_cancel = \"" . $vbphrase['cancel'] . "\";\n";
	
	// Options variables 
	$jsvars .= "var val_timeout = " . ($permissions['mgc_cb_evo_refreshrate'] * 1000) . ";\n";
	$jsvars .= "var auto_refresh = " . $vbulletin->options['mgc_cb_evo_refresh_active'] . ";\n";
	$jsvars .= "var chats_when_collapsed = " . $vbulletin->options['mgc_cb_evo_nbchats_closed'] . ";\n";
	$jsvars .= "var chats_order = " . $vbulletin->options['mgc_cb_evo_chats_order'] . ";\n";
	$jsvars .= "var inactive_mode = " . $vbulletin->options['mgc_cb_evo_inactive_mode'] . ";\n";
	$jsvars .= "var inactive_mode_delay = " . ($vbulletin->options['mgc_cb_evo_inactive_mode_delay'] * 60 * 1000) . ";\n";
	$jsvars .= "var bburl = \"" . $vbulletin->options['bburl'] . "\";\n";
	$jsvars .= "var warn_active = " . $vbulletin->options['mgc_cb_evo_channels_warning'] . ";\n";
	$jsvars .= "var cbavatar_on = " . $vbulletin->options['mgc_cb_evo_avatar_on'] . ";\n";
	$jsvars .= "var cbalignchats = " . $vbulletin->options['mgc_cb_evo_chats_align'] . ";\n";
	$jsvars .= "var cbaltcolors = " . $vbulletin->options['mgc_cb_evo_alt_colors'] . ";\n";	
	$jsvars .= "var warn_delay = " . ($vbulletin->options['mgc_cb_evo_channels_warning_delay'] * 60 * 1000) . ";\n";
	$jsvars .= "var mgc_cb_evo_chat_valign = \"" . $vbulletin->options['mgc_cb_evo_valign'] . "\";\n";
	$jsvars .= "var separate_special_chats = " . $vbulletin->options['mgc_cb_evo_separate_special_chats'] . ";\n";
	$jsvars .= "var hide_refreshimg = " . $vbulletin->options['mgc_cb_evo_hide_refresh_img'] . ";\n";
	$jsvars .= "var mgc_cb_evo_yui_online = " . $vbulletin->options['mgc_cb_evo_js_load_locally'] . ";\n";
	$jsvars .= "var mgc_cb_evo_left = \"" . $stylevar['left'] . "\";\n";
	$jsvars .= "var mgc_cb_evo_right = \"" . $stylevar['right'] . "\";\n";
	$jsvars .= "var imgdir_misc = \"" . $stylevar['imgdir_misc'] . "\";\n";
	$jsvars .= "var br_after_username = " . $vbulletin->options['mgc_cb_evo_notifs_br_after_username'] . ";\n"; 

	// chat configuration parameters 
	if ($vbulletin->userinfo['mgc_cb_evo_b'])
	{
		$jsvars .= "var mgc_cb_evo_ubbcode_b = 1;\n";
	}
	else
	{
		$jsvars .= "var mgc_cb_evo_ubbcode_b = 0;\n";	
	}
	
	if ($vbulletin->userinfo['mgc_cb_evo_u'])
	{
		$jsvars .= "var mgc_cb_evo_ubbcode_u = 1;\n";
	}
	else
	{
		$jsvars .= "var mgc_cb_evo_ubbcode_u = 0;\n";	
	}	
	
	if ($vbulletin->userinfo['mgc_cb_evo_i'])
	{
		$jsvars .= "var mgc_cb_evo_ubbcode_i = 1;\n";
	}
	else
	{
		$jsvars .= "var mgc_cb_evo_ubbcode_i = 0;\n";	
	}		
	
	$jsvars .= "var mgc_cb_evo_ubbcode_color 	= \"#" . $vbulletin->userinfo['mgc_cb_evo_color'] . "\";\n";
	$jsvars .= "var mgc_cb_evo_ubbcode_font 	= \"" . $vbulletin->userinfo['mgc_cb_evo_font'] . "\";\n";
	$jsvars .= "var mgc_cb_evo_ubbcode_size	= \"" . $vbulletin->userinfo['mgc_cb_evo_size'] . "\";\n";
 
 	// Sound notification active 
 	if ($vbulletin->options['mgc_cb_evo_newmsg_sound'])
 	{
 		if ($vbulletin->options['mgc_cb_evo_newmsg_sound_candisable'])
 		{
 			if ($vbulletin->userinfo['mgc_cb_evo_sound_disable'])
 			{
 				$jsvars .= "var mgc_cb_evo_sound = 0;\n";
 			}
 			else
 			{
 				$jsvars .= "var mgc_cb_evo_sound = 1;\n";
 			}
  		}
 		else
 		{
 			$jsvars .= "var mgc_cb_evo_sound = 1;\n";
 		}
 	}
 	else
 	{
 		$jsvars .= "var mgc_cb_evo_sound = 0;\n";
 	}
 	
 	// Channel sound notification active 
 	if ($vbulletin->options['mgc_cb_evo_newmsg_channel_sound'])
 	{
 		if ($vbulletin->options['mgc_cb_evo_newmsg_sound_candisable'])
 		{
 			if ($vbulletin->userinfo['mgc_cb_evo_sound_disable'])
 			{
 				$jsvars .= "var mgc_cb_evo_sound_channel = 0;\n";
 			}
 			else
 			{
 				$jsvars .= "var mgc_cb_evo_sound_channel = 1;\n";
 			}
  		}
 		else
 		{
 			$jsvars .= "var mgc_cb_evo_sound_channel = 1;\n";
 		}
 	}
 	else
 	{
 		$jsvars .= "var mgc_cb_evo_sound_channel = 0;\n";
 	}
 	
 
 	// Force anonymous to enter username before they chat 
 	if ($vbulletin->options['mgc_cb_evo_ask_anonymous_name'] && ($vbulletin->userinfo['usergroupid'] == 1))
 	{
 		$jsvars .= "var chatbox_ask_name = 1;\n";
 	}
 	else
 	{
 		$jsvars .= "var chatbox_ask_name = 0;\n";
  	}
  	
  	// Whosonline refresh timeout 
  	if (!empty($vbulletin->options['mgc_cb_evo_whoisonline_autorefresh']) && $vbulletin->options['mgc_cb_evo_whoisonline_active'])
  	{
 		$jsvars .= "var whoisonline_active = 1;\n";
 		$jsvars .= "var whoisonline_delay = " . ($vbulletin->options['mgc_cb_evo_whoisonline_autorefresh'] * 1000 * 60) . ";\n";
		
		if (!$vbulletin->options['mgc_cb_evo_whoisonline_showintab'])
		{
      		$jsvars .= "var whoisonlineTimeout = setTimeout(\"get_online_users()\", whoisonline_delay);\n";
    	}  	
  	}
  	
  	// Inactive mode active on load 
	if ($vbulletin->options['mgc_cb_evo_inactive_mode'] && $vbulletin->options['mgc_cb_evo_inactive_mode_onload'])
	{
		$jsvars .= "var chatbox_inactive = 1;\n";
		$jsvars .= "var idleTimeout = null;\n";
	}
	else 
	{
		$jsvars .= "var chatbox_inactive = 0;\n";
		
		if ($vbulletin->options['mgc_cb_evo_inactive_mode'])
		{
			// Idle timeout launch 
			$jsvars .= "var idleTimeout = setTimeout(\"activate_idle_chatbox()\", inactive_mode_delay);\n";
		}
		else
		{
			$jsvars .= "var idleTimeout = null;\n";
		}
	}
	
	// Init actions management 
	if (empty($collapsestate))
	{
		// Chatbox is not collapsed 
		$jsvars .= "var mgc_cb_evo_iscollapsed = 0;\n";

		if (!$vbulletin->options['mgc_cb_evo_inactive_mode'] || ($vbulletin->options['mgc_cb_evo_inactive_mode'] && !$vbulletin->options['mgc_cb_evo_inactive_mode_onload']))
		{
			$jsvars .= "var mgc_cb_evo_initstate = 1;\n";
		}
		else
		{
			$jsvars .= "var mgc_cb_evo_initstate = 0;\n";		
		}
	}
	else
	{
		// Chatbox is collapsed 
		$jsvars .= "var mgc_cb_evo_iscollapsed = 1;\n";
		
		// Show chats when collapsed 
		if ($vbulletin->options['mgc_cb_evo_nbchats_closed'])
		{
			$jsvars .= "var mgc_cb_evo_inistate = 1;\n";			
		}
		else
		{
			$jsvars .= "var mgc_cb_evo_inistate = 0;\n";		
		}
	}
 
 	// vBulletin version 
	$vbversion = substr($vbulletin->options['templateversion'],0,3);
	if ($vbversion < 3.7)
	{
		$vbversion = 1;
	}
	else
	{
		$vbversion = 0;
	}
	$jsvars .= "var vbulletin_version = " . $vbversion . ";\n";	
 
 
 	// Function dependent configuration 
	$jsvars .= "var mgc_cb_evo_autorefresh_on = " . $autorefreshon . ";\n";
 	$jsvars .= "var mgc_cb_evo_jsloc = \"" . $chatboxlocation . "\";\n";
	$jsvars .= "var chat_input_prompt = " . $showpromptmsg . ";\n";	
	
	// Autcompletion array 
	if ($vbulletin->options['mgc_cb_evo_act_autocompletion'] && !empty($autocompletion_js))
	{
		$jsvars .= "var chatAutocompletionarray = [" . $autocompletion_js . "];\n";
		$jsvars .= "var mgc_cb_evo_autocomplete_on = 1;\n";
	}
	else
	{
		$jsvars .= "var mgc_cb_evo_autocomplete_on = 0;\n";
	}
	
	// Disable refresh upon limit of posts 
	if ($permissions['mgc_cb_evo_permissions'] & $vbulletin->bf_ugp_mgc_cb_evo_permissions['disablerefreshuponlimit'])
	{
		$jsvars .= "var disablerefreshuponlimit = 1;\n";
	}
 	else
 	{
		$jsvars .= "var disablerefreshuponlimit = 0;\n";
 	}
 	
 	// Channel names array 
 	if ($vbulletin->options['mgc_cb_evo_show_channelname'])
 	{
		$jsvars .= "var channelNamesArray = new Array();\n";
		foreach($channelnames AS $chanid => $channelname)
		{	
			$jsvars .= "channelNamesArray[$chanid] = $channelname;\n";
		}
	}
				
	return $jsvars;
}

function decode_htmlspecialchars($string,$style=ENT_COMPAT)
{
	$translation = array_flip(get_html_translation_table(HTML_SPECIALCHARS,$style));
	
	if($style === ENT_QUOTES)
	{
		$translation['&#039;'] = '\'';
	}

	return strtr($string,$translation);
}

function writefile_debug($filename,$content)
{
	if (!$handle = fopen($filename, 'w'))
	{
		exit;
	}

    if (fwrite($handle, $content) === FALSE)
    {
        	exit;
    }

    fclose($handle);
}

// Compare datelines of two chatbits array elements but keeps sticky at top
function array_compare_dateline($a,$b)
{
	// Both chat stickied 
	if ($a['sticky'] && !$b['sticky'])
	{
		return 1;
	}
	else if ($b['sticky'] && !$a['sticky'])
	{
		return -1;
	}
	else
	{
		if ($a['dateline'] > $b['dateline'])
		{
			return 1;
		}
		else if ($a['dateline'] == $b['dateline'])
		{
			return 0;
		}
		else
		{
			return -1;
		}
	}
}
function construct_mgc_cb_evo_headinclude()
{	
	global $vbulletin;
	
	$js = '';
	if ($vbulletin->options['mgc_cb_evo_js_load_locally'])
	{
		$js .= '<link rel="stylesheet" href="http://yui.yahooapis.com/combo?2.7.0/build/container/assets/skins/sam/container.css&2.7.0/build/button/assets/skins/sam/button.css" type="text/css">';
	}
	else
	{
		$js .= '<link rel="stylesheet" href="clientscript/mgc_cb_evo/yui/container/assets/skins/sam/container.css" type="text/css">';
		$js .= '<link rel="stylesheet" href="clientscript/mgc_cb_evo/yui/button/assets/skins/sam/button.css" type="text/css">';
	}
	
	$js .= '<link rel="stylesheet" href="clientscript/mgc_cb_evo/widget-skin.css" type="text/css">';

	$vbversion = substr($vbulletin->options['templateversion'],0,3);
	if ($vbversion < 3.7)
	{
		$vbversion = 1;
	}
	else
	{
		$vbversion = 0;
	}	
	
	if ($vbulletin->options['mgc_cb_evo_js_load_locally'])
	{	
		if ($vbversion)
		{
			// Load only for version prior to 3.7 
			$js .= '<script type="text/javascript" src="http://yui.yahooapis.com/combo?2.7.0/build/yahoo-dom-event/yahoo-dom-event.js&2.7.0/build/connection/connection-min.js"></script>';
		}
		
		$js .= '<script type="text/javascript" src="http://yui.yahooapis.com/combo?2.7.0/build/animation/animation-min.js&2.7.0/build/datasource/datasource-min.js&2.7.0/build/autocomplete/autocomplete-min.js&2.7.0/build/element/element-min.js&2.7.0/build/button/button-min.js&2.7.0/build/container/container-min.js"></script>';
	}
	else
	{	
		if ($vbversion)
		{	
			// Load only for version prior to 3.7 
			$js .= '<script type="text/javascript" src="clientscript/mgc_cb_evo/yui/yahoo-dom-event/yahoo-dom-event.js"></script>';
			$js .= '<script type="text/javascript" src="clientscript/mgc_cb_evo/yui/connection/connection-min.js"></script>';
		}
		
		$js .= '<script type="text/javascript" src="clientscript/mgc_cb_evo/yui/animation/animation-min.js"></script>';
		$js .= '<script type="text/javascript" src="clientscript/mgc_cb_evo/yui/datasource/datasource-min.js"></script>';
		$js .= '<script type="text/javascript" src="clientscript/mgc_cb_evo/yui/autocomplete/autocomplete-min.js"></script>';
		$js .= '<script type="text/javascript" src="clientscript/mgc_cb_evo/yui/element/element-min.js"></script>';
		$js .= '<script type="text/javascript" src="clientscript/mgc_cb_evo/yui/container/container-min.js"></script>';
		$js .= '<script type="text/javascript" src="clientscript/mgc_cb_evo/yui/button/button-min.js"></script>';
	}
	
	$js .= '<script type="text/javascript" src="clientscript/mgc_cb_evo/mgc_cb_evo_functions.js"></script>';
	return $js;	
}

?>